/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.bgmddatalock.v2;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.bgmddatalock.v2.DataLockService;
import kd.epm.eb.common.bgmddatalock.v2.IDataLockChecker;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.BgmdShrekLockDao;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DataLockChecker
implements IDataLockChecker {
    private static final Log log = LogFactory.getLog(DataLockChecker.class);
    private Map<Long, Map<String, Map<String, Set<String>>>> caseLockMap = new HashMap<Long, Map<String, Map<String, Set<String>>>>(16);
    private Long modelId;
    private Long bizModelId;

    public static DataLockChecker initByBizModel(Long modelId, Long bizModelId) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        return new Builder().init(modelCache, bizModelId);
    }

    public boolean isDataLock(Map<String, String> dimMemberMap) {
        String[] members = new String[]{dimMemberMap.get(SysDimensionEnum.BudgetPeriod.getNumber()), dimMemberMap.get(SysDimensionEnum.Version.getNumber()), dimMemberMap.get(SysDimensionEnum.DataType.getNumber()), dimMemberMap.get(SysDimensionEnum.AuditTrail.getNumber()), dimMemberMap.get(SysDimensionEnum.Entity.getNumber())};
        return this.isDataLock(members);
    }

    public boolean isDataLockScope(Map<String, Set<String>> dimMemberScope) {
        Set<String> inBpSet = dimMemberScope.get(SysDimensionEnum.BudgetPeriod.getNumber());
        Set<String> inVersionSet = dimMemberScope.get(SysDimensionEnum.Version.getNumber());
        Set<String> inDataTypeSet = dimMemberScope.get(SysDimensionEnum.DataType.getNumber());
        Set<String> inAuditSet = dimMemberScope.get(SysDimensionEnum.AuditTrail.getNumber());
        Set<String> inEntitySet = dimMemberScope.get(SysDimensionEnum.Entity.getNumber());
        if (CollectionUtils.isEmpty(inBpSet) || CollectionUtils.isEmpty(inVersionSet) || CollectionUtils.isEmpty(inDataTypeSet) || CollectionUtils.isEmpty(inAuditSet) || CollectionUtils.isEmpty(inEntitySet)) {
            log.warn("\u5165\u53c2\u4e0d\u6b63\u786e\uff0c\u4e0d\u5224\u65ad\u9501\u5b9a");
            return false;
        }
        for (Map.Entry<Long, Map<String, Map<String, Set<String>>>> caseEntry : this.caseLockMap.entrySet()) {
            Map<String, Map<String, Set<String>>> itemLockMap = caseEntry.getValue();
            if (MapUtils.isNotEmpty(itemLockMap)) {
                Map<String, Set<String>> luckyMap = itemLockMap.entrySet().iterator().next().getValue();
                Set<String> versionSet = luckyMap.get(SysDimensionEnum.Version.getNumber());
                Set<String> dataTypeSet = luckyMap.get(SysDimensionEnum.DataType.getNumber());
                Set<String> auditSet = luckyMap.get(SysDimensionEnum.AuditTrail.getNumber());
                if (versionSet.stream().noneMatch(inVersionSet::contains) || dataTypeSet.stream().noneMatch(inDataTypeSet::contains) || auditSet.stream().noneMatch(inAuditSet::contains)) continue;
            }
            for (Map.Entry<String, Map<String, Set<String>>> itemEntry : caseEntry.getValue().entrySet()) {
                Map<String, Set<String>> lockMap = itemEntry.getValue();
                Set<String> bpSet = lockMap.get(SysDimensionEnum.BudgetPeriod.getNumber());
                Set<String> entitySet = lockMap.get(SysDimensionEnum.Entity.getNumber());
                if (bpSet.stream().noneMatch(inBpSet::contains) || entitySet.stream().noneMatch(inEntitySet::contains)) continue;
                return true;
            }
        }
        return false;
    }

    public Pair<Boolean, Long> isDataLockWithCase(Map<String, String> dimMemberMap) {
        String[] members = new String[]{dimMemberMap.get(SysDimensionEnum.BudgetPeriod.getNumber()), dimMemberMap.get(SysDimensionEnum.Version.getNumber()), dimMemberMap.get(SysDimensionEnum.DataType.getNumber()), dimMemberMap.get(SysDimensionEnum.AuditTrail.getNumber()), dimMemberMap.get(SysDimensionEnum.Entity.getNumber())};
        for (Map.Entry<Long, Map<String, Map<String, Set<String>>>> caseEntry : this.caseLockMap.entrySet()) {
            Long caseId = caseEntry.getKey();
            Map<String, Map<String, Set<String>>> itemLockMap = caseEntry.getValue();
            if (MapUtils.isNotEmpty(itemLockMap)) {
                Map<String, Set<String>> luckyMap = itemLockMap.entrySet().iterator().next().getValue();
                Set<String> versionSet = luckyMap.get(SysDimensionEnum.Version.getNumber());
                Set<String> dataTypeSet = luckyMap.get(SysDimensionEnum.DataType.getNumber());
                Set<String> auditSet = luckyMap.get(SysDimensionEnum.AuditTrail.getNumber());
                if (!versionSet.contains(members[1]) || !dataTypeSet.contains(members[2]) || !auditSet.contains(members[3])) continue;
            }
            for (Map.Entry<String, Map<String, Set<String>>> itemEntry : caseEntry.getValue().entrySet()) {
                Map<String, Set<String>> lockMap = itemEntry.getValue();
                Set<String> bpSet = lockMap.get(SysDimensionEnum.BudgetPeriod.getNumber());
                Set<String> entitySet = lockMap.get(SysDimensionEnum.Entity.getNumber());
                if (!bpSet.contains(members[0]) || !entitySet.contains(members[4])) continue;
                return Pair.of((Object)true, (Object)caseId);
            }
        }
        return Pair.of((Object)false, (Object)0L);
    }

    public boolean isDataLock(String[] members) {
        for (Map.Entry<Long, Map<String, Map<String, Set<String>>>> caseEntry : this.caseLockMap.entrySet()) {
            Map<String, Map<String, Set<String>>> itemLockMap = caseEntry.getValue();
            if (MapUtils.isNotEmpty(itemLockMap)) {
                Map<String, Set<String>> luckyMap = itemLockMap.entrySet().iterator().next().getValue();
                Set<String> versionSet = luckyMap.get(SysDimensionEnum.Version.getNumber());
                Set<String> dataTypeSet = luckyMap.get(SysDimensionEnum.DataType.getNumber());
                Set<String> auditSet = luckyMap.get(SysDimensionEnum.AuditTrail.getNumber());
                if (!versionSet.contains(members[1]) || !dataTypeSet.contains(members[2]) || !auditSet.contains(members[3])) continue;
            }
            for (Map.Entry<String, Map<String, Set<String>>> itemEntry : itemLockMap.entrySet()) {
                Map<String, Set<String>> lockMap = itemEntry.getValue();
                Set<String> bpSet = lockMap.get(SysDimensionEnum.BudgetPeriod.getNumber());
                Set<String> entitySet = lockMap.get(SysDimensionEnum.Entity.getNumber());
                if (!bpSet.contains(members[0]) || !entitySet.contains(members[4])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEmpty() {
        return this.caseLockMap.isEmpty();
    }

    public Long getModelId() {
        return this.modelId;
    }

    public Long getBizModelId() {
        return this.bizModelId;
    }

    static class Builder {
        Builder() {
        }

        public DataLockChecker init(IModelCacheHelper modelCache, Long bizModelId) {
            DataLockChecker dataLockChecker = new DataLockChecker();
            dataLockChecker.modelId = modelCache.getModelobj().getId();
            dataLockChecker.bizModelId = bizModelId;
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("model", "=", (Object)modelCache.getModelobj().getId());
            qfBuilder.add("bizmodel", "=", (Object)bizModelId);
            Map dojMap = BusinessDataServiceHelper.loadFromCache((String)"bgmd_datalockcase", (QFilter[])qfBuilder.toArray());
            if (dojMap == null || dojMap.isEmpty()) {
                return dataLockChecker;
            }
            List dataSetIds = DatasetServiceHelper.getDataSetIdByBusModelIds((Set)Sets.newHashSet((Object[])new Long[]{bizModelId}));
            Long luckyDataSetId = (Long)dataSetIds.get(0);
            String cubeNumber = DataLockService.getInstance().getCubeNumber(luckyDataSetId);
            log.info("\u67e5\u8be2\u9501\u5b9a\u89c4\u5219\uff0c cube\uff1a" + cubeNumber);
            List cubeLockRuleNames = BgmdShrekLockDao.getInstance().getCubeLockRuleNames(modelCache.getModelobj(), cubeNumber);
            for (DynamicObject doj : dojMap.values()) {
                long caseId = doj.getLong("id");
                List lockNameList = cubeLockRuleNames.stream().filter(e -> e.startsWith(caseId + "_")).collect(Collectors.toList());
                if (lockNameList.isEmpty()) continue;
                HashMap lockItemMap = Maps.newHashMapWithExpectedSize((int)lockNameList.size());
                for (String ruleName : lockNameList) {
                    List list = BgmdShrekLockDao.getInstance().getCubeLockRule(modelCache.getModelobj(), cubeNumber, ruleName);
                    if (CollectionUtils.isEmpty((Collection)list)) continue;
                    ArrayList members = ((BgmdShrekLockDao.LockRuleInfo)list.get(0)).getMembers();
                    HashSet bpSet = new HashSet((Collection)members.get(0));
                    HashSet versionSet = new HashSet((Collection)members.get(1));
                    HashSet dataTypeSet = new HashSet((Collection)members.get(2));
                    HashSet auditSet = new HashSet((Collection)members.get(3));
                    HashSet entitySet = new HashSet((Collection)members.get(4));
                    HashMap lockMap = Maps.newHashMapWithExpectedSize((int)4);
                    lockMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), bpSet);
                    lockMap.put(SysDimensionEnum.Version.getNumber(), versionSet);
                    lockMap.put(SysDimensionEnum.DataType.getNumber(), dataTypeSet);
                    lockMap.put(SysDimensionEnum.AuditTrail.getNumber(), auditSet);
                    lockMap.put(SysDimensionEnum.Entity.getNumber(), entitySet);
                    lockItemMap.put(ruleName, lockMap);
                }
                dataLockChecker.caseLockMap.put(caseId, lockItemMap);
            }
            return dataLockChecker;
        }
    }
}

