/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.cache.threadlocal;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.FunPermissionHelper;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.membPerm.DimMemberPermChecker;
import kd.epm.eb.common.utils.DataSourceUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.UserUtils;

public class EpmThreadLocalUtils {
    private static final ThreadLocal<Map<String, Map<String, Object>>> COMM_LOCAL = ThreadLocal.withInitial(HashMap::new);
    private static final String LIMIT_MODEL_PERM_KEY = "LIMIT_MODEL_PERM_KEY";
    private static final String EFFECTIVE_MODEL_PERM_KEY = "EFFECTIVE_MODEL_PERM_KEY";
    private static final String EPM_SHREK_CHECK_ACCOUNT_KEY = "EPM_SHREK_CHECK_ACCOUNT_KEY";
    private static final String EPM_DECOMPOSE_ADJUST_DATA_KEY = "EPM_DECOMPOSE_ADJUST_DATA_KEY";
    private static final String EPM_PERM_DATA_KEY = "EPM_PERM_NUM_DATA_KEY";
    private static final String EPM_PERM_ID_DATA_KEY = "EPM_PERM_ID_DATA_KEY";
    private static final String EPM_PERM_CHECK_DATA_KEY = "EPM_PERM_CHECK_DATA_KEY";
    private static final String DIM_VER_CHECK = "DIM_VER_NO_CHECK_KEY";
    private static final String DIM_VIEW_MEM_RANGE = "DIM_VIEW_MEM_RANGE";
    private static final String DIM_VIEW_MEM_RANGE_ID = "DIM_VIEW_MEM_RANGE_ID";
    private static final String BUDGET_EXPORT_FLAG = "BUDGET_EXPORT_FLAG";
    private static final String CHECK_DATA_PARAM = "CHECK_DATA_PARAM";
    private static final String DIM_REL_MEM_NUMBER = "DIM_REL_MEM_NUMBER";

    protected static ThreadLocal<Map<String, Map<String, Object>>> getCommLocal() {
        return COMM_LOCAL;
    }

    private static Map<String, Object> getDataMap(String key) {
        return EpmThreadLocalUtils.getCommLocal().get().computeIfAbsent(key, k -> new HashMap(16));
    }

    private static String getApplicationNum(ApplicationTypeEnum application) {
        return application != null ? application.getIndex() : "nullApp";
    }

    public static void remove() {
        EpmThreadLocalUtils.getCommLocal().remove();
    }

    public static Set<Long> getLimitedModelListByUser(ApplicationTypeEnum application, Long userId) {
        Map<String, Object> _dataMap = EpmThreadLocalUtils.getDataMap(LIMIT_MODEL_PERM_KEY);
        Long _userId = IDUtils.isNull((Long)userId) ? UserUtils.getUserId() : userId;
        HashSet<Long> modelIds = new HashSet<Long>();
        String _localKey = "LIMIT_MODEL_PERM_KEY." + EpmThreadLocalUtils.getApplicationNum(application) + '.' + _userId;
        Object _result = _dataMap.computeIfAbsent(_localKey, f -> ModelServiceHelper.$getLimitedModelListByUser((ApplicationTypeEnum)application, (Long)_userId));
        if (_result instanceof Set) {
            modelIds = new HashSet((Set)_result);
        }
        return modelIds;
    }

    public static Set<Long> getEffectiveByPermModel(String entity, ApplicationTypeEnum application) {
        Map<String, Object> _dataMap = EpmThreadLocalUtils.getDataMap(EFFECTIVE_MODEL_PERM_KEY);
        HashSet<Long> modelIds = new HashSet<Long>();
        String _localKey = "EFFECTIVE_MODEL_PERM_KEY." + EpmThreadLocalUtils.getApplicationNum(application) + '.' + entity;
        Object _result = _dataMap.computeIfAbsent(_localKey, f -> FunPermissionHelper.$getEffectiveByPermModel((String)entity, (ApplicationTypeEnum)application));
        if (_result instanceof Set) {
            modelIds = new HashSet((Set)_result);
        }
        return modelIds;
    }

    public static boolean verifyAccountId(Long dataSourceId, String accountId) {
        Map<String, Object> _dataMap = EpmThreadLocalUtils.getDataMap(EPM_SHREK_CHECK_ACCOUNT_KEY);
        boolean verify = true;
        String _localKey = "EPM_SHREK_CHECK_ACCOUNT_KEY." + dataSourceId + '.' + accountId;
        Object _result = _dataMap.computeIfAbsent(_localKey, f -> DataSourceUtils.$verifyAccountByPrivate((Long)dataSourceId, (String)accountId));
        if (_result instanceof Boolean) {
            verify = (Boolean)_result;
        }
        return verify;
    }

    public static DynamicObjectCollection getAdjustDys(String entity, String field, QFilter filter) {
        Map<String, Object> _dataMap = EpmThreadLocalUtils.getDataMap(EPM_DECOMPOSE_ADJUST_DATA_KEY);
        DynamicObjectCollection result = new DynamicObjectCollection();
        String _localKey = "EPM_DECOMPOSE_ADJUST_DATA_KEY." + filter.toString();
        Object _result = _dataMap.computeIfAbsent(_localKey, f -> QueryServiceHelper.query((String)entity, (String)field, (QFilter[])filter.toArray()));
        if (_result instanceof DynamicObjectCollection) {
            result = (DynamicObjectCollection)_result;
        }
        return result;
    }

    public static Set<String> getPermMembNumbers(String dimensionNumber, Long modelId, Long bizModelId, Long viewId, DimMembPermType permTypeEnum, boolean needHasPerm) {
        return EpmThreadLocalUtils.getPermMembNumbers(UserUtils.getUserId(), dimensionNumber, modelId, bizModelId, viewId, permTypeEnum, needHasPerm);
    }

    public static Set<String> getPermMembNumbers(Long userId, String dimensionNumber, Long modelId, Long bizModelId, Long viewId, DimMembPermType permTypeEnum, boolean needHasPerm) {
        Map<String, Object> _dataMap = EpmThreadLocalUtils.getDataMap(EPM_PERM_DATA_KEY);
        HashSet result = null;
        String _localKey = "EPM_PERM_NUM_DATA_KEY." + userId + '.' + dimensionNumber + '.' + modelId + '.' + bizModelId + '.' + viewId + '.' + permTypeEnum + '.' + needHasPerm;
        Object _result = _dataMap.computeIfAbsent(_localKey, f -> DimMembPermHelper.getPermMembNumbers((Long)userId, (String)dimensionNumber, (Long)modelId, (Long)bizModelId, (Long)viewId, (DimMembPermType)permTypeEnum, (boolean)needHasPerm));
        if (_result instanceof Set) {
            result = new HashSet((Set)_result);
        }
        return result;
    }

    public static Set<Long> getPermMembIds(String dimensionNumber, Long modelId, Long bizModelId, Long viewId, DimMembPermType permTypeEnum, boolean needHasPerm) {
        Map<String, Object> _dataMap = EpmThreadLocalUtils.getDataMap(EPM_PERM_ID_DATA_KEY);
        HashSet result = null;
        String _localKey = "EPM_PERM_ID_DATA_KEY." + dimensionNumber + '.' + modelId + '.' + bizModelId + '.' + viewId + '.' + permTypeEnum + '.' + needHasPerm;
        Object _result = _dataMap.computeIfAbsent(_localKey, f -> DimMembPermHelper.getPermMembIds((String)dimensionNumber, (Long)modelId, (Long)bizModelId, (Long)viewId, (DimMembPermType)permTypeEnum, (boolean)needHasPerm));
        if (_result instanceof Set) {
            result = new HashSet((Set)_result);
        }
        return result;
    }

    public static DimMemberPermChecker getWritePermChecker(Long modelId, Long datasetId) {
        return EpmThreadLocalUtils.getPermChecker(modelId, datasetId, null, DimMembPermType.WRITE);
    }

    public static DimMemberPermChecker getPermChecker(Long modelId, Long datasetId, Long userId, DimMembPermType permType) {
        Map<String, Object> _dataMap = EpmThreadLocalUtils.getDataMap(EPM_PERM_CHECK_DATA_KEY);
        String _localKey = "EPM_PERM_CHECK_DATA_KEY." + modelId + '.' + datasetId + '.' + userId + '.' + permType;
        return (DimMemberPermChecker)_dataMap.computeIfAbsent(_localKey, f -> DimMembPermHelper.getPermChecker((Long)modelId, (Long)datasetId, (Long)userId, (DimMembPermType)permType));
    }

    public static void setDimNoCheckVersion(long modelId) {
        String key = DIM_VER_CHECK + modelId;
        Map<String, Object> map = EpmThreadLocalUtils.getDataMap(DIM_VER_CHECK);
        map.put(key, "noCheck");
    }

    public static boolean needDimCheckVersion(long modelId) {
        String key = DIM_VER_CHECK + modelId;
        Map<String, Object> map = EpmThreadLocalUtils.getDataMap(DIM_VER_CHECK);
        return map == null || !map.containsKey(key);
    }

    public static List<Member> getMemberRange(long modelId, String dimNumber, long viewId, String memNumber, int range) {
        Map<String, Object> _dataMap = EpmThreadLocalUtils.getDataMap(DIM_VIEW_MEM_RANGE);
        String _localKey = "DIM_VIEW_MEM_RANGE." + modelId + '.' + dimNumber + '.' + viewId + '.' + memNumber + '.' + range;
        return (List)_dataMap.computeIfAbsent(_localKey, f -> {
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            return modelCache.getMember(dimNumber, Long.valueOf(viewId), memNumber, range);
        });
    }

    public static Set<Long> getMemberRangeIdSet(long modelId, String dimNumber, long viewId, String memNumber, int range) {
        Map<String, Object> _dataMap = EpmThreadLocalUtils.getDataMap(DIM_VIEW_MEM_RANGE_ID);
        String _localKey = "DIM_VIEW_MEM_RANGE_ID." + modelId + '.' + dimNumber + '.' + viewId + '.' + memNumber + '.' + range;
        return (Set)_dataMap.computeIfAbsent(_localKey, f -> {
            IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            return modelCache.getMember(dimNumber, Long.valueOf(viewId), memNumber, range).stream().map(item -> item.getId()).collect(Collectors.toSet());
        });
    }

    public static void setBudgetExportFlag() {
        Map<String, Object> map = EpmThreadLocalUtils.getDataMap(BUDGET_EXPORT_FLAG);
        map.put(BUDGET_EXPORT_FLAG, "export");
    }

    public static boolean budgetExporgFlag() {
        Map<String, Object> map = EpmThreadLocalUtils.getDataMap(BUDGET_EXPORT_FLAG);
        return map != null && map.containsKey(BUDGET_EXPORT_FLAG);
    }

    public static boolean needCheckDataPerm(String dimNum, Long modelId) {
        Map<String, Object> _dataMap = EpmThreadLocalUtils.getDataMap(CHECK_DATA_PARAM);
        String _localKey = "CHECK_DATA_PARAM." + modelId + '.';
        Set needCheckDimNums = (Set)_dataMap.computeIfAbsent(_localKey, f -> {
            List<Dimension> permControlDim = DimMembPermUtil.getPermControlDim(modelId);
            return permControlDim.stream().map(d -> d.getNumber()).collect(Collectors.toSet());
        });
        return needCheckDimNums.contains(dimNum);
    }

    public static Set<String> getRelationMemNum(long modelId, String dimNumber, Long currPeriodId, Map<String, String> preDimMap, Supplier<Set<String>> supplier) {
        Map<String, Object> _dataMap = EpmThreadLocalUtils.getDataMap(DIM_REL_MEM_NUMBER);
        String preMemStr = preDimMap.values().stream().collect(Collectors.joining(String.valueOf('.')));
        String _localKey = "DIM_REL_MEM_NUMBER." + modelId + '.' + dimNumber + '.' + currPeriodId + '.' + preMemStr;
        return Collections.unmodifiableSet((Set)_dataMap.computeIfAbsent(_localKey, f -> (Set)supplier.get()));
    }
}

