/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.olapdao;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import kd.epm.eb.common.cache.impl.Dimension;

public class BGCell
implements Serializable {
    private static final long serialVersionUID = -7015733594649375323L;
    private Map<String, String> memberMap;
    private Object value;
    private Object oldValue;
    private long updateTime;
    private String key = null;
    private Object[] memberKey;

    public BGCell() {
    }

    public BGCell(Map<String, String> memberMap) {
        this.memberMap = memberMap;
    }

    public BGCell(Map<String, String> memberMap, Object value) {
        this.memberMap = memberMap;
        this.value = value;
    }

    public String getKey(List<String> dimNumbers) {
        StringBuilder sb = new StringBuilder();
        if (this.memberMap != null) {
            if (dimNumbers != null) {
                for (String dimNumber : dimNumbers) {
                    sb.append(this.memberMap.get(dimNumber)).append('!');
                }
            } else {
                for (Map.Entry<String, String> entry : this.memberMap.entrySet()) {
                    sb.append(entry.getValue()).append('!');
                }
            }
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public Object[] getMemberKey(List<Dimension> dimensionList) {
        if (this.memberKey == null) {
            this.memberKey = new Object[dimensionList.size() + 1];
            for (int i = 0; i < dimensionList.size(); ++i) {
                Dimension dimension = dimensionList.get(i);
                this.memberKey[i + 1] = this.memberMap.get(dimension.getNumber());
            }
        }
        return this.memberKey;
    }

    public String getKey2(List<Dimension> dimensionList) {
        if (this.key == null) {
            StringBuilder sb = new StringBuilder();
            if (this.memberMap != null) {
                if (dimensionList != null) {
                    for (Dimension dimNumber : dimensionList) {
                        sb.append(this.memberMap.get(dimNumber.getNumber())).append('!');
                    }
                } else {
                    for (Map.Entry<String, String> entry : this.memberMap.entrySet()) {
                        sb.append(entry.getValue()).append('!');
                    }
                }
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            this.key = sb.toString();
        }
        return this.key;
    }

    public Map<String, String> getMemberMap() {
        return this.memberMap;
    }

    public void setMemberMap(Map<String, String> memberMap) {
        this.memberMap = memberMap;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(Object oldValue) {
        this.oldValue = oldValue;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    public String[] getMeta(String ... dimensions) {
        int index = 0;
        String[] metas = new String[dimensions.length];
        for (String _dimension : dimensions) {
            metas[index] = this.memberMap.get(_dimension);
        }
        return metas;
    }

    public String toString() {
        return "BGCell{value=" + this.value + ", memberMap=" + this.memberMap + '}';
    }
}

