/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.olapdao;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.epm.eb.algo.olap.Cell;
import kd.epm.eb.algo.olap.MdxResult;
import kd.epm.eb.algo.olap.Member;
import kd.epm.eb.algo.olap.OlapElement;
import kd.epm.eb.common.cache.impl.AbstractDimension;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.utils.ObjectCache;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.FixMember;
import kd.epm.eb.common.utils.StringUtils;

public class BGCells {
    public static List<BGCell> of(MdxResult rst, List<FixMember> fixMembers, List<Dimension> dimensionList) {
        ArrayList list = Lists.newArrayList();
        Iterator ite = rst.getCellIterator();
        Map<String, String> shortMap = dimensionList.stream().collect(Collectors.toMap(AbstractDimension::getShortNumber, BaseCache::getNumber));
        List<String> dims = dimensionList.stream().map(BaseCache::getNumber).collect(Collectors.toList());
        Map<String, String> fixMemberCollect = fixMembers.stream().collect(Collectors.toMap(k -> k.getDimNumber(), v -> v.getMemberNumber()));
        while (ite.hasNext()) {
            Cell cell = (Cell)ite.next();
            list.add(BGCells.of(cell, fixMemberCollect, shortMap, dims));
        }
        return list;
    }

    public static BGCell of(Cell cell, Map<String, String> fixMembers, Map<String, String> shortMap, List<String> dims) {
        Member[] members = cell.getMemberContext();
        Map<String, String> mdxCellCollect = Stream.of(cell.getMemberContext()).collect(Collectors.toMap(k -> (String)shortMap.get(k.getDimension().getName()), OlapElement::getName, (n1, n2) -> n2));
        HashMap memberMap = Maps.newHashMapWithExpectedSize((int)members.length);
        for (String dim : dims) {
            String number = mdxCellCollect.get(dim);
            if (StringUtils.isEmpty(number)) {
                number = fixMembers.get(dim);
            }
            memberMap.put(dim, number);
        }
        return new BGCell(memberMap, cell.getValue());
    }

    public static Object[] toArray(BGCell cell, List<String> writeDims) {
        Object[] values = new Object[writeDims.size() + 1];
        values[0] = cell.getValue();
        Map<String, String> memberMap = cell.getMemberMap();
        for (int i = 0; i < writeDims.size(); ++i) {
            String dimNumber = writeDims.get(i);
            values[i + 1] = memberMap.get(dimNumber);
        }
        return values;
    }

    public static BGCell of(Object[] row, List<String> selectDims) {
        HashMap memberMap = Maps.newHashMapWithExpectedSize((int)selectDims.size());
        Object value = row[0];
        for (int i = 0; i < selectDims.size(); ++i) {
            String dimNumber = selectDims.get(i);
            memberMap.put(dimNumber, row[i + 1].toString());
        }
        return new BGCell(memberMap, value);
    }

    public static BGCell of(Object[] row, List<String> selectDims, ObjectCache memberCache) {
        LinkedHashMap memberMap = Maps.newLinkedHashMapWithExpectedSize((int)selectDims.size());
        Object value = row[0];
        for (int i = 0; i < selectDims.size(); ++i) {
            String dimNumber = selectDims.get(i);
            memberMap.put(dimNumber, memberCache.valueOf((Object)row[i + 1].toString()));
        }
        return new BGCell(memberMap, value);
    }

    public static BGCell ofDistinct(Object[] row, List<String> selectDims) {
        HashMap memberMap = Maps.newHashMapWithExpectedSize((int)selectDims.size());
        for (int i = 0; i < selectDims.size(); ++i) {
            String dimNumber = selectDims.get(i);
            memberMap.put(dimNumber, row[i].toString());
        }
        return new BGCell(memberMap, null);
    }
}

