/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.olapdao;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.OlapDataReader;
import kd.epm.eb.common.olapdao.valueConverter.ValueConverter;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.shrek.util.ShrekOlapUtils;

public class BgmdOlapReader
implements AutoCloseable,
Iterator {
    private OlapConnection conn = null;
    protected OlapDataReader reader = null;
    protected List<ValueConverter> valueConverters;
    private List<Object[]> cacheList = Lists.newArrayList();
    private Iterator<Object[]> cacheIterator = Collections.emptyIterator();
    private boolean useCache = false;
    private boolean singleCalc = false;
    private List<String> selectDims = Lists.newArrayList();
    private Map<String, Map<String, String>> functionVirtualMap = Maps.newHashMap();
    private boolean isCloseConn = true;
    private Map<String, Set<String>> leftMembers = Maps.newHashMap();
    private boolean dataLimit = true;
    private int currDataCnt = 0;
    private int maxDataLimit = 1000000;

    public BgmdOlapReader(OlapConnection conn, OlapDataReader reader, boolean isCloseConn, boolean dataLimit) {
        this(conn, reader, dataLimit);
        this.dataLimit = dataLimit;
        this.isCloseConn = isCloseConn;
        if (this.dataLimit) {
            this.maxDataLimit = ParamQueryServiceHelper.getInt((long)0L, (ParamEnum)ParamEnum.BG078);
        }
    }

    public BgmdOlapReader(OlapConnection conn, OlapDataReader reader, boolean dataLimit) {
        this.conn = conn;
        this.reader = reader;
        this.dataLimit = dataLimit;
        if (this.dataLimit) {
            this.maxDataLimit = ParamQueryServiceHelper.getInt((long)0L, (ParamEnum)ParamEnum.BG078);
        }
    }

    @Override
    public void close() {
        ShrekOlapUtils.close((Object[])new Object[]{this.reader});
        if (this.isCloseConn) {
            ShrekOlapUtils.close((Object[])new Object[]{this.conn});
        }
    }

    @Override
    public boolean hasNext() {
        boolean next = false;
        if (this.reader != null && !this.useCache && !(next = this.reader.next())) {
            this.useCache = true;
            this.cacheIterator = this.cacheList.iterator();
        }
        if (this.useCache) {
            next = this.cacheIterator.hasNext();
        }
        return next;
    }

    public void registerValueConverter(ValueConverter valueConverter) {
        if (this.valueConverters == null) {
            this.valueConverters = new LinkedList<ValueConverter>();
        }
        this.valueConverters.add(valueConverter);
    }

    public Object[] next() {
        if (this.useCache) {
            return this.cacheIterator.next();
        }
        Object[] values = null;
        if (this.reader != null) {
            values = new Object[this.reader.getFieldCount()];
            this.reader.getValues(values);
        }
        if (this.valueConverters != null && values != null) {
            for (ValueConverter valueConverter : this.valueConverters) {
                values = valueConverter.convert(values);
            }
        }
        boolean useSrcValue = false;
        if (values != null && this.functionVirtualMap != null && !this.functionVirtualMap.isEmpty()) {
            for (Map.Entry<String, Map<String, String>> entry : this.functionVirtualMap.entrySet()) {
                String dimNumber = entry.getKey();
                Map<String, String> memberMapping = entry.getValue();
                int index = this.selectDims.indexOf(dimNumber) + 1;
                for (Map.Entry<String, String> memEntry : memberMapping.entrySet()) {
                    String srcMem = memEntry.getKey();
                    String fvmMem = memEntry.getValue();
                    if (!srcMem.equals(values[index])) continue;
                    Object[] newArr = new Object[values.length];
                    System.arraycopy(values, 0, newArr, 0, values.length);
                    newArr[index] = fvmMem;
                    this.cacheList.add(newArr);
                    useSrcValue = true;
                }
            }
        }
        if (useSrcValue && this.singleCalc) {
            boolean bl = true;
            if (!this.leftMembers.isEmpty()) {
                boolean bl2;
                for (Map.Entry<String, Set<String>> entry : this.leftMembers.entrySet()) {
                    int index;
                    String member;
                    String dimNumber = entry.getKey();
                    Set<String> members = entry.getValue();
                    if (members.contains(member = (String)values[index = this.selectDims.indexOf(dimNumber) + 1])) continue;
                    bl2 = false;
                    break;
                }
                if (bl2) {
                    values[0] = null;
                }
            }
        }
        ++this.currDataCnt;
        if (this.dataLimit && this.currDataCnt > this.maxDataLimit) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u636e\u91cf\u8d85\u8fc7\u9884\u7b97\u591a\u7ef4\u6570\u636e\u67e5\u8be2\u9650\u5236\u3010%1\u3011\u3002", (String)"BgmdOlapReader_0", (String)"epm-eb-common", (Object[])new Object[]{this.maxDataLimit}));
        }
        return values;
    }

    public void forEachRemaining(Consumer action) {
        throw new UnsupportedOperationException("forEachRemaining");
    }

    public List<String> getSelectDims() {
        return this.selectDims;
    }

    public void setSelectDims(List<String> selectDims) {
        this.selectDims = selectDims;
    }

    public Map<String, Map<String, String>> getFunctionVirtualMap() {
        return this.functionVirtualMap;
    }

    public void setFunctionVirtualMap(Map<String, Map<String, String>> functionVirtualMap) {
        this.functionVirtualMap = functionVirtualMap;
    }

    public boolean isSingleCalc() {
        return this.singleCalc;
    }

    public void setSingleCalc(boolean singleCalc) {
        this.singleCalc = singleCalc;
    }

    public Map<String, Set<String>> getLeftMembers() {
        return this.leftMembers;
    }

    public void setLeftMembers(Map<String, Set<String>> leftMembers) {
        this.leftMembers = leftMembers;
    }
}

