/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.permission;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.cache.DimMembPermVerHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.perm.MemberRecord;
import kd.epm.eb.common.cache.impl.perm.RowRecord;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.constant.BgFormConstant;
import kd.epm.eb.common.membpermlog.EbMembPermLogHelper;
import kd.epm.eb.common.membpermlog.MembPermOpType;
import kd.epm.eb.common.membpermlog.MembPermType;
import kd.epm.eb.common.membpermlog.PermOpLogObj;
import kd.epm.eb.common.permission.AbstructPermRecordSqlBuilder;
import kd.epm.eb.common.permission.DetailPermSqlBuilder;
import kd.epm.eb.common.permission.DimMembPermUtil;
import kd.epm.eb.common.permission.IPermRecordSqlBuilder;
import kd.epm.eb.common.permission.MainRecordSqlBuilder;
import kd.epm.eb.common.permission.enums.PermGroupEnum;
import kd.epm.eb.common.permission.membPerm.ManagerPermConsumer;
import kd.epm.eb.common.permission.pojo.BatchPermSaveArgs;
import kd.epm.eb.common.permission.pojo.DimMembPermDetailRecord;
import kd.epm.eb.common.permission.pojo.DimMembPermRecord;
import kd.epm.eb.common.permission.pojo.MemberTree;
import kd.epm.eb.common.permission.policyUtils.DetailMembPermRecordHandler;
import kd.epm.eb.common.permission.policyUtils.DetailNoMembRecordHandler;
import kd.epm.eb.common.permission.policyUtils.DetailRecord4SeqHandler;
import kd.epm.eb.common.permission.policyUtils.DetailRecordHandler;
import kd.epm.eb.common.permission.policyUtils.IPermRecordHandler;
import kd.epm.eb.common.permission.policyUtils.MainRecord4DimStrHandler;
import kd.epm.eb.common.permission.policyUtils.MainRecord4MapHandler;
import kd.epm.eb.common.permission.policyUtils.MainRecord4SetHandler;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.UserUtils;

public class MembPermRecordUtil {
    public static String mainRecordInsertSql = "insert into t_eb_membpermrecord(fid,fmodelid,fdimshortnums,fuid,fbizctrlrangeid,fpermgroup,fmodifier,fmodifytime) values(?,?,?,?,?,?,?,?)";
    public static String detailRecordInsertSql = "insert into t_eb_membpermrecorddetail(fid,fentryid,fmemberid,fpermval,fseq,fmembtype,fmembseq,fviewid) values(?,?,?,?,?,?,?,?)";
    public static String mainRecordUpdateSql = "update t_eb_membpermrecord set fmodifier = ?,fmodifytime = ? where fid = ?";
    public static String mainRecordDelSql = "delete from t_eb_membpermrecord where fid = ?";
    public static String detailRecordDelSql = "delete from t_eb_membpermrecorddetail where fid = ? and fseq = ?";
    private static final Log log = LogFactory.getLog(MembPermRecordUtil.class);
    private static final DBRoute route = new DBRoute("epm");

    public static DimMembPermRecord getMainPermRecord(Long modelId, Long bizCtrlRangeId, List<String> dimNums, Long userId, PermGroupEnum permGrop) {
        Map<Long, DimMembPermRecord> allUserPerm = MembPermRecordUtil.getUsersPermRecord(modelId, bizCtrlRangeId, dimNums, Sets.newHashSet((Object[])new Long[]{userId}), permGrop);
        return allUserPerm == null ? null : allUserPerm.get(userId);
    }

    public static void fillDetailRecord(Map<Long, DimMembPermRecord> mainRecordMap) {
        if (mainRecordMap.size() > 0) {
            DetailRecordHandler recordHandler = new DetailRecordHandler(mainRecordMap);
            MembPermRecordUtil.readDetailPermRecord((IPermRecordHandler)recordHandler);
        }
    }

    public static Set<Long> getMainIds(MainRecordSqlBuilder sqlBuilder) {
        MainRecord4SetHandler mainRecordHandler = new MainRecord4SetHandler();
        MembPermRecordUtil.readPermRecord((AbstructPermRecordSqlBuilder)sqlBuilder, (IPermRecordHandler)mainRecordHandler);
        return (Set)mainRecordHandler.getResult();
    }

    public static void readPermRecord(AbstructPermRecordSqlBuilder sqlBuilder, IPermRecordHandler recordHandler) {
        recordHandler.addFilter((IPermRecordSqlBuilder)sqlBuilder);
        recordHandler.addSelFields((IPermRecordSqlBuilder)sqlBuilder);
        String sql = sqlBuilder.build();
        try (DataSet dataSet = DB.queryDataSet((String)"readPermRecord", (DBRoute)route, (String)sql, (Object[])sqlBuilder.getArraysParams());){
            for (Row row : dataSet) {
                recordHandler.dealRow(row);
            }
        }
    }

    public static Map<Long, DimMembPermRecord> getUsersPermRecord(Long modelId, Long bizCtrlRangeId, List<String> dimNums, Collection<Long> usreIds, PermGroupEnum permGrop) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Map<String, Map<Long, DimMembPermRecord>> allPermRecord = MembPermRecordUtil.getPermRecordByBizModel(modelCacheHelper, bizCtrlRangeId, dimNums, usreIds, permGrop, false, true);
        String dimShortNumsStr = DimMembPermUtil.getDimShortNumsStr(modelCacheHelper, dimNums, false);
        Map<Long, DimMembPermRecord> userRecords = allPermRecord.get(dimShortNumsStr);
        return userRecords;
    }

    public static Map<String, Map<Long, DimMembPermRecord>> getPermRecordByBizModel(IModelCacheHelper modelCacheHelper, Long bizCtrlRangeId, List<String> dimNums, Collection<Long> usreIds, PermGroupEnum permGrop, boolean fuzzySearch, boolean needDetailRecord) {
        Map<Long, Map<String, Map<Long, DimMembPermRecord>>> usersPermRecord4 = MembPermRecordUtil.getPermRecordByBizModels(modelCacheHelper, Sets.newHashSet((Object[])new Long[]{bizCtrlRangeId}), dimNums, usreIds, permGrop, fuzzySearch, needDetailRecord);
        HashMap result = usersPermRecord4.get(bizCtrlRangeId);
        return result == null ? new HashMap(1) : result;
    }

    public static Map<Long, Map<String, Map<Long, DimMembPermRecord>>> getPermRecordByBizModels(IModelCacheHelper modelCacheHelper, Set<Long> bizCtrlRangeIds, List<String> dimNums, Collection<Long> usreIds, PermGroupEnum permGrop, boolean fuzzySearch, boolean needDetailRecord) {
        Long modelId = modelCacheHelper.getModelobj().getId();
        List<String> dimShortNums = DimMembPermUtil.toShortNums(modelCacheHelper, dimNums);
        HashSet<Long> searchBizModelIds = new HashSet<Long>(bizCtrlRangeIds);
        MainRecordSqlBuilder sqlBuilder = new MainRecordSqlBuilder();
        sqlBuilder.setBCRsFilter(searchBizModelIds);
        if (fuzzySearch) {
            sqlBuilder.setDimNumsFilter(DimMembPermUtil.getDimShortNumsStr(dimShortNums, true));
        } else {
            sqlBuilder.setDimNumFilter(DimMembPermUtil.getDimShortNumsStr(dimShortNums, false));
        }
        sqlBuilder.setPermGroupFilter(permGrop);
        sqlBuilder.setUsersFilter(usreIds);
        sqlBuilder.setModelFilter(modelId);
        Map<Long, DimMembPermRecord> recordMap = MembPermRecordUtil.readMainRecord((AbstructPermRecordSqlBuilder)sqlBuilder, modelId, permGrop, bizCtrlRangeIds);
        if (needDetailRecord) {
            MembPermRecordUtil.fillDetailRecord(recordMap);
        }
        HashMap<Long, Map<String, Map<Long, DimMembPermRecord>>> result = new HashMap<Long, Map<String, Map<Long, DimMembPermRecord>>>(16);
        recordMap.values().forEach(record -> result.computeIfAbsent(record.getBizCtrlRangeId(), key -> new HashMap(16)).computeIfAbsent(record.getDimNumsStr(), key -> new HashMap(16)).put(record.getUid(), record));
        return result;
    }

    public static Map<Long, DimMembPermRecord> readMainRecordByModel(Long modelId, PermGroupEnum permGroupEnum) {
        MainRecordSqlBuilder sqlBuilder = new MainRecordSqlBuilder();
        sqlBuilder.setModelFilter(modelId);
        if (permGroupEnum == PermGroupEnum.MANAGER) {
            sqlBuilder.setBCRFilter(Long.valueOf(0L));
        }
        sqlBuilder.setPermGroupFilter(permGroupEnum);
        Map<Long, DimMembPermRecord> permRecordMap = MembPermRecordUtil.readMainRecord((AbstructPermRecordSqlBuilder)sqlBuilder, modelId, permGroupEnum, null);
        MembPermRecordUtil.fillDetailRecord(permRecordMap);
        return permRecordMap;
    }

    public static Map<Long, DimMembPermRecord> readMainRecord(AbstructPermRecordSqlBuilder sqlBuilder, Long modelId, PermGroupEnum permGroup, Set<Long> bizCtrlRangeIds) {
        HashMap<Long, DimMembPermRecord> recordMap = new HashMap<Long, DimMembPermRecord>(16);
        sqlBuilder.addSelFields(new String[]{"fid", "fuid", "fmodifier", "fmodifytime", "fbizctrlrangeid", "fdimshortnums"});
        try (DataSet dataSet = DB.queryDataSet((String)"getUsersPermRecord_main", (DBRoute)route, (String)sqlBuilder.build(), (Object[])sqlBuilder.getArraysParams());){
            for (Row row : dataSet) {
                Long bcrIdOnRecord = row.getLong("fbizctrlrangeid");
                if (bizCtrlRangeIds != null && !bizCtrlRangeIds.contains(bcrIdOnRecord)) continue;
                DimMembPermRecord dimMembPermRecord = new DimMembPermRecord(row.getLong("fid"), modelId, row.getString("fdimshortnums"), row.getLong("fuid"), bcrIdOnRecord, permGroup, row.getLong("fmodifier"), row.getTimestamp("fmodifytime"));
                recordMap.put(dimMembPermRecord.getId(), dimMembPermRecord);
            }
        }
        return recordMap;
    }

    public static void mergeRecordOnUser(Map<String, Map<Long, List<RowRecord>>> sourceRecord, Map<String, Map<Long, List<RowRecord>>> targetRecord, Long userId) {
        sourceRecord.forEach((dimStr, allUserRecord) -> {
            List records = (List)allUserRecord.get(userId);
            if (records != null) {
                targetRecord.computeIfAbsent((String)dimStr, key -> new HashMap(16)).put(userId, records);
            }
        });
    }

    public static void mergeRecordOnUser(Map<String, Map<Long, Map<Long, List<RowRecord>>>> sourceRecord, Long viewGroupId, Map<String, Map<Long, List<RowRecord>>> targetRecord, Long userId) {
        sourceRecord.forEach((dimStr, allUserRecord) -> {
            List _records;
            Map records = (Map)allUserRecord.get(userId);
            if (records != null && (_records = (List)records.get(viewGroupId)) != null) {
                targetRecord.computeIfAbsent((String)dimStr, key -> new HashMap(16)).put(userId, _records);
            }
        });
    }

    public static Map<Long, List<RowRecord>> getUserPermRowRecords(Long modelId, Long bizCtrlRangeId, List<String> dimNums, List<Long> userInfoList, PermGroupEnum permGroup, boolean fuzzySearch, boolean loadRefInfo, boolean checkNotDataPerm) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Map<String, Map<Long, List<RowRecord>>> allPermRecord = MembPermRecordUtil.getUsersPermRowRecords(modelCacheHelper, bizCtrlRangeId, dimNums, userInfoList, permGroup, fuzzySearch, loadRefInfo, checkNotDataPerm);
        String dimShortNumsStr = DimMembPermUtil.getDimShortNumsStr(modelCacheHelper, dimNums, false);
        return allPermRecord.get(dimShortNumsStr);
    }

    public static Map<String, Map<Long, List<RowRecord>>> getUsersPermRowRecords(IModelCacheHelper modelCacheHelper, Long bizCtrlRangeId, List<String> currentDimNums, Collection<Long> userInfoList, PermGroupEnum permGroup, boolean fuzzySearch, boolean loadRefInfo, boolean checkNotDataPerm) {
        Map<String, Map<Long, DimMembPermRecord>> usersPermRecord = MembPermRecordUtil.getPermRecordByBizModel(modelCacheHelper, bizCtrlRangeId, currentDimNums, userInfoList, permGroup, fuzzySearch, true);
        HashMap<String, Map<Long, List<RowRecord>>> rowRecords = new HashMap<String, Map<Long, List<RowRecord>>>(usersPermRecord.size());
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate(modelCacheHelper.getModelobj().getId());
        usersPermRecord.forEach((dimShortNumStr, allUserPermInfo) -> {
            List<String> dimNums = DimMembPermUtil.getDimNumsByShortStr(dimShortNumStr, modelCacheHelper);
            if (!dimNums.isEmpty()) {
                if (permGroup == PermGroupEnum.MANAGER && dimNums.size() == 1) {
                    MembPermRecordUtil.switchManagerPermRecord(allUserPermInfo, modelCacheHelper, bizCtrlRangeId, memberPropCache, loadRefInfo, checkNotDataPerm, dimNums, (_viewGroupId, _userId, permRows) -> rowRecords.computeIfAbsent((String)dimShortNumStr, key -> new HashMap(16)).computeIfAbsent(_userId, key -> new ArrayList(16)).addAll(permRows));
                } else {
                    allUserPermInfo.forEach((uId, allRowPermRecord) -> {
                        List<RowRecord> records = MembPermRecordUtil.switchPermRecord(allRowPermRecord.getAllDetailRecords().values(), null, dimNums, modelCacheHelper, bizCtrlRangeId, memberPropCache, loadRefInfo, checkNotDataPerm);
                        rowRecords.computeIfAbsent((String)dimShortNumStr, key -> new HashMap(16)).put(uId, records);
                    });
                }
            }
        });
        return rowRecords;
    }

    public static Map<String, Map<Long, Map<Long, List<RowRecord>>>> getUsersManagerPermRowRecords(IModelCacheHelper modelCacheHelper, Long bizCtrlRangeId, List<String> dimNumbers, Collection<Long> userInfoList, PermGroupEnum permGroup, boolean fuzzySearch, boolean loadRefInfo, boolean checkNotDataPerm) {
        Map<String, Map<Long, DimMembPermRecord>> usersPermRecord = MembPermRecordUtil.getPermRecordByBizModel(modelCacheHelper, bizCtrlRangeId, dimNumbers, userInfoList, permGroup, fuzzySearch, true);
        HashMap<String, Map<Long, Map<Long, List<RowRecord>>>> rowRecords = new HashMap<String, Map<Long, Map<Long, List<RowRecord>>>>(usersPermRecord.size());
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate(modelCacheHelper.getModelobj().getId());
        usersPermRecord.forEach((dimShortNumStr, allUserPermInfo) -> {
            List<String> dimNums = DimMembPermUtil.getDimNumsByShortStr(dimShortNumStr, modelCacheHelper);
            if (!dimNums.isEmpty()) {
                MembPermRecordUtil.switchManagerPermRecord(allUserPermInfo, modelCacheHelper, bizCtrlRangeId, memberPropCache, loadRefInfo, checkNotDataPerm, dimNums, (_viewGroupId, _userId, permRows) -> rowRecords.computeIfAbsent((String)dimShortNumStr, key -> new HashMap(16)).computeIfAbsent(_userId, key -> new HashMap(16)).put(_viewGroupId, permRows));
            }
        });
        return rowRecords;
    }

    private static void switchManagerPermRecord(Map<Long, DimMembPermRecord> allUserPermInfo, IModelCacheHelper modelCacheHelper, Long bizCtrlRangeId, MemberPropCache memberPropCache, boolean loadRefInfo, boolean checkNotDataPerm, List<String> dimNums, ManagerPermConsumer permConsumer) {
        Map<Long, Set<Long>> allViewAndGroup = DimMembPermUtil.getAllViewAndGroupFromCache(modelCacheHelper.getModelobj().getId(), modelCacheHelper.getDimension(dimNums.get(0)).getId());
        allUserPermInfo.forEach((uId, allRowPermRecord) -> {
            if (allViewAndGroup.isEmpty()) {
                List<RowRecord> _rowRecords = MembPermRecordUtil.switchPermRecord(allRowPermRecord.getAllDetailRecords().values(), null, dimNums, modelCacheHelper, bizCtrlRangeId, memberPropCache, loadRefInfo, checkNotDataPerm);
                permConsumer.accept(Long.valueOf(0L), uId, _rowRecords);
            } else {
                ArrayList detailRecordList = new ArrayList(16);
                allViewAndGroup.forEach((viewGroupId, refViewIds) -> {
                    Set<Long> _refViewIds = new HashSet(16);
                    boolean hasProp = false;
                    for (DimMembPermDetailRecord[] detailRecord : allRowPermRecord.getAllDetailRecords().values()) {
                        if (!detailRecord[0].isMember() || refViewIds.contains(detailRecord[0].getViewId())) {
                            detailRecordList.add(detailRecord);
                        }
                        if (IDUtils.isNotEmptyLong((Long)detailRecord[0].getViewId()).booleanValue()) {
                            _refViewIds.add(detailRecord[0].getViewId());
                        }
                        hasProp = hasProp || !detailRecord[0].isMember();
                    }
                    if (detailRecordList.size() > 0) {
                        if (hasProp) {
                            _refViewIds = refViewIds;
                        }
                        HashMap<String, Set<Long>> allRefViewIds = new HashMap<String, Set<Long>>(1);
                        allRefViewIds.put((String)dimNums.get(0), _refViewIds);
                        List<RowRecord> _rowRecords = MembPermRecordUtil.switchPermRecord(detailRecordList, allRefViewIds, dimNums, modelCacheHelper, bizCtrlRangeId, memberPropCache, loadRefInfo, checkNotDataPerm);
                        permConsumer.accept(viewGroupId, uId, _rowRecords);
                        detailRecordList.clear();
                    }
                });
            }
        });
    }

    private static List<RowRecord> switchPermRecord(Collection<DimMembPermDetailRecord[]> detailRecordList, Map<String, Set<Long>> refViewIds, List<String> dimNums, IModelCacheHelper modelCacheHelper, Long bizCtrlRangeId, MemberPropCache memberPropCache, boolean loadRefInfo, boolean checkNotDataPerm) {
        List<MemberTree> dimViewList = DimMembPermUtil.getDimViews(dimNums, refViewIds, modelCacheHelper, bizCtrlRangeId);
        return MembPermRecordUtil.switchPermRecord(detailRecordList, dimViewList, loadRefInfo, memberPropCache, checkNotDataPerm);
    }

    public static List<RowRecord> switchPermRecord(Collection<DimMembPermDetailRecord[]> allRowPermRecord, List<MemberTree> dimViewList, boolean loadRefInfo, MemberPropCache memberPropCache, boolean checkNotDataPerm) {
        ArrayList<RowRecord> records = new ArrayList<RowRecord>(allRowPermRecord.size());
        allRowPermRecord.forEach(memberRecords -> {
            RowRecord row = new RowRecord();
            int i = 0;
            for (DimMembPermDetailRecord detailRecord : memberRecords) {
                row.setPermVal(detailRecord.getPermVal());
                MemberRecord record = new MemberRecord();
                record.setId(detailRecord.getMemberId());
                record.setMember(detailRecord.isMember());
                record.setViewId(detailRecord.getViewId());
                if (record.isMember()) {
                    if (i < dimViewList.size()) {
                        Member m = ((MemberTree)dimViewList.get(i)).getMember(record.getId());
                        if (m == null) return;
                        record.setSortVal(m.getAllChildCount());
                    }
                } else {
                    record.setSortVal(-10000 - detailRecord.getSeq());
                }
                if (row.getRowId() == null) {
                    row.setRowId(detailRecord.getEntryId());
                }
                row.getMemberRecords().add(record);
                ++i;
            }
            records.add(row);
        });
        records.sort((record1, record2) -> {
            for (int i = 0; i < record1.getMemberRecords().size() && i < record2.getMemberRecords().size(); ++i) {
                MemberRecord memberRecord1 = (MemberRecord)record1.getMemberRecords().get(i);
                MemberRecord memberRecord2 = (MemberRecord)record2.getMemberRecords().get(i);
                if (memberRecord1.getSortVal() < memberRecord2.getSortVal()) {
                    return 1;
                }
                if (memberRecord1.getSortVal() <= memberRecord2.getSortVal()) continue;
                return -1;
            }
            return 0;
        });
        if (loadRefInfo) {
            DimMembPermUtil.buildRefPermRecordInside(records, dimViewList, memberPropCache, checkNotDataPerm);
        }
        return records;
    }

    public static Map<Long, DimMembPermRecord> getBRCsPermRecordNoDetail(Long modelId, Long bizModelId, List<String> dimShortNums, Long userId, PermGroupEnum permGrop) {
        Map<Long, Map<Long, DimMembPermRecord>> brCsPermRecordNoDetail = MembPermRecordUtil.getBRCsPermRecordNoDetail(modelId, bizModelId, dimShortNums, Collections.singletonList(userId), permGrop);
        HashMap permRecordMap = brCsPermRecordNoDetail.get(userId);
        return permRecordMap == null ? new HashMap(16) : permRecordMap;
    }

    public static Map<Long, Map<Long, DimMembPermRecord>> getBRCsPermRecordNoDetail(Long modelId, Long bizModelId, List<String> dimShortNums, Collection<Long> userIds, PermGroupEnum permGroup) {
        String dimStr = DimMembPermUtil.getDimShortNumsStr(dimShortNums, false);
        MainRecordSqlBuilder sqlBuilder = new MainRecordSqlBuilder();
        sqlBuilder.addSelFields(new String[]{"fid", "fuid", "fmodifier", "fmodifytime", "fbizctrlrangeid"});
        sqlBuilder.setModelFilter(modelId);
        sqlBuilder.setUsersFilter(userIds);
        sqlBuilder.setDimNumFilter(dimStr);
        sqlBuilder.setPermGroupFilter(permGroup);
        sqlBuilder.setBCRsFilter((Collection)Sets.newHashSet((Object[])new Long[]{bizModelId}));
        HashMap<Long, Map<Long, DimMembPermRecord>> recordsMap = new HashMap<Long, Map<Long, DimMembPermRecord>>(16);
        try (DataSet dataSet = DB.queryDataSet((String)"getUsersPermRecord_main", (DBRoute)route, (String)sqlBuilder.build(), (Object[])sqlBuilder.getArraysParams());){
            for (Row row : dataSet) {
                Long userId = row.getLong("fuid");
                DimMembPermRecord dimMembPermRecord = new DimMembPermRecord(row.getLong("fid"), modelId, dimStr, userId, row.getLong("fbizctrlrangeid"), permGroup, row.getLong("fmodifier"), row.getTimestamp("fmodifytime"));
                Map recordMap = recordsMap.computeIfAbsent(userId, key -> new HashMap(16));
                recordMap.put(dimMembPermRecord.getBizCtrlRangeId(), dimMembPermRecord);
            }
        }
        return recordsMap;
    }

    public static void saveRecord(DimMembPermRecord permRecord) {
        boolean hasDetailRecord;
        boolean newRecord = permRecord.getId() == 0L;
        boolean bl = hasDetailRecord = permRecord.getAllDetailRecords() != null && permRecord.getAllDetailRecords().size() > 0;
        if (hasDetailRecord) {
            if (newRecord) {
                permRecord.setId(GlobalIdUtil.genGlobalLongId());
                MembPermRecordUtil.batchSaveMainRecord(Collections.singletonList(permRecord));
            } else {
                DB.execute((DBRoute)route, (String)mainRecordUpdateSql, (Object[])new Object[]{permRecord.getModifierId(), permRecord.getModifytime(), permRecord.getId()});
            }
            MembPermRecordUtil.saveDetailRecord(Collections.singletonList(permRecord), true);
        } else if (!newRecord) {
            DB.execute((DBRoute)route, (String)mainRecordDelSql, (Object[])new Object[]{permRecord.getId()});
        }
    }

    private static void addLog(DimMembPermRecord permRecord, Set<Long> mainRecordIds) {
        PermOpLogObj logObj = new PermOpLogObj();
        PermGroupEnum permGrop = permRecord.getPermGrop();
        MembPermType permType = PermGroupEnum.DATA == permGrop ? MembPermType.DATA : MembPermType.MANAGER;
        logObj.setOpType(MembPermOpType.SET);
        logObj.setPermType(permType);
        logObj.setBcrId(permRecord.getBizCtrlRangeId());
        logObj.setModel(permRecord.getModelId());
        logObj.setDimShortNumStr(permRecord.getDimNumsStr());
        logObj.setTargetUser(permRecord.getUid());
        logObj.setOpUser(UserUtils.getUserId());
        logObj.setOpTime(TimeServiceHelper.now());
        StringBuilder logInfo = new StringBuilder();
        logInfo.append("recordSize:").append(permRecord.getAllDetailRecords().size());
        HashSet<Long> mainIds = new HashSet<Long>(mainRecordIds);
        mainIds.add(permRecord.getId());
        logInfo.append(",mainRecordIds:").append(SerializationUtils.toJsonString(mainIds));
        logObj.setLogInfo(logInfo.toString());
        EbMembPermLogHelper.addOpLog(Collections.singletonList(logObj));
    }

    public static void saveDetailRecord(List<DimMembPermRecord> mainRecords, boolean updateMainId) {
        ArrayList values = new ArrayList(16);
        mainRecords.forEach(mRecord -> mRecord.getAllDetailRecords().forEach((seq, detailRecords) -> {
            int memberSeq = 0;
            for (DimMembPermDetailRecord detailRecord : detailRecords) {
                if (updateMainId) {
                    detailRecord.setMainId(mRecord.getId());
                }
                detailRecord.setSeq(seq.intValue());
                detailRecord.setMemberSeq(memberSeq);
                values.add(detailRecord.getValues());
                ++memberSeq;
            }
        }));
        if (values.size() > 0) {
            DB.executeBatch((DBRoute)route, (String)detailRecordInsertSql, values);
        }
    }

    public static void batchSavePermRecord(List<DimMembPermRecord> permRecords, List<String> dimNums, Long bizCtrlRangeId, Long modelId, MembPermOpType opType) {
        if (permRecords == null || permRecords.isEmpty()) {
            return;
        }
        PermGroupEnum permGrop = permRecords.get(0).getPermGrop();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        ArrayList<String> dimShortNums = new ArrayList<String>(dimNums.size());
        for (String dimNum : dimNums) {
            Dimension dimension = modelCacheHelper.getDimension(dimNum);
            if (dimension == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u83b7\u53d6\u7ef4\u5ea6%1\u5931\u8d25", (String)"DimMembPermUtil_1", (String)"epm-eb-common", (Object[])new Object[]{dimNum}));
            }
            dimShortNums.add(dimension.getShortNumber());
        }
        HashSet<Long> refUserIs = new HashSet<Long>(16);
        permRecords.forEach(mainRecord -> refUserIs.add(mainRecord.getUid()));
        HashSet refMainRecordIds = new HashSet(16);
        Map<Long, Map<Long, DimMembPermRecord>> refPermMainRecords = MembPermRecordUtil.getBRCsPermRecordNoDetail(modelId, bizCtrlRangeId, dimShortNums, refUserIs, permGrop);
        refPermMainRecords.forEach((userId, refPermRecord) -> refPermRecord.values().forEach(mainRecord -> refMainRecordIds.add(mainRecord.getId())));
        HashSet<String> dimGroupNums = new HashSet<String>(1);
        dimGroupNums.add(DimMembPermUtil.getDimShortNumsStr(modelCacheHelper, dimNums, false));
        BatchPermSaveArgs batchPermSaveArgs = new BatchPermSaveArgs(refMainRecordIds, permRecords, refUserIs, dimGroupNums, (Set)Sets.newHashSet((Object[])new Long[]{bizCtrlRangeId}), modelId, opType);
        MembPermRecordUtil.batchSavePermRecord(batchPermSaveArgs);
    }

    public static void batchSavePermRecord(BatchPermSaveArgs saveArgs) {
        try (TXHandle tx = TX.required((String)"batchSavePermRecord");){
            try {
                MembPermRecordUtil.delPermRecord(null, saveArgs.getRefMainRecord());
                MembPermRecordUtil.savePermRecord(saveArgs.getToSaveMainRecord());
                DimMembPermVerHelper.updateVer((Long)saveArgs.getModelId(), (Set)saveArgs.getTargetUserIds(), (Set)saveArgs.getTargetDimGroupNumbers(), (Set)saveArgs.getTargetBCRIds());
            }
            catch (Exception ex) {
                tx.markRollback();
                throw ex;
            }
        }
        MembPermRecordUtil.addLog(saveArgs);
    }

    private static void addLog(BatchPermSaveArgs saveArgs) {
        Set selectedBCRIds = saveArgs.getTargetBCRIds();
        Set selectedDimGroupNumbers = saveArgs.getTargetDimGroupNumbers();
        Set selectedTargetUsers = saveArgs.getTargetUserIds();
        ArrayList opLogObjs = new ArrayList(16);
        Date now = TimeServiceHelper.now();
        Long opUser = UserUtils.getUserId();
        if (saveArgs.getTargetBCRIds().isEmpty()) {
            selectedBCRIds = Sets.newHashSet((Object[])new Long[]{0L});
        }
        selectedBCRIds.forEach(bcrId -> selectedDimGroupNumbers.forEach(dimShortNumStr -> selectedTargetUsers.forEach(targetUid -> {
            PermOpLogObj logObj = new PermOpLogObj();
            logObj.setLogInfo(saveArgs.getLogInfo());
            logObj.setOpTime(now);
            logObj.setOpUser(opUser);
            logObj.setModel(saveArgs.getModelId());
            logObj.setDimShortNumStr(dimShortNumStr);
            logObj.setBcrId(bcrId);
            logObj.setTargetUser(targetUid);
            logObj.setOpType(saveArgs.getPermOpType());
            logObj.setPermType(MembPermType.DATA);
            opLogObjs.add(logObj);
        })));
        EbMembPermLogHelper.addOpLog(opLogObjs);
    }

    public static void savePermRecord(Set<Long> refMainRecordIds, Long targetUserId, boolean isUserGroup, DimMembPermRecord permRecord) {
        try (TXHandle th = TX.required();){
            try {
                MembPermRecordUtil.delPermRecord(permRecord, refMainRecordIds);
                MembPermRecordUtil.saveRecord(permRecord);
                if (permRecord.getPermGrop() == PermGroupEnum.DATA) {
                    DimMembPermVerHelper.updateVer4Auth((String)permRecord.getDimNumsStr(), (Long)permRecord.getBizCtrlRangeId(), (Long)permRecord.getModelId(), (Long)targetUserId, (!isUserGroup ? 1 : 0) != 0);
                }
            }
            catch (Exception e) {
                th.markRollback();
                log.error((Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
        MembPermRecordUtil.addLog(permRecord, refMainRecordIds);
    }

    public static void savePermRecord(List<DimMembPermRecord> mainPermRecords) {
        MembPermRecordUtil.batchSaveMainRecord(mainPermRecords);
        MembPermRecordUtil.saveDetailRecord(mainPermRecords, false);
    }

    public static void batchSaveMainRecord(List<DimMembPermRecord> mainPermRecords) {
        if (mainPermRecords.size() > 0) {
            ArrayList values = new ArrayList(mainPermRecords.size());
            mainPermRecords.forEach(dimMembPermRecord -> values.add(dimMembPermRecord.getValues()));
            DB.executeBatch((DBRoute)route, (String)mainRecordInsertSql, values);
        }
    }

    public static Set<Long> getBCRIdsOnGivePerm(Long modelId, Long userId) {
        return (Set)MembPermRecordUtil.getFieldValOnGivePerm(userId, modelId, null, "fbizctrlrangeid");
    }

    public static Set<Long> getModelIdsOnGivePerm(Long userId) {
        return (Set)MembPermRecordUtil.getFieldValOnGivePerm(userId, null, null, "fmodelid");
    }

    public static Set<String> getDimShortNumStrOnGivePerm(Long userId, Long modelId, Long bizCtrlRageId) {
        return (Set)MembPermRecordUtil.getFieldValOnGivePerm(userId, modelId, bizCtrlRageId, "fdimshortnums");
    }

    private static <T> T getFieldValOnGivePerm(Long userId, Long modelId, Long bizCtrlRageId, String fieldKey) {
        MainRecordSqlBuilder sqlBuilder = new MainRecordSqlBuilder();
        sqlBuilder.setBCRFilter(bizCtrlRageId);
        sqlBuilder.setModelFilter(modelId);
        MainRecord4MapHandler recordHandler = new MainRecord4MapHandler(fieldKey);
        MembPermRecordUtil.readMainPermRecordOnGPerm((IPermRecordHandler)recordHandler, sqlBuilder, userId);
        DetailNoMembRecordHandler detailRecordHandler = new DetailNoMembRecordHandler((Map)recordHandler.getResult());
        MembPermRecordUtil.readDetailPermRecord((IPermRecordHandler)detailRecordHandler);
        return (T)detailRecordHandler.getResult();
    }

    public static Set<String> getDimShortNumStrWithData(Long modelId, Long bizCtrlRageId, Collection<String> dimShortNumStrs, Long userId, PermGroupEnum permDimGroup) {
        MainRecord4DimStrHandler recordHandler = new MainRecord4DimStrHandler(bizCtrlRageId);
        MainRecordSqlBuilder sqlBuilder = new MainRecordSqlBuilder();
        sqlBuilder.setModelFilter(modelId);
        sqlBuilder.setPermGroupFilter(permDimGroup);
        sqlBuilder.setDimShortNumsFilter(dimShortNumStrs);
        if (userId != null) {
            sqlBuilder.setUsersFilter((Collection)UserUtils.getAllRefUserGroupIds((Long)userId));
        }
        MembPermRecordUtil.readPermRecord((AbstructPermRecordSqlBuilder)sqlBuilder, (IPermRecordHandler)recordHandler);
        return (Set)recordHandler.getResult();
    }

    private static void readMainPermRecordOnGPerm(IPermRecordHandler recordHandler, MainRecordSqlBuilder sqlBuilder, Long userId) {
        List allRefUserGropInfo = UserUtils.getAllRefUserGroupIds((Long)userId);
        sqlBuilder.addSelFields(new String[]{"fid"});
        sqlBuilder.setUsersFilter((Collection)allRefUserGropInfo);
        sqlBuilder.setPermGroupFilter(PermGroupEnum.DATA);
        MembPermRecordUtil.readPermRecord((AbstructPermRecordSqlBuilder)sqlBuilder, recordHandler);
    }

    private static void readDetailPermRecord(IPermRecordHandler recordHandler) {
        DetailPermSqlBuilder sqlBuilder = new DetailPermSqlBuilder();
        MembPermRecordUtil.readPermRecord((AbstructPermRecordSqlBuilder)sqlBuilder, recordHandler);
    }

    public static void delPermRecord(DimMembPermRecord toSaveRecord, Set<Long> refMainRecordIds) {
        if (refMainRecordIds.size() > 0) {
            StringBuilder sql = new StringBuilder();
            sql.append("delete from t_eb_membpermrecorddetail where fid in(").append(SqlBatchUtils.getBatchParamsSql((int)refMainRecordIds.size())).append(')');
            DB.execute((DBRoute)route, (String)sql.toString(), (Object[])refMainRecordIds.toArray());
            HashSet<Long> ids = new HashSet<Long>(refMainRecordIds);
            if (toSaveRecord != null) {
                ids.remove(toSaveRecord.getId());
            }
            if (ids.size() > 0) {
                sql.setLength(0);
                sql.append("delete from t_eb_membpermrecord where fid in(").append(SqlBatchUtils.getBatchParamsSql((int)refMainRecordIds.size())).append(')');
                DB.execute((DBRoute)route, (String)sql.toString(), (Object[])refMainRecordIds.toArray());
            }
        }
    }

    public static void delPermRecordByDims(Long modelId, Set<Long> dimIds, PermGroupEnum permGroup) {
        if (dimIds.size() > 0) {
            Set<String> dimShortNumStrs = DimMembPermUtil.getRefDimShortNums(dimIds, modelId);
            Set<Long> mainIds = MembPermRecordUtil.getMainRecordIdByDims(modelId, dimShortNumStrs, permGroup);
            MembPermRecordUtil.delPermRecord(null, mainIds);
            DimMembPermUtil.delPermCtrlDimGroup(modelId, dimShortNumStrs);
        }
    }

    public static void dealPermRecordAndVerByPropValIds(Long modelId, Long dimensionId, Collection<Long> propValIds) {
        MembPermRecordUtil.delDetailRecordByMembIds(modelId, dimensionId, null, propValIds);
        DimMembPermVerHelper.updateVer4MembChanged(null, (Long)modelId, (Long)dimensionId, (String)"propValDel");
    }

    public static void delDetailRecordByMembIds(Long modelId, Long dimensionId, Collection<Long> memberIds) {
        MembPermRecordUtil.delDetailRecordByMembIds(modelId, dimensionId, null, memberIds);
    }

    public static void delDetailRecordByMembIds(Long modelId, Long dimensionId, Collection<Long> viewIds, Collection<Long> memberIds) {
        if (memberIds == null || memberIds.isEmpty()) {
            return;
        }
        Set<String> refDimShortNums = DimMembPermUtil.getRefDimShortNums(Sets.newHashSet((Object[])new Long[]{dimensionId}), modelId, false);
        if (refDimShortNums.isEmpty()) {
            String delSql = "delete from t_eb_membpermrecorddetail where fmemberid in(" + SqlBatchUtils.getBatchParamsSql((int)1000) + ")";
            if (CollectionUtils.isNotEmpty(viewIds)) {
                delSql = delSql + " and fviewid in (" + viewIds.stream().map(String::valueOf).collect(Collectors.joining(",")) + ")";
            }
            SqlBatchUtils.executeBatch((String)delSql, new ArrayList<Long>(memberIds), (int)1000);
        } else {
            DetailMembPermRecordHandler membPermRecordHandler = new DetailMembPermRecordHandler(memberIds);
            membPermRecordHandler.setViewIds(viewIds);
            MembPermRecordUtil.readDetailPermRecord((IPermRecordHandler)membPermRecordHandler);
            List mainIdSeqVal = (List)membPermRecordHandler.getResult();
            if (mainIdSeqVal != null && mainIdSeqVal.size() > 0) {
                DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)detailRecordDelSql, (List)mainIdSeqVal);
            }
        }
    }

    public static List<DimMembPermRecord> getPermRecordByMemberIds(IModelCacheHelper modelCacheHelper, Long bizModelId, Collection<Long> memberIds) {
        Long modelId = modelCacheHelper.getModelobj().getId();
        DetailMembPermRecordHandler membPermRecordHandler = new DetailMembPermRecordHandler(memberIds);
        MembPermRecordUtil.readDetailPermRecord((IPermRecordHandler)membPermRecordHandler);
        List mainIdSeqVal = (List)membPermRecordHandler.getResult();
        if (mainIdSeqVal != null && mainIdSeqVal.size() > 0) {
            HashMap mainIdRowSeqMap = new HashMap(16);
            mainIdSeqVal.forEach(val -> mainIdRowSeqMap.computeIfAbsent((Long)val[0], key -> new HashSet(16)).add((Integer)val[1]));
            HashSet searchBizModelIds = Sets.newHashSet((Object[])new Long[]{bizModelId});
            MainRecordSqlBuilder sqlBuilder = new MainRecordSqlBuilder();
            sqlBuilder.setIdsFilter(mainIdRowSeqMap.keySet());
            sqlBuilder.setBCRsFilter((Collection)searchBizModelIds);
            Map<Long, DimMembPermRecord> recordMap = MembPermRecordUtil.readMainRecord((AbstructPermRecordSqlBuilder)sqlBuilder, modelId, PermGroupEnum.DATA, searchBizModelIds);
            DetailRecord4SeqHandler record4SeqHandler = new DetailRecord4SeqHandler(recordMap, mainIdRowSeqMap);
            MembPermRecordUtil.readDetailPermRecord((IPermRecordHandler)record4SeqHandler);
            return new ArrayList<DimMembPermRecord>(recordMap.values());
        }
        return new ArrayList<DimMembPermRecord>(1);
    }

    public static Set<Long> getMainRecordIdByDims(Long modelId, Set<String> dimShortNumStrs, PermGroupEnum permGroup) {
        MainRecordSqlBuilder sqlBuilder = new MainRecordSqlBuilder();
        sqlBuilder.addSelFields(new String[]{"fid"});
        sqlBuilder.setModelFilter(modelId);
        sqlBuilder.setDimShortNumsFilter(dimShortNumStrs);
        sqlBuilder.setPermGroupFilter(permGroup);
        return MembPermRecordUtil.getMainIds(sqlBuilder);
    }

    public static void delPermRecordByBcrAndDim(Long modelId, Long bizCtrlRangeId, Set<Long> dimensionIds) {
        Set<Long> mainIds;
        MainRecordSqlBuilder sqlBuilder = new MainRecordSqlBuilder();
        sqlBuilder.addSelFields(new String[]{"fid"});
        sqlBuilder.setBCRFilter(bizCtrlRangeId);
        sqlBuilder.setModelFilter(modelId);
        if (dimensionIds != null) {
            Set<String> refDimShortNums = DimMembPermUtil.getRefDimShortNums(dimensionIds, modelId);
            sqlBuilder.setDimShortNumsFilter(refDimShortNums);
        }
        if ((mainIds = MembPermRecordUtil.getMainIds(sqlBuilder)).size() > 0) {
            MembPermRecordUtil.delPermRecord(null, mainIds);
        }
    }

    public static void updateMainRecordBizModel(List<Object[]> bizModelInfo) {
        if (bizModelInfo.size() > 0) {
            String sql = "update t_eb_membpermrecord set fbizctrlrangeid = ? where fpermgroup = 'D' and fmodelid = ?";
            DB.executeBatch((DBRoute)route, (String)sql, bizModelInfo);
        }
    }

    public static void updateDetailRecord4View(List<Object[]> viewInfo) {
        if (viewInfo.size() > 0) {
            String detailRecordUpdateSql = "update t_eb_membpermrecorddetail set fviewid = ? where fentryid = ?";
            DB.executeBatch((DBRoute)route, (String)detailRecordUpdateSql, viewInfo);
        }
    }

    public static void upDetailRecord4ViewAndMember(List<Object[]> viewMemberInfo) {
        if (viewMemberInfo.size() > 0) {
            String detailRecordUpdateSql = "update t_eb_membpermrecorddetail set fviewid = ?,fmemberid = ? where fentryid = ?";
            DB.executeBatch((DBRoute)route, (String)detailRecordUpdateSql, viewMemberInfo);
        }
    }
}

