/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.rule.ruleFunction;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.FunctionItemEnum;
import kd.epm.eb.common.rule.ruleFunction.FunctionRefMember;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionFactory;
import org.apache.commons.collections4.CollectionUtils;

public class GetNameRuleFunction
extends RuleFunction {
    public GetNameRuleFunction(String functionName) {
        super(functionName);
    }

    public GetNameRuleFunction(String functionKey, String functionInfoStr, String functionName) {
        super(functionKey, functionInfoStr, functionName);
    }

    @Override
    public String genNewFunParseStr() {
        StringBuilder sb = new StringBuilder();
        sb.append('@');
        sb.append(this.functionName);
        sb.append('[').append(this.functionKey).append(']').append('(');
        this.dealGetNameVal(sb);
        sb.append(')');
        return sb.toString();
    }

    private void dealGetNameVal(StringBuilder sb) {
        String dimNumber = (String)this.allVals.get(FunctionItemEnum.DIMENSIONLIST.getKey());
        sb.append(dimNumber);
        sb.append(',');
        if (this.allVals.containsKey("childIsFun")) {
            String funStr = (String)this.allVals.get(FunctionItemEnum.DIMEMBER.getKey());
            RuleFunction childFun = RuleFunctionFactory.fromJsonString((String)funStr);
            sb.append(childFun.genNewFunParseStr());
        } else {
            String memberNumber = (String)this.allVals.get(FunctionItemEnum.DIMEMBER.getKey());
            sb.append('`');
            sb.append(memberNumber);
            sb.append('`');
        }
    }

    @Override
    public FunctionRefMember genRefMember(Map<String, Set<String>> leftMemberScope, IModelCacheHelper modelCache, Map<String, Long> viewMap) {
        FunctionRefMember functionRefMember;
        String dimNumber = (String)this.allVals.get(FunctionItemEnum.DIMENSIONLIST.getKey());
        if (this.allVals.containsKey("childIsFun")) {
            String funStr = (String)this.allVals.get(FunctionItemEnum.DIMEMBER.getKey());
            RuleFunction childFun = RuleFunctionFactory.fromJsonString((String)funStr);
            functionRefMember = childFun.genRefMember(leftMemberScope, modelCache, viewMap);
        } else {
            functionRefMember = new FunctionRefMember();
            functionRefMember.setDimNumber(dimNumber);
            String memberNumber = (String)this.allVals.get(FunctionItemEnum.DIMEMBER.getKey());
            HashSet<String> members = new HashSet<String>(16);
            members.add(memberNumber);
            functionRefMember.setMembers(members);
        }
        return functionRefMember;
    }

    @Override
    public Set<String> analyzeRealMember(IModelCacheHelper modelCache, Map<String, Long> viewMap, String dimNumber, Map<String, Set<String>> currMemberMap, Map<String, String> leftMemberMap, Long currDataSetId, boolean yvRelationHasMem) {
        Set<String> memNumber = currMemberMap.get(dimNumber);
        String funStr = (String)this.allVals.get(FunctionItemEnum.DIMEMBER.getKey());
        if (this.allVals.containsKey("childIsFun")) {
            RuleFunction childFun = RuleFunctionFactory.fromJsonString((String)funStr);
            memNumber = childFun.analyzeRealMember(modelCache, viewMap, dimNumber, currMemberMap, leftMemberMap, currDataSetId, yvRelationHasMem);
        } else {
            memNumber.clear();
            memNumber.add(funStr);
        }
        LinkedHashSet members = Sets.newLinkedHashSet();
        if (CollectionUtils.isNotEmpty(memNumber)) {
            String _memberNum = memNumber.iterator().next();
            Member member = modelCache.getMember(dimNumber, viewMap.getOrDefault(dimNumber, 0L), _memberNum);
            if (member != null) {
                members.add(member.getNumber());
            }
        }
        return members;
    }

    @Override
    public List<MemberQuoteDao> genFunctionRefQuote(Long modelId, Long bizctrlrangeidLong, Long ruleId) {
        if (this.allVals.containsKey("childIsFun")) {
            return null;
        }
        String dimNumber = (String)this.allVals.get(FunctionItemEnum.DIMENSIONLIST.getKey());
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension dimension = modelCache.getDimension(dimNumber);
        String memNumber = (String)this.allVals.get(FunctionItemEnum.DIMEMBER.getKey());
        Long viewId = this.getDimensionViewId(this.allVals, dimNumber, Collections.emptyMap());
        Member member = dimension.getMember(viewId, memNumber);
        return Lists.newArrayList((Object[])new MemberQuoteDao[]{new MemberQuoteDao(modelId, bizctrlrangeidLong, dimension.getId(), member.getId(), MemberQuoteResourceEnum.BizRule, ruleId)});
    }
}

