/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.rule.ruleFunction;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.formula.DimMemberPojo;
import kd.epm.eb.common.dao.formula.FormulaMemberPojo;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.FunctionItemEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.MemberFunctionParamEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.RuleFunctionEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.rule.ruleFunction.FunctionRefMember;
import kd.epm.eb.common.rule.ruleFunction.MemberRuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionFactory;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import org.apache.commons.collections4.CollectionUtils;

public class MemberRuleFunction
extends RuleFunction {
    public MemberRuleFunction(String functionName) {
        super(functionName);
    }

    public MemberRuleFunction(String functionKey, String functionInfoStr, String functionName) {
        super(functionKey, functionInfoStr, functionName);
    }

    @Override
    public String genNewFunParseStr() {
        StringBuilder sb = new StringBuilder();
        sb.append('@');
        sb.append(this.functionName);
        sb.append('[').append(this.functionKey).append(']').append('(');
        this.dealMemberVal(sb);
        sb.append(')');
        return sb.toString();
    }

    private void dealMemberVal(StringBuilder sb) {
        String dimNumber = (String)this.allVals.get("dimensionlist");
        sb.append(dimNumber);
        sb.append(',');
        block5: for (MemberFunctionParamEnum memberFunctionParamEnum : MemberFunctionParamEnum.values()) {
            String paramStr = (String)this.allVals.get(memberFunctionParamEnum.getMemberKey());
            if (paramStr == null) continue;
            switch (1.$SwitchMap$kd$epm$eb$common$enums$ruleFunctionEnums$MemberFunctionParamEnum[memberFunctionParamEnum.ordinal()]) {
                case 1: {
                    FormulaMemberPojo dimGroupMemberPojo = (FormulaMemberPojo)JsonUtils.readValue((String)paramStr, FormulaMemberPojo.class);
                    sb.append("MBR:[");
                    sb.append(dimGroupMemberPojo.getMemberKey());
                    sb.append("]");
                    continue block5;
                }
                case 2: {
                    RuleFunction childFun = RuleFunctionFactory.fromJsonString((String)paramStr);
                    sb.append(childFun.genNewFunParseStr());
                    continue block5;
                }
                case 3: {
                    sb.append("'").append(paramStr).append("'");
                    continue block5;
                }
            }
        }
    }

    @Override
    public FunctionRefMember genRefMember(Map<String, Set<String>> leftMemberScope, IModelCacheHelper modelCache, Map<String, Long> viewMap) {
        FunctionRefMember functionRefMember = super.genRefMember(leftMemberScope, modelCache, viewMap);
        String dimNumber = (String)this.allVals.get(FunctionItemEnum.DIMENSIONLIST.getKey());
        functionRefMember.setDimNumber(dimNumber);
        functionRefMember.setSkip(true);
        HashSet<String> members = new HashSet<String>(16);
        HashSet<String> memberNumSet = new HashSet<String>(16);
        for (MemberFunctionParamEnum memberFunctionParamEnum : MemberFunctionParamEnum.values()) {
            String funStr = (String)this.allVals.get(memberFunctionParamEnum.getMemberKey());
            if (StringUtils.isEmpty(funStr)) continue;
            if (memberFunctionParamEnum.getMemberKey().equals(MemberFunctionParamEnum.BTN_FIXSTRING.getMemberKey())) {
                memberNumSet.add(funStr);
                continue;
            }
            if (memberFunctionParamEnum.getMemberKey().equals(MemberFunctionParamEnum.BTN_DIMGROUP.getMemberKey())) {
                functionRefMember.setAllMember(true);
                continue;
            }
            if (!memberFunctionParamEnum.getMemberKey().equals(MemberFunctionParamEnum.BTN_STRINGFUN.getMemberKey()) || !this.allVals.containsKey("childIsFun")) continue;
            RuleFunction childFun = RuleFunctionFactory.fromJsonString((String)funStr);
            FunctionRefMember childFuncRefMem = childFun.genRefMember(leftMemberScope, modelCache, viewMap);
            functionRefMember.setOtherFuncRefMem(childFuncRefMem);
            String childDimNum = childFuncRefMem.getDimNumber();
            Set<String> childMembers = childFuncRefMem.getMembers();
            if (CollectionUtils.isNotEmpty(childMembers)) {
                memberNumSet.addAll(this.getChildFunMemNumSet(modelCache, viewMap, childFun, childDimNum, childMembers));
                continue;
            }
            HashSet<String> collect = new HashSet<String>(16);
            Long viewId = viewMap.getOrDefault(childDimNum, 0L);
            List _childMembers = modelCache.getMembers(viewId, childDimNum);
            collect.addAll(_childMembers.stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
            memberNumSet.addAll(this.getChildFunMemNumSet(modelCache, viewMap, childFun, childDimNum, collect));
        }
        Long viewId = viewMap.getOrDefault(dimNumber, 0L);
        for (String memberNum : memberNumSet) {
            Member childMember = modelCache.getMember(dimNumber, viewId, memberNum);
            if (childMember == null) continue;
            members.add(childMember.getNumber());
        }
        functionRefMember.setMembers(members);
        return functionRefMember;
    }

    private Set<String> getChildFunMemNumSet(IModelCacheHelper modelCache, Map<String, Long> viewMap, RuleFunction childFun, String childDimNum, Set<String> childMembers) {
        HashSet<String> childMemNumSet = new HashSet<String>(16);
        for (String childMemberNum : childMembers) {
            Member childMember = modelCache.getMember(childDimNum, viewMap.getOrDefault(childDimNum, 0L), childMemberNum);
            if (childMember == null) continue;
            if (childFun.getFunctionName().equals(RuleFunctionEnum.GetName.getName())) {
                childMemNumSet.add(childMember.getName());
                continue;
            }
            if (!childFun.getFunctionName().equals(RuleFunctionEnum.GetNumber.getName())) continue;
            childMemNumSet.add(childMember.getShowNumber());
        }
        return childMemNumSet;
    }

    private Long getRefMemberDatasetId(IModelCacheHelper modelCache, FormulaMemberPojo formulaMemberPojo, Map<String, Set<String>> dimMemberMap, Long datasetId) {
        for (DimMemberPojo refDimMember : formulaMemberPojo.getRefDimMembers()) {
            Member member;
            String refDimNum = refDimMember.getDimNumber();
            String refMemNumber = refDimMember.getNumber();
            if (refDimNum.equals(SysDimensionEnum.Account.getNumber()) && (member = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, refMemNumber)) != null) {
                datasetId = member.getDatasetId();
            }
            dimMemberMap.put(refDimNum, Sets.newHashSet((Object[])new String[]{refMemNumber}));
        }
        return datasetId;
    }

    private String getValueStrByDateType(String valueStr) {
        String rgex;
        Pattern pattern;
        Matcher matcher;
        if (valueStr.startsWith("/OADate") && (matcher = (pattern = Pattern.compile(rgex = "(?<=\\/OADate\\().*?(?=\\)/)")).matcher(valueStr)).find()) {
            String time = matcher.group();
            BigDecimal _time = new BigDecimal(time);
            _time = _time.multiply(new BigDecimal(86400000)).add(new BigDecimal("-2209190400000"));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            valueStr = sdf.format(new Date(_time.longValue()));
        }
        return valueStr;
    }

    @Override
    public Set<String> analyzeRealMember(IModelCacheHelper modelCache, Map<String, Long> viewMap, String dimNumber, Map<String, Set<String>> currMemberMap, Map<String, String> leftMemberMap, Long currDataSetId, boolean yvRelationHasMem) {
        Set<String> memNumber = currMemberMap.get(dimNumber);
        String dimNum = (String)this.allVals.get(FunctionItemEnum.DIMENSIONLIST.getKey());
        if (!dimNumber.equals(dimNum)) {
            return memNumber;
        }
        HashSet<String> refMembers = new HashSet<String>(16);
        String memberNum = "";
        for (MemberFunctionParamEnum memberFunctionParamEnum : MemberFunctionParamEnum.values()) {
            Set<String> childFunMemNumSet;
            Map<String, Object> allValues;
            String childDimNum;
            RuleFunction childFun;
            Set<String> childMemberNumSet;
            String funStr = (String)this.allVals.get(memberFunctionParamEnum.getMemberKey());
            if (StringUtils.isEmpty(funStr)) continue;
            if (memberFunctionParamEnum.getMemberKey().equals(MemberFunctionParamEnum.BTN_FIXSTRING.getMemberKey())) {
                memberNum = funStr;
                continue;
            }
            if (memberFunctionParamEnum.getMemberKey().equals(MemberFunctionParamEnum.BTN_DIMGROUP.getMemberKey())) {
                FormulaMemberPojo formulaMemberPojo = (FormulaMemberPojo)JsonUtils.readValue((String)funStr, FormulaMemberPojo.class);
                HashMap<String, Set<String>> dimMemberMap = new HashMap<String, Set<String>>(16);
                leftMemberMap.forEach((dim, mem) -> {
                    Set cfr_ignored_0 = dimMemberMap.put((String)dim, Sets.newHashSet((Object[])new String[]{mem}));
                });
                Long datasetId = currDataSetId;
                datasetId = this.getRefMemberDatasetId(modelCache, formulaMemberPojo, dimMemberMap, datasetId);
                List bgCells = RuleFunctionUtils.queryList((IModelCacheHelper)modelCache, (Long)datasetId, dimMemberMap);
                if (!CollectionUtils.isNotEmpty((Collection)bgCells)) continue;
                Object value = ((BGCell)bgCells.get(0)).getValue();
                memberNum = this.getValueStrByDateType(value.toString());
                continue;
            }
            if (!memberFunctionParamEnum.getMemberKey().equals(MemberFunctionParamEnum.BTN_STRINGFUN.getMemberKey()) || !this.allVals.containsKey("childIsFun") || !CollectionUtils.isNotEmpty(childMemberNumSet = (childFun = RuleFunctionFactory.fromJsonString((String)funStr)).analyzeRealMember(modelCache, viewMap, childDimNum = (String)(allValues = childFun.getAllValues()).get(FunctionItemEnum.DIMENSIONLIST.getKey()), currMemberMap, leftMemberMap, currDataSetId, yvRelationHasMem)) || !CollectionUtils.isNotEmpty(childFunMemNumSet = this.getChildFunMemNumSet(modelCache, viewMap, childFun, childDimNum, childMemberNumSet))) continue;
            memberNum = childFunMemNumSet.iterator().next();
        }
        Member refMember = modelCache.getMember(dimNumber, viewMap.getOrDefault(dimNumber, 0L), memberNum);
        if (refMember != null) {
            refMembers.add(refMember.getNumber());
        }
        return refMembers;
    }

    @Override
    public List<MemberQuoteDao> genFunctionRefQuote(Long modelId, Long bizctrlrangeidLong, Long ruleId) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        ArrayList memberQuoteDaoList = Lists.newArrayListWithExpectedSize((int)16);
        for (MemberFunctionParamEnum memberFunctionParamEnum : MemberFunctionParamEnum.values()) {
            String funStr = (String)this.allVals.get(memberFunctionParamEnum.getMemberKey());
            if (funStr == null || !memberFunctionParamEnum.getMemberKey().equals(MemberFunctionParamEnum.BTN_DIMGROUP.getMemberKey())) continue;
            FormulaMemberPojo accountMemberPojo = (FormulaMemberPojo)JsonUtils.readValue((String)funStr, FormulaMemberPojo.class);
            List refDimMembers = accountMemberPojo.getRefDimMembers();
            for (DimMemberPojo refDimMember : refDimMembers) {
                Dimension dimension = modelCache.getDimension(refDimMember.getDimNumber());
                MemberQuoteDao memberQuoteDao = new MemberQuoteDao(modelId, bizctrlrangeidLong, dimension.getId(), refDimMember.getId(), MemberQuoteResourceEnum.BizRule, ruleId);
                RuleFunctionUtils.putMemberQuoteViewMap((Long)refDimMember.getId(), (Long)refDimMember.getViewId(), (MemberQuoteDao)memberQuoteDao);
                memberQuoteDaoList.add(memberQuoteDao);
            }
        }
        return memberQuoteDaoList;
    }
}

