/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.rule.ruleFunction;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.rule.ruleFunction.FunctionRefMember;
import kd.epm.eb.common.rule.ruleFunction.IRuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionFactory;
import kd.epm.eb.common.utils.IDUtils;

public class RuleFunction
implements IRuleFunction {
    protected long bizRuleId;
    protected String functionKey;
    protected String functionShowStr;
    protected String functionName;
    private transient Map<String, Set<String>> refMembs = null;
    protected Map<String, Object> allVals;

    public RuleFunction() {
    }

    public RuleFunction(String functionName) {
        this.functionName = functionName;
    }

    public RuleFunction(String functionKey, String functionInfoStr, String functionName) {
        this.functionKey = functionKey;
        this.functionName = functionName;
        this.allVals = functionInfoStr == null ? new HashMap<String, Object>(9) : (Map)SerializationUtils.fromJsonString((String)functionInfoStr, Map.class);
    }

    @Override
    public String getFunctionKey() {
        return this.functionKey;
    }

    @Override
    public void setFunctionKey(String key) {
        this.functionKey = key;
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    @Override
    public long getBizRuleId() {
        return this.bizRuleId;
    }

    @Override
    public void setBizRuleId(long bizRuleId) {
        this.bizRuleId = bizRuleId;
    }

    @Override
    public String getFunctionShowStr() {
        StringBuilder sb = new StringBuilder();
        if (this.functionShowStr != null && !this.functionShowStr.startsWith("@")) {
            sb.append('@');
        }
        sb.append(this.functionShowStr);
        return sb.toString();
    }

    @Override
    public void setFunctionShowStr(String showStr) {
        this.functionShowStr = showStr;
    }

    @Override
    public String getFunctionInfoStr() {
        return SerializationUtils.toJsonString(this.allVals);
    }

    @Override
    public String genNewFunParseStr() {
        throw new IllegalStateException("Unexpected value: " + this.functionName);
    }

    public FunctionRefMember genRefMemberFirst(Map<String, Set<String>> leftMemberScope, IModelCacheHelper modelCache, Map<String, Long> viewMap) {
        FunctionRefMember functionRefMember = this.genRefMember(leftMemberScope, modelCache, viewMap);
        if (functionRefMember.isAllMember()) {
            HashSet<String> collect = new HashSet<String>(16);
            String dimNumber = functionRefMember.getDimNumber();
            Long viewId = viewMap.getOrDefault(dimNumber, 0L);
            List members = modelCache.getMembers(viewId, dimNumber);
            collect.addAll(members.stream().map(BaseCache::getNumber).collect(Collectors.toSet()));
            functionRefMember.setMembers(collect);
        }
        return functionRefMember;
    }

    @Override
    public FunctionRefMember genRefMember(Map<String, Set<String>> leftMemberScope, IModelCacheHelper modelCache, Map<String, Long> viewMap) {
        FunctionRefMember functionRefMember = new FunctionRefMember();
        if ("IsChild".equals(this.functionName)) {
            String dimNumber = (String)this.allVals.get("dimensionlist");
            String memNumber = (String)this.allVals.get("dimmember");
            functionRefMember.setDimNumber(dimNumber);
            functionRefMember.setMembers(Sets.newHashSet((Object[])new String[]{memNumber}));
        }
        return functionRefMember;
    }

    @Override
    public Set<String> analyzeRealMember(IModelCacheHelper modelCache, Map<String, Long> viewMap, String dimNumber, Map<String, Set<String>> currMemberMap, Map<String, String> leftMemberMap, Long currDataSetId, boolean yvRelationHasMem) {
        RuleFunction realFunction = RuleFunctionFactory.getRealFunction((RuleFunction)this);
        return realFunction.analyzeRealMember(modelCache, viewMap, dimNumber, currMemberMap, leftMemberMap, currDataSetId, yvRelationHasMem);
    }

    @Override
    public DynamicObject toDynamicObj() {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"eb_rulefunctionsentity");
        obj.set("id", (Object)DB.genGlobalLongId());
        obj.set("functiontype", (Object)this.getFunctionName());
        obj.set("functionkey", (Object)this.getFunctionKey());
        obj.set("functioninfostr", (Object)this.getFunctionInfoStr());
        obj.set("ruleid", (Object)this.getBizRuleId());
        obj.set("functionshowstr", (Object)this.functionShowStr);
        return obj;
    }

    @Override
    public Map<String, Object> getAllValues() {
        return this.allVals;
    }

    public void setAllVals(Map<String, Object> allVals) {
        this.allVals = allVals;
    }

    @Override
    public <T> T getValue(String key) {
        return (T)this.allVals.get(key);
    }

    @Override
    public void setValue(String key, Object value) {
        this.allVals.put(key, value);
    }

    public Map<String, Set<String>> getRefMembs() {
        return this.refMembs;
    }

    public void setRefMembs(Map<String, Set<String>> refMembs) {
        this.refMembs = refMembs;
    }

    public Map<String, Object> getAllVals() {
        return this.allVals;
    }

    @Override
    public List<MemberQuoteDao> genFunctionRefQuote(Long modelId, Long bizctrlrangeidLong, Long ruleId) {
        return null;
    }

    public CustomPropertyValue handleAttributeValueGenRefMember(Map<String, Set<String>> leftMemberScope, IModelCacheHelper modelCache, Map<String, Long> viewMap) {
        return null;
    }

    public CustomPropertyValue handleAttributeValueByAnalyzeRealMember(IModelCacheHelper modelCache, Map<String, Long> viewMap, String dimNumber, Set<String> refMembers, Map<String, String> leftMemberMap, Long currDataSetId, Map<String, Set<String>> currMemberMap, boolean yvRelationHasMem) {
        return null;
    }

    public CustomPropertyValue handleAttributeValueGenFunctionRefQuote(Long modelId, Long bizctrlrangeidLong, Long ruleId) {
        return null;
    }

    @Override
    public Long getDimensionViewId(Map<String, Object> allVals, String dimNumber, Map<String, Long> viewMap) {
        if (allVals == null) {
            return viewMap.getOrDefault(dimNumber, 0L);
        }
        String viewIdStr = (String)allVals.get("allvals_view_id");
        Long viewId = IDUtils.toLong((Object)viewIdStr);
        if (IDUtils.isEmptyLong((Long)viewId).booleanValue()) {
            viewId = viewMap.getOrDefault(dimNumber, 0L);
        }
        return viewId;
    }
}

