/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.shrek.service;

import com.google.common.collect.Lists;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.ComputingCommandInfo;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.olap.dataSources.DistinctSelectCommandInfo;
import kd.bos.olap.dataSources.FelLambdaExpressionItem;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.OlapDataReader;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.olap.metadata.IMetadataBuilder;
import kd.bos.olap.metadata.StringMetadataBuilder;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.elasticsearch.OlapDataAuditService;
import kd.epm.eb.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.Pair;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.shrek.controller.IShrekSave;
import kd.epm.eb.common.shrek.controller.ShrekOlapReader;
import kd.epm.eb.common.shrek.controller.ShrekOlapSave;
import kd.epm.eb.common.shrek.controller.ShrekOlapServiceHelper;
import kd.epm.eb.common.shrek.service.ShrekCubeServiceHelper;
import kd.epm.eb.common.shrek.service.ShrekExecuteServiceHelper;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.shrek.util.ShrekOlapUtils;
import kd.epm.eb.common.utils.LogStats;
import org.apache.commons.collections4.MapUtils;
import org.jetbrains.annotations.NotNull;

public class ShrekExecuteServiceHelper {
    private static final Log log = LogFactory.getLog(ShrekExecuteServiceHelper.class);

    public static ShrekOlapReader queryReader(@NotNull Model model, @NotNull SelectCommandInfo query, LogStats stats) {
        return ShrekExecuteServiceHelper.queryReader(model, null, query, stats);
    }

    public static ShrekOlapReader queryReader(@NotNull Model model, Dataset dataset, @NotNull SelectCommandInfo query, LogStats stats, Option option) {
        if (stats != null) {
            stats.addInfo("begin-queryReader.");
        }
        log.info(query.toString());
        try {
            OlapConnection conn = ShrekOlapServiceHelper.getConnection((Model)model, (Dataset)dataset);
            conn.Open();
            query.setExcludeNull(option.isExcludeNull());
            ShrekOlapReader shrekOlapReader = new ShrekOlapReader(conn, new OlapCommand(conn, (CommandInfo)query).executeReader((IMetadataBuilder)StringMetadataBuilder.INSTANCE));
            return shrekOlapReader;
        }
        catch (Throwable ex) {
            log.error("shrek-queryReader-error:", ex);
            if (ex instanceof ConnectException) {
                ControlException.connectOlapFail();
                throw new KDBizException(new ErrorCode("EB040551", ex.getMessage()), new Object[0]);
            }
            throw new KDBizException(new ErrorCode("EB040551", ex.getMessage()), new Object[0]);
        }
        finally {
            if (stats != null) {
                stats.addInfo("end-queryReader.");
            }
        }
    }

    public static ShrekOlapReader queryReader(@NotNull Model model, Dataset dataset, @NotNull SelectCommandInfo query, LogStats stats) {
        return ShrekExecuteServiceHelper.queryReader(model, dataset, query, stats, new Option());
    }

    public static List<MembersKey> queryReader(@NotNull Model model, Dataset dataset, @NotNull SelectCommandInfo query) {
        LogStats stats = new LogStats("budget-shrek-log : ");
        stats.addInfo("begin-queryData.");
        LinkedList<MembersKey> cells = new LinkedList<MembersKey>();
        try (ShrekOlapReader soReader = ShrekExecuteServiceHelper.queryReader(model, dataset, query, stats);){
            while (soReader.hasNext()) {
                Object[] value = soReader.next();
                if (value == null || value[0] == null) continue;
                cells.add(new MembersKey(value));
            }
        }
        catch (Throwable ex) {
            stats.addInfo("error-queryData. " + ex.getMessage());
            throw new KDBizException(new ErrorCode("EB040551", ex.getMessage()), new Object[0]);
        }
        finally {
            stats.addInfo("end-queryData. size = " + cells.size());
            log.info(stats.toString());
        }
        return cells;
    }

    public static MembersKey queryOne(@NotNull Model model, Dataset dataset, @NotNull SelectCommandInfo query) {
        LogStats stats = new LogStats("budget-shrek-log : ");
        stats.addInfo("begin queryData.");
        MembersKey cell = null;
        try (ShrekOlapReader soReader = ShrekExecuteServiceHelper.queryReader(model, dataset, query, stats);){
            while (soReader.hasNext() && cell == null) {
                Object[] value = soReader.next();
                if (value == null || value[0] == null) continue;
                cell = new MembersKey(value);
            }
        }
        catch (Throwable ex) {
            stats.addInfo("error queryData. " + ex.getMessage());
            throw new KDBizException(new ErrorCode("EB040551", ex.getMessage()), new Object[0]);
        }
        finally {
            log.info(stats.toString());
        }
        return cell;
    }

    public static Map<String, Object> queryDataToMap(@NotNull Model model, Dataset dataset, @NotNull SelectCommandInfo query) {
        LinkedHashMap<String, Object> cellMaps = new LinkedHashMap<String, Object>();
        LogStats stats = new LogStats("budget-shrek-log : ");
        stats.addInfo("begin queryDataToMap.");
        StringBuilder key = new StringBuilder();
        try (ShrekOlapReader soReader = ShrekExecuteServiceHelper.queryReader(model, dataset, query, stats);){
            while (soReader.hasNext()) {
                Object[] value = soReader.next();
                if (value == null || value.length == 0 || value[0] == null) continue;
                for (int i = 1; i < value.length; ++i) {
                    key.append(value[i].toString()).append("!!");
                }
                key.setLength(key.length() - 2);
                cellMaps.put(key.toString(), value[0]);
                key.delete(0, key.length());
            }
        }
        catch (Throwable ex) {
            stats.addInfo("error queryDataToMap. " + ex.getMessage());
            throw new KDBizException(new ErrorCode("EB040551", ex.getMessage()), new Object[0]);
        }
        finally {
            stats.addInfo("end queryDataToMap. size = " + cellMaps.size());
            log.info(stats.toString());
        }
        return cellMaps;
    }

    public static IShrekSave saveData(Model model, Dataset dataset, String[] dimensions, @NotNull Map<String, String> shrekProperties) {
        return ShrekExecuteServiceHelper.saveData(model, dataset, dimensions, false, shrekProperties);
    }

    public static IShrekSave saveDataByIncrement(Model model, Dataset dataset, String[] dimensions, @NotNull Map<String, String> shrekProperties) {
        return ShrekExecuteServiceHelper.saveData(model, dataset, dimensions, true, shrekProperties);
    }

    private static IShrekSave saveData(Model model, Dataset dataset, String[] dimensions, boolean isIncrement, @NotNull Map<String, String> shrekProperties) {
        OlapConnection conn = ShrekCubeServiceHelper.getConnection((Model)model, (Dataset)dataset);
        if (conn == null) {
            log.error("save-data-error.dataSourceId = " + model.getDataSourceId());
            throw new KDBizException("conn is null");
        }
        conn.Open();
        SaveCommandInfo saveCommand = new SaveCommandInfo();
        saveCommand.addDimensions(dimensions);
        saveCommand.setMeasures(new String[]{"FMONEY"});
        saveCommand.setIncrement(isIncrement);
        if (shrekProperties.containsKey("IGNORE_DATA_LOCK")) {
            try {
                saveCommand.setIgnoreDataLock(true);
            }
            catch (Exception e) {
                throw new KDBizException("need upgrade olap client above 2.8.17, and olap server above 9.16");
            }
        }
        ShrekIdCodeUtils.setTraceInfo((CommandInfo)saveCommand, shrekProperties);
        String cubeNumber = model.isModelByEB() ? ShrekOlapUtils.getCubeNumber((Model)model) : ShrekOlapUtils.getCubeNumber((Dataset)dataset);
        OlapDataAuditService.getInstance().enhanceCommandWithAudit(model.getNumber(), cubeNumber, (CommandInfo)saveCommand);
        return new ShrekOlapSave(dimensions, conn, new OlapCommand(conn, (CommandInfo)saveCommand).CreateWriter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static boolean deleteData(Model model, Dataset dataSet, Map<String, Set<String>> deleteRange, String dimNumber, String memNumber) {
        String left = dimNumber + "@" + memNumber;
        FelLambdaExpressionItem exp = new FelLambdaExpressionItem();
        exp.setExpressLeft(left);
        exp.setExpression("null");
        ComputingCommandInfo command = new ComputingCommandInfo();
        ArrayList filters = new ArrayList(16);
        if (MapUtils.isNotEmpty(deleteRange)) {
            deleteRange.forEach((k, v) -> {
                if (!dimNumber.equals(k)) {
                    filters.add(new DimensionFilterItem(k, new ArrayList(v)));
                }
            });
        }
        command.setFilter(filters);
        command.getExpressionItems().add(exp);
        command.setMainMeaName("FMONEY");
        command.setMainDimName(SysDimensionEnum.Metric.getNumber());
        ShrekIdCodeUtils.setTraceInfo((CommandInfo)command, (Map)ShrekIdCodeUtils.getDefaultIdCodes(null));
        OlapDataAuditService.getInstance().enhanceCommandWithAudit(model.getNumber(), ShrekOlapUtils.getCubeNumber((Dataset)dataSet), (CommandInfo)command);
        OlapConnection conn = null;
        try {
            conn = ShrekOlapServiceHelper.getConnection((Model)model, (Dataset)dataSet);
            OlapCommand cmd = new OlapCommand(conn, (CommandInfo)command);
            cmd.executeCompute();
        }
        finally {
            if (conn != null) {
                conn.Close();
            }
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    public static Map<String, Set<String>> analyzeRange(Model model, Dataset dataSet, Set<String> skipDim, Map<String, Set<String>> anaRanges) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> checkOnce(OlapConnection conn, String checkDimNumber, List<DimensionFilterItem> filter) {
        DistinctSelectCommandInfo commandInfo = new DistinctSelectCommandInfo();
        commandInfo.addDims(new String[]{checkDimNumber});
        commandInfo.setFilter(filter);
        commandInfo.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        commandInfo.setExcludeNull(true);
        ArrayList<String> returnLists = new ArrayList<String>(16);
        try (OlapDataReader reader = null;){
            reader = new OlapCommand(conn, (CommandInfo)commandInfo).executeReader((IMetadataBuilder)StringMetadataBuilder.INSTANCE);
            while (reader.next()) {
                Object[] values = new Object[reader.getFieldCount()];
                reader.getValues(values);
                returnLists.add((String)values[0]);
            }
        }
        return returnLists;
    }

    private static /* synthetic */ void lambda$analyzeRange$3(List filter, Pair v) {
        String dimNumber = (String)v.getKey();
        Object[] range = (String[])v.getValue();
        filter.add(new DimensionFilterItem(dimNumber, (List)Lists.newArrayList((Object[])range)));
    }

    private static /* synthetic */ int lambda$analyzeRange$2(Pair o1, Pair o2) {
        return Integer.compare(((String[])o2.getValue()).length, ((String[])o1.getValue()).length);
    }

    private static /* synthetic */ void lambda$analyzeRange$1(List ranges, String dimNumber, Set leftR) {
        ranges.add(new Pair((Object)dimNumber, (Object)leftR.toArray(new String[0])));
    }
}

