/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class CollectionUtils {
    public static boolean isEmpty(Collection<?> colls) {
        return colls == null || colls.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> colls) {
        return colls == null || colls.isEmpty();
    }

    public static boolean isEmpty(Object ... colls) {
        if (colls == null || colls.length == 0) {
            return true;
        }
        for (Object _str : colls) {
            if (_str != null) continue;
            return true;
        }
        return false;
    }

    public static boolean isNotEmpty(Collection<?> colls) {
        return !CollectionUtils.isEmpty(colls);
    }

    public static boolean isNotEmpty(Map<?, ?> colls) {
        return !CollectionUtils.isEmpty(colls);
    }

    public static <T> List<T> asList(T ... objects) {
        if (objects == null || objects.length == 0) {
            return Collections.emptyList();
        }
        return Stream.of(objects).collect(Collectors.toList());
    }

    public static <T> List<T> asList(Collection<T> objects) {
        if (objects == null || objects.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<T>(objects);
    }

    public static <T> List<T> asList(Collection<T>[] objects) {
        if (objects == null || objects.length == 0) {
            return Collections.emptyList();
        }
        LinkedList<T> tmpList = new LinkedList<T>();
        for (Collection<T> entry : objects) {
            tmpList.addAll(entry);
        }
        return tmpList;
    }

    public static <T> List<T> asListByCollection(Collection<List<T>> objects) {
        if (objects == null || objects.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList _tmpLists = Lists.newLinkedList();
        objects.forEach(_tmpLists::addAll);
        return _tmpLists;
    }

    public static <T> Set<T> asSet(T ... objects) {
        if (objects == null || objects.length == 0) {
            return Collections.emptySet();
        }
        return Stream.of(objects).collect(Collectors.toSet());
    }

    public static <K, V> Map<K, V> asMap(K key, V value) {
        HashMap map = Maps.newHashMap();
        map.put(key, value);
        return map;
    }

    public static <K, V> Map<K, V> asMap(K[] keys, V[] values) {
        if (keys == null || keys.length == 0) {
            return Maps.newHashMap();
        }
        HashMap<K, Object> map = new HashMap<K, Object>(keys.length);
        if (values == null) {
            for (K k : keys) {
                map.put(k, null);
            }
        } else {
            int valueSize = values.length;
            int size = keys.length;
            for (int i = 0; i < size; ++i) {
                map.put(keys[i], i < valueSize ? (Object)values[i] : null);
            }
        }
        return map;
    }

    public static boolean includeByStarts(String str, Collection<String> collection) {
        if (CollectionUtils.isEmpty(str) || CollectionUtils.isEmpty(collection)) {
            return false;
        }
        for (String _str : collection) {
            if (!str.startsWith(_str)) continue;
            return true;
        }
        return false;
    }

    public static boolean include(Map<?, ?> includeMap, Map<?, ?> distMap) {
        if (includeMap == null || distMap == null) {
            return false;
        }
        boolean isInclude = true;
        for (Map.Entry<?, ?> entry : includeMap.entrySet()) {
            Object object = distMap.get(entry.getKey());
            if (object != entry.getValue()) {
                isInclude = entry.getValue() instanceof Collection ? CollectionUtils.include((Collection)entry.getValue(), object) : false;
            }
            if (isInclude) continue;
            break;
        }
        return isInclude;
    }

    public static boolean includeByIgn(Map<?, ?> includeMap, Map<?, ?> distMap) {
        if (includeMap == null || distMap == null) {
            return false;
        }
        boolean isInclude = true;
        for (Map.Entry<?, ?> entry : includeMap.entrySet()) {
            if (!distMap.containsKey(entry.getKey())) continue;
            Object object = distMap.get(entry.getKey());
            if (object != entry.getValue()) {
                isInclude = entry.getValue() == null || object == null ? false : (entry.getValue() instanceof Collection ? CollectionUtils.include((Collection)entry.getValue(), object) : (entry.getValue() instanceof Comparable && object instanceof Comparable ? ((Comparable)entry.getValue()).compareTo(object) == 0 : entry.getValue().equals(object)));
            }
            if (isInclude) continue;
            break;
        }
        return isInclude;
    }

    public static boolean include(Collection<?> includes, Object distObject) {
        return includes.contains(distObject);
    }

    public static boolean include(Collection<?> includes, Collection<?> destObjects) {
        if (includes == null || destObjects == null) {
            return false;
        }
        boolean include = false;
        Iterator<?> iterator = destObjects.iterator();
        while (!include && iterator.hasNext()) {
            include = includes.contains(iterator.next());
        }
        return include;
    }

    public static <K, V> Map<K, V> merge(Map<K, V> dest, Map<K, V> src) {
        if (dest == null || src == null || src.isEmpty()) {
            return dest;
        }
        for (Map.Entry<K, V> entry : src.entrySet()) {
            V value = dest.get(entry.getKey());
            if (value == null) {
                dest.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!(value instanceof Collection) || !(entry.getValue() instanceof Collection)) continue;
            ((Collection)value).addAll((Collection)entry.getValue());
        }
        return dest;
    }

    public static <K, V> Map<K, V> retainAll(Map<K, V> src, Collection<K> dest) {
        if (src == null || src.isEmpty() || dest == null || dest.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap _filter = Maps.newHashMapWithExpectedSize((int)src.size());
        for (Map.Entry<K, V> entry : src.entrySet()) {
            if (dest.contains(entry.getKey())) continue;
            _filter.put(entry.getKey(), entry.getValue());
        }
        return _filter;
    }

    public static boolean equals(Collection value1, Collection value2) {
        if (value1 == value2) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        return value1.size() == value2.size() && value1.containsAll(value2);
    }

    public static boolean equals(Map<?, ?> value1, Map<?, ?> value2) {
        if (value1 != null && value2 != null) {
            return value1.equals(value2);
        }
        return CollectionUtils.isEmpty(value1) && CollectionUtils.isEmpty(value2);
    }

    public static boolean notEquals(Map<?, ?> value1, Map<?, ?> value2) {
        return !CollectionUtils.equals(value1, value2);
    }

    public static int[] getBase(List<Integer> colls) {
        if (colls == null || colls.isEmpty()) {
            return new int[0];
        }
        int[] _rows = new int[colls.size()];
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            _rows[i] = colls.get(i);
        }
        return _rows;
    }

    public static <T> boolean checkIntersection(@NotNull Set<T> smallerSet, @NotNull Set<T> largerSet) {
        if (smallerSet.size() > largerSet.size()) {
            Set<T> temp = smallerSet;
            smallerSet = largerSet;
            largerSet = temp;
        }
        for (T element : smallerSet) {
            if (!largerSet.contains(element)) continue;
            return true;
        }
        return false;
    }

    public static <T> T getIntersection(@NotNull Set<T> smallerSet, @NotNull Set<T> largerSet) {
        if (smallerSet.size() > largerSet.size()) {
            Set<T> temp = smallerSet;
            smallerSet = largerSet;
            largerSet = temp;
        }
        for (T element : smallerSet) {
            if (!largerSet.contains(element)) continue;
            return element;
        }
        return null;
    }

    public static List<int[]> mergeContinuousRegions(Map<Integer, Set<Integer>> dataMap, boolean dataIsRow, boolean needMergeCol) {
        ArrayList<int[]> result = new ArrayList<int[]>();
        ArrayList<int[]> cellResult = new ArrayList<int[]>();
        ArrayList<Integer> sortedKeys = new ArrayList<Integer>(dataMap.keySet());
        Collections.sort(sortedKeys);
        Iterator iterator = sortedKeys.iterator();
        while (iterator.hasNext()) {
            int keyIndex = (Integer)iterator.next();
            Set<Integer> rowOrCol = dataMap.get(keyIndex);
            if (rowOrCol.isEmpty()) continue;
            ArrayList<Integer> sortedDataList = new ArrayList<Integer>(rowOrCol);
            Collections.sort(sortedDataList);
            int firstData = -1;
            int prevData = -1;
            for (int i = 0; i < sortedDataList.size(); ++i) {
                int currData = (Integer)sortedDataList.get(i);
                if (i == 0) {
                    firstData = currData;
                    prevData = currData;
                    continue;
                }
                if (currData != prevData + 1) {
                    if (dataIsRow) {
                        result.add(new int[]{keyIndex, keyIndex, firstData, prevData});
                    } else if (firstData != prevData) {
                        result.add(new int[]{firstData, prevData, keyIndex, keyIndex});
                    } else {
                        cellResult.add(new int[]{firstData, prevData, keyIndex, keyIndex});
                    }
                    firstData = currData;
                }
                prevData = currData;
            }
            if (firstData == -1 || prevData == -1) continue;
            if (dataIsRow) {
                result.add(new int[]{keyIndex, keyIndex, firstData, prevData});
                continue;
            }
            if (firstData != prevData) {
                result.add(new int[]{firstData, prevData, keyIndex, keyIndex});
                continue;
            }
            cellResult.add(new int[]{firstData, prevData, keyIndex, keyIndex});
        }
        if (!cellResult.isEmpty()) {
            if (!needMergeCol) {
                result.addAll(cellResult);
            } else {
                cellResult.sort(Comparator.comparingInt(o -> o[0]));
                int firstRow = -1;
                int firstCol = -1;
                int prevCol = -1;
                for (int[] area : cellResult) {
                    int currRow = area[0];
                    int currCol = area[2];
                    if (firstRow == -1) {
                        firstRow = currRow;
                    }
                    if (firstCol == -1) {
                        firstCol = currCol;
                        prevCol = currCol;
                        continue;
                    }
                    if (currRow != firstRow) {
                        result.add(new int[]{firstRow, firstRow, firstCol, prevCol});
                        firstRow = currRow;
                        firstCol = currCol;
                        prevCol = currCol;
                        continue;
                    }
                    if (currCol != prevCol + 1) {
                        result.add(new int[]{firstRow, firstRow, firstCol, prevCol});
                        firstCol = currCol;
                    }
                    prevCol = currCol;
                }
                if (firstRow != -1 && firstCol != -1 && prevCol != -1) {
                    result.add(new int[]{firstRow, firstRow, firstCol, prevCol});
                }
            }
        }
        result.sort(Comparator.comparingInt(o -> o[0]));
        return result;
    }

    public static List<int[]> mergeRowAreas(List<int[]> areas) {
        if (areas == null || areas.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashMap rowGroups = Maps.newLinkedHashMap();
        areas.forEach(area -> {
            int firstCol = area[2];
            int lastCol = area[3];
            List rows = rowGroups.computeIfAbsent(firstCol + "-" + lastCol, f -> Lists.newLinkedList());
            rows.add(area);
        });
        LinkedList mergeAreas = Lists.newLinkedList();
        rowGroups.values().forEach(_areas -> mergeAreas.addAll(CollectionUtils.mergeRowsBySingleArea(_areas)));
        return mergeAreas;
    }

    private static List<int[]> mergeRowsBySingleArea(List<int[]> regionList) {
        if (CollectionUtils.isEmpty(regionList)) {
            return Collections.emptyList();
        }
        ArrayList merges = Lists.newArrayListWithExpectedSize((int)regionList.size());
        int firstRow = -1;
        int lastRow = -1;
        int firstCol = -1;
        int lastCol = -1;
        boolean initArea = true;
        for (int[] region : regionList) {
            int _firstRow = region[0];
            int _lastRow = region[1];
            int _firstCol = region[2];
            int _lastCol = region[3];
            if (initArea) {
                initArea = false;
                firstRow = _firstRow;
                lastRow = _lastRow;
                firstCol = _firstCol;
                lastCol = _lastCol;
                continue;
            }
            if (firstCol == _firstCol && lastCol == _lastCol) {
                if (_firstRow == firstRow + CollectionUtils.getRows(firstRow, lastRow)) {
                    lastRow += CollectionUtils.getRows(_firstRow, _lastRow);
                    continue;
                }
                merges.add(new int[]{firstRow, lastRow, firstCol, lastCol});
                firstRow = _firstRow;
                lastRow = _lastRow;
                firstCol = _firstCol;
                lastCol = _lastCol;
                continue;
            }
            merges.add(new int[]{firstRow, lastRow, firstCol, lastCol});
            firstRow = _firstRow;
            lastRow = _lastRow;
            firstCol = _firstCol;
            lastCol = _lastCol;
        }
        if (firstRow != -1 && lastRow != -1 && firstCol != -1 && lastCol != -1) {
            merges.add(new int[]{firstRow, lastRow, firstCol, lastCol});
        }
        return merges;
    }

    private static int getRows(int firstRow, int lastRow) {
        return lastRow - firstRow + 1;
    }
}

