/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.ILocaleString;
import org.apache.commons.lang3.time.DateUtils;
import org.jetbrains.annotations.NotNull;

public final class StringUtils {
    private static final String[] DATA_PATTERN = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS Z", "yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss"};

    public static boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static boolean isEmptyArrays(String ... strings) {
        if (strings == null || strings.length == 0) {
            return true;
        }
        for (String _str : strings) {
            if (!StringUtils.isEmpty(_str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmptyArray(String ... str) {
        return str == null || str.length == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static Date isDate(String dateTime) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dateTime)) {
            return null;
        }
        dateTime = dateTime.replace("Z", " UTC");
        Date date = null;
        try {
            date = DateUtils.parseDateStrictly((String)dateTime, (String[])DATA_PATTERN);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public static boolean equals(String str, String str2) {
        return StringUtils.equals(str, str2, false);
    }

    public static boolean equals(ILocaleString str, ILocaleString str2) {
        return StringUtils.equals(str, str2, false);
    }

    public static boolean equals(String str, String str2, boolean ignBlank) {
        if (null == str) {
            return ignBlank ? null == str2 || "".equals(str2) : null == str2;
        }
        return ignBlank ? null == str2 || str.equals(str2) : str.equals(str2);
    }

    public static boolean equals(ILocaleString str, ILocaleString str2, boolean ignBlank) {
        boolean re;
        block2: {
            String _key;
            if (str == null && str2 == null) {
                return true;
            }
            re = false;
            if (str == null || str2 == null || str.keySet().size() != str2.keySet().size()) break block2;
            Set key1 = str.keySet();
            Iterator iterator = key1.iterator();
            while (iterator.hasNext() && (re = StringUtils.equals((String)str.get((Object)(_key = (String)iterator.next())), (String)str2.get((Object)_key), ignBlank))) {
            }
        }
        return re;
    }

    public static boolean notEquals(String str, String str2) {
        return !StringUtils.equals(str, str2);
    }

    public static boolean notEquals(String str, String str2, boolean ignBlank) {
        return !StringUtils.equals(str, str2, ignBlank);
    }

    public static boolean notEquals(ILocaleString str, ILocaleString str2) {
        return !StringUtils.equals(str, str2);
    }

    public static boolean notEquals(ILocaleString str, ILocaleString str2, boolean ignBlank) {
        return !StringUtils.equals(str, str2, ignBlank);
    }

    public static boolean equalsIgnoreCase(String str, String str2) {
        if (null == str) {
            return null == str2;
        }
        return str.equalsIgnoreCase(str2);
    }

    public static String join(Object[] array, char separator) {
        return org.apache.commons.lang.StringUtils.join((Object[])array, (char)separator);
    }

    public static String join(Object[] array, String separator) {
        return org.apache.commons.lang.StringUtils.join((Object[])array, (String)separator);
    }

    public static String join(Collection array, char separator) {
        return org.apache.commons.lang.StringUtils.join((Collection)array, (char)separator);
    }

    public static String join(Collection array, String separator) {
        return org.apache.commons.lang.StringUtils.join((Collection)array, (String)separator);
    }

    public static String firstUpperCase(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        char[] cs = str.toCharArray();
        if (cs[0] >= 'a' && cs[0] <= 'z') {
            cs[0] = (char)(cs[0] - 32);
        }
        return String.valueOf(cs);
    }

    public static <T> boolean isBase64Encode(String value) {
        char[] chrs;
        if (value == null || value.length() == 0) {
            return false;
        }
        if (value.length() % 4 != 0) {
            return false;
        }
        if (value.matches("[0-9]+")) {
            return false;
        }
        if (value.matches("[a-zA-Z]+")) {
            return false;
        }
        for (char chr : chrs = value.toCharArray()) {
            if (chr >= 'a' && chr <= 'z' || chr >= 'A' && chr <= 'Z' || chr >= '0' && chr <= '9' || chr == '+' || chr == '/' || chr == '=') continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        return pattern.matcher(str).matches();
    }

    public static List<String> asList(String ... texts) {
        if (texts == null || texts.length == 0) {
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayListWithCapacity((int)texts.length);
        Collections.addAll(list, texts);
        return list;
    }

    public static String[] split(String str, String separatorChars) {
        return org.apache.commons.lang3.StringUtils.split((String)str, (String)separatorChars);
    }

    public static String replace(@NotNull String str, Object ... args) {
        if (args == null) {
            return str;
        }
        int in = args.length;
        for (int i = 1; i <= in; ++i) {
            str = str.replace("%" + i, String.valueOf(args[i - 1]));
        }
        return str;
    }

    public static String replace(@NotNull String str, HashMap<String, String> replaceArgs) {
        if (StringUtils.isEmpty(str) || replaceArgs == null || replaceArgs.isEmpty()) {
            return str;
        }
        for (Map.Entry<String, String> replace : replaceArgs.entrySet()) {
            str = str.replaceAll(replace.getKey(), replace.getValue());
        }
        return str;
    }

    public static String toTrimString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return ((String)value).trim();
        }
        return value.toString().trim();
    }

    public static String toNoEmptyString(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return ((String)value).trim();
        }
        return value.toString().trim();
    }

    public static String substring(String str, int len) {
        if (str == null) {
            return null;
        }
        if (str.length() > len) {
            return str.substring(0, len);
        }
        return str;
    }

    public static boolean include(String str, String text) {
        return str != null && text != null && str.contains(text);
    }

    public static String removeBlank(String str) {
        return str != null ? str.replaceAll(" ", "").replaceAll("\u3000", "") : str;
    }
}

