/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.opplugin.ApproveBill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateContext;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.epm.eb.business.approveBill.CommitCheck;
import kd.epm.eb.business.approveBill.RejectOnReportService;
import kd.epm.eb.business.approveBill.helper.ApproveBillSubmitHelper;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.business.taskflow.TaskFlowServiceHelper;
import kd.epm.eb.common.approveBill.ApproveBillQuery;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitDim;
import kd.epm.eb.common.decompose.entity.AdjustParam;
import kd.epm.eb.common.examine.domain.report.ExamineCheckReport;
import kd.epm.eb.common.examine.enums.ExamineCheckResultEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;

public class ApproveBillValidator
extends AbstractValidator {
    private Map<String, String> cusParams = new HashMap<String, String>(16);

    public ApproveBillValidator() {
    }

    public ApproveBillValidator(Map<String, String> cusParams) {
        if (cusParams != null) {
            this.cusParams.putAll(cusParams);
        }
    }

    public void validate() {
        String key;
        switch (key = this.getOperateKey().toLowerCase(Locale.getDefault())) {
            case "unsubmit01": 
            case "unsubmit": 
            case "unaudit": 
            case "submit": 
            case "delete": {
                this.doValidate(key);
                break;
            }
        }
    }

    private void doValidate(String key) {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        this.checkBillsValid(dataEntities, key, null);
        if ("unsubmit01".equals(key)) {
            this.unsubmitValidate();
        } else if ("unaudit".equals(key)) {
            this.unauditValidate();
        } else if ("delete".equals(key)) {
            this.deleteValidate();
        }
    }

    public boolean checkBillsValid(ExtendedDataEntity[] dataEntities, String key, String[] errorMsg) {
        boolean flag = false;
        Map<String, ApproveBillSubMitDim> subMitDims = this.getSubMitDimsByBills(dataEntities);
        if (subMitDims == null || subMitDims.size() == 0) {
            return false;
        }
        ArrayList<ExtendedDataEntity> noErrorObjs = new ArrayList<ExtendedDataEntity>(16);
        CommitCheck checkObj = new CommitCheck();
        HashSet errorIds = new HashSet(16);
        ValidateContext validateContext = this.getValidateContext();
        if (validateContext != null && validateContext.getValidateResults() != null) {
            errorIds.addAll(validateContext.getValidateResults().getErrorPkIds());
        }
        for (ExtendedDataEntity dataEntitie : dataEntities) {
            OperationResult result;
            if (dataEntitie == null) continue;
            String billNo = dataEntitie.getBillNo();
            if (StringUtils.isEmpty((String)billNo)) {
                String string = billNo = dataEntitie.getDataEntity() != null ? dataEntitie.getDataEntity().getString("billno") : "";
            }
            if ((result = this.canUndo(subMitDims.get(billNo), (Long)dataEntitie.getBillPkId(), checkObj, key)) != null && !result.getAllErrorInfo().isEmpty()) {
                String allErrorInfo = result.getAllErrorInfo().toString();
                String errMsg = allErrorInfo.replace("[", "").replace("]", "");
                if (errorMsg != null && errorMsg.length == 1) {
                    errorMsg[0] = errMsg;
                } else {
                    this.addErrorMessage(dataEntitie, errMsg);
                }
                flag = true;
                continue;
            }
            if (errorIds.contains(dataEntitie.getBillPkId())) continue;
            noErrorObjs.add(dataEntitie);
        }
        flag = this.checkExamine4Submit(flag, noErrorObjs, subMitDims);
        return flag;
    }

    private boolean checkExamine4Submit(boolean flag, List<ExtendedDataEntity> checkObjs, Map<String, ApproveBillSubMitDim> subMitDims) {
        if (this.isSubmit() && this.isFromApproveList() && checkObjs.size() > 0 && subMitDims.size() > 0) {
            HashMap _subMitDims = new HashMap(checkObjs.size());
            ArrayList billObjs = new ArrayList(checkObjs.size());
            HashMap dataEntityMap = new HashMap(checkObjs.size());
            checkObjs.forEach(entity -> {
                Long billId = (Long)entity.getBillPkId();
                ApproveBillSubMitDim subMitDim = (ApproveBillSubMitDim)subMitDims.get(entity.getDataEntity().getString("billno"));
                if (subMitDim != null) {
                    _subMitDims.put(billId, subMitDim);
                    billObjs.add(entity.getDataEntity());
                    dataEntityMap.put((Long)entity.getBillPkId(), entity);
                }
            });
            Map reportProcessIdsByBill = ApproveUtils.getInstance().getReportProcessIdsByBill(_subMitDims);
            List examineCheckReports = ApproveBillSubmitHelper.getInstance().batCheckExamine(billObjs, reportProcessIdsByBill);
            HashSet<Long> errorBills = new HashSet<Long>(16);
            HashMap<Long, List> checkResult = new HashMap<Long, List>(16);
            for (ExamineCheckReport report : examineCheckReports) {
                Long approveBillId = report.getApproveBillId();
                ExamineCheckResultEnum examineCheckResultEnum = report.getExamineCheckResultEnum();
                if (examineCheckResultEnum != ExamineCheckResultEnum.NoPassIgnore && examineCheckResultEnum != ExamineCheckResultEnum.NoPassCanAnnotation && examineCheckResultEnum != ExamineCheckResultEnum.NoPass && examineCheckResultEnum != ExamineCheckResultEnum.OverRange) continue;
                checkResult.computeIfAbsent(approveBillId, key -> new ArrayList(16)).add(examineCheckResultEnum.getDescription().loadKDString());
                if (examineCheckResultEnum == ExamineCheckResultEnum.NoPassIgnore) continue;
                errorBills.add(approveBillId);
            }
            ArrayList remindMes = new ArrayList(16);
            checkResult.forEach((billId, errorInfo) -> {
                ExtendedDataEntity extendedData = (ExtendedDataEntity)dataEntityMap.get(billId);
                if (extendedData != null) {
                    String billNumber = extendedData.getDataEntity().getString("billno");
                    String errorMes = ResManager.loadResFormat((String)"\u5355\u636e[%1]\u52fe\u7a3d\u68c0\u67e5%2", (String)"ApproveBillValidator_1", (String)"epm-eb-opplugin", (Object[])new Object[]{billNumber, errorInfo.toString()});
                    if (errorBills.contains(billId)) {
                        this.addErrorMessage(extendedData, errorMes);
                    } else {
                        remindMes.add(errorMes);
                    }
                }
            });
            if (remindMes.size() > 0) {
                this.getOption().setVariableValue("remindMes", SerializationUtils.toJsonString(remindMes));
            }
        }
        return flag;
    }

    private boolean isSubmit() {
        if (this.getOperateKey() == null) {
            return false;
        }
        String key = this.getOperateKey().toLowerCase(Locale.getDefault());
        return "submit".equals(key);
    }

    private boolean isFromApproveList() {
        return "true".equals(this.cusParams.get("fromapprove"));
    }

    private Set<Long> getSelBillIds(ExtendedDataEntity[] dataEntitiess) {
        HashSet<Long> returns = new HashSet<Long>(dataEntitiess.length * 2 + 1);
        if (dataEntitiess.length > 0) {
            for (ExtendedDataEntity dataEntity : dataEntitiess) {
                Long billId = Long.valueOf(dataEntity.getBillPkId().toString());
                returns.add(billId);
            }
        }
        return returns;
    }

    private Map<String, ApproveBillSubMitDim> getSubMitDimsByBills(ExtendedDataEntity[] dataEntitiess) {
        ApproveBillQuery queryObject = ApproveBillQuery.getInstance();
        DynamicObject[] billInfos = queryObject.queryBillInfsByIds(this.getSelBillIds(dataEntitiess));
        if (billInfos == null || billInfos.length == 0) {
            return null;
        }
        HashMap<String, ApproveBillSubMitDim> returns = new HashMap<String, ApproveBillSubMitDim>(billInfos.length);
        for (DynamicObject billInfo : billInfos) {
            returns.put(billInfo.getString("billno"), queryObject.getApproveBillSubMitDim(billInfo));
        }
        return returns;
    }

    private OperationResult canUndo(ApproveBillSubMitDim subMitDim, Long billId, CommitCheck checkObj, String key) {
        OperationResult opResult = new OperationResult();
        if (subMitDim == null) {
            return opResult;
        }
        checkObj.canBillDoOperate(subMitDim, billId, opResult, key);
        return opResult;
    }

    private void unsubmitValidate() {
        ExtendedDataEntity[] dataEntities;
        HashSet<Long> pkIds = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            Map addjustDatas;
            Long modelId;
            AdjustParam adjustParam;
            Long approveBillId = IDUtils.toLong((Object)dataEntity.getBillPkId());
            pkIds.add(approveBillId);
            Set reportProcessIds = ApproveUtils.getInstance().getApproveRefReportProcessIds(Collections.singleton(approveBillId));
            Set notAllDealProcesses = ApproveUtils.getInstance().getNotAllDealProcesses((Collection)reportProcessIds, Collections.singleton(approveBillId));
            if (notAllDealProcesses.size() != 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u64a4\u9500\u5931\u8d25\uff0c\u5f53\u524d\u5355\u636e\u5b58\u5728\u5982\u4e0b\u672a\u5904\u7406\u5b8c\u6210\u7684\u9a73\u56de\u62a5\u8868\uff1a\r\n%s", (String)"AuditOp_05", (String)"epm-eb-opplugin", (Object[])new Object[]{String.join((CharSequence)"\r\n", notAllDealProcesses)}));
            }
            if ((adjustParam = CommonUtils.getAdjustParam((Long)(modelId = Long.valueOf(dataEntity.getDataEntity().getLong("modelid.id"))))).isCanunsubmit() || (addjustDatas = BusinessDataServiceHelper.loadFromCache((String)"eb_decomposeadjust", (String)"eb_decomposeadjustsub.approvebill", (QFilter[])QFBuilder.newQFilter().add("model", "=", (Object)modelId).add("eb_decomposeadjustsub.approvebill", "=", (Object)approveBillId).toArray())).isEmpty()) continue;
            String tmpName = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity").size() > 0 ? ((DynamicObject)dataEntity.getDataEntity().getDynamicObjectCollection("entryentity").get(0)).getString("tempid.name") : dataEntity.getDataEntity().getString("billno");
            this.addMessage(dataEntity, "", ResManager.loadResFormat((String)"\u4ee5\u4e0b\u62a5\u8868\u3010%s\u3011\u5df2\u88ab\u5ba1\u6279\u8c03\u6574\uff0c\u64a4\u9500\u5931\u8d25\u3002", (String)"ApproveBillValidator_2", (String)"epm-eb-opplugin", (Object[])new Object[]{tmpName}), ErrorLevel.Error);
        }
        DynamicObject[] approveBills = BusinessDataServiceHelper.load((Object[])pkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_approvebill"));
        Map notInProcessAndWfCanUnSubmit = WorkflowServiceHelper.canWithdraw((DynamicObject[])approveBills);
        List causes = (List)notInProcessAndWfCanUnSubmit.get("notWithdrawCause");
        HashMap<String, String> notWithdrawCause = new HashMap<String, String>(16);
        if (causes != null) {
            for (String cause : causes) {
                String[] arr = cause.split("_");
                if (arr.length != 2) continue;
                notWithdrawCause.put(arr[0], arr[1]);
            }
        }
        if (!notWithdrawCause.isEmpty()) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                Object pkValue = dataEntity.getBillPkId();
                String tip = (String)notWithdrawCause.get(pkValue.toString());
                this.addMessage(dataEntity, "", tip, ErrorLevel.Error);
            }
        }
    }

    private void unauditValidate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            boolean canUnaudit;
            Long approveBillId = IDUtils.toLong((Object)dataEntity.getBillPkId());
            Set rejectBillNos = RejectOnReportService.getInstance().getRejectBillNos(Collections.singleton(approveBillId));
            if (CollectionUtils.isNotEmpty((Collection)rejectBillNos)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u9a73\u56de\u5ba1\u6279\u5355\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\uff0c\u5355\u636e\u5982\u4e0b\uff1a\r\n%s", (String)"AuditOp_04", (String)"epm-eb-opplugin", (Object[])new Object[]{String.join((CharSequence)"\r\n", rejectBillNos)}));
            }
            if (canUnaudit = TaskFlowServiceHelper.canUnaudit((Long)approveBillId)) continue;
            DynamicObject approveBill = dataEntity.getDataEntity();
            Long taskPackId = approveBill.getLong("source_id");
            Long orgId = approveBill.getLong("eborgid.id");
            DynamicObjectCollection tempList = approveBill.getDynamicObjectCollection("entryentity");
            HashSet<Long> tempIds = new HashSet<Long>(tempList.size());
            for (DynamicObject temp : tempList) {
                tempIds.add(temp.getLong("tempid.id"));
            }
            QFilter taskProcessFilter = new QFilter("task.tasklist.id", "=", (Object)taskPackId);
            taskProcessFilter.and("org", "=", (Object)orgId);
            taskProcessFilter.and("template", "in", tempIds);
            DynamicObjectCollection taskProcessList = QueryServiceHelper.query((String)"eb_taskprocess", (String)"id,org.name,task.name", (QFilter[])taskProcessFilter.toArray());
            StringBuilder tips = new StringBuilder();
            tips.append(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff1a\u4ee5\u4e0b\u4efb\u52a1\u7684\u540e\u7f6e\u4efb\u52a1\u6b63\u5728\u8fdb\u884c\u6216\u5df2\u5b8c\u6210\uff0c\u8bf7\u68c0\u67e5\u540e\u7f6e\u4efb\u52a1\u7684\u72b6\u6001\u3002", (String)"AuditOp_21", (String)"epm-eb-opplugin", (Object[])new Object[0])).append("\r\n");
            for (int i = 0; i < taskProcessList.size(); ++i) {
                DynamicObject taskProcess = (DynamicObject)taskProcessList.get(i);
                String orgName = taskProcess.getString("org.name");
                String taskName = taskProcess.getString("task.name");
                tips.append(ResManager.loadResFormat((String)"%1.\u7ec4\u7ec7\uff1a\u201c%2\u201d\uff0c\u5b50\u4efb\u52a1:\u201c%3\u201d\u3002", (String)"AuditOp_22", (String)"epm-eb-opplugin", (Object[])new Object[]{i + 1, orgName, taskName}));
                tips.append("\n\r");
            }
            this.addErrorMessage(dataEntity, tips.toString());
        }
    }

    private void deleteValidate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            Long approveBillId = IDUtils.toLong((Object)dataEntity.getBillPkId());
            Set rejectBillNos = RejectOnReportService.getInstance().getRejectBillNos(Collections.singleton(approveBillId));
            if (!CollectionUtils.isNotEmpty((Collection)rejectBillNos)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u9a73\u56de\u5ba1\u6279\u5355\u4e0d\u5141\u8bb8\u5220\u9664\uff0c\u5355\u636e\u5982\u4e0b\uff1a\r\n%s", (String)"AuditOp_06", (String)"epm-eb-opplugin", (Object[])new Object[]{String.join((CharSequence)"\r\n", rejectBillNos)}));
        }
    }
}

