/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.bizrule;

import com.alibaba.fastjson.JSON;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.cache.Cache;
import kd.epm.eb.olap.impl.bizrule.RuleCacheService;
import kd.epm.eb.olap.impl.bizrule.RuleExecutionCacheContext;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;

public class RuleExecutionCacheService {
    private static final Log log = LogFactory.getLog(RuleExecutionCacheService.class);
    public static final String CACHE_RULE_GRAPHNODE_Version_KEY = "epm:cacheRuleExecution:v";
    private static final long MODEL_MAX_SIZE = 16L;
    private static final long MODEL_OVER_TIME = 10L;
    private static LoadingCache<Long, RuleExecutionCacheContext> caches = CacheBuilder.newBuilder().maximumSize(16L).expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Long, RuleExecutionCacheContext>(){

        public RuleExecutionCacheContext load(Long bizModelId) {
            return RuleExecutionCacheService.getInstance().initCache(bizModelId);
        }
    });

    public static RuleExecutionCacheService getInstance() {
        return InnerClass.instance;
    }

    public RuleExecutionCacheContext listRuleScopeFromLocalCache(Long bizModelId) {
        RuleExecutionCacheContext ruleContext;
        try {
            ruleContext = (RuleExecutionCacheContext)caches.get((Object)bizModelId);
        }
        catch (ExecutionException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
        String versionNum = this.getVersionFromRedis(bizModelId);
        if (!ruleContext.getVersionId().equals(versionNum)) {
            log.info("\u7f13\u5b58\u7248\u672c\u4e0d\u4e00\u81f4\uff0c\u91cd\u65b0\u52a0\u8f7d\u89c4\u5219\u6267\u884c\u7f13\u5b58:" + bizModelId);
            caches.refresh((Object)bizModelId);
            try {
                ruleContext = (RuleExecutionCacheContext)caches.get((Object)bizModelId);
            }
            catch (ExecutionException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                throw new KDBizException(ex.getMessage());
            }
        }
        return ruleContext;
    }

    private String getCacheKey(Long bizModelId) {
        return CACHE_RULE_GRAPHNODE_Version_KEY + bizModelId + "v1";
    }

    public RuleExecutionCacheContext initCache(Long bizModelId) {
        DynamicObject busDy = BusinessDataServiceHelper.loadSingle((String)"eb_businessmodel", (String)"model.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bizModelId)});
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)busDy.getLong("model.id"));
        RuleExecutionCacheContext ruleContext = new RuleExecutionCacheContext();
        String versionNum = this.getVersionFromRedis(bizModelId);
        log.info("\u89c4\u5219\u6267\u884c\u7f13\u5b58\u7248\u672c\u53f7\uff1a" + versionNum + ", \u5f53\u524d\u7f13\u5b58key:" + JSON.toJSONString(caches.asMap().keySet()));
        ruleContext.setVersionId(versionNum);
        List ruleDtos = RuleCacheService.getInstance().listRuleFromLocalCache(bizModelId).getRuleDtoList();
        List filterRules = ruleDtos.stream().filter(rule -> {
            String ruleMet = (String)((Set)rule.getLeftMembers().get(SysDimensionEnum.Metric.getNumber())).iterator().next();
            Member ruleMetMember = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, ruleMet);
            if (ruleMetMember.hasAgg()) {
                return false;
            }
            Map rightMembers = rule.getRightMembers();
            for (Map rightMemberScope : rightMembers.values()) {
                Member rMetMember;
                Set rMetSet = (Set)rightMemberScope.get(SysDimensionEnum.Metric.getNumber());
                if (rMetSet == null || rMetSet.isEmpty() || !(rMetMember = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, (String)rMetSet.iterator().next())).hasAgg()) continue;
                return true;
            }
            return false;
        }).collect(Collectors.toList());
        HashMap ruleExecutionLeftMap = new HashMap(10);
        ConcurrentHashMap dimAllMemberMap = new ConcurrentHashMap(16);
        List pageList = Lists.partition(filterRules, (int)8);
        ArrayList futures = Lists.newArrayListWithExpectedSize((int)pageList.size());
        for (List subList : pageList) {
            Future future = EpmThreadPools.RULE_HANDLE_POOL.submit(() -> {
                for (RuleDto rule : subList) {
                    HashMap executionLeftMap = Maps.newHashMapWithExpectedSize((int)5);
                    rule.getLeftMembers().forEach((dimNum, memSet) -> {
                        Set newSet = executionLeftMap.computeIfAbsent(dimNum, val -> Sets.newHashSet());
                        Long viewId = (Long)rule.getViewMap().get(dimNum);
                        int memSize = memSet.size();
                        for (String mem : memSet) {
                            String key = dimNum + "_" + viewId + "_" + mem;
                            Set allMember = dimAllMemberMap.computeIfAbsent(key, v -> modelCache.getMember(dimNum, viewId, mem, RangeEnum.ALL.getIndex()).stream().map(BaseCache::getNumber).collect(Collectors.toCollection(ConcurrentHashMap::newKeySet)));
                            if (memSize == 1) {
                                newSet = allMember;
                                executionLeftMap.put(dimNum, newSet);
                                continue;
                            }
                            newSet.addAll(allMember);
                        }
                    });
                    ruleExecutionLeftMap.put(rule.getId(), executionLeftMap);
                }
                return null;
            });
            futures.add(future);
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (Exception e) {
                log.error((Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u591a\u7ebf\u7a0b\u5904\u7406\u540e\u7ee7\u51fa\u9519\u3002", (String)"RuleGraphService_41", (String)"epm-eb-business", (Object[])new Object[0]));
            }
        }
        ruleContext.setRuleExecutionLeftMap(ruleExecutionLeftMap);
        return ruleContext;
    }

    private String getVersionFromRedis(Long bizModelId) {
        String versionStr = Cache.get().get(this.getCacheKey(bizModelId));
        if (StringUtils.isNotEmpty((String)versionStr)) {
            return versionStr;
        }
        String newVersionNum = DBServiceHelper.genStringId();
        Cache.get().set(this.getCacheKey(bizModelId), newVersionNum);
        return newVersionNum;
    }

    public void clearCache(Long bizModelId) {
        if (bizModelId == null) {
            return;
        }
        log.info("\u6e05\u9664\u89c4\u5219\u6267\u884c\u7f13\u5b58:" + bizModelId);
        Cache.get().remove(this.getCacheKey(bizModelId));
        caches.invalidate((Object)bizModelId);
    }

    static {
        try {
            ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
            scheduledExecutor.scheduleAtFixedRate(() -> {
                log.info("\u5b9a\u65f6\u6e05\u7406\u89c4\u5219\u6267\u884c\u7f13\u5b58");
                caches.cleanUp();
            }, 10L, 30L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            log.warn("\u5b9a\u65f6\u6e05\u7406\u89c4\u5219\u6267\u884c\u7f13\u5b58", (Throwable)e);
        }
    }

    private static class InnerClass {
        private static RuleExecutionCacheService instance = new RuleExecutionCacheService();

        private InnerClass() {
        }
    }
}

