/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.bizrule;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.extension.ConcurrentHashSet;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.cache.threadlocal.EpmThreadLocalUtils;
import kd.epm.eb.common.cache.utils.ObjectCache;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.FunctionItemEnum;
import kd.epm.eb.common.f7.FormulaCondition;
import kd.epm.eb.common.f7.MemberCondition;
import kd.epm.eb.common.pojo.CustomAttributeRelationTypeEnum;
import kd.epm.eb.common.rule.ruleFunction.FunctionRefMember;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionFactory;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionUtils;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.AnalyzeRangeUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UpdateRecordHelper;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.KdUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.common.var.ReportVarUtil;
import kd.epm.eb.olap.impl.bizrule.RuleCacheService;
import kd.epm.eb.olap.impl.bizrule.context.QueryRuleDtoBizContext;
import kd.epm.eb.olap.impl.bizrule.entity.FormulaMemberDto;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.impl.bizrule.entity.RuleRightItemDto;
import kd.epm.eb.olap.impl.execute.dao.RuleManageJsonUtil;
import kd.epm.eb.olap.service.LeafFeature;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class RuleService {
    private static final Log log = LogFactory.getLog(RuleService.class);

    public static RuleService getInstance() {
        return InnerClass.instance;
    }

    private RuleService() {
    }

    public Set<Long> getDirectRuleByTempId(Long templateId) {
        return this.getDirectRuleByTempIdList(Lists.newArrayList((Object[])new Long[]{templateId}));
    }

    public Set<Long> getDirectRuleByTempIdList(List<Long> templateIds) {
        HashSet<Long> returnSet = new HashSet<Long>(16);
        QFilter qFilter = new QFilter("template.id", "in", templateIds);
        try (DataSet dataset = QueryServiceHelper.queryDataSet((String)"getDirectRuleByTempIds", (String)"eb_leafbizruletemplatedis", (String)"bizrule.id as id", (QFilter[])qFilter.toArray(), null);){
            if (dataset != null) {
                for (Row row : dataset) {
                    returnSet.add(row.getLong("id"));
                }
            }
        }
        return returnSet;
    }

    public List<RuleDto> listRule(Long bizctrlrangeid, Boolean status, Collection<Long> ids) {
        QFilter qFilter = new QFilter("ruletype", "!=", (Object)"1");
        if (status != null) {
            qFilter.and("status", "=", (Object)status);
        }
        if (IDUtils.isNotNull((Long)bizctrlrangeid)) {
            qFilter.and("bizctrlrange", "=", (Object)bizctrlrangeid);
        }
        if (CollectionUtils.isNotEmpty(ids)) {
            qFilter.and("id", "in", ids);
        }
        if (IDUtils.isEmptyLong((Long)bizctrlrangeid).booleanValue() && CollectionUtils.isEmpty(ids)) {
            return new ArrayList<RuleDto>(0);
        }
        return this.listRule(qFilter, (Boolean)true, null);
    }

    public List<RuleDto> listRule(QFilter qFilter, Boolean needCheckEmpty, Map<String, Map<String, Set<String>>> varValues) {
        List<RuleDto> dtos = this.getRuleDtos(qFilter);
        if (dtos.isEmpty()) {
            return new ArrayList<RuleDto>(0);
        }
        Long modelId = dtos.get(0).getModelId();
        if (!this.updateOldRule(modelId)) {
            dtos = this.getRuleDtos(qFilter);
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelCache.getModelobj().getId());
        CustomAttributeRelationTypeEnum customAttributeRelationTypeEnum = KdUtils.getCustomAttributeRelationTypeEnum((Long)modelCache.getModelobj().getId());
        if (varValues == null || varValues.isEmpty()) {
            varValues = ReportVarUtil.getVarValuesByRule((String)String.valueOf(ProcessTypeEnum.RULE.getIndex()), (Long)modelId);
        }
        DynamicObjectCollection varList = QueryServiceHelper.query((String)"eb_periodvariable", (String)"offset,number", (QFilter[])new QFilter("model", "=", (Object)modelId).and("dimension.number", "=", (Object)SysDimensionEnum.BudgetPeriod.getNumber()).toArray());
        Map finalVarValues = varValues;
        QueryRuleDtoBizContext _bizCtx = this.getQueryRuleDtoBizContext(dtos, modelId, modelCache, memberPropCache, customAttributeRelationTypeEnum);
        List<RuleFunction> functions = this.queryFunctionByRuleId(dtos.stream().map(RuleDto::getId).collect(Collectors.toSet()));
        Map<Long, List<RuleFunction>> functionGroup = functions.stream().collect(Collectors.groupingBy(RuleFunction::getBizRuleId));
        ConcurrentHashSet removeSet = new ConcurrentHashSet(16);
        List pageList = Lists.partition(dtos, (int)3);
        for (List sub : pageList) {
            CountDownLatch latch = new CountDownLatch(sub.size());
            ConcurrentHashSet errorMsg = new ConcurrentHashSet(16);
            for (RuleDto obj : sub) {
                EpmThreadPools.RULE_HANDLE_POOL.execute(() -> {
                    EpmThreadLocalUtils.setDimNoCheckVersion((long)modelId);
                    try {
                        ArrayList<RuleFunction> ruleDtoFunctions;
                        log.info("\u5904\u7406\u89c4\u5219\u8303\u56f4\uff1a" + obj.getNumber());
                        String useScope = obj.getUseScope();
                        this.setOffsetMap(obj);
                        Map<String, Set<String>> leftMemberScope = this.getLeftMemberScope(_bizCtx.getLeftMemberObjs().get(obj.getId()), obj, _bizCtx, finalVarValues, varList);
                        if (needCheckEmpty.booleanValue() && leftMemberScope.values().stream().anyMatch(CollectionUtils::isEmpty)) {
                            removeSet.add((Object)obj.getId());
                            return;
                        }
                        if (obj.getNewLeafFeature() == LeafFeature.NOTLEAF && this.leftMetricIsAgg(modelCache, leftMemberScope)) {
                            removeSet.add((Object)obj.getId());
                            return;
                        }
                        obj.setLeftMembers(leftMemberScope);
                        String accountMemberNumberString = (String)LambdaUtils.get(() -> {
                            Set accountNumbers = (Set)leftMemberScope.get(SysDimensionEnum.Account.getNumber());
                            if (CollectionUtils.isNotEmpty((Collection)accountNumbers)) {
                                return (String)accountNumbers.iterator().next();
                            }
                            if (StringUtils.isBlank((CharSequence)useScope)) {
                                return null;
                            }
                            List formulaConditions = RuleManageJsonUtil.getConditions2((String)useScope);
                            if (CollectionUtils.isEmpty((Collection)formulaConditions)) {
                                return null;
                            }
                            List accountFormulaConditionList = formulaConditions.stream().filter(item -> item != null && SysDimensionEnum.Account.getNumber().equals(item.getDimensionNumber())).collect(Collectors.toList());
                            if (CollectionUtils.isEmpty(accountFormulaConditionList)) {
                                return null;
                            }
                            List memberConditionList = ((FormulaCondition)accountFormulaConditionList.get(0)).getMemberList();
                            if (CollectionUtils.isEmpty((Collection)memberConditionList)) {
                                return null;
                            }
                            return ((MemberCondition)memberConditionList.get(0)).getNumber();
                        });
                        if (StringUtils.isBlank((CharSequence)accountMemberNumberString)) {
                            throw new KDBizException(ResManager.loadResFormat((String)"\u201c%1\u201d\u89c4\u5219\u6709\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"RuleService_2", (String)"epm-eb-olap", (Object[])new Object[]{obj.getNumber()}));
                        }
                        Member accountMember = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, accountMemberNumberString);
                        obj.setDataSetId(accountMember.getDatasetId());
                        Set<Object> scopeHasViewDimSet = new HashSet(16);
                        HashSet<Object> hasViewDimSet = new HashSet(16);
                        if (StringUtils.isNotBlank((CharSequence)useScope)) {
                            List useScopeList = JSON.parseArray((String)useScope, FormulaCondition.class);
                            scopeHasViewDimSet = useScopeList.stream().map(FormulaCondition::getDimensionNumber).filter(dimensionNumber -> !View.NoViewDimNums.contains(dimensionNumber)).collect(Collectors.toSet());
                            Set _hasViewDimSet = modelCache.getDimensionList(obj.getDataSetId()).stream().map(BaseCache::getNumber).filter(number -> !View.NoViewDimNums.contains(number)).collect(Collectors.toSet());
                            hasViewDimSet = new HashSet(_hasViewDimSet);
                            Long mainDimensionId = obj.getMainDimensionId();
                            Dimension dimension = modelCache.getDimension(mainDimensionId);
                            _hasViewDimSet.remove(dimension.getNumber());
                            _hasViewDimSet.removeAll(scopeHasViewDimSet);
                            if (CollectionUtils.isNotEmpty(_hasViewDimSet)) {
                                throw new KDBizException(ResManager.loadResFormat((String)"%1\u89c4\u5219%2\u7ef4\u5ea6\u9002\u7528\u8303\u56f4\u672a\u9009\u62e9\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CalcBizTemplate_4", (String)"epm-eb-olap", (Object[])new Object[]{obj.getNumber(), StringUtils.join(_hasViewDimSet, (String)",")}));
                            }
                        }
                        _bizCtx.setViewMap(RuleFunctionUtils.getRuleViewMapByViewNumber((IModelCacheHelper)modelCache, (String)obj.getRuleView(), scopeHasViewDimSet, (String)obj.getNumber(), hasViewDimSet));
                        List<RuleRightItemDto> ruleRightItemDtos = _bizCtx.getRightMemberObjs().get(obj.getId());
                        if (ruleRightItemDtos == null) {
                            ruleRightItemDtos = Collections.emptyList();
                        }
                        if ((ruleDtoFunctions = (ArrayList<RuleFunction>)functionGroup.get(obj.getId())) == null) {
                            ruleDtoFunctions = new ArrayList<RuleFunction>(0);
                        }
                        obj.setFunctions((List)ruleDtoFunctions);
                        HashMap dimRefProp = Maps.newHashMapWithExpectedSize((int)1);
                        obj.setDimRefProp((Map)dimRefProp);
                        HashMap calcRefMember = Maps.newHashMapWithExpectedSize((int)1);
                        obj.setCalcRefMember((Map)calcRefMember);
                        this.setFunctionMemberToRightMember(leftMemberScope, ruleRightItemDtos, _bizCtx, ruleDtoFunctions, dimRefProp, calcRefMember);
                        if (ruleRightItemDtos.isEmpty()) {
                            obj.setRuleRightItemDto(Collections.emptyList());
                            obj.setRightMemberCacheNav(Collections.emptyMap());
                            obj.setRightPageMembers(Collections.emptyMap());
                            obj.setUnionPageRightMembers(Collections.emptyMap());
                            obj.setDimRefProp((Map)dimRefProp);
                            return;
                        }
                        for (RuleRightItemDto ruleRightItemDto : ruleRightItemDtos) {
                            if (ruleRightItemDto.getDataSetId() != null) continue;
                            ruleRightItemDto.setDataSetId(accountMember.getDatasetId());
                        }
                        Map offsetMap = obj.getOffsetMap();
                        if (MapUtils.isNotEmpty((Map)offsetMap)) {
                            block9: for (Map.Entry entry : offsetMap.entrySet()) {
                                String offsetKey = (String)entry.getKey();
                                for (RuleRightItemDto ruleRightItemDto : ruleRightItemDtos) {
                                    if (!offsetKey.equals(ruleRightItemDto.getMemberKey())) continue;
                                    ruleRightItemDto.setPeriodOffset((Integer)entry.getValue());
                                    continue block9;
                                }
                            }
                        }
                        obj.setRuleRightItemDto(ruleRightItemDtos);
                        this.setRightMemberScope(obj, ruleRightItemDtos, _bizCtx, leftMemberScope.get(SysDimensionEnum.Metric.getNumber()).iterator().next());
                        HashMap<String, Set> hashMap = new HashMap<String, Set>(16);
                        HashMap hashMap2 = new HashMap(16);
                        for (RuleRightItemDto itemDto : ruleRightItemDtos) {
                            HashMap<String, HashSet> members = new HashMap<String, HashSet>(10);
                            hashMap2.put(itemDto.getMemberKey(), members);
                            Map<String, Set<String>> refMemberMap = itemDto.getRefMemberMap();
                            for (Map.Entry<String, Set<String>> entry : refMemberMap.entrySet()) {
                                String dimNumber = (String)_bizCtx.getMemberCache().valueOf((Object)entry.getKey());
                                Set<String> refMember = entry.getValue();
                                hashMap.computeIfAbsent(dimNumber, v -> new HashSet(10)).addAll(refMember);
                                members.put(dimNumber, Sets.newHashSet(refMember));
                            }
                            if (!CollectionUtils.isNotEmpty(itemDto.getSkipDimList()) || itemDto.isLoop()) continue;
                            obj.setSkipSelf(true);
                        }
                        obj.setUnionPageRightMembers(hashMap);
                        obj.setRightPageMembers(hashMap2);
                    }
                    catch (Exception e) {
                        log.error("\u4e1a\u52a1\u89c4\u5219\u5904\u7406\u540e\u7ee7\u51fa\u9519", (Throwable)e);
                        errorMsg.add((Object)(obj.getNumber() + ":" + e.getMessage()));
                    }
                    finally {
                        latch.countDown();
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e2) {
                log.error((Throwable)e2);
                throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u591a\u7ebf\u7a0b\u5904\u7406\u540e\u7ee7\u51fa\u9519\u3002", (String)"RuleGraphService_41", (String)"epm-eb-business", (Object[])new Object[0]));
            }
            if (errorMsg.isEmpty()) continue;
            StringBuffer msgString = new StringBuffer();
            for (String msg : errorMsg) {
                msgString.append(msg).append("!");
            }
            throw new KDBizException(ResManager.loadResFormat((String)msgString.toString(), (String)"RuleGraphService_42", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        dtos.removeIf(e -> removeSet.contains((Object)e.getId()));
        return dtos;
    }

    private boolean updateOldRule(Long modelId) {
        boolean isUpdated = UpdateRecordHelper.isUpdated((String)("oldrule_" + modelId));
        if (!isUpdated) {
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"UpdateOldRuleService", (String)"autoUpdateOldRule", (Object[])new Object[]{modelId, true});
        }
        return isUpdated;
    }

    private QueryRuleDtoBizContext getQueryRuleDtoBizContext(List<RuleDto> dtos, Long modelId, IModelCacheHelper modelCache, MemberPropCache memberPropCache, CustomAttributeRelationTypeEnum customAttributeRelationTypeEnum) {
        QueryRuleDtoBizContext bizCtx = new QueryRuleDtoBizContext(modelId, modelCache, memberPropCache);
        Long bizCtrlRangeId = dtos.get(0).getBizCtrlRangeId();
        bizCtx.setBusinessModelId(bizCtrlRangeId);
        Map viewMap = modelCache.getViewsByBusModel(bizCtrlRangeId);
        bizCtx.setViewMap(viewMap);
        bizCtx.setDtos(dtos);
        bizCtx.setCustomAttributeRelationTypeEnum(customAttributeRelationTypeEnum);
        this.setFormulaMember(bizCtx);
        return bizCtx;
    }

    private List<RuleDto> getRuleDtos(QFilter qFilter) {
        String field = "id,model.id,number,name,usescope,index,groupid,status,executerange,applicationscenario,formulastring,formulastringforparse,mdxleft,mdxright,periodoffset,successors,offsetsuccessors,bizctrlrange.id,leftmember,maindimension.id,ifhasnotparam,ruleview";
        ArrayList<RuleDto> dtos = new ArrayList<RuleDto>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"eb_bizruleset", (String)field, (QFilter[])qFilter.toArray(), null);){
            for (Row row : ds) {
                RuleDto obj = new RuleDto();
                obj.setId(row.getLong("id"));
                obj.setModelId(row.getLong("model.id"));
                obj.setNumber(row.getString("number"));
                obj.setName(row.getString("name"));
                obj.setGroupId(row.getLong("groupid"));
                obj.setUseScope(row.getString("usescope"));
                obj.setStatus(row.getBoolean("status"));
                String formulaString = row.getString("formulastringforparse");
                if (StringUtils.isBlank((CharSequence)formulaString)) {
                    formulaString = row.getString("formulastring");
                }
                obj.setFormulaString(formulaString);
                obj.setMdxLeft(row.getString("mdxleft"));
                obj.setMdxRight(row.getString("mdxright"));
                obj.setLeafFeature(StringUtils.isEmpty((CharSequence)row.getString("executerange")) ? kd.epm.eb.algo.olap.LeafFeature.ALL : kd.epm.eb.algo.olap.LeafFeature.of((String)row.getString("executerange")));
                obj.setNewLeafFeature(StringUtils.isEmpty((CharSequence)row.getString("executerange")) ? LeafFeature.ALL : LeafFeature.of((String)row.getString("executerange")));
                obj.setPeriodOffset(row.getString("periodoffset"));
                obj.setSuccessors(row.getString("successors") == null ? "" : row.getString("successors"));
                obj.setOffSuccessors(row.getString("offsetsuccessors") == null ? "" : row.getString("offsetsuccessors"));
                obj.setGroupId(row.getLong("groupid"));
                obj.setBizCtrlRangeId(row.getLong("bizctrlrange.id"));
                obj.setMainDimensionId(row.getLong("maindimension.id"));
                obj.setIfHasNotParam(row.getBoolean("ifhasnotparam").booleanValue());
                obj.setRuleView(row.getString("ruleview"));
                dtos.add(obj);
            }
        }
        return dtos;
    }

    private boolean leftMetricIsAgg(IModelCacheHelper modelCache, Map<String, Set<String>> leftMemberScope) {
        Set<String> metricNumbers = leftMemberScope.get(SysDimensionEnum.Metric.getNumber());
        if (CollectionUtils.isEmpty(metricNumbers)) {
            return true;
        }
        Member metricMember = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, metricNumbers.iterator().next());
        return metricMember.hasAgg();
    }

    private void setFunctionMemberToRightMember(Map<String, Set<String>> leftMemberScope, List<RuleRightItemDto> ruleRightItemDtos, QueryRuleDtoBizContext bizCtx, List<RuleFunction> functions, Map<String, Set<String>> dimRefProp, Map<String, Set<String>> calcRefMember) {
        if (CollectionUtils.isEmpty(functions)) {
            return;
        }
        RuleRightItemDto currentRightDto = null;
        for (RuleFunction function : functions) {
            FunctionRefMember functionRefMember = function.genRefMemberFirst(leftMemberScope, bizCtx.getModelCache(), bizCtx.getViewMap());
            FunctionRefMember otherFuncRefMem = functionRefMember.getOtherFuncRefMem();
            if (functionRefMember.isSkip() || functionRefMember.getDimNumber() != null) {
                String refMemKey = (String)function.getValue("refMemKey");
                if (StringUtils.isNotEmpty((CharSequence)refMemKey)) {
                    Set refMembers;
                    LinkedHashMap filterRefMemberMap;
                    LinkedHashMap refMemberMap;
                    for (RuleRightItemDto ruleRightItemDto : ruleRightItemDtos) {
                        if (!refMemKey.equals(ruleRightItemDto.getMemberKey())) continue;
                        currentRightDto = ruleRightItemDto;
                        break;
                    }
                    if (currentRightDto == null) continue;
                    currentRightDto.setRefFunctionKey(function.getFunctionKey());
                    Map allValues = function.getAllValues();
                    if (allValues.containsKey(FunctionItemEnum.DIMENSIONLIST.getKey()) && allValues.containsKey("allvals_view_id")) {
                        HashMap refFunctionDimView = Maps.newHashMapWithExpectedSize((int)16);
                        refFunctionDimView.put((String)allValues.get(FunctionItemEnum.DIMENSIONLIST.getKey()), IDUtils.toLong(allValues.get("allvals_view_id")));
                        currentRightDto.setRefFunctionDimView(refFunctionDimView);
                    }
                    ArrayList functionRefDimList = Lists.newArrayList((Object[])new String[]{functionRefMember.getDimNumber()});
                    ArrayList<String> skipDimList = new ArrayList<String>(16);
                    if (functionRefMember.isSkip()) {
                        skipDimList.add(functionRefMember.getDimNumber());
                    }
                    if (functionRefMember.isLoop()) {
                        currentRightDto.setLoop(functionRefMember.isLoop());
                    }
                    if ((refMemberMap = currentRightDto.getRefMemberMap()) == null) {
                        refMemberMap = Maps.newLinkedHashMap();
                        currentRightDto.setRefMemberMap(refMemberMap);
                    }
                    if ((filterRefMemberMap = currentRightDto.getFilterRefMemberMap()) == null) {
                        filterRefMemberMap = Maps.newLinkedHashMap();
                        for (Map.Entry entry : refMemberMap.entrySet()) {
                            filterRefMemberMap.put(entry.getKey(), new HashSet((Collection)entry.getValue()));
                        }
                        currentRightDto.setFilterRefMemberMap(filterRefMemberMap);
                    }
                    if (!(refMembers = refMemberMap.computeIfAbsent(functionRefMember.getDimNumber(), v -> new LinkedHashSet())).isEmpty()) {
                        log.error("memberKey=" + currentRightDto.getMemberKey() + "'s right member is wrong");
                    }
                    if (functionRefMember.getFilterMembers() == null) {
                        filterRefMemberMap.put(functionRefMember.getDimNumber(), functionRefMember.getMembers());
                    } else {
                        filterRefMemberMap.put(functionRefMember.getDimNumber(), functionRefMember.getFilterMembers());
                    }
                    refMembers.addAll(functionRefMember.getMembers());
                    if (otherFuncRefMem != null) {
                        RuleFunction childFun;
                        Map childFunAllValues;
                        String relFunStr = (String)allValues.get(FunctionItemEnum.RELATIONFUN.getKey());
                        if (StringUtils.isNotBlank((CharSequence)relFunStr) && (childFunAllValues = (childFun = RuleFunctionFactory.fromJsonString((String)relFunStr)).getAllValues()).containsKey(FunctionItemEnum.DIMENSIONLIST.getKey()) && childFunAllValues.containsKey("allvals_view_id")) {
                            HashMap refFunctionDimView = Maps.newHashMapWithExpectedSize((int)16);
                            refFunctionDimView.put((String)childFunAllValues.get(FunctionItemEnum.DIMENSIONLIST.getKey()), IDUtils.toLong(childFunAllValues.get("allvals_view_id")));
                            currentRightDto.setRefFunctionDimView(refFunctionDimView);
                        }
                        if (BooleanUtils.isFalse((Boolean)otherFuncRefMem.isHasRefMember())) {
                            currentRightDto.setYvRelationHasMem(false);
                        }
                        functionRefDimList.add(otherFuncRefMem.getDimNumber());
                        if (otherFuncRefMem.isSkip()) {
                            skipDimList.add(otherFuncRefMem.getDimNumber());
                        }
                        Set otherRefMembers = refMemberMap.computeIfAbsent(otherFuncRefMem.getDimNumber(), v -> new LinkedHashSet());
                        otherRefMembers.addAll(otherFuncRefMem.getMembers());
                        if (otherFuncRefMem.getFilterMembers() == null) {
                            filterRefMemberMap.put(otherFuncRefMem.getDimNumber(), otherFuncRefMem.getMembers());
                        } else {
                            filterRefMemberMap.put(otherFuncRefMem.getDimNumber(), otherFuncRefMem.getFilterMembers());
                        }
                    }
                    currentRightDto.setFunctionRefDimList(functionRefDimList);
                    currentRightDto.setSkipDimList(skipDimList);
                } else {
                    if (StringUtils.isNotEmpty((CharSequence)functionRefMember.getDimNumber()) && functionRefMember.getMembers() != null) {
                        calcRefMember.computeIfAbsent(functionRefMember.getDimNumber(), v -> new HashSet(16)).addAll(functionRefMember.getMembers());
                    }
                    if (otherFuncRefMem != null && StringUtils.isNotEmpty((CharSequence)otherFuncRefMem.getDimNumber()) && otherFuncRefMem.getMembers() != null) {
                        calcRefMember.computeIfAbsent(otherFuncRefMem.getDimNumber(), v -> new HashSet(16)).addAll(otherFuncRefMem.getMembers());
                    }
                }
            }
            this.addFuncRefProperties(dimRefProp, functionRefMember, functionRefMember.getDimNumber());
            if (otherFuncRefMem == null) continue;
            this.addFuncRefProperties(dimRefProp, otherFuncRefMem, otherFuncRefMem.getDimNumber());
        }
    }

    private void addFuncRefProperties(Map<String, Set<String>> dimRefProp, FunctionRefMember functionRefMember, String dimNumber) {
        Set refPropSet = functionRefMember.getRefPropSet();
        if (CollectionUtils.isNotEmpty((Collection)refPropSet)) {
            Set dimRefPropTemp = dimRefProp.computeIfAbsent(dimNumber, v -> new HashSet(16));
            dimRefPropTemp.addAll(refPropSet);
        }
    }

    public void deleteRuleFromCacheByModel(Long modelId) {
        List pkIds = QueryServiceHelper.queryPrimaryKeys((String)"eb_businessmodel", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray(), null, (int)1000);
        for (Object pkId : pkIds) {
            RuleCacheService.getInstance().clearCache((Long)pkId);
        }
    }

    private void setRightMemberScope(RuleDto obj, List<RuleRightItemDto> ruleRightItemDtos, QueryRuleDtoBizContext bizCtx, String metricNumber) {
        ObjectCache memberCache = bizCtx.getMemberCache();
        Member metricMember = bizCtx.getModelCache().getMember(SysDimensionEnum.Metric.getNumber(), null, metricNumber);
        boolean leftMetricHasAgg = metricMember.hasAgg();
        HashMap<String, Map> rMembers = new HashMap<String, Map>(16);
        for (RuleRightItemDto rightItemDto : ruleRightItemDtos) {
            boolean metricAgg;
            Map dimViewMap = obj.getViewMap();
            for (FormulaMemberDto formulaMemberDto : rightItemDto.getFormulaMemberList()) {
                if (dimViewMap.containsKey(formulaMemberDto.getDimNumber()) || !IDUtils.isNotEmptyLong((Long)formulaMemberDto.getViewId()).booleanValue()) continue;
                dimViewMap.put(formulaMemberDto.getDimNumber(), formulaMemberDto.getViewId());
            }
            Map<String, Long> refFunctionDimView = rightItemDto.getRefFunctionDimView();
            if (refFunctionDimView != null && !refFunctionDimView.isEmpty()) {
                for (Map.Entry<String, Long> entry : refFunctionDimView.entrySet()) {
                    if (dimViewMap.containsKey(entry.getKey()) || !IDUtils.isNotEmptyLong((Long)entry.getValue()).booleanValue()) continue;
                    dimViewMap.put(entry.getKey(), entry.getValue());
                }
            }
            String string = rightItemDto.getMemberKey();
            Map rDimMemMap = rMembers.computeIfAbsent(string, v -> new HashMap());
            Map<String, Set<String>> refMemberMap = rightItemDto.getRefMemberMap();
            Set<String> metricNumbers = refMemberMap.get(SysDimensionEnum.Metric.getNumber());
            if (CollectionUtils.isNotEmpty(metricNumbers)) {
                if (metricNumbers.size() > 1) {
                    throw new KDBizException("rule " + obj.getNumber() + "'s metric is more then one. please check");
                }
                String metricOne = metricNumbers.iterator().next();
                metricMember = bizCtx.getModelCache().getMember(SysDimensionEnum.Metric.getNumber(), null, metricOne);
                metricAgg = metricMember.hasAgg();
            } else {
                metricAgg = leftMetricHasAgg;
            }
            int rangeIndex = metricAgg ? RangeEnum.ALL.getIndex() : RangeEnum.ONLY.getIndex();
            for (Map.Entry<String, Set<String>> entry : refMemberMap.entrySet()) {
                String dimNumber = entry.getKey();
                Set<String> memberNumbers = entry.getValue();
                Long viewId = IDUtils.toLong(dimViewMap.get(dimNumber));
                if (memberNumbers.isEmpty()) continue;
                if (memberNumbers.size() == 1) {
                    String memberNumber = memberNumbers.iterator().next();
                    Set<String> collect = bizCtx.getPubMemberCache(dimNumber, memberNumber, rangeIndex, viewId);
                    rDimMemMap.put(memberCache.valueOf((Object)dimNumber), collect);
                    continue;
                }
                Set memberMap = rDimMemMap.computeIfAbsent(memberCache.valueOf((Object)dimNumber), v -> new HashSet(16));
                for (String memberNumber : memberNumbers) {
                    Set<String> collect = bizCtx.getPubMemberCache((String)memberCache.valueOf((Object)dimNumber), memberNumber, rangeIndex, viewId);
                    memberMap.addAll(collect);
                }
            }
        }
        obj.setRightMembers(rMembers);
    }

    private Map<String, Set<String>> getLeftMemberScope(List<FormulaMemberDto> formulaMemberDtos, RuleDto ruleDto, QueryRuleDtoBizContext bizCtx, Map<String, Map<String, Set<String>>> varValues, DynamicObjectCollection varList) {
        ObjectCache memberCache = bizCtx.getMemberCache();
        LinkedHashMap<String, Set> leftMemberScope = new LinkedHashMap<String, Set>(16);
        Map viewMap = ruleDto.getViewMap();
        if (formulaMemberDtos == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u516c\u5f0f\u201c%1\u201d\u5de6\u5f0f\u65e0\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u8be5\u516c\u5f0f\u3002", (String)"BizruleServiceImpl_3", (String)"epm-eb-olap", (Object[])new Object[]{ruleDto.getNumber()}));
        }
        IModelCacheHelper modelCache = bizCtx.getModelCache();
        for (FormulaMemberDto dto : formulaMemberDtos) {
            Long mainDimensionId = ruleDto.getMainDimensionId();
            Dimension dimension = modelCache.getDimension(mainDimensionId);
            String dimNumber = dto.getDimNumber();
            if (!dimension.getNumber().equals(dimNumber)) continue;
            String number = (String)memberCache.valueOf((Object)dto.getNumber());
            leftMemberScope.computeIfAbsent((String)memberCache.valueOf((Object)dto.getDimNumber()), a -> new HashSet()).add(number);
            if (!viewMap.containsKey(dimNumber) && IDUtils.isNotEmptyLong((Long)dto.getViewId()).booleanValue()) {
                Long viewId = dto.getViewId();
                viewMap.put(dimNumber, viewId);
                ruleDto.setMainDimensionViewId(viewId);
            }
            if (!SysDimensionEnum.ChangeType.getNumber().equals(dimNumber)) continue;
            ruleDto.setLeftMainMemContainCtControl(RuleFunctionUtils.getCtControlMemSet().contains(number));
        }
        if (MapUtils.isEmpty(leftMemberScope)) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u516c\u5f0f\u201c%1\u201d\u5de6\u5f0f\u65e0\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u8be5\u516c\u5f0f\u3002", (String)"BizruleServiceImpl_3", (String)"epm-eb-olap", (Object[])new Object[]{ruleDto.getNumber()}));
        }
        List formulaConditions = RuleManageJsonUtil.getConditions2((String)ruleDto.getUseScope());
        kd.epm.eb.algo.olap.LeafFeature leafFeature = ruleDto.getLeafFeature();
        if (CollectionUtils.isNotEmpty((Collection)formulaConditions)) {
            boolean onlyLeafBoolean = leafFeature == kd.epm.eb.algo.olap.LeafFeature.LEAF;
            for (FormulaCondition formulaCondition : formulaConditions) {
                String dimNumber = formulaCondition.getDimensionNumber();
                List memberList = formulaCondition.getMemberList();
                if (CollectionUtils.isNotEmpty((Collection)memberList) && !viewMap.containsKey(dimNumber) && IDUtils.isNotEmptyLong((Long)((MemberCondition)memberList.get(0)).getViewIdLong()).booleanValue()) {
                    viewMap.put(dimNumber, ((MemberCondition)memberList.get(0)).getViewIdLong());
                }
                Long viewId = (Long)viewMap.get(dimNumber);
                Set memberSet = leftMemberScope.computeIfAbsent(dimNumber, a -> new HashSet(10));
                memberSet.addAll(AnalyzeRangeUtils.analyzeMemberConditionToMember((String)dimNumber, (Long)viewId, (List)memberList, (IModelCacheHelper)modelCache, (MemberPropCache)bizCtx.getMemberPropCache(), varValues, (DynamicObjectCollection)varList, (boolean)onlyLeafBoolean, (CustomAttributeRelationTypeEnum)bizCtx.getCustomAttributeRelationTypeEnum()));
                RuleFunctionUtils.removeCtControlMem((String)dimNumber, (Set)memberSet);
                if (!memberSet.isEmpty()) continue;
                log.warn("\u516c\u5f0f\u8303\u56f4\u65e0\u6210\u5458\uff0c\u8bf7\u68c0\u67e5\u6216\u8005\u7981\u7528\u8be5\u516c\u5f0f:" + ruleDto.getNumber());
            }
        }
        LinkedHashMap sortMap = Maps.newLinkedHashMap();
        leftMemberScope.entrySet().stream().sorted(Comparator.comparingInt(e -> ((Set)e.getValue()).size())).forEachOrdered(e -> sortMap.put(memberCache.valueOf(e.getKey()), Collections.unmodifiableSet((Set)memberCache.valueOf(e.getValue()))));
        return Collections.unmodifiableMap(sortMap);
    }

    private void setFormulaMember(QueryRuleDtoBizContext bizCtx) {
        DynamicObject[] ruleDynamicObjectArray;
        QFilter qf = new QFilter("ruleid", "in", bizCtx.getDtos().stream().map(RuleDto::getId).collect(Collectors.toSet()));
        String fieldFormula = "id,ruleid,isleft,memberkey,aggtype,periodshift,dimenstionjsonfix,dimenstionjsonvar";
        for (DynamicObject formulaDo : ruleDynamicObjectArray = BusinessDataServiceHelper.load((String)"eb_bizrulesetacc", (String)fieldFormula, (QFilter[])qf.toArray())) {
            long ruleId = formulaDo.getLong("ruleid");
            String memberKey = formulaDo.getString("memberkey");
            int aggType = formulaDo.getInt("aggtype");
            boolean periodshift = formulaDo.getBoolean("periodshift");
            String dimenstionJsonFix = formulaDo.getString("dimenstionjsonfix");
            if (!StringUtils.isNotBlank((CharSequence)dimenstionJsonFix)) continue;
            List<FormulaMemberDto> formulaMemberDtos = JSON.parseArray((String)dimenstionJsonFix, FormulaMemberDto.class);
            if (formulaDo.getBoolean("isLeft")) {
                bizCtx.getLeftMemberObjs().put(ruleId, formulaMemberDtos);
                continue;
            }
            LinkedHashMap<String, Set<String>> refMemberMap = new LinkedHashMap<String, Set<String>>();
            formulaMemberDtos = formulaMemberDtos.stream().filter(dto -> {
                boolean isBP = SysDimensionEnum.BudgetPeriod.getNumber().equals(dto.getDimNumber());
                boolean isPeriodVariable = dto.getVariable();
                boolean emptyNumber = StringUtils.isBlank((CharSequence)dto.getNumber());
                boolean isVar = dto.getNumber() != null && dto.getNumber().startsWith("@");
                return !isBP || !isPeriodVariable && !emptyNumber && !isVar;
            }).collect(Collectors.toList());
            for (FormulaMemberDto formulaMemberDto : formulaMemberDtos) {
                refMemberMap.computeIfAbsent(formulaMemberDto.getDimNumber(), v -> new LinkedHashSet()).add(formulaMemberDto.getNumber());
            }
            RuleRightItemDto ruleRightItemDto = new RuleRightItemDto(memberKey, aggType, periodshift, formulaMemberDtos, refMemberMap);
            FormulaMemberDto targetFormulaMemberDto = (FormulaMemberDto)LambdaUtils.getTarget(formulaMemberDtos, item -> SysDimensionEnum.Account.getNumber().equals(item.getDimNumber()));
            if (targetFormulaMemberDto != null) {
                ruleRightItemDto.setDataSetId(bizCtx.getModelCache().getMember(SysDimensionEnum.Account.getNumber(), null, targetFormulaMemberDto.getNumber()).getDatasetId());
            }
            bizCtx.getRightMemberObjs().computeIfAbsent(ruleId, e -> new ArrayList(10)).add(ruleRightItemDto);
        }
    }

    private void setOffsetMap(RuleDto obj) {
        if (StringUtils.isNotBlank((CharSequence)obj.getPeriodOffset())) {
            Map periodoffsetMap = (Map)JsonUtils.readValue((String)obj.getPeriodOffset(), (TypeReference)new TypeReference<Map<String, Long>>(){});
            if (periodoffsetMap.isEmpty()) {
                return;
            }
            Collection varIds = periodoffsetMap.values();
            Map varMap = BusinessDataServiceHelper.loadFromCache((Object[])varIds.toArray(), (String)"eb_periodvariable");
            HashMap offsetMap = new HashMap(16);
            periodoffsetMap.forEach((k, v) -> {
                DynamicObject varDo = (DynamicObject)varMap.get(v);
                if (varDo != null) {
                    offsetMap.put(k, varDo.getInt("offset"));
                }
            });
            if (!offsetMap.isEmpty()) {
                obj.setOffsetMap(offsetMap);
            }
        }
    }

    private List<RuleFunction> queryFunctionByRuleId(Collection<Long> ids) {
        DynamicObject[] functionArr;
        ArrayList<RuleFunction> functions = new ArrayList<RuleFunction>(ids.size());
        for (DynamicObject obj : functionArr = BusinessDataServiceHelper.load((String)"eb_rulefunctionsentity", (String)"ruleid,functionshowstr,functionkey,functioninfostr,functiontype", (QFilter[])new QFilter("ruleid", "in", ids).toArray())) {
            RuleFunction ruleFunction = RuleFunctionFactory.getFunction((String)obj.getString("functionkey"), (String)obj.getString("functionInfoStr"), (String)obj.getString("functiontype"));
            ruleFunction.setBizRuleId(obj.getLong("ruleid"));
            ruleFunction.setFunctionShowStr(obj.getString("functionshowstr"));
            functions.add(ruleFunction);
        }
        return functions;
    }

    private static class InnerClass {
        private static RuleService instance = new RuleService();

        private InnerClass() {
        }
    }
}

