/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.bizrule;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.graph.MutableGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.olap.impl.bizrule.entity.RuleBo;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.impl.bizrule.entity.RuleNodeBo;
import kd.epm.eb.olap.impl.bizrule.entity.RuleRightItemDto;
import kd.epm.eb.olap.service.request.AlgoCalcRequest;
import kd.epm.eb.olap.utils.RuleGraphUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class RuleTraceHelper {
    private static final Log log = LogFactory.getLog(RuleTraceHelper.class);

    public static void findExecuteRules(RuleTraceContext ctx) {
        log.info("\u62c6\u5206\u89c4\u5219start");
        ArrayList rowRuleList = Lists.newArrayListWithExpectedSize((int)12);
        RuleBo startRule = ctx.getStartRule();
        Map offsetMap = startRule.getRuleDto().getOffsetMap();
        HashSet<String> bpSet = new HashSet<String>((Collection)ctx.getLeftScope().get(SysDimensionEnum.BudgetPeriod.getNumber()));
        boolean reverse = false;
        for (RuleDto beMatchRule : ctx.getBeMatchRules()) {
            boolean hasOffset;
            Set<String> set = (Set<String>)beMatchRule.getLeftMembers().get(SysDimensionEnum.BudgetPeriod.getNumber());
            boolean bl = hasOffset = MapUtils.isNotEmpty((Map)beMatchRule.getOffsetMap()) || beMatchRule.getFormulaString().contains("PeriodShift");
            if (hasOffset && CollectionUtils.isEmpty((Collection)set)) {
                set = ctx.getAllMemCache(SysDimensionEnum.BudgetPeriod.getNumber());
            }
            if (CollectionUtils.isNotEmpty((Collection)set)) {
                bpSet.addAll(set);
            }
            if (reverse || beMatchRule.getOffsetMap() == null || !beMatchRule.getOffsetMap().values().stream().anyMatch(offset -> offset > 0)) continue;
            reverse = true;
        }
        List sortedBpSet = bpSet.stream().sorted(String::compareTo).collect(Collectors.toList());
        if (reverse) {
            Collections.reverse(sortedBpSet);
        }
        if (sortedBpSet.isEmpty()) {
            return;
        }
        LinkedHashMap mergeScope = Maps.newLinkedHashMap();
        kd.epm.eb.common.utils.MapUtils.mergeMap(ctx.getLeftScope(), (Map)mergeScope);
        for (String minStartBp : sortedBpSet) {
            LinkedHashMap exeScope = Maps.newLinkedHashMap();
            mergeScope.forEach((k, v) -> {
                exeScope.put(k, new HashSet(v));
                if (SysDimensionEnum.BudgetPeriod.getNumber().equals(k)) {
                    HashSet<String> minStartBpSet = new HashSet<String>();
                    minStartBpSet.add(minStartBp);
                    exeScope.put(k, minStartBpSet);
                }
            });
            Long dsId = ctx.getModelCache().getMember(SysDimensionEnum.Account.getNumber(), null, ctx.getLeftScope().get(SysDimensionEnum.Account.getNumber()).iterator().next()).getDatasetId();
            AlgoCalcRequest calcRequest = new AlgoCalcRequest(ctx.getModelCache().getModelobj().getId(), dsId, ctx.getViewMap(), exeScope, Collections.singletonList(startRule.getRuleDto()));
            String ruleId = startRule.getId().toString() + "_" + minStartBp;
            RuleNodeBo beginRule = new RuleNodeBo(ruleId, startRule.getRuleDto(), calcRequest);
            ArrayList rightRules = Lists.newArrayListWithExpectedSize((int)10);
            RuleTraceHelper.findRightRules(ctx, beginRule, rightRules);
            if (!ctx.getReadyRuleSet().contains(beginRule.getRuleId())) {
                rightRules.add(beginRule);
            }
            if (rightRules.isEmpty()) continue;
            rightRules.removeIf(e -> e.getRuleId().equals(beginRule.getRuleId()));
            rightRules.add(0, beginRule);
            rowRuleList.add(rightRules);
        }
        ctx.setRowRuleList(rowRuleList);
        log.info("\u62c6\u5206\u89c4\u5219end");
    }

    public static void findRightRules(RuleTraceContext ctx, RuleNodeBo currRule, List<RuleNodeBo> rightRules) {
        Map<String, Set<String>> leftScope = currRule.getCalcRequest().getMemberInfo();
        List<RuleNodeBo> matchRules = RuleTraceHelper.matchRules(leftScope, ctx, currRule);
        if (!matchRules.isEmpty()) {
            rightRules.addAll(matchRules);
        }
    }

    private static List<RuleNodeBo> matchRules(Map<String, Set<String>> preLeftScope, RuleTraceContext ctx, RuleNodeBo currRule) {
        IModelCacheHelper modelCache = ctx.getModelCache();
        List beMatchRules = ctx.beMatchRules;
        HashMap newPreLeftScope = Maps.newHashMapWithExpectedSize((int)preLeftScope.size());
        kd.epm.eb.common.utils.MapUtils.mergeMap(preLeftScope, (Map)newPreLeftScope);
        ArrayList ruleList = Lists.newArrayList();
        HashMap successorBpMap = Maps.newHashMapWithExpectedSize((int)(beMatchRules.size() - 1));
        MutableGraph<Long> graph = RuleGraphUtils.buildDagGraph(beMatchRules);
        while (!graph.nodes().isEmpty()) {
            Set zeroNodes = graph.nodes().stream().filter(node -> graph.inDegree(node) == 0).collect(Collectors.toSet());
            if (!CollectionUtils.isNotEmpty(zeroNodes)) continue;
            List<RuleDto> zeroRules = beMatchRules.stream().filter(ruleDto -> zeroNodes.contains(ruleDto.getId())).collect(Collectors.toList());
            for (RuleDto rule : zeroRules) {
                if (rule.getId().equals(currRule.getRuleDto().getId())) continue;
                for (RuleRightItemDto rightItemDto : rule.getRuleRightItemDto()) {
                    Map<String, Set<String>> refMemberMap = rightItemDto.getRefMemberMap();
                    refMemberMap.forEach((k, v) -> {
                        Set ruleMemSet;
                        if (newPreLeftScope.containsKey(k) && CollectionUtils.isNotEmpty((Collection)(ruleMemSet = (Set)rule.getLeftMembers().get(k)))) {
                            ((Set)newPreLeftScope.get(k)).addAll(ruleMemSet);
                        }
                    });
                }
                LinkedHashMap ruleExeScope = Maps.newLinkedHashMap();
                Map ruleScope = rule.getLeftMembers();
                for (RuleRightItemDto rightItemDto : rule.getRuleRightItemDto()) {
                    LinkedHashMap itemRightScope = Maps.newLinkedHashMap();
                    Map<String, Set<String>> itemRefMemberMap = rightItemDto.getRefMemberMap();
                    Long rightDataSetId = rightItemDto.getDataSetId();
                    List rightDimensionList = modelCache.getDimensionList(rightDataSetId);
                    for (Dimension rDim : rightDimensionList) {
                        Map itemRightMemberMap;
                        Set itemSet;
                        Set suBpSet;
                        String rDimNumber = rDim.getNumber();
                        if (!newPreLeftScope.containsKey(rDimNumber)) {
                            itemRightScope.clear();
                            break;
                        }
                        HashSet preMemSet = (HashSet)newPreLeftScope.get(rDimNumber);
                        if (SysDimensionEnum.BudgetPeriod.getNumber().equals(rDimNumber) && (suBpSet = (Set)successorBpMap.get(rule.getId())) != null) {
                            preMemSet = new HashSet(suBpSet);
                        }
                        if (CollectionUtils.isEmpty((Collection)(itemSet = (Set)(itemRightMemberMap = (Map)rule.getRightMembers().get(rightItemDto.getMemberKey())).get(rDimNumber)))) {
                            itemSet = (Set)ruleScope.get(rDimNumber);
                        }
                        if (SysDimensionEnum.BudgetPeriod.getNumber().equals(rDimNumber) && rightItemDto.getPeriodOffset() != null && rightItemDto.getPeriodOffset() != 0) {
                            Set bpSet = (Set)ruleScope.get(SysDimensionEnum.BudgetPeriod.getNumber());
                            if (bpSet == null) {
                                itemRightScope.put(rDimNumber, preMemSet);
                                continue;
                            }
                            HashSet bpNewSet = Sets.newHashSet();
                            for (String bp : bpSet) {
                                Member bpMember = modelCache.getMemberOffset(SysDimensionEnum.BudgetPeriod.getNumber(), bp, rightItemDto.getPeriodOffset().intValue());
                                if (bpMember == null) continue;
                                bpNewSet.add(bpMember.getNumber());
                            }
                            Set interSet = bpNewSet.stream().filter(preMemSet::contains).collect(Collectors.toSet());
                            if (interSet.isEmpty()) {
                                itemRightScope.clear();
                                break;
                            }
                            itemRightScope.put(rDimNumber, interSet);
                            continue;
                        }
                        if (CollectionUtils.isEmpty((Collection)itemSet)) {
                            itemRightScope.put(rDimNumber, preMemSet);
                            continue;
                        }
                        Set interSet = itemSet.stream().filter(preMemSet::contains).collect(Collectors.toSet());
                        if (interSet.isEmpty()) {
                            itemRightScope.clear();
                            break;
                        }
                        itemRightScope.put(rDimNumber, interSet);
                    }
                    if (MapUtils.isEmpty((Map)itemRightScope)) continue;
                    Integer itemOffset = (Integer)rule.getOffsetMap().get(rightItemDto.getMemberKey());
                    boolean itemHasOffSet = itemOffset != null && itemOffset != 0;
                    HashMap returnBackLeftTrimRange = Maps.newHashMapWithExpectedSize((int)itemRightScope.size());
                    List dimensionList = modelCache.getDimensionList(rule.getDataSetId());
                    for (Dimension leftDimension : dimensionList) {
                        String dimNumber = leftDimension.getNumber();
                        Set rightMemSet = (Set)itemRightScope.get(dimNumber);
                        Set ruleMemSet = (Set)ruleScope.get(dimNumber);
                        if (itemHasOffSet && SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) {
                            HashSet bpNewSet = Sets.newHashSet();
                            boolean hasNullBp = false;
                            for (String bp : rightMemSet) {
                                Member bpMember = modelCache.getMemberOffset(SysDimensionEnum.BudgetPeriod.getNumber(), bp, -rightItemDto.getPeriodOffset().intValue());
                                if (bpMember == null) {
                                    hasNullBp = true;
                                    break;
                                }
                                bpNewSet.add(bpMember.getNumber());
                            }
                            if (hasNullBp) {
                                returnBackLeftTrimRange.clear();
                                ruleExeScope.clear();
                                break;
                            }
                            returnBackLeftTrimRange.put(dimNumber, bpNewSet);
                            continue;
                        }
                        if (!itemRightScope.containsKey(dimNumber)) {
                            returnBackLeftTrimRange.put(dimNumber, ruleMemSet);
                            continue;
                        }
                        if (itemRefMemberMap.get(dimNumber) == null) {
                            returnBackLeftTrimRange.put(dimNumber, rightMemSet);
                            continue;
                        }
                        returnBackLeftTrimRange.put(dimNumber, ruleMemSet);
                    }
                    kd.epm.eb.common.utils.MapUtils.mergeMap((Map)returnBackLeftTrimRange, (Map)ruleExeScope);
                }
                if (MapUtils.isEmpty((Map)ruleExeScope)) continue;
                List bpList = ((Set)ruleExeScope.get(SysDimensionEnum.BudgetPeriod.getNumber())).stream().sorted(String::compareTo).collect(Collectors.toList());
                String ruleId = rule.getId().toString() + "_" + (String)bpList.get(0);
                if (!ctx.getReadyRuleSet().add(ruleId)) continue;
                Long dsId = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, (String)((Set)ruleExeScope.get(SysDimensionEnum.Account.getNumber())).iterator().next()).getDatasetId();
                AlgoCalcRequest calcRequest = new AlgoCalcRequest(modelCache.getModelobj().getId(), dsId, ctx.getViewMap(), ruleExeScope, Collections.singletonList(rule));
                ruleList.add(new RuleNodeBo(ruleId, rule, calcRequest));
                Set successors = graph.successors((Object)rule.getId());
                for (Long successor : successors) {
                    successorBpMap.computeIfAbsent(successor, v -> Sets.newHashSetWithExpectedSize((int)2)).addAll(bpList);
                }
            }
            zeroRules.forEach(e -> graph.removeNode((Object)e.getId()));
        }
        return ruleList;
    }

    public static class RuleTraceContext {
        private Map<String, Set<String>> leftScope;
        private Map<String, Long> viewMap;
        private List<RuleDto> beMatchRules;
        private RuleBo startRule;
        private boolean skipAgg;
        private IModelCacheHelper modelCache;
        private Set<String> readyRuleSet = new HashSet<String>(16);
        private Set<String> totalBpMemberSet = new HashSet<String>(1);
        private List<List<RuleNodeBo>> rowRuleList = new ArrayList<List<RuleNodeBo>>(10);
        private Map<String, Set<String>> allMemCache = new HashMap<String, Set<String>>(16);

        public RuleTraceContext(Map<String, Set<String>> leftScope, List<RuleDto> beMatchRules, RuleBo startRule, IModelCacheHelper modelCache) {
            this.leftScope = leftScope;
            this.beMatchRules = beMatchRules;
            this.startRule = startRule;
            this.modelCache = modelCache;
        }

        public Map<String, Set<String>> getLeftScope() {
            return this.leftScope;
        }

        public void setLeftScope(Map<String, Set<String>> leftScope) {
            this.leftScope = leftScope;
        }

        public Map<String, Long> getViewMap() {
            return this.viewMap;
        }

        public void setViewMap(Map<String, Long> viewMap) {
            this.viewMap = viewMap;
        }

        public List<RuleDto> getBeMatchRules() {
            return this.beMatchRules;
        }

        public void setBeMatchRules(List<RuleDto> beMatchRules) {
            this.beMatchRules = beMatchRules;
        }

        public RuleBo getStartRule() {
            return this.startRule;
        }

        public boolean isSkipAgg() {
            return this.skipAgg;
        }

        public void setSkipAgg(boolean skipAgg) {
            this.skipAgg = skipAgg;
        }

        public IModelCacheHelper getModelCache() {
            return this.modelCache;
        }

        public void setModelCache(IModelCacheHelper modelCache) {
            this.modelCache = modelCache;
        }

        public Set<String> getReadyRuleSet() {
            return this.readyRuleSet;
        }

        public void setRowRuleList(List<List<RuleNodeBo>> rowRuleList) {
            this.rowRuleList = rowRuleList;
        }

        public List<List<RuleNodeBo>> getRowRuleList() {
            return this.rowRuleList;
        }

        public Set<String> getTotalBpMemberSet() {
            if (this.totalBpMemberSet.isEmpty()) {
                Dimension bpDimension = this.modelCache.getDimension(SysDimensionEnum.BudgetPeriod.getNumber());
                this.totalBpMemberSet = bpDimension.getAllMembers().stream().map(BaseCache::getNumber).collect(Collectors.toSet());
            }
            return this.totalBpMemberSet;
        }

        public Set<String> getAllMemCache(String dimNumber) {
            Set<String> cacheSet = this.allMemCache.get(dimNumber);
            if (CollectionUtils.isEmpty(cacheSet)) {
                Dimension dimension = this.modelCache.getDimension(dimNumber);
                cacheSet = dimension.getAllMembers().stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                this.allMemCache.put(dimNumber, cacheSet);
            }
            return cacheSet;
        }
    }
}

