/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.bizrule.context;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.cache.utils.ObjectCache;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.AggOprtEnum;
import kd.epm.eb.common.f7.MemberCondition;
import kd.epm.eb.common.pojo.CustomAttributeRelationTypeEnum;
import kd.epm.eb.olap.impl.bizrule.entity.FormulaMemberDto;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.impl.bizrule.entity.RuleRightItemDto;

public class QueryRuleDtoBizContext {
    private Long modelId;
    private Long businessModelId;
    private IModelCacheHelper modelCache;
    private MemberPropCache memberPropCache;
    private Map<String, Long> viewMap;
    private List<RuleDto> dtos;
    private CustomAttributeRelationTypeEnum customAttributeRelationTypeEnum;
    private ObjectCache memberCache = new ObjectCache();
    private Map<String, Set<String>> pubMemberCache = new HashMap<String, Set<String>>(16);
    private Map<Long, List<FormulaMemberDto>> leftMemberObjs = new HashMap<Long, List<FormulaMemberDto>>(16);
    private Map<Long, List<RuleRightItemDto>> rightMemberObjs = new HashMap<Long, List<RuleRightItemDto>>(16);

    public QueryRuleDtoBizContext() {
    }

    public QueryRuleDtoBizContext(Long modelId, IModelCacheHelper modelCache, MemberPropCache memberPropCache) {
        this.modelId = modelId;
        this.modelCache = modelCache;
        this.memberPropCache = memberPropCache;
    }

    public Long getModelId() {
        return this.modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public IModelCacheHelper getModelCache() {
        return this.modelCache;
    }

    public void setModelCache(IModelCacheHelper modelCache) {
        this.modelCache = modelCache;
    }

    public MemberPropCache getMemberPropCache() {
        return this.memberPropCache;
    }

    public void setMemberPropCache(MemberPropCache memberPropCache) {
        this.memberPropCache = memberPropCache;
    }

    public Map<String, Long> getViewMap() {
        return this.viewMap;
    }

    public void setViewMap(Map<String, Long> viewMap) {
        this.viewMap = viewMap;
    }

    public Map<Long, List<FormulaMemberDto>> getLeftMemberObjs() {
        return this.leftMemberObjs;
    }

    public void setLeftMemberObjs(Map<Long, List<FormulaMemberDto>> leftMemberObjs) {
        this.leftMemberObjs = leftMemberObjs;
    }

    public Map<Long, List<RuleRightItemDto>> getRightMemberObjs() {
        return this.rightMemberObjs;
    }

    public void setRightMemberObjs(Map<Long, List<RuleRightItemDto>> rightMemberObjs) {
        this.rightMemberObjs = rightMemberObjs;
    }

    public List<RuleDto> getDtos() {
        return this.dtos;
    }

    public void setDtos(List<RuleDto> dtos) {
        this.dtos = dtos;
    }

    public CustomAttributeRelationTypeEnum getCustomAttributeRelationTypeEnum() {
        return this.customAttributeRelationTypeEnum;
    }

    public void setCustomAttributeRelationTypeEnum(CustomAttributeRelationTypeEnum customAttributeRelationTypeEnum) {
        this.customAttributeRelationTypeEnum = customAttributeRelationTypeEnum;
    }

    public Long getBusinessModelId() {
        return this.businessModelId;
    }

    public void setBusinessModelId(Long businessModelId) {
        this.businessModelId = businessModelId;
    }

    public ObjectCache getMemberCache() {
        return this.memberCache;
    }

    public void setMemberCache(ObjectCache memberCache) {
        this.memberCache = memberCache;
    }

    public Set<String> getPubMemberCache(String dimNumber, String memberNumber, int rangeIndex, Long viewId) {
        MemberCondition memberCondition = new MemberCondition(memberNumber, String.valueOf(rangeIndex));
        memberCondition.setViewIdLong(viewId);
        return this.getPubMemberCache(dimNumber, memberCondition);
    }

    public Set<String> getPubMemberCache(String dimNumber, MemberCondition memberCondition) {
        String memberNumber = memberCondition.getNumber();
        String range = memberCondition.getRange();
        Long viewId = memberCondition.getViewIdLong();
        if (viewId == null) {
            viewId = 0L;
        }
        String cacheKey = this.buildCacheKey(dimNumber, "memb", memberNumber, String.valueOf(memberCondition.getRange()), viewId);
        if (memberCondition.isProp()) {
            cacheKey = this.buildCacheKey(dimNumber, "prop", memberNumber, String.valueOf(memberCondition.getRange()), viewId);
        }
        Long finalViewId = viewId;
        return this.pubMemberCache.computeIfAbsent(cacheKey, v -> {
            if (memberCondition.isProp()) {
                CustomPropertyValue customPropertyValue = this.memberPropCache.getPropertyValue(dimNumber, memberCondition.getLongnumber());
                List propMemberList = MemberPropCache.getMembersByPropValues((IModelCacheHelper)this.modelCache, (MemberPropCache)this.memberPropCache, (Long)finalViewId, (CustomPropertyValue)customPropertyValue);
                return propMemberList.stream().map(e -> (String)this.memberCache.valueOf((Object)e.getNumber())).collect(Collectors.toSet());
            }
            List member = this.modelCache.getMemberIncludeCosmic(dimNumber, finalViewId, memberNumber, Integer.parseInt(range));
            return member.stream().filter(e -> {
                if (e.getNumber().equals(memberNumber)) {
                    return true;
                }
                return !AggOprtEnum.SKIP.getSign().equals(e.getAggType());
            }).map(e -> (String)this.memberCache.valueOf((Object)e.getNumber())).collect(Collectors.toSet());
        });
    }

    private String buildCacheKey(String dimNumber, String type, String memberNumber, String rangeEnum, Long viewId) {
        return "cache`" + dimNumber + "#" + viewId + "#" + type + "#" + memberNumber + '#' + rangeEnum;
    }
}

