/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute.impl.expr.expr;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.enums.AggType;
import kd.epm.eb.common.rule.edit.ToolEnum;
import kd.epm.eb.olap.impl.execute.RuleEnlargeEvaluator;
import kd.epm.eb.olap.impl.execute.face.IExpress;
import kd.epm.eb.olap.impl.execute.impl.CheckEnvironment;
import kd.epm.eb.olap.impl.execute.impl.Environment;
import kd.epm.eb.olap.impl.execute.impl.Evaluator;
import kd.epm.eb.olap.impl.execute.impl.expr.FunReturnType;
import kd.epm.eb.olap.impl.execute.impl.expr.ParseUtils;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.AbstractFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.MdxMemberExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.SetFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.SingleMemberExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanel;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanelType;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.PanelEnvironment;

public class AVGRangeFun
extends AbstractFun {
    private List<IExpress> args;

    public List<IExpress> getChildren() {
        return this.args;
    }

    public String toMdx(Environment env) {
        String memberMdx = ((MdxMemberExpr)this.args.get(0)).toMdx(env, true);
        SetFun setFun = (SetFun)this.args.get(1);
        String setMdx = setFun.toMdx(env);
        if (setFun instanceof SingleMemberExpr) {
            setMdx = "{" + setMdx + "}";
        }
        setMdx = "Distinct(" + setMdx + ")";
        if (memberMdx.isEmpty()) {
            return "Avg({" + setMdx + "})";
        }
        return "Avg({" + setMdx + '*' + memberMdx + "})";
    }

    public List<ExprPanel> toPanel(PanelEnvironment env) {
        LinkedList panels = Lists.newLinkedList();
        int seq = 0;
        ExprPanel panel1 = new ExprPanel(this.getFunKey() + seq, ExprPanelType.String, false);
        panel1.addShowStringAndValue("@AVGRange(", null);
        panel1.addBackStageKeyAndSeq(this.getFunKey(), seq++);
        panels.add(panel1);
        for (int i = 0; i < this.args.size(); ++i) {
            if (i != 0) {
                ExprPanel panel = new ExprPanel(this.getFunKey() + seq, ExprPanelType.String, false);
                panel.addShowStringAndValue(",", null);
                panel.addBackStageKeyAndSeq(this.getFunKey(), seq++);
                panels.add(panel);
            }
            panels.addAll(this.args.get(i).toPanel(env));
        }
        ExprPanel panel3 = new ExprPanel(this.getFunKey() + seq, ExprPanelType.String, false);
        panel3.addShowStringAndValue(")", null);
        panel3.addBackStageKeyAndSeq(this.getFunKey(), seq);
        panels.add(panel3);
        return panels;
    }

    public String toShrekString(Environment env) {
        throw new KDBizException("unsupported toShrek");
    }

    public Map<String, Set<String>> analyzeRange(Map<String, Set<String>> leftRange, Evaluator evaluator) {
        Map<String, Set<String>> rangeMap;
        Map newLeftRange = this.getNewLeftRange(leftRange);
        Map<String, Set<String>> setMap = null;
        try {
            setMap = this.args.get(1).analyzeRange(newLeftRange, evaluator);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String dimNumber = ((SetFun)this.args.get(1)).getDimNumber();
        Map<String, Set<String>> leftRange2 = newLeftRange.entrySet().stream().filter(k -> !((String)k.getKey()).equals(dimNumber)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (n1, n2) -> n2));
        if (setMap != null && setMap.containsKey(dimNumber)) {
            leftRange2.put(dimNumber, setMap.get(dimNumber));
        }
        if ((rangeMap = this.args.get(0).analyzeRange(leftRange2, evaluator)).isEmpty()) {
            return rangeMap;
        }
        rangeMap.put(dimNumber, leftRange.get(dimNumber));
        return rangeMap;
    }

    public Set<String> checkRuleEnlarge(RuleEnlargeEvaluator evaluator) {
        Set<String> args0 = this.args.get(0).checkRuleEnlarge(evaluator);
        Set<String> args1 = this.args.get(1).checkRuleEnlarge(evaluator);
        return this.getRuleEnlarge(args0, args1);
    }

    public void doCheck(CheckEnvironment env) {
        env.setParentToolEnum(ToolEnum.AVGRange);
        this.args.get(0).doCheck(env);
        SetFun setFun = (SetFun)this.args.get(1);
        setFun.doCheck(env);
        ParseUtils.checkReturnIsNumber((IExpress)this.args.get(0), (CheckEnvironment)env);
        env.addFunKeyRefMemKey(setFun.getFunKey(), ((MdxMemberExpr)this.args.get(0)).getName());
        env.addFunKeyRefParentFunKey(setFun.getFunKey(), this.getFunKey());
        env.addMemberAggType(((MdxMemberExpr)this.args.get(0)).getName(), AggType.AVG.getIndex());
        env.checkFunAndMemberRefDim(setFun.getFunKey(), ((MdxMemberExpr)this.args.get(0)).getName());
        env.setParentToolEnum(null);
    }

    public FunReturnType getReturnType() {
        return FunReturnType.Numeric;
    }

    public List<IExpress> getArgs() {
        return this.args;
    }

    public void setArgs(List<IExpress> args) {
        this.args = args;
    }
}

