/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute.impl.expr.expr;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.olap.impl.execute.RuleEnlargeEvaluator;
import kd.epm.eb.olap.impl.execute.face.IExpress;
import kd.epm.eb.olap.impl.execute.impl.CheckEnvironment;
import kd.epm.eb.olap.impl.execute.impl.Environment;
import kd.epm.eb.olap.impl.execute.impl.Evaluator;
import kd.epm.eb.olap.impl.execute.impl.expr.FunReturnType;
import kd.epm.eb.olap.impl.execute.impl.expr.ParseUtils;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.AbstractFun;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanel;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanelType;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.PanelEnvironment;

public class AbsFun
extends AbstractFun {
    private IExpress express;

    public List<IExpress> getChildren() {
        return Lists.newArrayList((Object[])new IExpress[]{this.express});
    }

    public IExpress getExpress() {
        return this.express;
    }

    public void setExpress(IExpress express) {
        this.express = express;
    }

    public String toMdx(Environment env) {
        StringBuilder stringBuilder = new StringBuilder("Abs(");
        stringBuilder.append(this.express.toMdx(env));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public List<ExprPanel> toPanel(PanelEnvironment env) {
        LinkedList exprPanelList = Lists.newLinkedList();
        LambdaUtils.run(() -> {
            ExprPanel exprPanel = new ExprPanel(GlobalIdUtil.genStringId(), ExprPanelType.String, false);
            exprPanel.addShowStringAndValue("@ABS(", null);
            exprPanel.addBackStageKeyAndSeq(exprPanel.getKey(), 0);
            exprPanelList.add(exprPanel);
        });
        exprPanelList.addAll(this.express.toPanel(env));
        LambdaUtils.run(() -> {
            ExprPanel exprPanel = new ExprPanel(GlobalIdUtil.genStringId(), ExprPanelType.String, false);
            exprPanel.addShowStringAndValue(")", null);
            exprPanel.addBackStageKeyAndSeq(exprPanel.getKey(), 0);
            exprPanelList.add(exprPanel);
        });
        return exprPanelList;
    }

    public String toShrekString(Environment env) {
        StringBuilder stringBuilder = new StringBuilder("abs(");
        stringBuilder.append(this.express.toShrekString(env));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public Map<String, Set<String>> analyzeRange(Map<String, Set<String>> leftRange, Evaluator evaluator) {
        return this.express.analyzeRange(this.getNewLeftRange(leftRange), evaluator);
    }

    public Set<String> checkRuleEnlarge(RuleEnlargeEvaluator evaluator) {
        return this.express.checkRuleEnlarge(evaluator);
    }

    public void doCheck(CheckEnvironment env) {
        this.express.doCheck(env);
        ParseUtils.checkReturnIsNumber((IExpress)this.express, (CheckEnvironment)env);
    }

    public FunReturnType getReturnType(CheckEnvironment env) {
        return this.express.getReturnType(env);
    }

    public FunReturnType getReturnType() {
        return this.express.getReturnType();
    }

    public boolean checkRightHasNumber() {
        return this.express.checkRightHasNumber();
    }
}

