/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute.impl.expr.expr;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.entity.property.CustomProperty;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.rule.edit.ToolEnum;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.olap.impl.execute.face.IExpress;
import kd.epm.eb.olap.impl.execute.impl.CheckEnvironment;
import kd.epm.eb.olap.impl.execute.impl.Environment;
import kd.epm.eb.olap.impl.execute.impl.Evaluator;
import kd.epm.eb.olap.impl.execute.impl.ParseExceptionCatcher;
import kd.epm.eb.olap.impl.execute.impl.expr.ParseUtils;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.AttributeValueExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.GetAttributeFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.RangeMemberSetFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.SetFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.SingleMemberExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanel;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanelType;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.PanelEnvironment;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

public class AttributeFun
extends SetFun {
    private SetFun setFun;
    private String attribute;
    private SetFun attributeValue;

    public List<IExpress> getChildren() {
        return Lists.newArrayList((Object[])new IExpress[]{this.setFun, this.attributeValue});
    }

    public void setSetExpr(SetFun setFun) {
        this.setFun = setFun;
    }

    public SetFun getSetExpr() {
        return this.setFun;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String getAttribute() {
        return this.attribute.substring(1, this.attribute.length() - 1);
    }

    public void setAttributeValue(SetFun attributeValue) {
        attributeValue.setDimNumber(this.getDimNumber());
        this.attributeValue = attributeValue;
    }

    public SetFun getAttributeValue() {
        return this.attributeValue;
    }

    public String toMdx(Environment env) {
        StringBuilder sb = new StringBuilder();
        String attribute = this.getAttribute();
        IModelCacheHelper modelCache = env.getModelCache();
        Long modelId = modelCache.getModelobj().getId();
        String dimNumber = this.getDimNumber();
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelId);
        Dimension dimension = env.getModelCache().getDimension(dimNumber);
        Long dimensionId = dimension.getId();
        Map viewMap = env.getRuleDto().getViewMap();
        Long viewId = (Long)viewMap.get(dimNumber);
        if (this.attributeValue instanceof GetAttributeFun) {
            sb.append("Intersect(");
            String str = this.setFun.toMdx(env);
            if (this.setFun instanceof SingleMemberExpr) {
                str = "{" + str + "}";
            }
            sb.append(str).append(',');
            CustomProperty property = memberPropCache.getProperty(dimNumber, attribute);
            List propertyValuesByDim = memberPropCache.getPropertyValuesByDim(dimensionId);
            List<Object> membersByPropValues = new ArrayList(16);
            if (CollectionUtils.isNotEmpty((Collection)propertyValuesByDim)) {
                List propertyValues = propertyValuesByDim.stream().filter(e -> e.getProp().getNumber().equals(property.getNumber())).map(CustomPropertyValue::getId).collect(Collectors.toList());
                membersByPropValues = memberPropCache.getMembersByPropValues(dimensionId, viewId, propertyValues);
                membersByPropValues = membersByPropValues.stream().distinct().collect(Collectors.toList());
            }
            String shortNumber = dimension.getShortNumber();
            String memberSetMdx = membersByPropValues.stream().map(e -> ParseUtils.genLongNumberMdx((String)dimension.getShortNumber(), (String)e.getLongNumber())).collect(Collectors.joining(",", "{", "}"));
            sb.append("MemberPropertiesFilter(").append(memberSetMdx);
            sb.append(',').append('`').append(shortNumber).append('`').append(".CurrentMember.Properties('").append(attribute).append("') = ").append(this.attributeValue.toMdx(env)).append(')');
            sb.append(')');
        } else if (this.attributeValue instanceof AttributeValueExpr) {
            AttributeValueExpr attributeValueExpr = (AttributeValueExpr)this.attributeValue;
            String attributeValue = attributeValueExpr.getAttributeValue();
            CustomPropertyValue propertyValue = memberPropCache.getPropertyValue(dimNumber, attribute, attributeValue);
            List membersByPropValues = memberPropCache.getMembersByPropValues(dimensionId, viewId, propertyValue.getId());
            if (this.setFun instanceof RangeMemberSetFun) {
                Set<String> rangeMembers = this.getRangeMembers(env);
                if (CollectionUtils.isEmpty((Collection)membersByPropValues) || CollectionUtils.isEmpty(rangeMembers)) {
                    sb.append("{}");
                } else {
                    Set proValMemberSet = membersByPropValues.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                    Sets.SetView intersection = Sets.intersection(rangeMembers, proValMemberSet);
                    if (CollectionUtils.isEmpty((Collection)intersection)) {
                        sb.append("{}");
                    } else {
                        List interMembers = modelCache.getMembers(dimension, viewId, (Collection)intersection);
                        String interMemberMdx = interMembers.stream().map(item -> ParseUtils.genLongNumberMdx((String)dimension.getShortNumber(), (String)item.getLongNumber())).collect(Collectors.joining(",", "{", "}"));
                        sb.append(interMemberMdx);
                    }
                }
            } else {
                sb.append("Filter(");
                String str = this.setFun.toMdx(env);
                if (this.setFun instanceof SingleMemberExpr) {
                    str = "{" + str + "}";
                }
                sb.append(str);
                sb.append(',').append('`').append(dimension.getShortNumber()).append('`').append(".CurrentMember.Properties('").append(attribute).append("') = ").append(propertyValue.getGlobalOrder()).append(')');
            }
        }
        env.addDimAttribute(this.getDimNumber(), attribute);
        return sb.toString();
    }

    public Set<String> getRangeMembers(Environment env) {
        Set<String> rangeMembers = new HashSet<String>(16);
        IModelCacheHelper modelCache = env.getModelCache();
        String dimNumber = this.getDimNumber();
        Long viewId = env.getRuleDto().getViewMap().getOrDefault(dimNumber, 0L);
        Dimension dimension = modelCache.getDimension(dimNumber);
        Map functionMap = env.getFunctionMap();
        RuleFunction ruleFunction = (RuleFunction)functionMap.get(this.getFunKey());
        String memberNumber = (String)ruleFunction.getValue("dimmemberrange");
        List memberConditionList = (List)SerializationUtils.deSerializeFromBase64((String)memberNumber);
        Set numberSet = (Set)LambdaUtils.get(() -> {
            Pair matchedAndNotMatchedListPair = LambdaUtils.getMatchedAndNotMatchedListPair((Collection)memberConditionList, item -> !Boolean.TRUE.equals(item.getRemoveBoolean()));
            List normalMemberConditionList = (List)matchedAndNotMatchedListPair.getLeft();
            Set normalMemberNumberStringSet = normalMemberConditionList.stream().map(item -> modelCache.getMember(dimNumber, viewId, item.getNumber(), Integer.parseInt(item.getRange())).stream().map(BaseCache::getNumber).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
            List removeMemberConditionList = (List)matchedAndNotMatchedListPair.getRight();
            if (CollectionUtils.isEmpty((Collection)removeMemberConditionList)) {
                return normalMemberNumberStringSet;
            }
            Set removeMemberNumberStringSet = removeMemberConditionList.stream().map(item -> modelCache.getMember(dimNumber, viewId, item.getNumber(), Integer.parseInt(item.getRange())).stream().map(BaseCache::getNumber).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toSet());
            normalMemberNumberStringSet.removeAll(removeMemberNumberStringSet);
            return normalMemberNumberStringSet;
        });
        if (SysDimensionEnum.BudgetPeriod.getNumber().equals(this.getDimNumber())) {
            List allMembers = env.getModelCache().getDimension(SysDimensionEnum.BudgetPeriod.getNumber()).getAllMemberSort();
            LinkedList filter = Lists.newLinkedList();
            for (Member member : allMembers) {
                if (!numberSet.contains(member.getNumber())) continue;
                filter.add(member);
            }
            rangeMembers = filter.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
        } else {
            List members = modelCache.getMembers(dimension, viewId, (Collection)numberSet);
            if (CollectionUtils.isNotEmpty((Collection)members)) {
                rangeMembers = members.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
            }
        }
        return rangeMembers;
    }

    public List<ExprPanel> toPanel(PanelEnvironment env) {
        LinkedList panels = Lists.newLinkedList();
        int seq = 0;
        ExprPanel panel1 = new ExprPanel(this.getFunKey() + seq, ExprPanelType.String, false);
        Dimension dimension = env.getModelCache().getDimension(this.getDimNumber());
        panel1.addShowStringAndValue("@Attribute(" + dimension.getName() + ",", null);
        panel1.addBackStageKeyAndSeq(this.getFunKey(), seq++);
        panels.add(panel1);
        panels.addAll(this.setFun.toPanel(env));
        MemberPropCache memberPropCache = env.getMemberPropCache();
        CustomProperty property = memberPropCache.getProperty(dimension.getNumber(), this.getAttribute());
        ExprPanel panel2 = new ExprPanel(this.getFunKey() + seq, ExprPanelType.String, false);
        panel2.addShowStringAndValue("," + property.getName() + ",", null);
        panel2.addBackStageKeyAndSeq(this.getFunKey(), seq++);
        panels.add(panel2);
        panels.addAll(this.attributeValue.toPanel(env));
        ExprPanel panel3 = new ExprPanel(this.getFunKey() + seq, ExprPanelType.String, false);
        panel3.addShowStringAndValue(")", null);
        panel3.addBackStageKeyAndSeq(this.getFunKey(), seq);
        panels.add(panel3);
        return panels;
    }

    public void doCheck(CheckEnvironment env) {
        String parentDimNumber;
        if (!ToolEnum.rangeFunctionBoolean((ToolEnum)env.getParentToolEnum())) {
            ParseExceptionCatcher.throwRangeException();
        }
        String currentFunDimNumber = this.getDimNumber();
        if (!env.getCurrentDataSetDimSet().contains(currentFunDimNumber)) {
            ParseExceptionCatcher.throwException4();
        }
        if (SysDimensionEnum.Account.getNumber().equals(currentFunDimNumber)) {
            ParseExceptionCatcher.throwAttributeUseAccountException();
        }
        env.addFunRefDimension(this.getFunKey(), currentFunDimNumber);
        IExpress parentExpress = env.getParentExpress();
        if (parentExpress != null && !currentFunDimNumber.equals(parentDimNumber = ParseUtils.getExpressDimNumber((IExpress)parentExpress))) {
            ParseExceptionCatcher.throwException2((String)parentDimNumber, (String)this.getDimNumber());
        }
        if (this.setFun != null) {
            env.setParentExpress((IExpress)((Object)this));
            this.setFun.doCheck(env);
            env.setParentExpress(null);
        }
        if (this.attributeValue != null) {
            env.setParentExpress((IExpress)((Object)this));
            this.attributeValue.doCheck(env);
            env.setParentExpress(null);
        }
    }

    public Map<String, Set<String>> analyzeRange(Map<String, Set<String>> leftRange, Evaluator evaluator) {
        Map newLeftRange = this.getNewLeftRange(leftRange);
        Map childResultMap = this.setFun.analyzeRange(newLeftRange, evaluator);
        Map child2ResultMap = this.attributeValue.analyzeRange(newLeftRange, evaluator);
        if (childResultMap != null && child2ResultMap != null && !child2ResultMap.isEmpty()) {
            for (Map.Entry entry : child2ResultMap.entrySet()) {
                Set members = childResultMap.computeIfAbsent(entry.getKey(), k -> new HashSet(16));
                members.addAll((Collection)entry.getValue());
            }
        }
        return childResultMap;
    }
}

