/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute.impl.expr.expr;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.enums.AggType;
import kd.epm.eb.common.rule.edit.ToolEnum;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.impl.execute.RuleEnlargeEvaluator;
import kd.epm.eb.olap.impl.execute.face.IExpress;
import kd.epm.eb.olap.impl.execute.impl.CheckEnvironment;
import kd.epm.eb.olap.impl.execute.impl.Environment;
import kd.epm.eb.olap.impl.execute.impl.Evaluator;
import kd.epm.eb.olap.impl.execute.impl.expr.FunReturnType;
import kd.epm.eb.olap.impl.execute.impl.expr.ParseUtils;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.AbstractFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.MdxMemberExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.SetFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.SingleMemberExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanel;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanelType;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.PanelEnvironment;
import org.apache.commons.collections4.CollectionUtils;

public class IRRFun
extends AbstractFun {
    private MdxMemberExpr arg0;
    private IExpress arg1;
    private IExpress arg2;

    public List<IExpress> getChildren() {
        return Lists.newArrayList((Object[])new IExpress[]{this.arg0, this.arg1, this.arg2});
    }

    public void setArg0(MdxMemberExpr arg0) {
        this.arg0 = arg0;
    }

    public void setArg1(IExpress arg1) {
        this.arg1 = arg1;
    }

    public void setArg2(IExpress arg2) {
        this.arg2 = arg2;
    }

    public MdxMemberExpr getArg0() {
        return this.arg0;
    }

    public IExpress getArg1() {
        return this.arg1;
    }

    public IExpress getArg2() {
        return this.arg2;
    }

    public String toMdx(Environment env) {
        String memberMdx = this.arg0.toMdx(env, true);
        String setMdx = this.arg1.toMdx(env);
        if (this.arg1 instanceof SingleMemberExpr) {
            setMdx = "{" + setMdx + "}";
        }
        setMdx = "Distinct(" + setMdx + ")";
        String numberMdx = "0.1";
        if (this.arg2 != null) {
            numberMdx = this.arg2.toMdx(env);
        }
        if (memberMdx.isEmpty()) {
            return "IRR({" + setMdx + "}," + numberMdx + ")";
        }
        return "IRR({" + setMdx + '*' + memberMdx + "}," + numberMdx + ")";
    }

    public String toShrekString(Environment env) {
        throw new KDBizException("unsupported toShrek");
    }

    public FunReturnType getReturnType() {
        return FunReturnType.Numeric;
    }

    public List<ExprPanel> toPanel(PanelEnvironment env) {
        LinkedList panels = Lists.newLinkedList();
        int seq = 0;
        ExprPanel panel1 = new ExprPanel(this.getFunKey() + seq, ExprPanelType.String, false);
        panel1.addShowStringAndValue("@IRR(", null);
        panel1.addBackStageKeyAndSeq(this.getFunKey(), seq++);
        panels.add(panel1);
        panels.addAll(this.arg0.toPanel(env));
        ExprPanel panel2 = new ExprPanel(this.getFunKey() + seq, ExprPanelType.String, false);
        panel2.addShowStringAndValue(",", null);
        panel2.addBackStageKeyAndSeq(this.getFunKey(), seq++);
        panels.add(panel2);
        panels.addAll(this.arg1.toPanel(env));
        if (this.arg2 != null) {
            ExprPanel panel3 = new ExprPanel(this.getFunKey() + seq, ExprPanelType.String, false);
            panel3.addShowStringAndValue(",", null);
            panel3.addBackStageKeyAndSeq(this.getFunKey(), seq++);
            panels.add(panel3);
            panels.addAll(this.arg2.toPanel(env));
            ExprPanel panel4 = new ExprPanel(this.getFunKey() + seq, ExprPanelType.String, false);
            panel4.addShowStringAndValue(")", null);
            panel4.addBackStageKeyAndSeq(this.getFunKey(), seq);
            panels.add(panel4);
        } else {
            ExprPanel panel3 = new ExprPanel(this.getFunKey() + seq, ExprPanelType.String, false);
            panel3.addShowStringAndValue(")", null);
            panel3.addBackStageKeyAndSeq(this.getFunKey(), seq);
            panels.add(panel3);
        }
        return panels;
    }

    public Map<String, Set<String>> analyzeRange(Map<String, Set<String>> leftRange, Evaluator evaluator) {
        Map<String, Set<String>> rangeMap;
        Map newLeftRange = this.getNewLeftRange(leftRange);
        Map<String, Set<String>> setMap = null;
        try {
            setMap = this.arg1.analyzeRange(newLeftRange, evaluator);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String dimNumber = ((SetFun)this.arg1).getDimNumber();
        Map<String, Set<String>> leftRange2 = newLeftRange.entrySet().stream().filter(k -> !((String)k.getKey()).equals(dimNumber)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (n1, n2) -> n2));
        if (setMap != null && setMap.containsKey(dimNumber)) {
            leftRange2.put(dimNumber, setMap.get(dimNumber));
        }
        if ((rangeMap = this.arg0.analyzeRange(leftRange2, evaluator)).isEmpty()) {
            return rangeMap;
        }
        rangeMap.put(dimNumber, leftRange.get(dimNumber));
        return rangeMap;
    }

    public Set<String> checkRuleEnlarge(RuleEnlargeEvaluator evaluator) {
        Set<String> args0 = this.arg0.checkRuleEnlarge(evaluator);
        if (args0 == null) {
            return Sets.newLinkedHashSet();
        }
        String dimNumber = ((SetFun)this.arg1).getDimNumber();
        RuleDto ruleDto = evaluator.getRuleDto();
        Map leftMembers = ruleDto.getLeftMembers();
        Set leftMember = (Set)leftMembers.get(dimNumber);
        if (CollectionUtils.isEmpty((Collection)leftMember) || leftMember.size() > 1) {
            args0.add(dimNumber);
        }
        return args0;
    }

    public void doCheck(CheckEnvironment env) {
        env.setParentToolEnum(ToolEnum.IRR);
        this.arg0.doCheck(env);
        ParseUtils.checkReturnIsNumber((IExpress)this.arg0, (CheckEnvironment)env);
        SetFun setFun = (SetFun)this.arg1;
        setFun.doCheck(env);
        env.addFunKeyRefMemKey(setFun.getFunKey(), this.arg0.getName());
        env.addFunKeyRefParentFunKey(setFun.getFunKey(), this.getFunKey());
        env.addMemberAggType(this.arg0.getName(), AggType.IRR.getIndex());
        if (this.arg2 != null) {
            this.arg2.doCheck(env);
            ParseUtils.checkReturnIsNumber((IExpress)this.arg2, (CheckEnvironment)env);
        }
        env.checkFunAndMemberRefDim(setFun.getFunKey(), this.arg0.getName());
        env.setParentToolEnum(null);
    }
}

