/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute.impl.expr.expr;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.olap.impl.execute.RuleEnlargeEvaluator;
import kd.epm.eb.olap.impl.execute.face.IExpress;
import kd.epm.eb.olap.impl.execute.impl.CheckEnvironment;
import kd.epm.eb.olap.impl.execute.impl.Environment;
import kd.epm.eb.olap.impl.execute.impl.Evaluator;
import kd.epm.eb.olap.impl.execute.impl.RangeMapUtils;
import kd.epm.eb.olap.impl.execute.impl.expr.FunReturnType;
import kd.epm.eb.olap.impl.execute.impl.expr.ParseUtils;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.BinaryExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.IsAttributeFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.OtherFun;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanel;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanelType;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.PanelEnvironment;
import kd.epm.eb.olap.impl.execute.impl.expr.parse.ParseException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.BooleanUtils;

public class IfExpr
implements IExpress {
    private IExpress condition = null;
    private IExpress left = null;
    private IExpress right = null;

    public IExpress getCondition() {
        return this.condition;
    }

    public void setCondition(IExpress condition) {
        this.condition = condition;
    }

    public IExpress getLeft() {
        return this.left;
    }

    public void setLeft(IExpress left) {
        this.left = left;
    }

    public IExpress getRight() {
        return this.right;
    }

    public void setRight(IExpress right) {
        this.right = right;
    }

    @Override
    public String toMdx(Environment env) {
        Environment falseEnv;
        Environment trueEnv;
        StringBuilder mdx = new StringBuilder();
        mdx.append("IIF(");
        Environment environment = new Environment();
        try {
            BeanUtils.copyProperties((Object)environment, (Object)env);
        }
        catch (Exception exception) {
            // empty catch block
        }
        environment.setCondition(!env.isCondition());
        if (env.isCondition()) {
            trueEnv = env;
            falseEnv = environment;
        } else {
            trueEnv = environment;
            falseEnv = env;
        }
        mdx.append(this.condition.toMdx(trueEnv));
        mdx.append(',');
        if (this.left != null) {
            mdx.append(this.left.toMdx(falseEnv));
        } else {
            mdx.append(this.handleMainMemMdxByFunVirtualMem(env));
        }
        mdx.append(',');
        if (this.right != null) {
            mdx.append(this.right.toMdx(falseEnv));
        } else {
            mdx.append(this.handleMainMemMdxByFunVirtualMem(env));
        }
        mdx.append(')');
        return mdx.toString();
    }

    @Override
    public List<ExprPanel> toPanel(PanelEnvironment env) {
        LinkedList panels = Lists.newLinkedList();
        ExprPanel panel = new ExprPanel(env.createKey(), ExprPanelType.String, false);
        panel.addShowStringAndValue("IF(", null);
        panels.add(panel);
        panels.addAll(this.condition.toPanel(env));
        panel = new ExprPanel(env.createKey(), ExprPanelType.String, false);
        panel.addShowStringAndValue(",", null);
        panels.add(panel);
        if (this.left == null) {
            panel = new ExprPanel(env.createKey(), ExprPanelType.String, false);
            panel.addShowStringAndValue("", null);
            panels.add(panel);
        } else {
            panels.addAll(this.left.toPanel(env));
        }
        panel = new ExprPanel(env.createKey(), ExprPanelType.String, false);
        panel.addShowStringAndValue(",", null);
        panels.add(panel);
        if (this.right == null) {
            panel = new ExprPanel(env.createKey(), ExprPanelType.String, false);
            panel.addShowStringAndValue("", null);
            panels.add(panel);
        } else {
            panels.addAll(this.right.toPanel(env));
        }
        panel = new ExprPanel(env.createKey(), ExprPanelType.String, false);
        panel.addShowStringAndValue(")", null);
        panels.add(panel);
        return panels;
    }

    @Override
    public String toShrekString(Environment env) {
        StringBuilder mdx = new StringBuilder();
        mdx.append("(");
        mdx.append(this.condition.toShrekString(env));
        mdx.append(" ? ");
        if (this.left != null) {
            mdx.append(this.left.toShrekString(env));
        } else {
            this.handleMainMemShrekStringByFunVirtualMem(env, mdx);
        }
        mdx.append(" : ");
        if (this.right != null) {
            mdx.append(this.right.toShrekString(env));
        } else {
            this.handleMainMemShrekStringByFunVirtualMem(env, mdx);
        }
        mdx.append(')');
        return mdx.toString();
    }

    @Override
    public Map<String, Set<String>> analyzeRange(Map<String, Set<String>> leftRange, Evaluator evaluator) {
        Map<String, Set<String>> newLeftRange = this.getNewLeftRange(leftRange);
        if (this.left == null && this.right == null) {
            return null;
        }
        if (this.left == null) {
            return this.right.analyzeRange(newLeftRange, evaluator);
        }
        if (this.right == null) {
            return this.left.analyzeRange(newLeftRange, evaluator);
        }
        Map<String, Set<String>> leftMap = this.left.analyzeRange(newLeftRange, evaluator);
        Map<String, Set<String>> rightMap = this.right.analyzeRange(newLeftRange, evaluator);
        return RangeMapUtils.union((String[])evaluator.getDimensionNum(), leftMap, rightMap);
    }

    @Override
    public Set<String> checkRuleEnlarge(RuleEnlargeEvaluator evaluator) {
        if (this.left == null || this.right == null) {
            if (this.left == null && this.right == null) {
                return null;
            }
            IExpress checkExpr = this.left == null ? this.right : this.left;
            return checkExpr.checkRuleEnlarge(evaluator);
        }
        Set<String> leftDim = this.left.checkRuleEnlarge(evaluator);
        Set<String> rightDim = this.right.checkRuleEnlarge(evaluator);
        return this.getRuleEnlarge(leftDim, rightDim);
    }

    @Override
    public void doCheck(CheckEnvironment env) {
        if (this.getCondition() instanceof BinaryExpr || this.getCondition() instanceof OtherFun || this.getCondition() instanceof IsAttributeFun) {
            FunReturnType returnType = this.getCondition().getReturnType(env);
            if (returnType != FunReturnType.Boolean) {
                throw new ParseException(ResManager.loadResFormat((String)"\u89e3\u6790\u51fa\u9519,IF\u8868\u8fbe\u5f0f\u7684\u6761\u4ef6\u8868\u8fbe\u5f0f\u4e0d\u662f\u903b\u8f91\u6bd4\u8f83\u7b26\uff1a\u201c%1\u201d\u3002", (String)"RuleManagePlugin2_43", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            }
        } else {
            throw new ParseException(ResManager.loadKDString((String)"\u89e3\u6790\u51fa\u9519,IF\u8868\u8fbe\u5f0f\u7684\u6761\u4ef6\u4e0d\u662f\u4e8c\u5143\u8868\u8fbe\u5f0f\u3002", (String)"RuleManagePlugin2_45", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        env.setIfCondition(true);
        this.getCondition().doCheck(env);
        env.setIfCondition(false);
        if (this.getLeft() != null) {
            ParseUtils.checkReturnIsNumberORNull((IExpress)this.getLeft(), (CheckEnvironment)env);
            this.getLeft().doCheck(env);
        }
        if (this.getRight() != null) {
            ParseUtils.checkReturnIsNumberORNull((IExpress)this.getRight(), (CheckEnvironment)env);
            this.getRight().doCheck(env);
        }
        if (BooleanUtils.isFalse((Boolean)env.isIfHasNotParam()) && (this.getLeft() == null || this.getRight() == null)) {
            env.setIfHasNotParam(true);
        }
    }

    @Override
    public FunReturnType getReturnType(CheckEnvironment env) {
        if (this.left == null && this.right == null) {
            return FunReturnType.Numeric;
        }
        if (this.left == null || this.right == null) {
            IExpress express = this.left == null ? this.right : this.left;
            return express.getReturnType(env);
        }
        FunReturnType returnType = this.left.getReturnType(env);
        if (FunReturnType.Word == returnType) {
            return this.right.getReturnType(env);
        }
        return returnType;
    }

    @Override
    public FunReturnType getReturnType() {
        FunReturnType returnType = this.left.getReturnType();
        if (FunReturnType.Word == returnType) {
            return this.right.getReturnType();
        }
        return returnType;
    }

    @Override
    public boolean checkRightHasNumber() {
        boolean leftHave = this.getLeft() != null && this.getLeft().checkRightHasNumber();
        boolean rightHave = this.getRight() != null && this.getRight().checkRightHasNumber();
        return leftHave || rightHave;
    }
}

