/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute.impl.expr.expr;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.AnalysisContext;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.rule.edit.FormulaMembPojo;
import kd.epm.eb.common.rule.edit.FormulaPojo;
import kd.epm.eb.common.rule.edit.ToolEnum;
import kd.epm.eb.common.rule.showbizrule.ReportShowBizRuleMemberBo;
import kd.epm.eb.common.shrek.service.ShrekExecuteServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.olap.impl.bizrule.entity.FormulaMemberDto;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.impl.bizrule.entity.RuleRightItemDto;
import kd.epm.eb.olap.impl.execute.RuleEnlargeEvaluator;
import kd.epm.eb.olap.impl.execute.face.IExpress;
import kd.epm.eb.olap.impl.execute.impl.CheckEnvironment;
import kd.epm.eb.olap.impl.execute.impl.Environment;
import kd.epm.eb.olap.impl.execute.impl.Evaluator;
import kd.epm.eb.olap.impl.execute.impl.ParseExceptionCatcher;
import kd.epm.eb.olap.impl.execute.impl.expr.FunReturnType;
import kd.epm.eb.olap.impl.execute.impl.expr.ParseUtils;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanel;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanelType;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.PanelEnvironment;
import kd.epm.eb.olap.impl.execute.impl.expr.parse.ParseException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class MdxMemberExpr
implements IExpress {
    private String name = null;
    private Map<String, Set<String>> leafRightRefMemberMap = Maps.newHashMapWithExpectedSize((int)4);

    public MdxMemberExpr() {
    }

    public MdxMemberExpr(String name) {
        this.name = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public FunReturnType getReturnType() {
        return FunReturnType.Numeric;
    }

    public String toMdx(Environment env, boolean memberCollectionBoolean) {
        RuleRightItemDto rightItemDto = this.getRightItemDto(env);
        Set fixDimension = env.getFixDimension();
        IModelCacheHelper modelCache = env.getModelCache();
        Long currentMemberBizModelId = rightItemDto.getDataSetId();
        Map ruleViewMap = env.getRuleDto().getViewMap();
        Map<String, FormulaMemberDto> formulaMemberMap = rightItemDto.getFormulaMemberList().stream().collect(Collectors.toMap(x -> x.getDimNumber(), x -> x));
        StringBuilder mdxSb = new StringBuilder();
        if (currentMemberBizModelId != null) {
            FormulaMemberDto accountMemberDto;
            if (!currentMemberBizModelId.equals(env.getBizModelId()) && env.getNeedLink()) {
                fixDimension = (Set)env.getOtherCubeFixDimension().get(currentMemberBizModelId);
                mdxSb.append("LinkValue(\"").append(currentMemberBizModelId).append("\",\"");
            } else if (memberCollectionBoolean) {
                mdxSb.append("(");
            } else if (env.getToNumber().booleanValue()) {
                mdxSb.append("ToNumber((");
            } else {
                mdxSb.append("Value(");
            }
            if (!fixDimension.contains(SysDimensionEnum.Account.getNumber()) && (accountMemberDto = formulaMemberMap.get(SysDimensionEnum.Account.getNumber())) != null) {
                String dimShortNumber = accountMemberDto.getDimShortNumber();
                Member accountMember = modelCache.getMember(accountMemberDto.getDimNumber(), null, accountMemberDto.getNumber());
                String longNumber = accountMember.getLongNumber();
                mdxSb.append(ParseUtils.genLongNumberMdx((String)dimShortNumber, (String)longNumber));
                if (memberCollectionBoolean) {
                    mdxSb.append("*");
                } else {
                    mdxSb.append(",");
                }
            }
        } else if (fixDimension.contains(SysDimensionEnum.Account.getNumber())) {
            mdxSb.append("Value(");
        } else if (!SysDimensionEnum.Account.getNumber().equals(env.getCalcDimNumber())) {
            mdxSb.append("Value(");
        } else if (env.getToNumber().booleanValue()) {
            mdxSb.append("ToNumber((");
        } else {
            mdxSb.append("Value(").append("${account}").append(",");
            mdxSb.append("${account}");
            if (memberCollectionBoolean) {
                mdxSb.append("*");
            } else {
                mdxSb.append(",");
            }
        }
        if (env.getPeriodShift() != null) {
            if (rightItemDto.getPeriodOffset() != null && rightItemDto.getPeriodOffset() != 0) {
                mdxSb.append('`').append(SysDimensionEnum.BudgetPeriod.getShortNumber()).append('`').append('.').append("CurrentMember.Lead(").append(rightItemDto.getPeriodOffset()).append(")").append(".Lag(").append(env.getPeriodShift()).append(")");
            } else {
                FormulaMemberDto formulaMemberDto = formulaMemberMap.get(SysDimensionEnum.BudgetPeriod.getNumber());
                if (formulaMemberDto != null) {
                    mdxSb.append(ParseUtils.genLongNumberMdx((String)SysDimensionEnum.BudgetPeriod.getShortNumber(), (String)formulaMemberDto.getLongNumber())).append(".Lag(").append(env.getPeriodShift()).append(")");
                } else {
                    mdxSb.append('`').append(SysDimensionEnum.BudgetPeriod.getShortNumber()).append('`').append('.').append("CurrentMember.Lag(").append(env.getPeriodShift()).append(")");
                }
            }
            if (memberCollectionBoolean) {
                mdxSb.append("*");
            } else {
                mdxSb.append(",");
            }
        } else if (rightItemDto.getPeriodOffset() != null && rightItemDto.getPeriodOffset() != 0) {
            mdxSb.append('`').append(SysDimensionEnum.BudgetPeriod.getShortNumber()).append('`').append('.').append("CurrentMember.Lead(").append(rightItemDto.getPeriodOffset()).append(")");
            if (memberCollectionBoolean) {
                mdxSb.append("*");
            } else {
                mdxSb.append(",");
            }
        }
        for (FormulaMemberDto formulaMemberDto : rightItemDto.getFormulaMemberList()) {
            String dimNumber = formulaMemberDto.getDimNumber();
            if (fixDimension.contains(dimNumber) || rightItemDto.getPeriodOffset() != null && rightItemDto.getPeriodOffset() != 0 && SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber) || env.getPeriodShift() != null && SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber) || SysDimensionEnum.Account.getNumber().equals(dimNumber)) continue;
            Dimension dimension = modelCache.getDimension(dimNumber);
            Member member = modelCache.getMember(dimNumber, (Long)ruleViewMap.get(dimNumber), formulaMemberDto.getNumber());
            if (member == null) {
                throw new KDBizException("member not found" + formulaMemberDto);
            }
            mdxSb.append(this.genLongNumberMdx(dimension.getShortNumber(), member.getLongNumber()));
            if (memberCollectionBoolean) {
                mdxSb.append("*");
                continue;
            }
            mdxSb.append(",");
        }
        if (MapUtils.isNotEmpty((Map)env.getFillInDefaultMap()) && MapUtils.isNotEmpty((Map)((Map)env.getFillInDefaultMap().get(currentMemberBizModelId)))) {
            Map defaultMemberMap = (Map)env.getFillInDefaultMap().get(currentMemberBizModelId);
            for (Map.Entry entry : defaultMemberMap.entrySet()) {
                String dimNumber = (String)entry.getKey();
                Dimension dimension = modelCache.getDimension(dimNumber);
                Member member = (Member)entry.getValue();
                mdxSb.append(this.genLongNumberMdx(dimension.getShortNumber(), member.getLongNumber()));
                if (memberCollectionBoolean) {
                    mdxSb.append("*");
                    continue;
                }
                mdxSb.append(",");
            }
        }
        mdxSb.setLength(mdxSb.length() - 1);
        if (mdxSb.length() > 0) {
            if (mdxSb.charAt(0) == 'L') {
                mdxSb.append("\")");
            } else if (env.getToNumber().booleanValue()) {
                mdxSb.append("))");
            } else {
                mdxSb.append(")");
            }
        }
        return mdxSb.toString();
    }

    @Override
    public String toMdx(Environment env) {
        return this.toMdx(env, false);
    }

    @Override
    public List<ExprPanel> toPanel(PanelEnvironment env) {
        LinkedList panels = Lists.newLinkedList();
        Map ruleMemberMap = env.getRuleMemberMap();
        ReportShowBizRuleMemberBo ruleMemberBo = (ReportShowBizRuleMemberBo)ruleMemberMap.get(this.getName());
        if (ruleMemberBo == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u89c4\u5219\u89e3\u6790\u9519\u8bef\uff0c\u65e0\u6cd5\u627e\u5230key[%1]\u5bf9\u5e94\u7684\u6570\u636e\u5e93\u5bf9\u8c61\uff0c\u8bf7\u91cd\u65b0\u7f16\u5236\u8be5\u89c4\u5219[%2]", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getName(), env.getRuleKey()}));
        }
        ExprPanel panel = new ExprPanel(this.getName(), ExprPanelType.Member, true);
        String val = ruleMemberBo.getValue() == null ? null : ruleMemberBo.getValue().toString();
        panel.addShowStringAndValue(ruleMemberBo.getName(), val);
        panels.add(panel);
        return panels;
    }

    public String toLeftMdx(Environment env) {
        Map leftMembers = env.getLeftMembers();
        IModelCacheHelper modelCache = env.getModelCache();
        Map ruleViewMap = env.getRuleDto().getViewMap();
        Set leftMember = (Set)leftMembers.get(env.getMainDimNumber());
        if (SysDimensionEnum.Account.getNumber().equals(env.getCalcDimNumber()) && !env.getMainDimNumber().equals(env.getCalcDimNumber())) {
            return "${account}";
        }
        Dimension dimension = modelCache.getDimension(env.getMainDimNumber());
        Member member = modelCache.getMember(env.getMainDimNumber(), (Long)ruleViewMap.get(env.getMainDimNumber()), (String)leftMember.iterator().next());
        if (member == null) {
            throw new KDBizException("member not found" + (String)leftMember.iterator().next());
        }
        if (dimension.isKeepTree()) {
            return ParseUtils.genLongNumberMdx((String)dimension.getShortNumber(), (String)member.getLongNumber());
        }
        return ParseUtils.genLongNumberMdx((String)dimension.getShortNumber(), (String)member.getNumber());
    }

    public String toLeftShrekString(Environment env) {
        Map leftMembers = env.getLeftMembers();
        String dimNumber = env.getMainDimNumber();
        Set leftMember = (Set)leftMembers.get(dimNumber);
        String memberNumber = (String)leftMember.iterator().next();
        return dimNumber + "@" + memberNumber;
    }

    @Override
    public String toShrekString(Environment env) {
        boolean kuaCube;
        RuleRightItemDto rightItemDto = this.getRightItemDto(env);
        Long datasetId = rightItemDto.getDataSetId();
        StringBuilder mdxSb = new StringBuilder();
        boolean bl = kuaCube = datasetId != null && !datasetId.equals(env.getBizModelId());
        if (kuaCube) {
            AnalysisContext analysisContext = OlapContext.getAnalysisContext();
            if (analysisContext != null) {
                Map analysisCubeMap = analysisContext.getAnalysisCubeMap();
                String sanBoxCubeName = MapUtils.getString((Map)analysisCubeMap, (Object)datasetId);
                if (StringUtils.isBlank((CharSequence)sanBoxCubeName)) {
                    throw new KDBizException("sanBox cubeName cannot be null");
                }
                mdxSb.append("cube('").append(env.getModelCache().getDataSet(datasetId).getCubeNumber()).append("','").append(sanBoxCubeName).append("','").append("','");
            } else {
                mdxSb.append("cube('").append(env.getModelCache().getDataSet(datasetId).getCubeNumber()).append("','");
            }
        } else {
            mdxSb.append("v('");
        }
        for (FormulaMemberDto formulaMemberDto : rightItemDto.getFormulaMemberList()) {
            String dimNumber = formulaMemberDto.getDimNumber();
            mdxSb.append(dimNumber).append("@").append(formulaMemberDto.getNumber()).append(",");
        }
        mdxSb.setLength(mdxSb.length() - 1);
        mdxSb.append("')");
        return mdxSb.toString();
    }

    private RuleRightItemDto getRightItemDto(Environment env) {
        RuleRightItemDto ruleRightItemDto = (RuleRightItemDto)env.getRuleRightItemDtoMap().get(this.name);
        if (ruleRightItemDto == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u89c4\u5219\u89e3\u6790\u9519\u8bef\uff0c\u65e0\u6cd5\u627e\u5230key[%1]\u5bf9\u5e94\u7684\u6570\u636e\u5e93\u5bf9\u8c61\uff0c\u8bf7\u91cd\u65b0\u7f16\u5236\u8be5\u89c4\u5219[%2]", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[]{this.getName(), env.getRuleDto().getNumber()}));
        }
        return ruleRightItemDto;
    }

    @Override
    public Map<String, Set<String>> analyzeRange(Map<String, Set<String>> leftRange, Evaluator evaluator) {
        Map hasTrimRightMap;
        String[] currentDimensionNum;
        Dataset currentDataSet;
        boolean hasPeriodOffSet;
        Map<String, Set<String>> newLeftRange = this.getNewLeftRange(leftRange);
        if (evaluator.hasCollect(this.name)) {
            return evaluator.getCollect(this.name);
        }
        Dataset dataSet = evaluator.getDataSet();
        String[] dimensionNum = evaluator.getDimensionNum();
        IModelCacheHelper modelCache = evaluator.getModelCache();
        RuleDto ruleDto = evaluator.getRuleDto();
        List rightItems = ruleDto.getRuleRightItemDto();
        Optional<RuleRightItemDto> first = rightItems.stream().filter(item -> item.getMemberKey().equals(this.name)).findFirst();
        Integer offset = (Integer)ruleDto.getOffsetMap().get(this.name);
        boolean bl = hasPeriodOffSet = offset != null && offset != 0;
        if (!first.isPresent()) {
            return ShrekExecuteServiceHelper.analyzeRange((Model)modelCache.getModelobj(), (Dataset)dataSet, null, newLeftRange);
        }
        RuleRightItemDto ruleRightItemDto = first.get();
        Optional<FormulaMemberDto> accountOptional = ruleRightItemDto.getFormulaMemberList().stream().filter(item -> SysDimensionEnum.Account.getNumber().equals(item.getDimNumber())).findFirst();
        if (accountOptional.isPresent()) {
            FormulaMemberDto formulaMemberDto = accountOptional.get();
            Member accountMember = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, formulaMemberDto.getNumber());
            Long currentDataSetId = accountMember.getDatasetId();
            if (dataSet.getId().equals(currentDataSetId)) {
                currentDataSet = dataSet;
                currentDimensionNum = dimensionNum;
            } else {
                currentDataSet = DatasetServiceHelper.getInstance().getDataSet(currentDataSetId);
                currentDimensionNum = modelCache.getDimensionNums(currentDataSetId);
            }
        } else {
            currentDataSet = dataSet;
            currentDimensionNum = dimensionNum;
        }
        boolean metricHasAgg = true;
        Member metricMember = null;
        Optional<FormulaMemberDto> metricOptional = ruleRightItemDto.getFormulaMemberList().stream().filter(item -> SysDimensionEnum.Metric.getNumber().equals(item.getDimNumber())).findFirst();
        String metricDimNumber = SysDimensionEnum.Metric.getNumber();
        if (metricOptional.isPresent()) {
            FormulaMemberDto formulaMemberDto = metricOptional.get();
            metricMember = modelCache.getMember(metricDimNumber, null, formulaMemberDto.getNumber());
        } else {
            Set<String> leftR = newLeftRange.get(metricDimNumber);
            if (CollectionUtils.isNotEmpty(leftR)) {
                String number = leftR.iterator().next();
                metricMember = modelCache.getMember(metricDimNumber, null, number);
            }
        }
        if (metricMember != null) {
            metricHasAgg = metricMember.hasAgg();
        }
        Map<String, Set<String>> rightRefMemberMap = ruleRightItemDto.getRefMemberMap();
        HashMap<String, Set<String>> rightExecuteList = new HashMap<String, Set<String>>(16);
        for (String dimNumber : currentDimensionNum) {
            Set<String> leftR = newLeftRange.get(dimNumber);
            Set<String> rightRefMembers = rightRefMemberMap.get(dimNumber);
            if (CollectionUtils.isEmpty(leftR) && rightRefMembers == null) continue;
            if (rightRefMembers != null) {
                if (metricHasAgg) {
                    Set<String> leafMembers = this.getLeafMembers(modelCache, currentDataSet, dimNumber, rightRefMembers, evaluator);
                    rightExecuteList.put(dimNumber, leafMembers);
                    continue;
                }
                rightExecuteList.put(dimNumber, rightRefMembers);
                continue;
            }
            rightExecuteList.put(dimNumber, leftR);
        }
        HashSet skipDim = null;
        if (hasPeriodOffSet) {
            skipDim = Sets.newHashSet((Object[])new String[]{SysDimensionEnum.BudgetPeriod.getNumber()});
            Set leftBps = (Set)rightExecuteList.get(SysDimensionEnum.BudgetPeriod.getNumber());
            if (CollectionUtils.isNotEmpty((Collection)leftBps)) {
                Set<String> offSetMembers = this.getOffSetDimMembers(leftBps, modelCache, offset);
                rightExecuteList.put(SysDimensionEnum.BudgetPeriod.getNumber(), offSetMembers);
            }
        }
        if ((hasTrimRightMap = ShrekExecuteServiceHelper.analyzeRange((Model)modelCache.getModelobj(), (Dataset)currentDataSet, skipDim, rightExecuteList)).isEmpty()) {
            return new HashMap<String, Set<String>>(1);
        }
        HashMap returnBackLeftTrimRange = Maps.newHashMapWithExpectedSize((int)dimensionNum.length);
        for (String dimNumber : dimensionNum) {
            Set<String> rightRefMembers = rightRefMemberMap.get(dimNumber);
            if (hasPeriodOffSet && SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) {
                returnBackLeftTrimRange.put(dimNumber, newLeftRange.get(dimNumber));
                continue;
            }
            if (rightRefMembers != null) {
                returnBackLeftTrimRange.put(dimNumber, newLeftRange.get(dimNumber));
                continue;
            }
            Set<String> value = (Set<String>)hasTrimRightMap.get(dimNumber);
            if (value == null) {
                value = newLeftRange.get(dimNumber);
            }
            if (value == null) {
                throw new KDBizException("rule(" + ruleDto.getNumber() + ")'s dim(" + dimNumber + "is null ,please reedit this rule.");
            }
            returnBackLeftTrimRange.put(dimNumber, value);
        }
        if (rightRefMemberMap.containsKey(evaluator.getPartDimension())) {
            // empty if block
        }
        return returnBackLeftTrimRange;
    }

    private Set<String> getOffSetDimMembers(Set<String> cellMembers, IModelCacheHelper modelCache, int offset) {
        HashSet realMembers = Sets.newHashSet();
        for (String member : cellMembers) {
            Member offsetMember = modelCache.getMemberOffset(SysDimensionEnum.BudgetPeriod.getNumber(), member, offset);
            if (offsetMember == null) continue;
            realMembers.add(offsetMember.getNumber());
        }
        return realMembers;
    }

    private Set<String> getLeafMembers(IModelCacheHelper modelCache, Dataset currentDataSet, String dimNumber, Set<String> rightRefMembers, Evaluator evaluator) {
        return this.leafRightRefMemberMap.computeIfAbsent(dimNumber, v -> {
            HashSet<String> leafMembers = new HashSet<String>(16);
            Long viewId = evaluator.getRuleDto().getViewMap().getOrDefault(dimNumber, 0L);
            for (String rightRefMember : rightRefMembers) {
                Member member = modelCache.getMember(dimNumber, viewId, rightRefMember);
                if (member.isLeaf()) {
                    leafMembers.add(member.getNumber());
                    continue;
                }
                leafMembers.addAll(modelCache.getLeafOfNumbers(member));
            }
            return leafMembers;
        });
    }

    @Override
    public Set<String> checkRuleEnlarge(RuleEnlargeEvaluator evaluator) {
        Set dimNumbers = evaluator.getDimNumbers();
        RuleDto ruleDto = evaluator.getRuleDto();
        Map leftMembers = ruleDto.getLeftMembers();
        List rightItems = ruleDto.getRuleRightItemDto();
        Optional<RuleRightItemDto> first = rightItems.stream().filter(item -> item.getMemberKey().equals(this.name)).findFirst();
        LinkedHashSet collect = Sets.newLinkedHashSet();
        if (first.isPresent()) {
            RuleRightItemDto ruleRightItemDto = first.get();
            List<FormulaMemberDto> formulaMemberList = ruleRightItemDto.getFormulaMemberList();
            for (FormulaMemberDto formulaMemberDto : formulaMemberList) {
                Set leftMember;
                String dimNumber = formulaMemberDto.getDimNumber();
                if (!dimNumbers.contains(dimNumber) || !CollectionUtils.isEmpty((Collection)(leftMember = (Set)leftMembers.get(dimNumber))) && leftMember.size() <= 1) continue;
                collect.add(dimNumber);
            }
        }
        return collect;
    }

    @Override
    public void doCheck(CheckEnvironment env) {
        FormulaPojo formulaPojo = (FormulaPojo)env.getFormulaPojoMap().get(this.getName());
        if (formulaPojo == null) {
            throw new ParseException(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u516c\u5f0f\u6709\u9519\u8bef\u3002", (String)"RuleManagePlugin2_98", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        IModelCacheHelper modelCache = env.getModelCache();
        env.addMemberRefDimension(this.name, env.getMainDimNumber());
        List notMainMemberList = formulaPojo.getNotMainMemberList();
        if (notMainMemberList != null) {
            for (FormulaMembPojo formulaMembPojo : notMainMemberList) {
                env.addMemberRefDimension(this.name, formulaMembPojo.getDimNumber());
            }
        }
        env.addRightMemberKeys(this.getName());
        if (ToolEnum.rangeFunctionBoolean((ToolEnum)env.getParentToolEnum())) {
            if (SysDimensionEnum.Account.getNumber().equals(env.getMainDimNumber())) {
                Member member = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, formulaPojo.getNumberString());
                if (member == null || !member.getDatasetId().equals(env.getDataSetId())) {
                    throw new ParseException(ParseExceptionCatcher.loadNotDataSetString());
                }
            } else if (notMainMemberList != null) {
                for (FormulaMembPojo formulaMembPojo : notMainMemberList) {
                    String dimNumber = formulaMembPojo.getDimNumber();
                    if (!SysDimensionEnum.Account.getNumber().equals(dimNumber)) continue;
                    String memberIdString = formulaMembPojo.getMemberIdString();
                    Member member = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, Long.valueOf(memberIdString));
                    if (member != null && member.getDatasetId().equals(env.getDataSetId())) continue;
                    throw new ParseException(ParseExceptionCatcher.loadNotDataSetString());
                }
            }
        }
        if (!env.isIfCondition() && !env.isYearOrMonth() && FunReturnType.Date == this.getReturnType(env)) {
            throw new ParseException(ResManager.loadKDString((String)"\u65e5\u671f\u7c7b\u578b\u7684\u5ea6\u91cf\u53ea\u80fd\u7528\u4e8eif\u51fd\u6570\u7684\u6761\u4ef6\u5224\u65ad\u6216\u8005month\u3001year\u3001DateDif\u51fd\u6570\u4e2d", (String)"RuleManagePlugin2_92", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (!env.isIfCondition() && FunReturnType.Numeric != this.getReturnType(env) && FunReturnType.Date != this.getReturnType(env)) {
            throw new ParseException(ResManager.loadKDString((String)"\u6587\u672c\u548c\u679a\u4e3e\u7c7b\u578b\u7684\u5ea6\u91cf\u53ea\u80fd\u7528\u4e8eif\u51fd\u6570\u7684\u6761\u4ef6\u5224\u65ad\u4e2d", (String)"RuleManagePlugin2_91", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
    }

    @Override
    public FunReturnType getReturnType(CheckEnvironment env) {
        Member member;
        FormulaPojo formulaPojo = (FormulaPojo)env.getFormulaPojoMap().get(this.getName());
        if (formulaPojo == null) {
            throw new ParseException(ResManager.loadKDString((String)"\u8f93\u5165\u7684\u516c\u5f0f\u6709\u9519\u8bef\u3002", (String)"RuleManagePlugin2_98", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (SysDimensionEnum.Metric.getNumber().equals(env.getMainDimNumber())) {
            IModelCacheHelper modelCache = env.getModelCache();
            member = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, formulaPojo.getNumberString());
        } else {
            List notMainMemberList = formulaPojo.getNotMainMemberList();
            if (notMainMemberList == null || notMainMemberList.isEmpty()) {
                return this.getReturnType();
            }
            Optional<FormulaMembPojo> optional = notMainMemberList.stream().filter(membPojo -> SysDimensionEnum.Metric.getNumber().equals(membPojo.getDimNumber())).findFirst();
            if (!optional.isPresent()) {
                return this.getReturnType();
            }
            FormulaMembPojo formulaMembPojo = optional.get();
            String numberString = formulaMembPojo.getNumberString();
            IModelCacheHelper modelCache = env.getModelCache();
            member = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, numberString);
        }
        if (member == null) {
            return this.getReturnType();
        }
        return FunReturnType.getType((String)member.getDatatype());
    }

    private String genLongNumberMdx(String dimShortNumber, String longNumber) {
        String[] split;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("`").append(dimShortNumber).append("`");
        for (String number : split = longNumber.split("!")) {
            stringBuilder.append(".").append("`").append(number).append("`");
        }
        return stringBuilder.toString();
    }
}

