/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute.impl.expr.expr;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dao.formula.DimMemberPojo;
import kd.epm.eb.common.dao.formula.FormulaMemberPojo;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.FunctionItemEnum;
import kd.epm.eb.common.rule.edit.ToolEnum;
import kd.epm.eb.common.rule.ruleFunction.IRuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.rule.showbizrule.ReportShowBizRuleMemberBo;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.impl.execute.RuleEnlargeEvaluator;
import kd.epm.eb.olap.impl.execute.face.IExpress;
import kd.epm.eb.olap.impl.execute.impl.CheckEnvironment;
import kd.epm.eb.olap.impl.execute.impl.Environment;
import kd.epm.eb.olap.impl.execute.impl.Evaluator;
import kd.epm.eb.olap.impl.execute.impl.ParseExceptionCatcher;
import kd.epm.eb.olap.impl.execute.impl.expr.ParseUtils;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.MdxMemberExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.SetFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.SingleMemberExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.StringExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanel;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanelType;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.PanelEnvironment;
import org.apache.commons.collections4.CollectionUtils;

public class MemberFun
extends SingleMemberExpr {
    private MdxMemberExpr dimGroup;
    private SetFun stringFun;
    private StringExpr fixString;

    public MdxMemberExpr getDimGroup() {
        return this.dimGroup;
    }

    public void setDimGroup(MdxMemberExpr dimGroup) {
        this.dimGroup = dimGroup;
    }

    public SetFun getStringFun() {
        return this.stringFun;
    }

    public void setStringFun(SetFun stringFun) {
        this.stringFun = stringFun;
    }

    public StringExpr getFixString() {
        return this.fixString;
    }

    public void setFixString(StringExpr fixString) {
        this.fixString = fixString;
    }

    public String toMdx(Environment env) {
        RuleFunction ruleFunction = (RuleFunction)env.getFunctionMap().get(this.getFunKey());
        StringBuilder stringBuilder = new StringBuilder("MemberOfShowNumber(");
        if (ruleFunction == null) {
            stringBuilder.append(",)");
            return stringBuilder.toString();
        }
        if (this.dimGroup != null) {
            Map allVal = ruleFunction.getAllValues();
            String accountRangeMemStr = this.getDimRangeInfoToString(allVal, FunctionItemEnum.DIMGROUP.getKey(), ',', false, env);
            stringBuilder.append("Value(").append(accountRangeMemStr).append(")");
        } else if (this.stringFun != null) {
            stringBuilder.append(this.stringFun.toMdx(env));
        } else if (this.fixString != null) {
            stringBuilder.append("'").append(this.fixString.toMdx()).append("'");
        }
        IModelCacheHelper modelCache = env.getModelCache();
        String dimNumber = this.getDimNumber();
        Long viewId = env.getRuleDto().getViewMap().getOrDefault(dimNumber, 0L);
        Dimension dimension = modelCache.getDimension(dimNumber);
        String accountMemNum = (String)((Set)env.getLeftMembers().get(SysDimensionEnum.Account.getNumber())).iterator().next();
        Member accountMember = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, accountMemNum);
        stringBuilder.append(",").append(this.getAllMemberMdx(dimension, viewId, accountMember)).append(",");
        stringBuilder.append(this.getRootMemberMdx(modelCache, viewId)).append(")");
        return stringBuilder.toString();
    }

    public String getAllMemberMdx(Dimension dimension, Long viewId, Member accountMember) {
        List allMembers = dimension.getAllMembers(viewId);
        if (dimension.getNumber().equals(SysDimensionEnum.Account.getNumber())) {
            Long datasetId = accountMember.getDatasetId();
            allMembers = allMembers.stream().filter(e -> datasetId.equals(e.getDatasetId())).collect(Collectors.toList());
        }
        return allMembers.stream().map(item -> ParseUtils.genLongNumberMdx((String)dimension.getShortNumber(), (String)item.getLongNumber())).collect(Collectors.joining(",", "{", "}"));
    }

    public String getRootMemberMdx(IModelCacheHelper modelCache, Long viewId) {
        String dimNumber = this.getDimNumber();
        Dimension dimension = modelCache.getDimension(dimNumber);
        Member rootMember = modelCache.getRootMember(dimNumber, viewId);
        return ParseUtils.genLongNumberMdx((String)dimension.getShortNumber(), (String)rootMember.getLongNumber());
    }

    public List<ExprPanel> toPanel(PanelEnvironment env) {
        LinkedList panels = Lists.newLinkedList();
        int seq = 0;
        ExprPanel panel1 = new ExprPanel(this.getFunKey() + seq, ExprPanelType.String, false);
        Dimension dimension = env.getModelCache().getDimension(this.getDimNumber());
        panel1.addShowStringAndValue("@Member(" + dimension.getName() + ",", null);
        panel1.addBackStageKeyAndSeq(this.getFunKey(), seq++);
        panels.add(panel1);
        if (this.dimGroup != null) {
            IRuleFunction ruleFunction = (IRuleFunction)env.getFunctionMap().get(this.getFunKey());
            Map allVal = ruleFunction.getAllValues();
            String keyInfo = (String)allVal.get(FunctionItemEnum.DIMGROUP.getKey());
            FormulaMemberPojo formulaMemberPojo = (FormulaMemberPojo)JsonUtils.readValue((String)keyInfo, FormulaMemberPojo.class);
            String memberKey = (String)allVal.get("dimgroupmemberkey");
            ExprPanel panel2 = new ExprPanel(memberKey, ExprPanelType.Member, true);
            List refDimMembers = formulaMemberPojo.getRefDimMembers();
            StringBuilder stringBuilder = new StringBuilder();
            for (DimMemberPojo refDimMember : refDimMembers) {
                stringBuilder.append(refDimMember.getName()).append("|");
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
            Map ruleMemberMap = env.getRuleMemberMap();
            ReportShowBizRuleMemberBo ruleMemberBo = (ReportShowBizRuleMemberBo)ruleMemberMap.get(memberKey);
            String val = ruleMemberBo.getValue() == null ? null : ruleMemberBo.getValue().toString();
            panel2.addShowStringAndValue(stringBuilder.toString(), val);
            panels.add(panel2);
        }
        if (this.stringFun != null) {
            panels.addAll(this.stringFun.toPanel(env));
        }
        if (this.fixString != null) {
            panels.addAll(this.fixString.toPanel(env));
        }
        ExprPanel panel3 = new ExprPanel(this.getFunKey() + seq, ExprPanelType.String, false);
        panel3.addShowStringAndValue(")", null);
        panel3.addBackStageKeyAndSeq(this.getFunKey(), seq);
        panels.add(panel3);
        return panels;
    }

    public void doCheck(CheckEnvironment env) {
        IRuleFunction function;
        Map allValues;
        String parentDimNumber;
        if (!ToolEnum.rangeFunctionBoolean((ToolEnum)env.getParentToolEnum())) {
            ParseExceptionCatcher.throwRangeException();
        }
        String currentFunDimNumber = this.getDimNumber();
        if (!env.getCurrentDataSetDimSet().contains(currentFunDimNumber)) {
            ParseExceptionCatcher.throwException4();
        }
        env.addFunRefDimension(this.getFunKey(), currentFunDimNumber);
        IExpress parentExpress = env.getParentExpress();
        if (parentExpress != null && !currentFunDimNumber.equals(parentDimNumber = ParseUtils.getExpressDimNumber((IExpress)parentExpress))) {
            ParseExceptionCatcher.throwException2((String)parentDimNumber, (String)this.getDimNumber());
        }
        if (this.stringFun != null) {
            env.setParentExpress((IExpress)((Object)this));
            env.setParentToolEnum(ToolEnum.Member);
            this.stringFun.doCheck(env);
            env.setParentToolEnum(null);
            env.setParentExpress(null);
        }
        if (this.dimGroup != null && (allValues = (function = (IRuleFunction)env.getFunctionMap().get(this.getFunKey())).getAllValues()).containsKey(FunctionItemEnum.DIMGROUP.getKey())) {
            String dimGroupStr = (String)allValues.get(FunctionItemEnum.DIMGROUP.getKey());
            FormulaMemberPojo formulaMemberPojo = (FormulaMemberPojo)JsonUtils.readValue((String)dimGroupStr, FormulaMemberPojo.class);
            Set dimSet = formulaMemberPojo.getRefDimMembers().stream().map(DimMemberPojo::getDimNumber).collect(Collectors.toSet());
            Long rangeDataSetId = env.getRangeDataSetId();
            if (IDUtils.isNotEmptyLong((Long)rangeDataSetId).booleanValue()) {
                List dimensionList = env.getModelCache().getDimensionList(rangeDataSetId);
                Set dimSetByDataset = dimensionList.stream().map(BaseCache::getNumber).collect(Collectors.toSet());
                dimSet.removeAll(dimSetByDataset);
                if (CollectionUtils.isNotEmpty(dimSet)) {
                    ParseExceptionCatcher.throwMemberDimGroupException((String)StringUtils.join(dimSet, (String)","), (String)env.getParentToolEnum().getCode());
                }
            }
        }
    }

    public Map<String, Set<String>> analyzeRange(Map<String, Set<String>> leftRange, Evaluator evaluator) {
        return this.getNewLeftRange(leftRange);
    }

    public List<IExpress> getChildren() {
        if (this.dimGroup != null) {
            return Lists.newArrayList((Object[])new IExpress[]{this.dimGroup});
        }
        if (this.stringFun != null) {
            return Lists.newArrayList((Object[])new IExpress[]{this.stringFun});
        }
        if (this.fixString != null) {
            return Lists.newArrayList((Object[])new IExpress[]{this.fixString});
        }
        return null;
    }

    public Set<String> checkRuleEnlarge(RuleEnlargeEvaluator evaluator) {
        String dimNumber;
        RuleDto ruleDto = evaluator.getRuleDto();
        Map leftMembers = ruleDto.getLeftMembers();
        Set leftMember = (Set)leftMembers.get(dimNumber = this.getDimNumber());
        if (kd.epm.eb.common.utils.CollectionUtils.isEmpty((Collection)leftMember) || leftMember.size() > 1) {
            return Sets.newHashSet((Object[])new String[]{dimNumber});
        }
        return Sets.newLinkedHashSet();
    }
}

