/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute.impl.expr.expr;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.ruleFunctionEnums.RuleFunctionEnum;
import kd.epm.eb.olap.impl.execute.face.IExpress;
import kd.epm.eb.olap.impl.execute.impl.CheckEnvironment;
import kd.epm.eb.olap.impl.execute.impl.Environment;
import kd.epm.eb.olap.impl.execute.impl.Evaluator;
import kd.epm.eb.olap.impl.execute.impl.ParseExceptionCatcher;
import kd.epm.eb.olap.impl.execute.impl.expr.ParseUtils;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.SingleMemberExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanel;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanelType;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.PanelEnvironment;

public class ParentFun
extends SingleMemberExpr {
    private SingleMemberExpr memberExpr;

    public void setMemberExpr(SingleMemberExpr memberExpr) {
        memberExpr.setDimNumber(this.getDimNumber());
        this.memberExpr = memberExpr;
    }

    public SingleMemberExpr getMemberExpr() {
        return this.memberExpr;
    }

    public String toMdx(Environment env) {
        return this.memberExpr.toMdx(env) + ".Parent";
    }

    public List<ExprPanel> toPanel(PanelEnvironment env) {
        LinkedList panels = Lists.newLinkedList();
        int seq = 0;
        ExprPanel panel1 = new ExprPanel(this.getFunKey() + seq, ExprPanelType.String, false);
        Dimension dimension = env.getModelCache().getDimension(this.getDimNumber());
        panel1.addShowStringAndValue("@Parent(" + dimension.getName() + ",", null);
        panel1.addBackStageKeyAndSeq(this.getFunKey(), seq++);
        panels.add(panel1);
        panels.addAll(this.memberExpr.toPanel(env));
        ExprPanel panel2 = new ExprPanel(this.getFunKey() + seq, ExprPanelType.String, false);
        panel2.addShowStringAndValue(")", null);
        panel2.addBackStageKeyAndSeq(this.getFunKey(), seq);
        panels.add(panel2);
        return panels;
    }

    public void doCheck(CheckEnvironment env) {
        String parentDimNumber;
        String funcName = RuleFunctionEnum.Parent.getName();
        this.checkRangeAndGetNumberGetNameContain(env, funcName);
        String currentFunDimNumber = this.getDimNumber();
        if (!env.getCurrentDataSetDimSet().contains(currentFunDimNumber)) {
            ParseExceptionCatcher.throwException4();
        }
        env.addFunRefDimension(this.getFunKey(), currentFunDimNumber);
        IExpress parentExpress = env.getParentExpress();
        if (parentExpress != null && !currentFunDimNumber.equals(parentDimNumber = ParseUtils.getExpressDimNumber((IExpress)parentExpress))) {
            ParseExceptionCatcher.throwException2((String)parentDimNumber, (String)this.getDimNumber());
        }
        env.setParentExpress((IExpress)((Object)this));
        this.memberExpr.doCheck(env);
        env.setParentExpress(null);
    }

    public Map<String, Set<String>> analyzeRange(Map<String, Set<String>> leftRange, Evaluator evaluator) {
        Map newLeftRange = this.getNewLeftRange(leftRange);
        String dimNumber = this.getDimNumber();
        Map childMap = this.memberExpr.analyzeRange(newLeftRange, evaluator);
        Set childMembers = (Set)childMap.get(dimNumber);
        LinkedHashSet members = Sets.newLinkedHashSet();
        IModelCacheHelper modelCache = evaluator.getModelCache();
        Long viewId = evaluator.getRuleDto().getViewMap().getOrDefault(dimNumber, 0L);
        for (String memNum : childMembers) {
            Member member = modelCache.getMember(dimNumber, viewId, memNum);
            Member parent = modelCache.getParent(viewId, member);
            if (parent == null) continue;
            members.add(parent.getNumber());
        }
        childMap.put(dimNumber, members);
        return childMap;
    }

    public List<IExpress> getChildren() {
        return Lists.newArrayList((Object[])new IExpress[]{this.memberExpr});
    }
}

