/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute.impl.expr.expr;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.enums.AggType;
import kd.epm.eb.common.rule.edit.ToolEnum;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.olap.impl.execute.RuleEnlargeEvaluator;
import kd.epm.eb.olap.impl.execute.face.IExpress;
import kd.epm.eb.olap.impl.execute.impl.CheckEnvironment;
import kd.epm.eb.olap.impl.execute.impl.Environment;
import kd.epm.eb.olap.impl.execute.impl.Evaluator;
import kd.epm.eb.olap.impl.execute.impl.RangeMapUtils;
import kd.epm.eb.olap.impl.execute.impl.expr.FunReturnType;
import kd.epm.eb.olap.impl.execute.impl.expr.ParseUtils;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.AbstractFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.MdxMemberExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanel;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanelType;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.PanelEnvironment;

public class PeriodShiftFun
extends AbstractFun {
    private List<IExpress> args;

    public List<IExpress> getChildren() {
        return this.args;
    }

    public String toMdx(Environment env) {
        String mdx1;
        IExpress iExpress = this.args.get(1);
        if (iExpress instanceof AbstractFun) {
            env.setToNumber(Boolean.valueOf(false));
            mdx1 = "ToNumber(" + this.args.get(1).toMdx(env) + ")";
        } else {
            env.setToNumber(Boolean.valueOf(true));
            mdx1 = this.args.get(1).toMdx(env);
        }
        env.setToNumber(Boolean.valueOf(false));
        env.setPeriodShift(mdx1);
        String mdx = this.args.get(0).toMdx(env);
        env.setPeriodShift(null);
        return mdx;
    }

    public List<ExprPanel> toPanel(PanelEnvironment env) {
        LinkedList exprPanelList = Lists.newLinkedList();
        AtomicInteger seq = new AtomicInteger(0);
        LambdaUtils.run(() -> {
            ExprPanel exprPanel = new ExprPanel(this.getFunKey() + seq.getAndIncrement(), ExprPanelType.String, false);
            exprPanel.addShowStringAndValue("@PeriodShift(", null);
            exprPanel.addBackStageKeyAndSeq(this.getFunKey(), seq.getAndIncrement());
            exprPanelList.add(exprPanel);
        });
        for (int i = 0; i < this.args.size(); ++i) {
            IExpress arg = this.args.get(i);
            exprPanelList.addAll(arg.toPanel(env));
            if (i >= this.args.size() - 1) continue;
            ExprPanel splitPanel = new ExprPanel(env.createKey() + seq.getAndIncrement(), ExprPanelType.String, false);
            splitPanel.addShowStringAndValue(",", null);
            exprPanelList.add(splitPanel);
        }
        LambdaUtils.run(() -> {
            ExprPanel exprPanel = new ExprPanel(this.getFunKey() + seq.getAndIncrement(), ExprPanelType.String, false);
            exprPanel.addShowStringAndValue(")", null);
            exprPanel.addBackStageKeyAndSeq(this.getFunKey(), seq.getAndIncrement());
            exprPanelList.add(exprPanel);
        });
        return exprPanelList;
    }

    public String toShrekString(Environment env) {
        throw new KDBizException("unsupported toShrek");
    }

    public Map<String, Set<String>> analyzeRange(Map<String, Set<String>> leftRange, Evaluator evaluator) {
        Map newLeftRange = this.getNewLeftRange(leftRange);
        Map<String, Set<String>> arg0 = this.args.get(0).analyzeRange(newLeftRange, evaluator);
        Map<String, Set<String>> arg1 = this.args.get(1).analyzeRange(newLeftRange, evaluator);
        return RangeMapUtils.union((String[])evaluator.getDimensionNum(), arg0, arg1);
    }

    public Set<String> checkRuleEnlarge(RuleEnlargeEvaluator evaluator) {
        Set<String> args0 = this.args.get(0).checkRuleEnlarge(evaluator);
        Set<String> args1 = this.args.get(1).checkRuleEnlarge(evaluator);
        return this.getRuleEnlarge(args0, args1);
    }

    public void doCheck(CheckEnvironment env) {
        env.setParentToolEnum(ToolEnum.PeriodShift);
        MdxMemberExpr mdxMemberExpr = (MdxMemberExpr)this.args.get(0);
        ParseUtils.checkReturnIsNumber((IExpress)mdxMemberExpr, (CheckEnvironment)env);
        ParseUtils.checkReturnIsNumber((IExpress)this.args.get(1), (CheckEnvironment)env);
        mdxMemberExpr.doCheck(env);
        this.args.get(1).doCheck(env);
        env.addHasPeriodShiftMember(mdxMemberExpr.getName());
        env.addMemberAggType(mdxMemberExpr.getName(), AggType.PERIODSHIFT.getIndex());
        env.setParentToolEnum(null);
    }

    public FunReturnType getReturnType() {
        return FunReturnType.Numeric;
    }

    public List<IExpress> getArgs() {
        return this.args;
    }

    public void setArgs(List<IExpress> args) {
        this.args = args;
    }
}

