/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.execute.impl.expr.expr;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.enums.AggType;
import kd.epm.eb.common.rule.edit.ToolEnum;
import kd.epm.eb.olap.impl.execute.RuleEnlargeEvaluator;
import kd.epm.eb.olap.impl.execute.face.IExpress;
import kd.epm.eb.olap.impl.execute.impl.CheckEnvironment;
import kd.epm.eb.olap.impl.execute.impl.Environment;
import kd.epm.eb.olap.impl.execute.impl.Evaluator;
import kd.epm.eb.olap.impl.execute.impl.expr.FunReturnType;
import kd.epm.eb.olap.impl.execute.impl.expr.ParseUtils;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.AbstractFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.MdxMemberExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.SetFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.SingleMemberExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanel;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.ExprPanelType;
import kd.epm.eb.olap.impl.execute.impl.expr.panel.PanelEnvironment;

public class SumFun
extends AbstractFun {
    private MdxMemberExpr memberExpr;
    private SetFun setFun;

    public List<IExpress> getChildren() {
        return Lists.newArrayList((Object[])new IExpress[]{this.memberExpr, this.setFun});
    }

    public MdxMemberExpr getMemberExpr() {
        return this.memberExpr;
    }

    public void setMemberExpr(MdxMemberExpr memberExpr) {
        this.memberExpr = memberExpr;
    }

    public SetFun getSetExpr() {
        return this.setFun;
    }

    public void setSetExpr(SetFun setFun) {
        this.setFun = setFun;
    }

    public String toMdx(Environment env) {
        String memberMdx = this.memberExpr.toMdx(env, true);
        String setMdx = this.setFun.toMdx(env);
        if (this.setFun instanceof SingleMemberExpr) {
            setMdx = "{" + setMdx + "}";
        }
        setMdx = "Distinct(" + setMdx + ")";
        if (memberMdx.isEmpty()) {
            return "Sum({" + setMdx + "})";
        }
        return "Sum({" + setMdx + '*' + memberMdx + "})";
    }

    public FunReturnType getReturnType() {
        return FunReturnType.Numeric;
    }

    public List<ExprPanel> toPanel(PanelEnvironment env) {
        LinkedList panels = Lists.newLinkedList();
        int seq = 0;
        ExprPanel panel1 = new ExprPanel(this.getFunKey() + seq, ExprPanelType.String, false);
        panel1.addShowStringAndValue("@SumRange(", null);
        panel1.addBackStageKeyAndSeq(this.getFunKey(), seq++);
        panels.add(panel1);
        panels.addAll(this.memberExpr.toPanel(env));
        ExprPanel panel2 = new ExprPanel(this.getFunKey() + seq, ExprPanelType.String, false);
        panel2.addShowStringAndValue(",", null);
        panel2.addBackStageKeyAndSeq(this.getFunKey(), seq++);
        panels.add(panel2);
        panels.addAll(this.setFun.toPanel(env));
        ExprPanel panel3 = new ExprPanel(this.getFunKey() + seq, ExprPanelType.String, false);
        panel3.addShowStringAndValue(")", null);
        panel3.addBackStageKeyAndSeq(this.getFunKey(), seq);
        panels.add(panel3);
        return panels;
    }

    public String toShrekString(Environment env) {
        throw new KDBizException("unsupported toShrek");
    }

    public Map<String, Set<String>> analyzeRange(Map<String, Set<String>> leftRange, Evaluator evaluator) {
        Map<String, Set<String>> rangeMap;
        Map newLeftRange = this.getNewLeftRange(leftRange);
        Map setMap = null;
        try {
            setMap = this.setFun.analyzeRange(newLeftRange, evaluator);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String dimNumber = this.setFun.getDimNumber();
        Map<String, Set<String>> leftRange2 = newLeftRange.entrySet().stream().filter(k -> !((String)k.getKey()).equals(dimNumber)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (n1, n2) -> n2));
        if (setMap != null && setMap.containsKey(dimNumber)) {
            leftRange2.put(dimNumber, (Set<String>)setMap.get(dimNumber));
        }
        if ((rangeMap = this.memberExpr.analyzeRange(leftRange2, evaluator)).isEmpty()) {
            return rangeMap;
        }
        rangeMap.put(dimNumber, leftRange.get(dimNumber));
        return rangeMap;
    }

    public Set<String> checkRuleEnlarge(RuleEnlargeEvaluator evaluator) {
        Set<String> args0 = this.memberExpr.checkRuleEnlarge(evaluator);
        Set args1 = this.setFun.checkRuleEnlarge(evaluator);
        return this.getRuleEnlarge(args0, args1);
    }

    public void doCheck(CheckEnvironment env) {
        env.setParentToolEnum(ToolEnum.SumRange);
        this.memberExpr.doCheck(env);
        ParseUtils.checkReturnIsNumber((IExpress)this.memberExpr, (CheckEnvironment)env);
        env.setRangeDataSetId(this.getRangeDatasetId(env, this.memberExpr.getName()));
        this.setFun.doCheck(env);
        env.addFunKeyRefMemKey(this.setFun.getFunKey(), this.memberExpr.getName());
        env.addFunKeyRefParentFunKey(this.setFun.getFunKey(), this.getFunKey());
        env.addMemberAggType(this.memberExpr.getName(), AggType.SUM.getIndex());
        env.checkFunAndMemberRefDim(this.setFun.getFunKey(), this.memberExpr.getName());
        env.setParentToolEnum(null);
    }
}

