/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.impl.utils.rule;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.rule.execute.RuleExecuteTypeEnum;
import kd.epm.eb.common.template.TemplateMemberModel;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.impl.execute.impl.Evaluator;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.BinaryExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.parse.Parse2RPN;
import kd.epm.eb.olap.utils.PageUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Triple;

public class RuleOptimizeUtil {
    private static final Log log = LogFactory.getLog(RuleOptimizeUtil.class);

    public static Map<String, Set<String>> optimizeByEntity(IModelCacheHelper modelCache, Long dataSetId, Map<String, Set<String>> queryMemberMap, RuleDto ruleDto, int exePartition, String source) {
        List entitypartition;
        if (MapUtils.isEmpty((Map)ruleDto.getRightPageMembers())) {
            return new HashMap<String, Set<String>>(queryMemberMap);
        }
        String formulaString = ruleDto.getFormulaString();
        Parse2RPN parse2RPN = new Parse2RPN(formulaString);
        parse2RPN.parse();
        BinaryExpr expr = (BinaryExpr)parse2RPN.getExpr();
        Dataset dataSet = DatasetServiceHelper.getInstance().getDataSet(dataSetId);
        String[] dimensionNums = modelCache.getDimensionNums(dataSetId);
        String partDimension = SysDimensionEnum.Entity.getNumber();
        Set<String> entitySet = queryMemberMap.get(partDimension);
        Long mainDimensionId = ruleDto.getMainDimensionId();
        Dimension dimension = modelCache.getDimension(mainDimensionId);
        int maxSize = 0;
        if (entitySet.size() > 200 || dimension != null && dimension.getNumber().equals(partDimension)) {
            log.info(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6570\u91cf\u8d85\u8fc7200\u4e2a\uff0c\u8bf7\u4ee5\u53e6\u4e00\u4e2a\u7ef4\u5ea6\u4f5c\u4e3a\u57fa\u51c6\u3002", (String)"ExecuteRuleServiceImpl_35", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            for (Map.Entry<String, Set<String>> entry : queryMemberMap.entrySet()) {
                String dimNumber = entry.getKey();
                int size = entry.getValue().size();
                if (size > 200 || SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber) || dimension != null && dimension.getNumber().equals(dimNumber) || size <= maxSize) continue;
                maxSize = size;
                partDimension = dimNumber;
                entitySet = entry.getValue();
            }
        }
        Evaluator evaluator = new Evaluator(partDimension, ruleDto, modelCache, dimensionNums, dataSet);
        ArrayList returnCollection = Lists.newArrayListWithExpectedSize((int)entitySet.size());
        if (entitySet.size() > exePartition) {
            int pageSize = entitySet.size() / exePartition + 1;
            entitypartition = Lists.partition(new ArrayList<String>(entitySet), (int)pageSize);
        } else {
            entitypartition = Lists.partition(new ArrayList<String>(entitySet), (int)entitySet.size());
        }
        for (List entitys : entitypartition) {
            evaluator.clearCollect();
            HashMap partEntityMap = Maps.newHashMap(queryMemberMap);
            partEntityMap.put(partDimension, Sets.newHashSet((Iterable)entitys));
            Map<String, Set<String>> hasTrimMap = RuleExecuteTypeEnum.DEPEN.getType().equals(source) ? expr.getRight().analyzeRange(partEntityMap, evaluator) : expr.analyzeRange(partEntityMap, evaluator);
            if (hasTrimMap == null) {
                returnCollection.add(partEntityMap);
                continue;
            }
            if (hasTrimMap.isEmpty() || hasTrimMap.size() == 1 && "ignore".equals(hasTrimMap.entrySet().iterator().next().getKey())) continue;
            returnCollection.add(hasTrimMap);
        }
        HashMap unionMap = Maps.newHashMapWithExpectedSize((int)queryMemberMap.size());
        for (Map sub : returnCollection) {
            kd.epm.eb.common.utils.MapUtils.mergeMap((Map)sub, (Map)unionMap);
        }
        return unionMap;
    }

    public static List<Triple<Map<String, Set<String>>, List<String>, List<String[]>>> getTemplateRowRelation(Map<Long, Set<Long>> templateMap, RuleDto executeRule, Map<String, Set<String>> calcMemberInfo, Long currTemplateId, Map<Long, TemplateMemberModel> templateMemberModelMap, IModelCacheHelper modelCache) {
        ArrayList olapRelationList = new ArrayList(10);
        HashSet templateIds = templateMap.get(executeRule.getId());
        if (currTemplateId != null && currTemplateId > 0L) {
            templateIds = Sets.newHashSet((Object[])new Long[]{currTemplateId});
        }
        if (CollectionUtils.isEmpty(templateIds)) {
            log.info(executeRule.getNumber() + "\uff1a\u89c4\u5219\u6ca1\u5173\u8054\u5230\u6a21\u7248");
            Iterator olapRelation = PageUtil.getOlapRelationPage(calcMemberInfo, executeRule, modelCache, 1);
            olapRelationList.add(olapRelation);
        } else {
            log.info(executeRule.getNumber() + "\uff0c\u5173\u8054\u6a21\u7248:" + templateIds);
            for (Long templateId : templateIds) {
                TemplateMemberModel memberRel = RuleOptimizeUtil.getTempateInfo(templateMemberModelMap, modelCache, templateId);
                for (TemplateMemberModel.AreaMemberRel area : memberRel.getAreaMemberRelList()) {
                    boolean isFloat;
                    HashMap hashMap = Maps.newHashMapWithExpectedSize((int)calcMemberInfo.size());
                    kd.epm.eb.common.utils.MapUtils.mergeMap(calcMemberInfo, (Map)hashMap);
                    HashMap areaMap = new HashMap(10);
                    areaMap.putAll(memberRel.getPageMember());
                    areaMap.putAll(memberRel.getViewMember());
                    areaMap.putAll(area.getRowColMember());
                    boolean isCalc = true;
                    for (Map.Entry entry : hashMap.entrySet()) {
                        String dim = (String)entry.getKey();
                        if (memberRel.getVarDimSet().contains(dim)) continue;
                        Set memSet = (Set)entry.getValue();
                        Set areaSet = (Set)areaMap.get(dim);
                        if (CollectionUtils.isEmpty((Collection)areaSet)) continue;
                        memSet.retainAll(areaSet);
                        if (!memSet.isEmpty()) continue;
                        isCalc = false;
                        break;
                    }
                    if (!isCalc) {
                        log.info("\u4e0e\u6a21\u7248\u533a\u57df\u8303\u56f4\u65e0\u4ea4\u96c6\uff0c\u4e0d\u8ba1\u7b97\uff1a" + templateId);
                        continue;
                    }
                    boolean bl = isFloat = area.getFloatOnWhere() != -1;
                    if (isFloat) {
                        log.info(executeRule.getNumber() + "-\u6d6e\u52a8\u6a21\u7248" + templateId);
                        Triple<Map<String, Set<String>>, List<String>, List<String[]>> olapRelation = PageUtil.getOlapRelationPage(hashMap, executeRule, modelCache, 1);
                        olapRelationList.add(olapRelation);
                        continue;
                    }
                    log.info(executeRule.getNumber() + "-\u975e\u6d6e\u52a8\u6a21\u7248\uff1a" + templateId + ",\u533a\u57df\uff1a" + area.getAreaIndex());
                    List rowMemberRelDims = area.getRowMemberRelDims();
                    List rowMemberRelList = area.getRowMemberRelList();
                    if (!CollectionUtils.isNotEmpty((Collection)rowMemberRelDims)) continue;
                    List<String[]> rowRelList = Lists.newArrayListWithExpectedSize((int)rowMemberRelList.size());
                    for (String[] row : rowMemberRelList) {
                        boolean contain = true;
                        for (int index = 0; index < row.length; ++index) {
                            if (((Set)hashMap.get(rowMemberRelDims.get(index))).contains(row[index])) continue;
                            contain = false;
                            break;
                        }
                        if (!contain) continue;
                        rowRelList.add(row);
                    }
                    if ((rowRelList = (List)rowRelList.stream().collect(Collectors.collectingAndThen(Collectors.toMap(Arrays::toString, array -> array, (array1, array2) -> array1), map -> new ArrayList(map.values())))).isEmpty()) {
                        log.info("\u6210\u5458\u5173\u7cfb\u4e3a\u7a7a\uff0c\u4e0d\u8ba1\u7b97");
                        continue;
                    }
                    Map relMap = kd.epm.eb.common.utils.MapUtils.relRowToMap(rowRelList, (List)rowMemberRelDims);
                    hashMap.putAll(relMap);
                    HashMap excludeRelDimMap = new HashMap(hashMap);
                    rowMemberRelDims.forEach(excludeRelDimMap::remove);
                    BigInteger mapSum = kd.epm.eb.common.utils.MapUtils.calcDescartes(excludeRelDimMap);
                    BigInteger calcCnt = mapSum.multiply(BigInteger.valueOf(rowRelList.size()));
                    if (BigInteger.valueOf(1000000L).compareTo(calcCnt) < 0) {
                        log.info("\u6a21\u7248\u8303\u56f4\u4ea4\u51fa\u6765\u7684\u8303\u56f4\u5927\u4e8e100\u4e07\uff0c\u4f7f\u7528\u6570\u636e\u5173\u7cfb\u4f18\u5316");
                        Triple<Map<String, Set<String>>, List<String>, List<String[]>> olapRelation = PageUtil.getOlapRelationPage(hashMap, executeRule, modelCache, 1);
                        boolean retain = true;
                        for (Map.Entry entry : excludeRelDimMap.entrySet()) {
                            String dim = (String)entry.getKey();
                            Set memSet = (Set)entry.getValue();
                            Set optSet = ((Map)olapRelation.getLeft()).computeIfAbsent(dim, v -> Collections.emptySet());
                            memSet.retainAll(optSet);
                            if (!memSet.isEmpty()) continue;
                            retain = false;
                            break;
                        }
                        if (!retain) {
                            log.info("\u6a21\u7248\u8303\u56f4\u4ea4\u51fa\u6765\u7684\u8303\u56f4\u4e0e\u6570\u636e\u5173\u7cfb\u4f18\u5316\u5904\u7406\u7684\u8303\u56f4\u65e0\u4ea4\u96c6\uff0c\u4e0d\u8ba1\u7b97");
                            continue;
                        }
                        hashMap.putAll(excludeRelDimMap);
                    }
                    rowRelList.add(0, (String[])rowMemberRelDims.stream().map(e -> modelCache.getDimension(e).getShortNumber()).toArray(String[]::new));
                    log.info("\u6210\u5458\u5173\u7cfb\u7ef4\u5ea6\u3010" + rowMemberRelDims + "\u3011\uff0c\u6210\u5458\u5173\u7cfb\u6570\u91cf\uff1a" + rowRelList.size());
                    olapRelationList.add(Triple.of((Object)hashMap, (Object)rowMemberRelDims, rowRelList));
                }
            }
        }
        ArrayList<Triple<Map<String, Set<String>>, List<String>, List<String[]>>> distinctList = new ArrayList<Triple<Map<String, Set<String>>, List<String>, List<String[]>>>(olapRelationList.size());
        for (int i = 0; i < olapRelationList.size(); ++i) {
            Triple obj = (Triple)olapRelationList.get(i);
            if (distinctList.isEmpty()) {
                distinctList.add((Triple<Map<String, Set<String>>, List<String>, List<String[]>>)obj);
                continue;
            }
            int diffCnt = 0;
            for (Triple triple : distinctList) {
                boolean diff = true;
                if (((List)triple.getMiddle()).equals(obj.getMiddle()) && triple.getRight() != null && obj.getRight() != null && ((List)obj.getRight()).size() == ((List)triple.getRight()).size()) {
                    boolean memDiff = false;
                    for (Map.Entry entry : ((Map)obj.getLeft()).entrySet()) {
                        Set objMemSet = (Set)entry.getValue();
                        Set distinctMemSet = (Set)((Map)triple.getLeft()).get(entry.getKey());
                        if (objMemSet == null || distinctMemSet == null || Sets.difference((Set)objMemSet, (Set)distinctMemSet).isEmpty()) continue;
                        memDiff = true;
                        break;
                    }
                    if (!memDiff) {
                        diff = false;
                    }
                }
                if (!diff) continue;
                ++diffCnt;
            }
            if (diffCnt != distinctList.size()) continue;
            distinctList.add((Triple<Map<String, Set<String>>, List<String>, List<String[]>>)obj);
        }
        return distinctList;
    }

    public static List<Map<String, Set<String>>> getTemplateOptMap(Map<Long, Set<Long>> templateMap, RuleDto executeRule, Map<String, Set<String>> calcMemberInfo, Map<Long, TemplateMemberModel> templateMemberModelMap, IModelCacheHelper modelCache) {
        ArrayList<Map<String, Set<String>>> optList = new ArrayList<Map<String, Set<String>>>(10);
        Set<Long> templateIds = templateMap.get(executeRule.getId());
        if (CollectionUtils.isEmpty(templateIds)) {
            log.info(executeRule.getNumber() + "\uff1a\u89c4\u5219\u6ca1\u5173\u8054\u5230\u6a21\u7248,\u4e0d\u8ba1\u7b97");
            return optList;
        }
        log.info(executeRule.getNumber() + "\uff0c\u5173\u8054\u6a21\u7248:" + templateIds);
        for (Long templateId : templateIds) {
            TemplateMemberModel memberRel = RuleOptimizeUtil.getTempateInfo(templateMemberModelMap, modelCache, templateId);
            for (TemplateMemberModel.AreaMemberRel area : memberRel.getAreaMemberRelList()) {
                HashMap exeMap = Maps.newHashMapWithExpectedSize((int)calcMemberInfo.size());
                kd.epm.eb.common.utils.MapUtils.mergeMap(calcMemberInfo, (Map)exeMap);
                HashMap areaMap = new HashMap(10);
                areaMap.putAll(memberRel.getPageMember());
                areaMap.putAll(memberRel.getViewMember());
                areaMap.putAll(area.getRowColMember());
                boolean isCalc = true;
                for (Map.Entry entry : exeMap.entrySet()) {
                    String dim = (String)entry.getKey();
                    if (memberRel.getVarDimSet().contains(dim)) continue;
                    Set memSet = (Set)entry.getValue();
                    Set areaSet = (Set)areaMap.get(dim);
                    if (CollectionUtils.isEmpty((Collection)areaSet)) continue;
                    memSet.retainAll(areaSet);
                    if (!memSet.isEmpty()) continue;
                    isCalc = false;
                    break;
                }
                if (!isCalc) continue;
                optList.add(exeMap);
            }
        }
        return optList;
    }

    private static TemplateMemberModel getTempateInfo(Map<Long, TemplateMemberModel> templateMemberModelMap, IModelCacheHelper modelCache, Long templateId) {
        TemplateMemberModel memberRel = templateMemberModelMap.computeIfAbsent(templateId, v -> (TemplateMemberModel)DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"TemplateService", (String)"getMemberRel", (Object[])new Object[]{modelCache.getModelobj().getId(), templateId}));
        return memberRel;
    }
}

