/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.threadlocal.EpmThreadLocalUtils;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.FixMember;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.membPerm.DimMemberPermChecker;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.olap.api.base.IKDValue;
import kd.epm.eb.olap.api.metadata.IKDCell;
import kd.epm.eb.olap.impl.base.KDValue;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.impl.metadata.KDCell;
import kd.epm.eb.olap.service.LeafFeature;
import kd.epm.eb.olap.service.request.AlgoCalcRequest;
import kd.epm.eb.olap.service.request.QueryRequest;
import kd.epm.eb.olap.service.request.SaveRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class AlgoCalcUtils {
    private static final Log log = LogFactory.getLog(AlgoCalcUtils.class);

    public static List<FixMember> genFixMembers(String calcDimNumber, Map<String, Set<String>> memberMap, Map<String, Set<String>> refPropMap, List<String> ignoreDim) {
        return AlgoCalcUtils.genFixMembers(calcDimNumber, memberMap, new HashMap<String, Set<String>>(1), refPropMap, ignoreDim);
    }

    public static List<FixMember> genFixMembers(String calcDimNumber, Map<String, Set<String>> memberMap, Map<String, Set<String>> otherCubeAllMembers, Map<String, Set<String>> refPropMap, List<String> ignoreDim) {
        ArrayList fixMembers = Lists.newArrayList();
        for (Map.Entry<String, Set<String>> entry : memberMap.entrySet()) {
            String dimNumber = entry.getKey();
            if (calcDimNumber.equals(dimNumber) || SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber) || SysDimensionEnum.Metric.getNumber().equals(dimNumber) || refPropMap.containsKey(dimNumber) || ignoreDim.contains(dimNumber)) continue;
            Set<String> queryMembers = entry.getValue();
            Set<String> otherCubeMember = otherCubeAllMembers.get(dimNumber);
            if (queryMembers.size() != 1 || otherCubeMember != null && otherCubeMember.size() > 1) continue;
            fixMembers.add(new FixMember(dimNumber, queryMembers.iterator().next()));
        }
        return fixMembers;
    }

    public static String genMdxQuerySql(IModelCacheHelper modelCache, String mdxCubeName, Map<String, Set<String>> memberInfo, List<FixMember> fixMemberList, List<String> bizModelSelectDim) {
        Collection<String> members;
        Dimension dimension;
        ArrayList rowColDims = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList whereDims = Lists.newArrayListWithExpectedSize((int)16);
        HashMap<String, Set<String>> queryInfo = new HashMap<String, Set<String>>();
        for (String dimNumber : bizModelSelectDim) {
            Set<String> members2 = memberInfo.get(dimNumber);
            if (members2 == null || memberInfo.isEmpty() || members2.size() == 1) {
                whereDims.add(dimNumber);
            } else {
                rowColDims.add(dimNumber);
            }
            if (members2 == null || memberInfo.isEmpty()) {
                queryInfo.put(dimNumber, Sets.newHashSet((Object[])new String[]{modelCache.getDimension(dimNumber).getNoneNumber()}));
                continue;
            }
            queryInfo.put(dimNumber, members2);
        }
        while (rowColDims.size() < 2) {
            String luckyDim = (String)whereDims.remove(0);
            rowColDims.add(luckyDim);
        }
        StringBuilder rowTubles = new StringBuilder();
        StringBuilder colTubles = new StringBuilder();
        StringBuilder whereTubles = new StringBuilder();
        for (int i = 0; i < rowColDims.size(); ++i) {
            String dimNumber = (String)rowColDims.get(i);
            dimension = modelCache.getDimension(dimNumber);
            members = (List<String>)queryInfo.get(dimNumber);
            String dimHeadStr = "`" + dimension.getShortNumber() + "`";
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) {
                members = AlgoCalcUtils.sortMembersByBp(members);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            for (String member : members) {
                sb.append(dimHeadStr).append(" -> ").append("`").append(member).append("`").append(",");
            }
            sb.setCharAt(sb.length() - 1, '}');
            if (i % 2 == 0) {
                rowTubles.append((CharSequence)sb).append(" * ");
                continue;
            }
            colTubles.append((CharSequence)sb).append(" * ");
        }
        rowTubles.setLength(rowTubles.length() - 3);
        colTubles.setLength(colTubles.length() - 3);
        if (CollectionUtils.isNotEmpty((Collection)whereDims)) {
            whereTubles.append("(");
            for (String dimNumber : whereDims) {
                dimension = modelCache.getDimension(dimNumber);
                members = (Set)queryInfo.get(dimNumber);
                String memberNumber = (String)members.iterator().next();
                String memberMdxString = "`" + dimension.getShortNumber() + "` -> `" + memberNumber + "`";
                whereTubles.append(memberMdxString).append(",");
            }
            whereTubles.setCharAt(whereTubles.length() - 1, ')');
        }
        String sql = "select " + rowTubles + " * {measures.va} on rows," + colTubles + " on columns from " + mdxCubeName;
        if (whereTubles.length() > 0) {
            sql = sql + " where " + whereTubles;
        }
        return sql;
    }

    public static String genMemberRelMdxQuerySql(IModelCacheHelper modelCache, String mdxCubeName, AlgoCalcRequest request, List<FixMember> fixMemberList, List<String> bizModelSelectDim) {
        List<String> members;
        Dimension dimension;
        ArrayList rowDims = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList colDims = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList whereDims = Lists.newArrayListWithExpectedSize((int)16);
        Map<String, Set<String>> memberInfo = request.getMemberInfo();
        HashMap<String, Set<String>> queryInfo = new HashMap<String, Set<String>>();
        for (String dimNumber : bizModelSelectDim) {
            Set<String> members2 = memberInfo.get(dimNumber);
            if (request.getRowMemberRelDims().contains(dimNumber)) {
                rowDims.add(dimNumber);
            } else if (members2 == null || memberInfo.isEmpty() || members2.size() == 1) {
                whereDims.add(dimNumber);
            } else {
                colDims.add(dimNumber);
            }
            if (members2 == null || memberInfo.isEmpty()) {
                queryInfo.put(dimNumber, Sets.newHashSet((Object[])new String[]{modelCache.getDimension(dimNumber).getNoneNumber()}));
                continue;
            }
            queryInfo.put(dimNumber, members2);
        }
        while (rowDims.size() < 2) {
            String luckyDim = (String)whereDims.remove(0);
            rowDims.add(luckyDim);
        }
        StringBuilder rowTubles = new StringBuilder();
        StringBuilder colTubles = new StringBuilder();
        StringBuilder whereTubles = new StringBuilder();
        for (int i = 0; i < bizModelSelectDim.size(); ++i) {
            String dimNumber = bizModelSelectDim.get(i);
            if (whereDims.contains(dimNumber)) continue;
            dimension = modelCache.getDimension(dimNumber);
            members = (List<String>)queryInfo.get(dimNumber);
            String dimHeadStr = "`" + dimension.getShortNumber() + "`";
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber)) {
                members = AlgoCalcUtils.sortMembersByBp((Collection<String>)members);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            for (String member : members) {
                sb.append(dimHeadStr).append(" -> ").append("`").append(member).append("`").append(",");
            }
            sb.setCharAt(sb.length() - 1, '}');
            if (rowDims.contains(dimNumber)) {
                rowTubles.append((CharSequence)sb).append(" * ");
                continue;
            }
            if (!colDims.contains(dimNumber)) continue;
            colTubles.append((CharSequence)sb).append(" * ");
        }
        rowTubles.setLength(rowTubles.length() - 3);
        if (colTubles.length() > 3) {
            colTubles.setLength(colTubles.length() - 3);
        }
        if (CollectionUtils.isNotEmpty((Collection)whereDims)) {
            whereTubles.append("(");
            for (String dimNumber : whereDims) {
                dimension = modelCache.getDimension(dimNumber);
                members = (Set)queryInfo.get(dimNumber);
                String memberNumber = (String)members.iterator().next();
                String memberMdxString = "`" + dimension.getShortNumber() + "` -> `" + memberNumber + "`";
                whereTubles.append(memberMdxString).append(",");
            }
            whereTubles.setCharAt(whereTubles.length() - 1, ')');
        }
        String sql = colTubles.length() > 3 ? "select " + rowTubles + " on rows," + colTubles + " * {measures.va} on columns from " + mdxCubeName : "select " + rowTubles + " on rows, {measures.va} on columns from " + mdxCubeName;
        if (whereTubles.length() > 0) {
            sql = sql + " where " + whereTubles;
        }
        return sql;
    }

    public static List<String> sortMembersByBp(Collection<String> members) {
        HashMap bgMap = Maps.newHashMapWithExpectedSize((int)members.size());
        for (String member : members) {
            bgMap.put(AlgoCalcUtils.extractKey(member), member);
        }
        List<String> sortBp = bgMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).collect(Collectors.toList());
        return sortBp;
    }

    private static int extractKey(String element) {
        if (element.startsWith("BudgetPeriod")) {
            return Integer.MAX_VALUE;
        }
        if (element.startsWith("FY")) {
            int year = Integer.parseInt(element.substring(2, 6));
            if (element.length() < 7) {
                return year * 100 + 99;
            }
            String type = element.substring(7);
            if (type.startsWith("M")) {
                int month = Integer.parseInt(type.substring(1));
                return year * 100 + (month - 1) / 3 * 10 + (month - 1) % 3;
            }
            if (type.startsWith("Q")) {
                int qu = Integer.parseInt(type.substring(1).replace("._inv", ""));
                return year * 100 + (qu - 1) * 10 + 4;
            }
            if (type.startsWith("HF")) {
                int hf = Integer.parseInt(type.substring(2).replace("._inv", ""));
                return year * 100 + hf * 20 - 10 + 5;
            }
        }
        return Integer.MAX_VALUE;
    }

    public static Set<String> calcBp(IModelCacheHelper modelCache, Set<String> originBpSet, Integer min, Integer max) {
        HashSet<String> calcBp = new HashSet<String>(originBpSet);
        HashMap<Integer, List> bpMemberForLevel = new HashMap<Integer, List>(16);
        for (String bpNumber : originBpSet) {
            Member bpMember = modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, bpNumber);
            int level = bpMember.getLevel();
            List bpMembers = bpMemberForLevel.computeIfAbsent(level, v -> new ArrayList(16));
            bpMembers.add(bpNumber);
        }
        HashSet fillSet = Sets.newHashSet();
        for (Map.Entry entry : bpMemberForLevel.entrySet()) {
            Member memberOffset;
            int i;
            List leafBpMembers = (List)entry.getValue();
            String minLeafBpNumber = (String)leafBpMembers.stream().min(String::compareTo).get();
            String maxLeafBpNumber = (String)leafBpMembers.stream().max(String::compareTo).get();
            fillSet.addAll(modelCache.getMemberBetween(SysDimensionEnum.BudgetPeriod.getNumber(), minLeafBpNumber, maxLeafBpNumber, true).stream().map(BaseCache::getNumber).collect(Collectors.toList()));
            if (min < 0) {
                for (i = min.intValue(); i < 0; ++i) {
                    memberOffset = modelCache.getMemberOffset(SysDimensionEnum.BudgetPeriod.getNumber(), minLeafBpNumber, i);
                    if (memberOffset != null) {
                        fillSet.add(memberOffset.getNumber());
                        continue;
                    }
                    fillSet.add(minLeafBpNumber);
                }
            }
            if (max <= 0) continue;
            for (i = 1; i <= max; ++i) {
                memberOffset = modelCache.getMemberOffset(SysDimensionEnum.BudgetPeriod.getNumber(), maxLeafBpNumber, i);
                if (memberOffset != null) {
                    fillSet.add(memberOffset.getNumber());
                    continue;
                }
                fillSet.add(maxLeafBpNumber);
            }
        }
        calcBp.addAll(fillSet);
        return calcBp;
    }

    public static String genCalcDimNumber(IModelCacheHelper modelCache, List<RuleDto> rules) {
        Set dimSet = rules.stream().map(RuleDto::getMainDimensionId).collect(Collectors.toSet());
        if (dimSet.size() == 1) {
            return modelCache.getDimension((Long)dimSet.iterator().next()).getNumber();
        }
        return SysDimensionEnum.Account.getNumber();
    }

    public static boolean fixMemberHasNotLeaf(List<FixMember> fixMembers, Set<String> datasetContainsDim, Map<String, Long> viewMap, IModelCacheHelper modelCache) {
        if (viewMap == null) {
            viewMap = new HashMap<String, Long>(1);
        }
        for (FixMember fixMember : fixMembers) {
            Member member;
            String dimNumber = fixMember.getDimNumber();
            if (!datasetContainsDim.contains(dimNumber) || (member = modelCache.getMember(dimNumber, viewMap.get(dimNumber), fixMember.getMemberNumber())) == null || member.isLeaf()) continue;
            return true;
        }
        return false;
    }

    public static IKDCell toKDCell(BGCell bgCell) {
        String[] meta = bgCell.getMemberMap().values().toArray(new String[0]);
        IKDValue value = KDValue.valueOf((Object)bgCell.getValue());
        IKDCell cell = KDCell.of((String[])meta);
        cell.setValue(value);
        return cell;
    }

    public static List<BGCell> toBGCell(List<IKDCell> kdCells, IModelCacheHelper modelCache, Long bizModelId, Map<IKDCell, Map<String, Long>> kdCellViewMap) {
        ArrayList<BGCell> cells = new ArrayList<BGCell>(kdCells.size());
        List dimensions = modelCache.getDimensionList(bizModelId);
        for (IKDCell kdCell : kdCells) {
            BGCell cell = AlgoCalcUtils.toBGCell(kdCell, modelCache, dimensions, kdCellViewMap.get(kdCell));
            cells.add(cell);
        }
        return cells;
    }

    public static BGCell toBGCell(IKDCell kdCell, IModelCacheHelper modelCache, List<Dimension> dimensions) {
        return AlgoCalcUtils.toBGCell(kdCell, modelCache, dimensions, null);
    }

    public static BGCell toBGCell(IKDCell kdCell, IModelCacheHelper modelCache, List<Dimension> dimensions, Map<String, Long> dimViewMap) {
        String[] number = kdCell.getMeta().getNumber();
        HashMap memberMap = Maps.newHashMapWithExpectedSize((int)dimensions.size());
        for (int i = 0; i < dimensions.size(); ++i) {
            String dimNumber = dimensions.get(i).getNumber();
            if (dimViewMap != null) {
                Long viewId = dimViewMap.get(dimNumber);
                Member member = modelCache.getMember(dimNumber, viewId, number[i]);
                if (member == null) continue;
                memberMap.put(dimNumber, member.getNumber());
                continue;
            }
            memberMap.put(dimNumber, number[i]);
        }
        return new BGCell((Map)memberMap, kdCell.getValue().getValue());
    }

    public static List<RuleDto> filterRuleByScope(Map<String, Set<String>> queryInfoScope, List<RuleDto> rules, LeafFeature leafFeature) {
        ArrayList newRules = Lists.newArrayListWithExpectedSize((int)rules.size());
        for (RuleDto rule : rules) {
            LeafFeature newLeafFeature = rule.getNewLeafFeature();
            if (newLeafFeature != LeafFeature.ALL && leafFeature != null && !leafFeature.isEquals(newLeafFeature)) continue;
            boolean checked = true;
            Map leftRefMembers = rule.getLeftMembers();
            for (Map.Entry entry : leftRefMembers.entrySet()) {
                String dimNumber = (String)entry.getKey();
                Set leftMembers = (Set)entry.getValue();
                Set<String> queryMembers = queryInfoScope.get(dimNumber);
                Set<Object> intersection = Sets.newHashSet();
                if (queryMembers != null) {
                    intersection = leftMembers.stream().filter(queryMembers::contains).collect(Collectors.toSet());
                }
                if (!intersection.isEmpty()) continue;
                checked = false;
                break;
            }
            if (!checked) continue;
            newRules.add(rule);
        }
        return newRules;
    }

    public static LinkedList<BGCell> getOnlyNewChangeCell(List<BGCell> oldCells, List<BGCell> newCells, List<Dimension> dimensionList) {
        Map<String, BGCell> oldCellMap = oldCells.stream().collect(Collectors.toMap(cell -> cell.getKey2(dimensionList), v -> v, (v1, v2) -> v1));
        Map<String, BGCell> newCellMap = newCells.stream().collect(Collectors.toMap(cell -> cell.getKey2(dimensionList), v -> v, (v1, v2) -> v1.getUpdateTime() > v2.getUpdateTime() ? v1 : v2));
        LinkedList changeCells = Lists.newLinkedList();
        for (Map.Entry<String, BGCell> entry : newCellMap.entrySet()) {
            BGCell newCell;
            Object newValue;
            BGCell oldCell = oldCellMap.remove(entry.getKey());
            Object oldValue = oldCell == null ? null : oldCell.getValue();
            if (AlgoCalcUtils.equalsMetricValue(oldValue, newValue = (newCell = entry.getValue()).getValue(), false)) continue;
            changeCells.add(newCell);
            if (!AlgoCalcUtils.equalsMetricValue(newValue, null, false)) continue;
            newCell.setOldValue(oldValue);
        }
        return changeCells;
    }

    public static LinkedList<BGCell> getChangeCell(List<BGCell> oldCells, List<BGCell> newCells, List<Dimension> dimensionList) {
        Map<String, BGCell> oldCellMap = oldCells.stream().collect(Collectors.toMap(cell -> cell.getKey2(dimensionList), v -> v, (v1, v2) -> v1));
        Map<String, BGCell> newCellMap = newCells.stream().collect(Collectors.toMap(cell -> cell.getKey2(dimensionList), v -> v, (v1, v2) -> v1));
        LinkedList changeCells = Lists.newLinkedList();
        for (Map.Entry<String, BGCell> entry : newCellMap.entrySet()) {
            BGCell newCell;
            Object newValue;
            BGCell oldCell = oldCellMap.remove(entry.getKey());
            Object oldValue = oldCell == null ? null : oldCell.getValue();
            if (AlgoCalcUtils.equalsMetricValue(oldValue, newValue = (newCell = entry.getValue()).getValue(), true)) continue;
            changeCells.add(newCell);
            if (!AlgoCalcUtils.equalsMetricValue(newValue, null, true)) continue;
            newCell.setOldValue(oldValue);
        }
        if (MapUtils.isNotEmpty(oldCellMap)) {
            oldCellMap.values().forEach(cell -> {
                cell.setOldValue(cell.getValue());
                cell.setValue(null);
                changeCells.add(cell);
            });
        }
        return changeCells;
    }

    public static LinkedList<BGCell> getTrustCell(List<BGCell> oldCells, List<BGCell> dbCells, List<Dimension> dimensionList) {
        Map<String, BGCell> dbCellMap = dbCells.stream().collect(Collectors.toMap(cell -> cell.getKey2(dimensionList), v -> v, (v1, v2) -> v1));
        Map<String, BGCell> oldCellMap = oldCells.stream().collect(Collectors.toMap(cell -> cell.getKey2(dimensionList), v -> v, (v1, v2) -> v1));
        LinkedList updateCells = Lists.newLinkedList();
        for (Map.Entry<String, BGCell> entry : oldCellMap.entrySet()) {
            String key = entry.getKey();
            BGCell oldCell = entry.getValue();
            BGCell dbCell = dbCellMap.get(key);
            if (dbCellMap.containsKey(key)) {
                updateCells.add(dbCell);
                continue;
            }
            updateCells.add(oldCell);
        }
        return updateCells;
    }

    public static boolean equalsMetricValue(Object oldValue, Object newValue, boolean zeroIsNull) {
        if (oldValue == null && newValue == null) {
            return true;
        }
        if (oldValue == null) {
            if (newValue instanceof Number) {
                BigDecimal _v2 = AlgoCalcUtils.transToBigDecimal(newValue);
                return _v2.compareTo(BigDecimal.ZERO) == 0;
            }
            return false;
        }
        if (newValue == null) {
            if (zeroIsNull && oldValue instanceof Number) {
                BigDecimal _v1 = AlgoCalcUtils.transToBigDecimal(oldValue);
                return _v1.compareTo(BigDecimal.ZERO) == 0;
            }
            return false;
        }
        if (oldValue instanceof Number && newValue instanceof Number) {
            BigDecimal _v2;
            BigDecimal _v1 = AlgoCalcUtils.transToBigDecimal(oldValue);
            return _v1.compareTo(_v2 = AlgoCalcUtils.transToBigDecimal(newValue)) == 0;
        }
        return Objects.equals(oldValue, newValue);
    }

    private static BigDecimal transToBigDecimal(Object v1) {
        BigDecimal _v1 = v1 instanceof BigDecimal ? (BigDecimal)v1 : new BigDecimal(v1.toString());
        _v1 = _v1.setScale(15, 4);
        return _v1;
    }

    public static List<QueryRequest> filterPermRead(List<QueryRequest> requests, IModelCacheHelper modelCache) {
        ArrayList<QueryRequest> reqs = new ArrayList<QueryRequest>(requests.size());
        for (QueryRequest request : requests) {
            QueryRequest req = AlgoCalcUtils.filterPermRead(request, modelCache);
            if (req == null) continue;
            reqs.add(req);
        }
        return reqs;
    }

    public static AlgoCalcRequest filterPermRead(AlgoCalcRequest request, IModelCacheHelper modelCache) {
        QueryRequest req = new QueryRequest(request.getModelId(), request.getDatasetId(), request.getViewMap(), request.getMemberInfo(), null);
        QueryRequest filterRequest = AlgoCalcUtils.filterPermRead(req, modelCache);
        if (filterRequest == null) {
            return null;
        }
        request.setMemberInfo(filterRequest.getMemberInfo());
        return request;
    }

    public static List<BGCell> filterPermRead(List<BGCell> cells, long datasetId, Map<String, Long> viewMap, IModelCacheHelper modelCache) {
        Long modelId = modelCache.getModelobj().getId();
        List permDimGroups = DimMembPermHelper.getPermDimGroupWithData((Long)modelId, (Long)datasetId);
        if (CollectionUtils.isEmpty((Collection)permDimGroups)) {
            return cells;
        }
        DimMemberPermChecker readPermChecker = DimMembPermHelper.getReadPermChecker((Long)modelId, (Long)datasetId);
        if (readPermChecker.hasAllPerm()) {
            return cells;
        }
        ArrayList permDatas = Lists.newArrayListWithExpectedSize((int)cells.size());
        for (BGCell cell : cells) {
            HashMap memberGroup = Maps.newHashMap();
            cell.getMemberMap().forEach((dim, mem) -> {
                Member member;
                Long viewId = 0L;
                if (viewMap != null && viewMap.containsKey(dim)) {
                    viewId = (Long)viewMap.get(dim);
                }
                if ((member = modelCache.getMember(dim, viewId, mem)) != null) {
                    MemberItem mi = new MemberItem(true, member.getId());
                    memberGroup.put(dim, mi);
                }
            });
            if (!readPermChecker.check((Map)memberGroup)) continue;
            permDatas.add(cell);
        }
        return permDatas;
    }

    public static List<Object[]> filterPermRead(List<Object[]> objects, List<String> dims, long datasetId, Map<String, Long> viewMap, IModelCacheHelper modelCache) {
        if (objects.isEmpty()) {
            return objects;
        }
        Long modelId = modelCache.getModelobj().getId();
        List permDimGroups = DimMembPermHelper.getPermDimGroupWithData((Long)modelId, (Long)datasetId);
        if (CollectionUtils.isEmpty((Collection)permDimGroups)) {
            return objects;
        }
        DimMemberPermChecker readPermChecker = DimMembPermHelper.getReadPermChecker((Long)modelId, (Long)datasetId);
        if (readPermChecker.hasAllPerm()) {
            return objects;
        }
        ArrayList permDatas = Lists.newArrayListWithExpectedSize((int)objects.size());
        for (Object[] cell : objects) {
            HashMap memberGroup = Maps.newHashMap();
            int index = 1;
            for (String dimNumber : dims) {
                Long viewId;
                Member member = modelCache.getMember(dimNumber, viewId = viewMap != null ? viewMap.getOrDefault(dimNumber, 0L) : Long.valueOf(0L), (String)cell[index]);
                if (member != null) {
                    MemberItem mi = new MemberItem(true, member.getId());
                    memberGroup.put(dimNumber, mi);
                }
                ++index;
            }
            if (!readPermChecker.check((Map)memberGroup)) continue;
            permDatas.add(cell);
        }
        return permDatas;
    }

    public static QueryRequest filterPermRead(QueryRequest request, IModelCacheHelper modelCache) {
        HashMap permissionMap = Maps.newHashMapWithExpectedSize((int)16);
        for (String dimNumber : request.getMemberInfo().keySet()) {
            Long bizCtrlRangeId = modelCache.getBusModelByDataSet(request.getDatasetId());
            Long viewId = 0L;
            if (request.getViewMap() != null && request.getViewMap().containsKey(dimNumber)) {
                viewId = request.getViewMap().get(dimNumber);
            }
            Set permMemberNumbers = EpmThreadLocalUtils.getPermMembNumbers((String)dimNumber, (Long)request.getModelId(), (Long)bizCtrlRangeId, (Long)viewId, (DimMembPermType)DimMembPermType.READ, (boolean)true);
            permissionMap.put(dimNumber, permMemberNumbers);
        }
        HashMap<String, Set<String>> newQueryInfo = new HashMap<String, Set<String>>(16);
        for (Map.Entry<String, Set<String>> entry : request.getMemberInfo().entrySet()) {
            String dimNumber = entry.getKey();
            Set<String> value = entry.getValue();
            Set permMembNumbers = (Set)permissionMap.get(dimNumber);
            if (permMembNumbers == null) {
                newQueryInfo.put(dimNumber, value);
                continue;
            }
            Set hasPermSet = value.stream().filter(permMembNumbers::contains).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(hasPermSet)) {
                log.info("\u5f53\u524d\u7528\u6237\u6ca1\u6709(" + dimNumber + ")\u7ef4\u5ea6\u7684\u6210\u5458\u8bfb\u53d6\u6743\u9650");
                return null;
            }
            newQueryInfo.put(dimNumber, hasPermSet);
        }
        request.setMemberInfo(newQueryInfo);
        return request;
    }

    public static SaveRequest filterPermWrite(SaveRequest request, IModelCacheHelper modelCache) {
        Long modelId = modelCache.getModelobj().getId();
        DimMemberPermChecker writePermChecker = EpmThreadLocalUtils.getWritePermChecker((Long)modelId, (Long)request.getDatasetId());
        if (writePermChecker.hasAllPerm()) {
            return request;
        }
        ArrayList permDatas = Lists.newArrayListWithExpectedSize((int)request.getDatas().size());
        for (BGCell data : request.getDatas()) {
            HashMap memberGroup = Maps.newHashMap();
            data.getMemberMap().forEach((dim, mem) -> {
                Member member;
                Long viewId = 0L;
                if (request.getViewMap() != null && request.getViewMap().containsKey(dim)) {
                    viewId = (Long)request.getViewMap().get(dim);
                }
                if ((member = modelCache.getMember(dim, viewId, mem)) != null) {
                    MemberItem mi = new MemberItem(true, member.getId());
                    memberGroup.put(dim, mi);
                }
            });
            if (!writePermChecker.check((Map)memberGroup)) continue;
            permDatas.add(data);
        }
        request.setDatas((List)permDatas);
        return request;
    }

    public static String getCubeNumber(Long bizModelId) {
        Dataset dataSet = DatasetServiceHelper.getInstance().getDataSet(bizModelId);
        return AlgoCalcUtils.getCubeNumber(dataSet);
    }

    public static String getCubeNumber(Dataset dataSet) {
        return "CUBE" + dataSet.getNumber() + dataSet.getId();
    }
}

