/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.service;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.graph.MutableGraph;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.log.Stats;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.FloatRows;
import kd.epm.eb.common.olapdao.OlapReadOption;
import kd.epm.eb.common.olapdao.OlapWriteOption;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.params.ParamServiceHelper;
import kd.epm.eb.common.rule.execute.RuleExecuteTypeEnum;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.base.StrUtils;
import kd.epm.eb.common.utils.cache.Cache;
import kd.epm.eb.olap.impl.bizrule.RuleCacheService;
import kd.epm.eb.olap.impl.bizrule.RuleService;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.impl.bizrule.entity.RuleTemplateInfo;
import kd.epm.eb.olap.service.AlgoCalcUtils;
import kd.epm.eb.olap.service.CheckRuleSimpleUtils;
import kd.epm.eb.olap.service.LeafFeature;
import kd.epm.eb.olap.service.OlapCommService;
import kd.epm.eb.olap.service.OlapManager;
import kd.epm.eb.olap.service.RuleRetryService;
import kd.epm.eb.olap.service.biztemplate.CalcBizTemplate;
import kd.epm.eb.olap.service.biztemplate.SaveBizTemplate;
import kd.epm.eb.olap.service.enums.CheckResult;
import kd.epm.eb.olap.service.request.AlgoCalcRequest;
import kd.epm.eb.olap.service.request.FloatQueryRequest;
import kd.epm.eb.olap.service.request.Options;
import kd.epm.eb.olap.service.request.QueryRequest;
import kd.epm.eb.olap.service.request.SaveRequest;
import kd.epm.eb.olap.utils.PageUtil;
import kd.epm.eb.olap.utils.RuleGraphUtils;
import kd.epm.eb.olap.utils.TemplateParamUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;

public class OlapReportService {
    private static final Log log = LogFactory.getLog(OlapReportService.class);

    public static OlapReportService getInstance() {
        return InnerClass.instance;
    }

    public List<FloatRows> getFloatMember(long reportId, List<FloatQueryRequest> requests, String floatCalculate) {
        if (requests == null || requests.isEmpty()) {
            log.info(StrUtils.format((String)"getFloatMember requests is empty.", (Object[])new Object[0]));
            return new ArrayList<FloatRows>(16);
        }
        Stats stats = new Stats("getFloatMember");
        stats.appendMessage(StrUtils.format((String)"reportId: {},request size: {}", (Object[])new Object[]{reportId, requests.size()}));
        ArrayList floatRowsList = Lists.newArrayListWithExpectedSize((int)requests.size());
        Set<Long> templateRuleIds = RuleService.getInstance().getDirectRuleByTempId(reportId);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)requests.get(0).getModelId());
        List<RuleDto> rules = this.queryRuleList(modelCache, templateRuleIds, requests.get(0).getDatasetId());
        Options options = new Options();
        for (FloatQueryRequest request : requests) {
            Object dimNumber2;
            Stats.StatItem statItem = stats.createStatItem(StrUtils.format((String)"do Float: float number{}", (Object[])new Object[]{request.getNumber()}));
            Long datasetId = request.getDatasetId();
            List dimensionList = modelCache.getDimensionList(datasetId);
            try {
                OlapManager.getInstance().checkDimension(request.getMemberInfo(), (List<Dimension>)dimensionList);
            }
            catch (KDBizException e) {
                log.error((Throwable)e);
                continue;
            }
            if (CollectionUtils.isEmpty((Collection)request.getFloatDims())) continue;
            Map viewMap = request.getViewMap();
            if (viewMap == null || viewMap.isEmpty()) {
                viewMap = modelCache.getViewsByDataSet(request.getDatasetId());
            }
            FloatRows floatRows = new FloatRows(request.getNumber(), request.getSeq(), request.getFloatDims());
            floatRows.setRangeType(request.getRangeType());
            LinkedHashMap query = Maps.newLinkedHashMap();
            request.getMemberInfo().forEach((dim, mem) -> query.computeIfAbsent(dim, v -> Sets.newLinkedHashSet()).addAll(mem));
            QueryRequest req = new QueryRequest(request.getModelId(), request.getDatasetId(), query);
            req.setViewMap(viewMap);
            Stopwatch stopwatch = Stopwatch.createStarted();
            Stats.StatItem filterPermStat = stats.createStatItem(StrUtils.format((String)"filterPermRead", (Object[])new Object[0]));
            req = AlgoCalcUtils.filterPermRead(req, modelCache);
            filterPermStat.close();
            log.info("getFloatMember request filterPermRead cost:{}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            stopwatch.reset().start();
            if (req == null || OlapManager.getInstance().checkDimensionNoError(dimensionList, req.getMemberInfo())) {
                statItem.close();
                floatRows.setFloatRows(Collections.emptyList());
                floatRowsList.add(floatRows);
                continue;
            }
            if (request.getRangeType() == 1 && request.isFilterTopItems() && !ModelServiceHelper.isUserHasRootPermByModel((long)UserUtils.getUserId(), (Long)request.getModelId())) {
                this.filterTopItems(modelCache, request.getFloatDims(), req.getMemberInfo(), req.getViewMap());
            }
            if (!MapUtils.isEmpty((Map)viewMap)) {
                options.setAnalysisView(Boolean.valueOf(true));
            }
            List<RuleDto> ruleDtos = AlgoCalcUtils.filterRuleByScope(request.getMemberInfo(), rules, LeafFeature.NOTLEAF);
            if ("1".equals(floatCalculate) && !ruleDtos.isEmpty() && request.getRangeType() == 1) {
                MutableGraph<Long> graph = RuleGraphUtils.buildDagGraph(ruleDtos);
                while (!graph.nodes().isEmpty()) {
                    Set zeroNodes = graph.nodes().stream().filter(node -> graph.inDegree(node) == 0).collect(Collectors.toSet());
                    if (!CollectionUtils.isNotEmpty(zeroNodes)) continue;
                    List zeroRules = ruleDtos.stream().filter(ruleDto -> zeroNodes.contains(ruleDto.getId())).collect(Collectors.toList());
                    Iterator iterator = zeroRules.iterator();
                    while (iterator.hasNext()) {
                        RuleDto ruleDto2 = (RuleDto)iterator.next();
                        this.calcRule(ruleDto2, req, options, modelCache);
                        graph.removeNode((Object)ruleDto2.getId());
                    }
                }
            }
            FloatQueryRequest.FixedDim fixedDim = request.getFixedDim();
            HashSet sections = Sets.newHashSetWithExpectedSize((int)fixedDim.getMemberNumbers().size());
            for (List memberNumber : fixedDim.getMemberNumbers()) {
                String join = StringUtils.join((Iterable)memberNumber, (String)"!");
                sections.add(join);
            }
            OlapReadOption olapReadOption = new OlapReadOption();
            olapReadOption.setUseDynamicCalcV2(false);
            olapReadOption.setDataLimit(false);
            List<Object[]> cells = OlapCommService.getInstance().queryObject(req, olapReadOption);
            List<String> dims = req.getSelectDims();
            if (CollectionUtils.isEmpty(dims)) {
                dims = Arrays.asList(modelCache.getDimensionNums(req.getDatasetId()));
            }
            log.info("getFloatMember queryList cost:{}ms, cellList:{}", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS), (Object)cells.size());
            stopwatch.reset().start();
            statItem.append((Object)("cell Size:" + cells.size()));
            ArrayList rows = Lists.newArrayListWithExpectedSize((int)cells.size());
            StringBuilder fixedDimSb = new StringBuilder();
            StringBuilder floatDimSb = new StringBuilder();
            LinkedHashSet contains = Sets.newLinkedHashSet();
            List floatDims = request.getFloatDims();
            ArrayList fixDimIndex = Lists.newArrayListWithExpectedSize((int)fixedDim.getDimNumbers().size());
            for (Object dimNumber2 : fixedDim.getDimNumbers()) {
                fixDimIndex.add(dims.indexOf(dimNumber2) + 1);
            }
            ArrayList floatDimIndex = Lists.newArrayListWithExpectedSize((int)floatDims.size());
            dimNumber2 = floatDims.iterator();
            while (dimNumber2.hasNext()) {
                String dimNumber3 = (String)dimNumber2.next();
                floatDimIndex.add(dims.indexOf(dimNumber3) + 1);
            }
            List<Object[]> permCells = AlgoCalcUtils.filterPermRead(cells, dims, request.getDatasetId(), request.getViewMap(), modelCache);
            for (Object[] cell : permCells) {
                int dimIndex;
                Object value = cell[0];
                if (value == null || value instanceof Number && ConvertUtils.equalValue((Object)BigDecimal.ZERO, (Object)value) || value instanceof String && StringUtils.isBlank((CharSequence)((String)value))) continue;
                fixedDimSb.setLength(0);
                Iterator iterator = fixDimIndex.iterator();
                while (iterator.hasNext()) {
                    dimIndex = (Integer)iterator.next();
                    fixedDimSb.append(cell[dimIndex]).append('!');
                }
                fixedDimSb.setLength(fixedDimSb.length() - 1);
                if (!sections.contains(fixedDimSb.toString())) continue;
                floatDimSb.setLength(0);
                iterator = floatDimIndex.iterator();
                while (iterator.hasNext()) {
                    dimIndex = (Integer)iterator.next();
                    floatDimSb.append(cell[dimIndex]).append('!');
                }
                floatDimSb.setLength(floatDimSb.length() - 1);
                String uniqueKey = floatDimSb.toString();
                if (!contains.add(uniqueKey)) continue;
                FloatRows.FloatRow floatRow = new FloatRows.FloatRow();
                ArrayList items = Lists.newArrayListWithExpectedSize((int)floatDims.size());
                Iterator iterator2 = floatDimIndex.iterator();
                while (iterator2.hasNext()) {
                    int dimIndex2 = (Integer)iterator2.next();
                    items.add((String)cell[dimIndex2]);
                }
                floatRow.setColItems((List)items);
                rows.add(floatRow);
            }
            log.info("getFloatMember filterPermRead cost:{}ms, floatRowSize:{}", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS), (Object)rows.size());
            floatRows.setFloatRows((List)rows);
            floatRowsList.add(floatRows);
            statItem.close();
        }
        stats.close();
        log.info(stats.toString("budget-olap-query:"));
        return floatRowsList;
    }

    private void filterTopItems(IModelCacheHelper modelCacheHelper, List<String> floatDims, Map<String, Set<String>> memberInfo, Map<String, Long> viewMap) {
        if (modelCacheHelper != null && floatDims != null && memberInfo != null) {
            Set<String> memNumbers = null;
            Object memLongNumbers = null;
            ArrayList<Member> members = null;
            for (String dimNumber : floatDims) {
                Long ViewId = IDUtils.toLong((Object)viewMap.get(dimNumber));
                memNumbers = memberInfo.get(dimNumber);
                if (memNumbers == null || memNumbers.size() <= 1) continue;
                HashSet<String> topMemNumbers = new HashSet<String>(16);
                members = new ArrayList<Member>(modelCacheHelper.getMembers(dimNumber, ViewId, memNumbers));
                members.sort(Comparator.comparing(Member::getLongNumber));
                String prevLongNum = "";
                for (Member member : members) {
                    if (member.getLongNumber().startsWith(prevLongNum + "!")) continue;
                    topMemNumbers.add(member.getNumber());
                    prevLongNum = member.getLongNumber();
                }
                memberInfo.put(dimNumber, topMemNumbers);
            }
        }
    }

    public List<BGCell> reportQuery(Set<Long> bizruleIds, List<QueryRequest> requests) {
        log.info(StrUtils.format((String)"reportQuery,bizruleIds: {},requests: {}", (Object[])new Object[]{bizruleIds, requests.toString()}));
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)requests.get(0).getModelId());
        List<RuleDto> rules = this.queryRuleList(modelCache, bizruleIds, requests.get(0).getDatasetId());
        return this.reportQuery(null, rules, requests);
    }

    private List<RuleDto> queryRuleList(IModelCacheHelper modelCache, Set<Long> ruleIds, Long datasetId) {
        if (CollectionUtils.isEmpty(ruleIds)) {
            return Collections.emptyList();
        }
        Long bizModelId = modelCache.getBusModelByDataSet(datasetId);
        List allRuleList = RuleCacheService.getInstance().listRuleFromLocalCache(bizModelId).getRuleDtoList();
        return allRuleList.stream().filter(RuleDto::getStatus).filter(rule -> ruleIds.contains(rule.getId())).collect(Collectors.toList());
    }

    public List<BGCell> reportQuery(long reportId, List<QueryRequest> requests) {
        log.info(StrUtils.format((String)"reportQuery,reportId: {},requests: {}", (Object[])new Object[]{reportId, requests.toString()}));
        Set<Long> templateRuleIds = RuleService.getInstance().getDirectRuleByTempId(reportId);
        Long modelId = requests.get(0).getModelId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List<RuleDto> rules = this.queryRuleList(modelCache, templateRuleIds, requests.get(0).getDatasetId());
        RuleTemplateInfo ruleTemplateInfo = new RuleTemplateInfo(modelId, Long.valueOf(reportId));
        return this.reportQuery(ruleTemplateInfo, rules, requests);
    }

    public List<BGCell> export(long reportId, List<QueryRequest> requests) {
        log.info(StrUtils.format((String)"export,reportId: {},requests size: {}", (Object[])new Object[]{reportId, requests.size()}));
        Long modelId = requests.get(0).getModelId();
        RuleTemplateInfo ruleTemplateInfo = new RuleTemplateInfo(modelId, Long.valueOf(reportId));
        ruleTemplateInfo.setCheckBindRuleToTemplate(false);
        return this.reportQuery(ruleTemplateInfo, Collections.emptyList(), requests);
    }

    public List<BGCell> reportQuery(RuleTemplateInfo ruleTemplateInfo, List<RuleDto> rules, List<QueryRequest> requests) {
        boolean checkBindRuleToTemplate;
        Long templateId = ruleTemplateInfo == null ? null : ruleTemplateInfo.getTemplateId();
        boolean runRuleBoolean = TemplateParamUtils.getRunRuleBoolean(templateId);
        if (!runRuleBoolean) {
            rules = Collections.emptyList();
        }
        Long modelId = requests.get(0).getModelId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        boolean bl = checkBindRuleToTemplate = ruleTemplateInfo == null || ruleTemplateInfo.isCheckBindRuleToTemplate();
        if (checkBindRuleToTemplate && runRuleBoolean) {
            Long bizModelId = modelCache.getBusModelByDataSet(requests.get(0).getDatasetId());
            this.checkBindRuleToTemplate(bizModelId, templateId);
        }
        Stats stats = new Stats("reportQuery");
        List ruleIds = rules.stream().map(RuleDto::getId).collect(Collectors.toList());
        stats.appendMessage(StrUtils.format((String)"bizruleIds: {},request size: {}", (Object[])new Object[]{ruleIds, requests.size()}));
        Stats.StatItem statItem = stats.createStatItem(StrUtils.format((String)"filterPermRead,request size: {}", (Object[])new Object[]{requests.size()}));
        requests = AlgoCalcUtils.filterPermRead(requests, modelCache);
        statItem.close();
        if (requests.isEmpty()) {
            stats.appendMessage("all request is empty");
            log.info(stats.toString("budget-olap-log:"));
            return Collections.emptyList();
        }
        requests.forEach(request -> {
            Options options = request.getOptions();
            if (options == null) {
                options = new Options();
                request.setOptions(options);
            }
            options.setNeedFilterRule(Boolean.valueOf(false));
            this.dealSpecialViewMap((QueryRequest)request, modelCache, options);
        });
        for (QueryRequest request2 : requests) {
            Long bizModelId = request2.getDatasetId();
            List dimensionList = modelCache.getDimensionList(bizModelId);
            OlapManager.getInstance().checkDimension(request2.getMemberInfo(), (List<Dimension>)dimensionList);
        }
        if (!rules.isEmpty()) {
            MutableGraph<Long> graph = RuleGraphUtils.buildDagGraph(rules);
            while (!graph.nodes().isEmpty()) {
                Set zeroNodes = graph.nodes().stream().filter(node -> graph.inDegree(node) == 0).collect(Collectors.toSet());
                if (!CollectionUtils.isNotEmpty((Collection)zeroNodes)) continue;
                List zeroRules = rules.stream().filter(ruleDto -> zeroNodes.contains(ruleDto.getId())).collect(Collectors.toList());
                boolean isChange = false;
                for (RuleDto ruleDto2 : zeroRules) {
                    for (QueryRequest request3 : requests) {
                        List<BGCell> changedCells = this.calcRule(ruleDto2, request3, request3.getOptions(), modelCache);
                        if (changedCells.isEmpty()) continue;
                        isChange = true;
                        this.calcChain(ruleTemplateInfo, modelCache, request3, changedCells, request3.getOptions());
                        changedCells.clear();
                    }
                    graph.removeNode((Object)ruleDto2.getId());
                }
                if (!isChange) continue;
                MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u89c4\u5219\u8ba1\u7b97", "AbstractOlapServiceCaller_11", "epm-eb-olap");
                MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u62a5\u8868\u5237\u65b0\u8ba1\u7b97", "AbstractOlapServiceCaller_13", "epm-eb-olap");
                OperationLogUtil.log((String)"bgmd", (String)"eb_bizruleset", (String)"reportQuery", (String)"reportQuery", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, null);
            }
        }
        ArrayList cells = Lists.newArrayListWithExpectedSize((int)100);
        for (QueryRequest request4 : requests) {
            List<BGCell> dbCells = OlapManager.getInstance().queryList(request4);
            cells.addAll(AlgoCalcUtils.filterPermRead(dbCells, request4.getDatasetId(), request4.getViewMap(), modelCache));
        }
        boolean retryerrorcalc = ParamQueryServiceHelper.getBoolean((long)modelId, (ParamEnum)ParamEnum.BG041);
        if (retryerrorcalc) {
            RuleRetryService.getInstance().retryErrorCalc(modelId, modelCache);
        }
        log.info(stats.toString("budget-olap-log:"));
        return cells;
    }

    public void checkBindRuleToTemplate(Long bizModelId, Long templateId) {
        this.checkBindRuleToTemplateByCacheKey(templateId, "CACHE_BIND_RULE_TO_TEMPLATE_" + bizModelId);
        this.checkBindRuleToTemplateByCacheKey(templateId, "CACHE_BIND_RULE_TO_APPLY_TEMPLATE_" + bizModelId);
    }

    public void checkBindRuleToTemplateByCacheKey(Long templateId, String cacheKey) {
        String cache = Cache.get().get(cacheKey);
        if (StringUtils.isNotEmpty((CharSequence)cache)) {
            if (cache.equals(cacheKey)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u6b63\u5728\u53d1\u5e03\u4e2d\uff0c\u4e3a\u4fdd\u8bc1\u6570\u636e\u7684\u51c6\u786e\u6027\uff0c\u8bf75\u5206\u949f\u540e\u518d\u8bd5", (String)"RuleExecutionService_3", (String)"epm-eb-business", (Object[])new Object[0]));
            }
            String[] split = cache.split(",");
            Set templateStrSet = Arrays.stream(split).collect(Collectors.toSet());
            if (IDUtils.isNotEmptyLong((Long)templateId).booleanValue() && templateStrSet.contains(IDUtils.toString((Object)templateId))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u6b63\u5728\u53d1\u5e03\u4e2d\uff0c\u4e3a\u4fdd\u8bc1\u6570\u636e\u7684\u51c6\u786e\u6027\uff0c\u8bf75\u5206\u949f\u540e\u518d\u8bd5", (String)"RuleExecutionService_3", (String)"epm-eb-business", (Object[])new Object[0]));
            }
        }
    }

    private void calcChain(RuleTemplateInfo ruleTemplateInfo, IModelCacheHelper modelCache, QueryRequest request, List<BGCell> changedCells, Options options) {
        Map<String, Long> viewMap = request.getViewMap();
        Set<String> entityNumberSet = request.getMemberInfo().get(SysDimensionEnum.Entity.getNumber());
        Long currentEntityId = modelCache.getMember(SysDimensionEnum.Entity.getNumber(), viewMap.get(SysDimensionEnum.Entity.getNumber()), entityNumberSet.iterator().next()).getId();
        HashMap templateScope = Maps.newHashMap();
        kd.epm.eb.common.utils.MapUtils.mergeMap(request.getMemberInfo(), (Map)templateScope);
        if (ruleTemplateInfo != null) {
            ruleTemplateInfo.setCurrentEntityId(currentEntityId);
            ruleTemplateInfo.setTemplateScope((Map)templateScope);
        }
        RuleExecuteTypeEnum ruleExecuteType = RuleExecuteTypeEnum.REFRESH;
        if (options != null && options.getUseAnalysis().booleanValue()) {
            ruleExecuteType = RuleExecuteTypeEnum.ANALYSIS;
        }
        String appId = "eb";
        String _appId = ParamServiceHelper.queryParam((String)"BCS_SERVICE_APPID", (String)appId);
        if (options == null) {
            options = new Options();
        }
        options.setViewMap(request.getViewMap());
        DispatchServiceHelper.invokeBizService((String)"epm", (String)_appId, (String)"RuleExecutionService", (String)"executeRuleChain", (Object[])new Object[]{ruleTemplateInfo, request.getDatasetId(), modelCache.getModelobj().getId(), changedCells, ruleExecuteType.getType(), options});
    }

    private List<BGCell> calcRule(RuleDto ruleDto, QueryRequest request, Options options, IModelCacheHelper modelCache) {
        Map<String, Set<String>> reqScope = request.getMemberInfo();
        Map<String, Long> viewMap = request.getViewMap();
        Long datasetId = request.getDatasetId();
        CalcBizTemplate calcBizTemplate = CalcBizTemplate.newInstance();
        calcBizTemplate.setReturnChangeData(true);
        ArrayList calcCells = Lists.newArrayList();
        HashMap<String, Set<String>> calcMap = new HashMap<String, Set<String>>(reqScope.size());
        Map leftMembers = ruleDto.getLeftMembers();
        for (Map.Entry<String, Set<String>> entry : reqScope.entrySet()) {
            String dimNumber = entry.getKey();
            Set ruleScope = (Set)leftMembers.get(dimNumber);
            if (CollectionUtils.isEmpty((Collection)ruleScope)) {
                calcMap.put(dimNumber, entry.getValue());
                continue;
            }
            Set intersection = ruleScope.stream().filter(entry.getValue()::contains).collect(Collectors.toSet());
            if (intersection.isEmpty()) {
                return Collections.emptyList();
            }
            calcMap.put(dimNumber, new HashSet(intersection));
        }
        BigInteger sum = kd.epm.eb.common.utils.MapUtils.calcDescartes(calcMap);
        if (BigInteger.valueOf(10000L).compareTo(sum) > 0) {
            AlgoCalcRequest calcRequest = new AlgoCalcRequest(modelCache.getModelobj().getId(), datasetId, viewMap, calcMap, Lists.newArrayList((Object[])new RuleDto[]{ruleDto}), options);
            return calcBizTemplate.doService(calcRequest);
        }
        log.info("\u5927\u5bbd\u8868\u8303\u56f4\u4f18\u5316start");
        CheckResult checkRes = CheckRuleSimpleUtils.check((IModelCacheHelper)modelCache, (RuleDto)ruleDto);
        Triple olapRelationPage = null;
        if (CheckResult.AlgoCalc == checkRes) {
            List<String> reportRowMemberRelDims = request.getRowMemberRelDims();
            if (CollectionUtils.isNotEmpty(reportRowMemberRelDims)) {
                log.info("\u884c\u7ef4\u5ea6\u4f18\u5316");
                List<String[]> rowRelList = Lists.newArrayListWithExpectedSize((int)reportRowMemberRelDims.size());
                for (String[] row : request.getRowMemberRelList()) {
                    boolean contain = true;
                    for (int i = 0; i < row.length; ++i) {
                        if (((Set)calcMap.get(reportRowMemberRelDims.get(i))).contains(row[i])) continue;
                        contain = false;
                        break;
                    }
                    if (!contain) continue;
                    rowRelList.add(row);
                }
                if ((rowRelList = (List)rowRelList.stream().collect(Collectors.collectingAndThen(Collectors.toMap(Arrays::toString, array -> array, (array1, array2) -> array1), map -> new ArrayList(map.values())))).isEmpty()) {
                    log.info("\u6210\u5458\u5173\u7cfb\u4e3a\u7a7a\uff0c\u4e0d\u8ba1\u7b97");
                    return calcCells;
                }
                Map relMap = kd.epm.eb.common.utils.MapUtils.relRowToMap(rowRelList, reportRowMemberRelDims);
                calcMap.putAll(relMap);
                rowRelList.add(0, (String[])reportRowMemberRelDims.stream().map(e -> modelCache.getDimension(e).getShortNumber()).toArray(String[]::new));
                log.info("\u6210\u5458\u5173\u7cfb\u7ef4\u5ea6\u3010" + reportRowMemberRelDims + "\u3011\uff0c\u6210\u5458\u5173\u7cfb\u6570\u91cf\uff1a" + rowRelList.size());
                olapRelationPage = Triple.of(calcMap, reportRowMemberRelDims, rowRelList);
            } else {
                log.info("algo \u6210\u5458\u5173\u7cfb\u4f18\u5316");
                olapRelationPage = PageUtil.getOlapRelationPage(calcMap, ruleDto, modelCache, 1);
            }
        }
        log.info("\u5927\u5bbd\u8868\u8303\u56f4\u4f18\u5316end");
        if (olapRelationPage != null && MapUtils.isEmpty((Map)((Map)olapRelationPage.getLeft()))) {
            return calcCells;
        }
        AlgoCalcRequest calcRequest = new AlgoCalcRequest(modelCache.getModelobj().getId(), datasetId, viewMap, calcMap, Lists.newArrayList((Object[])new RuleDto[]{ruleDto}), options);
        if (olapRelationPage != null) {
            calcRequest.setMemberInfo((Map)olapRelationPage.getLeft());
            calcRequest.setRowMemberRelDims((List)olapRelationPage.getMiddle());
            calcRequest.setRowMemberRelList((List)olapRelationPage.getRight());
        }
        return calcBizTemplate.doService(calcRequest);
    }

    private void dealSpecialViewMap(QueryRequest request, IModelCacheHelper modelCache, Options options) {
        Map<String, Long> viewMap = request.getViewMap();
        if (MapUtils.isEmpty(viewMap)) {
            request.setViewMap(modelCache.getViewsByDataSet(request.getDatasetId()));
        } else {
            HashMap<String, Long> newViewMap = new HashMap<String, Long>(16);
            for (Map.Entry<String, Long> entry : viewMap.entrySet()) {
                String key = entry.getKey();
                if (key.contains("_")) {
                    String[] s = key.split("_");
                    newViewMap.put(s[0], entry.getValue());
                    continue;
                }
                newViewMap.put(key, entry.getValue());
            }
            request.setViewMap(newViewMap);
            options.setAnalysisView(Boolean.valueOf(true));
        }
    }

    public List<BGCell> reportSave(RuleTemplateInfo ruleTemplateInfo, List<SaveRequest> requests) {
        Long templateId = ruleTemplateInfo == null ? null : ruleTemplateInfo.getTemplateId();
        log.info(StrUtils.format((String)"reportSave,reportId: {},requests: {}", (Object[])new Object[]{templateId, requests.toString()}));
        Stats stats = new Stats("reportSave");
        Long modelId = requests.get(0).getModelId();
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Long bizModelId = modelCacheHelper.getBusModelByDataSet(requests.get(0).getDatasetId());
        this.checkBindRuleToTemplate(bizModelId, templateId);
        SaveBizTemplate saveBizTemplate = SaveBizTemplate.newInstance();
        OlapWriteOption writeOption = new OlapWriteOption();
        writeOption.setValidPerm(requests.get(0).isValidPerm());
        saveBizTemplate.setOlapWriteOption(writeOption);
        ArrayList<BGCell> allChangedCells = new ArrayList<BGCell>(16);
        for (SaveRequest request : requests) {
            Stats.StatItem doSave = stats.createStatItem("do Save");
            List changedCells = saveBizTemplate.doService(request);
            doSave.close();
            Stats.StatItem executeRuleChain = stats.createStatItem("do executeRuleChain");
            if (!changedCells.isEmpty()) {
                String appId = "eb";
                String _appId = ParamServiceHelper.queryParam((String)"BCS_SERVICE_APPID", (String)appId);
                Options options = new Options();
                options.setViewMap(request.getViewMap());
                this.executeRuleChain(ruleTemplateInfo, modelId, request, changedCells, _appId, options);
            }
            executeRuleChain.close();
            allChangedCells.addAll(changedCells);
        }
        log.info(stats.toString("budget-olap-query:"));
        return allChangedCells;
    }

    private void executeRuleChain(RuleTemplateInfo ruleTemplateInfo, Long modelId, SaveRequest request, List<BGCell> changedCells, String _appId, Options options) {
        DispatchServiceHelper.invokeBizService((String)"epm", (String)_appId, (String)"RuleExecutionService", (String)"executeRuleChain", (Object[])new Object[]{ruleTemplateInfo, request.getDatasetId(), modelId, changedCells, RuleExecuteTypeEnum.DEPEN.getType(), options});
    }

    private static class InnerClass {
        private static OlapReportService instance = new OlapReportService();

        private InnerClass() {
        }
    }
}

