/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.algo.olap.LeafFeature;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.AggOprtEnum;
import kd.epm.eb.common.enums.AggType;
import kd.epm.eb.common.enums.RealDataType;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.FunctionItemEnum;
import kd.epm.eb.common.olapdao.AnalysisContext;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.pojo.CellPojo;
import kd.epm.eb.common.pojo.OlapPojo;
import kd.epm.eb.common.rule.ruleFunction.MemberRuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionFactory;
import kd.epm.eb.common.rule.showbizrule.ReportShowBizRuleBo;
import kd.epm.eb.common.rule.showbizrule.ReportShowBizRuleMemberBo;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.base.LambdaUtils;
import kd.epm.eb.common.utils.base.ObjUtils;
import kd.epm.eb.common.utils.base.OlapUtils;
import kd.epm.eb.olap.analysiscanvas.model.AnalysisCanvasDataset;
import kd.epm.eb.olap.analysiscanvas.service.AnalysisCubeService;
import kd.epm.eb.olap.impl.bizrule.RuleCacheService;
import kd.epm.eb.olap.impl.bizrule.RuleService;
import kd.epm.eb.olap.impl.bizrule.entity.FormulaMemberDto;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.impl.bizrule.entity.RuleRightItemDto;
import kd.epm.eb.olap.impl.execute.face.IExpress;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.AbstractFun;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.BinaryExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.IfExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.MdxMemberExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.OtherFun;
import kd.epm.eb.olap.impl.execute.impl.expr.parse.Parse2RPN;
import kd.epm.eb.olap.impl.execute.impl.visit.FormulaVisit;
import kd.epm.eb.olap.impl.execute.impl.visit.FormulaVisitContext;
import kd.epm.eb.olap.impl.execute.impl.visit.FormulaVisitResult;
import kd.epm.eb.olap.service.FormulaStrProxyHandler;
import kd.epm.eb.olap.service.OlapCommService;
import kd.epm.eb.olap.service.OlapManager;
import kd.epm.eb.olap.service.request.AlgoCalcRequest;
import kd.epm.eb.olap.service.request.Options;
import kd.epm.eb.olap.service.request.QueryRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ShowBizRuleUtils {
    public static ReportShowBizRuleBo getReportShowBizRuleBo(Map<String, String> dimensionAndMemberNumberMap, Long modelIdLong, AnalysisContext analysisContext) {
        Member accountMember;
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelIdLong);
        List dimensionList = modelCacheHelper.getDimensionList((accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, dimensionAndMemberNumberMap.get(SysDimensionEnum.Account.getNumber()))).getDatasetId());
        if (dimensionList.size() != dimensionAndMemberNumberMap.size()) {
            return null;
        }
        return ShowBizRuleUtils.getReportShowBizRuleBo(dimensionAndMemberNumberMap, accountMember.getDatasetId(), modelIdLong, analysisContext);
    }

    public static ReportShowBizRuleBo getReportShowBizRuleBo(Map<String, String> dimensionAndMemberNumberMap, Long dataSetIdLong, Long modelIdLong, AnalysisContext analysisContext) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelIdLong);
        String budgetPeriodMemberNumberString = dimensionAndMemberNumberMap.get(SysDimensionEnum.BudgetPeriod.getNumber());
        if (StringUtils.isNotBlank((CharSequence)budgetPeriodMemberNumberString) && budgetPeriodMemberNumberString.equals("_")) {
            return null;
        }
        Long busModelIdLong = modelCacheHelper.getBusModelByDataSet(dataSetIdLong);
        List ruleDtoList = RuleCacheService.getInstance().listRuleFromLocalCache(busModelIdLong).getRuleDtoList();
        boolean leafBoolean = ShowBizRuleUtils.leafBoolean(dimensionAndMemberNumberMap, modelCacheHelper, busModelIdLong);
        for (RuleDto ruleDto : ruleDtoList) {
            LeafFeature leafFeature = ruleDto.getLeafFeature();
            Map leftDimensionAndMemberNumberMap = ruleDto.getLeftMembers();
            if (!ShowBizRuleUtils.hasRelationBoolean(dimensionAndMemberNumberMap, leftDimensionAndMemberNumberMap, leafBoolean, leafFeature) || ruleDto.getLeafFeature() == LeafFeature.LEAF && ShowBizRuleUtils.containVirtualMemberBoolean(dimensionAndMemberNumberMap, modelCacheHelper)) continue;
            return ShowBizRuleUtils.createReportShowBizRuleBo(modelIdLong, null, dimensionAndMemberNumberMap, ruleDto, analysisContext);
        }
        return null;
    }

    public static boolean containVirtualMemberBoolean(Map<String, String> dimensionAndMemberNumberMap, IModelCacheHelper modelCacheHelper) {
        for (Map.Entry<String, String> entry : dimensionAndMemberNumberMap.entrySet()) {
            Set virtualMemberNumberStringSet = modelCacheHelper.getDimension(entry.getKey()).getViewMember().stream().map(BaseCache::getNumber).collect(Collectors.toSet());
            if (!virtualMemberNumberStringSet.contains(entry.getValue())) continue;
            return true;
        }
        return false;
    }

    public static ReportShowBizRuleBo createReportShowBizRuleBo(Long modelId, Long templateId, Map<String, String> leftMemberMap, RuleDto ruleDto, AnalysisContext analysisContext) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        ReportShowBizRuleBo reportShowBizRuleBo = new ReportShowBizRuleBo();
        reportShowBizRuleBo.setId(ruleDto.getId());
        reportShowBizRuleBo.setName(ruleDto.getName());
        reportShowBizRuleBo.setFormulaString(ruleDto.getFormulaString());
        reportShowBizRuleBo.setNumber(ruleDto.getNumber());
        reportShowBizRuleBo.setMainDimensionNum(modelCacheHelper.getDimension(ruleDto.getMainDimensionId()).getNumber());
        reportShowBizRuleBo.setFunction(ruleDto.getFunctions());
        String leftMemberKey = ShowBizRuleUtils.getLeftMemberKey(ruleDto);
        Long leftDataSetId = ShowBizRuleUtils.getCurrentDataSetId(modelCacheHelper, leftMemberMap);
        Map viewMap = modelCacheHelper.getViewsByDataSet(leftDataSetId);
        ShowBizRuleUtils.appendInMemberBo(ruleDto, reportShowBizRuleBo, templateId, modelCacheHelper, leftMemberKey, leftDataSetId, viewMap, leftMemberMap, analysisContext);
        return reportShowBizRuleBo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static void appendInMemberBo(RuleDto ruleDto, ReportShowBizRuleBo reportShowBizRuleBo, Long templateId, IModelCacheHelper modelCache, String leftMemberKey, Long leftDataSetId, Map<String, Long> viewMap, Map<String, String> leftMemberMap, AnalysisContext analysisContext) {
        leftMemberCollect = leftMemberMap.entrySet().stream().collect(Collectors.toMap((Function<Map.Entry, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getKey(), (Ljava/util/Map$Entry;)Ljava/lang/String;)(), (Function<Map.Entry, Set>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$appendInMemberBo$0(java.util.Map$Entry ), (Ljava/util/Map$Entry;)Ljava/util/Set;)()));
        reportShowBizRuleBo.setLeftMemberCollect(leftMemberCollect);
        reportShowBizRuleBo.setLeftDataSetId(leftDataSetId);
        reportShowBizRuleBo.setViewMap(viewMap);
        reportShowBizRuleBo.setAnalysisContext(analysisContext);
        leftMemberBo = ShowBizRuleUtils.convertToBo(leftDataSetId, reportShowBizRuleBo.getMainDimensionNum(), modelCache, leftMemberKey, leftMemberCollect, null);
        modelId = modelCache.getModelobj().getId();
        bizCtrlRangeId = ruleDto.getBizCtrlRangeId();
        if (!ShowBizRuleUtils.leafBoolean(modelId, leftMemberBo.getDimNumberToMemberNumber(), bizCtrlRangeId)) {
            cellPojo = ShowBizRuleUtils.getCellPojo(modelId, templateId, ruleDto, viewMap, leftMemberBo.getDimToMemMap(), analysisContext);
            if (!cellPojo.isEmpty()) {
                leftMemberBo.addValue(cellPojo.get(0).getValueString());
            }
        } else {
            cellPojo = ShowBizRuleUtils.getCellPojo(leftMemberBo.getDimToMemMap(), modelId, leftMemberBo.getDataSetId(), analysisContext);
            if (!cellPojo.isEmpty()) {
                leftMemberBo.addValue(cellPojo.get(0).getValueString());
            }
        }
        reportShowBizRuleBo.setLeftMember(leftMemberBo);
        reportShowBizRuleBo.setRightMembers(new ArrayList<E>(16));
        ruleRightItemDtoList = ruleDto.getRuleRightItemDto();
        offsetMap = ruleDto.getOffsetMap();
        functionMap = ruleDto.getFunctions().stream().collect(Collectors.toMap((Function<RuleFunction, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getFunctionKey(), (Lkd/epm/eb/common/rule/ruleFunction/RuleFunction;)Ljava/lang/String;)(), (Function<RuleFunction, RuleFunction>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$appendInMemberBo$1(kd.epm.eb.common.rule.ruleFunction.RuleFunction ), (Lkd/epm/eb/common/rule/ruleFunction/RuleFunction;)Lkd/epm/eb/common/rule/ruleFunction/RuleFunction;)()));
        for (RuleRightItemDto itemDto : ruleRightItemDtoList) {
            dimToMemberPair = itemDto.getFilterRefMemberMap();
            if (dimToMemberPair == null) {
                dimToMemberPair = itemDto.getRefMemberMap();
            }
            currDataSetId = ShowBizRuleUtils.getCurrentDataSetId(modelCache, dimToMemberPair, leftDataSetId);
            currMemberMap = ShowBizRuleUtils.analyzeRealMemberMap(modelCache, itemDto, offsetMap, functionMap, currDataSetId, leftMemberMap, dimToMemberPair, leftDataSetId, ruleDto.getViewMap());
            rightMemberBo = ShowBizRuleUtils.convertToBo(currDataSetId, reportShowBizRuleBo.getMainDimensionNum(), modelCache, itemDto.getMemberKey(), currMemberMap, itemDto);
            if (AggType.needAlgoCalc((AggType)rightMemberBo.getAggType())) {
                try {
                    request = new AlgoCalcRequest();
                    request.setModelId(modelId);
                    request.setDatasetId(leftDataSetId);
                    mockFormulaStr = ShowBizRuleUtils.getMockFormulaString(ruleDto.getFormulaString(), itemDto.getMemberKey(), functionMap);
                    mockRuleDto = (RuleDto)new FormulaStrProxyHandler((Object)ruleDto, mockFormulaStr).bind();
                    request.setRules(Lists.newArrayList((Object[])new RuleDto[]{mockRuleDto}));
                    request.setMemberInfo(leftMemberCollect);
                    request.setViewMap(ruleDto.getViewMap());
                    if (analysisContext != null) {
                        options = new Options();
                        options.setUseAnalysis(Boolean.valueOf(true));
                        options.setUseAlgoAgg(Boolean.valueOf(false));
                        request.setOptions(options);
                        newAnalysisContext = ShowBizRuleUtils.getAnalysisContext(analysisContext, leftDataSetId);
                        OlapContext.setAnalysisContext((AnalysisContext)newAnalysisContext);
                    }
                    OlapManager.getInstance().filterRulesRangeMember(request, modelCache);
                    bgCells = OlapManager.getInstance().singleCalc(request);
                    cellPojo = ShowBizRuleUtils.trans(bgCells);
                    if (cellPojo.isEmpty()) ** GOTO lbl69
                    rightMemberBo.addValue(cellPojo.get(0).getValueString());
                }
                finally {
                    OlapContext.clearAnalysisContext();
                }
            } else {
                cellPojo = ShowBizRuleUtils.getCellPojo(rightMemberBo.getDimToMemMap(), modelId, rightMemberBo.getDataSetId(), analysisContext);
                if (!cellPojo.isEmpty()) {
                    for (CellPojo pojo : cellPojo) {
                        first = ((Set)rightMemberBo.getDimToMemMap().get(SysDimensionEnum.Metric.getNumber())).stream().findFirst();
                        if (first.isPresent()) {
                            member = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, (String)first.get());
                            if (MetricDataTypeEnum.isDate((String)member.getDatatype())) {
                                rightMemberBo.addValue(ConvertUtils.toDateString((Date)ConvertUtils.from((String)pojo.getValueString())));
                                continue;
                            }
                            rightMemberBo.addValue(pojo.getValueString());
                            continue;
                        }
                        rightMemberBo.addValue(pojo.getValueString());
                    }
                }
            }
lbl69:
            // 5 sources

            reportShowBizRuleBo.getRightMembers().add(rightMemberBo);
        }
    }

    private static String getMockFormulaString(String formulaString, String funKey, Map<String, RuleFunction> functionMap) {
        if (formulaString == null || funKey == null) {
            return formulaString;
        }
        Parse2RPN parse2RPN = new Parse2RPN(formulaString);
        parse2RPN.parse();
        IExpress expr = parse2RPN.getExpr();
        IExpress right = ((BinaryExpr)expr).getRight();
        IExpress currExpress = ShowBizRuleUtils.dfs(right, funKey, functionMap);
        if (currExpress == null) {
            return formulaString;
        }
        ArrayList<IExpress> parent = new ArrayList<IExpress>();
        if (currExpress instanceof OtherFun) {
            parent.add(currExpress);
        } else {
            ShowBizRuleUtils.getParent(right, currExpress, parent);
        }
        if (parent.isEmpty()) {
            return formulaString;
        }
        FormulaVisit formulaVisit = new FormulaVisit();
        FormulaVisitResult leftResult = formulaVisit.visit(((BinaryExpr)expr).getLeft(), new FormulaVisitContext());
        FormulaVisitResult rightResult = formulaVisit.visit((IExpress)parent.get(0), new FormulaVisitContext());
        return leftResult.getFormulaStr() + " = " + rightResult.getFormulaStr();
    }

    public static String getMockFormulaString(String formulaString, String funKey) {
        return ShowBizRuleUtils.getMockFormulaString(formulaString, funKey, new HashMap<String, RuleFunction>(16));
    }

    private static boolean getParent(IExpress express, IExpress needFindExpr, List<IExpress> parent) {
        block4: {
            block5: {
                block3: {
                    if (needFindExpr == express) {
                        return true;
                    }
                    if (!(express instanceof BinaryExpr)) break block3;
                    if (!ShowBizRuleUtils.getParent(((BinaryExpr)express).getLeft(), needFindExpr, parent) && !ShowBizRuleUtils.getParent(((BinaryExpr)express).getRight(), needFindExpr, parent)) break block4;
                    parent.add(express);
                    break block4;
                }
                if (!(express instanceof IfExpr)) break block5;
                if (!ShowBizRuleUtils.getParent(((IfExpr)express).getCondition(), needFindExpr, parent) && !ShowBizRuleUtils.getParent(((IfExpr)express).getLeft(), needFindExpr, parent) && !ShowBizRuleUtils.getParent(((IfExpr)express).getRight(), needFindExpr, parent)) break block4;
                parent.add(express);
                break block4;
            }
            if (express instanceof AbstractFun && ((AbstractFun)express).getChildren() != null) {
                for (IExpress child : ((AbstractFun)express).getChildren()) {
                    boolean is = ShowBizRuleUtils.getParent(child, needFindExpr, parent);
                    if (!is) continue;
                    parent.add(express);
                    break;
                }
            }
        }
        return false;
    }

    private static IExpress dfs(IExpress express, String funKey, Map<String, RuleFunction> functionMap) {
        Map allVal;
        String memberKey;
        String functionKey;
        RuleFunction ruleFunction;
        if (express instanceof BinaryExpr) {
            return Optional.ofNullable(ShowBizRuleUtils.dfs(((BinaryExpr)express).getLeft(), funKey, functionMap)).orElseGet(() -> ShowBizRuleUtils.dfs(((BinaryExpr)express).getRight(), funKey, functionMap));
        }
        if (express instanceof IfExpr) {
            return Optional.ofNullable(Optional.ofNullable(ShowBizRuleUtils.dfs(((IfExpr)express).getCondition(), funKey, functionMap)).orElseGet(() -> ShowBizRuleUtils.dfs(((IfExpr)express).getLeft(), funKey, functionMap))).orElseGet(() -> ShowBizRuleUtils.dfs(((IfExpr)express).getRight(), funKey, functionMap));
        }
        if (express instanceof AbstractFun) {
            if (funKey.equals(((AbstractFun)express).getFunKey())) {
                return express;
            }
            if (((AbstractFun)express).getChildren() != null) {
                for (IExpress child : ((AbstractFun)express).getChildren()) {
                    IExpress ex = ShowBizRuleUtils.dfs(child, funKey, functionMap);
                    if (ex == null) continue;
                    return ex;
                }
            }
        } else if (express instanceof MdxMemberExpr ? funKey.equals(((MdxMemberExpr)express).getName()) : express instanceof OtherFun && (ruleFunction = functionMap.get(functionKey = ((OtherFun)express).getFunctionKey())) != null && funKey.equals(memberKey = (String)(allVal = ruleFunction.getAllValues()).get("accountmemberkey"))) {
            return express;
        }
        return null;
    }

    private static Map<String, Set<String>> analyzeRealMemberMap(IModelCacheHelper modelCache, RuleRightItemDto itemDto, Map<String, Integer> offsetMap, Map<String, RuleFunction> functionMap, Long currDataSetId, Map<String, String> leftMemberMap, Map<String, Set<String>> dimToMemberPair, Long leftDataSetId, Map<String, Long> viewMap) {
        String memberKey = itemDto.getMemberKey();
        Integer offsetSize = offsetMap.get(memberKey);
        List currentDimensionList = modelCache.getDimensionList(currDataSetId);
        HashMap<String, Set<String>> currMemberMap = new HashMap<String, Set<String>>(16);
        List needAnalyzeDim = (List)LambdaUtils.get(() -> {
            if (itemDto.getSkipDimList() == null) {
                return Collections.emptyList();
            }
            return itemDto.getSkipDimList();
        });
        for (Dimension dimension : currentDimensionList) {
            Object memberNumber;
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimension.getNumber()) && offsetSize != null && (long)offsetSize.intValue() != 0L) {
                memberNumber = leftMemberMap.get(dimension.getNumber());
                Member memberOffset = modelCache.getMemberOffset(SysDimensionEnum.BudgetPeriod.getNumber(), (String)memberNumber, offsetSize.intValue());
                if (memberOffset == null) continue;
                currMemberMap.put(dimension.getNumber(), Sets.newHashSet((Object[])new String[]{memberOffset.getNumber()}));
                continue;
            }
            memberNumber = dimToMemberPair.get(dimension.getNumber());
            if (needAnalyzeDim.contains(dimension.getNumber()) || memberNumber == null) {
                String leftMember = leftMemberMap.get(dimension.getNumber());
                if (StringUtils.isBlank((CharSequence)leftMember)) {
                    leftMember = dimension.getNoneNumber();
                }
                currMemberMap.put(dimension.getNumber(), Sets.newHashSet((Object[])new String[]{leftMember}));
                continue;
            }
            currMemberMap.put(dimension.getNumber(), new HashSet(memberNumber));
        }
        for (Dimension dimension : currentDimensionList) {
            String refFunctionKey;
            RuleFunction ruleFunction;
            if (!needAnalyzeDim.contains(dimension.getNumber()) || (ruleFunction = functionMap.get(refFunctionKey = itemDto.getRefFunctionKey())) == null) continue;
            Map currViewMap = currDataSetId.equals(leftDataSetId) ? viewMap : modelCache.getViewsByDataSet(currDataSetId);
            String dimensionNumber = dimension.getNumber();
            if (ShowBizRuleUtils.checkMemberChildFunctionDimNum(ruleFunction, dimensionNumber)) {
                Map<String, FormulaMemberDto> formulaMemberMap = itemDto.getFormulaMemberList().stream().collect(Collectors.toMap(FormulaMemberDto::getDimNumber, x -> x));
                FormulaMemberDto formulaMemberDto = formulaMemberMap.get(dimensionNumber);
                if (formulaMemberDto != null) {
                    currMemberMap.put(dimensionNumber, Sets.newHashSet((Object[])new String[]{formulaMemberDto.getNumber()}));
                    continue;
                }
                String leftMember = leftMemberMap.get(dimensionNumber);
                if (StringUtils.isBlank((CharSequence)leftMember)) {
                    leftMember = dimension.getNoneNumber();
                }
                currMemberMap.put(dimensionNumber, Sets.newHashSet((Object[])new String[]{leftMember}));
                continue;
            }
            Set analyzeRealMember = ruleFunction.analyzeRealMember(modelCache, currViewMap, dimensionNumber, currMemberMap, leftMemberMap, currDataSetId, itemDto.isYvRelationHasMem());
            if (analyzeRealMember.isEmpty()) {
                currMemberMap.remove(dimensionNumber);
                continue;
            }
            currMemberMap.put(dimensionNumber, analyzeRealMember);
        }
        return currMemberMap;
    }

    private static boolean checkMemberChildFunctionDimNum(RuleFunction ruleFunction, String dimNumber) {
        if (ruleFunction instanceof MemberRuleFunction) {
            Map allVals = ruleFunction.getAllVals();
            String memFuncDimNum = (String)allVals.get(FunctionItemEnum.DIMENSIONLIST.getKey());
            if (dimNumber.equals(memFuncDimNum)) {
                return false;
            }
            if (allVals.containsKey(FunctionItemEnum.STRINGFUN.getKey())) {
                String funStr = (String)allVals.get(FunctionItemEnum.STRINGFUN.getKey());
                RuleFunction childFun = RuleFunctionFactory.fromJsonString((String)funStr);
                Map _allVals = childFun.getAllVals();
                String _childFuncDimNum = (String)_allVals.get(FunctionItemEnum.DIMENSIONLIST.getKey());
                if (memFuncDimNum.equals(_childFuncDimNum)) {
                    return false;
                }
                if (dimNumber.equals(_childFuncDimNum)) {
                    return true;
                }
            }
        }
        return false;
    }

    private static ReportShowBizRuleMemberBo convertToBo(Long dataSetId, String mainDimensionNum, IModelCacheHelper modelCache, String memberKey, Map<String, Set<String>> memberMap, RuleRightItemDto ruleRightItemDto) {
        ReportShowBizRuleMemberBo reportShowBizRuleMemberBo = new ReportShowBizRuleMemberBo();
        reportShowBizRuleMemberBo.setDataSetId(dataSetId);
        reportShowBizRuleMemberBo.setDimensionNums(modelCache.getDimensionNums(dataSetId));
        HashMap<String, String> dimNumberToMemberNumber = new HashMap<String, String>(16);
        Long busModelByDataSet = modelCache.getBusModelByDataSet(dataSetId);
        for (String dimensionNum : reportShowBizRuleMemberBo.getDimensionNums()) {
            String memberName;
            Set<String> currentMemberNumberSet = memberMap.get(dimensionNum);
            if (mainDimensionNum.equals(dimensionNum)) {
                memberName = modelCache.getMemberByAnyView(busModelByDataSet, dimensionNum, currentMemberNumberSet.iterator().next()).getName();
                reportShowBizRuleMemberBo.setName(memberName);
            } else if (SysDimensionEnum.Account.getNumber().equals(dimensionNum) && currentMemberNumberSet != null) {
                memberName = modelCache.getMember(dimensionNum, null, currentMemberNumberSet.iterator().next()).getName();
                reportShowBizRuleMemberBo.setAccountName(memberName);
            }
            if (currentMemberNumberSet != null && currentMemberNumberSet.size() == 1) {
                dimNumberToMemberNumber.put(dimensionNum, currentMemberNumberSet.iterator().next());
                continue;
            }
            reportShowBizRuleMemberBo.setCanTraceBack(false);
        }
        reportShowBizRuleMemberBo.setDimNumberToMemberNumber(dimNumberToMemberNumber);
        reportShowBizRuleMemberBo.setDimToMemMap(memberMap);
        reportShowBizRuleMemberBo.setMemberKey(memberKey);
        if (ruleRightItemDto != null) {
            reportShowBizRuleMemberBo.setAggType(AggType.getByIndex((int)ruleRightItemDto.getAggType()));
            reportShowBizRuleMemberBo.setDataType(ruleRightItemDto.getDataType());
            reportShowBizRuleMemberBo.setRefFunctionKey(ruleRightItemDto.getRefFunctionKey());
        } else {
            reportShowBizRuleMemberBo.setLeft(true);
            reportShowBizRuleMemberBo.setAggType(AggType.SUM);
            reportShowBizRuleMemberBo.setDataType(RealDataType.BigDecimal);
        }
        return reportShowBizRuleMemberBo;
    }

    private static Long getCurrentDataSetId(IModelCacheHelper modelCache, Map<String, String> dimensionAndMemberNumberMap) {
        Member accountMemb = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, dimensionAndMemberNumberMap.get(SysDimensionEnum.Account.getNumber()));
        if (accountMemb == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u83b7\u53d6\u79d1\u76ee\u6210\u5458%1\u5931\u8d25\u3002", (String)"BizRuleOptimizePlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[]{dimensionAndMemberNumberMap.get(SysDimensionEnum.Account.getNumber())}));
        }
        return accountMemb.getDatasetId();
    }

    private static Long getCurrentDataSetId(IModelCacheHelper modelCache, Map<String, Set<String>> cellScope, Long leftDataSetId) {
        Long currentDataSetId = leftDataSetId;
        Set<String> accountMembers = cellScope.get(SysDimensionEnum.Account.getNumber());
        if (CollectionUtils.isNotEmpty(accountMembers)) {
            Member accountMember = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, accountMembers.iterator().next());
            currentDataSetId = accountMember.getDatasetId();
        }
        return currentDataSetId;
    }

    private static String getLeftMemberKey(RuleDto ruleDto) {
        DynamicObject leftObj = QueryServiceHelper.queryOne((String)"eb_bizrulesetacc", (String)"memberkey", (QFilter[])new QFilter[]{new QFilter("isleft", "=", (Object)true), new QFilter("ruleid", "=", (Object)ruleDto.getId())});
        return leftObj.getString("memberkey");
    }

    public static boolean leafBoolean(Map<String, String> allDimensionAndMemberNumberMap, IModelCacheHelper modelCacheHelper, Long busModelIdLong) {
        for (Map.Entry<String, String> entry : allDimensionAndMemberNumberMap.entrySet()) {
            Member member = modelCacheHelper.getMemberByAnyView(busModelIdLong, entry.getKey(), entry.getValue());
            if (member != null && member.isLeaf() && !MemberSourceEnum.COSMIC_INVISIBLE.getIndex().equals(member.getSource())) continue;
            return false;
        }
        return true;
    }

    public static boolean leafBoolean(Long modelIdLong, Map<String, String> allDimensionAndMemberNumberMap, Long bizCtrlRangeId) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelIdLong);
        for (Map.Entry<String, String> entry : allDimensionAndMemberNumberMap.entrySet()) {
            Member member = modelCacheHelper.getMemberByAnyView(bizCtrlRangeId, entry.getKey(), entry.getValue());
            if (member != null && member.isLeaf()) continue;
            return false;
        }
        return true;
    }

    public static boolean hasRelationBoolean(Map<String, String> allDimensionAndMemberNumberMap, Map<String, Set<String>> leftDimensionAndMemberNumberMap, Boolean leafBoolean, LeafFeature leafFeature) {
        for (Map.Entry<String, String> entry : allDimensionAndMemberNumberMap.entrySet()) {
            if (!leafBoolean.booleanValue() && leafFeature == LeafFeature.LEAF) {
                return false;
            }
            if (leafBoolean.booleanValue() && leafFeature == LeafFeature.NOTLEAF) {
                return false;
            }
            Set<String> formulaMemberStringSet = leftDimensionAndMemberNumberMap.get(entry.getKey());
            if (!CollectionUtils.isNotEmpty(formulaMemberStringSet) || formulaMemberStringSet.contains(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<CellPojo> getCellPojo(Map<String, Set<String>> dimensionAndMemberStringSetMap, Long modelIdLong, Long dataSetId, AnalysisContext analysisContext) {
        List<BGCell> bgCellList;
        QueryRequest request = new QueryRequest();
        request.setModelId(modelIdLong);
        request.setDatasetId(dataSetId);
        request.setMemberInfo(dimensionAndMemberStringSetMap);
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelIdLong);
        List dimensionList = modelCache.getDimensionList(dataSetId);
        if (OlapManager.getInstance().checkDimensionNoError(dimensionList, dimensionAndMemberStringSetMap)) {
            return Collections.emptyList();
        }
        if (analysisContext == null) {
            bgCellList = OlapCommService.getInstance().queryList(request);
        } else {
            try {
                AnalysisContext newAnalysisContext = ShowBizRuleUtils.getAnalysisContext(analysisContext, dataSetId);
                OlapContext.setAnalysisContext((AnalysisContext)newAnalysisContext);
                AlgoCalcRequest algoCalcRequest = ShowBizRuleUtils.buildAnalysisRequest(newAnalysisContext, modelIdLong, dataSetId, Collections.emptyMap(), dimensionAndMemberStringSetMap, Collections.emptyList());
                bgCellList = OlapCommService.getInstance().queryByRule(algoCalcRequest);
            }
            finally {
                OlapContext.clearAnalysisContext();
            }
        }
        return ShowBizRuleUtils.trans(bgCellList);
    }

    public static AnalysisContext getAnalysisContext(AnalysisContext analysisContext, long datasetId) {
        Long canvasId = analysisContext.getAnalysisCanvasId();
        Long boxId = analysisContext.getAnalysisBoxId();
        AnalysisCanvasDataset canvasDataset = AnalysisCubeService.getInstance().getAnalysisDataset(canvasId.longValue(), boxId.longValue(), datasetId);
        if (canvasDataset != null) {
            return new AnalysisContext(canvasDataset.getAnalysisCubeId().longValue(), canvasId.longValue(), boxId.longValue(), canvasDataset.getSeq().intValue());
        }
        return null;
    }

    private static AlgoCalcRequest buildAnalysisRequest(AnalysisContext analysisContext, long modelId, long datasetId, Map<String, Long> viewMap, Map<String, Set<String>> queryDim, List<RuleDto> requestRules) {
        AlgoCalcRequest request = new AlgoCalcRequest();
        request.setModelId(modelId);
        request.setDatasetId(datasetId);
        request.setRules(requestRules);
        request.setMemberInfo(queryDim);
        request.setViewMap(viewMap);
        if (analysisContext != null) {
            Options options = new Options();
            options.setUseAnalysis(Boolean.valueOf(true));
            options.setUseAlgoAgg(Boolean.valueOf(false));
            request.setOptions(options);
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CellPojo> getCellPojo(Long modelIdLong, Long templateIdLong, RuleDto ruleDto, Map<String, Long> viewMap, Map<String, Set<String>> dimensionAndMemberStringSetMap, AnalysisContext analysisContext) {
        List<BGCell> bgCellList;
        Set<String> accountNums = dimensionAndMemberStringSetMap.get(SysDimensionEnum.Account.getNumber());
        if (CollectionUtils.isEmpty(accountNums)) {
            return Collections.emptyList();
        }
        Dataset dataset = OlapUtils.getDatasetByAccountMember((Long)modelIdLong, (String)accountNums.iterator().next());
        Long datasetId = dataset.getId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelIdLong);
        List dimensionList = modelCache.getDimensionList(datasetId);
        if (OlapManager.getInstance().checkDimensionNoError(dimensionList, dimensionAndMemberStringSetMap)) {
            return Collections.emptyList();
        }
        Set<Long> templateRuleIdLongSet = RuleService.getInstance().getDirectRuleByTempId(templateIdLong);
        List<RuleDto> ruleDtoList = RuleService.getInstance().listRule(null, (Boolean)true, templateRuleIdLongSet);
        ruleDtoList = ShowBizRuleUtils.filterRuleByScope(dimensionAndMemberStringSetMap, ruleDtoList);
        if (!templateRuleIdLongSet.contains(ruleDto.getId())) {
            ruleDtoList.add(ruleDto);
        }
        if (analysisContext == null) {
            AlgoCalcRequest algoCalcRequest = MapUtils.isNotEmpty(viewMap) ? new AlgoCalcRequest(modelIdLong, datasetId, viewMap, dimensionAndMemberStringSetMap, ruleDtoList) : new AlgoCalcRequest(modelIdLong, datasetId, dimensionAndMemberStringSetMap, ruleDtoList);
            bgCellList = OlapCommService.getInstance().queryByRule(algoCalcRequest);
        } else {
            try {
                AnalysisContext newAnalysisContext = ShowBizRuleUtils.getAnalysisContext(analysisContext, datasetId);
                OlapContext.setAnalysisContext((AnalysisContext)newAnalysisContext);
                AlgoCalcRequest algoCalcRequest = ShowBizRuleUtils.buildAnalysisRequest(newAnalysisContext, modelIdLong, datasetId, viewMap, dimensionAndMemberStringSetMap, ruleDtoList);
                bgCellList = OlapCommService.getInstance().queryByRule(algoCalcRequest);
            }
            finally {
                OlapContext.clearAnalysisContext();
            }
        }
        return ShowBizRuleUtils.trans(bgCellList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CellPojo> getCellPojoList(OlapPojo olapPojo, AnalysisContext analysisContext) {
        List<BGCell> bgCellList;
        Long modelIdLong = olapPojo.getModelIdLong();
        LinkedHashMap dimensionAndMemberNumberSetMap = olapPojo.getDimensionAndMemberNumberSetMap();
        if (dimensionAndMemberNumberSetMap == null) {
            dimensionAndMemberNumberSetMap = new LinkedHashMap(16);
            olapPojo.setDimensionAndMemberNumberSetMap(dimensionAndMemberNumberSetMap);
            Map dimensionAndMemberNumberMap = olapPojo.getDimensionAndMemberNumberMap();
            for (Map.Entry entry : dimensionAndMemberNumberMap.entrySet()) {
                LinkedHashSet memberNumberStringSet2 = new LinkedHashSet(1);
                memberNumberStringSet2.add(entry.getValue());
                dimensionAndMemberNumberSetMap.put(entry.getKey(), memberNumberStringSet2);
            }
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelIdLong);
        String oneAccountMember = (String)((Set)dimensionAndMemberNumberSetMap.get(SysDimensionEnum.Account.getNumber())).iterator().next();
        Member accountMember = modelCacheHelper.getMember(SysDimensionEnum.Account.getNumber(), null, oneAccountMember);
        if (accountMember == null) {
            return Collections.emptyList();
        }
        String oneMetricMember = (String)((Set)dimensionAndMemberNumberSetMap.get(SysDimensionEnum.Metric.getNumber())).iterator().next();
        Member metricMember = modelCacheHelper.getMember(SysDimensionEnum.Metric.getNumber(), null, oneMetricMember);
        if (metricMember == null || !metricMember.hasAgg()) {
            return Collections.emptyList();
        }
        Long dataSetId = accountMember.getDatasetId();
        List dimensionList = modelCacheHelper.getDimensionList(dataSetId);
        for (Dimension dimension : dimensionList) {
            Set strings = (Set)dimensionAndMemberNumberSetMap.get(dimension.getNumber());
            if (!CollectionUtils.isEmpty((Collection)strings)) continue;
            return Collections.emptyList();
        }
        HashMap<String, Set<String>> memberInfo = new HashMap<String, Set<String>>(dimensionList.size());
        Long busModelByDataSet = modelCacheHelper.getBusModelByDataSet(dataSetId);
        dimensionAndMemberNumberSetMap.forEach((dimensionNumberString, memberNumberStringSet) -> {
            Dimension dimension = modelCacheHelper.getDimension(dimensionNumberString);
            if (Boolean.TRUE.equals(olapPojo.getLeafMemberBoolean())) {
                LinkedHashSet<String> finalMemberNumberStringSet = new LinkedHashSet<String>(16);
                for (String memberNumberString : memberNumberStringSet) {
                    Member member = modelCacheHelper.getMemberByAnyView(busModelByDataSet, dimensionNumberString, memberNumberString);
                    if (member == null) continue;
                    if (dimension.hasWeight()) {
                        ShowBizRuleUtils.getLeafExcludeSkipAggType(finalMemberNumberStringSet, member, member.getNumber());
                        continue;
                    }
                    ShowBizRuleUtils.addLeafMember(finalMemberNumberStringSet, member);
                }
                if (CollectionUtils.isNotEmpty(finalMemberNumberStringSet)) {
                    memberInfo.put((String)dimensionNumberString, (Set<String>)finalMemberNumberStringSet);
                }
            } else if (CollectionUtils.isNotEmpty((Collection)memberNumberStringSet)) {
                memberInfo.put((String)dimensionNumberString, (Set<String>)memberNumberStringSet);
            }
        });
        if (memberInfo.size() != dimensionAndMemberNumberSetMap.size()) {
            return Collections.emptyList();
        }
        QueryRequest request = new QueryRequest();
        request.setModelId(modelIdLong);
        request.setDatasetId(dataSetId);
        request.setMemberInfo(memberInfo);
        if (OlapManager.getInstance().checkDimensionNoError(dimensionList, memberInfo)) {
            return Collections.emptyList();
        }
        if (analysisContext == null) {
            bgCellList = OlapCommService.getInstance().queryList(request);
        } else {
            try {
                AnalysisContext newAnalysisContext = ShowBizRuleUtils.getAnalysisContext(analysisContext, dataSetId);
                OlapContext.setAnalysisContext((AnalysisContext)newAnalysisContext);
                AlgoCalcRequest algoCalcRequest = ShowBizRuleUtils.buildAnalysisRequest(newAnalysisContext, modelIdLong, dataSetId, Collections.emptyMap(), memberInfo, Collections.emptyList());
                bgCellList = OlapCommService.getInstance().queryByRule(algoCalcRequest);
            }
            finally {
                OlapContext.clearAnalysisContext();
            }
        }
        return ShowBizRuleUtils.trans(bgCellList);
    }

    private static void addLeafMember(Set<String> finalMemberNumberStringSet, Member member) {
        List memberList = member.getAllMembers();
        if (CollectionUtils.isEmpty((Collection)memberList)) {
            return;
        }
        for (Member itemMember : memberList) {
            if (!itemMember.isLeaf()) continue;
            finalMemberNumberStringSet.add(itemMember.getNumber());
        }
    }

    public static void getLeafExcludeSkipAggType(Set<String> finalMemberNumberStringSet, Member member, String number) {
        if (!number.equals(member.getNumber()) && AggOprtEnum.SKIP.getSign().equals(member.getAggType())) {
            return;
        }
        if (member.isLeaf()) {
            finalMemberNumberStringSet.add(member.getNumber());
        } else {
            for (Member child : member.getChildren()) {
                ShowBizRuleUtils.getLeafExcludeSkipAggType(finalMemberNumberStringSet, child, number);
            }
        }
    }

    @NotNull
    public static List<CellPojo> trans(List<BGCell> bgCellList) {
        ArrayList<CellPojo> cellPojoList = new ArrayList<CellPojo>(16);
        for (BGCell bgCell : bgCellList) {
            CellPojo cellPojo = new CellPojo();
            cellPojo.setDimensionAndMemberStringMap(bgCell.getMemberMap());
            cellPojo.setValueString(ObjUtils.getString((Object)bgCell.getValue()));
            cellPojoList.add(cellPojo);
        }
        return cellPojoList;
    }

    public static List<RuleDto> filterRuleByScope(Map<String, Set<String>> queryInfoScope, List<RuleDto> rules) {
        ArrayList newRules = Lists.newArrayListWithExpectedSize((int)rules.size());
        for (RuleDto rule : rules) {
            boolean checked = true;
            Map leftRefMembers = rule.getLeftMembers();
            for (Map.Entry entry : leftRefMembers.entrySet()) {
                String dimNumber = (String)entry.getKey();
                Set leftMembers = (Set)entry.getValue();
                Set<String> queryMembers = queryInfoScope.get(dimNumber);
                HashSet intersection = Sets.newHashSet();
                if (queryMembers != null) {
                    intersection = Sets.intersection((Set)leftMembers, queryMembers);
                }
                if (!intersection.isEmpty()) continue;
                checked = false;
                break;
            }
            if (!checked) continue;
            newRules.add(rule);
        }
        return newRules;
    }

    private static /* synthetic */ RuleFunction lambda$appendInMemberBo$1(RuleFunction v) {
        return v;
    }

    private static /* synthetic */ Set lambda$appendInMemberBo$0(Map.Entry v) {
        return Sets.newHashSet((Object[])new String[]{(String)v.getValue()});
    }
}

