/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.service.biztemplate;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.elasticsearch.OlapDataAuditEventEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.log.Stats;
import kd.epm.eb.common.olapdao.BGCell;
import kd.epm.eb.common.olapdao.BgmdShrekDao;
import kd.epm.eb.common.olapdao.OlapCalcOption;
import kd.epm.eb.common.olapdao.OlapContext;
import kd.epm.eb.common.olapdao.OlapWriteOption;
import kd.epm.eb.common.olapdao.SaveDataContext;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.StrUtils;
import kd.epm.eb.olap.impl.bizrule.entity.FormulaMemberDto;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.impl.bizrule.entity.RuleRightItemDto;
import kd.epm.eb.olap.impl.execute.impl.Environment;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.BinaryExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.expr.MdxMemberExpr;
import kd.epm.eb.olap.impl.execute.impl.expr.parse.Parse2RPN;
import kd.epm.eb.olap.service.AlgoCalcUtils;
import kd.epm.eb.olap.service.CheckRuleSimpleUtils;
import kd.epm.eb.olap.service.LeafFeature;
import kd.epm.eb.olap.service.OlapManager;
import kd.epm.eb.olap.service.biztemplate.strategy.ReturnChangeDataStrategy;
import kd.epm.eb.olap.service.enums.CheckResult;
import kd.epm.eb.olap.service.request.AlgoCalcRequest;
import kd.epm.eb.olap.service.request.QueryRequest;
import kd.epm.eb.olap.service.request.SaveRequest;
import kd.epm.eb.olap.service.request.ShrekCalcRequest;
import kd.epm.epbs.business.log.trace.OlapTraceServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class CalcBizTemplate {
    private static final Log log = LogFactory.getLog(CalcBizTemplate.class);
    private OlapCalcOption calcOption = new OlapCalcOption();
    private OlapWriteOption writeOption = new OlapWriteOption();
    private IModelCacheHelper modelCache;
    List<BGCell> bgCells = new ArrayList<BGCell>(16);
    private Stats stats = new Stats("CalcBizTemplate");

    public static CalcBizTemplate newInstance() {
        return new CalcBizTemplate();
    }

    private CalcBizTemplate() {
    }

    public final List<BGCell> doService(AlgoCalcRequest request) {
        log.info(StrUtils.format((String)"CalcBizTemplate,request: {}", (Object[])new Object[]{request.toString()}));
        Long modelId = request.getModelId();
        IModelCacheHelper modelCache = this.getModelCache(modelId);
        Long datasetId = request.getDatasetId();
        Set dimensionSet = modelCache.getDimensionList(datasetId).stream().map(BaseCache::getNumber).collect(Collectors.toSet());
        Set<String> requestDimSet = request.getMemberInfo().keySet();
        dimensionSet.removeAll(requestDimSet);
        if (dimensionSet.size() > 0) {
            return this.bgCells;
        }
        OlapManager.getInstance().checkRuleViewNeedUpgrade(request);
        AlgoCalcRequest newRequest = new AlgoCalcRequest(modelId, datasetId, request.getViewMap(), request.getMemberInfo(), request.getRules(), request.getOptions());
        newRequest.setRowMemberRelDims(request.getRowMemberRelDims());
        newRequest.setRowMemberRelList(request.getRowMemberRelList());
        OlapManager.getInstance().filterRulesRangeMember(newRequest, modelCache);
        for (Map.Entry<String, Set<String>> entry : newRequest.getMemberInfo().entrySet()) {
            if (!entry.getValue().isEmpty()) continue;
            return this.bgCells;
        }
        OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.BizRule));
        List<RuleDto> rules = newRequest.getRules();
        String traceOpInfo = rules.stream().map(RuleDto::getNumber).collect(Collectors.joining(","));
        this.beforeDoService(traceOpInfo);
        List<RuleDto> newRules = this.getNewRulesByOffset(newRequest, rules);
        newRequest.setRules(Lists.newArrayList((Object[])new RuleDto[]{newRules.get(0)}));
        CheckResult checkResult = this.checkRuleSimple(newRequest);
        for (RuleDto newRule : newRules) {
            newRequest.setRules(Lists.newArrayList((Object[])new RuleDto[]{newRule}));
            if (CheckResult.AllDataLock == checkResult) continue;
            if (CheckResult.OlapCalc == checkResult) {
                this.bgCells.addAll(this.olapCalcStrategy(newRequest));
                continue;
            }
            this.bgCells.addAll(this.algoCalcStrategy(newRequest));
        }
        this.afterDoService();
        return this.bgCells;
    }

    private List<RuleDto> getNewRulesByOffset(AlgoCalcRequest request, List<RuleDto> rules) {
        ArrayList<RuleDto> newRules = new ArrayList<RuleDto>(rules.size());
        IModelCacheHelper modelCache = this.getModelCache(request.getModelId());
        String bpDimNumber = SysDimensionEnum.BudgetPeriod.getNumber();
        Dimension bpDim = modelCache.getDimension(bpDimNumber);
        for (RuleDto rule : rules) {
            Set<String> requestBpSet;
            Sets.SetView intersection;
            if (rule.getOffsetMap().isEmpty()) {
                newRules.add(rule);
                continue;
            }
            Map leftMembers = rule.getLeftMembers();
            Set bpMembers = (Set)leftMembers.get(bpDimNumber);
            if (CollectionUtils.isEmpty((Collection)bpMembers)) {
                bpMembers = rule.getNewLeafFeature() == LeafFeature.LEAF ? bpDim.getAllMembers().stream().filter(Member::isLeaf).map(BaseCache::getNumber).collect(Collectors.toSet()) : bpDim.getAllMembers().stream().map(BaseCache::getNumber).collect(Collectors.toSet());
            }
            if (CollectionUtils.isEmpty((Collection)(intersection = Sets.intersection((Set)bpMembers, requestBpSet = request.getMemberInfo().get(SysDimensionEnum.BudgetPeriod.getNumber()))))) {
                newRules.add(rule);
                continue;
            }
            bpMembers = new HashSet(intersection);
            List sortList = bpMembers.stream().sorted(String::compareTo).collect(Collectors.toList());
            Stats.StatItem getNewRulesByOffset = this.stats.createStatItem("getNewRulesByOffset");
            getNewRulesByOffset.append((Object)("srcRule:" + rule.getNumber()));
            getNewRulesByOffset.append((Object)("bpMembers-size:" + bpMembers.size()));
            for (String bpMember : sortList) {
                RuleDto newRule = new RuleDto();
                try {
                    this.copyRule(rule, newRule);
                    newRule.setNumber(rule.getNumber() + "_" + bpMember);
                    HashMap<String, HashSet> newLeftMembers = new HashMap<String, HashSet>(16);
                    newRule.setLeftMembers(newLeftMembers);
                    for (Map.Entry entry : leftMembers.entrySet()) {
                        String dimNum2 = (String)entry.getKey();
                        if (bpDimNumber.equals(dimNum2)) {
                            newLeftMembers.put(bpDimNumber, Sets.newHashSet((Object[])new String[]{bpMember}));
                            continue;
                        }
                        newLeftMembers.put(dimNum2, (HashSet)entry.getValue());
                    }
                    Set leftBpMembers = (Set)newLeftMembers.get(SysDimensionEnum.BudgetPeriod.getNumber());
                    if (leftBpMembers == null) {
                        newLeftMembers.put(bpDimNumber, Sets.newHashSet((Object[])new String[]{bpMember}));
                    }
                    HashMap<String, Set> newUnionPageRightMembers = new HashMap<String, Set>(16);
                    rule.getUnionPageRightMembers().forEach((dimNum, members) -> {
                        if (bpDimNumber.equals(dimNum)) {
                            newUnionPageRightMembers.put((String)dimNum, new HashSet(members));
                        } else {
                            newUnionPageRightMembers.put((String)dimNum, (Set)members);
                        }
                    });
                    HashMap<String, String> newRightItemBpMemMap = new HashMap<String, String>(16);
                    HashSet<String> notOffsetBpMemSet = new HashSet<String>(16);
                    HashMap<String, Integer> funcOffsetMap = new HashMap<String, Integer>(16);
                    ArrayList<RuleRightItemDto> newRuleRightItemDtoList = new ArrayList<RuleRightItemDto>(16);
                    List ruleRightItemDtoList = rule.getRuleRightItemDto();
                    for (RuleRightItemDto ruleRightItemDto : ruleRightItemDtoList) {
                        Integer periodOffset = ruleRightItemDto.getPeriodOffset();
                        String memberKey = ruleRightItemDto.getMemberKey();
                        if (ruleRightItemDto.isPeriodshift() || periodOffset == null || periodOffset == 0 || StringUtils.isNotEmpty((String)ruleRightItemDto.getRefFunctionKey())) {
                            if (StringUtils.isNotEmpty((String)ruleRightItemDto.getRefFunctionKey()) && periodOffset != null) {
                                funcOffsetMap.put(memberKey, periodOffset);
                            }
                            newRuleRightItemDtoList.add(ruleRightItemDto);
                            continue;
                        }
                        RuleRightItemDto newRuleRightItemDto = new RuleRightItemDto();
                        this.copyRuleRightItemDto(ruleRightItemDto, newRuleRightItemDto);
                        List<FormulaMemberDto> formulaMemberList = ruleRightItemDto.getFormulaMemberList();
                        ArrayList<FormulaMemberDto> newFormulaMemberList = new ArrayList<FormulaMemberDto>(16);
                        newRuleRightItemDto.setFormulaMemberList(newFormulaMemberList);
                        newFormulaMemberList.addAll(formulaMemberList);
                        FormulaMemberDto formulaMemberDto = new FormulaMemberDto();
                        Member memberOffset = modelCache.getMemberOffset(bpDimNumber, bpMember, periodOffset.intValue());
                        if (memberOffset != null) {
                            formulaMemberDto.setId(memberOffset.getId());
                            String bpMemberNum = memberOffset.getNumber();
                            formulaMemberDto.setNumber(bpMemberNum);
                            formulaMemberDto.setLongNumber(memberOffset.getLongNumber());
                            formulaMemberDto.setName(memberOffset.getName());
                            formulaMemberDto.setDimNumber(bpDimNumber);
                            formulaMemberDto.setDimShortNumber(SysDimensionEnum.BudgetPeriod.getShortNumber());
                            formulaMemberDto.setVariable(Boolean.valueOf(false));
                            newFormulaMemberList.add(formulaMemberDto);
                            Map<String, Set<String>> refMemberMap = ruleRightItemDto.getRefMemberMap();
                            HashMap<String, Set<String>> newRefMemberMap = new HashMap<String, Set<String>>(16);
                            refMemberMap.forEach((dim, memSet) -> {
                                if (bpDimNumber.equals(dim)) {
                                    newRefMemberMap.put((String)dim, new LinkedHashSet(memSet));
                                } else {
                                    newRefMemberMap.put((String)dim, (Set<String>)memSet);
                                }
                            });
                            Set bpMemberSet = newRefMemberMap.computeIfAbsent(bpDimNumber, k -> new LinkedHashSet(16));
                            bpMemberSet.add(bpMemberNum);
                            newRuleRightItemDto.setRefMemberMap(newRefMemberMap);
                            newRightItemBpMemMap.put(memberKey, bpMemberNum);
                            newRuleRightItemDtoList.add(newRuleRightItemDto);
                            Map<String, Set<String>> _refMemberMap = newRuleRightItemDto.getRefMemberMap();
                            for (Map.Entry<String, Set<String>> entry : _refMemberMap.entrySet()) {
                                String dimNumber = entry.getKey();
                                if (!bpDimNumber.equals(dimNumber)) continue;
                                Set<String> refMember = entry.getValue();
                                newUnionPageRightMembers.computeIfAbsent(dimNumber, v -> new HashSet(10)).addAll(refMember);
                            }
                        } else {
                            notOffsetBpMemSet.add(memberKey);
                        }
                        newRuleRightItemDto.setPeriodOffset(null);
                    }
                    newRule.setRuleRightItemDto(newRuleRightItemDtoList);
                    newRule.setUnionPageRightMembers(newUnionPageRightMembers);
                    Map rightMembers = rule.getRightMembers();
                    HashMap newRightMembers = new HashMap(16);
                    rightMembers.forEach((memKey, rightMemberMap) -> {
                        if (!notOffsetBpMemSet.contains(memKey)) {
                            HashMap newRightMemberMap = new HashMap(16);
                            rightMemberMap.forEach((dim, memSet) -> {
                                if (bpDimNumber.equals(dim)) {
                                    newRightMemberMap.put(dim, new HashSet(memSet));
                                } else {
                                    newRightMemberMap.put(dim, memSet);
                                }
                            });
                            newRightMembers.put(memKey, newRightMemberMap);
                        }
                    });
                    newRule.setRightMembers(newRightMembers);
                    Map rightPageMembers = rule.getRightPageMembers();
                    HashMap newRightPageMembers = new HashMap(16);
                    rightPageMembers.forEach((memKey, rightPageMemberMap) -> {
                        if (!notOffsetBpMemSet.contains(memKey)) {
                            HashMap newRightPageMemberMap = new HashMap(16);
                            rightPageMemberMap.forEach((dim, memSet) -> {
                                if (bpDimNumber.equals(dim)) {
                                    newRightPageMemberMap.put(dim, new HashSet(memSet));
                                } else {
                                    newRightPageMemberMap.put(dim, memSet);
                                }
                            });
                            newRightPageMembers.put(memKey, newRightPageMemberMap);
                        }
                    });
                    newRule.setRightPageMembers(newRightPageMembers);
                    newRightItemBpMemMap.forEach((memKey, bpMemNum) -> {
                        Map rightPageMemMap;
                        Map rightMemMap = (Map)newRightMembers.get(memKey);
                        if (rightMemMap != null) {
                            Set bpMemSet = rightMemMap.computeIfAbsent(bpDimNumber, k -> new HashSet(16));
                            bpMemSet.add(bpMemNum);
                        }
                        if ((rightPageMemMap = (Map)newRightPageMembers.get(memKey)) != null) {
                            Set bpMemSet = rightPageMemMap.computeIfAbsent(bpDimNumber, k -> new HashSet(16));
                            bpMemSet.add(bpMemNum);
                        }
                    });
                    newRule.setOffsetMap(funcOffsetMap);
                    Map periodOffsetMap = (Map)JsonUtils.readValue((String)rule.getPeriodOffset(), (TypeReference)new TypeReference<Map<String, Long>>(){});
                    HashMap _periodOffsetMap = new HashMap(16);
                    for (String memberKey : funcOffsetMap.keySet()) {
                        if (!periodOffsetMap.containsKey(memberKey)) continue;
                        _periodOffsetMap.put(memberKey, periodOffsetMap.get(memberKey));
                    }
                    if (_periodOffsetMap.isEmpty()) {
                        newRule.setPeriodOffset(null);
                    } else {
                        newRule.setPeriodOffset(JsonUtils.getJsonString(_periodOffsetMap));
                    }
                    String formulaString = rule.getFormulaString();
                    for (String memberKey : notOffsetBpMemSet) {
                        String memberKeyStr = "MBR:\\[" + memberKey + "]";
                        formulaString = formulaString.replaceAll(memberKeyStr, "1*null");
                    }
                    if (notOffsetBpMemSet.size() > 0) {
                        getNewRulesByOffset.append((Object)("notOffsetBpMem-rule:" + newRule.getNumber()));
                        getNewRulesByOffset.append((Object)("notOffsetBpMemSet:" + StringUtils.join(notOffsetBpMemSet, (String)",")));
                    }
                    newRule.setFormulaString(formulaString);
                    newRules.add(newRule);
                }
                catch (Exception e) {
                    log.error("getNewRulesByOffset-error:", (Throwable)e);
                    throw new KDBizException(e.getMessage());
                }
            }
            getNewRulesByOffset.close();
        }
        return newRules;
    }

    private void copyRuleRightItemDto(RuleRightItemDto ruleRightItemDto, RuleRightItemDto newRuleRightItemDto) {
        newRuleRightItemDto.setMemberKey(ruleRightItemDto.getMemberKey());
        newRuleRightItemDto.setPeriodOffset(ruleRightItemDto.getPeriodOffset());
        newRuleRightItemDto.setDataSetId(ruleRightItemDto.getDataSetId());
        newRuleRightItemDto.setSkipDimList(ruleRightItemDto.getSkipDimList());
        newRuleRightItemDto.setLoop(ruleRightItemDto.isLoop());
        newRuleRightItemDto.setFunctionRefDimList(ruleRightItemDto.getFunctionRefDimList());
        newRuleRightItemDto.setFormulaMemberList(ruleRightItemDto.getFormulaMemberList());
        newRuleRightItemDto.setRefMemberMap(ruleRightItemDto.getRefMemberMap());
        newRuleRightItemDto.setFilterRefMemberMap(ruleRightItemDto.getFilterRefMemberMap());
        newRuleRightItemDto.setRefFunctionKey(ruleRightItemDto.getRefFunctionKey());
        newRuleRightItemDto.setRefFunctionDimView(ruleRightItemDto.getRefFunctionDimView());
        newRuleRightItemDto.setYvRelationHasMem(ruleRightItemDto.isYvRelationHasMem());
    }

    private void copyRule(RuleDto rule, RuleDto newRule) {
        newRule.setId(rule.getId());
        newRule.setModelId(rule.getModelId());
        newRule.setNumber(rule.getNumber());
        newRule.setName(rule.getName());
        newRule.setUseScope(rule.getUseScope());
        newRule.setFormulaString(rule.getFormulaString());
        newRule.setStatus(rule.getStatus());
        newRule.setMdxLeft(rule.getMdxLeft());
        newRule.setMdxRight(rule.getMdxRight());
        newRule.setLeafFeature(rule.getLeafFeature());
        newRule.setNewLeafFeature(rule.getNewLeafFeature());
        newRule.setPeriodOffset(rule.getPeriodOffset());
        newRule.setSuccessors(rule.getSuccessors());
        newRule.setOffSuccessors(rule.getOffSuccessors());
        newRule.setDimRefProp(rule.getDimRefProp());
        newRule.setGroupId(rule.getGroupId());
        newRule.setBizCtrlRangeId(rule.getBizCtrlRangeId());
        newRule.setMainDimensionId(rule.getMainDimensionId());
        newRule.setOffsetMap(rule.getOffsetMap());
        newRule.setLeftMembers(rule.getLeftMembers());
        newRule.setRightMembers(rule.getRightMembers());
        newRule.setRightMemberCacheNav(rule.getRightMemberCacheNav());
        newRule.setUnionPageRightMembers(rule.getUnionPageRightMembers());
        newRule.setRightPageMembers(rule.getRightPageMembers());
        newRule.setFunctions(rule.getFunctions());
        newRule.setDataSetId(rule.getDataSetId());
        newRule.setRuleRightItemDto(rule.getRuleRightItemDto());
        newRule.setSkipSelf(rule.isSkipSelf());
        newRule.setCalcRefMember(rule.getCalcRefMember());
        newRule.setIfHasNotParam(rule.isIfHasNotParam());
        newRule.setViewMap(rule.getViewMap());
        newRule.setMainDimensionViewId(rule.getMainDimensionViewId());
        newRule.setRuleView(rule.getRuleView());
        newRule.setLeftMainMemContainCtControl(rule.isLeftMainMemContainCtControl());
        newRule.setOriRightMembers(rule.getOriRightMembers());
    }

    private List<BGCell> algoCalcStrategy(AlgoCalcRequest request) {
        Stats.StatItem algoCalc = this.stats.createStatItem("algoCalc");
        ArrayList<BGCell> bgCells = new ArrayList(16);
        List<RuleDto> rules = request.getRules();
        if (request.getOptions().getNeedFilterRule().booleanValue()) {
            List<RuleDto> ruleDtos = AlgoCalcUtils.filterRuleByScope(request.getMemberInfo(), rules, null);
            if (ruleDtos.isEmpty()) {
                algoCalc.appendAndClose((Object)"rule is not in scope.");
                return bgCells;
            }
            request.setRules(ruleDtos);
        }
        bgCells = this.algoCalc(request);
        algoCalc.close();
        Stats.StatItem save = this.stats.createStatItem("save");
        List<BGCell> changeCells = this.compareSave(request, bgCells);
        if (this.calcOption.isReturnChangeData()) {
            bgCells = changeCells;
        }
        save.close();
        return bgCells;
    }

    private void afterDoService() {
        this.stats.appendMessage(StrUtils.format((String)"result size:{},results sampling:{}", (Object[])new Object[]{this.bgCells.size(), this.bgCells.isEmpty() ? "null" : this.bgCells.get(0).toString()}));
        log.info(this.stats.toString("budget-olap-log:"));
    }

    private List<BGCell> olapCalcStrategy(AlgoCalcRequest request) {
        Stats.StatItem shrekCalc = this.stats.createStatItem("shrekCalc");
        List<Object> bgCells = new ArrayList<BGCell>(16);
        Map<String, Set<String>> memberInfo = request.getMemberInfo();
        IModelCacheHelper modelCache = this.getModelCache(request.getModelId());
        if (request.getRules().get(0).getLeafFeature() == kd.epm.eb.algo.olap.LeafFeature.LEAF) {
            memberInfo = this.filterLeafScope(memberInfo, request, modelCache);
        }
        if (memberInfo == null) {
            shrekCalc.appendAndClose((Object)"rule is leaf and calc range NoLeaf.don't calc");
            return bgCells;
        }
        ReturnChangeDataStrategy returnChangeDataStrategy = new ReturnChangeDataStrategy(this.calcOption.isReturnChangeData());
        returnChangeDataStrategy.queryBefore(new QueryRequest(request.getModelId(), request.getDatasetId(), request.getMemberInfo()));
        ShrekCalcRequest shrekCalcRequest = new ShrekCalcRequest(request.getModelId(), request.getDatasetId(), request.getMemberInfo(), request.getRules().get(0), true);
        this.shrekCalc(shrekCalcRequest);
        bgCells = returnChangeDataStrategy.getChangeData();
        shrekCalc.close();
        return bgCells;
    }

    private void beforeDoService(String traceOpInfo) {
        if (OlapContext.getSaveDataContext() == null) {
            OlapContext.setSaveDataContext((SaveDataContext)new SaveDataContext(OlapDataAuditEventEnum.BizRule));
            OlapTraceServiceHelper.setTraceOpInfo((String)traceOpInfo);
        }
    }

    private Map<String, Set<String>> filterLeafScope(Map<String, Set<String>> ruleScope, AlgoCalcRequest request, IModelCacheHelper modelCache) {
        HashMap<String, Set<String>> leafScope = new HashMap<String, Set<String>>(16);
        Map viewMap = request.getRules().get(0).getViewMap();
        for (Map.Entry<String, Set<String>> entry : ruleScope.entrySet()) {
            String dimNumber = entry.getKey();
            Set<String> members = entry.getValue();
            HashSet<String> leafMembers = new HashSet<String>(members.size());
            for (String memberNumber : members) {
                Member member = modelCache.getMember(dimNumber, (Long)viewMap.get(dimNumber), memberNumber);
                if (member == null || !member.isLeaf()) continue;
                leafMembers.add(memberNumber);
            }
            if (!leafMembers.isEmpty()) {
                leafScope.put(dimNumber, leafMembers);
                continue;
            }
            return null;
        }
        return leafScope;
    }

    private CheckResult checkRuleSimple(AlgoCalcRequest request) {
        IModelCacheHelper modelCache = this.getModelCache(request.getModelId());
        if (request.getRules().size() != 1) {
            return CheckResult.AlgoCalc;
        }
        RuleDto ruleDto = request.getRules().get(0);
        return CheckRuleSimpleUtils.check((IModelCacheHelper)modelCache, (RuleDto)ruleDto);
    }

    private void shrekCalc(ShrekCalcRequest request) {
        RuleDto ruleDto = request.getRule();
        Parse2RPN parse2RPN = new Parse2RPN(ruleDto.getFormulaString());
        parse2RPN.parse();
        BinaryExpr binaryExpr = (BinaryExpr)parse2RPN.getExpr();
        IModelCacheHelper modelCache = this.getModelCache(request.getModelId());
        Long mainDimensionId = ruleDto.getMainDimensionId();
        Dimension dimension = modelCache.getDimension(mainDimensionId);
        List ruleRightItemDto = ruleDto.getRuleRightItemDto();
        Map<String, RuleRightItemDto> ruleRightItemDtoMap = ruleRightItemDto.stream().collect(Collectors.toMap(RuleRightItemDto::getMemberKey, v -> v));
        Environment env = new Environment();
        env.setRuleDto(ruleDto);
        env.setBizModelId(request.getDatasetId());
        env.setMainDimNumber(dimension.getNumber());
        env.setLeftMembers(ruleDto.getLeftMembers());
        env.setRuleRightItemDtoMap(ruleRightItemDtoMap);
        env.setModelCache(modelCache);
        String leftMdx = ((MdxMemberExpr)binaryExpr.getLeft()).toLeftShrekString(env);
        String rightMdx = binaryExpr.getRight().toShrekString(env);
        String cubeNumber = AlgoCalcUtils.getCubeNumber(request.getDatasetId());
        List<Pair> rules = Collections.singletonList(Pair.onePair((Object)leftMdx, (Object)rightMdx));
        Map memberInfo = request.getMemberInfo();
        HashMap calcInfos = Maps.newHashMapWithExpectedSize((int)memberInfo.size());
        for (Map.Entry entry : memberInfo.entrySet()) {
            Set leftSet = (Set)ruleDto.getLeftMembers().get(entry.getKey());
            if (leftSet == null) {
                calcInfos.put(entry.getKey(), entry.getValue());
                continue;
            }
            HashSet strings = new HashSet(leftSet);
            strings.retainAll((Collection)entry.getValue());
            if (strings.isEmpty()) {
                return;
            }
            calcInfos.put(entry.getKey(), strings);
        }
        try {
            BgmdShrekDao.getInstance().calcRule(modelCache.getModelobj(), cubeNumber, dimension.getNumber(), (Map)calcInfos, rules, request.isAddLog());
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadResFormat((String)"\u89c4\u5219[%1]\u6267\u884c\u5931\u8d25[%2],\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"CalcBizTemplate_1", (String)"epm-eb-olap", (Object[])new Object[]{ruleDto.getNumber(), e.getMessage()}));
        }
    }

    private List<BGCell> algoCalc(AlgoCalcRequest request) {
        return OlapManager.getInstance().singleCalc(request);
    }

    private List<BGCell> compareSave(AlgoCalcRequest request, List<BGCell> cells) {
        Set<String> calcBpMembers;
        Sets.SetView intersection;
        HashMap copyMap = Maps.newHashMapWithExpectedSize((int)request.getMemberInfo().size());
        request.getMemberInfo().forEach((k, v) -> {
            Set cfr_ignored_0 = copyMap.put(k, new HashSet(v));
        });
        QueryRequest req = new QueryRequest(request.getModelId(), request.getDatasetId(), copyMap);
        Set ruleBpMembers = (Set)request.getRules().get(0).getLeftMembers().get(SysDimensionEnum.BudgetPeriod.getNumber());
        if (CollectionUtils.isNotEmpty((Collection)ruleBpMembers) && CollectionUtils.isNotEmpty((Collection)(intersection = Sets.intersection((Set)ruleBpMembers, calcBpMembers = req.getMemberInfo().get(SysDimensionEnum.BudgetPeriod.getNumber()))))) {
            req.getMemberInfo().put(SysDimensionEnum.BudgetPeriod.getNumber(), new HashSet(intersection));
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)req.getModelId());
        List<BGCell> oldCells = OlapManager.getInstance().queryList(req);
        Long busModelByDataSet = modelCache.getBusModelByDataSet(request.getDatasetId());
        RuleDto ruleDto = request.getRules().get(0);
        this.filterLeafCells(modelCache, oldCells, busModelByDataSet, ruleDto);
        List dimensionList = modelCache.getDimensionList(req.getDatasetId());
        LinkedList<BGCell> changeCell = AlgoCalcUtils.getChangeCell(oldCells, cells, dimensionList);
        SaveRequest saveRequest = new SaveRequest(request.getModelId(), request.getDatasetId(), changeCell);
        this.writeOption.setDataLockThrowErr(false);
        OlapManager.getInstance().saveList(saveRequest, this.writeOption);
        List<BGCell> newDbCells = OlapManager.getInstance().queryList(req);
        this.filterLeafCells(modelCache, newDbCells, busModelByDataSet, ruleDto);
        return AlgoCalcUtils.getChangeCell(oldCells, newDbCells, dimensionList);
    }

    private void filterLeafCells(IModelCacheHelper modelCache, List<BGCell> bgCells, Long busModelByDataSet, RuleDto ruleDto) {
        if (ruleDto.getLeafFeature() == kd.epm.eb.algo.olap.LeafFeature.NOTLEAF && bgCells.size() > 0) {
            bgCells.removeIf(e -> {
                Map memberMap = e.getMemberMap();
                for (Map.Entry entry : memberMap.entrySet()) {
                    Member member = modelCache.getMemberByAnyView(busModelByDataSet, (String)entry.getKey(), (String)entry.getValue());
                    if (member == null || member.isLeaf()) continue;
                    return false;
                }
                return true;
            });
        }
    }

    public void setReturnChangeData(boolean returnChangeData) {
        this.calcOption.setReturnChangeData(returnChangeData);
    }

    public void setWriteOption(OlapWriteOption writeOption) {
        this.writeOption = writeOption;
    }

    public IModelCacheHelper getModelCache(long modelId) {
        if (this.modelCache == null) {
            this.modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        }
        return this.modelCache;
    }
}

