/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.service.request;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.service.request.AlgoCalcRequest;
import kd.epm.eb.olap.service.request.Options;

public class QueryRequest
implements Serializable {
    private String number;
    private Long modelId;
    private Long datasetId;
    private Map<String, Long> viewMap;
    private Map<String, Set<String>> memberInfo;
    private List<String> selectDims;
    private List<RuleDto> rules = null;
    private List<String> rowMemberRelDims;
    private List<String[]> rowMemberRelList;
    private Options options;

    public QueryRequest() {
    }

    public QueryRequest(Long modelId, Long datasetId, Map<String, Set<String>> memberInfo) {
        this.modelId = modelId;
        this.datasetId = datasetId;
        this.memberInfo = memberInfo;
    }

    public QueryRequest(Long modelId, Long datasetId, Map<String, Set<String>> memberInfo, List<String> selectDims) {
        this.modelId = modelId;
        this.datasetId = datasetId;
        this.memberInfo = memberInfo;
        this.selectDims = selectDims;
    }

    public QueryRequest(Long modelId, Long datasetId, Map<String, Long> viewMap, Map<String, Set<String>> memberInfo, List<String> selectDims) {
        this.modelId = modelId;
        this.datasetId = datasetId;
        this.viewMap = viewMap;
        this.memberInfo = memberInfo;
        this.selectDims = selectDims;
    }

    public static QueryRequest of(AlgoCalcRequest request) {
        QueryRequest queryRequest = new QueryRequest(request.getModelId(), request.getDatasetId(), request.getMemberInfo());
        queryRequest.setViewMap(request.getViewMap());
        queryRequest.setOptions(request.getOptions());
        queryRequest.setRules(request.getRules());
        return queryRequest;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Long getModelId() {
        return this.modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public Long getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(Long datasetId) {
        this.datasetId = datasetId;
    }

    public Map<String, Long> getViewMap() {
        return this.viewMap;
    }

    public void setViewMap(Map<String, Long> viewMap) {
        this.viewMap = viewMap;
    }

    public Map<String, Set<String>> getMemberInfo() {
        return this.memberInfo;
    }

    public void setMemberInfo(Map<String, Set<String>> memberInfo) {
        this.memberInfo = memberInfo;
    }

    public List<String> getSelectDims() {
        return this.selectDims;
    }

    public void setSelectDims(List<String> selectDims) {
        this.selectDims = selectDims;
    }

    public Options getOptions() {
        return this.options;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    @Deprecated
    public void setRules(List<RuleDto> rules) {
        this.rules = rules;
    }

    @Deprecated
    public List<RuleDto> getRules() {
        return this.rules;
    }

    public List<String> getRowMemberRelDims() {
        return this.rowMemberRelDims;
    }

    public void setRowMemberRelDims(List<String> rowMemberRelDims) {
        this.rowMemberRelDims = rowMemberRelDims;
    }

    public List<String[]> getRowMemberRelList() {
        return this.rowMemberRelList;
    }

    public void setRowMemberRelList(List<String[]> rowMemberRelList) {
        this.rowMemberRelList = rowMemberRelList;
    }

    public String toString() {
        int memberRelListSize = this.rowMemberRelList != null ? this.rowMemberRelList.size() : 0;
        return "modelId=" + this.modelId + ", datasetId=" + this.datasetId + "], memberRelDims=[" + this.rowMemberRelDims + "], memberRelListSize=[" + memberRelListSize + ", memberInfo=" + this.memberInfo + '}';
    }
}

