/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.service.view.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.DynamicObjectUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.MemberServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.excelImport.POIUtils;
import kd.epm.eb.olap.service.view.ViewGroupManager;
import kd.epm.eb.olap.service.view.ViewMemberManager;
import kd.epm.eb.olap.service.view.bean.DimensionViewMember;
import kd.epm.eb.olap.service.view.bean.utils.MemberVoUtils;
import kd.epm.eb.olap.service.view.bean.vo.AccountMemberExcelVO;
import kd.epm.eb.olap.service.view.bean.vo.IMemberVO;
import kd.epm.eb.olap.service.view.bean.vo.MemberExcelVO;
import kd.epm.eb.olap.service.view.bean.vo.MemberVO;
import kd.epm.eb.olap.service.view.context.IMemberContext;
import kd.epm.eb.olap.service.view.context.MemberOperEnum;
import kd.epm.eb.olap.service.view.context.MemberOperationSourceEnum;
import kd.epm.eb.olap.service.view.context.SaveMemberContext;
import kd.epm.eb.olap.service.view.valid.AccountExcelImportValidator;
import kd.epm.eb.olap.service.view.valid.EntityExcelImportValidator;
import kd.epm.eb.olap.service.view.valid.ICExcelImportValidator;
import kd.epm.eb.olap.service.view.valid.IMemberValidator;
import kd.epm.eb.olap.service.view.valid.MainSubMemberValidator;
import kd.epm.eb.olap.service.view.valid.MemberBaseExcelImportValidator;
import kd.epm.eb.olap.service.view.valid.MemberDataValidator;
import kd.epm.eb.olap.service.view.valid.MemberExtExcelImportValidator;
import kd.epm.eb.olap.service.view.valid.MemberPermValidator;
import kd.epm.eb.olap.service.view.valid.MemberValidator;
import kd.epm.eb.olap.service.view.valid.ValidResult;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.jetbrains.annotations.NotNull;

public class MemberExcelImportHandler {
    public static final Log log = LogFactory.getLog(MemberExcelImportHandler.class);
    private final SaveMemberContext context;
    private Set<String> refNumbers = null;
    private MemberValidator validator = null;
    public static final int HEAD_ROW_INDEX = 2;
    public static final int DATA_ROW_INDEX = 3;
    private final Set<String> saveMemberNumbers = Sets.newLinkedHashSet();
    private final Set<String> disableMemberNumbers = Sets.newLinkedHashSet();
    private Set<String> presetMembers = null;
    private Boolean openApi = null;
    private final ValidResult<String> disableValid = new ValidResult();

    protected SaveMemberContext getContext() {
        return this.context;
    }

    protected IModelCacheHelper getModelCache() {
        return this.getContext().getModelCache();
    }

    protected Long getModelId() {
        return this.getModelCache().getModelobj().getId();
    }

    protected String getDimNumber() {
        return this.getContext().getDimNumber();
    }

    protected Long getViewId() {
        return this.getContext().getViewId();
    }

    public void setRefNumbers(Set<String> refNumbers) {
        this.refNumbers = refNumbers;
    }

    public Set<String> getRefNumbers() {
        return this.refNumbers;
    }

    protected MemberValidator getValidator() {
        if (this.validator == null) {
            this.validator = MemberBaseExcelImportValidator.getValidator(this.getModelCache(), this.getDimNumber(), this.getViewId());
            this.validator.setRefNumbers(this.getRefNumbers());
            this.validator.setInitAllMember(true);
            this.validator.setInitCusPropValue(true);
            this.validator.setInitMetric(true);
            this.validator.registerValidator(MainSubMemberValidator.get((IMemberContext)this.getContext()));
            this.validator.registerValidator(MemberPermValidator.get((IMemberContext)this.getContext()));
            this.validator.registerValidator(this.getExtExcelImportValidator(this.getContext()));
            this.validator.registerValidator(MemberDataValidator.get((IMemberContext)this.getContext()));
        }
        return this.validator;
    }

    public MemberExcelImportHandler(SaveMemberContext context) {
        this.context = context;
    }

    protected int getHeadRowIndex() {
        return 2;
    }

    protected int getBeginDataRowIndex() {
        return 3;
    }

    protected int getMaxRowCount() {
        return 100002;
    }

    public Set<String> getSaveMemberNumbers() {
        return this.saveMemberNumbers;
    }

    public Set<String> getDisableMemberNumbers() {
        return this.disableMemberNumbers;
    }

    public void execute(List<Workbook> workbooks, List<ValidResult<String>> workBookValid, @NotNull LogStats stats) {
        if (workbooks == null || workbooks.isEmpty()) {
            return;
        }
        MemberVoUtils voUtils = this.getContext().getVoUtils();
        for (Workbook _workBook : workbooks) {
            ValidResult valid = new ValidResult();
            workBookValid.add((ValidResult<String>)valid);
            this.save(this.transMembers(_workBook, (ValidResult<String>)valid, voUtils, stats));
        }
    }

    public void execute(List<IMemberVO> members, ValidResult<String> valid) {
        if (members == null || members.isEmpty()) {
            return;
        }
        this.save(this.verifyMembers(members, valid));
    }

    protected IMemberValidator getExtExcelImportValidator(SaveMemberContext context) {
        Object validator;
        switch (context.getDimNumber()) {
            case "Entity": {
                validator = EntityExcelImportValidator.get((IMemberContext)this.getContext());
                break;
            }
            case "Account": {
                validator = AccountExcelImportValidator.get((IMemberContext)this.getContext());
                break;
            }
            case "InternalCompany": {
                validator = ICExcelImportValidator.get((IMemberContext)this.getContext());
                break;
            }
            default: {
                validator = MemberExtExcelImportValidator.get((IMemberContext)this.getContext());
            }
        }
        return validator;
    }

    protected List<IMemberVO> transMembers(Workbook workbook, ValidResult<String> workValid, MemberVoUtils voUtils, @NotNull LogStats stats) {
        ValidResult<String> _tmpValids;
        stats.addInfo("begin-loadAndValid-sheet.");
        Sheet _sheet = workbook.getSheetAt(0);
        LinkedList members = Lists.newLinkedList();
        short lastCellNum = _sheet.getRow(this.getHeadRowIndex()).getLastCellNum();
        Iterator rows = _sheet.rowIterator();
        while (rows.hasNext()) {
            IMemberVO member;
            Row row = (Row)rows.next();
            if (row.getRowNum() > this.getMaxRowCount()) {
                workValid.addValidResult(row.getRowNum(), (Object)ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458Excel\u5bfc\u5165\u6700\u5927\u53ea\u652f\u630110\u4e07\u6761\u6570\u636e\uff0c\u8bf7\u5206\u6279\u5bfc\u5165\u3002", (String)"DimMemImportBasePlugin_59", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                break;
            }
            if (row.getRowNum() < this.getBeginDataRowIndex() || POIUtils.isBreak((Row)row, (int)lastCellNum) || (member = voUtils.toMember(row)) == null || this.hasPresetMember(member)) continue;
            this.syncCurrentMemberData((MemberExcelVO)member);
            member = this.beforeValid((MemberExcelVO)member);
            if (member != null) {
                members.add(member);
                _tmpValids = this.getValidator().valid(member);
                if (_tmpValids.isOk()) continue;
                workValid.setOk(_tmpValids.isOk());
                workValid.getValidResultMap().put(String.valueOf(row.getRowNum()), _tmpValids.getErrMsg());
                continue;
            }
            if (this.getContext().getOperationType() != MemberOperEnum.ADD) continue;
            workValid.addValidResult(row.getRowNum(), (Object)ResManager.loadKDString((String)"\u8be5\u7f16\u7801\u5df2\u5b58\u5728\u4e8e\u7cfb\u7edf\u4e2d\u3002", (String)"DimMemImportBasePlugin_8", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        if (workValid.isOk()) {
            LinkedHashMap memberVOMap = Maps.newLinkedHashMapWithExpectedSize((int)members.size());
            members.forEach(m -> memberVOMap.put(m.getNumber(), m));
            _tmpValids = this.getValidator().batchValid(memberVOMap);
            if (!_tmpValids.isOk()) {
                workValid.setErrMsg(_tmpValids.getErrMsg());
                workValid.getValidResultMap().putAll(_tmpValids.getValidResultMap());
            } else if (memberVOMap.size() != members.size()) {
                members.clear();
                members.addAll(memberVOMap.values());
            }
        }
        stats.add("end-loadAndValid-sheet.");
        return workValid.isOk() ? members : null;
    }

    protected boolean hasPresetMember(@NotNull IMemberVO memberVO) {
        if (this.presetMembers == null) {
            this.presetMembers = this.getPresetMember(this.getDimNumber());
        }
        return this.presetMembers.contains(memberVO.getNumber());
    }

    protected Set<String> getPresetMember(String dimensionNumber) {
        Set<String> _presetMembers;
        switch (dimensionNumber) {
            case "Entity": {
                _presetMembers = this.getEntityMember();
                break;
            }
            case "Account": {
                _presetMembers = this.getAccountMember();
                break;
            }
            case "InternalCompany": {
                _presetMembers = this.getICMember();
                break;
            }
            case "Metric": {
                _presetMembers = this.getMetricMember();
                break;
            }
            default: {
                _presetMembers = this.getUserDefinedMember();
            }
        }
        return _presetMembers;
    }

    protected Set<String> getEntityMember() {
        HashSet<String> _presetMembers = new HashSet<String>();
        _presetMembers.add("Entity");
        this.addViewRootMember(_presetMembers);
        return _presetMembers;
    }

    protected Set<String> getAccountMember() {
        HashSet<String> _presetMembers = new HashSet<String>();
        _presetMembers.add("Account");
        return _presetMembers;
    }

    protected Set<String> getICMember() {
        HashSet<String> _presetMembers = new HashSet<String>();
        _presetMembers.add("InternalCompany");
        _presetMembers.add("ICTotal");
        _presetMembers.add("ICEntity");
        _presetMembers.add("ICOEntity");
        _presetMembers.add("ICNone");
        this.addViewRootMember(_presetMembers);
        return _presetMembers;
    }

    protected Set<String> getMetricMember() {
        HashSet<String> _presetMembers = new HashSet<String>();
        _presetMembers.add("Metric");
        _presetMembers.add("Money");
        _presetMembers.add("Amount");
        _presetMembers.add("UnitPrice\t");
        return _presetMembers;
    }

    protected Set<String> getUserDefinedMember() {
        HashSet<String> _presetMembers = new HashSet<String>();
        _presetMembers.add(this.getDimNumber());
        _presetMembers.add(this.getModelCache().getDimension(this.getDimNumber()).getNoneNumber());
        this.addViewRootMember(_presetMembers);
        return _presetMembers;
    }

    protected void addViewRootMember(Set<String> presetMembers) {
        Member rootMember;
        if (IDUtils.isNotNull((Long)this.getViewId()) && (rootMember = this.getModelCache().getRootMember(this.getDimNumber(), this.getViewId())) != null) {
            presetMembers.add(rootMember.getNumber());
        }
    }

    protected List<IMemberVO> verifyMembers(List<IMemberVO> members, ValidResult<String> workValid) {
        ValidResult<String> _tmpValids;
        if (members == null || members.isEmpty()) {
            return Collections.emptyList();
        }
        int index = 0;
        ArrayList filter = Lists.newArrayListWithExpectedSize((int)members.size());
        for (IMemberVO memberVO : members) {
            this.syncCurrentMemberData((MemberExcelVO)memberVO);
            IMemberVO member = this.beforeValid((MemberExcelVO)memberVO);
            if (member == null) continue;
            filter.add(member);
            _tmpValids = this.getValidator().valid(member);
            if (_tmpValids.isOk()) continue;
            workValid.setOk(_tmpValids.isOk());
            workValid.getValidResultMap().put(String.valueOf(index), _tmpValids.getErrMsg());
        }
        if (workValid.isOk()) {
            LinkedHashMap memberVOMap = Maps.newLinkedHashMapWithExpectedSize((int)filter.size());
            filter.forEach(m -> memberVOMap.put(m.getNumber(), m));
            _tmpValids = this.getValidator().batchValid(memberVOMap);
            if (!_tmpValids.isOk()) {
                workValid.setOk(_tmpValids.isOk());
                workValid.setErrMsg(_tmpValids.getErrMsg());
                workValid.getValidResultMap().putAll(_tmpValids.getValidResultMap());
            } else if (memberVOMap.size() != filter.size()) {
                filter.clear();
                filter.addAll(memberVOMap.values());
            }
        }
        return workValid.isOk() ? filter : Collections.emptyList();
    }

    protected boolean isOpenApi() {
        if (this.openApi == null) {
            this.openApi = this.getContext().getOperationSource() == MemberOperationSourceEnum.OPENAPI;
        }
        return this.openApi;
    }

    protected void syncCurrentMemberData(MemberExcelVO saveMember) {
        DimensionViewMember dbViewMember;
        DimensionViewMember dbMember = this.getValidator().getDbDimMemberMap().get(saveMember.getNumber());
        if (dbMember != null) {
            saveMember.setId(dbMember.getMemberId());
            saveMember.setMemberId(dbMember.getMemberId());
            saveMember.setSeq(dbMember.getDseq());
            saveMember.setLevel(dbMember.getLevel());
            saveMember.setLongNumber(dbMember.getLongNumber());
            if (this.isOpenApi()) {
                if (StringUtils.isEmpty((String)saveMember.getParentNumber())) {
                    saveMember.setParentNumber(dbMember.getParentNumber());
                }
                if (CollectionUtils.isNotEmpty((Map)dbMember.getPropValues())) {
                    for (Map.Entry entry : dbMember.getPropValues().entrySet()) {
                        if (saveMember.getPropValues() != null && saveMember.getPropValues().containsKey(entry.getKey())) continue;
                        saveMember.addPropValue((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                if (saveMember instanceof AccountMemberExcelVO && CollectionUtils.isNotEmpty((Collection)dbMember.getMetrics())) {
                    AccountMemberExcelVO _account = (AccountMemberExcelVO)saveMember;
                    for (String _metric : dbMember.getMetrics()) {
                        if (_account.getMetrics().contains(_metric)) continue;
                        _account.addMetric(_metric);
                    }
                }
            }
        }
        if (this.getContext().hasView() && (dbViewMember = this.getValidator().getDbViewMemberMap().get(saveMember.getNumber())) != null) {
            saveMember.setViewMemberId(dbViewMember.getViewMemberId());
            saveMember.setViewSeq(dbViewMember.getDseq());
            saveMember.setViewLevel(dbViewMember.getLevel());
            saveMember.setViewLongNumber(dbViewMember.getLongNumber());
            if (this.isOpenApi()) {
                if (StringUtils.isEmpty((String)saveMember.getLocaleName())) {
                    saveMember.setName(dbViewMember.getName());
                }
                if (StringUtils.isEmpty((String)saveMember.getLocaleSimpleName())) {
                    saveMember.setSimpleName(dbViewMember.getSimpleName());
                }
                if (StringUtils.isEmpty((String)saveMember.getAggoprt())) {
                    saveMember.setAggoprt(dbViewMember.getAggoprt());
                }
                if (StringUtils.isEmpty((String)saveMember.getDescription())) {
                    saveMember.setDescription(dbViewMember.getDescription());
                }
            }
        }
    }

    protected IMemberVO beforeValid(MemberExcelVO member) {
        if (this.getContext().getOperationType() == MemberOperEnum.ADD && (this.getContext().hasView() ? IDUtils.isNotNull((Long)member.getViewMemberId()) : IDUtils.isNotNull((Long)member.getId()))) {
            return null;
        }
        return member;
    }

    public void save(List<IMemberVO> members) {
        MemberExcelVO excelVO;
        if (members == null || members.isEmpty()) {
            return;
        }
        MemberVoUtils voUtils = this.getContext().getVoUtils();
        LinkedHashMap saveMembers = Maps.newLinkedHashMap();
        LinkedHashMap addNewMembers = Maps.newLinkedHashMap();
        LinkedHashMap saveViewMembers = Maps.newLinkedHashMap();
        LinkedHashMap addNewViewMembers = Maps.newLinkedHashMap();
        LinkedList upParentMembers = Lists.newLinkedList();
        LinkedList upParentViewMembers = Lists.newLinkedList();
        LinkedHashSet oldUpParentIds = Sets.newLinkedHashSet();
        LinkedHashSet oldViewUpParentIds = Sets.newLinkedHashSet();
        for (IMemberVO _member : members) {
            excelVO = (MemberExcelVO)_member;
            if (excelVO.isUpdateParent()) {
                oldUpParentIds.add(excelVO.getOldParentId());
                upParentMembers.add(excelVO);
            }
            if (!this.getContext().hasView() || !excelVO.isUpdateParentView()) continue;
            oldViewUpParentIds.add(excelVO.getOldViewParentId());
            upParentViewMembers.add(excelVO);
        }
        Map<Object, DynamicObject> updateObjects = this.getUpdateObject(members, voUtils);
        Map updateViewObjects = this.getContext().hasView() ? this.getUpdateViewObject(members, voUtils) : Collections.emptyMap();
        DynamicObject[] upChildrenMap = this.queryUpParentAllObject(upParentMembers);
        DynamicObject[] upViewChildrenMap = this.getContext().hasView() ? this.queryUpParentViewAllObject(upParentViewMembers) : new DynamicObject[]{};
        for (IMemberVO _member : members) {
            DynamicObject vObject;
            excelVO = (MemberExcelVO)_member;
            DynamicObject object = voUtils.toMemberObject(excelVO, updateObjects);
            if (object != null) {
                this.getSaveMemberNumbers().add(excelVO.getNumber());
                if (excelVO.isUpdate()) {
                    saveMembers.put(object.getLong("id"), object);
                } else {
                    addNewMembers.put(object.getLong("id"), object);
                }
            }
            if (!this.getContext().hasView() || (vObject = voUtils.toViewMemberObject(excelVO, updateViewObjects)) == null) continue;
            this.getSaveMemberNumbers().add(excelVO.getNumber());
            if (excelVO.isUpdateView()) {
                saveViewMembers.put(vObject.getLong("id"), vObject);
                continue;
            }
            addNewViewMembers.put(vObject.getLong("id"), vObject);
        }
        upParentMembers.sort(Comparator.comparing(MemberVO::getOldLevel));
        this.syncChildObjectData(upParentMembers, upChildrenMap, saveMembers, addNewMembers, voUtils, false);
        upParentViewMembers.sort(Comparator.comparing(MemberExcelVO::getOldViewLevel));
        this.syncChildObjectData(upParentViewMembers, upViewChildrenMap, saveViewMembers, addNewViewMembers, voUtils, true);
        try (TXHandle tx = TX.requiresNew((String)"importMemberSave");){
            try {
                DynamicObjectUtils.save((List)CollectionUtils.asList(addNewMembers.values()));
                DynamicObjectUtils.save((List)CollectionUtils.asList(saveMembers.values()));
                DynamicObjectUtils.update(this.filterObject(upChildrenMap, saveMembers.keySet()));
                BgDimensionServiceHelper.updateIsLeafByParentId((Long[])this.getParentIds(addNewMembers.values(), saveMembers.values(), oldUpParentIds), (Long)this.getModelId(), (Long)this.getContext().getDimensionId(), (String)this.getContext().getMemberModel());
                this.updateDisableState(this.getModelId(), this.getContext().getDimensionId(), null, members, this.getDisableValid());
                if (this.getContext().hasView()) {
                    DynamicObjectUtils.save((List)CollectionUtils.asList(addNewViewMembers.values()));
                    DynamicObjectUtils.save((List)CollectionUtils.asList(saveViewMembers.values()));
                    DynamicObjectUtils.update(this.filterObject(upViewChildrenMap, saveViewMembers.keySet()));
                    Long[] parentIds = this.getParentIds(addNewViewMembers.values(), saveViewMembers.values(), oldViewUpParentIds);
                    BgDimensionServiceHelper.updateIsLeafByParentId((Long[])parentIds, (Long)this.getModelId(), (Long)this.getContext().getDimensionId(), (String)"eb_viewmember");
                    this.updateDisableState(this.getModelId(), this.getContext().getDimensionId(), this.getViewId(), members, this.getDisableValid());
                    Set<Long> modViewMemberIds = addNewViewMembers.values().stream().map(e -> e.getLong("memberid")).collect(Collectors.toSet());
                    modViewMemberIds.addAll(saveViewMembers.values().stream().map(e -> e.getLong("memberid")).collect(Collectors.toSet()));
                    ViewMemberManager.getInstance().syncViewMember(this.getModelId(), this.getDimNumber(), this.getViewId(), modViewMemberIds);
                }
            }
            catch (Throwable ex) {
                log.error("MemberExcelImportHandler-error:", ex);
                tx.markRollback();
                throw new KDBizException(ex.getMessage());
            }
        }
    }

    public ValidResult<String> getDisableValid() {
        return this.disableValid;
    }

    protected Map<Object, DynamicObject> getUpdateObject(List<IMemberVO> members, MemberVoUtils voUtils) {
        if (members == null || members.isEmpty()) {
            return Collections.emptyMap();
        }
        Set memberIds = members.stream().filter(m -> ((MemberExcelVO)((Object)m)).isUpdate()).map(IMemberVO::getId).collect(Collectors.toSet());
        if (memberIds.isEmpty()) {
            return Collections.emptyMap();
        }
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)this.getContext().getModel().getId());
        builder.add("dimension", "=", (Object)this.getContext().getDimensionId());
        builder.add("id", "in", memberIds);
        DynamicObject[] object = BusinessDataServiceHelper.load((String)this.getContext().getMemberModel(), (String)voUtils.getFields(), (QFilter[])builder.toArray());
        return Stream.of(object).collect(Collectors.toMap(o -> o.getLong("id"), o -> o));
    }

    protected Map<Object, DynamicObject> getUpdateViewObject(List<IMemberVO> members, MemberVoUtils voUtils) {
        if (members == null || members.isEmpty()) {
            return Collections.emptyMap();
        }
        Set memberIds = members.stream().filter(m -> ((MemberExcelVO)((Object)m)).isUpdateView()).map(m -> ((MemberExcelVO)((Object)m)).getViewMemberId()).collect(Collectors.toSet());
        if (memberIds.isEmpty()) {
            return Collections.emptyMap();
        }
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)this.getContext().getModel().getId());
        builder.add("dimension", "=", (Object)this.getContext().getDimensionId());
        builder.add("view", "=", (Object)this.getContext().getViewId());
        builder.add("id", "in", memberIds);
        DynamicObject[] object = BusinessDataServiceHelper.load((String)"eb_viewmember", (String)voUtils.getViewFields(), (QFilter[])builder.toArray());
        return Stream.of(object).collect(Collectors.toMap(o -> o.getLong("id"), o -> o));
    }

    protected DynamicObject[] queryUpParentAllObject(List<MemberExcelVO> members) {
        if (members == null || members.isEmpty()) {
            return new DynamicObject[0];
        }
        Set memberNumbers = members.stream().map(MemberVO::getNumber).collect(Collectors.toSet());
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)this.getModelId());
        builder.add("dimension", "=", (Object)this.getContext().getDimensionId());
        builder.add("number", "in", memberNumbers);
        DynamicObjectCollection objects = QueryServiceHelper.query((String)this.getContext().getMemberModel(), (String)"id,longnumber", (QFilter[])builder.toArray(), null);
        Set longNumbers = objects.stream().map(m -> m.getString("longnumber")).collect(Collectors.toSet());
        return MemberServiceHelper.queryAllChildrenByLongNumber((Long)this.getModelId(), (Long)this.getContext().getDimensionId(), new ArrayList(longNumbers), (String)"id,number,longnumber,level,parent", (String)this.getContext().getMemberModel());
    }

    protected DynamicObject[] queryUpParentViewAllObject(List<MemberExcelVO> members) {
        if (members == null || members.isEmpty()) {
            return new DynamicObject[0];
        }
        Set memberNumbers = members.stream().map(MemberVO::getNumber).collect(Collectors.toSet());
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)this.getModelId());
        builder.add("dimension", "=", (Object)this.getContext().getDimensionId());
        builder.add("view", "=", (Object)this.getContext().getViewId());
        builder.add("number", "in", memberNumbers);
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"eb_viewmember", (String)"id,longnumber,parent.number", (QFilter[])builder.toArray(), null);
        Set longNumbers = objects.stream().map(m -> m.getString("longnumber")).collect(Collectors.toSet());
        return MemberServiceHelper.queryViewAllChildrenByLongNumber((Long)this.getModelId(), (Long)this.getContext().getDimensionId(), (Long)this.getViewId(), new ArrayList(longNumbers), (String)"id,number,longnumber,level,parent");
    }

    protected void buildChildrenMap(Collection<DynamicObject> objects, Map<Long, Map<Long, DynamicObject>> childrenMap) {
        for (DynamicObject object : objects) {
            Map tmpMap;
            Object parent = object.get("parent");
            if (parent instanceof Long) {
                tmpMap = childrenMap.computeIfAbsent((Long)parent, f -> Maps.newLinkedHashMap());
                tmpMap.put(object.getLong("id"), object);
                continue;
            }
            if (!(parent instanceof DynamicObject)) continue;
            tmpMap = childrenMap.computeIfAbsent(((DynamicObject)parent).getLong("id"), f -> Maps.newLinkedHashMap());
            tmpMap.put(object.getLong("id"), object);
        }
    }

    protected void syncChildObjectData(List<MemberExcelVO> upParentMembers, DynamicObject[] childrenMap, Map<Long, DynamicObject> upObject, Map<Long, DynamicObject> newObject, MemberVoUtils utils, boolean hasView) {
        if (upParentMembers.isEmpty()) {
            return;
        }
        LinkedHashMap allChildrenMap = Maps.newLinkedHashMap();
        this.buildChildrenMap(upObject.values(), allChildrenMap);
        this.buildChildrenMap(newObject.values(), allChildrenMap);
        Map<Long, DynamicObject> _dbChildrenMap = Stream.of(childrenMap).collect(Collectors.toMap(m -> m.getLong("id"), m -> m));
        upObject.keySet().forEach(_dbChildrenMap::remove);
        this.buildChildrenMap(_dbChildrenMap.values(), allChildrenMap);
        List<MemberExcelVO> roots = this.getRootByMembers(upParentMembers, childrenMap);
        LinkedHashSet buildData = Sets.newLinkedHashSet();
        for (MemberExcelVO excelVO : roots) {
            Map children = (Map)allChildrenMap.get(utils.getId(excelVO, hasView));
            if (children == null || children.isEmpty()) continue;
            for (DynamicObject _child : children.values()) {
                if (!buildData.add(_child.getString("number"))) continue;
                _child.set("longnumber", (Object)((hasView ? excelVO.getViewLongNumber() : excelVO.getLongNumber()) + '!' + _child.getString("number")));
                _child.set("level", (Object)((hasView ? excelVO.getViewLevel() : excelVO.getLevel()) + 1));
                this.syncChildObjectData(_child, allChildrenMap, buildData);
            }
        }
    }

    protected List<MemberExcelVO> getRootByMembers(List<MemberExcelVO> upParentMembers, DynamicObject[] childrenMap) {
        HashMap memberMap = Maps.newHashMapWithExpectedSize((int)(upParentMembers.size() + childrenMap.length));
        for (MemberExcelVO vo : upParentMembers) {
            memberMap.put(vo.getNumber(), vo);
        }
        for (DynamicObject child : childrenMap) {
            memberMap.put(child.getString("number"), child);
        }
        LinkedHashMap roots = Maps.newLinkedHashMap();
        LinkedHashSet parents = Sets.newLinkedHashSet();
        for (MemberExcelVO vo : upParentMembers) {
            this.getRootByMembers((Object)vo, memberMap, roots, parents);
        }
        return new ArrayList<MemberExcelVO>(roots.values());
    }

    protected void getRootByMembers(Object current, Map<String, Object> memberMap, Map<String, MemberExcelVO> roots, Set<String> numbers) {
        if (current == null) {
            return;
        }
        String currentNumber = null;
        if (current instanceof MemberExcelVO) {
            currentNumber = ((MemberExcelVO)((Object)current)).getNumber();
        } else if (current instanceof DynamicObject) {
            currentNumber = ((DynamicObject)current).getString("number");
        }
        if (!numbers.add(currentNumber)) {
            return;
        }
        Object parent = null;
        if (current instanceof MemberExcelVO) {
            parent = memberMap.get(((MemberExcelVO)((Object)current)).getParentNumber());
        } else if (current instanceof DynamicObject) {
            parent = memberMap.get(((DynamicObject)current).getString("parent.number"));
        }
        if (parent == null && current instanceof MemberExcelVO) {
            MemberExcelVO _current = (MemberExcelVO)((Object)current);
            if (!roots.containsKey(_current.getNumber())) {
                roots.put(_current.getNumber(), _current);
            }
        } else {
            this.getRootByMembers(parent, memberMap, roots, numbers);
        }
    }

    protected void syncChildObjectData(DynamicObject current, Map<Long, Map<Long, DynamicObject>> allChildrenMap, Set<String> buildData) {
        if (current == null) {
            return;
        }
        Map<Long, DynamicObject> children = allChildrenMap.get(current.getLong("id"));
        if (children != null && !children.isEmpty()) {
            for (DynamicObject _child : children.values()) {
                if (!buildData.add(_child.getString("number"))) continue;
                _child.set("longnumber", (Object)(current.getString("longnumber") + '!' + _child.getString("number")));
                _child.set("level", (Object)(current.getInt("level") + 1));
                this.syncChildObjectData(_child, allChildrenMap, buildData);
            }
        }
    }

    protected List<DynamicObject> filterObject(DynamicObject[] objects, Set<Long> updateIds) {
        if (objects == null || objects.length == 0) {
            return Collections.emptyList();
        }
        return Stream.of(objects).filter(m -> !updateIds.contains(m.getLong("id"))).collect(Collectors.toList());
    }

    protected Long[] getParentIds(Collection<DynamicObject> newMembers, Collection<DynamicObject> upMembers, Set<Long> upParentIds) {
        LinkedHashSet memberIds = Sets.newLinkedHashSet();
        if (newMembers != null && !newMembers.isEmpty()) {
            memberIds.addAll(newMembers.stream().map(m -> m.getLong("parent")).collect(Collectors.toSet()));
        }
        if (upMembers != null && !upMembers.isEmpty()) {
            memberIds.addAll(upMembers.stream().map(m -> m.getLong("parent")).collect(Collectors.toSet()));
        }
        if (upParentIds != null) {
            memberIds.addAll(upParentIds);
        }
        return memberIds.toArray(new Long[0]);
    }

    protected void updateDisableState(Long modelId, Long dimensionId, Long viewId, List<IMemberVO> members, ValidResult<String> valid) {
        if (members == null || members.isEmpty()) {
            return;
        }
        boolean hasView = IDUtils.isNotNull((Long)viewId);
        if (View.NoViewDimNums.contains(this.getDimNumber()) && hasView) {
            return;
        }
        if (!View.NoViewDimNums.contains(this.getDimNumber()) && !hasView) {
            return;
        }
        Comparator comparator = (o1, o2) -> {
            int size2;
            int size1 = org.apache.commons.lang3.StringUtils.countMatches((CharSequence)o1, (char)'!');
            if (size1 == (size2 = org.apache.commons.lang3.StringUtils.countMatches((CharSequence)o2, (char)'!'))) {
                return o1.compareTo((String)o2);
            }
            return size1 - size2;
        };
        TreeMap<String, IMemberVO> disableMap = new TreeMap<String, IMemberVO>(comparator);
        for (IMemberVO _member : members) {
            if (!StringUtils.isNotEmpty((String)_member.getDisable())) continue;
            disableMap.put(_member.getLongNumber(), _member);
        }
        if (!disableMap.isEmpty()) {
            long userId = this.getContext().getUserId();
            Date date = new Date();
            for (Map.Entry entry : disableMap.entrySet()) {
                SqlBuilder sql;
                MemberExcelVO memberVO = (MemberExcelVO)((Object)entry.getValue());
                if (StringUtils.equals((String)"0", (String)memberVO.getDisable())) {
                    sql = new SqlBuilder();
                    if (hasView) {
                        sql.append("select fid, fdisable from t_eb_viewmember where fid in (", new Object[0]);
                        sql.append("select fparentid from t_eb_viewmember where fmodelid = ?", new Object[]{modelId});
                        sql.append(" and fviewid = ? and fdimensionid = ? and fmemberid = ?)", new Object[]{viewId, dimensionId, memberVO.getMemberId()});
                    } else {
                        sql.append("select fid, fdisable from ", new Object[0]).append(this.getContext().getMemberTable(), new Object[0]).append(" where fid in (", new Object[0]);
                        sql.append("select fparentid from ", new Object[0]).append(this.getContext().getMemberTable(), new Object[0]).append(" where fmodelid = ?", new Object[]{modelId});
                        sql.append(" and fdimensionid = ? and fid = ?)", new Object[]{dimensionId, memberVO.getMemberId()});
                    }
                    if (StringUtils.equals((String)"1", (String)this.queryMemberDisableState(sql))) {
                        valid.addValidResult(memberVO.getRowIndex(), (Object)ResManager.loadKDString((String)"\u4e0a\u7ea7\u6210\u5458\u662f\u7981\u7528\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u542f\u7528\u64cd\u4f5c\u3002", (String)"MemberUpdateImpl_1", (String)"epm-eb-mservice", (Object[])new Object[0]));
                        continue;
                    }
                }
                sql = new SqlBuilder();
                if (hasView) {
                    sql.append("update t_eb_viewmember set fdisable = ? where fmodelid = ? and fviewid = ? and fdimensionid = ? and (fmemberid = ? or flongnumber like ?)", new Object[]{memberVO.getDisable(), modelId, viewId, dimensionId, memberVO.getMemberId(), memberVO.getViewLongNumber() + "!%"});
                    this.execute(sql);
                    Set groupViewIds = ViewGroupManager.getInstance().getViewsByViewId(viewId.longValue());
                    for (Long _viewId : groupViewIds) {
                        if (Objects.equals(viewId, _viewId)) continue;
                        QFBuilder builder = new QFBuilder();
                        builder.add("model", "=", (Object)modelId);
                        builder.add("view", "=", (Object)_viewId);
                        builder.add("dimension", "=", (Object)dimensionId);
                        builder.add("memberid", "=", (Object)memberVO.getMemberId());
                        DynamicObject _viewMember = QueryServiceHelper.queryOne((String)"eb_viewmember", (String)"id, longnumber", (QFilter[])builder.toArray());
                        if (_viewMember == null) continue;
                        sql.append("update t_eb_viewmember set fdisable = ? where fmodelid = ? and fviewid = ? and fdimensionid = ? and (fmemberid = ? or flongnumber like ?)", new Object[]{memberVO.getDisable(), modelId, _viewId, dimensionId, memberVO.getMemberId(), _viewMember.getString("longnumber") + "!%"});
                        this.execute(sql);
                    }
                } else {
                    sql.append("update " + this.getContext().getMemberTable() + " set fdisable = ?, fdisablerid = ?, fdisabledate = ? where fmodelid = ? and fdimensionid = ? and (fid = ? or flongnumber like ?)", new Object[]{memberVO.getDisable(), userId, date, modelId, dimensionId, memberVO.getMemberId(), memberVO.getLongNumber() + "!%"});
                    this.execute(sql);
                }
                this.getDisableMemberNumbers().add(memberVO.getNumber());
            }
            if (hasView) {
                CacheServiceHelper.clearEntityCache((String)"eb_viewmember");
            } else {
                CacheServiceHelper.clearEntityCache((String)this.getContext().getMemberModel());
            }
        }
    }

    protected void execute(@NotNull SqlBuilder sql) {
        DB.execute((DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
    }

    protected String queryMemberDisableState(@NotNull SqlBuilder sql) {
        String _status = null;
        try (DataSet ds = DB.queryDataSet((String)"queryParentDisableState", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null && ds.hasNext()) {
                kd.bos.algo.Row row = ds.next();
                _status = row.getString("fdisable");
            }
        }
        return _status;
    }
}

