/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.service.view.valid;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.olap.service.view.bean.DimensionViewMember;
import kd.epm.eb.olap.service.view.bean.vo.IMemberVO;
import kd.epm.eb.olap.service.view.bean.vo.MemberExcelVO;
import kd.epm.eb.olap.service.view.valid.CommMemberValidator;
import kd.epm.eb.olap.service.view.valid.MemberValidator;
import kd.epm.eb.olap.service.view.valid.ValidResult;

public class MemberBaseExcelImportValidator
extends CommMemberValidator {
    private final Set<String> memberNums = Sets.newLinkedHashSet();
    private final Set<String> memberShowNums = Sets.newLinkedHashSet();

    public MemberBaseExcelImportValidator(IModelCacheHelper modelCache, String dimNumber, Long viewId) {
        super(modelCache, dimNumber, viewId);
    }

    public static MemberValidator getValidator(IModelCacheHelper modelCache, String dimNumber, Long viewId) {
        return new MemberBaseExcelImportValidator(modelCache, dimNumber, viewId);
    }

    protected Set<String> getMemberNums() {
        return this.memberNums;
    }

    protected Set<String> getMemberShowNums() {
        return this.memberShowNums;
    }

    public void validNumber(IMemberVO saveMember) {
        super.validNumber(saveMember);
        if (!this.getMemberNums().add(saveMember.getNumber())) {
            String errorTag = ResManager.loadKDString((String)"\u8be5\u5185\u7801\u5728\u5bfc\u5165\u6587\u4ef6\u4e2d\u5b58\u5728\u91cd\u590d\u3002", (String)"DimMemImportBasePlugin_9_1", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            throw new KDBizException(errorTag);
        }
        if (this.hasExistShowNumber(saveMember)) {
            String errorTag = ResManager.loadKDString((String)"\u8be5\u7f16\u7801\u5728\u5bfc\u5165\u6587\u4ef6\u4e2d\u5b58\u5728\u91cd\u590d\u3002", (String)"DimMemImportBasePlugin_9", (String)"epm-eb-formplugin", (Object[])new Object[0]);
            throw new KDBizException(errorTag);
        }
        DimensionViewMember dbMember = (DimensionViewMember)this.getDbDimMemberMap().get(saveMember.getNumber());
        if (dbMember != null && dbMember.getLevel() == 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5bfc\u5165\u7ef4\u5ea6\u6839\u6210\u5458\u3002", (String)"MemberBaseExcelImportValidator_0", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
    }

    protected boolean hasExistShowNumber(IMemberVO saveMember) {
        if (StringUtils.isEmpty((String)saveMember.getShowNumber())) {
            return !this.getMemberShowNums().add(saveMember.getNumber());
        }
        return !this.getMemberShowNums().add(saveMember.getShowNumber());
    }

    public ValidResult<String> batchValid(Map<String, IMemberVO> members) {
        ValidResult valid = super.batchValid(members);
        if (valid.isOk()) {
            if (!this.getModelCache().getModelobj().isModelByEB()) {
                LinkedHashMap showNumMap = Maps.newLinkedHashMap();
                for (Map.Entry entry : this.getDbViewShowNumber().entrySet()) {
                    showNumMap.put(entry.getKey(), CollectionUtils.asSet((Object[])new String[]{(String)entry.getValue()}));
                }
                for (IMemberVO member : members.values()) {
                    Set numSet = showNumMap.computeIfAbsent(member.getShowNumber(), f -> Sets.newHashSetWithExpectedSize((int)2));
                    numSet.add(member.getNumber());
                    if (numSet.size() <= 1) continue;
                    valid.addValidResult(((MemberExcelVO)member).getRowIndex(), (Object)ResManager.loadKDString((String)"\u8be5\u7f16\u7801\u5b58\u5728\u91cd\u590d\u3002", (String)"DimMemImportBasePlugin_9_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
            if (valid.isOk() && this.hasVerifyName()) {
                boolean hasView = IDUtils.isNotNull((Long)this.getViewId());
                HashSet names = Sets.newHashSetWithExpectedSize((int)members.size());
                for (IMemberVO member : members.values()) {
                    if (!names.add(member.getLocaleName())) {
                        valid.addValidResult(((MemberExcelVO)member).getRowIndex(), (Object)ResManager.loadKDString((String)"\u8be5\u540d\u79f0\u5728\u5bfc\u5165\u6587\u4ef6\u4e2d\u91cd\u590d\u5b58\u5728\u3002", (String)"DimMemImportBasePlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                    }
                    if (!IDUtils.isNull((Long)this.getMemberId(hasView, (MemberExcelVO)member)) || !this.getDbViewNameSet().contains(member.getLocaleName())) continue;
                    valid.addValidResult(((MemberExcelVO)member).getRowIndex(), (Object)ResManager.loadKDString((String)"\u8be5\u540d\u79f0\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\u3002", (String)"DimMemImportBasePlugin_13", (String)"epm-eb-formplugin", (Object[])new Object[0]));
                }
            }
        }
        return valid;
    }

    protected Long getMemberId(boolean hasView, MemberExcelVO member) {
        return hasView ? member.getViewMemberId() : member.getMemberId();
    }

    protected boolean equals(DimensionViewMember dbDimMember, IMemberVO saveMember) {
        return super.equals(dbDimMember, saveMember);
    }

    protected boolean equalsByView(DimensionViewMember dbDimMember, IMemberVO saveMember) {
        MemberExcelVO excelVO = (MemberExcelVO)saveMember;
        return dbDimMember.getViewMemberId().equals(excelVO.getViewMemberId());
    }
}

