/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.dataSources.DimensionFilterItem;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.olapdao.BgmdShrekDao;
import kd.epm.eb.common.shrek.service.ShrekExecuteServiceHelper;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.MapUtils;
import kd.epm.eb.olap.entity.DimPage;
import kd.epm.eb.olap.impl.bizrule.entity.FormulaMemberDto;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.impl.bizrule.entity.RuleRightItemDto;
import kd.epm.eb.olap.service.AlgoCalcUtils;
import kd.epm.eb.olap.service.request.QueryRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class PageUtil {
    private static final Log log = LogFactory.getLog(PageUtil.class);

    public static List<QueryRequest> getSelectCommandInfoPage(SelectCommandInfo sci, int orgPageSize) {
        long st = System.currentTimeMillis();
        log.info("\u5f00\u59cb\u5206\u9875");
        Map<String, List<List<String>>> dimPageMap = PageUtil.getTotalPageMapExcludeBp(sci, orgPageSize);
        ArrayList<QueryRequest> result = new ArrayList<QueryRequest>(16);
        ArrayList<List<List<String>>> allMembers = new ArrayList<List<List<String>>>(dimPageMap.size());
        ArrayList<String> dimensions = new ArrayList<String>(dimPageMap.keySet());
        for (String dimNumber : dimensions) {
            allMembers.add(dimPageMap.get(dimNumber));
        }
        CommonServiceHelper.buildDescartes(allMembers, memberPage -> {
            QueryRequest request = new QueryRequest();
            HashMap<String, Set<String>> memberInfo = new HashMap<String, Set<String>>(dimensions.size());
            for (int dimIndex = 0; dimIndex < dimensions.size(); ++dimIndex) {
                memberInfo.put((String)dimensions.get(dimIndex), new HashSet((Collection)memberPage.get(dimIndex)));
            }
            request.setMemberInfo(memberInfo);
            result.add(request);
            return false;
        });
        log.info("\u5206\u9875\u6570\uff1a" + result.size() + ",\u5206\u9875\u8017\u65f6:" + (System.currentTimeMillis() - st));
        return result;
    }

    public static Iterator<Map<String, Set<String>>> getPageMapExcludeBpIterator(Map<String, Set<String>> memberScope, int pageSize) {
        Map<String, List<List<String>>> dimPageMap = PageUtil.getPageMap(memberScope, pageSize, null, 0);
        List<List<DimPage>> list = PageUtil.getDimPage(dimPageMap);
        return new PageIterator(list);
    }

    public static Iterator<Map<String, Set<String>>> getPageMapExcludeBpIterator(Map<String, Set<String>> memberScope, int pageSize, List<String> noPageDims, int noPageDataSize) {
        Map<String, List<List<String>>> dimPageMap = PageUtil.getPageMap(memberScope, pageSize, noPageDims, noPageDataSize);
        List<List<DimPage>> list = PageUtil.getDimPage(dimPageMap);
        return new PageIterator(list);
    }

    public static List<Map<String, Set<String>>> getPageByOrg(Map<String, Set<String>> memberScope, int orgPageSize) {
        Set<String> entitySet = memberScope.get(SysDimensionEnum.Entity.getNumber());
        List partition = Lists.partition(new ArrayList<String>(entitySet), (int)orgPageSize);
        ArrayList orgPages = Lists.newArrayListWithExpectedSize((int)orgPageSize);
        for (List sugOrg : partition) {
            HashMap<String, Set<String>> sub = new HashMap<String, Set<String>>(memberScope);
            sub.put(SysDimensionEnum.Entity.getNumber(), new HashSet(sugOrg));
            orgPages.add(sub);
        }
        return orgPages;
    }

    public static List<Map<String, Set<String>>> getPageMapExcludeBp(Map<String, Set<String>> memberScope, int pageSize) {
        long st = System.currentTimeMillis();
        log.info("\u5f00\u59cb\u5206\u9875");
        Map<String, List<List<String>>> dimPageMap = PageUtil.getPageMap(memberScope, pageSize, null, 0);
        List<Map<String, Set<String>>> pageList = PageUtil.getSubMap(dimPageMap);
        log.info("\u5206\u9875\u6570\uff1a" + pageList.size() + ",\u5206\u9875\u8017\u65f6:" + (System.currentTimeMillis() - st));
        return pageList;
    }

    private static List<Map<String, Set<String>>> getSubMap(Map<String, List<List<String>>> dimPageMap) {
        List<List<DimPage>> resultList = PageUtil.getDimPage(dimPageMap);
        ArrayList sciList = Lists.newArrayListWithExpectedSize((int)20);
        for (List<DimPage> dimPages : resultList) {
            HashMap scopeMap = Maps.newHashMapWithExpectedSize((int)16);
            for (DimPage dimPage : dimPages) {
                scopeMap.put(dimPage.getDimNumber(), new HashSet(dimPage.getMembers()));
            }
            sciList.add(scopeMap);
        }
        return sciList;
    }

    private static List<List<DimPage>> getDimPage(Map<String, List<List<String>>> dimPageMap) {
        ArrayList list = new ArrayList(dimPageMap.size());
        for (Map.Entry<String, List<List<String>>> entry : dimPageMap.entrySet()) {
            String dimNumber = entry.getKey();
            List<List<String>> pageList = entry.getValue();
            ArrayList<DimPage> dimPageList = new ArrayList<DimPage>(pageList.size());
            for (List<String> page : pageList) {
                DimPage dimPage = new DimPage(dimNumber, page);
                dimPageList.add(dimPage);
            }
            list.add(dimPageList);
        }
        return Lists.cartesianProduct(list);
    }

    public static Map<String, List<List<String>>> getTotalPageMapExcludeBp(SelectCommandInfo queryInfo, int orgPageSize) {
        ConcurrentHashMap<String, List<List<String>>> dimPageMap = new ConcurrentHashMap<String, List<List<String>>>(64);
        for (DimensionFilterItem item : queryInfo.getFilter()) {
            String dimNumber = item.getName();
            List members = item.getValues();
            if (SysDimensionEnum.Entity.getNumber().equals(dimNumber)) {
                List memberPageList = Lists.partition((List)members, (int)orgPageSize);
                dimPageMap.put(dimNumber, memberPageList);
                continue;
            }
            ArrayList memberList = Lists.newArrayListWithExpectedSize((int)1);
            memberList.add(members);
            dimPageMap.put(dimNumber, memberList);
        }
        return dimPageMap;
    }

    public static Triple<Map<String, Set<String>>, List<String>, List<String[]>> getOlapRelationPage(Map<String, Set<String>> rawRange, RuleDto ruleDto, IModelCacheHelper modelCache, int exePartition) {
        Object relMap;
        ArrayList rangeList = Lists.newArrayListWithExpectedSize((int)rawRange.size());
        rawRange.forEach((dimNumber, leftR) -> rangeList.add(Pair.of((Object)dimNumber, (Object)leftR)));
        rangeList.sort((o1, o2) -> Integer.compare(((Set)o2.getValue()).size(), ((Set)o1.getValue()).size()));
        Long ruleDataSetId = ruleDto.getDataSetId();
        String ruleMet = (String)((Set)ruleDto.getLeftMembers().get(SysDimensionEnum.Metric.getNumber())).iterator().next();
        Member ruleMetMember = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, ruleMet);
        ArrayList relDims = Lists.newArrayListWithExpectedSize((int)5);
        List ruleRightItemDto = ruleDto.getRuleRightItemDto();
        if (CollectionUtils.isEmpty((Collection)ruleRightItemDto)) {
            log.warn("\u65e0\u53f3\u5f0f\uff0c\u76f4\u63a5\u8df3\u8fc7\u6210\u5458\u5173\u7cfb\u4f18\u5316");
            return Triple.of(rawRange, new ArrayList(0), null);
        }
        block0: for (Pair dimRange : rangeList) {
            String dimNumber2 = (String)dimRange.getLeft();
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber2) || ((Set)dimRange.getRight()).size() < 2) continue;
            for (RuleRightItemDto rightItemDto : ruleRightItemDto) {
                Map dimensionMap;
                Map<String, Set<String>> refMemberMap = rightItemDto.getRefMemberMap();
                if (refMemberMap.containsKey(dimNumber2)) continue block0;
                Optional<FormulaMemberDto> accountOptional = rightItemDto.getFormulaMemberList().stream().filter(item -> SysDimensionEnum.Account.getNumber().equals(item.getDimNumber())).findFirst();
                if (!accountOptional.isPresent()) continue;
                FormulaMemberDto formulaMemberDto = accountOptional.get();
                Member accountMember = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, formulaMemberDto.getNumber());
                Long currentDataSetId = accountMember.getDatasetId();
                if (ruleDataSetId.equals(currentDataSetId) || (dimensionMap = modelCache.getDimensionMap(currentDataSetId)).containsKey(dimNumber2)) continue;
                continue block0;
            }
            relDims.add(dimNumber2);
        }
        if (relDims.size() < 2) {
            log.warn("\u6210\u5458\u5173\u7cfb\u7ef4\u5ea6\u5c11\u4e8e2\u4e2a\uff0c\u4e0d\u505a\u6210\u5458\u5173\u7cfb\u4f18\u5316");
            if (relDims.size() == 1) {
                log.warn("\u6210\u5458\u5173\u7cfb\u7ef4\u5ea6\u53ea\u67091\u4e2a\uff0c\u5355\u7ef4\u5ea6\u4f18\u5316");
                HashSet<String> dimSet = new HashSet<String>(rawRange.keySet());
                dimSet.remove(relDims.get(0));
                Map optMap = ShrekExecuteServiceHelper.analyzeRange((Model)modelCache.getModelobj(), (Dataset)modelCache.getDataSet(ruleDataSetId), new HashSet<String>(dimSet), rawRange);
                return Triple.of((Object)optMap, new ArrayList(0), null);
            }
            return Triple.of(rawRange, new ArrayList(0), null);
        }
        log.info("\u6210\u5458\u5173\u7cfb\u7ef4\u5ea6\u3010" + relDims + "\u3011");
        List leftDimensions = modelCache.getDimensionList(ruleDataSetId);
        Map leftExecuteMap = Maps.newHashMapWithExpectedSize((int)rawRange.size());
        List leftRelRowList = BgmdShrekDao.getInstance().distinct(modelCache.getModelobj(), AlgoCalcUtils.getCubeNumber(ruleDataSetId), (List)relDims, rawRange);
        if (!leftRelRowList.isEmpty()) {
            leftExecuteMap = ShrekExecuteServiceHelper.analyzeRange((Model)modelCache.getModelobj(), (Dataset)modelCache.getDataSet(ruleDataSetId), new HashSet(relDims), rawRange);
            relMap = MapUtils.relRowToMap((List)leftRelRowList, (List)relDims);
            MapUtils.mergeMap((Map)relMap, (Map)leftExecuteMap);
        }
        block2: for (RuleRightItemDto rightItemDto : ruleRightItemDto) {
            List itemRelRowList;
            Long itemDataSetId = ruleDataSetId;
            Set<String> itemAccSet = rightItemDto.getRefMemberMap().get(SysDimensionEnum.Account.getNumber());
            if (CollectionUtils.isNotEmpty(itemAccSet)) {
                Member accountMember = modelCache.getMember(SysDimensionEnum.Account.getNumber(), null, itemAccSet.iterator().next());
                itemDataSetId = accountMember.getDatasetId();
            }
            String itemMet = ruleMet;
            Set<String> itemMetSet = rightItemDto.getRefMemberMap().get(SysDimensionEnum.Metric.getNumber());
            if (CollectionUtils.isNotEmpty(itemMetSet)) {
                itemMet = itemMetSet.iterator().next();
            }
            Member itemMetMember = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, itemMet);
            List itemDimList = modelCache.getDimensionList(itemDataSetId);
            HashMap itemDistinctMap = Maps.newHashMapWithExpectedSize((int)itemDimList.size());
            for (Dimension itemDimension : itemDimList) {
                Member member;
                HashSet leafMembers;
                String dimNumber3 = itemDimension.getNumber();
                Set leftMemSet = (Set)ruleDto.getLeftMembers().get(dimNumber3);
                Set<String> itemMemSet = rightItemDto.getRefMemberMap().get(dimNumber3);
                if (CollectionUtils.isEmpty((Collection)leftMemSet) && itemMemSet == null) continue;
                Long viewId = ruleDto.getViewMap().getOrDefault(dimNumber3, 0L);
                if (itemMemSet != null) {
                    if (itemMemSet.isEmpty()) continue block2;
                    if (itemMetMember.hasAgg()) {
                        leafMembers = Sets.newHashSetWithExpectedSize((int)itemMemSet.size());
                        for (String rightRefMember : itemMemSet) {
                            member = modelCache.getMember(dimNumber3, viewId, rightRefMember);
                            if (member.isLeaf()) {
                                leafMembers.add(member.getNumber());
                                continue;
                            }
                            leafMembers.addAll(modelCache.getLeafOfNumbers(member));
                        }
                        itemDistinctMap.put(dimNumber3, leafMembers);
                        continue;
                    }
                    itemDistinctMap.put(dimNumber3, itemMemSet);
                    continue;
                }
                if (!ruleMetMember.hasAgg() && itemMetMember.hasAgg()) {
                    leafMembers = Sets.newHashSetWithExpectedSize((int)leftMemSet.size());
                    for (String leftMember : leftMemSet) {
                        member = modelCache.getMember(dimNumber3, viewId, leftMember);
                        if (member.isLeaf()) {
                            leafMembers.add(member.getNumber());
                            continue;
                        }
                        leafMembers.addAll(modelCache.getLeafOfNumbers(member));
                    }
                    itemDistinctMap.put(dimNumber3, leafMembers);
                    continue;
                }
                itemDistinctMap.put(dimNumber3, leftMemSet);
            }
            Integer itemOffset = (Integer)ruleDto.getOffsetMap().get(rightItemDto.getMemberKey());
            boolean itemHasOffSet = itemOffset != null && itemOffset != 0;
            ArrayList<String> itemSkipDims = new ArrayList<String>(relDims);
            if (itemHasOffSet) {
                itemSkipDims.add(SysDimensionEnum.BudgetPeriod.getNumber());
                Set leftBps = (Set)itemDistinctMap.get(SysDimensionEnum.BudgetPeriod.getNumber());
                if (CollectionUtils.isNotEmpty((Collection)leftBps)) {
                    HashSet realMembers = Sets.newHashSet();
                    for (String member : leftBps) {
                        Member offsetMember = modelCache.getMemberOffset(SysDimensionEnum.BudgetPeriod.getNumber(), member, itemOffset.intValue());
                        if (offsetMember == null) continue;
                        realMembers.add(offsetMember.getNumber());
                    }
                    itemDistinctMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), realMembers);
                }
            }
            if ((itemRelRowList = BgmdShrekDao.getInstance().distinct(modelCache.getModelobj(), AlgoCalcUtils.getCubeNumber(itemDataSetId), (List)relDims, (Map)itemDistinctMap)).isEmpty()) continue;
            leftRelRowList.addAll(itemRelRowList);
            Map itemMap = ShrekExecuteServiceHelper.analyzeRange((Model)modelCache.getModelobj(), (Dataset)modelCache.getDataSet(itemDataSetId), new HashSet(itemSkipDims), (Map)itemDistinctMap);
            Map itemRelMap = MapUtils.relRowToMap((List)itemRelRowList, (List)relDims);
            MapUtils.mergeMap((Map)itemRelMap, (Map)itemMap);
            HashMap returnBackLeftTrimRange = Maps.newHashMapWithExpectedSize((int)rawRange.size());
            for (Dimension leftDimension : leftDimensions) {
                String dimNumber4 = leftDimension.getNumber();
                Set rightRefMembers = (Set)itemMap.get(dimNumber4);
                if (itemHasOffSet && SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber4)) {
                    returnBackLeftTrimRange.put(dimNumber4, rawRange.get(dimNumber4));
                    continue;
                }
                if (rightRefMembers != null) {
                    returnBackLeftTrimRange.put(dimNumber4, rawRange.get(dimNumber4));
                    continue;
                }
                Set<String> value = (Set<String>)itemMap.get(dimNumber4);
                if (value == null) {
                    value = rawRange.get(dimNumber4);
                }
                if (value == null) {
                    throw new KDBizException("rule(" + ruleDto.getNumber() + ")'s dim(" + dimNumber4 + "is null ,please reedit this rule.");
                }
                returnBackLeftTrimRange.put(dimNumber4, value);
            }
            MapUtils.mergeMap((Map)returnBackLeftTrimRange, leftExecuteMap);
        }
        leftRelRowList = leftRelRowList.stream().collect(Collectors.collectingAndThen(Collectors.toMap(Arrays::toString, array -> array, (array1, array2) -> array1), map -> new ArrayList(map.values())));
        relMap = MapUtils.relRowToMap((List)leftRelRowList, (List)relDims);
        leftExecuteMap.putAll(relMap);
        leftRelRowList.add(0, relDims.stream().map(e -> modelCache.getDimension(e).getShortNumber()).toArray(String[]::new));
        log.info("\u6210\u5458\u5173\u7cfb\u7ef4\u5ea6\u3010" + relDims + "\u3011\uff0c\u6210\u5458\u5173\u7cfb\u6570\u91cf\uff1a" + leftRelRowList.size());
        return Triple.of(leftExecuteMap, (Object)relDims, (Object)leftRelRowList);
    }

    public static Map<String, List<List<String>>> getPageMap(Map<String, Set<String>> queryInfo, int pageSize, List<String> noPageDims, int noPageDataSize) {
        int currDescar = 1;
        ConcurrentHashMap<String, List<List<String>>> dimPageMap = new ConcurrentHashMap<String, List<List<String>>>(64);
        currDescar *= queryInfo.get(SysDimensionEnum.BudgetPeriod.getNumber()).size();
        if (CollectionUtils.isNotEmpty(noPageDims) && noPageDataSize > 0) {
            currDescar *= noPageDataSize;
        }
        for (Map.Entry<String, Set<String>> entry : queryInfo.entrySet()) {
            int partSign;
            List memberPageList;
            String dimNumber = entry.getKey();
            ArrayList members = new ArrayList(entry.getValue());
            if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNumber) || CollectionUtils.isNotEmpty(noPageDims) && noPageDims.contains(dimNumber)) {
                memberPageList = new ArrayList(1);
                memberPageList.add(members);
                dimPageMap.put(dimNumber, memberPageList);
                continue;
            }
            if (currDescar > pageSize) {
                memberPageList = Lists.partition(members, (int)1);
                dimPageMap.put(dimNumber, memberPageList);
                continue;
            }
            int tmp = Integer.MAX_VALUE / currDescar;
            List memberPageList2 = new ArrayList(16);
            if (tmp >= members.size()) {
                if ((currDescar *= members.size()) > pageSize) {
                    partSign = pageSize / (currDescar / members.size());
                    memberPageList2 = Lists.partition(members, (int)partSign);
                } else {
                    memberPageList2.add(members);
                }
            } else {
                partSign = pageSize / currDescar;
                memberPageList2 = Lists.partition(members, (int)partSign);
            }
            dimPageMap.put(dimNumber, memberPageList2);
        }
        return dimPageMap;
    }

    private static class PageIterator
    implements Iterator<Map<String, Set<String>>> {
        private Iterator<List<DimPage>> dataIterator;

        PageIterator(List<List<DimPage>> list) {
            log.info("PageIterator\u5206\u9875\u5927\u5c0f\uff1a" + list.size());
            this.dataIterator = list.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.dataIterator.hasNext();
        }

        @Override
        public Map<String, Set<String>> next() {
            List<DimPage> dimPages = this.dataIterator.next();
            HashMap pageMap = Maps.newHashMapWithExpectedSize((int)16);
            for (DimPage dimPage : dimPages) {
                pageMap.put(dimPage.getDimNumber(), new HashSet(dimPage.getMembers()));
            }
            return pageMap;
        }
    }
}

