/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap.utils;

import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.util.List;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import org.apache.commons.lang3.StringUtils;

public class RuleGraphUtils {
    public static MutableGraph<Long> buildDagGraph(List<RuleDto> ruleDtoList) {
        MutableGraph graph = GraphBuilder.directed().allowsSelfLoops(false).build();
        for (RuleDto ruleDto : ruleDtoList) {
            if (graph.nodes().contains(ruleDto.getId())) continue;
            graph.addNode((Object)ruleDto.getId());
        }
        for (RuleDto ruleDto : ruleDtoList) {
            String successors = ruleDto.getSuccessors();
            if (!StringUtils.isNotBlank((CharSequence)successors)) continue;
            for (String su : StringUtils.split((String)successors, (String)",")) {
                long nodeId = Long.parseLong(su);
                if (!graph.nodes().contains(nodeId) || ruleDto.getId().equals(nodeId)) continue;
                graph.putEdge((Object)ruleDto.getId(), (Object)nodeId);
            }
        }
        return graph;
    }
}

