/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.DimensionView;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.olap.common.CommandTypes;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.MemberMetadataItem;
import kd.bos.olap.dataSources.MetadataCommandInfo;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.metadata.MemberStorageTypes;
import kd.bos.olap.metadata.MetadataTypes;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.business.bizrule.RuleRelationService;
import kd.epm.eb.business.datalock.DataLockUpViewService;
import kd.epm.eb.business.dataperm.MemberPermUpViewService;
import kd.epm.eb.business.ebupgrades.utils.UpgradesTaskUtil;
import kd.epm.eb.common.bgmddatalock.v2.DataLockService;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dataset;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.cache.impl.ViewUpMember;
import kd.epm.eb.common.enums.DimensionViewGroupEnum;
import kd.epm.eb.common.enums.StorageTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.enums.dimensionEnums.ViewMemberSourceEnum;
import kd.epm.eb.common.olapdao.ConnectionManager;
import kd.epm.eb.common.olapdao.ShrekDataSource;
import kd.epm.eb.common.shrek.domain.ShrekConfig;
import kd.epm.eb.common.shrek.service.ShrekConfigServiceHelper;
import kd.epm.eb.common.shrek.service.ShrekServiceFactory;
import kd.epm.eb.common.shrek.util.ShrekIdCodeUtils;
import kd.epm.eb.common.shrek.util.ShrekOlapUtils;
import kd.epm.eb.common.shrek.util.ShrekParamUtils;
import kd.epm.eb.common.utils.CacheServiceHelper;
import kd.epm.eb.common.utils.CubeUtils;
import kd.epm.eb.common.utils.DataSourceUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.NumberCheckUtils;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.common.utils.base.LanguageUtils;
import kd.epm.eb.common.utils.cache.Cache;
import kd.epm.eb.olap.impl.bizrule.RuleService;
import kd.epm.eb.olap.service.view.bean.DimensionViewMember;
import kd.epm.eb.olap.service.view.bean.UpgradeDimensionViewMember;
import kd.epm.eb.olap.service.view.bean.UpgradeViewResult;
import org.apache.commons.collections4.CollectionUtils;

public class ViewMemberUpgradeService {
    public static final Log log = LogFactory.getLog(ViewMemberUpgradeService.class);
    public static final String VIEW_MEMBER_FIELD = "fid,fname,fnumber,fsimplename,fshownumber,fmodelid,fdimensionid,fmemberid,fviewid,faggoprt,flevel,fdseq,flongnumber,fisleaf,fmembersource,fparentid,fenable,fdisable,fmodifydate,fmodifier,fstatus,fshowchildren,fshowself,frefview,fisinnerorg,fisouterorg,fsyncstatus,fsyncdate,fmergernode,fisoffsetentry";
    public static final String VIEW_MEMBER_UPGRADE = "view_member_upgrade_";
    public static final String SUCCESS = "success";
    public static final String AUTO_UPDATE_MODEL_CACHE = "AUTO_UPDATE_MODEL_CACHE";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UpgradeViewResult upgradeOldModel(List<Long> modelIds) {
        List collect;
        ArrayList<Long> upgradeModelIds = new ArrayList<Long>(16);
        HashMap<Long, Model> modelMap = new HashMap<Long, Model>(16);
        UpgradeViewResult result = ViewMemberUpgradeService.queryModelById(modelIds, upgradeModelIds, modelMap);
        Set alreadyUpgradeSet = result.getAlreadyUpgradeModel().stream().map(BaseCache::getId).collect(Collectors.toSet());
        String format = ViewMemberUpgradeService.getTimeFormat();
        List successModel = result.getSuccessModel();
        List failModel = result.getFailModel();
        for (Long tempModelId : upgradeModelIds) {
            if (alreadyUpgradeSet.contains(tempModelId)) continue;
            Model model = (Model)modelMap.get(tempModelId);
            try (TXHandle tx = TX.required((String)"BgmdViewMemUpgradeServiceImpl");){
                try {
                    ViewMemberUpgradeService.upgradeOneOldModel(tempModelId, modelMap, format);
                    successModel.add(model);
                }
                catch (Exception e) {
                    failModel.add(model);
                    tx.markRollback();
                    log.error("view_member_upgrade_failModel:" + model.getNumber() + "_error:", (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"LanguageDimUpgradeService", (String)"beforeExecuteSqlWithResult", (Object[])new Object[]{String.valueOf(tempModelId), null, null, null});
                throw throwable;
            }
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"LanguageDimUpgradeService", (String)"beforeExecuteSqlWithResult", (Object[])new Object[]{String.valueOf(tempModelId), null, null, null});
            try {
                ViewMemberUpgradeService.updateModelCache(model);
                ViewMemberUpgradeService.clearDataEntityCache();
                RuleRelationService.getInstance().updateOldData(tempModelId, false);
                RuleService.getInstance().deleteRuleFromCacheByModel(tempModelId);
            }
            catch (Exception tx) {}
        }
        List alreadyUpgradeModel = result.getAlreadyUpgradeModel();
        StringBuilder stringBuilder = new StringBuilder();
        if (CollectionUtils.isNotEmpty((Collection)alreadyUpgradeModel)) {
            collect = alreadyUpgradeModel.stream().map(BaseCache::getNumber).collect(Collectors.toList());
            stringBuilder.append("alreadyUpgradeModel:").append(StringUtils.join(collect, (String)",")).append(";");
        }
        if (CollectionUtils.isNotEmpty((Collection)successModel)) {
            collect = successModel.stream().map(BaseCache::getNumber).collect(Collectors.toList());
            stringBuilder.append("successModel:").append(StringUtils.join(collect, (String)",")).append(";");
        }
        if (CollectionUtils.isNotEmpty((Collection)failModel)) {
            collect = failModel.stream().map(BaseCache::getNumber).collect(Collectors.toList());
            String failModelStr = StringUtils.join(collect, (String)",");
            stringBuilder.append("failModel:").append(failModelStr).append(";");
            String traceId = RequestContext.get().getTraceId();
            result.setErrorMessage(failModelStr + ";traceId:" + traceId);
        }
        log.info(VIEW_MEMBER_UPGRADE + stringBuilder);
        result.setMessage(stringBuilder.toString());
        return result;
    }

    private static void upgradeOneOldModel(Long modelId, Map<Long, Model> modelMap, String format) {
        Object[] modelIdArray = Collections.singletonList(modelId).toArray();
        ViewMemberUpgradeService.checkBussModelHasViewDimNotSelView(modelIdArray);
        Model model = modelMap.get(modelId);
        boolean isEb = "4".equals(model.getReportType());
        if (!isEb) {
            try {
                ViewMemberUpgradeService.backupHistoryData(modelId, format);
            }
            catch (Exception e) {
                log.error("backupHistoryData_error:", (Throwable)e);
            }
        }
        ViewMemberUpgradeService.updateShowNumberByModelIdArray(modelIdArray);
        if (isEb) {
            SqlBuilder sqlBuilderDelEbDimView = new SqlBuilder();
            sqlBuilderDelEbDimView.append("delete from t_eb_dimensionview where fmodelid = ?", new Object[]{modelId});
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilderDelEbDimView);
            return;
        }
        SqlBuilder sqlBuilderDelPresetViewMem = new SqlBuilder();
        sqlBuilderDelPresetViewMem.append("delete from t_eb_viewmember where fmodelid = ? and fviewid in (select fid from t_eb_dimensionview where fmodelid = ? and fsource = '1')", new Object[]{modelId, modelId});
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilderDelPresetViewMem);
        SqlBuilder sqlBuilderDelDimViewGroupMem = new SqlBuilder();
        sqlBuilderDelDimViewGroupMem.append("delete from t_eb_dimensionview_group where fmodelid = ?", new Object[]{modelId});
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilderDelDimViewGroupMem);
        HashMap<Long, Long> ctDimensionMapByModel = new HashMap<Long, Long>(16);
        Map<Long, Map<Long, kd.epm.eb.common.model.Dimension>> dimensionMapByModel = ViewMemberUpgradeService.getDimensionMapByModel(modelIdArray, ctDimensionMapByModel);
        HashMap<Long, Map<Long, Long>> dimensionRootByModel = new HashMap<Long, Map<Long, Long>>(16);
        ViewMemberUpgradeService.delCtDimViewMember(dimensionMapByModel);
        ViewMemberUpgradeService.delOtherLevelOneDimMember(dimensionMapByModel, dimensionRootByModel);
        ViewMemberUpgradeService.delRedundantRootViewMember(dimensionMapByModel);
        ViewMemberUpgradeService.updateRootViewMemberNumber(dimensionMapByModel, dimensionRootByModel);
        HashMap<Long, Map<Long, Map<String, Object>>> dimViewMapByBaseView = new HashMap<Long, Map<Long, Map<String, Object>>>(16);
        HashMap<Long, Map<Long, Long>> dimPresetViewByModelMap = new HashMap<Long, Map<Long, Long>>(16);
        HashMap<Long, Map<Long, List<Long>>> dimViewsByModelMap = new HashMap<Long, Map<Long, List<Long>>>(16);
        HashMap<Long, Map<Long, List<Map<String, Object>>>> dimPresetBaseViewsByModelMap = new HashMap<Long, Map<Long, List<Map<String, Object>>>>(16);
        Map<Long, List<Long>> baseAnalViewMap = ViewMemberUpgradeService.getBaseAnalViewsMap(modelIdArray, dimensionMapByModel, dimViewMapByBaseView, dimPresetViewByModelMap, dimViewsByModelMap, dimPresetBaseViewsByModelMap);
        Map<Long, List<Long>> presetBaseViewsMap = ViewMemberUpgradeService.getPresetBaseViewsMap(dimPresetBaseViewsByModelMap);
        HashMap<Long, Long> viewGroupMap = new HashMap<Long, Long>(16);
        ViewMemberUpgradeService.insertDimensionViewGroup(dimViewMapByBaseView, viewGroupMap, dimensionMapByModel);
        Map<Long, Map<Long, Long>> bizModelRefDimView = ViewMemberUpgradeService.insertBusinessModelViewGroup(modelIdArray, viewGroupMap);
        ArrayList<Object[]> updateViewEntryList = new ArrayList<Object[]>(16);
        ctDimensionMapByModel.forEach((tempModel, ctDim) -> {
            Map dimViewMap = (Map)dimPresetViewByModelMap.get(tempModel);
            Long baseView = (Long)dimViewMap.get(ctDim);
            Object[] updateViewEntry = new Object[]{viewGroupMap.get(baseView), ctDim};
            updateViewEntryList.add(updateViewEntry);
        });
        ViewMemberUpgradeService.viewEntryUpdateRowsByDimId("t_eb_viewentry", updateViewEntryList);
        HashMap<Long, Long> ctDimViewGroupMap = new HashMap<Long, Long>(16);
        Object[] ctDimArray = ctDimensionMapByModel.values().toArray();
        ViewMemberUpgradeService.delCtDimNotPresetViewGroup(ctDimViewGroupMap, ctDimArray);
        ViewMemberUpgradeService.resetCtDimViewGroup(ctDimViewGroupMap, ctDimArray);
        ViewMemberUpgradeService.insertPresetViewMember(modelIdArray, dimPresetViewByModelMap);
        Map<Long, Map<Long, List<UpgradeDimensionViewMember>>> ctViewMembersMapByModel = ViewMemberUpgradeService.getCtMemberMapByModel(modelIdArray);
        ViewMemberUpgradeService.insertCtViewMembers(ctDimensionMapByModel, dimViewsByModelMap, ctViewMembersMapByModel, presetBaseViewsMap);
        Map<Long, List<UpgradeDimensionViewMember>> dimViewMemberMapByViewId = ViewMemberUpgradeService.getDimensionViewMemberMap(modelIdArray);
        HashMap<Long, Map<Long, UpgradeDimensionViewMember>> allViewMemIdDimViewMemberMapByViewId = new HashMap<Long, Map<Long, UpgradeDimensionViewMember>>(16);
        HashMap<Long, Map<Long, UpgradeDimensionViewMember>> allMemIdDimViewMemberMapByViewId = new HashMap<Long, Map<Long, UpgradeDimensionViewMember>>(16);
        for (Map.Entry<Long, List<UpgradeDimensionViewMember>> entry : dimViewMemberMapByViewId.entrySet()) {
            Long viewId = entry.getKey();
            Map allViewMemIdDimViewMemberMap = allViewMemIdDimViewMemberMapByViewId.computeIfAbsent(viewId, k -> Maps.newLinkedHashMapWithExpectedSize((int)16));
            Map allMemIdDimViewMemberMap = allMemIdDimViewMemberMapByViewId.computeIfAbsent(viewId, k -> Maps.newLinkedHashMapWithExpectedSize((int)16));
            ViewMemberUpgradeService.buildDimViewMemberTree(entry.getValue(), allViewMemIdDimViewMemberMap, allMemIdDimViewMemberMap);
        }
        HashMap<String, UpgradeDimensionViewMember> addMemberMapByNumber = new HashMap<String, UpgradeDimensionViewMember>(16);
        HashMap<Long, Set<Long>> changeIsLeafMap = new HashMap<Long, Set<Long>>(16);
        ViewMemberUpgradeService.upgradeAnalViewMember(dimViewMapByBaseView, baseAnalViewMap, allViewMemIdDimViewMemberMapByViewId, allMemIdDimViewMemberMapByViewId, addMemberMapByNumber, changeIsLeafMap);
        ViewMemberUpgradeService.insertViewNotLeafMember(dimensionMapByModel, addMemberMapByNumber);
        ViewMemberUpgradeService.updateBaseViewMemberSource(dimViewMapByBaseView, allViewMemIdDimViewMemberMapByViewId, dimensionMapByModel);
        ViewMemberUpgradeService.updateAnalViewMemberSource(dimViewMapByBaseView, baseAnalViewMap, allViewMemIdDimViewMemberMapByViewId, dimensionMapByModel);
        HashSet<Long> queryDatasetSet = new HashSet<Long>(16);
        Map<Long, List<Dataset>> datasetMapByModel = ViewMemberUpgradeService.getDatasetMapByModel(modelIdArray, queryDatasetSet);
        ViewMemberUpgradeService.handleDatasetDims(queryDatasetSet, datasetMapByModel);
        ViewMemberUpgradeService.handleDatasetViews(datasetMapByModel);
        HashMap<Long, List<Member>> alreadyViewMemberMapByView = new HashMap<Long, List<Member>>(16);
        HashMap<Long, Integer> maxLevelMapByViewId = new HashMap<Long, Integer>(16);
        HashMap<Long, Member> alreadyViewMemberMapByViewMemId = new HashMap<Long, Member>(16);
        ViewMemberUpgradeService.getAllViewMemberByModel(modelIdArray, alreadyViewMemberMapByView, maxLevelMapByViewId, alreadyViewMemberMapByViewMemId);
        ViewMemberUpgradeService.updateViewMemberLongNumber(alreadyViewMemberMapByView, maxLevelMapByViewId, dimPresetViewByModelMap);
        ViewMemberUpgradeService.updateViewMemberChangeIsLeaf(changeIsLeafMap, alreadyViewMemberMapByView);
        Long ctDimPresetViewId = ViewMemberUpgradeService.getCtDimPresetViewId(modelId, dimensionMapByModel, dimPresetViewByModelMap);
        ViewMemberUpgradeService.updateViewMemberRefView(modelIdArray, baseAnalViewMap, presetBaseViewsMap, ctDimPresetViewId);
        HashMap<Long, List<Member>> alreadyViewMemberHasChildMapByView = new HashMap<Long, List<Member>>(16);
        for (Map.Entry entry : alreadyViewMemberMapByView.entrySet()) {
            alreadyViewMemberHasChildMapByView.put((Long)entry.getKey(), ViewMemberUpgradeService.buildViewMemberTree((List)entry.getValue()));
        }
        ViewMemberUpgradeService.updateAnalLeaf(modelIdArray);
        ViewMemberUpgradeService.handleViewMemberLang(modelIdArray);
        MemberPermUpViewService.update(dimPresetBaseViewsByModelMap, dimensionMapByModel, alreadyViewMemberHasChildMapByView, bizModelRefDimView, dimPresetViewByModelMap, modelId);
        DataLockUpViewService.update(dimViewMapByBaseView, dimensionMapByModel, (Long)modelId);
        ViewMemberUpgradeService.handleOlapSync(modelMap, dimensionMapByModel, datasetMapByModel, alreadyViewMemberMapByViewMemId, alreadyViewMemberHasChildMapByView);
    }

    private static void delRedundantRootViewMember(Map<Long, Map<Long, kd.epm.eb.common.model.Dimension>> dimensionMapByModel) {
        if (dimensionMapByModel == null) {
            return;
        }
        HashMap<Long, Map> viewRootViewMemberMapByModel = new HashMap<Long, Map>(16);
        Set<Long> modelIdSet = dimensionMapByModel.keySet();
        SqlBuilder sqlBuilderRootViewMember = new SqlBuilder();
        sqlBuilderRootViewMember.append("select ", new Object[0]).append("fid,fnumber,fmodelid,fdimensionid,fviewid", new Object[0]);
        sqlBuilderRootViewMember.append(" from t_eb_viewmember where", new Object[0]).appendIn("fmodelid", modelIdSet.toArray()).append("and flevel = ?", new Object[]{1});
        DataSet rowsRootViewMember = ViewMemberUpgradeService.queryDatasetBySql(sqlBuilderRootViewMember, "queryRootViewMember");
        if (rowsRootViewMember != null && !rowsRootViewMember.isEmpty()) {
            while (rowsRootViewMember.hasNext()) {
                Row row = rowsRootViewMember.next();
                Long id = row.getLong("fid");
                Long l = row.getLong("fmodelid");
                Long dimId = row.getLong("fdimensionid");
                Long viewId = row.getLong("fviewid");
                String number = row.getString("fnumber");
                Map viewRootViewMemberMap = viewRootViewMemberMapByModel.computeIfAbsent(l, k -> new HashMap(16));
                Set rootViewMemSet = viewRootViewMemberMap.computeIfAbsent(viewId, k -> new HashSet(16));
                UpgradeDimensionViewMember rootViewMem = new UpgradeDimensionViewMember();
                rootViewMem.setViewMemberId(id);
                rootViewMem.setNumber(number);
                rootViewMem.setModel(l);
                rootViewMem.setDimension(dimId);
                rootViewMem.setView(viewId);
                rootViewMemSet.add(rootViewMem);
            }
        }
        HashSet<Long> delIdSet = new HashSet<Long>(16);
        for (Map.Entry entry : viewRootViewMemberMapByModel.entrySet()) {
            Long modelId = (Long)entry.getKey();
            Map<Long, kd.epm.eb.common.model.Dimension> dimensionMap = dimensionMapByModel.get(modelId);
            Map viewRootMemberMap = (Map)entry.getValue();
            for (Map.Entry setEntry : viewRootMemberMap.entrySet()) {
                Set _rootViewMemSet = (Set)setEntry.getValue();
                if (_rootViewMemSet.size() == 1) continue;
                kd.epm.eb.common.model.Dimension dimension = dimensionMap.get(((UpgradeDimensionViewMember)_rootViewMemSet.iterator().next()).getDimension());
                if (dimension == null) {
                    delIdSet.addAll(_rootViewMemSet.stream().map(DimensionViewMember::getViewMemberId).collect(Collectors.toSet()));
                    continue;
                }
                for (UpgradeDimensionViewMember upgradeDimensionViewMember : _rootViewMemSet) {
                    if (!upgradeDimensionViewMember.getNumber().equals(dimension.getNumber())) continue;
                    delIdSet.add(upgradeDimensionViewMember.getViewMemberId());
                }
            }
        }
        if (CollectionUtils.isNotEmpty(delIdSet)) {
            SqlBuilder sqlBuilderDelOtherRootViewMem = new SqlBuilder();
            sqlBuilderDelOtherRootViewMem.append("delete from t_eb_viewmember where", new Object[0]).appendIn("fid", delIdSet.toArray());
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilderDelOtherRootViewMem);
        }
    }

    private static void handleViewMemberLang(Object[] modelIdArray) {
        DataSet rowsMemberLang;
        HashSet tableSet = Sets.newHashSet((Object[])new String[]{"t_eb_structofent", "t_eb_structofchangetype", "t_eb_structoficentity", "t_eb_structofdefined"});
        HashMap<Long, Map> dimRootNameLangMap = new HashMap<Long, Map>(16);
        HashMap<Long, Map> dimRootSimpleNameLangMap = new HashMap<Long, Map>(16);
        HashMap<Long, Map> nameLangMap = new HashMap<Long, Map>(16);
        HashMap<Long, Map> simpleNameLangMap = new HashMap<Long, Map>(16);
        for (String table : tableSet) {
            String langTable = table + "_l";
            SqlBuilder sqlBuilderMemberLang = new SqlBuilder();
            sqlBuilderMemberLang.append("select ", new Object[0]).append("a.fid as fid,a.fdimensionid as fdimensionid,a.flevel as flevel,b.fname as fname,b.fsimplename as fsimplename,b.flocaleid as flocaleid", new Object[0]);
            sqlBuilderMemberLang.append(" from ", new Object[0]).append(table, new Object[0]).append(" a left join ", new Object[0]).append(langTable, new Object[0]).append(" b on b.fid = a.fid and b.flocaleid in ('zh_CN','zh_TW','en_US') where ", new Object[0]).appendIn("a.fmodelid", modelIdArray);
            rowsMemberLang = ViewMemberUpgradeService.queryDatasetBySql(sqlBuilderMemberLang, "queryMemberLang");
            if (rowsMemberLang == null || rowsMemberLang.isEmpty()) continue;
            while (rowsMemberLang.hasNext()) {
                String simpleName;
                Row row = rowsMemberLang.next();
                Long id = row.getLong("fid");
                String localeId = row.getString("flocaleid");
                String name = row.getString("fname");
                Integer level = row.getInteger("flevel");
                Long dimId = row.getLong("fdimensionid");
                if (StringUtils.isNotEmpty((String)name)) {
                    Map nameMap = nameLangMap.computeIfAbsent(id, k -> new HashMap(16));
                    nameMap.put(localeId, name);
                    if (level == 1) {
                        Map dimRootNameMap = dimRootNameLangMap.computeIfAbsent(dimId, k -> new HashMap(16));
                        dimRootNameMap.put(localeId, name);
                    }
                }
                if (!StringUtils.isNotEmpty((String)(simpleName = row.getString("fsimplename")))) continue;
                Map simpleNameMap = simpleNameLangMap.computeIfAbsent(id, k -> new HashMap(16));
                simpleNameMap.put(localeId, simpleName);
                if (level != 1) continue;
                Map dimRootSimpleNameMap = dimRootSimpleNameLangMap.computeIfAbsent(dimId, k -> new HashMap(16));
                dimRootSimpleNameMap.put(localeId, simpleName);
            }
        }
        SqlBuilder sqlBuilderViewMemberLang = new SqlBuilder();
        sqlBuilderViewMemberLang.append("select ", new Object[0]).append("b.fid as fid,b.flocaleid as flocaleid", new Object[0]);
        sqlBuilderViewMemberLang.append(" from ", new Object[0]).append("t_eb_viewmember a left join t_eb_viewmember_l", new Object[0]).append(" b on b.fid = a.fid where ", new Object[0]).appendIn("a.fmodelid", modelIdArray);
        DataSet rowsViewMemberLang = ViewMemberUpgradeService.queryDatasetBySql(sqlBuilderViewMemberLang, "queryAllViewMemberLang");
        HashSet<String> existSet = new HashSet<String>(16);
        if (rowsViewMemberLang != null && !rowsViewMemberLang.isEmpty()) {
            while (rowsViewMemberLang.hasNext()) {
                Row row = rowsViewMemberLang.next();
                Long id = row.getLong("fid");
                String localeId = row.getString("flocaleid");
                existSet.add(id + "_" + localeId);
            }
        }
        SqlBuilder sqlBuilderAllViewMember = new SqlBuilder();
        sqlBuilderAllViewMember.append("select ", new Object[0]).append("fid,fmemberid,flevel,fdimensionid", new Object[0]).append(" from ", new Object[0]).append("t_eb_viewmember where", new Object[0]).appendIn("fmodelid", modelIdArray);
        rowsMemberLang = ViewMemberUpgradeService.queryDatasetBySql(sqlBuilderAllViewMember, "queryAllViewMember");
        HashSet localeIdSet = Sets.newHashSet((Object[])new String[]{"zh_CN", "en_US", "zh_TW"});
        ArrayList<Object[]> insertViewMemberLangList = new ArrayList<Object[]>(16);
        if (rowsMemberLang != null && !rowsMemberLang.isEmpty()) {
            while (rowsMemberLang.hasNext()) {
                Row row = rowsMemberLang.next();
                Long id = row.getLong("fid");
                Long memId = row.getLong("fmemberid");
                Integer level = row.getInteger("flevel");
                Long dimId = row.getLong("fdimensionid");
                for (String localeId : localeIdSet) {
                    Object[] insertViewMemberLang;
                    String[] idLa;
                    if (existSet.contains(id + "_" + localeId)) continue;
                    String name = "";
                    String simpleName = "";
                    if (nameLangMap.containsKey(memId)) {
                        name = ((Map)nameLangMap.get(memId)).getOrDefault(localeId, "");
                    }
                    if (simpleNameLangMap.containsKey(memId)) {
                        simpleName = ((Map)simpleNameLangMap.get(memId)).getOrDefault(localeId, "");
                    }
                    if (StringUtils.isNotEmpty((String)name) || StringUtils.isNotEmpty((String)simpleName)) {
                        idLa = DBServiceHelper.genStringIds((String)"t_eb_viewmember_l", (int)1);
                        insertViewMemberLang = new Object[]{idLa[0], id, localeId, name, simpleName};
                        insertViewMemberLangList.add(insertViewMemberLang);
                        continue;
                    }
                    if (level != 1) continue;
                    if (dimRootNameLangMap.containsKey(dimId)) {
                        name = ((Map)dimRootNameLangMap.get(dimId)).getOrDefault(localeId, "");
                    }
                    if (dimRootSimpleNameLangMap.containsKey(dimId)) {
                        simpleName = ((Map)dimRootSimpleNameLangMap.get(dimId)).getOrDefault(localeId, "");
                    }
                    if (!StringUtils.isNotEmpty((String)name) && !StringUtils.isNotEmpty((String)simpleName)) continue;
                    idLa = DBServiceHelper.genStringIds((String)"t_eb_viewmember_l", (int)1);
                    insertViewMemberLang = new Object[]{idLa[0], id, localeId, name, simpleName};
                    insertViewMemberLangList.add(insertViewMemberLang);
                }
            }
        }
        ViewMemberUpgradeService.insertRows("fpkid,fid,flocaleid,fname,fsimplename", "t_eb_viewmember_l", insertViewMemberLangList);
    }

    private static void updateAnalLeaf(Object[] modelIdArray) {
        SqlBuilder sqlBuilderViewMember = new SqlBuilder();
        sqlBuilderViewMember.append("select fid from t_eb_viewmember where", new Object[0]);
        sqlBuilderViewMember.appendIn("fmodelid", modelIdArray);
        sqlBuilderViewMember.append("and flevel = ? and fmembersource = ?", new Object[]{2, "1"});
        DataSet rowsViewMember = ViewMemberUpgradeService.queryDatasetBySql(sqlBuilderViewMember, "queryLevel2ViewMem");
        HashSet<Long> viewMemberIdSet = new HashSet<Long>(16);
        if (rowsViewMember != null && !rowsViewMember.isEmpty()) {
            while (rowsViewMember.hasNext()) {
                Row row = rowsViewMember.next();
                Long id = row.getLong("fid");
                viewMemberIdSet.add(id);
            }
        }
        if (viewMemberIdSet.isEmpty()) {
            return;
        }
        SqlBuilder sqlBuilderViewMember2 = new SqlBuilder();
        sqlBuilderViewMember2.append("select fid,fparentid from t_eb_viewmember where", new Object[0]);
        sqlBuilderViewMember2.appendIn("fmodelid", modelIdArray);
        sqlBuilderViewMember2.append("and", new Object[0]);
        sqlBuilderViewMember2.appendIn("fparentid", viewMemberIdSet.toArray());
        DataSet rowsViewMember2 = ViewMemberUpgradeService.queryDatasetBySql(sqlBuilderViewMember2, "queryByParentViewMem");
        HashSet<Long> hasChildViewMemSet = new HashSet<Long>(16);
        if (rowsViewMember2 != null && !rowsViewMember2.isEmpty()) {
            while (rowsViewMember2.hasNext()) {
                Row row = rowsViewMember2.next();
                Long parentId = row.getLong("fparentid");
                hasChildViewMemSet.add(parentId);
            }
        }
        ArrayList<Object[]> viewMemberAnalLeafUpdateParams = new ArrayList<Object[]>(16);
        for (Long id : viewMemberIdSet) {
            if (hasChildViewMemSet.contains(id)) {
                viewMemberAnalLeafUpdateParams.add(new Object[]{"0", "1", "1", id});
                continue;
            }
            viewMemberAnalLeafUpdateParams.add(new Object[]{"1", "0", "1", id});
        }
        ViewMemberUpgradeService.viewMemberAnalLeafUpdateRows("t_eb_viewmember", viewMemberAnalLeafUpdateParams);
    }

    private static Long getCtDimPresetViewId(Long modelId, Map<Long, Map<Long, kd.epm.eb.common.model.Dimension>> dimensionMapByModel, Map<Long, Map<Long, Long>> dimPresetViewByModelMap) {
        Long ctDimId = 0L;
        Map<Long, kd.epm.eb.common.model.Dimension> dimensionMap = dimensionMapByModel.get(modelId);
        for (Map.Entry<Long, kd.epm.eb.common.model.Dimension> entry : dimensionMap.entrySet()) {
            if (!entry.getValue().getNumber().equals(SysDimensionEnum.ChangeType.getNumber())) continue;
            ctDimId = entry.getKey();
            break;
        }
        Map<Long, Long> presetViewMap = dimPresetViewByModelMap.get(modelId);
        Long ctDimPresetViewId = presetViewMap.getOrDefault(ctDimId, 0L);
        return ctDimPresetViewId;
    }

    private static void delCtDimViewMember(Map<Long, Map<Long, kd.epm.eb.common.model.Dimension>> dimensionMapByModel) {
        if (dimensionMapByModel == null) {
            return;
        }
        dimensionMapByModel.forEach((tempModelId, dimensionMap) -> {
            for (kd.epm.eb.common.model.Dimension dimension : dimensionMap.values()) {
                if (!dimension.getNumber().equals(SysDimensionEnum.ChangeType.getNumber())) continue;
                ViewMemberUpgradeService.executeDelCtDimViewMember(tempModelId, dimension);
            }
        });
    }

    private static void executeDelCtDimViewMember(Long tempModelId, kd.epm.eb.common.model.Dimension dimension) {
        SqlBuilder sqlBuilderDelCtMem = new SqlBuilder();
        sqlBuilderDelCtMem.append("delete from t_eb_viewmember where fmodelid = ? and fdimensionid = ?", new Object[]{tempModelId, dimension.getId()});
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilderDelCtMem);
    }

    private static void checkBussModelHasViewDimNotSelView(Object[] modelIdArray) {
        SqlBuilder sqlBuilderBussModelViewEntry = new SqlBuilder();
        sqlBuilderBussModelViewEntry.append("select a.fnumber bussnumber, c.fviewid viewid, b.fnumber dimnumber from t_eb_businessmodel a left join t_eb_viewentry c on c.fid=a.fid left join t_eb_dimension b on b.fid=c.fdimensionid where", new Object[0]);
        sqlBuilderBussModelViewEntry.appendIn("a.fmodelid", modelIdArray);
        DataSet rows = ViewMemberUpgradeService.queryDatasetBySql(sqlBuilderBussModelViewEntry, "queryBusinessView");
        HashMap<String, Set> notViewBussModelMap = new HashMap<String, Set>(16);
        if (rows != null && !rows.isEmpty()) {
            while (rows.hasNext()) {
                Row row = rows.next();
                String bussNumber = row.getString("bussnumber");
                String dimNumber = row.getString("dimnumber");
                Long view = row.getLong("viewid");
                if (View.NoViewDimNums.contains(dimNumber) || SysDimensionEnum.ChangeType.getNumber().equals(dimNumber) || !IDUtils.isEmptyLong((Long)view).booleanValue()) continue;
                Set notViewDim = notViewBussModelMap.computeIfAbsent(bussNumber, k -> Sets.newHashSetWithExpectedSize((int)16));
                notViewDim.add(dimNumber);
            }
        }
        if (!notViewBussModelMap.isEmpty()) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u5b58\u5728\u4e1a\u52a1\u6a21\u578b\u6709\u89c6\u56fe\u7684\u7ef4\u5ea6\u6ca1\u6709\u8bbe\u7f6e\u89c6\u56fe\uff0c\u8bf7\u68c0\u67e5\u3002\u4e1a\u52a1\u6a21\u578b\u53ca\u5bf9\u5e94\u7ef4\u5ea6\u8be6\u60c5\uff1a%1", (String)"ViewMemberUpgradeService_7", (String)"epm-eb-business", (Object[])new Object[]{JsonUtils.getJsonString(notViewBussModelMap)}));
        }
    }

    private static void delOtherLevelOneDimMember(Map<Long, Map<Long, kd.epm.eb.common.model.Dimension>> dimensionMapByModel, Map<Long, Map<Long, Long>> dimensionRootByModel) {
        if (dimensionMapByModel == null) {
            return;
        }
        dimensionMapByModel.forEach((tempModelId, dimensionMap) -> {
            for (kd.epm.eb.common.model.Dimension dimension : dimensionMap.values()) {
                String memberTable = dimension.getMemberTable();
                String memberTableL = memberTable + "_l";
                SqlBuilder sqlBuilderMember = new SqlBuilder();
                sqlBuilderMember.append("select fid,fnumber from", new Object[0]).append(memberTable, new Object[0]).append("where fmodelid = ? and fdimensionid = ? and flevel = 1", new Object[]{tempModelId, dimension.getId()});
                DataSet rowsMember = ViewMemberUpgradeService.queryDatasetBySql(sqlBuilderMember, "queryLevel1Mem");
                HashSet<Long> delIdSet = new HashSet<Long>(16);
                if (rowsMember != null && !rowsMember.isEmpty()) {
                    while (rowsMember.hasNext()) {
                        Row row = rowsMember.next();
                        Long id = row.getLong("fid");
                        String number = row.getString("fnumber");
                        if (!dimension.getNumber().equals(number)) {
                            delIdSet.add(id);
                            continue;
                        }
                        Map dimensionRootMap = dimensionRootByModel.computeIfAbsent((Long)tempModelId, k -> Maps.newHashMapWithExpectedSize((int)16));
                        dimensionRootMap.put(dimension.getId(), id);
                    }
                }
                if (!CollectionUtils.isNotEmpty(delIdSet)) continue;
                ViewMemberUpgradeService.doDelOtherLevelOneDimMember(tempModelId, memberTable, memberTableL, delIdSet);
            }
        });
    }

    private static void updateRootViewMemberNumber(Map<Long, Map<Long, kd.epm.eb.common.model.Dimension>> dimensionMapByModel, Map<Long, Map<Long, Long>> dimensionRootByModel) {
        if (dimensionMapByModel == null) {
            return;
        }
        ArrayList<Object[]> rootViewMemberUpdateParams = new ArrayList<Object[]>(16);
        dimensionMapByModel.forEach((tempModelId, dimensionMap) -> {
            Map dimensionRootMap = (Map)dimensionRootByModel.get(tempModelId);
            for (kd.epm.eb.common.model.Dimension dimension : dimensionMap.values()) {
                Long dimensionId = dimension.getId();
                String dimensionNumber = dimension.getNumber();
                rootViewMemberUpdateParams.add(new Object[]{dimensionNumber, dimensionNumber, dimensionRootMap.get(dimensionId), tempModelId, dimensionId});
            }
        });
        ViewMemberUpgradeService.viewMemberRootNumberAndShowNumberUpdateRows("t_eb_viewmember", rootViewMemberUpdateParams);
    }

    private static void doDelOtherLevelOneDimMember(Long tempModelId, String memberTable, String memberTableL, Set<Long> delIdSet) {
        SqlBuilder sqlBuilderDelOtherRootMem = new SqlBuilder();
        sqlBuilderDelOtherRootMem.append("delete from", new Object[0]).append(memberTable, new Object[0]).append("where fmodelid = ?", new Object[]{tempModelId}).append("and", new Object[0]).appendIn("fid", delIdSet.toArray());
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilderDelOtherRootMem);
        SqlBuilder sqlBuilderDelOtherRootLongMem = new SqlBuilder();
        sqlBuilderDelOtherRootLongMem.append("delete from", new Object[0]).append(memberTableL, new Object[0]).append("where", new Object[0]).appendIn("fid", delIdSet.toArray());
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilderDelOtherRootLongMem);
    }

    private static void resetCtDimViewGroup(Map<Long, Long> ctDimViewGroupMap, Object[] ctDimArray) {
        ArrayList<Object[]> ctDimViewParams = new ArrayList<Object[]>(16);
        SqlBuilder sqlBuilderCtDimView = new SqlBuilder();
        sqlBuilderCtDimView.append("select fid,fmodelid,fdimensionid from t_eb_dimensionview where", new Object[0]);
        sqlBuilderCtDimView.appendIn("fdimensionid", ctDimArray);
        DataSet rowsCtDimView = ViewMemberUpgradeService.queryDatasetBySql(sqlBuilderCtDimView, "queryDimViewByCt");
        if (rowsCtDimView != null && !rowsCtDimView.isEmpty()) {
            while (rowsCtDimView.hasNext()) {
                Row row = rowsCtDimView.next();
                long id = row.getLong("fid");
                long tempModelId = row.getLong("fmodelid");
                if (!ctDimViewGroupMap.containsKey(tempModelId)) continue;
                ctDimViewParams.add(new Object[]{ctDimViewGroupMap.get(tempModelId), id});
            }
        }
        ViewMemberUpgradeService.ctDimViewViewGroupUpdateRows("t_eb_dimensionview", ctDimViewParams);
    }

    private static void delCtDimNotPresetViewGroup(Map<Long, Long> ctDimViewGroupMap, Object[] ctDimArray) {
        HashSet<Long> delCtDimViewGroupSet = new HashSet<Long>(16);
        SqlBuilder sqlBuilderDimViewGroup = new SqlBuilder();
        sqlBuilderDimViewGroup.append("select fid,fmodelid,fdimensionid,fsource from t_eb_dimensionview_group where", new Object[0]);
        sqlBuilderDimViewGroup.appendIn("fdimensionid", ctDimArray);
        DataSet rowsDimViewGroup = ViewMemberUpgradeService.queryDatasetBySql(sqlBuilderDimViewGroup, "queryDimViewGroupByCt");
        if (rowsDimViewGroup != null && !rowsDimViewGroup.isEmpty()) {
            while (rowsDimViewGroup.hasNext()) {
                Row row = rowsDimViewGroup.next();
                long id = row.getLong("fid");
                long tempModelId = row.getLong("fmodelid");
                String source = row.getString("fsource");
                if ("1".equals(source)) {
                    ctDimViewGroupMap.put(tempModelId, id);
                    continue;
                }
                delCtDimViewGroupSet.add(id);
            }
        }
        if (CollectionUtils.isNotEmpty(delCtDimViewGroupSet)) {
            SqlBuilder sqlBuilderDelDimViewGroup = new SqlBuilder();
            sqlBuilderDelDimViewGroup.append("delete from t_eb_dimensionview_group where", new Object[0]);
            sqlBuilderDelDimViewGroup.appendIn("fid", delCtDimViewGroupSet.toArray());
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilderDelDimViewGroup);
            SqlBuilder sqlBuilderDelDimViewGroupL = new SqlBuilder();
            sqlBuilderDelDimViewGroupL.append("delete from t_eb_dimensionview_group_l where", new Object[0]);
            sqlBuilderDelDimViewGroupL.appendIn("fid", delCtDimViewGroupSet.toArray());
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilderDelDimViewGroupL);
        }
    }

    private static void updateAnalViewMemberSource(Map<Long, Map<Long, Map<String, Object>>> dimViewMapByBaseView, Map<Long, List<Long>> baseAnalViewMap, Map<Long, Map<Long, UpgradeDimensionViewMember>> allViewMemIdDimViewMemberMapByViewId, Map<Long, Map<Long, kd.epm.eb.common.model.Dimension>> dimensionMapByModel) {
        ArrayList<Object[]> viewMemberMemberSourceUpdateParams = new ArrayList<Object[]>(16);
        for (Map.Entry<Long, List<Long>> entry : baseAnalViewMap.entrySet()) {
            Long baseView = entry.getKey();
            Map<Long, Map<String, Object>> viewMap = dimViewMapByBaseView.get(baseView);
            List<Long> analViews = entry.getValue();
            for (Long analView : analViews) {
                Object root2;
                Map<Long, UpgradeDimensionViewMember> viewMemberMap;
                Map<String, Object> view = viewMap.get(baseView);
                if (view == null || (viewMemberMap = allViewMemIdDimViewMemberMapByViewId.get(analView)) == null) continue;
                Long modelId = (Long)view.get("fmodelid");
                Long dimId = (Long)view.get("fdimensionid");
                String memberSource = (String)view.get("fsource");
                kd.epm.eb.common.model.Dimension dimension = dimensionMapByModel.get(modelId).get(dimId);
                String noneNumber = dimension.getNoneNumber();
                List roots = viewMemberMap.values().stream().filter(e -> e.getLevel() == 1).collect(Collectors.toList());
                for (Object root2 : roots) {
                    viewMemberMemberSourceUpdateParams.add(new Object[]{ViewMemberSourceEnum.PRESET.getIndex(), root2.getViewMemberId()});
                }
                List refViewMembers = viewMemberMap.values().stream().filter(e -> !ViewMemberSourceEnum.ADD.getIndex().equals(e.getViewMembersource())).collect(Collectors.toList());
                root2 = refViewMembers.iterator();
                while (root2.hasNext()) {
                    UpgradeDimensionViewMember refViewMember = (UpgradeDimensionViewMember)root2.next();
                    if (refViewMember.getLevel() == 1 || refViewMember.getNumber().equals(noneNumber)) continue;
                    if ("1".equals(memberSource)) {
                        viewMemberMemberSourceUpdateParams.add(new Object[]{ViewMemberSourceEnum.INNER_REF.getIndex(), refViewMember.getViewMemberId()});
                        continue;
                    }
                    viewMemberMemberSourceUpdateParams.add(new Object[]{ViewMemberSourceEnum.OUTER_REF.getIndex(), refViewMember.getViewMemberId()});
                }
                if (dimension.isSysDim()) continue;
                List nones = viewMemberMap.values().stream().filter(e -> e.getNumber().equals(noneNumber)).collect(Collectors.toList());
                for (UpgradeDimensionViewMember none : nones) {
                    if ("1".equals(memberSource)) {
                        viewMemberMemberSourceUpdateParams.add(new Object[]{ViewMemberSourceEnum.INNER_REF.getIndex(), none.getViewMemberId()});
                        continue;
                    }
                    viewMemberMemberSourceUpdateParams.add(new Object[]{ViewMemberSourceEnum.OUTER_REF.getIndex(), none.getViewMemberId()});
                }
            }
        }
        ViewMemberUpgradeService.viewMemberMemberSourceUpdateRows("t_eb_viewmember", viewMemberMemberSourceUpdateParams);
    }

    private static void updateViewMemberChangeIsLeaf(Map<Long, Set<Long>> changeIsLeafMap, Map<Long, List<Member>> alreadyViewMemberMapByView) {
        ArrayList<Object[]> viewMemberChangeIsLeafUpdateParams = new ArrayList<Object[]>(16);
        for (Map.Entry<Long, List<Member>> entry : alreadyViewMemberMapByView.entrySet()) {
            Long viewId = entry.getKey();
            if (!changeIsLeafMap.containsKey(viewId)) continue;
            List<Member> viewMembers = entry.getValue();
            Set<Long> changeIsLeafSet = changeIsLeafMap.get(viewId);
            for (Long viewMemId : changeIsLeafSet) {
                if (!viewMembers.stream().noneMatch(e -> e.getParentId().equals(viewMemId))) continue;
                viewMemberChangeIsLeafUpdateParams.add(new Object[]{true, viewMemId});
            }
        }
        ViewMemberUpgradeService.viewMemberChangeIsLeafUpdateRows("t_eb_viewmember", viewMemberChangeIsLeafUpdateParams);
    }

    private static Map<Long, List<Long>> getPresetBaseViewsMap(Map<Long, Map<Long, List<Map<String, Object>>>> dimPresetBaseViewsByModelMap) {
        HashMap<Long, List<Long>> presetBaseViewsMap = new HashMap<Long, List<Long>>(16);
        dimPresetBaseViewsByModelMap.forEach((tempModel, dimPresetBaseViewMap) -> dimPresetBaseViewMap.forEach((tempDim, presetBaseViews) -> {
            String source;
            Long presetView = 0L;
            for (Map presetBaseView : presetBaseViews) {
                source = (String)presetBaseView.get("fsource");
                if (!"1".equals(source)) continue;
                presetView = (Long)presetBaseView.get("fid");
                break;
            }
            List baseViews = presetBaseViewsMap.computeIfAbsent(presetView, k -> Lists.newArrayListWithExpectedSize((int)16));
            for (Map presetBaseView : presetBaseViews) {
                source = (String)presetBaseView.get("fsource");
                if ("1".equals(source)) continue;
                baseViews.add((Long)presetBaseView.get("fid"));
            }
        }));
        return presetBaseViewsMap;
    }

    private static void updateViewMemberRefView(Object[] modelIdArray, Map<Long, List<Long>> baseAnalViewMap, Map<Long, List<Long>> presetBaseViewsMap, Long ctDimPresetViewId) {
        Map<Long, Map<Long, List<UpgradeDimensionViewMember>>> dimensionViewMemberMapUseRefView = ViewMemberUpgradeService.getDimensionViewMemberMapByModelsUseRefView(modelIdArray);
        ArrayList<Object[]> viewMemberRefViewUpdateParams = new ArrayList<Object[]>(16);
        HashMap editBaseViewMap = new HashMap(16);
        presetBaseViewsMap.forEach((srcView, baseTarViews) -> {
            for (Long baseTarView : baseTarViews) {
                editBaseViewMap.put(baseTarView, srcView);
            }
        });
        presetBaseViewsMap.forEach((srcViewId, tarViews) -> {
            Map srcViewDimViewMemMap = (Map)dimensionViewMemberMapUseRefView.get(srcViewId);
            String refIndex = ViewMemberSourceEnum.OUTER_REF.getIndex();
            if (srcViewId.equals(ctDimPresetViewId)) {
                refIndex = ViewMemberSourceEnum.INNER_REF.getIndex();
            }
            for (Long tarView : tarViews) {
                Map tarViewDimViewMemMap = (Map)dimensionViewMemberMapUseRefView.get(tarView);
                if (srcViewDimViewMemMap == null || tarViewDimViewMemMap == null) continue;
                for (Map.Entry viewMemberEntry : tarViewDimViewMemMap.entrySet()) {
                    Long memberId = (Long)viewMemberEntry.getKey();
                    List viewMembers = (List)viewMemberEntry.getValue();
                    if (!srcViewDimViewMemMap.containsKey(memberId)) continue;
                    for (UpgradeDimensionViewMember viewMember : viewMembers) {
                        boolean hasRef = viewMember.getViewMembersource().equals(ViewMemberSourceEnum.INNER_REF.getIndex()) || viewMember.getViewMembersource().equals(ViewMemberSourceEnum.OUTER_REF.getIndex());
                        if (!hasRef) continue;
                        viewMemberRefViewUpdateParams.add(new Object[]{srcViewId, refIndex, viewMember.getViewMemberId()});
                    }
                }
            }
        });
        baseAnalViewMap.forEach((srcViewId, tarViews) -> {
            Map srcViewDimViewMemMap = (Map)dimensionViewMemberMapUseRefView.get(srcViewId);
            Long refView = srcViewId;
            String refIndex = ViewMemberSourceEnum.INNER_REF.getIndex();
            if (editBaseViewMap.containsKey(srcViewId)) {
                refView = (Long)editBaseViewMap.get(srcViewId);
                refIndex = ViewMemberSourceEnum.OUTER_REF.getIndex();
            }
            for (Long tarView : tarViews) {
                Map tarViewDimViewMemMap = (Map)dimensionViewMemberMapUseRefView.get(tarView);
                if (srcViewDimViewMemMap == null || tarViewDimViewMemMap == null) continue;
                for (Map.Entry viewMemberEntry : tarViewDimViewMemMap.entrySet()) {
                    Long memberId = (Long)viewMemberEntry.getKey();
                    List viewMembers = (List)viewMemberEntry.getValue();
                    if (!srcViewDimViewMemMap.containsKey(memberId)) continue;
                    for (UpgradeDimensionViewMember viewMember : viewMembers) {
                        boolean hasRef = viewMember.getViewMembersource().equals(ViewMemberSourceEnum.INNER_REF.getIndex()) || viewMember.getViewMembersource().equals(ViewMemberSourceEnum.OUTER_REF.getIndex());
                        if (!hasRef) continue;
                        viewMemberRefViewUpdateParams.add(new Object[]{refView, refIndex, viewMember.getViewMemberId()});
                    }
                }
            }
        });
        ViewMemberUpgradeService.viewMemberRefViewUpdateRows("t_eb_viewmember", viewMemberRefViewUpdateParams);
    }

    private static Map<Long, Map<Long, List<UpgradeDimensionViewMember>>> getDimensionViewMemberMapByModelsUseRefView(Object[] modelIdArray) {
        HashMap<Long, Map<Long, List<UpgradeDimensionViewMember>>> allViewMemIdDimViewMemberMapByViewIdUseRefView = new HashMap<Long, Map<Long, List<UpgradeDimensionViewMember>>>(16);
        SqlBuilder sqlBuilderViewMem = new SqlBuilder();
        sqlBuilderViewMem.append("select fid,fmemberid,fviewid,fmembersource,frefview,fnumber from t_eb_viewmember where ", new Object[0]);
        sqlBuilderViewMem.appendIn("fmodelid", modelIdArray);
        DataSet rowsViewMemUseRefView = ViewMemberUpgradeService.queryDatasetBySql(sqlBuilderViewMem, "queryViewMemUseRefView");
        if (rowsViewMemUseRefView != null && !rowsViewMemUseRefView.isEmpty()) {
            while (rowsViewMemUseRefView.hasNext()) {
                Row row = rowsViewMemUseRefView.next();
                Long viewId = row.getLong("fviewid");
                Long memberId = row.getLong("fmemberid");
                Map viewMembersMapByMemberId = allViewMemIdDimViewMemberMapByViewIdUseRefView.computeIfAbsent(viewId, k -> Maps.newHashMapWithExpectedSize((int)16));
                List viewMembers = viewMembersMapByMemberId.computeIfAbsent(memberId, k -> Lists.newArrayListWithExpectedSize((int)16));
                UpgradeDimensionViewMember dimViewMember = new UpgradeDimensionViewMember();
                dimViewMember.setViewMemberId(row.getLong("fid"));
                dimViewMember.setMemberId(memberId);
                dimViewMember.setView(viewId);
                dimViewMember.setViewMembersource(row.getString("fmembersource"));
                Long refView = row.getLong("frefview");
                if (refView == null) {
                    refView = 0L;
                }
                dimViewMember.setRefview(refView);
                dimViewMember.setNumber(row.getString("fnumber"));
                viewMembers.add(dimViewMember);
            }
        }
        return allViewMemIdDimViewMemberMapByViewIdUseRefView;
    }

    private static void insertCtViewMembers(Map<Long, Long> ctDimensionMapByModel, Map<Long, Map<Long, List<Long>>> dimViewsByModelMap, Map<Long, Map<Long, List<UpgradeDimensionViewMember>>> ctViewMembersMapByModel, Map<Long, List<Long>> presetBaseViewsMap) {
        ArrayList<Object[]> insertCtViewMemberList = new ArrayList<Object[]>(16);
        for (Map.Entry<Long, Map<Long, List<Long>>> entry : dimViewsByModelMap.entrySet()) {
            Long tempModelId = entry.getKey();
            Long ctDimId = ctDimensionMapByModel.get(tempModelId);
            Map<Long, List<Long>> dimViewsMap = entry.getValue();
            List<Long> ctViews = dimViewsMap.get(ctDimId);
            Map<Long, List<UpgradeDimensionViewMember>> ctMembersMapByViewId = ctViewMembersMapByModel.get(tempModelId);
            List<UpgradeDimensionViewMember> baseCtMembers = ctMembersMapByViewId.get(0L);
            for (Long ctView : ctViews) {
                HashMap<Long, Long> memViewMap = new HashMap<Long, Long>(16);
                boolean isPresetView = presetBaseViewsMap.containsKey(ctView);
                String baseCtMemberSource = isPresetView ? ViewMemberSourceEnum.PRESET.getIndex() : ViewMemberSourceEnum.INNER_REF.getIndex();
                for (UpgradeDimensionViewMember baseCtMember : baseCtMembers) {
                    long vid = GlobalIdUtil.genGlobalLongId();
                    baseCtMember.setViewMemberId(Long.valueOf(vid));
                    baseCtMember.setViewMembersource(baseCtMemberSource);
                    baseCtMember.setView(ctView);
                    memViewMap.put(baseCtMember.getMemberId(), vid);
                }
                ArrayList<UpgradeDimensionViewMember> needUpgradeCtMembers = new ArrayList<UpgradeDimensionViewMember>(16);
                needUpgradeCtMembers.addAll(baseCtMembers);
                List<UpgradeDimensionViewMember> tempCtViewMembers = ctMembersMapByViewId.get(ctView);
                if (CollectionUtils.isNotEmpty(tempCtViewMembers)) {
                    for (UpgradeDimensionViewMember tempCtViewMember : tempCtViewMembers) {
                        long vid = GlobalIdUtil.genGlobalLongId();
                        tempCtViewMember.setViewMemberId(Long.valueOf(vid));
                        memViewMap.put(tempCtViewMember.getMemberId(), vid);
                        if (tempCtViewMember.getViewMembersource().equals(ViewMemberSourceEnum.PRESET.getIndex())) continue;
                        tempCtViewMember.setViewMembersource(ViewMemberSourceEnum.ADD.getIndex());
                    }
                    needUpgradeCtMembers.addAll(tempCtViewMembers);
                }
                ArrayList<Object[]> tempSave = new ArrayList<Object[]>(16);
                Long rootVid = 0L;
                for (UpgradeDimensionViewMember needUpgradeCtMember : needUpgradeCtMembers) {
                    if (needUpgradeCtMember.getNumber().equals(SysDimensionEnum.ChangeType.getNumber())) {
                        rootVid = needUpgradeCtMember.getViewMemberId();
                    }
                    String name = StringUtils.isEmpty((String)needUpgradeCtMember.getLocaleName()) ? "_" : needUpgradeCtMember.getLocaleName();
                    String simpleName = StringUtils.isEmpty((String)needUpgradeCtMember.getLocaleSimpleName()) ? " " : needUpgradeCtMember.getLocaleSimpleName();
                    tempSave.add(new Object[]{needUpgradeCtMember.getViewMemberId(), name, needUpgradeCtMember.getNumber(), simpleName, needUpgradeCtMember.getShowNumber(), needUpgradeCtMember.getModel(), needUpgradeCtMember.getDimension(), needUpgradeCtMember.getMemberId(), needUpgradeCtMember.getView(), needUpgradeCtMember.getAggOprtSign(), needUpgradeCtMember.getLevel(), needUpgradeCtMember.getDseq(), needUpgradeCtMember.getLongNumber(), needUpgradeCtMember.isLeaf(), needUpgradeCtMember.getViewMembersource(), needUpgradeCtMember.getParentId(), needUpgradeCtMember.isEnable(), needUpgradeCtMember.getDisable(), needUpgradeCtMember.getModifyDate(), needUpgradeCtMember.getModifier(), needUpgradeCtMember.getStatus(), needUpgradeCtMember.isShowChildren(), needUpgradeCtMember.isShowSelf(), ViewMemberUpgradeService.getRefView(needUpgradeCtMember), needUpgradeCtMember.getInnerOrg(), needUpgradeCtMember.getOuterOrg(), needUpgradeCtMember.getSyncStatus(), needUpgradeCtMember.getSyncDate() == null ? null : needUpgradeCtMember.getSyncDate(), needUpgradeCtMember.getMergernode(), needUpgradeCtMember.getOffsetEntry()});
                }
                for (Object[] viewMem : tempSave) {
                    Long parent = (Long)viewMem[15];
                    if (memViewMap.containsKey(parent)) {
                        viewMem[15] = memViewMap.get(parent);
                        continue;
                    }
                    if (parent == 0L) continue;
                    viewMem[15] = rootVid;
                }
                insertCtViewMemberList.addAll(tempSave);
            }
        }
        ViewMemberUpgradeService.insertRows(VIEW_MEMBER_FIELD, "t_eb_viewmember", insertCtViewMemberList);
    }

    private static Long getRefView(UpgradeDimensionViewMember upgradeDimensionViewMember) {
        if (upgradeDimensionViewMember == null) {
            return 0L;
        }
        Long refView = upgradeDimensionViewMember.getRefview();
        if (refView == null) {
            refView = 0L;
        }
        return refView;
    }

    private static Map<Long, Map<Long, List<UpgradeDimensionViewMember>>> getCtMemberMapByModel(Object[] modelIdArray) {
        HashMap<Long, Map<Long, List<UpgradeDimensionViewMember>>> ctViewMembersMapByModel = new HashMap<Long, Map<Long, List<UpgradeDimensionViewMember>>>(16);
        String field = "a.fid id,b.fname fname,a.fnumber fnumber,b.fsimplename simplename,a.fmodelid modelid,a.fdimensionid dimensionid,a.fshownumber shownumber,a.flongnumber longnumber,a.fparentid parentid,a.faggoprt aggoprt,a.flevel flevel,a.fseq seq,a.fmembersource membersource,a.fdisable fdisable,a.fenable fenable,a.fisleaf isleaf,a.fsyncstatus syncstatus,a.fsyncdate syncdate,a.fviewid viewid,a.fstatus status,a.fmodifierid modifierid,a.fmodifytime modifytime";
        SqlBuilder sqlBuilderCtBaseMember = new SqlBuilder();
        sqlBuilderCtBaseMember.append("select ", new Object[0]).append(field, new Object[0]);
        sqlBuilderCtBaseMember.append(" from ", new Object[0]).append("t_eb_structofchangetype", new Object[0]).append(" a left join ", new Object[0]).append("t_eb_structofchangetype_l", new Object[0]).append(" b on b.fid = a.fid and b.flocaleid = 'zh_CN' where ", new Object[0]);
        sqlBuilderCtBaseMember.appendIn("a.fmodelid", modelIdArray);
        DataSet rowsCtBaseMember = ViewMemberUpgradeService.queryDatasetBySql(sqlBuilderCtBaseMember, "queryCtBaseMember");
        if (rowsCtBaseMember != null && !rowsCtBaseMember.isEmpty()) {
            while (rowsCtBaseMember.hasNext()) {
                Row row = rowsCtBaseMember.next();
                Long tempModelId = row.getLong("modelid");
                Long viewId = row.getLong("viewid");
                Map ctViewMembersMap = ctViewMembersMapByModel.computeIfAbsent(tempModelId, k -> Maps.newHashMapWithExpectedSize((int)16));
                List ctViewMembers = ctViewMembersMap.computeIfAbsent(viewId, k -> Lists.newArrayListWithExpectedSize((int)16));
                UpgradeDimensionViewMember ctMember = new UpgradeDimensionViewMember();
                ctViewMembers.add(ctMember);
                Long dimensionId = row.getLong("dimensionid");
                long viewMemId = GlobalIdUtil.genGlobalLongId();
                Long memId = row.getLong("id");
                ctMember.setViewMemberId(Long.valueOf(viewMemId));
                ctMember.setName(row.getString("fname"));
                ctMember.setNumber(row.getString("fnumber"));
                ctMember.setSimpleName(row.getString("simplename"));
                ctMember.setShowNumber(row.getString("shownumber"));
                ctMember.setModel(tempModelId);
                ctMember.setDimension(dimensionId);
                ctMember.setMemberId(memId);
                ctMember.setView(viewId);
                ctMember.setAggOprtSign(row.getString("aggoprt"));
                ctMember.setLevel(row.getInteger("flevel"));
                ctMember.setDseq(row.getInteger("seq"));
                ctMember.setLongNumber(row.getString("longnumber"));
                ctMember.setIsLeaf(row.getBoolean("isleaf").booleanValue());
                String memberSource = row.getString("membersource");
                if (memberSource.equals(MemberSourceEnum.PRESET.getIndex())) {
                    ctMember.setViewMembersource(ViewMemberSourceEnum.PRESET.getIndex());
                } else {
                    ctMember.setViewMembersource(ViewMemberSourceEnum.ADD.getIndex());
                }
                ctMember.setParentId(row.getLong("parentid"));
                ctMember.setEnable(row.getBoolean("fenable") != false ? "1" : "0");
                ctMember.setDisable(row.getString("fdisable"));
                ctMember.setStatus(row.getString("status"));
                ctMember.setSyncStatus(row.getString("syncstatus"));
                ctMember.setSyncDate(row.getDate("syncdate"));
                ctMember.setShowChildren(true);
                ctMember.setShowSelf(true);
                ctMember.setInnerOrg("0");
                ctMember.setOuterOrg("0");
                ctMember.setMergernode("0");
                ctMember.setOffsetEntry("0");
                ctMember.setModifyDate(row.getDate("modifytime"));
                ctMember.setModifier(row.getLong("modifierid"));
            }
        }
        return ctViewMembersMapByModel;
    }

    private static void updateBaseViewMemberSource(Map<Long, Map<Long, Map<String, Object>>> dimViewMapByBaseView, Map<Long, Map<Long, UpgradeDimensionViewMember>> allViewMemIdDimViewMemberMapByViewId, Map<Long, Map<Long, kd.epm.eb.common.model.Dimension>> dimensionMapByModel) {
        ArrayList<Object[]> viewMemberMemberSourceUpdateParams = new ArrayList<Object[]>(16);
        for (Map.Entry<Long, Map<Long, Map<String, Object>>> entry : dimViewMapByBaseView.entrySet()) {
            Map<Long, UpgradeDimensionViewMember> viewMemberMap;
            String source;
            Long baseView = entry.getKey();
            Map<Long, Map<String, Object>> viewMap = entry.getValue();
            Map<String, Object> view = viewMap.get(baseView);
            if (view == null || "1".equals(source = (String)view.get("fsource")) || (viewMemberMap = allViewMemIdDimViewMemberMapByViewId.get(baseView)) == null) continue;
            Long modelId = (Long)view.get("fmodelid");
            Long dimId = (Long)view.get("fdimensionid");
            kd.epm.eb.common.model.Dimension dimension = dimensionMapByModel.get(modelId).get(dimId);
            String dimensionNumber = dimension.getNumber();
            if (dimensionNumber.equals(SysDimensionEnum.ChangeType.getNumber())) continue;
            HashSet presetDimNumSet = Sets.newHashSet((Object[])new String[]{dimensionNumber});
            for (Map.Entry<Long, UpgradeDimensionViewMember> memberEntry : viewMemberMap.entrySet()) {
                Long viewMemId = memberEntry.getKey();
                UpgradeDimensionViewMember viewMember = memberEntry.getValue();
                String memberNumber = viewMember.getNumber();
                if (presetDimNumSet.contains(memberNumber)) {
                    viewMemberMemberSourceUpdateParams.add(new Object[]{ViewMemberSourceEnum.PRESET.getIndex(), viewMemId});
                    continue;
                }
                viewMemberMemberSourceUpdateParams.add(new Object[]{ViewMemberSourceEnum.OUTER_REF.getIndex(), viewMemId});
            }
        }
        ViewMemberUpgradeService.viewMemberMemberSourceUpdateRows("t_eb_viewmember", viewMemberMemberSourceUpdateParams);
    }

    private static Map<Long, List<Long>> getBaseAnalViewsMap(Object[] modelIdArray, Map<Long, Map<Long, kd.epm.eb.common.model.Dimension>> dimensionMapByModel, Map<Long, Map<Long, Map<String, Object>>> dimViewMapByBaseView, Map<Long, Map<Long, Long>> dimPresetViewByModelMap, Map<Long, Map<Long, List<Long>>> dimViewsByModelMap, Map<Long, Map<Long, List<Map<String, Object>>>> dimPresetBaseViewsByModelMap) {
        HashMap<Long, Map> dimPresetViewSetByModelMap = new HashMap<Long, Map>(16);
        HashMap<Long, List<Long>> baseAnalViewMap = new HashMap<Long, List<Long>>(16);
        SqlBuilder sqlBuilderDimView = new SqlBuilder();
        sqlBuilderDimView.append("select fid,fnumber,fname,fmodelid,fdimensionid,fsource,fusage,fbaseviewid,fviewgroupid,fmodifierid from t_eb_dimensionview where ", new Object[0]);
        sqlBuilderDimView.appendIn("fmodelid", modelIdArray);
        DataSet rowsDimView = ViewMemberUpgradeService.queryDatasetBySql(sqlBuilderDimView, "queryDimView");
        if (rowsDimView != null && !rowsDimView.isEmpty()) {
            while (rowsDimView.hasNext()) {
                List analysisViews;
                Map dimViewMap;
                Row row = rowsDimView.next();
                long tempModelId = row.getLong("fmodelid");
                long tempDimId = row.getLong("fdimensionid");
                Map<Long, kd.epm.eb.common.model.Dimension> dimensionMap = dimensionMapByModel.get(tempModelId);
                if (dimensionMap == null || !dimensionMap.containsKey(tempDimId)) continue;
                Map dimPresetBaseViewMap = dimPresetBaseViewsByModelMap.computeIfAbsent(tempModelId, k -> Maps.newHashMapWithExpectedSize((int)16));
                List presetBaseViews = dimPresetBaseViewMap.computeIfAbsent(tempDimId, k -> Lists.newArrayListWithExpectedSize((int)16));
                Long id = row.getLong("fid");
                if (IDUtils.isEmptyLong((Long)row.getLong("fbaseviewid")).booleanValue()) {
                    dimViewMap = dimViewMapByBaseView.computeIfAbsent(id, k -> Maps.newHashMapWithExpectedSize((int)16));
                    analysisViews = baseAnalViewMap.computeIfAbsent(id, k -> Lists.newArrayListWithExpectedSize((int)16));
                } else {
                    dimViewMap = dimViewMapByBaseView.computeIfAbsent(row.getLong("fbaseviewid"), k -> Maps.newHashMapWithExpectedSize((int)16));
                    analysisViews = baseAnalViewMap.computeIfAbsent(row.getLong("fbaseviewid"), k -> Lists.newArrayListWithExpectedSize((int)16));
                }
                HashMap view = Maps.newHashMapWithExpectedSize((int)16);
                view.put("fid", id);
                view.put("fnumber", row.getString("fnumber"));
                view.put("fname", row.getString("fname"));
                view.put("fmodelid", row.getLong("fmodelid"));
                view.put("fdimensionid", row.getLong("fdimensionid"));
                view.put("fsource", row.getString("fsource"));
                Map dimPresetViewSetByModel = dimPresetViewSetByModelMap.computeIfAbsent(row.getLong("fmodelid"), k -> Maps.newHashMapWithExpectedSize((int)16));
                Set dimPresetViewSet = dimPresetViewSetByModel.computeIfAbsent(row.getLong("fdimensionid"), k -> Sets.newHashSetWithExpectedSize((int)16));
                if ("1".equals(row.getString("fsource"))) {
                    Map dimPresetViewMap = dimPresetViewByModelMap.computeIfAbsent(row.getLong("fmodelid"), k -> Maps.newHashMapWithExpectedSize((int)16));
                    dimPresetViewMap.put(row.getLong("fdimensionid"), id);
                    dimPresetViewSet.add(id);
                }
                if ("1".equals(row.getString("fusage"))) {
                    analysisViews.add(id);
                }
                view.put("fbaseviewid", row.getLong("fbaseviewid"));
                view.put("fviewgroupid", row.getLong("fviewgroupid"));
                view.put("fmodifierid", row.getLong("fmodifierid"));
                dimViewMap.put(id, view);
                Map dimViews = dimViewsByModelMap.computeIfAbsent(tempModelId, k -> Maps.newHashMapWithExpectedSize((int)16));
                List views = dimViews.computeIfAbsent(tempDimId, k -> Lists.newArrayListWithExpectedSize((int)16));
                views.add(id);
                if (!IDUtils.isEmptyLong((Long)row.getLong("fbaseviewid")).booleanValue()) continue;
                presetBaseViews.add(view);
            }
        }
        HashSet morePresetViewDim = new HashSet(16);
        HashSet notPresetViewDim = new HashSet(16);
        dimPresetViewSetByModelMap.forEach((modelId, _dimPresetViewMap) -> {
            Map _dimensionMap = (Map)dimensionMapByModel.get(modelId);
            _dimPresetViewMap.forEach((dimId, _dimPresetViewSet) -> {
                String number = ((kd.epm.eb.common.model.Dimension)_dimensionMap.get(dimId)).getNumber();
                if (_dimPresetViewSet.size() > 1) {
                    morePresetViewDim.add(number);
                }
                if (_dimPresetViewSet.size() == 0) {
                    notPresetViewDim.add(number);
                }
            });
        });
        if (CollectionUtils.isNotEmpty(notPresetViewDim)) {
            throw new KDBizException(ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u6ca1\u6709\u9884\u7f6e\u89c6\u56fe\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ViewMemberUpgradeService_6", (String)"epm-eb-business", (Object[])new Object[]{StringUtils.join(notPresetViewDim, (String)",")}));
        }
        if (CollectionUtils.isNotEmpty(morePresetViewDim)) {
            throw new KDBizException(ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u5b58\u5728\u591a\u4e2a\u9884\u7f6e\u89c6\u56fe\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ViewMemberUpgradeService_5", (String)"epm-eb-business", (Object[])new Object[]{StringUtils.join(morePresetViewDim, (String)",")}));
        }
        HashSet<Long> viewIdSet = new HashSet<Long>(16);
        for (Map.Entry<Long, Map<Long, Map<String, Object>>> entry : dimViewMapByBaseView.entrySet()) {
            Map<Long, Map<String, Object>> viewMap = entry.getValue();
            viewIdSet.addAll(viewMap.keySet());
        }
        HashMap<Long, Map> viewLocaleStrMap = new HashMap<Long, Map>(16);
        if (CollectionUtils.isNotEmpty(viewIdSet)) {
            SqlBuilder sqlBuilderDimViewLong = new SqlBuilder();
            sqlBuilderDimViewLong.append("select fid,flocaleid,fname from t_eb_dimensionview_l where ", new Object[0]);
            sqlBuilderDimViewLong.appendIn("fid", viewIdSet.toArray());
            DataSet rowsDimViewLong = ViewMemberUpgradeService.queryDatasetBySql(sqlBuilderDimViewLong, "queryDimViewLong");
            if (rowsDimViewLong != null && !rowsDimViewLong.isEmpty()) {
                while (rowsDimViewLong.hasNext()) {
                    Row row = rowsDimViewLong.next();
                    long id = row.getLong("fid");
                    String localeId = row.getString("flocaleid");
                    String name = row.getString("fname");
                    Map localeStrMap = viewLocaleStrMap.computeIfAbsent(id, k -> Maps.newHashMapWithExpectedSize((int)16));
                    localeStrMap.put(localeId, name);
                }
            }
            HashMap viewLocaleObjMap = new HashMap(16);
            for (Map.Entry entry : viewLocaleStrMap.entrySet()) {
                LocaleString ls = new LocaleString();
                ls.putAll((Map)entry.getValue());
                viewLocaleObjMap.put(entry.getKey(), ls);
            }
            for (Map.Entry<Object, Object> entry : dimViewMapByBaseView.entrySet()) {
                Map viewMap = (Map)entry.getValue();
                for (Map.Entry mapEntry : viewMap.entrySet()) {
                    LocaleString localeString = (LocaleString)viewLocaleObjMap.get(mapEntry.getKey());
                    if (localeString == null) continue;
                    ((Map)mapEntry.getValue()).put("localename", localeString);
                }
            }
        }
        return baseAnalViewMap;
    }

    private static void handleOlapSync(Map<Long, Model> modelMap, Map<Long, Map<Long, kd.epm.eb.common.model.Dimension>> dimensionMapByModel, Map<Long, List<Dataset>> datasetMapByModel, Map<Long, Member> alreadyViewMemberMapByViewMemId, Map<Long, List<Member>> alreadyViewMemberHasChildMapByView) {
        LogStats stats = new LogStats("budget-shrek-log : ");
        dimensionMapByModel.forEach((tempModelId, tempDimensionMap) -> {
            List tempDatasets = (List)datasetMapByModel.get(tempModelId);
            Model model = (Model)modelMap.get(tempModelId);
            ShrekConfig config = ShrekConfigServiceHelper.getDefaultConfig((Model)model);
            for (Dataset dataset : tempDatasets) {
                OlapConnection conn;
                block5: {
                    conn = null;
                    conn = ViewMemberUpgradeService.getConnection(model, dataset);
                    if (conn != null) break block5;
                    ShrekOlapUtils.close((Object[])new Object[]{conn});
                    stats.addInfo("finally updateDimension.");
                    log.info(stats.toString());
                    continue;
                }
                try {
                    conn.Open();
                    String cubeNumber = ShrekOlapUtils.getCubeNumber((Dataset)dataset);
                    stats.addInfo("begin updateDimension.");
                    List dimensionIdList = dataset.getDimensionIdList();
                    for (kd.epm.eb.common.model.Dimension dimension : tempDimensionMap.values()) {
                        List viewIdList;
                        if (!dimensionIdList.contains(dimension.getId()) || CollectionUtils.isEmpty((Collection)(viewIdList = (List)dataset.getViewGroupViewsMapByDimId().get(dimension.getId())))) continue;
                        ViewMemberUpgradeService.updateDimension(model, conn, cubeNumber, dimension.getNumber(), config, stats, viewIdList, true, alreadyViewMemberHasChildMapByView, alreadyViewMemberMapByViewMemId);
                        DataLockService.getInstance().updateLockRuleAsync(dimension.getNumber(), Collections.singletonList(dataset.getId()), model.getId());
                        stats.add("end updateDimension.");
                    }
                }
                catch (Throwable throwable) {
                    ShrekOlapUtils.close((Object[])new Object[]{conn});
                    stats.addInfo("finally updateDimension.");
                    log.info(stats.toString());
                    throw throwable;
                }
                ShrekOlapUtils.close((Object[])new Object[]{conn});
                stats.addInfo("finally updateDimension.");
                log.info(stats.toString());
            }
        });
    }

    private static OlapConnection getConnection(Model model, Dataset dataset) {
        ShrekDataSource ds = ViewMemberUpgradeService.getDataSource(model);
        if (ds == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u8fde\u63a5\u662f\u5426\u6b63\u5e38\u6216\u8005\u5207\u6362\u8fc7\u6570\u636e\u6e90\u662f\u5426\u6709\u91cd\u542f\u670d\u52a1", (String)"ConnectionManager_0", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        String cubeNumber = model.isModelByEB() ? ShrekOlapUtils.getCubeNumber((Model)model) : ShrekOlapUtils.getCubeNumber((Dataset)dataset);
        return ConnectionManager.getInstance().getConnection(MessageFormat.format("http://{0}:{1}/bos-olap-webserver/services/httpolap", ds.getIp(), ds.getPort()), ds.getUsername(), ds.getPassword(), cubeNumber);
    }

    private static ShrekDataSource getDataSource(Model model) {
        SqlBuilder sqlBuilderDataSource = new SqlBuilder();
        sqlBuilderDataSource.append("select fid, fnumber, fname, fserveraddress, fport, fusername, fpassword, faccountid from t_epbs_datasource where fid = ?", new Object[]{model.getDataSourceId()});
        DataSet rowsDataSource = ViewMemberUpgradeService.queryDatasetBySql(sqlBuilderDataSource, "queryDataSource");
        ShrekDataSource shrekDataSource = null;
        if (rowsDataSource != null && !rowsDataSource.isEmpty()) {
            while (rowsDataSource.hasNext()) {
                Row row = rowsDataSource.next();
                if (!DataSourceUtils.verifyAccount((Long)row.getLong("fid"), (String)row.getString("faccountid"))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u6e90\u4e0d\u662f\u8be5\u6570\u636e\u4e2d\u5fc3\u521b\u5efa\uff0c\u8bf7\u91cd\u65b0\u521b\u5efa\u6570\u636e\u6e90\u3002", (String)"ConnectionManager_1", (String)"epm-eb-common", (Object[])new Object[0]));
                }
                shrekDataSource = new ShrekDataSource(row.getString("fserveraddress"), row.getString("fport"), row.getString("fusername"), row.getString("fpassword"));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6e90\u8fde\u63a5\u662f\u5426\u6b63\u5e38\u6216\u8005\u5207\u6362\u8fc7\u6570\u636e\u6e90\u662f\u5426\u6709\u91cd\u542f\u670d\u52a1", (String)"ConnectionManager_0", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        return shrekDataSource;
    }

    private static void getAllViewMemberByModel(Object[] modelIdArray, Map<Long, List<Member>> alreadyViewMemberMapByView, Map<Long, Integer> maxLevelMapByViewId, Map<Long, Member> alreadyViewMemberMapByViewMemId) {
        SqlBuilder sqlBuilderViewMember = new SqlBuilder();
        sqlBuilderViewMember.append("select fid,fnumber,fmodelid,fdimensionid,fmemberid,fmembersource,fviewid,faggoprt,fisleaf,fparentid,flongnumber,flevel from t_eb_viewmember where ", new Object[0]);
        sqlBuilderViewMember.appendIn("fmodelid", modelIdArray);
        sqlBuilderViewMember.append(" order by fviewid, flevel", new Object[0]);
        DataSet rowsViewMember = ViewMemberUpgradeService.queryDatasetBySql(sqlBuilderViewMember, "queryAlreadyViewMem");
        if (rowsViewMember != null && !rowsViewMember.isEmpty()) {
            while (rowsViewMember.hasNext()) {
                Row row = rowsViewMember.next();
                Long viewId = row.getLong("fviewid");
                List viewMembers = alreadyViewMemberMapByView.computeIfAbsent(viewId, k -> Lists.newArrayListWithExpectedSize((int)16));
                ViewUpMember member = new ViewUpMember();
                member.setId(row.getLong("fid"));
                member.setNumber(row.getString("fnumber"));
                member.setAggType(row.getString("faggoprt"));
                member.setParentId(row.getLong("fparentid"));
                Dimension dimension = new Dimension();
                dimension.setId(row.getLong("fdimensionid"));
                member.setDimension(dimension);
                member.setLongNumber(row.getString("flongnumber"));
                Integer level = row.getInteger("flevel");
                member.setLevel(level.intValue());
                if (ViewMemberSourceEnum.ADD.getIndex().equals(row.getString("fmembersource"))) {
                    member.setNewMember(true);
                }
                member.setMemberId(row.getLong("fmemberid"));
                viewMembers.add(member);
                alreadyViewMemberMapByViewMemId.put(row.getLong("fid"), (Member)member);
                int maxLevel = maxLevelMapByViewId.computeIfAbsent(viewId, k -> 1);
                if (level <= maxLevel) continue;
                maxLevel = level;
                maxLevelMapByViewId.put(viewId, maxLevel);
            }
        }
    }

    private static void handleDatasetViews(Map<Long, List<Dataset>> datasetMapByModel) {
        HashSet bussModelSet = new HashSet(16);
        for (List<Dataset> datasetList2 : datasetMapByModel.values()) {
            bussModelSet.addAll(datasetList2.stream().map(Dataset::getBusModelId).collect(Collectors.toSet()));
        }
        HashMap<Long, List> bussModelViewGroupMap = new HashMap<Long, List>(16);
        SqlBuilder sqlBuilderViewGroup = new SqlBuilder();
        sqlBuilderViewGroup.append("select fid,fviewgroupid from t_eb_viewentry where ", new Object[0]);
        sqlBuilderViewGroup.appendIn("fid", bussModelSet.toArray());
        DataSet rowsViewGroup = ViewMemberUpgradeService.queryDatasetBySql(sqlBuilderViewGroup, "queryViewGroupByViewEntry");
        if (rowsViewGroup != null && !rowsViewGroup.isEmpty()) {
            while (rowsViewGroup.hasNext()) {
                Row row = rowsViewGroup.next();
                Long viewGroupId = row.getLong("fviewgroupid");
                if (IDUtils.isEmptyLong((Long)viewGroupId).booleanValue()) continue;
                List viewGroups = bussModelViewGroupMap.computeIfAbsent(row.getLong("fid"), k -> Lists.newArrayListWithExpectedSize((int)16));
                viewGroups.add(viewGroupId);
            }
        }
        HashMap bussModelViewGroupAndDirMap = new HashMap(16);
        for (Map.Entry entry : bussModelViewGroupMap.entrySet()) {
            HashSet<Long> viewGroupAndDirSet = new HashSet<Long>(16);
            Long bussModel = (Long)entry.getKey();
            List viewGroupList = (List)entry.getValue();
            viewGroupAndDirSet.addAll(viewGroupList);
            SqlBuilder sqlBuilderViewGroupAndDir = new SqlBuilder();
            sqlBuilderViewGroupAndDir.append("select fid from t_eb_dimensionview_group where ", new Object[0]);
            sqlBuilderViewGroupAndDir.appendIn("fparentid", viewGroupList.toArray());
            DataSet rowsViewGroupAndDir = ViewMemberUpgradeService.queryDatasetBySql(sqlBuilderViewGroupAndDir, "queryDimViewGroup");
            if (rowsViewGroupAndDir != null && !rowsViewGroupAndDir.isEmpty()) {
                while (rowsViewGroupAndDir.hasNext()) {
                    Row row = rowsViewGroupAndDir.next();
                    viewGroupAndDirSet.add(row.getLong("fid"));
                }
            }
            bussModelViewGroupAndDirMap.put(bussModel, viewGroupAndDirSet);
        }
        HashMap dimViewMapByBussModel = new HashMap(16);
        for (Map.Entry entry : bussModelViewGroupAndDirMap.entrySet()) {
            HashMap<Long, List> viewMapByDim = new HashMap<Long, List>(16);
            Long bussModel = (Long)entry.getKey();
            Set tempViewGroupAndDirSet = (Set)entry.getValue();
            SqlBuilder sqlBuilderDimViewByViewGroup = new SqlBuilder();
            sqlBuilderDimViewByViewGroup.append("select fid,fdimensionid from t_eb_dimensionview where ", new Object[0]);
            sqlBuilderDimViewByViewGroup.appendIn("fviewgroupid", tempViewGroupAndDirSet.toArray());
            DataSet rowsDimViewByViewGroup = ViewMemberUpgradeService.queryDatasetBySql(sqlBuilderDimViewByViewGroup, "queryDimViewByViewGroup");
            if (rowsDimViewByViewGroup != null && !rowsDimViewByViewGroup.isEmpty()) {
                while (rowsDimViewByViewGroup.hasNext()) {
                    Row row = rowsDimViewByViewGroup.next();
                    List viewIds = viewMapByDim.computeIfAbsent(row.getLong("fdimensionid"), k -> Lists.newArrayListWithExpectedSize((int)16));
                    viewIds.add(row.getLong("fid"));
                }
            }
            dimViewMapByBussModel.put(bussModel, viewMapByDim);
        }
        datasetMapByModel.forEach((model, datasetList) -> {
            for (Dataset dataset : datasetList) {
                if (!dimViewMapByBussModel.containsKey(dataset.getBusModelId())) continue;
                dataset.setViewGroupViewsMapByDimId((Map)dimViewMapByBussModel.get(dataset.getBusModelId()));
            }
        });
    }

    public static DataSet queryDatasetBySql(SqlBuilder sqlBuilder, String queryKey) {
        return DB.queryDataSet((String)queryKey, (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
    }

    private static void handleDatasetDims(Set<Long> queryDatasetSet, Map<Long, List<Dataset>> datasetMapByModel) {
        HashMap<Long, List> dimIdMapByDataset = new HashMap<Long, List>(16);
        SqlBuilder sqlBuilderDatasetDim = new SqlBuilder();
        sqlBuilderDatasetDim.append("select fid,fdatasetdim from t_eb_datasetdim where ", new Object[0]);
        sqlBuilderDatasetDim.appendIn("fid", queryDatasetSet.toArray());
        DataSet rowsDatasetDim = ViewMemberUpgradeService.queryDatasetBySql(sqlBuilderDatasetDim, "queryDatasetDim");
        if (rowsDatasetDim != null && !rowsDatasetDim.isEmpty()) {
            while (rowsDatasetDim.hasNext()) {
                Row row = rowsDatasetDim.next();
                List dims = dimIdMapByDataset.computeIfAbsent(row.getLong("fid"), k -> Lists.newArrayListWithExpectedSize((int)16));
                dims.add(row.getLong("fdatasetdim"));
            }
        }
        for (List<Dataset> datasetList : datasetMapByModel.values()) {
            for (Dataset dataset : datasetList) {
                dataset.setDimensionIdList((List)dimIdMapByDataset.get(dataset.getId()));
            }
        }
    }

    private static Map<Long, List<Dataset>> getDatasetMapByModel(Object[] modelIdArray, Set<Long> queryDatasetSet) {
        HashMap<Long, List<Dataset>> datasetMapByModel = new HashMap<Long, List<Dataset>>(16);
        SqlBuilder sqlBuilderDataset = new SqlBuilder();
        sqlBuilderDataset.append("select fid,fnumber,fmodel,fbizmodelid from t_eb_dataset where ", new Object[0]);
        sqlBuilderDataset.appendIn("fmodel", modelIdArray);
        DataSet rowsDataset = ViewMemberUpgradeService.queryDatasetBySql(sqlBuilderDataset, "queryDataset");
        if (rowsDataset != null && !rowsDataset.isEmpty()) {
            while (rowsDataset.hasNext()) {
                Row row = rowsDataset.next();
                List datasets = datasetMapByModel.computeIfAbsent(row.getLong("fmodel"), k -> Lists.newArrayListWithExpectedSize((int)16));
                Dataset dataset = new Dataset(row.getLong("fid"), row.getString("fnumber"));
                dataset.setBusModelId(row.getLong("fbizmodelid").longValue());
                datasets.add(dataset);
                queryDatasetSet.add(row.getLong("fid"));
            }
        }
        return datasetMapByModel;
    }

    private static void updateViewMemberLongNumber(Map<Long, List<Member>> alreadyViewMemberMapByView, Map<Long, Integer> maxLevelMapByViewId, Map<Long, Map<Long, Long>> dimPresetViewByModelMap) {
        ArrayList<Object[]> viewMemberLongNumberUpdateParams = new ArrayList<Object[]>(16);
        HashSet presetViewSet = new HashSet(16);
        dimPresetViewByModelMap.forEach((tempModel, dimPresetView) -> presetViewSet.addAll(dimPresetView.values()));
        for (Map.Entry<Long, List<Member>> entry : alreadyViewMemberMapByView.entrySet()) {
            Long viewId = entry.getKey();
            List<Member> tempViewMembers = entry.getValue();
            if (presetViewSet.contains(viewId)) continue;
            HashMap<Long, String> longNumberMapByVid = new HashMap<Long, String>(tempViewMembers.size());
            Integer level = maxLevelMapByViewId.get(viewId);
            Map<Integer, List<Member>> grpViewMemberMap = tempViewMembers.stream().collect(Collectors.groupingBy(Member::getLevel));
            for (int integer = 1; integer <= level; ++integer) {
                List<Member> tempMembers = grpViewMemberMap.get(integer);
                if (CollectionUtils.isEmpty(tempMembers)) continue;
                if (integer == 1) {
                    for (Member member : tempMembers) {
                        member.setLongNumber(member.getNumber());
                        longNumberMapByVid.put(member.getId(), member.getLongNumber());
                        viewMemberLongNumberUpdateParams.add(new Object[]{member.getLongNumber(), member.getId()});
                    }
                    continue;
                }
                for (Member member : tempMembers) {
                    if (longNumberMapByVid.containsKey(member.getParentId())) {
                        member.setLongNumber((String)longNumberMapByVid.get(member.getParentId()) + "!" + member.getNumber());
                    }
                    longNumberMapByVid.put(member.getId(), member.getLongNumber());
                    viewMemberLongNumberUpdateParams.add(new Object[]{member.getLongNumber(), member.getId()});
                }
            }
        }
        ViewMemberUpgradeService.viewMemberLongNumberUpdateRows("t_eb_viewmember", viewMemberLongNumberUpdateParams);
    }

    private static void insertViewNotLeafMember(Map<Long, Map<Long, kd.epm.eb.common.model.Dimension>> dimensionMapByModel, Map<String, UpgradeDimensionViewMember> addMemberMapByNumber) {
        Map<Object, Object> newMemberByModelMap = new HashMap(16);
        if (!addMemberMapByNumber.isEmpty()) {
            newMemberByModelMap = addMemberMapByNumber.values().stream().collect(Collectors.groupingBy(DimensionViewMember::getModel));
        }
        HashMap<String, List> tableMembersMap = new HashMap<String, List>(16);
        for (Map.Entry entry : newMemberByModelMap.entrySet()) {
            Long tepModelId = (Long)entry.getKey();
            List tempMembers2 = (List)entry.getValue();
            Map<Long, kd.epm.eb.common.model.Dimension> tempDimensionMap = dimensionMapByModel.get(tepModelId);
            for (UpgradeDimensionViewMember member : tempMembers2) {
                kd.epm.eb.common.model.Dimension dimension = tempDimensionMap.get(member.getDimension());
                List members = tableMembersMap.computeIfAbsent(dimension.getMemberTable(), k -> Lists.newArrayListWithExpectedSize((int)16));
                members.add(member);
            }
        }
        tableMembersMap.forEach((table, tempMembers) -> {
            String longTableName = table + "_l";
            ArrayList<Object[]> memberInsertParams = new ArrayList<Object[]>(16);
            ArrayList<Object[]> memberLongInsertParams = new ArrayList<Object[]>(16);
            boolean entTable = table.equalsIgnoreCase("t_eb_structofent");
            boolean definedTable = table.equalsIgnoreCase("t_eb_structofdefined");
            boolean ctTable = table.equalsIgnoreCase("t_eb_structofchangetype");
            boolean icEntTable = table.equalsIgnoreCase("t_eb_structoficentity");
            String fieldStr = "fid,fnumber,fshownumber,fmodelid,fdimensionid,faggoprt,flevel,fseq,flongnumber,fisleaf,fmembersource,fparentid,fenable,fdisable,fcreatetime,fcreatorid,fmodifytime,fmodifierid,fstatus,fsyncstatus,fsyncdate,fdescription,fdisablerid,fdisabledate,fmasterid,fname";
            if (entTable) {
                fieldStr = fieldStr + ",fstoragetype,fcopyfrom,fisinnerorg,fisouterorg,fmergernode,fisoffsetentry,fcurrencyid,feffdate,fexpdate,fschemeid,fisexchangerate,forgcode,fowner,fexecutor,foffsetsource";
            }
            if (definedTable) {
                fieldStr = fieldStr + ",fsimplename,fstoragetype,fcopyfrom,fdatatype,fvalue,fisseq";
            }
            if (ctTable) {
                fieldStr = fieldStr + ",fsimplename,fstoragetype,fcopyfrom,fchangeway,fformula,fformulaname,fviewid,fdatatype,fisperioddistribution";
            }
            if (icEntTable) {
                fieldStr = fieldStr + ",fsimplename";
            }
            ViewMemberUpgradeService.getRootMemberByIds(table, tempMembers, entTable, definedTable, ctTable, fieldStr);
            for (UpgradeDimensionViewMember tempMember : tempMembers) {
                Date syncDate = tempMember.getSyncDate() == null ? null : tempMember.getSyncDate();
                String name = tempMember.getLocaleName() == null ? "_" : tempMember.getLocaleName();
                String simpleName = tempMember.getSimpleName() == null ? " " : tempMember.getLocaleSimpleName();
                String description = tempMember.getDescription() == null ? " " : tempMember.getDescription();
                Long disablerId = IDUtils.toLong((Object)tempMember.getDisablerId());
                Long masterId = IDUtils.toLong((Object)tempMember.getMasterId());
                String storageType = tempMember.getStorageType() == null ? "2" : tempMember.getStorageType();
                Long copyFrom = IDUtils.toLong((Object)tempMember.getCopyFrom());
                if (entTable) {
                    memberInsertParams.add(new Object[]{tempMember.getMemberId(), tempMember.getNumber(), tempMember.getShowNumber(), tempMember.getModel(), tempMember.getDimension(), tempMember.getAggOprtSign(), tempMember.getLevel(), tempMember.getDseq(), tempMember.getLongNumber(), tempMember.isLeaf(), tempMember.getMembersource(), tempMember.getParentId(), tempMember.isEnable(), tempMember.getDisable(), tempMember.getCreateTime(), tempMember.getCreatorId(), tempMember.getModifyDate(), tempMember.getModifier(), tempMember.getStatus(), tempMember.getSyncStatus(), syncDate, description, disablerId, tempMember.getDisableDate(), masterId, name, storageType, copyFrom, tempMember.getInnerOrg(), tempMember.getOuterOrg(), tempMember.getMergernode(), tempMember.getOffsetEntry(), IDUtils.toLong((Object)tempMember.getCurrency()), tempMember.getEffDate(), tempMember.getExpDate(), IDUtils.toLong((Object)tempMember.getSchemeId()), tempMember.getExchangeRate() == null ? "0" : tempMember.getExchangeRate(), tempMember.getOrgCode() == null ? " " : tempMember.getOrgCode(), IDUtils.toLong((Object)tempMember.getOwner()), IDUtils.toLong((Object)tempMember.getExecutor()), tempMember.getOffsetSource() == null ? " " : tempMember.getOffsetSource()});
                } else {
                    String datatype;
                    String string = datatype = tempMember.getDatatype() == null ? "0" : tempMember.getDatatype();
                    if (definedTable) {
                        memberInsertParams.add(new Object[]{tempMember.getMemberId(), tempMember.getNumber(), tempMember.getShowNumber(), tempMember.getModel(), tempMember.getDimension(), tempMember.getAggOprtSign(), tempMember.getLevel(), tempMember.getDseq(), tempMember.getLongNumber(), tempMember.isLeaf(), tempMember.getMembersource(), tempMember.getParentId(), tempMember.isEnable(), tempMember.getDisable(), tempMember.getCreateTime(), tempMember.getCreatorId(), tempMember.getModifyDate(), tempMember.getModifier(), tempMember.getStatus(), tempMember.getSyncStatus(), syncDate, description, disablerId, tempMember.getDisableDate(), masterId, name, simpleName, storageType, copyFrom, datatype, IDUtils.toLong((Object)tempMember.getValue()), tempMember.getDefinedSeq() == null ? "0" : tempMember.getDefinedSeq()});
                    } else if (ctTable) {
                        Long view = tempMember.getView();
                        if (view == null) {
                            view = 0L;
                        }
                        memberInsertParams.add(new Object[]{tempMember.getMemberId(), tempMember.getNumber(), tempMember.getShowNumber(), tempMember.getModel(), tempMember.getDimension(), tempMember.getAggOprtSign(), tempMember.getLevel(), tempMember.getDseq(), tempMember.getLongNumber(), tempMember.isLeaf(), tempMember.getMembersource(), tempMember.getParentId(), tempMember.isEnable(), tempMember.getDisable(), tempMember.getCreateTime(), tempMember.getCreatorId(), tempMember.getModifyDate(), tempMember.getModifier(), tempMember.getStatus(), tempMember.getSyncStatus(), syncDate, description, disablerId, tempMember.getDisableDate(), masterId, name, simpleName, storageType, copyFrom, tempMember.getChangeway(), tempMember.getFormula(), tempMember.getFormulaName(), view, datatype, tempMember.getPeriodDistribution()});
                    } else if (icEntTable) {
                        memberInsertParams.add(new Object[]{tempMember.getMemberId(), tempMember.getNumber(), tempMember.getShowNumber(), tempMember.getModel(), tempMember.getDimension(), tempMember.getAggOprtSign(), tempMember.getLevel(), tempMember.getDseq(), tempMember.getLongNumber(), tempMember.isLeaf(), tempMember.getMembersource(), tempMember.getParentId(), tempMember.isEnable(), tempMember.getDisable(), tempMember.getCreateTime(), tempMember.getCreatorId(), tempMember.getModifyDate(), tempMember.getModifier(), tempMember.getStatus(), tempMember.getSyncStatus(), syncDate, description, disablerId, tempMember.getDisableDate(), masterId, name, simpleName});
                    }
                }
                String[] idLa = DBServiceHelper.genStringIds((String)longTableName, (int)1);
                Object[] insertMemberLongGroup = new Object[]{idLa[0], tempMember.getMemberId(), "zh_CN", name, simpleName};
                memberLongInsertParams.add(insertMemberLongGroup);
            }
            ViewMemberUpgradeService.insertRows(fieldStr, table, memberInsertParams);
            ViewMemberUpgradeService.insertRows("fpkid,fid,flocaleid,fname,fsimplename", longTableName, memberLongInsertParams);
        });
    }

    private static void getRootMemberByIds(String table, List<UpgradeDimensionViewMember> tepMembers, boolean entTable, boolean definedTable, boolean ctTable, String fieldStr) {
        Map<Long, List<UpgradeDimensionViewMember>> grpSourceMemberMap = tepMembers.stream().collect(Collectors.groupingBy(UpgradeDimensionViewMember::getSourceMemberId));
        SqlBuilder sqlBuilderMember = new SqlBuilder();
        sqlBuilderMember.append("select ", new Object[0]).append(fieldStr, new Object[0]).append(" from ", new Object[0]).append(table, new Object[0]).append(" where ", new Object[0]);
        sqlBuilderMember.appendIn("fid", tepMembers.stream().map(UpgradeDimensionViewMember::getSourceMemberId).distinct().toArray());
        DataSet rowsMember = ViewMemberUpgradeService.queryDatasetBySql(sqlBuilderMember, "queryRootMem");
        if (rowsMember != null && !rowsMember.isEmpty()) {
            while (rowsMember.hasNext()) {
                Row row = rowsMember.next();
                Long id = row.getLong("fid");
                List<UpgradeDimensionViewMember> upgradeDimensionViewMembers = grpSourceMemberMap.get(id);
                if (CollectionUtils.isEmpty(upgradeDimensionViewMembers)) continue;
                for (UpgradeDimensionViewMember upgradeDimensionViewMember : upgradeDimensionViewMembers) {
                    upgradeDimensionViewMember.setDescription(row.getString("fdescription"));
                    upgradeDimensionViewMember.setDisablerId(row.getLong("fdisablerid"));
                    upgradeDimensionViewMember.setDisableDate(row.getDate("fdisabledate"));
                    upgradeDimensionViewMember.setMasterId(row.getLong("fmasterid"));
                    if (entTable) {
                        upgradeDimensionViewMember.setStorageType(row.getString("fstoragetype"));
                        upgradeDimensionViewMember.setCopyFrom(row.getLong("fcopyfrom"));
                        upgradeDimensionViewMember.setCurrency(row.getLong("fcurrencyid"));
                        upgradeDimensionViewMember.setEffDate(row.getDate("feffdate"));
                        upgradeDimensionViewMember.setExpDate(row.getDate("fexpdate"));
                        upgradeDimensionViewMember.setSchemeId(row.getLong("fschemeid"));
                        upgradeDimensionViewMember.setExchangeRate(row.getString("fisexchangerate"));
                        upgradeDimensionViewMember.setOrgCode(row.getString("forgcode"));
                        upgradeDimensionViewMember.setOwner(row.getLong("fowner"));
                        upgradeDimensionViewMember.setExecutor(row.getLong("fexecutor"));
                        upgradeDimensionViewMember.setOffsetSource(row.getString("foffsetsource"));
                    }
                    if (definedTable) {
                        upgradeDimensionViewMember.setStorageType(row.getString("fstoragetype"));
                        upgradeDimensionViewMember.setCopyFrom(row.getLong("fcopyfrom"));
                        upgradeDimensionViewMember.setDatatype(row.getString("fdatatype"));
                        upgradeDimensionViewMember.setValue(row.getLong("fvalue"));
                        upgradeDimensionViewMember.setDefinedSeq(row.getString("fisseq"));
                    }
                    if (!ctTable) continue;
                    upgradeDimensionViewMember.setStorageType(row.getString("fstoragetype"));
                    upgradeDimensionViewMember.setCopyFrom(row.getLong("fcopyfrom"));
                    upgradeDimensionViewMember.setChangeway(row.getString("fchangeway"));
                    upgradeDimensionViewMember.setFormula(row.getString("fformula"));
                    upgradeDimensionViewMember.setFormulaName(row.getString("fformulaname"));
                    upgradeDimensionViewMember.setDatatype(row.getString("fdatatype"));
                    upgradeDimensionViewMember.setPeriodDistribution(row.getString("fisperioddistribution"));
                }
            }
        }
    }

    private static void upgradeAnalViewMember(Map<Long, Map<Long, Map<String, Object>>> dimViewMapByBaseView, Map<Long, List<Long>> baseAnalViewMap, Map<Long, Map<Long, UpgradeDimensionViewMember>> allViewMemIdDimViewMemberMapByViewId, Map<Long, Map<Long, UpgradeDimensionViewMember>> allMemIdDimViewMemberMapByViewId, Map<String, UpgradeDimensionViewMember> addMemberMapByNumber, Map<Long, Set<Long>> changeIsLeafMap) {
        ArrayList<Long> allDelViewMemberList = new ArrayList<Long>(16);
        ArrayList<UpgradeDimensionViewMember> allInsertDimViewMemList = new ArrayList<UpgradeDimensionViewMember>(16);
        ArrayList<UpgradeDimensionViewMember> allUpdateAddRootParentDimViewMemList = new ArrayList<UpgradeDimensionViewMember>(16);
        ArrayList<UpgradeDimensionViewMember> allUpdateIsLeafAndShowChildrenDimViewMemList = new ArrayList<UpgradeDimensionViewMember>(16);
        ArrayList<Object> allUpdateRootNumberDimViewMemList = new ArrayList<Object>(16);
        ArrayList<UpgradeDimensionViewMember> allUpdateAddChildrenLevelDimViewMemList = new ArrayList<UpgradeDimensionViewMember>(16);
        for (Map.Entry<Long, List<Long>> entry : baseAnalViewMap.entrySet()) {
            Long baseViewId = entry.getKey();
            List<Long> list = entry.getValue();
            Map<Long, Map<String, Object>> map = dimViewMapByBaseView.get(baseViewId);
            Map<String, Object> baseView = map.get(baseViewId);
            if (baseView == null) continue;
            String source = (String)baseView.get("fsource");
            String baseViewNumber = (String)baseView.get("fnumber");
            Map<Long, UpgradeDimensionViewMember> baseDimViewMemberMapByMemId = allMemIdDimViewMemberMapByViewId.get(baseViewId);
            Map<Long, UpgradeDimensionViewMember> baseDimViewMemberMapByViewMemId = allViewMemIdDimViewMemberMapByViewId.get(baseViewId);
            if (baseDimViewMemberMapByMemId == null || baseDimViewMemberMapByViewMemId == null) continue;
            if (!"1".equals(source)) {
                List baseRoots = baseDimViewMemberMapByViewMemId.values().stream().filter(e -> e.getLevel() == 1).collect(Collectors.toList());
                UpgradeDimensionViewMember baseRootViewMember = (UpgradeDimensionViewMember)baseRoots.get(0);
                UpgradeDimensionViewMember upgradeDimensionViewMember = new UpgradeDimensionViewMember();
                String notLeafNumber = baseRootViewMember.getNumber() + "_" + baseViewNumber;
                upgradeDimensionViewMember.setNumber(notLeafNumber);
                UpgradeDimensionViewMember baseRootMember = ViewMemberUpgradeService.addNotLeafMember(baseDimViewMemberMapByMemId.get(baseRootViewMember.getMemberId()), notLeafNumber);
                upgradeDimensionViewMember.setMemberId(baseRootMember.getMemberId());
                upgradeDimensionViewMember.setViewMemberId(baseRootViewMember.getViewMemberId());
                addMemberMapByNumber.put(notLeafNumber, baseRootMember);
                allUpdateRootNumberDimViewMemList.add(upgradeDimensionViewMember);
            }
            for (Long anaView : list) {
                Map<String, Object> view;
                Map<Long, UpgradeDimensionViewMember> analDimViewMemberMapByMemId = allMemIdDimViewMemberMapByViewId.get(anaView);
                Map<Long, UpgradeDimensionViewMember> analDimViewMemberMapByViewMemId = allViewMemIdDimViewMemberMapByViewId.get(anaView);
                if (map == null || analDimViewMemberMapByMemId == null || analDimViewMemberMapByViewMemId == null || (view = map.get(anaView)) == null) continue;
                String viewNumber = (String)view.get("fnumber");
                HashSet<Long> delViewMemberSet = new HashSet<Long>(16);
                ArrayList<UpgradeDimensionViewMember> insertDimViewMemList = new ArrayList<UpgradeDimensionViewMember>(16);
                ArrayList<UpgradeDimensionViewMember> updateAddRootParentDimViewMemList = new ArrayList<UpgradeDimensionViewMember>(16);
                ArrayList<UpgradeDimensionViewMember> updateIsLeafAndShowChildrenDimViewMemList = new ArrayList<UpgradeDimensionViewMember>(16);
                ArrayList<UpgradeDimensionViewMember> updateRootNumberDimViewMemList = new ArrayList<UpgradeDimensionViewMember>(16);
                ArrayList<UpgradeDimensionViewMember> updateAddChildrenLevelDimViewMemList = new ArrayList<UpgradeDimensionViewMember>(16);
                HashSet<Long> hasCheckMemSet = new HashSet<Long>(16);
                HashSet<String> insertAnalViewMemNumberSet = new HashSet<String>(16);
                List analRoots = analDimViewMemberMapByViewMemId.values().stream().filter(e -> e.getLevel() == 1).collect(Collectors.toList());
                UpgradeDimensionViewMember analRootViewMember = (UpgradeDimensionViewMember)analRoots.get(0);
                String notLeafNumber = analRootViewMember.getNumber() + "_" + viewNumber;
                analRootViewMember.setNumber(notLeafNumber);
                UpgradeDimensionViewMember analRootMember = ViewMemberUpgradeService.addNotLeafMember(baseDimViewMemberMapByMemId.get(analRootViewMember.getMemberId()), notLeafNumber);
                addMemberMapByNumber.put(notLeafNumber, analRootMember);
                hasCheckMemSet.add(analRootViewMember.getMemberId());
                for (Map.Entry<Long, UpgradeDimensionViewMember> entry2 : baseDimViewMemberMapByMemId.entrySet()) {
                    UpgradeDimensionViewMember baseViewMember = entry2.getValue();
                    ViewMemberUpgradeService.checkAnalViewMemberByBaseView(analDimViewMemberMapByMemId, delViewMemberSet, insertDimViewMemList, updateAddRootParentDimViewMemList, updateIsLeafAndShowChildrenDimViewMemList, hasCheckMemSet, insertAnalViewMemNumberSet, analRootViewMember, baseViewMember, changeIsLeafMap, updateAddChildrenLevelDimViewMemList);
                }
                analRootViewMember.setMemberId(analRootMember.getMemberId());
                updateRootNumberDimViewMemList.add(analRootViewMember);
                if (CollectionUtils.isNotEmpty(updateAddRootParentDimViewMemList)) {
                    int maxSeq = 0;
                    List level2ViewMembers = analDimViewMemberMapByViewMemId.values().stream().filter(e -> e.getLevel() == 2).collect(Collectors.toList());
                    for (UpgradeDimensionViewMember viewMember : level2ViewMembers) {
                        if (viewMember.getDseq() <= maxSeq) continue;
                        maxSeq = viewMember.getDseq();
                    }
                    for (UpgradeDimensionViewMember viewMember : updateAddRootParentDimViewMemList) {
                        viewMember.setDseq(Integer.valueOf(++maxSeq));
                    }
                }
                allDelViewMemberList.addAll(delViewMemberSet);
                allInsertDimViewMemList.addAll(insertDimViewMemList);
                allUpdateIsLeafAndShowChildrenDimViewMemList.addAll(updateIsLeafAndShowChildrenDimViewMemList);
                allUpdateRootNumberDimViewMemList.addAll(updateRootNumberDimViewMemList);
                allUpdateAddRootParentDimViewMemList.addAll(updateAddRootParentDimViewMemList);
                allUpdateAddChildrenLevelDimViewMemList.addAll(updateAddChildrenLevelDimViewMemList);
            }
        }
        if (CollectionUtils.isNotEmpty(allDelViewMemberList)) {
            SqlBuilder sqlBuilderDelViewMem = new SqlBuilder();
            sqlBuilderDelViewMem.append("delete from t_eb_viewmember where ", new Object[0]);
            sqlBuilderDelViewMem.appendIn("fid", allDelViewMemberList.toArray());
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilderDelViewMem);
        }
        ArrayList<Object[]> viewMemberRootNumberParams = new ArrayList<Object[]>(16);
        for (Object dimensionViewMember : allUpdateRootNumberDimViewMemList) {
            viewMemberRootNumberParams.add(new Object[]{dimensionViewMember.getNumber(), dimensionViewMember.getMemberId(), dimensionViewMember.getViewMemberId()});
        }
        ViewMemberUpgradeService.viewMemberRootNumberUpdateRows("t_eb_viewmember", viewMemberRootNumberParams);
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(16);
        for (UpgradeDimensionViewMember upgradeDimensionViewMember : allUpdateIsLeafAndShowChildrenDimViewMemList) {
            arrayList.add(new Object[]{upgradeDimensionViewMember.isLeaf(), upgradeDimensionViewMember.isShowChildren(), upgradeDimensionViewMember.isShowSelf(), upgradeDimensionViewMember.getMergernode(), upgradeDimensionViewMember.getViewMemberId()});
        }
        ViewMemberUpgradeService.viewMemberIsLeafAndShowChildrenUpdateRows("t_eb_viewmember", arrayList);
        ArrayList<Object[]> viewMemberAddRootParentUpdateParams = new ArrayList<Object[]>(16);
        for (UpgradeDimensionViewMember upgradeDimensionViewMember : allUpdateAddRootParentDimViewMemList) {
            viewMemberAddRootParentUpdateParams.add(new Object[]{upgradeDimensionViewMember.getParentId(), upgradeDimensionViewMember.getLevel(), upgradeDimensionViewMember.getDseq(), upgradeDimensionViewMember.getViewMemberId()});
        }
        ViewMemberUpgradeService.viewMemberAddRootParentUpdateRows("t_eb_viewmember", viewMemberAddRootParentUpdateParams);
        ArrayList<Object[]> arrayList2 = new ArrayList<Object[]>(16);
        for (UpgradeDimensionViewMember dimensionViewMember : allUpdateAddChildrenLevelDimViewMemList) {
            arrayList2.add(new Object[]{dimensionViewMember.getLevel(), dimensionViewMember.getViewMemberId()});
        }
        ViewMemberUpgradeService.viewMemberAAddChildrenLevelUpdateRows("t_eb_viewmember", arrayList2);
        ArrayList<Object[]> arrayList3 = new ArrayList<Object[]>(16);
        for (UpgradeDimensionViewMember dimensionViewMember : allInsertDimViewMemList) {
            arrayList3.add(new Object[]{dimensionViewMember.getViewMemberId(), dimensionViewMember.getLocaleName(), dimensionViewMember.getNumber(), dimensionViewMember.getLocaleSimpleName(), dimensionViewMember.getShowNumber(), dimensionViewMember.getModel(), dimensionViewMember.getDimension(), dimensionViewMember.getMemberId(), dimensionViewMember.getView(), dimensionViewMember.getAggOprtSign(), dimensionViewMember.getLevel(), dimensionViewMember.getDseq(), dimensionViewMember.getLongNumber(), dimensionViewMember.isLeaf(), dimensionViewMember.getViewMembersource(), dimensionViewMember.getParentId(), dimensionViewMember.isEnable(), dimensionViewMember.getDisable(), dimensionViewMember.getModifyDate(), dimensionViewMember.getModifier(), dimensionViewMember.getStatus(), dimensionViewMember.isShowChildren(), dimensionViewMember.isShowSelf(), ViewMemberUpgradeService.getRefView(dimensionViewMember), dimensionViewMember.getInnerOrg(), dimensionViewMember.getOuterOrg(), dimensionViewMember.getSyncStatus(), dimensionViewMember.getSyncDate() == null ? null : dimensionViewMember.getSyncDate(), dimensionViewMember.getMergernode(), dimensionViewMember.getOffsetEntry()});
        }
        ViewMemberUpgradeService.insertRows(VIEW_MEMBER_FIELD, "t_eb_viewmember", arrayList3);
    }

    private static void checkAnalViewMemberByBaseView(Map<Long, UpgradeDimensionViewMember> analDimViewMemberMapByMemId, Set<Long> delViewMemberSet, List<UpgradeDimensionViewMember> insertDimViewMemList, List<UpgradeDimensionViewMember> updateAddRootParentDimViewMemList, List<UpgradeDimensionViewMember> updateIsLeafAndShowChildrenDimViewMemList, Set<Long> hasCheckSet, Set<String> insertAnalViewMemNumberSet, UpgradeDimensionViewMember analRootViewMember, UpgradeDimensionViewMember baseViewMember, Map<Long, Set<Long>> changeIsLeafMap, List<UpgradeDimensionViewMember> updateAddChildrenLevelDimViewMemList) {
        Long memberId = baseViewMember.getMemberId();
        if (hasCheckSet.contains(memberId)) {
            return;
        }
        hasCheckSet.add(memberId);
        UpgradeDimensionViewMember analViewMember = analDimViewMemberMapByMemId.get(memberId);
        if (analViewMember == null) {
            return;
        }
        if (insertAnalViewMemNumberSet.contains(analViewMember.getNumber())) {
            ViewMemberUpgradeService.handleAnalAllChildrenViewMember(delViewMemberSet, updateAddRootParentDimViewMemList, hasCheckSet, baseViewMember, analRootViewMember, changeIsLeafMap, analViewMember, true, updateAddChildrenLevelDimViewMemList);
            return;
        }
        if (!baseViewMember.isLeaf()) {
            if (!analViewMember.isLeaf()) {
                ViewMemberUpgradeService.handleAnalAllChildrenViewMember(delViewMemberSet, updateAddRootParentDimViewMemList, hasCheckSet, baseViewMember, analRootViewMember, changeIsLeafMap, analViewMember, false, updateAddChildrenLevelDimViewMemList);
            }
            ViewMemberUpgradeService.addAllBaseChildrenViewMemberToAnalView(insertDimViewMemList, updateIsLeafAndShowChildrenDimViewMemList, insertAnalViewMemNumberSet, baseViewMember, analViewMember, analViewMember.isLeaf(), delViewMemberSet);
        }
        if (CollectionUtils.isNotEmpty((Collection)baseViewMember.getChildren())) {
            for (UpgradeDimensionViewMember child : baseViewMember.getChildren()) {
                ViewMemberUpgradeService.checkAnalViewMemberByBaseView(analDimViewMemberMapByMemId, delViewMemberSet, insertDimViewMemList, updateAddRootParentDimViewMemList, updateIsLeafAndShowChildrenDimViewMemList, hasCheckSet, insertAnalViewMemNumberSet, analRootViewMember, child, changeIsLeafMap, updateAddChildrenLevelDimViewMemList);
            }
        }
    }

    private static void addAllBaseChildrenViewMemberToAnalView(List<UpgradeDimensionViewMember> insertDimViewMemList, List<UpgradeDimensionViewMember> updateIsLeafAndShowChildrenDimViewMemList, Set<String> insertAnalViewMemNumberSet, UpgradeDimensionViewMember baseViewMember, UpgradeDimensionViewMember analViewMember, boolean analLeaf, Set<Long> delViewMemberSet) {
        UpgradeDimensionViewMember updateIsLeafViewMember = new UpgradeDimensionViewMember();
        updateIsLeafViewMember.setViewMemberId(analViewMember.getViewMemberId());
        updateIsLeafViewMember.setIsLeaf(false);
        updateIsLeafViewMember.setShowChildren(!analLeaf);
        updateIsLeafViewMember.setShowSelf(true);
        updateIsLeafViewMember.setMergernode(baseViewMember.getMergernode());
        updateIsLeafAndShowChildrenDimViewMemList.add(updateIsLeafViewMember);
        if (CollectionUtils.isNotEmpty((Collection)baseViewMember.getAllChildrenMembers()) && CollectionUtils.isNotEmpty((Collection)analViewMember.getAllChildrenMembers())) {
            Set baseAllChildren = baseViewMember.getAllChildrenMembers().stream().map(DimensionViewMember::getNumber).collect(Collectors.toSet());
            Set delAnalChildren = analViewMember.getAllChildrenMembers().stream().filter(e -> baseAllChildren.contains(e.getNumber())).map(DimensionViewMember::getViewMemberId).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty(delAnalChildren)) {
                delViewMemberSet.addAll(delAnalChildren);
            }
        }
        for (UpgradeDimensionViewMember child : baseViewMember.getChildren()) {
            ViewMemberUpgradeService.addAllBaseViewChildrenViewMemberToAnalView(child, analViewMember.getView(), analViewMember, insertDimViewMemList, analViewMember.getLevel() + 1, insertAnalViewMemNumberSet, analLeaf);
        }
    }

    private static void handleAnalAllChildrenViewMember(Set<Long> delViewMemberSet, List<UpgradeDimensionViewMember> updateAddRootParentDimViewMemList, Set<Long> hasCheckSet, UpgradeDimensionViewMember baseViewMember, UpgradeDimensionViewMember analRootViewMember, Map<Long, Set<Long>> changeIsLeafMap, UpgradeDimensionViewMember analViewMember, boolean delSelf, List<UpgradeDimensionViewMember> updateAddChildrenLevelDimViewMemList) {
        List baseAllMembers = baseViewMember.getAllMembers();
        Set baseAllMemNumSet = baseAllMembers.stream().map(DimensionViewMember::getNumber).collect(Collectors.toSet());
        List analAllMembers = analViewMember.getAllMembers();
        HashSet<String> notDelChildrenViewMemNumSet = new HashSet<String>(16);
        for (UpgradeDimensionViewMember viewMember : analAllMembers) {
            if (!delSelf && analViewMember.getViewMemberId().equals(viewMember.getViewMemberId()) || !viewMember.getViewMembersource().equals(ViewMemberSourceEnum.ADD.getIndex())) continue;
            viewMember.setParentId(analRootViewMember.getViewMemberId());
            int levelSub = viewMember.getLevel() - analRootViewMember.getLevel() - 1;
            viewMember.setLevel(viewMember.getLevel() - levelSub);
            updateAddRootParentDimViewMemList.add(viewMember);
            List allChildrenViewMembers = viewMember.getAllChildrenMembers();
            List notDelChildrenViewMembers = allChildrenViewMembers.stream().filter(e -> !baseAllMemNumSet.contains(e.getNumber())).collect(Collectors.toList());
            for (UpgradeDimensionViewMember notDelChildrenViewMember : notDelChildrenViewMembers) {
                notDelChildrenViewMember.setLevel(notDelChildrenViewMember.getLevel() - levelSub);
                updateAddChildrenLevelDimViewMemList.add(notDelChildrenViewMember);
                notDelChildrenViewMemNumSet.add(notDelChildrenViewMember.getNumber());
            }
        }
        for (UpgradeDimensionViewMember viewMember : analAllMembers) {
            if (!delSelf && analViewMember.getViewMemberId().equals(viewMember.getViewMemberId()) || viewMember.getViewMembersource().equals(ViewMemberSourceEnum.ADD.getIndex()) || notDelChildrenViewMemNumSet.contains(viewMember.getNumber())) continue;
            delViewMemberSet.add(viewMember.getViewMemberId());
            Set changeIsLeafSet = changeIsLeafMap.computeIfAbsent(analViewMember.getView(), k -> Sets.newHashSetWithExpectedSize((int)16));
            changeIsLeafSet.add(viewMember.getParentId());
            hasCheckSet.add(viewMember.getMemberId());
        }
    }

    private static UpgradeDimensionViewMember addAllBaseViewChildrenViewMemberToAnalView(UpgradeDimensionViewMember baseViewMember, Long viewId, UpgradeDimensionViewMember prentViewMem, List<UpgradeDimensionViewMember> insertDimViewMemList, Integer level, Set<String> insertAnalViewMemNumberSet, boolean analLeaf) {
        UpgradeDimensionViewMember dimensionViewMember = new UpgradeDimensionViewMember();
        dimensionViewMember.setViewMemberId(Long.valueOf(GlobalIdUtil.genGlobalLongId()));
        dimensionViewMember.setName(baseViewMember.getName());
        dimensionViewMember.setNumber(baseViewMember.getNumber());
        dimensionViewMember.setMemberId(baseViewMember.getMemberId());
        dimensionViewMember.setLongNumber(baseViewMember.getLongNumber());
        dimensionViewMember.setViewMembersource(ViewMemberSourceEnum.INNER_REF.getIndex());
        dimensionViewMember.setRefview(baseViewMember.getView());
        dimensionViewMember.setSimpleName(baseViewMember.getSimpleName());
        dimensionViewMember.setShowNumber(baseViewMember.getShowNumber());
        dimensionViewMember.setModel(baseViewMember.getModel());
        dimensionViewMember.setDimension(baseViewMember.getDimension());
        dimensionViewMember.setView(viewId);
        dimensionViewMember.setAggOprtSign(baseViewMember.getAggOprtSign());
        dimensionViewMember.setLevel(level);
        dimensionViewMember.setDseq(baseViewMember.getDseq());
        dimensionViewMember.setIsLeaf(baseViewMember.isLeaf());
        long parentId = prentViewMem == null ? 0L : prentViewMem.getViewMemberId();
        dimensionViewMember.setParentId(Long.valueOf(parentId));
        dimensionViewMember.setEnable(baseViewMember.isEnable());
        dimensionViewMember.setDisable(baseViewMember.getDisable());
        dimensionViewMember.setStatus(baseViewMember.getStatus());
        dimensionViewMember.setInnerOrg(baseViewMember.getInnerOrg());
        dimensionViewMember.setOuterOrg(baseViewMember.getOuterOrg());
        dimensionViewMember.setSyncStatus(baseViewMember.getSyncStatus());
        dimensionViewMember.setSyncDate(baseViewMember.getSyncDate());
        dimensionViewMember.setModifier(baseViewMember.getModifier());
        dimensionViewMember.setModifyDate(baseViewMember.getModifyDate());
        dimensionViewMember.setInnerOrg(baseViewMember.getInnerOrg());
        dimensionViewMember.setOuterOrg(baseViewMember.getOuterOrg());
        dimensionViewMember.setMergernode(baseViewMember.getMergernode());
        dimensionViewMember.setOffsetEntry(baseViewMember.getOffsetEntry());
        dimensionViewMember.setShowChildren(!analLeaf);
        dimensionViewMember.setShowSelf(!analLeaf);
        insertDimViewMemList.add(dimensionViewMember);
        insertAnalViewMemNumberSet.add(baseViewMember.getNumber());
        if (CollectionUtils.isNotEmpty((Collection)baseViewMember.getChildren())) {
            for (UpgradeDimensionViewMember child : baseViewMember.getChildren()) {
                ViewMemberUpgradeService.addAllBaseViewChildrenViewMemberToAnalView(child, viewId, dimensionViewMember, insertDimViewMemList, dimensionViewMember.getLevel() + 1, insertAnalViewMemNumberSet, analLeaf);
            }
        }
        return dimensionViewMember;
    }

    private static Map<Long, List<UpgradeDimensionViewMember>> getDimensionViewMemberMap(Object[] modelIdArray) {
        SqlBuilder sqlBuilderViewMem = new SqlBuilder();
        sqlBuilderViewMem.append("select fid,fname,fnumber,fsimplename,fshownumber,fmodelid,fdimensionid,fmemberid,fviewid,faggoprt,flevel,fdseq,flongnumber,fisleaf,fmembersource,fparentid,fenable,fdisable,fmodifydate,fmodifier,fstatus,fshowchildren,fshowself,fisinnerorg,fisouterorg,fsyncstatus,fsyncdate,fmodifydate,fmodifier,frefview,fmergernode,fisoffsetentry from t_eb_viewmember where ", new Object[0]);
        sqlBuilderViewMem.appendIn("fmodelid", modelIdArray);
        sqlBuilderViewMem.append("order by flevel,fdseq", new Object[0]);
        DataSet rowsViewMem = ViewMemberUpgradeService.queryDatasetBySql(sqlBuilderViewMem, "queryViewMem");
        HashMap<Long, List<UpgradeDimensionViewMember>> dimViewMemberMapByViewId = new HashMap<Long, List<UpgradeDimensionViewMember>>(16);
        if (rowsViewMem != null && !rowsViewMem.isEmpty()) {
            while (rowsViewMem.hasNext()) {
                Row row = rowsViewMem.next();
                Long viewId = row.getLong("fviewid");
                List dimViewMembers = dimViewMemberMapByViewId.computeIfAbsent(viewId, k -> Lists.newArrayListWithExpectedSize((int)16));
                UpgradeDimensionViewMember dimViewMember = new UpgradeDimensionViewMember();
                dimViewMember.setViewMemberId(row.getLong("fid"));
                dimViewMember.setName(row.getString("fname"));
                dimViewMember.setNumber(row.getString("fnumber"));
                dimViewMember.setSimpleName(row.getString("fsimplename"));
                dimViewMember.setShowNumber(row.getString("fshownumber"));
                dimViewMember.setModel(row.getLong("fmodelid"));
                dimViewMember.setDimension(row.getLong("fdimensionid"));
                dimViewMember.setMemberId(row.getLong("fmemberid"));
                dimViewMember.setView(row.getLong("fviewid"));
                dimViewMember.setAggOprtSign(row.getString("faggoprt"));
                dimViewMember.setLevel(row.getInteger("flevel"));
                dimViewMember.setDseq(row.getInteger("fdseq"));
                dimViewMember.setLongNumber(row.getString("flongnumber"));
                dimViewMember.setIsLeaf(row.getBoolean("fisleaf").booleanValue());
                dimViewMember.setViewMembersource(row.getString("fmembersource"));
                dimViewMember.setParentId(row.getLong("fparentid"));
                dimViewMember.setEnable(row.getString("fenable"));
                dimViewMember.setDisable(row.getString("fdisable"));
                dimViewMember.setStatus(row.getString("fstatus"));
                dimViewMember.setShowChildren(row.getBoolean("fshowchildren").booleanValue());
                dimViewMember.setShowSelf(row.getBoolean("fshowself").booleanValue());
                dimViewMember.setInnerOrg(row.getString("fisinnerorg"));
                dimViewMember.setOuterOrg(row.getString("fisouterorg"));
                dimViewMember.setSyncStatus(row.getString("fsyncstatus"));
                dimViewMember.setSyncDate(row.getDate("fsyncdate"));
                dimViewMember.setModifyDate(row.getDate("fmodifydate"));
                dimViewMember.setModifier(row.getLong("fmodifier"));
                Long refView = row.getLong("frefview");
                if (refView == null) {
                    refView = 0L;
                }
                dimViewMember.setRefview(refView);
                dimViewMember.setMergernode(row.getString("fmergernode"));
                dimViewMember.setOffsetEntry(row.getString("fisoffsetentry"));
                dimViewMembers.add(dimViewMember);
            }
        }
        return dimViewMemberMapByViewId;
    }

    private static void insertPresetViewMember(Object[] modelIdArray, Map<Long, Map<Long, Long>> dimPresetViewByModelMap) {
        ArrayList<Object[]> insertViewMemberList = new ArrayList<Object[]>(16);
        ArrayList needUpdateMemberTables = Lists.newArrayList((Object[])new String[]{SysDimensionEnum.Entity.getMemberTreetable(), SysDimensionEnum.InternalCompany.getMemberTreetable(), "t_eb_structofdefined"});
        for (String needUpdateMemTable : needUpdateMemberTables) {
            ArrayList<Object[]> tempSave = new ArrayList<Object[]>(16);
            HashMap<Long, Long> memViewMap = new HashMap<Long, Long>(16);
            String updateMemberLongTable = needUpdateMemTable + "_l";
            String field = "a.fid id,b.fname fname,a.fnumber fnumber,b.fsimplename simplename,a.fmodelid modelid,a.fdimensionid dimensionid,a.fshownumber shownumber,a.flongnumber longnumber,a.fparentid parentid,a.faggoprt aggoprt,a.flevel flevel,a.fseq seq,a.fmembersource membersource,a.fdisable fdisable,a.fenable fenable,a.fisleaf isleaf,a.fsyncstatus syncstatus,a.fsyncdate syncdate,a.fmodifytime modifytime,a.fmodifierid modifierid";
            SqlBuilder sqlBuilderBaseMember = new SqlBuilder();
            sqlBuilderBaseMember.append("select ", new Object[0]).append(field, new Object[0]);
            boolean entTable = needUpdateMemTable.equalsIgnoreCase("t_eb_structofent");
            if (entTable) {
                sqlBuilderBaseMember.append(",a.fisinnerorg innerorg,a.fisouterorg outerorg,a.fmergernode mergernode,a.fisoffsetentry offsetentry", new Object[0]);
            }
            sqlBuilderBaseMember.append(" from ", new Object[0]).append(needUpdateMemTable, new Object[0]).append(" a left join ", new Object[0]).append(updateMemberLongTable, new Object[0]).append(" b on b.fid = a.fid and b.flocaleid = 'zh_CN' where ", new Object[0]);
            sqlBuilderBaseMember.appendIn("a.fmodelid", modelIdArray);
            sqlBuilderBaseMember.append(" and a.fmembersource != '5'", new Object[0]);
            DataSet rowsBaseMember = ViewMemberUpgradeService.queryDatasetBySql(sqlBuilderBaseMember, "queryBaseMember");
            if (rowsBaseMember == null || rowsBaseMember.isEmpty()) continue;
            while (rowsBaseMember.hasNext()) {
                Row row = rowsBaseMember.next();
                Long modelId = row.getLong("modelid");
                Map<Long, Long> tepDimPresetViewMap = dimPresetViewByModelMap.get(modelId);
                Long dimensionId = row.getLong("dimensionid");
                Object[] updateViewMemEntry = new Object[30];
                long viewMemId = GlobalIdUtil.genGlobalLongId();
                Long memId = row.getLong("id");
                memViewMap.put(memId, viewMemId);
                updateViewMemEntry[0] = viewMemId;
                updateViewMemEntry[1] = StringUtils.isEmpty((String)row.getString("fname")) ? "_" : row.getString("fname");
                updateViewMemEntry[2] = row.getString("fnumber");
                updateViewMemEntry[3] = StringUtils.isEmpty((String)row.getString("simplename")) ? " " : row.getString("simplename");
                updateViewMemEntry[4] = row.getString("shownumber");
                updateViewMemEntry[5] = modelId;
                updateViewMemEntry[6] = dimensionId;
                updateViewMemEntry[7] = memId;
                updateViewMemEntry[8] = tepDimPresetViewMap != null && tepDimPresetViewMap.containsKey(dimensionId) ? tepDimPresetViewMap.get(dimensionId) : Long.valueOf(0L);
                updateViewMemEntry[9] = row.getString("aggoprt");
                updateViewMemEntry[10] = row.getInteger("flevel");
                updateViewMemEntry[11] = row.getInteger("seq");
                updateViewMemEntry[12] = row.getString("longnumber");
                updateViewMemEntry[13] = row.getBoolean("isleaf");
                String memberSource = row.getString("membersource");
                updateViewMemEntry[14] = memberSource.equals(MemberSourceEnum.PRESET.getIndex()) ? ViewMemberSourceEnum.PRESET.getIndex() : ViewMemberSourceEnum.ADD.getIndex();
                updateViewMemEntry[15] = row.getLong("parentid");
                updateViewMemEntry[16] = row.getBoolean("fenable");
                updateViewMemEntry[17] = row.getBoolean("fdisable");
                updateViewMemEntry[18] = row.getDate("modifytime");
                updateViewMemEntry[19] = row.getLong("modifierid");
                updateViewMemEntry[20] = "C";
                updateViewMemEntry[21] = "1";
                updateViewMemEntry[22] = "1";
                updateViewMemEntry[23] = 0L;
                if (entTable) {
                    updateViewMemEntry[24] = row.getBoolean("innerorg");
                    updateViewMemEntry[25] = row.getBoolean("outerorg");
                    updateViewMemEntry[28] = row.getBoolean("mergernode");
                    updateViewMemEntry[29] = row.getBoolean("offsetentry");
                } else {
                    updateViewMemEntry[24] = Character.valueOf('0');
                    updateViewMemEntry[25] = Character.valueOf('0');
                    updateViewMemEntry[28] = Character.valueOf('0');
                    updateViewMemEntry[29] = Character.valueOf('0');
                }
                updateViewMemEntry[26] = row.getString("syncstatus");
                updateViewMemEntry[27] = row.getDate("syncdate") == null ? null : row.getDate("syncdate");
                tempSave.add(updateViewMemEntry);
            }
            for (Object[] viewMem : tempSave) {
                Long parent = (Long)viewMem[15];
                viewMem[15] = memViewMap.get(parent) == null ? Long.valueOf(0L) : memViewMap.get(parent);
            }
            insertViewMemberList.addAll(tempSave);
        }
        ViewMemberUpgradeService.insertRows(VIEW_MEMBER_FIELD, "t_eb_viewmember", insertViewMemberList);
    }

    private static Map<Long, Map<Long, Long>> insertBusinessModelViewGroup(Object[] modelIdArray, Map<Long, Long> viewGroupMap) {
        HashMap<Long, Map<Long, Long>> bizModelRefDimView = new HashMap<Long, Map<Long, Long>>(16);
        SqlBuilder sqlBuilderViewEntry = new SqlBuilder();
        sqlBuilderViewEntry.append("select fid,fdimensionid,fviewid from t_eb_viewentry where fid in (select fid from t_eb_businessmodel where ", new Object[0]);
        sqlBuilderViewEntry.appendIn("fmodelid", modelIdArray);
        sqlBuilderViewEntry.append(")", new Object[0]);
        DataSet rowsViewEntry = ViewMemberUpgradeService.queryDatasetBySql(sqlBuilderViewEntry, "queryViewEntry");
        if (rowsViewEntry != null && !rowsViewEntry.isEmpty()) {
            ArrayList<Object[]> updateViewEntryList = new ArrayList<Object[]>(16);
            while (rowsViewEntry.hasNext()) {
                Row row = rowsViewEntry.next();
                Long viewId = row.getLong("fviewid");
                if (!viewGroupMap.containsKey(viewId)) continue;
                Object[] updateViewEntry = new Object[]{viewGroupMap.get(viewId), viewId};
                updateViewEntryList.add(updateViewEntry);
                bizModelRefDimView.computeIfAbsent(row.getLong("fid"), key -> new HashMap(16)).put(row.getLong("fdimensionid"), viewId);
            }
            ViewMemberUpgradeService.viewEntryUpdateRowsByViewId("t_eb_viewentry", updateViewEntryList);
        }
        return bizModelRefDimView;
    }

    private static void insertDimensionViewGroup(Map<Long, Map<Long, Map<String, Object>>> dimViewMapByBaseView, Map<Long, Long> viewGroupMap, Map<Long, Map<Long, kd.epm.eb.common.model.Dimension>> dimensionMapByModel) {
        if (!dimViewMapByBaseView.isEmpty()) {
            ArrayList<Object[]> insertViewGroupList = new ArrayList<Object[]>(16);
            ArrayList<Object[]> insertViewGroupLongList = new ArrayList<Object[]>(16);
            ArrayList<Object[]> updateDimViewList = new ArrayList<Object[]>(16);
            HashSet localeIdSet = Sets.newHashSet((Object[])new String[]{"zh_CN", "en_US", "zh_TW"});
            Lang currLang = RequestContext.get().getLang();
            for (Map.Entry<Long, Map<Long, Map<String, Object>>> dimViewEntry : dimViewMapByBaseView.entrySet()) {
                DimensionViewGroupEnum viewGroupEnum;
                Object userId;
                Long defaultViewId = dimViewEntry.getKey();
                Map<Long, Map<String, Object>> dimViews = dimViewEntry.getValue();
                Map<String, Object> defaultView = dimViews.get(defaultViewId);
                long viewGroupId = GlobalIdUtil.genGlobalLongId();
                viewGroupMap.put(defaultViewId, viewGroupId);
                Object[] insertViewGroup = new Object[13];
                insertViewGroup[0] = viewGroupId;
                insertViewGroup[3] = "1";
                insertViewGroup[4] = defaultView.get("fid");
                Long modelId = (Long)defaultView.get("fmodelid");
                insertViewGroup[5] = modelId;
                Long dimensionId = (Long)defaultView.get("fdimensionid");
                insertViewGroup[6] = dimensionId;
                insertViewGroup[7] = userId = defaultView.get("fmodifierid");
                Date now = TimeServiceHelper.now();
                insertViewGroup[8] = now;
                insertViewGroup[9] = userId;
                insertViewGroup[10] = now;
                String defaultViewName = (String)defaultView.get("fname");
                LocaleString localeString = new LocaleString();
                Object localeName = defaultView.get("localename");
                if (localeName instanceof LocaleString) {
                    localeString = (LocaleString)localeName;
                }
                if (StringUtils.isEmpty((String)defaultViewName) && StringUtils.isEmpty((String)(defaultViewName = (String)localeString.get((Object)currLang.name())))) {
                    defaultViewName = (String)localeString.get((Object)Lang.zh_CN.name());
                }
                String viewGroupName = LanguageUtils.getLocaleValue((String)ResManager.loadResFormat((String)"%1\u89c6\u56fe\u7ec4", (String)"ViewMemberUpgradeService_0", (String)"epm-eb-business", (Object[])new Object[]{defaultViewName}), (String)"ViewMemberUpgradeService_0", (String)"epm-eb-business").getLocaleValue();
                kd.epm.eb.common.model.Dimension dimension = dimensionMapByModel.get(modelId).get(dimensionId);
                String viewGroupNumber = dimension.getShortNumber() + "_" + defaultView.get("fnumber") + "_viewGroup";
                if (defaultView.get("fsource").toString().equals("1")) {
                    insertViewGroup[11] = "1";
                    viewGroupEnum = DimensionViewGroupEnum.getByDimNumber((String)dimension.getNumber());
                    if (viewGroupEnum != null) {
                        viewGroupName = LanguageUtils.getLocaleValue((String)viewGroupEnum.getName(), (String)viewGroupEnum.getNameKey().getResourceID(), (String)"epm-eb-common").getLocaleValue();
                        viewGroupNumber = viewGroupEnum.getNumber();
                    }
                } else {
                    insertViewGroup[11] = "0";
                }
                insertViewGroup[1] = viewGroupNumber;
                insertViewGroup[2] = viewGroupName;
                insertViewGroup[12] = 0L;
                insertViewGroupList.add(insertViewGroup);
                viewGroupEnum = DimensionViewGroupEnum.getByDimNumber((String)dimension.getNumber());
                for (String string : localeIdSet) {
                    String localeNameStr = defaultViewName;
                    if (StringUtils.isNotEmpty((String)((String)localeString.get((Object)string)))) {
                        localeNameStr = (String)localeString.get((Object)string);
                    } else {
                        boolean isHandle;
                        boolean bl = isHandle = string.equals(currLang.name()) || string.equals(Lang.zh_CN.name());
                        if (!isHandle) continue;
                    }
                    String[] idLa = DBServiceHelper.genStringIds((String)"t_eb_dimensionview_group_l", (int)1);
                    Object[] insertViewLongGroup = new Object[4];
                    insertViewLongGroup[0] = idLa[0];
                    insertViewLongGroup[1] = viewGroupId;
                    insertViewLongGroup[2] = string;
                    LocaleString localeValue = LanguageUtils.getLocaleValue((String)ResManager.loadResFormat((String)"%1\u89c6\u56fe\u7ec4", (String)"ViewMemberUpgradeService_0", (String)"epm-eb-business", (Object[])new Object[]{localeNameStr}), (String)"ViewMemberUpgradeService_0", (String)"epm-eb-business");
                    String viewGroupLongName = (String)localeValue.get((Object)string);
                    if (defaultView.get("fsource").toString().equals("1") && viewGroupEnum != null) {
                        LocaleString localeValuePreset = LanguageUtils.getLocaleValue((String)viewGroupEnum.getName(), (String)viewGroupEnum.getNameKey().getResourceID(), (String)"epm-eb-common");
                        viewGroupLongName = (String)localeValuePreset.get((Object)string);
                    }
                    insertViewLongGroup[3] = viewGroupLongName;
                    insertViewGroupLongList.add(insertViewLongGroup);
                }
                for (Map map : dimViews.values()) {
                    Object[] updateDimView = new Object[]{viewGroupId, map.get("fid")};
                    updateDimViewList.add(updateDimView);
                }
            }
            ViewMemberUpgradeService.insertRows("fid,fnumber,fname,ftype,fdefaultview,fmodelid,fdimensionid,fcreatorid,fcreatetime,fmodifierid,fmodifytime,fsource,fparentid", "t_eb_dimensionview_group", insertViewGroupList);
            ViewMemberUpgradeService.insertRows("fpkid,fid,flocaleid,fname", "t_eb_dimensionview_group_l", insertViewGroupLongList);
            ViewMemberUpgradeService.dimViewUpdateRows("t_eb_dimensionview", updateDimViewList);
        }
    }

    private static Map<Long, Map<Long, kd.epm.eb.common.model.Dimension>> getDimensionMapByModel(Object[] modelIdArray, Map<Long, Long> ctDimensionMapByModel) {
        HashMap<Long, Map<Long, kd.epm.eb.common.model.Dimension>> dimensionMapByModel = new HashMap<Long, Map<Long, kd.epm.eb.common.model.Dimension>>(16);
        HashSet hasViewSysDimSet = Sets.newHashSet((Object[])new String[]{SysDimensionEnum.Entity.getNumber(), SysDimensionEnum.InternalCompany.getNumber(), SysDimensionEnum.ChangeType.getNumber()});
        SqlBuilder sqlBuilderDim = new SqlBuilder();
        sqlBuilderDim.append("select fid,fname,fnumber,fissysdimension,fmodelid,fmembermodel,fmembertable,fshortnumber from t_eb_dimension where ", new Object[0]);
        sqlBuilderDim.appendIn("fmodelid", modelIdArray);
        DataSet rowsDim = ViewMemberUpgradeService.queryDatasetBySql(sqlBuilderDim, "queryDim");
        if (rowsDim != null && !rowsDim.isEmpty()) {
            while (rowsDim.hasNext()) {
                Row row = rowsDim.next();
                Long modelId = row.getLong("fmodelid");
                String number = row.getString("fnumber");
                Long id = row.getLong("fid");
                if (!row.getBoolean("fissysdimension").booleanValue() || hasViewSysDimSet.contains(number)) {
                    Map dimensionMap = dimensionMapByModel.computeIfAbsent(modelId, k -> Maps.newHashMapWithExpectedSize((int)16));
                    kd.epm.eb.common.model.Dimension dimension = new kd.epm.eb.common.model.Dimension(id, row.getString("fname"), number);
                    dimension.setMemberModel(row.getString("fmembermodel"));
                    dimension.setMemberTable(row.getString("fmembertable"));
                    dimension.setShortNumber(row.getString("fshortnumber"));
                    dimension.setSysDim(row.getBoolean("fissysdimension").booleanValue());
                    dimensionMap.put(id, dimension);
                }
                if (!SysDimensionEnum.ChangeType.getNumber().equals(number)) continue;
                ctDimensionMapByModel.put(modelId, id);
            }
        }
        return dimensionMapByModel;
    }

    private static void updateShowNumberByModelIdArray(Object[] modelIdArray) {
        SysDimensionEnum[] values = SysDimensionEnum.values();
        List updateTables = Arrays.stream(values).map(SysDimensionEnum::getMemberTreetable).collect(Collectors.toList());
        updateTables.add("t_eb_viewmember");
        for (String updateTable : updateTables) {
            if (StringUtils.isEmpty((String)updateTable)) continue;
            SqlBuilder sqlBuilderUpdateShowNumber = new SqlBuilder();
            sqlBuilderUpdateShowNumber.append("update", new Object[0]).append(updateTable, new Object[0]).append("set fshownumber = fnumber where", new Object[0]).appendIn("fmodelid", modelIdArray).append("and fshownumber = ' '", new Object[0]);
            ViewMemberUpgradeService.updateShowNumber(sqlBuilderUpdateShowNumber);
        }
    }

    private static void updateShowNumber(SqlBuilder sqlBuilderUpdateShowNumber) {
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilderUpdateShowNumber);
    }

    private static UpgradeViewResult queryModelById(List<Long> modelIds, List<Long> upgradeModelIds, Map<Long, Model> modelMap) {
        UpgradeViewResult result;
        block7: {
            block8: {
                result = new UpgradeViewResult();
                result.setMessage(SUCCESS);
                if (!CollectionUtils.isNotEmpty(modelIds)) break block8;
                Object[] modelArray = modelIds.toArray();
                SqlBuilder sqlBuilderModel = new SqlBuilder();
                sqlBuilderModel.append("select fid,fdatasource,freporttype,fshownumber from t_eb_model where", new Object[0]);
                sqlBuilderModel.appendIn("fid", modelArray);
                DataSet rowsModel = ViewMemberUpgradeService.queryDatasetBySql(sqlBuilderModel, "queryBatchModel");
                if (rowsModel != null && !rowsModel.isEmpty()) {
                    while (rowsModel.hasNext()) {
                        Row row = rowsModel.next();
                        ViewMemberUpgradeService.setModelByRow(upgradeModelIds, modelMap, row);
                    }
                }
                SqlBuilder sqlBuilderPreSetViewGroup = new SqlBuilder();
                sqlBuilderPreSetViewGroup.append("select a.fviewgroupid viewgroupid,b.fmodelid modelid,b.fid bussmodelid from t_eb_viewentry a left join t_eb_businessmodel b on a.fid = b.fid where", new Object[0]);
                sqlBuilderPreSetViewGroup.appendIn("b.fmodelid", modelArray);
                DataSet rows = ViewMemberUpgradeService.queryDatasetBySql(sqlBuilderPreSetViewGroup, "queryBusinessViewGroup");
                HashMap<Long, Map> viewGroupIdMapByModel = new HashMap<Long, Map>(16);
                if (rows != null && !rows.isEmpty()) {
                    while (rows.hasNext()) {
                        Row row = rows.next();
                        Long viewGroupId = row.getLong("viewgroupid");
                        Long tempModelId = row.getLong("modelid");
                        Long tempBussModelId = row.getLong("bussmodelid");
                        Map viewGroupIdMapByBussModel = viewGroupIdMapByModel.computeIfAbsent(tempModelId, k -> Maps.newHashMapWithExpectedSize((int)16));
                        Set viewGroupIdSet = viewGroupIdMapByBussModel.computeIfAbsent(tempBussModelId, k -> Sets.newHashSetWithExpectedSize((int)16));
                        if (!IDUtils.isNotEmptyLong((Long)viewGroupId).booleanValue()) continue;
                        viewGroupIdSet.add(viewGroupId);
                    }
                }
                for (Map.Entry entry : viewGroupIdMapByModel.entrySet()) {
                    Long tempModel = (Long)entry.getKey();
                    boolean alreadyUpgrade = true;
                    for (Map.Entry setEntry : ((Map)entry.getValue()).entrySet()) {
                        if (!CollectionUtils.isEmpty((Collection)((Collection)setEntry.getValue()))) continue;
                        alreadyUpgrade = false;
                        break;
                    }
                    if (!alreadyUpgrade) continue;
                    result.getAlreadyUpgradeModel().add(modelMap.get(tempModel));
                }
                break block7;
            }
            String modelSql = "select fid,fdatasource,freporttype,fshownumber from t_eb_model where freporttype !='4' order by fmodifytime desc";
            DataSet rows = DB.queryDataSet((String)"queryModel", (DBRoute)DBRoute.of((String)"epm"), (String)modelSql);
            if (rows == null || rows.isEmpty()) break block7;
            while (rows.hasNext()) {
                Row row = rows.next();
                ViewMemberUpgradeService.setModelByRow(upgradeModelIds, modelMap, row);
                if (upgradeModelIds.size() < 20) continue;
                break;
            }
        }
        return result;
    }

    private static void backupHistoryData(Long modelId, String format) {
        log.info("view_member_upgrade_backupModel:" + modelId + "_time:" + format);
        Object[] modelArray = Collections.singletonList(modelId).toArray();
        ArrayList srcTables = Lists.newArrayList((Object[])new String[]{"t_eb_viewmember", "t_eb_structofent", "t_eb_structofent_l", "t_eb_structoficentity", "t_eb_structoficentity_l", "t_eb_structofchangetype", "t_eb_structofchangetype_l", "t_eb_structofdefined", "t_eb_structofdefined_l", "t_eb_dimensionview", "t_eb_viewentry", "t_eb_dimensionview_group", "t_eb_dimensionview_group_l"});
        ArrayList backTables = Lists.newArrayList((Object[])new String[]{"t_eb_vm_" + format, "t_eb_ent_" + format, "t_eb_entl_" + format, "t_eb_icent_" + format, "t_eb_icentl_" + format, "t_eb_ct_" + format, "t_eb_ctl_" + format, "t_eb_def_" + format, "t_eb_defl_" + format, "t_eb_dv_" + format, "t_eb_ve_" + format, "t_eb_dvg_" + format, "t_eb_dvgl_" + format});
        HashMap sourceTableMap = Maps.newHashMapWithExpectedSize((int)16);
        sourceTableMap.put("t_eb_structofent_l", "t_eb_structofent");
        sourceTableMap.put("t_eb_structoficentity_l", "t_eb_structoficentity");
        sourceTableMap.put("t_eb_structofchangetype_l", "t_eb_structofchangetype");
        sourceTableMap.put("t_eb_structofdefined_l", "t_eb_structofdefined");
        sourceTableMap.put("t_eb_viewentry", "t_eb_businessmodel");
        sourceTableMap.put("t_eb_dimensionview_group_l", "t_eb_dimensionview_group");
        for (int i = 0; i < srcTables.size(); ++i) {
            String srcTable = (String)srcTables.get(i);
            String backTable = (String)backTables.get(i);
            if (!SqlBatchUtils.hasTable((String)backTable)) {
                UpgradesTaskUtil.getInstance().createBackupTable(DBRoute.of((String)"epm"), backTable, srcTable);
            }
            Set backColumns = SqlBatchUtils.getColumns((String)backTable);
            String allFields = StringUtils.join((Collection)backColumns, (String)",");
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("insert into", new Object[0]).append(backTable, new Object[0]).append("(", new Object[0]).append(allFields, new Object[0]).append(") select", new Object[0]).append(allFields, new Object[0]).append("from", new Object[0]).append(srcTable, new Object[0]).append("where", new Object[0]);
            if (sourceTableMap.containsKey(srcTable)) {
                sqlBuilder.append("fid in (select fid from", new Object[0]).append((String)sourceTableMap.get(srcTable), new Object[0]).append("where", new Object[0]).appendIn("fmodelid", modelArray).append(")", new Object[0]);
            } else {
                sqlBuilder.appendIn("fmodelid", modelArray);
            }
            ViewMemberUpgradeService.insertBackupData(sqlBuilder);
        }
    }

    private static void insertBackupData(SqlBuilder sqlBuilder) {
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
    }

    private static String getTimeFormat() {
        long timeMillis = System.currentTimeMillis();
        Timestamp timestamp = new Timestamp(timeMillis);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMddHHmm");
        return simpleDateFormat.format(timestamp);
    }

    private static void setModelByRow(List<Long> upgradeModelIds, Map<Long, Model> modelMap, Row row) {
        long id = row.getLong("fid");
        String showNumber = row.getString("fshownumber");
        Model model = new Model();
        model.setReportType(row.getString("freporttype"));
        model.setDataSourceId(row.getLong("fdatasource"));
        model.setId(Long.valueOf(id));
        model.setNumber(showNumber);
        modelMap.put(id, model);
        upgradeModelIds.add(id);
    }

    private static UpgradeDimensionViewMember addNotLeafMember(UpgradeDimensionViewMember baseViewMember, String notLeafNumber) {
        UpgradeDimensionViewMember member = new UpgradeDimensionViewMember();
        member.setMemberId(Long.valueOf(GlobalIdUtil.genGlobalLongId()));
        member.setName(baseViewMember.getName());
        member.setNumber(notLeafNumber);
        member.setSimpleName(baseViewMember.getSimpleName());
        member.setShowNumber(baseViewMember.getShowNumber());
        member.setModel(baseViewMember.getModel());
        member.setDimension(baseViewMember.getDimension());
        member.setAggOprtSign(baseViewMember.getAggOprtSign());
        member.setLevel(baseViewMember.getLevel());
        member.setDseq(baseViewMember.getDseq());
        member.setLongNumber(notLeafNumber);
        member.setIsLeaf(baseViewMember.isLeaf());
        member.setMembersource(MemberSourceEnum.PRESET.getIndex());
        DimensionViewMember parent = baseViewMember.getParent();
        if (parent != null) {
            member.setParentId(parent.getMemberId());
        } else {
            member.setParentId(Long.valueOf(0L));
        }
        member.setEnable(baseViewMember.isEnable());
        member.setDisable(baseViewMember.getDisable());
        member.setInnerOrg(baseViewMember.getInnerOrg());
        member.setOuterOrg(baseViewMember.getOuterOrg());
        member.setSyncStatus(baseViewMember.getSyncStatus());
        member.setSyncDate(baseViewMember.getSyncDate());
        member.setModifier(baseViewMember.getModifier());
        member.setModifyDate(baseViewMember.getModifyDate());
        member.setCreatorId(baseViewMember.getModifier());
        member.setCreateTime(baseViewMember.getModifyDate());
        member.setStatus(baseViewMember.getStatus());
        member.setMergernode(baseViewMember.getMergernode());
        member.setOffsetEntry(baseViewMember.getOffsetEntry());
        member.setSourceMemberId(baseViewMember.getMemberId());
        member.setView(baseViewMember.getView());
        return member;
    }

    private static void buildDimViewMemberTree(List<UpgradeDimensionViewMember> dimensionViewMembers, Map<Long, UpgradeDimensionViewMember> dimViewMemberMapByVid, Map<Long, UpgradeDimensionViewMember> dimViewMemberMapByMid) {
        LinkedHashMap refDimViewMemberByVid = Maps.newLinkedHashMap();
        LinkedHashMap dimViewMemberByVid = Maps.newLinkedHashMap();
        for (UpgradeDimensionViewMember dimensionViewMember : dimensionViewMembers) {
            ViewMemberUpgradeService.addRef(dimensionViewMember, refDimViewMemberByVid);
        }
        for (UpgradeDimensionViewMember dimensionViewMember : dimensionViewMembers) {
            ViewMemberUpgradeService.add(dimensionViewMember, dimViewMemberByVid, refDimViewMemberByVid);
        }
        LinkedList<UpgradeDimensionViewMember> dimensionViewMemberList = new LinkedList<UpgradeDimensionViewMember>();
        for (UpgradeDimensionViewMember dimensionViewMember : dimViewMemberByVid.values()) {
            ViewMemberUpgradeService.addAllDimensionViewMemberToMap(dimensionViewMember, dimensionViewMemberList);
        }
        for (UpgradeDimensionViewMember dimensionViewMember : dimensionViewMemberList) {
            dimViewMemberMapByVid.put(dimensionViewMember.getViewMemberId(), dimensionViewMember);
            dimViewMemberMapByMid.put(dimensionViewMember.getMemberId(), dimensionViewMember);
        }
    }

    private static void addAllDimensionViewMemberToMap(UpgradeDimensionViewMember dimensionViewMember, List<UpgradeDimensionViewMember> dimensionViewMemberList) {
        dimensionViewMemberList.add(dimensionViewMember);
        if (CollectionUtils.isNotEmpty((Collection)dimensionViewMember.getChildren())) {
            for (UpgradeDimensionViewMember child : dimensionViewMember.getChildren()) {
                ViewMemberUpgradeService.addAllDimensionViewMemberToMap(child, dimensionViewMemberList);
            }
        }
    }

    private static void add(UpgradeDimensionViewMember dimensionViewMember, Map<Long, UpgradeDimensionViewMember> dimViewMembers, Map<Long, UpgradeDimensionViewMember> refDimViewMember) {
        if (dimensionViewMember == null) {
            return;
        }
        if (dimensionViewMember.getParentId() == null || dimensionViewMember.getParentId() == 0L) {
            dimViewMembers.put(dimensionViewMember.getViewMemberId(), dimensionViewMember);
        } else {
            UpgradeDimensionViewMember parent = refDimViewMember.get(dimensionViewMember.getParentId());
            if (parent != null) {
                parent.addChild(dimensionViewMember);
            }
        }
    }

    private static void addRef(UpgradeDimensionViewMember dimensionViewMember, Map<Long, UpgradeDimensionViewMember> refMember) {
        if (dimensionViewMember == null) {
            return;
        }
        refMember.put(dimensionViewMember.getViewMemberId(), dimensionViewMember);
    }

    private static List<Member> buildViewMemberTree(List<Member> viewMembers) {
        LinkedList resultViewMembers = Lists.newLinkedList();
        if (viewMembers == null || viewMembers.isEmpty()) {
            return resultViewMembers;
        }
        LinkedHashMap refViewMemberMap = Maps.newLinkedHashMap();
        LinkedHashMap viewMemberMap = Maps.newLinkedHashMap();
        for (Member viewMember : viewMembers) {
            ViewMemberUpgradeService.addRefViewMember(viewMember, refViewMemberMap);
        }
        for (Member viewMember : viewMembers) {
            ViewMemberUpgradeService.addViewMember(viewMember, viewMemberMap, refViewMemberMap);
        }
        for (Member viewMember : viewMemberMap.values()) {
            ViewMemberUpgradeService.addAllViewMemberToMap(viewMember, resultViewMembers);
        }
        return resultViewMembers;
    }

    private static void addAllViewMemberToMap(Member viewMember, List<Member> viewMembers) {
        viewMembers.add(viewMember);
        if (CollectionUtils.isNotEmpty((Collection)viewMember.getChildren())) {
            for (Member child : viewMember.getChildren()) {
                ViewMemberUpgradeService.addAllViewMemberToMap(child, viewMembers);
            }
        }
    }

    private static void addViewMember(Member viewMember, Map<Long, Member> viewMemberMap, Map<Long, Member> refViewMember) {
        if (viewMember == null) {
            return;
        }
        if (viewMember.getParentId() == null || viewMember.getParentId() == 0L) {
            viewMemberMap.put(viewMember.getId(), viewMember);
        } else {
            Member parent = refViewMember.get(viewMember.getParentId());
            if (parent != null) {
                parent.addChild(viewMember);
            }
        }
    }

    private static void addRefViewMember(Member viewMember, Map<Long, Member> refViewMember) {
        if (viewMember == null) {
            return;
        }
        refViewMember.put(viewMember.getId(), viewMember);
    }

    public static void insertRows(String fieldStr, String ebTableName, List<Object[]> paramsList) {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(ebTableName).append("(").append(fieldStr).append(") values(");
        int length = fieldStr.split(",").length;
        for (int i = 0; i < length; ++i) {
            sql.append("?,");
        }
        sql.deleteCharAt(sql.length() - 1).append(")");
        if (paramsList != null && paramsList.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql.toString(), paramsList);
        }
    }

    public static void dimViewUpdateRows(String ebTableName, List<Object[]> paramsList) {
        if (paramsList == null || paramsList.isEmpty()) {
            return;
        }
        String sql = "update " + ebTableName + " set fviewgroupid = ? where fid = ?;";
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, paramsList);
    }

    public static void viewEntryUpdateRowsByViewId(String ebTableName, List<Object[]> paramsList) {
        if (paramsList == null || paramsList.isEmpty()) {
            return;
        }
        String sql = "update " + ebTableName + " set fviewgroupid = ? where fviewid = ?;";
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, paramsList);
    }

    public static void viewEntryUpdateRowsByDimId(String ebTableName, List<Object[]> paramsList) {
        if (paramsList == null || paramsList.isEmpty()) {
            return;
        }
        String sql = "update " + ebTableName + " set fviewgroupid = ? where fdimensionid = ?;";
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, paramsList);
    }

    public static void viewMemberRootNumberUpdateRows(String ebTableName, List<Object[]> paramsList) {
        if (paramsList == null || paramsList.isEmpty()) {
            return;
        }
        String sql = "update " + ebTableName + " set fnumber = ?, fmemberid  = ? where fid = ?;";
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, paramsList);
    }

    public static void viewMemberIsLeafAndShowChildrenUpdateRows(String ebTableName, List<Object[]> paramsList) {
        if (paramsList == null || paramsList.isEmpty()) {
            return;
        }
        String sql = "update " + ebTableName + " set fisleaf = ?, fshowchildren = ?, fshowself = ?, fmergernode = ? where fid = ?;";
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, paramsList);
    }

    public static void viewMemberAnalLeafUpdateRows(String ebTableName, List<Object[]> paramsList) {
        if (paramsList == null || paramsList.isEmpty()) {
            return;
        }
        String sql = "update " + ebTableName + " set fisleaf = ?, fshowchildren = ?, fshowself = ? where fid = ?;";
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, paramsList);
    }

    public static void viewMemberAddRootParentUpdateRows(String ebTableName, List<Object[]> paramsList) {
        if (paramsList == null || paramsList.isEmpty()) {
            return;
        }
        String sql = "update " + ebTableName + " set fparentid = ?, flevel = ?, fdseq = ? where fid = ?;";
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, paramsList);
    }

    public static void viewMemberAAddChildrenLevelUpdateRows(String ebTableName, List<Object[]> paramsList) {
        if (paramsList == null || paramsList.isEmpty()) {
            return;
        }
        String sql = "update " + ebTableName + " set flevel = ? where fid = ?;";
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, paramsList);
    }

    public static void viewMemberChangeIsLeafUpdateRows(String ebTableName, List<Object[]> paramsList) {
        if (paramsList == null || paramsList.isEmpty()) {
            return;
        }
        String sql = "update " + ebTableName + " set fisleaf = ? where fid = ?;";
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, paramsList);
    }

    public static void viewMemberLongNumberUpdateRows(String ebTableName, List<Object[]> paramsList) {
        if (paramsList == null || paramsList.isEmpty()) {
            return;
        }
        String sql = "update " + ebTableName + " set flongnumber = ? where fid = ?;";
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, paramsList);
    }

    public static void viewMemberRefViewUpdateRows(String ebTableName, List<Object[]> paramsList) {
        if (paramsList == null || paramsList.isEmpty()) {
            return;
        }
        String sql = "update " + ebTableName + " set frefview = ?,fmembersource = ? where fid = ?;";
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, paramsList);
    }

    public static void viewMemberMemberSourceUpdateRows(String ebTableName, List<Object[]> paramsList) {
        if (paramsList == null || paramsList.isEmpty()) {
            return;
        }
        String sql = "update " + ebTableName + " set fmembersource = ? where fid = ?;";
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, paramsList);
    }

    public static void viewMemberRootNumberAndShowNumberUpdateRows(String ebTableName, List<Object[]> paramsList) {
        if (paramsList == null || paramsList.isEmpty()) {
            return;
        }
        String sql = "update " + ebTableName + " set fnumber = ?,fshownumber = ?,fmemberid = ? where fmodelid = ? and fdimensionid = ? and flevel = 1;";
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, paramsList);
    }

    public static void updateDimension(Model model, OlapConnection conn, String cubeNumber, String dimNumber, ShrekConfig config, LogStats stats, List<Long> viewIds, boolean isNeedUpdateAll, Map<Long, List<Member>> alreadyViewMemberHasChildMapByView, Map<Long, Member> alreadyViewMemberMapByViewMemId) {
        for (Long viewId : viewIds) {
            List<Member> members = alreadyViewMemberHasChildMapByView.get(viewId);
            if (CollectionUtils.isEmpty(members)) continue;
            Set olapExistMembers = ShrekServiceFactory.SHREK_MEMBER.getAllMembers(conn, cubeNumber, dimNumber, true);
            ArrayList<Member> neeAdd = new ArrayList<Member>(members.size());
            for (Member member : members) {
                if (!olapExistMembers.add(member.getNumber().toLowerCase())) continue;
                neeAdd.add(member);
            }
            stats.addInfo("view_member_upgrade_needAddMember:" + neeAdd.stream().map(BaseCache::getNumber).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(neeAdd)) {
                ViewMemberUpgradeService.createMember(conn, model, cubeNumber, dimNumber, neeAdd, config, alreadyViewMemberMapByViewMemId);
            }
            if (isNeedUpdateAll) {
                if (MemberStorageTypes.DynamicCalc.equals((Object)config.getDefaultStorageType())) {
                    ViewMemberUpgradeService.syncDynamicCalc(model, conn, cubeNumber, dimNumber, members);
                } else {
                    ShrekServiceFactory.STOREDCALC.syncStoredCalc(conn, cubeNumber, dimNumber, members);
                }
            }
            Set memberNumbers = members.stream().filter(Objects::nonNull).map(BaseCache::getNumber).collect(Collectors.toSet());
            ShrekServiceFactory.SHREK_MEMBER.alterMember(conn, cubeNumber, dimNumber, memberNumbers);
        }
    }

    private static void syncDynamicCalc(Model model, OlapConnection conn, String cubeNumber, String dimension, Collection<Member> members) {
        ShrekServiceFactory.DYNAMIC_CALC.verifyElement(new Object[]{conn});
        ShrekServiceFactory.DYNAMIC_CALC.verifyDimensions(new String[]{dimension});
        ShrekServiceFactory.DYNAMIC_CALC.verifyMembers(members);
        if (members.size() == 0) {
            return;
        }
        MetadataCommandInfo meta = new MetadataCommandInfo();
        meta.setAction(CommandTypes.alter);
        meta.setMetadataType(MetadataTypes.Member);
        meta.setOwnerUniqueName(cubeNumber + "." + dimension);
        ShrekParamUtils.CubeParams cubeParams = null;
        if (SysDimensionEnum.Entity.getNumber().equals(dimension) && (cubeParams = ViewMemberUpgradeService.getCubeParamsByCache(model.getId())) != null && cubeParams.hasDynamicStore()) {
            meta.getProperties().set("enabledDS", "true");
        }
        Set existMember = ShrekServiceFactory.SHREK_MEMBER.getAllMembers(conn, cubeNumber, dimension, true);
        List items = meta.getItems();
        boolean isAccount = !model.isModelByEB() && SysDimensionEnum.Account.getNumber().equals(dimension);
        for (Member member : members) {
            ShrekServiceFactory.DYNAMIC_CALC.syncDynamicCalc(dimension, member, isAccount, existMember, items, cubeParams);
        }
        if (!items.isEmpty()) {
            ShrekIdCodeUtils.setTraceInfo((CommandInfo)meta, null);
            try {
                OlapCommand command = new OlapCommand(conn, (CommandInfo)meta);
                command.executeNonQuery();
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
    }

    private static ShrekParamUtils.CubeParams getCubeParamsByCache(long modelId) {
        ShrekParamUtils.CubeParams cubeParams;
        String paramJson = Cache.get().get("BUDGET_CUBE_PARAMS_CACHE" + modelId);
        if (StringUtils.isEmpty((String)paramJson)) {
            cubeParams = ViewMemberUpgradeService.getF7Params(modelId);
            if (cubeParams == null) {
                cubeParams = new ShrekParamUtils.CubeParams(modelId, null);
            }
            Cache.get().set("BUDGET_CUBE_PARAMS_CACHE" + modelId, JSON.toJSONString((Object)cubeParams));
        } else {
            cubeParams = (ShrekParamUtils.CubeParams)JSON.parseObject((String)paramJson, ShrekParamUtils.CubeParams.class);
        }
        return cubeParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ShrekParamUtils.CubeParams getF7Params(long modelId) {
        if (IDUtils.isNull((long)modelId)) {
            return null;
        }
        LogStats stats = new LogStats("budget-log : ");
        stats.addInfo("begin-load-cubeParams.");
        ShrekParamUtils.CubeParams cubeParams = null;
        try {
            SqlBuilder sqlBuilderCubeParams = new SqlBuilder();
            sqlBuilderCubeParams.append("select fparams from t_epbs_param_set where fid in (select fid from t_epbs_preset_param  where fnumber = 'BG031') and fmodelid = ?", new Object[]{modelId});
            DataSet rowsCubeParams = ViewMemberUpgradeService.queryDatasetBySql(sqlBuilderCubeParams, "queryCubeParams");
            String params = null;
            if (rowsCubeParams != null && !rowsCubeParams.isEmpty() && rowsCubeParams.hasNext()) {
                Row row = rowsCubeParams.next();
                params = row.getString("fparams");
            }
            if (StringUtils.isNotEmpty(params)) {
                Map paramsMap = (Map)SerializationUtils.fromJsonString(params, Map.class);
                String levelsValue = (String)paramsMap.get("storelevel");
                cubeParams = ShrekParamUtils.parseCubeParams((Long)modelId, (String)levelsValue);
            }
        }
        catch (Exception ex) {
            log.error("params-parse-error", (Throwable)ex);
        }
        finally {
            stats.add("end-load-cubeParams.");
            log.info(stats.toString());
        }
        return cubeParams;
    }

    public static void createMember(OlapConnection conn, Model model, String cubeNumber, String dimension, List<Member> members, ShrekConfig config, Map<Long, Member> alreadyViewMemberMapByViewMemId) {
        if (members == null || members.isEmpty()) {
            return;
        }
        ShrekServiceFactory.SHREK_MEMBER.verifyElement(new Object[]{conn, config});
        ShrekServiceFactory.SHREK_MEMBER.verifyCube(cubeNumber);
        ShrekServiceFactory.SHREK_MEMBER.verifyDimensions(new String[]{dimension});
        ShrekServiceFactory.SHREK_MEMBER.verifyMembers(members);
        boolean existDimension = ShrekServiceFactory.SHREK_DIMENSION.existDimension(conn, cubeNumber, dimension);
        if (!existDimension) {
            return;
        }
        LinkedHashSet errors = Sets.newLinkedHashSet();
        LinkedHashSet counts = Sets.newLinkedHashSet();
        ArrayList _members = Lists.newArrayListWithExpectedSize((int)members.size());
        for (Member member2 : members) {
            if (!SysDimensionEnum.Period.getNumber().equalsIgnoreCase(dimension) && !NumberCheckUtils.checkNumber((String)member2.getNumber())) {
                errors.add(member2.getNumber());
            }
            if (!counts.add(member2.getNumber())) continue;
            _members.add(member2);
        }
        members = _members;
        if (!errors.isEmpty()) {
            throw new KDBizException(ResManager.loadResFormat((String)"%1\u7ef4\u5ea6\u7684\u6210\u5458\u7f16\u7801%2\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u548c\u534a\u89d2\u6a2a\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u548c\u534a\u89d2\u6a2a\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"ShrekMember_0", (String)"epm-eb-common", (Object[])new Object[]{dimension, StringUtils.join((Collection)errors, (char)',')}));
        }
        Set existMember = ShrekServiceFactory.SHREK_MEMBER.getAllMembers(conn, cubeNumber, dimension, true);
        if ((members = members.stream().filter(m -> !existMember.contains(m.getNumber().toLowerCase())).collect(Collectors.toList())).isEmpty()) {
            return;
        }
        MetadataCommandInfo metadataCommandInfo = new MetadataCommandInfo();
        metadataCommandInfo.setAction(CommandTypes.create);
        metadataCommandInfo.setMetadataType(MetadataTypes.Member);
        metadataCommandInfo.setOwnerUniqueName(cubeNumber.trim() + "." + dimension.trim());
        boolean hasMetric = SysDimensionEnum.Metric.getNumber().equals(dimension);
        List items = metadataCommandInfo.getItems();
        for (Member member3 : members) {
            MemberMetadataItem item = new MemberMetadataItem(member3.getNumber().trim());
            if (hasMetric && !member3.hasAgg()) {
                item.setMemberAggShieldRule("none");
            }
            if (member3.isLeaf()) {
                item.setStorageType(MemberStorageTypes.Stored);
            } else {
                item.setStorageType(config.getDefaultStorageType());
            }
            items.add(item);
        }
        ShrekIdCodeUtils.setTraceInfo((CommandInfo)metadataCommandInfo, null);
        OlapCommand command = new OlapCommand(conn, (CommandInfo)metadataCommandInfo);
        command.executeNonQuery();
        if (config.getStats() != null) {
            config.getStats().addInfo(metadataCommandInfo.toString());
        }
        if (MemberStorageTypes.DynamicCalc == config.getDefaultStorageType()) {
            HashSet allUpdateMember = Sets.newHashSetWithExpectedSize((int)members.size());
            for (Member member4 : members) {
                allUpdateMember.add(member4);
                Member member5 = alreadyViewMemberMapByViewMemId.get(member4.getParentId());
                if (member5 == null) continue;
                allUpdateMember.add(member5);
            }
            allUpdateMember.removeIf(member -> StorageTypeEnum.STORAGE.getOIndex().equals(member.getStorageType()));
            if (!allUpdateMember.isEmpty()) {
                ShrekServiceFactory.DYNAMIC_CALC.syncDynamicCalc(model, conn, cubeNumber, dimension, (Collection)allUpdateMember);
            }
        }
    }

    public static void clearDataEntityCache() {
        CacheServiceHelper.clearEntityCache((String)"eb_businessmodel");
        CacheServiceHelper.clearEntityCache((String)"eb_dimensionview");
        CacheServiceHelper.clearEntityCache((String)"eb_dimensionview_group");
        CacheServiceHelper.clearEntityCache((String)"eb_viewmember");
        ArrayList entityList = Lists.newArrayList((Object[])new String[]{SysDimensionEnum.Entity.getMemberTreemodel(), SysDimensionEnum.InternalCompany.getMemberTreemodel(), SysDimensionEnum.ChangeType.getMemberTreemodel(), "epm_userdefinedmembertree"});
        for (String entity : entityList) {
            CacheServiceHelper.clearEntityCache((String)entity);
        }
    }

    public static void ctDimViewViewGroupUpdateRows(String ebTableName, List<Object[]> paramsList) {
        if (paramsList == null || paramsList.isEmpty()) {
            return;
        }
        String sql = "update " + ebTableName + " set fviewgroupid = ? where fid = ?;";
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, paramsList);
    }

    public static void viewMemberUpgradeByPage(List<Long> modelIds, IFormView view) {
        UpgradeViewResult upgradeViewResult = ViewMemberUpgradeService.upgradeOldModel(modelIds);
        List successModel = upgradeViewResult.getSuccessModel();
        for (Model model : successModel) {
            ViewMemberUpgradeService.updateModelCache(model);
        }
        if (successModel.size() > 0) {
            ViewMemberUpgradeService.clearDataEntityCache();
        }
        if (CollectionUtils.isNotEmpty((Collection)upgradeViewResult.getFailModel())) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u4ee5\u4e0b\u4f53\u7cfb\u5347\u7ea7\u5931\u8d25\uff1a%1", (String)"ViewMemberUpgradeService_3", (String)"epm-eb-business", (Object[])new Object[]{upgradeViewResult.getErrorMessage()}));
        }
        view.showSuccessNotification(ResManager.loadResFormat((String)"\u4f53\u7cfb\u5347\u7ea7\u5b8c\u6210\u3002", (String)"ViewMemberUpgradeService_4", (String)"epm-eb-business", (Object[])new Object[]{upgradeViewResult.getMessage()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void viewMemberUpgradeByAuto(IFormView view) {
        String cache = Cache.get().get(AUTO_UPDATE_MODEL_CACHE);
        if (StringUtils.isNotEmpty((String)cache)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6709\u4f53\u7cfb\u6b63\u5728\u5347\u7ea7\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ViewMemberUpgradeService_8", (String)"epm-eb-business", (Object[])new Object[0]));
            return;
        }
        Cache.get().set(AUTO_UPDATE_MODEL_CACHE, AUTO_UPDATE_MODEL_CACHE, 1, TimeUnit.HOURS);
        try {
            DynamicObjectCollection modelDyns = QueryServiceHelper.query((String)"epm_model", (String)"id,versionnumber", null, (String)"modifytime desc");
            ArrayList<Long> needUpdateIds = new ArrayList<Long>(modelDyns.size());
            if (modelDyns != null && !modelDyns.isEmpty()) {
                for (DynamicObject modelDyn : modelDyns) {
                    long id = modelDyn.getLong("id");
                    String versionNumber = modelDyn.getString("versionnumber");
                    if (!StringUtils.isEmpty((String)versionNumber) && !(ViewMemberUpgradeService.getVersionNumber(versionNumber) < 2.0)) continue;
                    needUpdateIds.add(id);
                    if (needUpdateIds.size() != 3) continue;
                    break;
                }
            }
            if (CollectionUtils.isNotEmpty(needUpdateIds)) {
                UpgradeViewResult upgradeViewResult = ViewMemberUpgradeService.upgradeOldModel(needUpdateIds);
                ArrayList<Object[]> updateModelVerNumList = new ArrayList<Object[]>(16);
                List successModel = upgradeViewResult.getSuccessModel();
                for (Model model : successModel) {
                    ViewMemberUpgradeService.updateModelCache(model);
                    updateModelVerNumList.add(new Object[]{"V2", model.getId()});
                }
                if (successModel.size() > 0) {
                    ViewMemberUpgradeService.clearDataEntityCache();
                }
                ViewMemberUpgradeService.modelVersionNumberUpdateRows("t_eb_model", updateModelVerNumList);
                if (CollectionUtils.isNotEmpty((Collection)upgradeViewResult.getFailModel())) {
                    view.showTipNotification(ResManager.loadResFormat((String)"\u4ee5\u4e0b\u4f53\u7cfb\u5347\u7ea7\u5931\u8d25\uff1a%1", (String)"ViewMemberUpgradeService_3", (String)"epm-eb-business", (Object[])new Object[]{upgradeViewResult.getErrorMessage()}));
                }
            }
        }
        finally {
            Cache.get().remove(AUTO_UPDATE_MODEL_CACHE);
        }
    }

    public static void updateModelCache(Model model) {
        CubeUtils.updateCubeVersion((Long)model.getId());
        ModelCacheContext.removeModel((Long)model.getId());
    }

    public static double getVersionNumber(String versionNumber) {
        if (StringUtils.isEmpty((String)versionNumber) || !versionNumber.startsWith("V")) {
            return 0.0;
        }
        String verNum = versionNumber.substring(1);
        return Double.parseDouble(verNum);
    }

    public static void modelVersionNumberUpdateRows(String ebTableName, List<Object[]> paramsList) {
        if (paramsList == null || paramsList.isEmpty()) {
            return;
        }
        String sql = "update " + ebTableName + " set fversionnumber = ? where fid = ?;";
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, paramsList);
    }
}

