/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.adjust;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.adjust.service.ExpenseAdjustBillServiceImpl;
import kd.epm.eb.business.adjust.service.IAdjustBillService;
import kd.epm.eb.business.adjust.service.OverallAdjustBillServiceImpl;
import kd.epm.eb.common.adjust.AdjustBillEnum;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.dao.adjust.CompareDataPojo;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.BgControlSettingTypeEnum;
import kd.epm.eb.common.enums.EbAdjBillTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.DynamicInfoCollection;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.controlParamsSetting.ControlParamsSettingUtil;
import kd.epm.eb.control.BgControlCallerImpl;
import kd.epm.eb.control.face.IBudgetBalance;
import kd.epm.eb.control.utils.BudgetAdjustCheckUtils;

public class AdjustHelper {
    public static final String SUBMIT_BAR = "submit";
    public static final String SAVE_BAR = "save";
    public static final String ENTRY_ENTITY = "entryentity";
    public static final String ADJ_DETAIL_ENTITY = "adjdetailentity";
    public static final int PERIOD_GROUP_COUNTS = 19;
    public static final String formType_adjust = "1";
    public static final String formType_adjpst = "2";
    public static final String billstatus_key = "billstatus";

    public static IAdjustBillService getInstance(AdjustBillEnum adjustBillEnum) {
        ExpenseAdjustBillServiceImpl adjustBillService = null;
        switch (adjustBillEnum) {
            case EXPENSE: {
                adjustBillService = ExpenseAdjustBillServiceImpl.getInstance();
                break;
            }
            case OVERALL: {
                adjustBillService = OverallAdjustBillServiceImpl.getInstance();
                break;
            }
        }
        return adjustBillService;
    }

    public static DynamicInfoCollection buildCustomDimInfo(Long modelId) {
        DynamicInfoCollection customDimInfo = new DynamicInfoCollection("customDimInfo", new String[]{"controlkey", "number", "shortnumber", "name", "id", "defMemberId", "defMemberNum"});
        if (IDUtils.isNull((Long)modelId)) {
            return customDimInfo;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensionList = modelCacheHelper.getDimensionList();
        ArrayList<Dimension> customDimList = new ArrayList<Dimension>(dimensionList.size());
        for (Dimension dimension : dimensionList) {
            if (dimension.isPreset()) continue;
            customDimList.add(dimension);
        }
        int seq = 1;
        for (Dimension dimension : customDimList) {
            kd.epm.eb.common.cache.impl.Member member = dimension.getMember(Long.valueOf(0L), dimension.getNoneNumber());
            customDimInfo.addInfo(new Object[]{"adjcustomdim" + seq++, dimension.getNumber(), dimension.getShortNumber(), dimension.getName(), String.valueOf(dimension.getId()), String.valueOf(member.getId()), member.getNumber()});
        }
        return customDimInfo;
    }

    public static DynamicInfoCollection buildCustomDimInfo(Long modelId, Long bizModelId) {
        DynamicInfoCollection customDimInfo = new DynamicInfoCollection("customDimInfo", new String[]{"controlkey", "number", "shortnumber", "name", "id", "defMemberId", "defMemberNum"});
        if (IDUtils.isNull((Long)modelId)) {
            return customDimInfo;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Map dimViewMap = modelCacheHelper.getViewsByBusModel(bizModelId);
        List dimensionList = modelCacheHelper.getDimensionListByBusModel(bizModelId);
        ArrayList<Dimension> customDimList = new ArrayList<Dimension>(dimensionList.size());
        for (Dimension dimension : dimensionList) {
            if (dimension.isPreset()) continue;
            customDimList.add(dimension);
        }
        int seq = 1;
        for (Dimension dimension : customDimList) {
            Long viewId;
            kd.epm.eb.common.cache.impl.Member member = dimension.getMember(viewId = (Long)dimViewMap.get(dimension.getNumber()), dimension.getNoneNumber());
            if (member != null) {
                customDimInfo.addInfo(new Object[]{"adjcustomdim" + seq++, dimension.getNumber(), dimension.getShortNumber(), dimension.getName(), String.valueOf(dimension.getId()), String.valueOf(member.getId()), member.getNumber()});
                continue;
            }
            customDimInfo.addInfo(new Object[]{"adjcustomdim" + seq++, dimension.getNumber(), dimension.getShortNumber(), dimension.getName(), String.valueOf(dimension.getId()), "", ""});
        }
        return customDimInfo;
    }

    public static DynamicInfoCollection getRowCustomDimInfo(DynamicInfoCollection customDims, Long modelId, Long datasetId) {
        DynamicInfoCollection rowCustomDim = new DynamicInfoCollection("customDimInfo", new String[]{"controlkey", "number", "shortnumber", "name", "id", "defMemberId", "defMemberNum"});
        if (datasetId == 0L) {
            return rowCustomDim;
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensionList = modelCacheHelper.getDimensionList(datasetId);
        ArrayList<Dimension> customDimList = new ArrayList<Dimension>(dimensionList.size());
        for (Dimension dimension : dimensionList) {
            if (dimension.isPreset()) continue;
            customDimList.add(dimension);
        }
        block1: for (Dimension dimension : customDimList) {
            String dimensionId = String.valueOf(dimension.getId());
            List customDimsValues = customDims.getValues();
            for (DynamicInfoCollection.InfoObject dimInfo : customDimsValues) {
                String id = (String)dimInfo.getValueByPropName("id");
                if (!id.equals(dimensionId)) continue;
                String dimKey = (String)dimInfo.getValueByPropName("controlkey");
                String number = (String)dimInfo.getValueByPropName("number");
                String shortNum = (String)dimInfo.getValueByPropName("shortnumber");
                String name = (String)dimInfo.getValueByPropName("name");
                String defMemberId = (String)dimInfo.getValueByPropName("defMemberId");
                String defMemberNum = (String)dimInfo.getValueByPropName("defMemberNum");
                rowCustomDim.addInfo(new Object[]{dimKey, number, shortNum, name, id, defMemberId, defMemberNum});
                continue block1;
            }
        }
        return rowCustomDim;
    }

    public static Long getDatasetId(Long accountId) {
        if (accountId == null || accountId == 0L) {
            return 0L;
        }
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "=", (Object)accountId);
        DynamicObject accountObj = QueryServiceHelper.queryOne((String)"epm_accountmembertree", (String)"dataset", (QFilter[])qfBuilder.toArray());
        return accountObj.getLong("dataset");
    }

    public static boolean isHasInternalCompany(Long modelId, Long datasetId) {
        String[] dimensionNums;
        boolean hasInternalCompany = false;
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        for (String dimensionNum : dimensionNums = modelCache.getDimensionNums(datasetId)) {
            if (!SysDimensionEnum.InternalCompany.getNumber().equals(dimensionNum)) continue;
            hasInternalCompany = true;
            break;
        }
        return hasInternalCompany;
    }

    public static String[] getCellMeta(Map<String, String> dimMemberMap, String[] dimensionNums) {
        int length = dimMemberMap.size();
        String[] cellMeta = new String[length];
        int index = 0;
        for (String dimNum : dimensionNums) {
            String dimMemberNum = dimMemberMap.get(dimNum);
            if (!StringUtils.isNotEmpty((String)dimMemberNum)) continue;
            cellMeta[index++] = dimMemberNum;
        }
        return cellMeta;
    }

    public static boolean isExitMixturePeriod(List<Map<String, String>> dimList, Collection<String> types) {
        int i = 0;
        int j = 0;
        int z = 0;
        for (Map<String, String> map : dimList) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String value;
                if ("Period".equals(entry.getKey())) {
                    value = entry.getValue();
                    if (value.startsWith("Q_")) {
                        ++i;
                    } else if (value.startsWith("H_")) {
                        ++j;
                    } else if (value.startsWith("M_")) {
                        ++z;
                    }
                }
                if (!"BudgetPeriod".equals(entry.getKey())) continue;
                value = entry.getValue();
                if (value.indexOf(".Q") >= 0) {
                    ++i;
                    continue;
                }
                if (value.indexOf(".H") >= 0) {
                    ++j;
                    continue;
                }
                if (value.indexOf(".M") < 0) continue;
                ++z;
            }
        }
        if (i != 0 && j == 0 && z == 0) {
            types.add(BgControlSettingTypeEnum.QUARTER.getNumber());
        } else if (i == 0 && j != 0 && z == 0) {
            types.add(BgControlSettingTypeEnum.HALFYEAR.getNumber());
        } else if (i == 0 && j == 0 && z != 0) {
            types.add(BgControlSettingTypeEnum.MONTH.getNumber());
        } else {
            return false;
        }
        return true;
    }

    public static Collection<IBudgetBalance> getAllIbCollection(Long modelId, List<Map<String, String>> dimList, Collection<String> types, List<CompareDataPojo> compareDataPojoList, String formType) {
        ArrayList<IBudgetBalance> cl = new ArrayList<IBudgetBalance>();
        ArrayList<Map<String, String>> qlist = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> hlist = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> mlist = new ArrayList<Map<String, String>>();
        for (int k = 0; k < dimList.size(); ++k) {
            for (String key : dimList.get(k).keySet()) {
                if ("Period".equals(key) && dimList.get(k).get(key).startsWith("Q_") || "BudgetPeriod".equals(key) && dimList.get(k).get(key).contains(".Q")) {
                    qlist.add(dimList.get(k));
                    continue;
                }
                if ("Period".equals(key) && dimList.get(k).get(key).startsWith("HF_") || "BudgetPeriod".equals(key) && dimList.get(k).get(key).contains(".HF")) {
                    hlist.add(dimList.get(k));
                    continue;
                }
                if ((!"Period".equals(key) || !dimList.get(k).get(key).startsWith("M_")) && (!"BudgetPeriod".equals(key) || !dimList.get(k).get(key).contains(".M"))) continue;
                mlist.add(dimList.get(k));
            }
        }
        if (qlist.size() != 0) {
            types.add(BgControlSettingTypeEnum.QUARTER.getNumber());
            Collection<IBudgetBalance> budgetBalances = AdjustHelper.queryBalance(modelId, mlist, types, compareDataPojoList, formType);
            cl.addAll(budgetBalances);
            types.clear();
        }
        if (hlist.size() != 0) {
            types.add(BgControlSettingTypeEnum.HALFYEAR.getNumber());
            Collection<IBudgetBalance> budgetBalances = AdjustHelper.queryBalance(modelId, mlist, types, compareDataPojoList, formType);
            cl.addAll(budgetBalances);
            types.clear();
        }
        if (mlist.size() != 0) {
            types.add(BgControlSettingTypeEnum.MONTH.getNumber());
            Collection<IBudgetBalance> budgetBalances = AdjustHelper.queryBalance(modelId, mlist, types, compareDataPojoList, formType);
            cl.addAll(budgetBalances);
            types.clear();
        }
        return cl;
    }

    public static Collection<IBudgetBalance> getBgmAllIbCollection(Long modelId, Long bizModelId, List<Map<String, String>> dimList, Collection<String> types, List<CompareDataPojo> compareDataPojoList, String formType) {
        ArrayList<IBudgetBalance> cl = new ArrayList<IBudgetBalance>();
        ArrayList<Map<String, String>> qlist = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> hlist = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> mlist = new ArrayList<Map<String, String>>();
        for (int k = 0; k < dimList.size(); ++k) {
            for (String key : dimList.get(k).keySet()) {
                if ("Period".equals(key) && dimList.get(k).get(key).startsWith("Q_") || "BudgetPeriod".equals(key) && dimList.get(k).get(key).contains(".Q")) {
                    qlist.add(dimList.get(k));
                    continue;
                }
                if ("Period".equals(key) && dimList.get(k).get(key).startsWith("HF_") || "BudgetPeriod".equals(key) && dimList.get(k).get(key).contains(".HF")) {
                    hlist.add(dimList.get(k));
                    continue;
                }
                if ((!"Period".equals(key) || !dimList.get(k).get(key).startsWith("M_")) && (!"BudgetPeriod".equals(key) || !dimList.get(k).get(key).contains(".M"))) continue;
                mlist.add(dimList.get(k));
            }
        }
        if (qlist.size() != 0) {
            types.add(BgControlSettingTypeEnum.QUARTER.getNumber());
            Collection<IBudgetBalance> budgetBalances = AdjustHelper.queryBgmBalance(modelId, bizModelId, mlist, types, compareDataPojoList, formType);
            cl.addAll(budgetBalances);
            types.clear();
        }
        if (hlist.size() != 0) {
            types.add(BgControlSettingTypeEnum.HALFYEAR.getNumber());
            Collection<IBudgetBalance> budgetBalances = AdjustHelper.queryBgmBalance(modelId, bizModelId, mlist, types, compareDataPojoList, formType);
            cl.addAll(budgetBalances);
            types.clear();
        }
        if (mlist.size() != 0) {
            types.add(BgControlSettingTypeEnum.MONTH.getNumber());
            Collection<IBudgetBalance> budgetBalances = AdjustHelper.queryBgmBalance(modelId, bizModelId, mlist, types, compareDataPojoList, formType);
            cl.addAll(budgetBalances);
            types.clear();
        }
        return cl;
    }

    public static Collection<IBudgetBalance> queryBalance(Long modelId, List<Map<String, String>> dimList, Collection<String> types, List<CompareDataPojo> compareDataPojoList, String formType) {
        BgControlCallerImpl bgControlCaller = new BgControlCallerImpl();
        Collection iBudgetBalances = new ArrayList(16);
        if (ControlParamsSettingUtil.isOpenReduceBill((Long)modelId, (String)formType)) {
            Map submitValueMap = BudgetAdjustCheckUtils.getAdjustValueMap(compareDataPojoList, (String)"submitValue", (String)formType);
            iBudgetBalances = bgControlCaller.queryBalance(modelId, dimList, types, true, true, submitValueMap);
        } else {
            iBudgetBalances = bgControlCaller.queryBalance(modelId, dimList, types, true, true);
        }
        return iBudgetBalances;
    }

    public static Collection<IBudgetBalance> queryBgmBalance(Long modelId, Long bizModelId, List<Map<String, String>> dimList, Collection<String> types, List<CompareDataPojo> compareDataPojoList, String formType) {
        Collection iBudgetBalances;
        BgControlCallerImpl bgControlCaller = new BgControlCallerImpl();
        if (ControlParamsSettingUtil.isOpenReduceBill((Long)modelId, (String)formType)) {
            Map submitValueMap = BudgetAdjustCheckUtils.getAdjustValueMap(compareDataPojoList, (String)"submitValue", (String)formType);
            iBudgetBalances = bgControlCaller.queryBalance(modelId, dimList, types, true, true, bizModelId, submitValueMap);
        } else {
            iBudgetBalances = bgControlCaller.queryBalance(modelId, dimList, types, true, true, bizModelId);
        }
        return iBudgetBalances;
    }

    public static boolean isDimMemberSame(IBudgetBalance budgetBalance, CompareDataPojo compareData, DynamicInfoCollection customDims) {
        boolean isFixDimSame;
        String period;
        boolean isCustomDimSame = true;
        String version = budgetBalance.getVersion(true).getNumber();
        String currency = budgetBalance.getCurrency(true).getNumber();
        String account = budgetBalance.getAccount(true).getNumber();
        String orgUnit = budgetBalance.getOrgUnit(true).getNumber();
        boolean isEb = budgetBalance.getBizModel().isEBByModel();
        if (isEb) {
            String year = budgetBalance.getYear(true).getNumber();
            period = budgetBalance.getPeriod(true).getNumber();
            isFixDimSame = account.equals(compareData.getAccountNumber()) && orgUnit.equals(compareData.getOrgnumber()) && period.equals(compareData.getPreiod()) && version.equals(compareData.getVersionNumber()) && year.equals(compareData.getYearNumber()) && currency.equals(compareData.getCurrencyNumber());
        } else {
            String metric = budgetBalance.getMember(true, SysDimensionEnum.Metric.getNumber()).getNumber();
            period = budgetBalance.getMember(true, SysDimensionEnum.BudgetPeriod.getNumber()).getNumber();
            isFixDimSame = account.equals(compareData.getAccountNumber()) && orgUnit.equals(compareData.getOrgnumber()) && metric.equals(compareData.getMetricNumber()) && period.equals(compareData.getPreiod()) && version.equals(compareData.getVersionNumber()) && currency.equals(compareData.getCurrencyNumber());
        }
        Map customDimMap = compareData.getCustomdimMap();
        if (customDimMap != null && customDimMap.size() > 0) {
            for (DynamicInfoCollection.InfoObject customDim : customDims.getValues()) {
                String controlKey = (String)customDim.getValueByPropName("controlkey");
                String memberNumber = (String)customDim.getValueByPropName("number");
                Member member = budgetBalance.getMember(true, memberNumber);
                if (member == null) continue;
                String customDimMemNum = (String)customDimMap.get(controlKey);
                if (StringUtils.isEmpty((String)customDimMemNum)) {
                    customDimMemNum = (String)customDimMap.get(controlKey.substring(3));
                }
                if (member == null || !StringUtils.isNotEmpty((String)member.getNumber()) || !StringUtils.isNotEmpty((String)customDimMemNum) || member.getNumber().equals(customDimMemNum)) continue;
                isCustomDimSame = false;
                break;
            }
        }
        return isFixDimSame && isCustomDimSame;
    }

    public static boolean isSameDims(Map<String, String> olapDimMemMap, String rowDims) {
        String[] dimArr;
        boolean isSameDims = true;
        for (String dimStr : dimArr = rowDims.split("!!")) {
            String[] dimStrArr = dimStr.split("@");
            String dimNum = dimStrArr[0];
            String dimMem = dimStrArr[1];
            String olapDimMem = olapDimMemMap.get(dimNum);
            if (!StringUtils.isEmpty((String)olapDimMem) && olapDimMem.equals(dimMem)) continue;
            isSameDims = false;
            break;
        }
        return isSameDims;
    }

    public static Map<String, Dimension> getCustomDimsByModel(Long modelId) {
        HashMap<String, Dimension> customDimMap = new HashMap<String, Dimension>(16);
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("model", "=", (Object)modelId);
        qfBuilder.add("issysdimension", "=", (Object)"0");
        DynamicObjectCollection dims = QueryServiceHelper.query((String)"epm_dimension", (String)"number,name,id,shortnumber", (QFilter[])qfBuilder.toArray(), (String)"dseq");
        int seq = 1;
        for (DynamicObject customDim : dims) {
            String id = customDim.getString("id");
            String number = customDim.getString("number");
            String shortNum = customDim.getString("shortnumber");
            String name = customDim.getString("name");
            Dimension dimension = new Dimension();
            dimension.setId(Long.valueOf(id));
            dimension.setNumber(number);
            dimension.setName(name);
            dimension.setShortNumber(shortNum);
            customDimMap.put("customdim" + seq++, dimension);
        }
        return customDimMap;
    }

    public static Map<String, Dimension> getCustomDimsByBizModel(Long modelId, Long bizModelId) {
        HashMap<String, Dimension> customDimMap = new HashMap<String, Dimension>(16);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensionList = modelCacheHelper.getDimensionListByBusModel(bizModelId);
        ArrayList<Dimension> customDimList = new ArrayList<Dimension>(dimensionList.size());
        for (Dimension dimension : dimensionList) {
            if (dimension.isPreset()) continue;
            customDimList.add(dimension);
        }
        int seq = 1;
        for (Dimension dimension : customDimList) {
            customDimMap.put("customdim" + seq++, dimension);
        }
        return customDimMap;
    }

    public static Map<String, Dimension> getCustomDimsByDataset(Long modelId, Long datasetId, Map<String, Dimension> customDimMap) {
        HashMap<String, Dimension> rowCustomDimMap = new HashMap<String, Dimension>(16);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        List dimensionList = modelCacheHelper.getDimensionList(datasetId);
        ArrayList<Dimension> customDimList = new ArrayList<Dimension>(dimensionList.size());
        for (Dimension dimension : dimensionList) {
            if (dimension.isPreset()) continue;
            customDimList.add(dimension);
        }
        block1: for (Dimension dimension : customDimList) {
            Long dimensionId = dimension.getId();
            for (Map.Entry<String, Dimension> entry : customDimMap.entrySet()) {
                String dimKey = entry.getKey();
                Dimension customDim = entry.getValue();
                Long id = customDim.getId();
                if (!id.equals(dimensionId)) continue;
                rowCustomDimMap.put(dimKey, customDim);
                continue block1;
            }
        }
        return rowCustomDimMap;
    }

    public static boolean verifyBillStatus(DynamicObject[] dataEntities) {
        DynamicObject dataEntity;
        String status;
        if (dataEntities != null && dataEntities.length > 0 && "E".equals(status = (dataEntity = dataEntities[0]).getString(billstatus_key))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u5ba1\u6838\u5b8c\u6210\uff0c\u65e0\u6cd5\u518d\u6b21\u5ba1\u6838\uff0c\u8bf7\u68c0\u67e5\u5de5\u4f5c\u6d41\u914d\u7f6e\u3002", (String)"AdjustHelper_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        return true;
    }

    public static Map<String, String> buildCustomDimMap(DynamicInfoCollection customDimInfoList) {
        LinkedHashMap<String, String> customDimMap = new LinkedHashMap<String, String>(16);
        List values = customDimInfoList.getValues();
        for (DynamicInfoCollection.InfoObject value : values) {
            customDimMap.put((String)value.getValueByPropName("number"), (String)value.getValueByPropName("controlkey"));
        }
        return customDimMap;
    }

    public static void refactorDynamicObject(DynamicObject doc, List<String> entryEntityKeys, Map<String, String> customDimJsonMap) {
        DynamicObjectCollection entryEntity = doc.getDynamicObjectCollection(ADJ_DETAIL_ENTITY);
        for (DynamicObject dynamicObject : entryEntity) {
            HashMap<String, DynamicObject> newDynamicObjMap = new HashMap<String, DynamicObject>(16);
            for (String string : entryEntityKeys) {
                DynamicObject object = (DynamicObject)dynamicObject.get(string);
                if (object != null) {
                    String longNumber = object.getString("longnumber");
                    String dimensionNumber = longNumber.split("!")[0];
                    String key = customDimJsonMap.get(dimensionNumber);
                    key = key.substring(3);
                    newDynamicObjMap.put(key, object);
                }
                dynamicObject.set(string, null);
            }
            for (Map.Entry entry : newDynamicObjMap.entrySet()) {
                dynamicObject.set((String)entry.getKey(), entry.getValue());
            }
        }
    }

    public static boolean isEb(Long modelId) {
        String reportType = ModelCacheContext.getOrCreate((Long)modelId).getModelobj().getReportType();
        return ApplicationTypeEnum.EB.getIndex().equals(reportType);
    }

    public static boolean isAllowSameDim(Long modelId, String billType) {
        ParamEnum paramEnum = EbAdjBillTypeEnum.adjust.getNumber().equals(billType) ? ParamEnum.BG051 : ParamEnum.BG053;
        return ParamQueryServiceHelper.getBoolean((long)modelId, (ParamEnum)paramEnum);
    }

    public static boolean isAllowNegative(Long modelId, String billType) {
        ParamEnum paramEnum = EbAdjBillTypeEnum.adjust.getNumber().equals(billType) ? ParamEnum.BG003 : ParamEnum.BG006;
        return ParamQueryServiceHelper.getBoolean((long)modelId, (ParamEnum)paramEnum);
    }

    public static boolean isAllowOnOrderBill(Long modelId, String billType) {
        ParamEnum paramEnum = EbAdjBillTypeEnum.adjust.getNumber().equals(billType) ? ParamEnum.BG052 : ParamEnum.BG054;
        return ParamQueryServiceHelper.getBoolean((long)modelId, (ParamEnum)paramEnum);
    }

    public static Long getDefaultOrgViewId(Long modelId, Long bizModelId) {
        return AdjustHelper.getDimDefaultViewId(modelId, bizModelId, SysDimensionEnum.Entity.getNumber());
    }

    public static Long getDimDefaultViewId(Long modelId, Long bizModelId, String dimNumber) {
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Map dimViewMap = modelCacheHelper.getViewsByBusModel(bizModelId);
        return (Long)dimViewMap.get(dimNumber);
    }

    public static Map<Object, DynamicObject> getCacheDynamicObject(DynamicObjectCollection adjdetail, List<String> entryEntityKeys) {
        if (adjdetail == null) {
            return null;
        }
        HashMap<Object, DynamicObject> cacheDynamicObject = new HashMap<Object, DynamicObject>(16);
        HashMap<DynamicObjectType, HashSet<Object>> needQueryObj = new HashMap<DynamicObjectType, HashSet<Object>>(16);
        for (DynamicObject dynamicObject : adjdetail) {
            for (String entryEntityKey : entryEntityKeys) {
                Object o = dynamicObject.get(entryEntityKey);
                if (!(o instanceof DynamicObject)) continue;
                DynamicObjectType dynamicObjectType = ((DynamicObject)o).getDynamicObjectType();
                Object id = ((DynamicObject)o).get("id");
                HashSet<Object> longs = (HashSet<Object>)needQueryObj.get(dynamicObjectType);
                if (longs == null) {
                    longs = new HashSet<Object>(16);
                }
                longs.add(id);
                needQueryObj.put(dynamicObjectType, longs);
            }
        }
        for (Map.Entry entry : needQueryObj.entrySet()) {
            DynamicObjectType key = (DynamicObjectType)entry.getKey();
            Set value = (Set)entry.getValue();
            Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((Object[])value.toArray(), (DynamicObjectType)key);
            cacheDynamicObject.putAll(objectDynamicObjectMap);
        }
        return cacheDynamicObject;
    }
}

