/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.applybill.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.business.applybill.util.ApplyBillAggHelper;
import kd.epm.eb.business.applybill.util.ApplyBillPluginUitl;
import kd.epm.eb.business.applybill.util.ApplyTemplateUtils;
import kd.epm.eb.business.applybill.util.BgApplyBillUtils;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateColCfgService;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateDimCfgService;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateDimRangeService;
import kd.epm.eb.business.centralapproval.ApproveBillUtil;
import kd.epm.eb.business.centralapproval.ApproveRecordUtil;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.applyTemplate.constants.ColCfgPropEnum;
import kd.epm.eb.common.applyTemplate.constants.ColCfgPropTypeEnum;
import kd.epm.eb.common.applyTemplate.constants.FormTypeEnum;
import kd.epm.eb.common.applyTemplate.entity.ApplyTemplateAtAllCfgEntity;
import kd.epm.eb.common.applyTemplate.entity.ApplyTemplateDimensionRelation;
import kd.epm.eb.common.applybill.ApplyBillType;
import kd.epm.eb.common.applybill.AuditRecordObj;
import kd.epm.eb.common.applybill.DetailMembBillData;
import kd.epm.eb.common.applybill.RowDataStatus;
import kd.epm.eb.common.applybill.RowDimMembInfo;
import kd.epm.eb.common.applybill.SchemeAssignDimGroup;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.CalculateColumn;
import kd.epm.eb.common.applytemplatecolumn.ColumnEnum;
import kd.epm.eb.common.applytemplatecolumn.ColumnList;
import kd.epm.eb.common.applytemplatecolumn.ColumnStyle;
import kd.epm.eb.common.applytemplatecolumn.DimensionDataColumn;
import kd.epm.eb.common.applytemplatecolumn.EntryTemplateConfig;
import kd.epm.eb.common.applytemplatecolumn.FieldTypeEnum;
import kd.epm.eb.common.applytemplatecolumn.FormatColumn;
import kd.epm.eb.common.applytemplatecolumn.MeasureColumn;
import kd.epm.eb.common.applytemplatecolumn.NumberColumn;
import kd.epm.eb.common.applytemplatecolumn.OlapDataEntry;
import kd.epm.eb.common.applytemplatecolumn.RelationValueColumn;
import kd.epm.eb.common.applytemplatecolumn.RowDimensionColumn;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.MembersKey;
import kd.epm.eb.common.centralapproval.AdjustRecordColInfo;
import kd.epm.eb.common.centralapproval.AppAdjustRecord;
import kd.epm.eb.common.centralapproval.ApproveBill;
import kd.epm.eb.common.centralapproval.CentralAppShowInfo;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.DateTimeUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.SqlBatchUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;

public class ApplyBillPluginUitl {
    private static Log log = LogFactory.getLog(ApplyBillPluginUitl.class);

    public static EntryTemplateConfig createMainEntryConfig(DynamicObject template, List<BaseColumn> main_collect, String table, IModelCacheHelper modelCacheHelper, Map<ColCfgPropTypeEnum, Map<String, ColCfgPropEnum>> colConfigMap, Long datasetId, Map<String, Map<String, String>> allDimValSetting) {
        Long templateId = template.getLong("id");
        Set statisticsDimCfg = ApplyTemplateDimCfgService.getInstance().getStatisticsDimCfg(templateId);
        return ApplyBillPluginUitl.createMainEntryConfig(template, main_collect, table, modelCacheHelper, colConfigMap, datasetId, allDimValSetting, statisticsDimCfg);
    }

    public static EntryTemplateConfig createMainEntryConfig(DynamicObject template, List<BaseColumn> main_collect, String table, IModelCacheHelper modelCacheHelper, Map<ColCfgPropTypeEnum, Map<String, ColCfgPropEnum>> colConfigMap, Long datasetId, Map<String, Map<String, String>> allDimValSetting, Collection<String> statisticsDimCfg) {
        Long modelId = modelCacheHelper.getModelobj().getId();
        Set currencyColumnKeys = ApplyTemplateUtils.getCurrencyColumnKeys(main_collect, (Long)modelId);
        Set rateColumnKeys = ApplyTemplateUtils.getRateColumnAndUpFormula(main_collect, (Long)modelId);
        List dimKeyList = ApplyTemplateUtils.getDimKeyList(main_collect);
        List rowDimNumList = ApplyTemplateUtils.getRowDimNumList(main_collect, (IModelCacheHelper)modelCacheHelper);
        String checkBoxColKey = null;
        String subtotalKey = null;
        for (BaseColumn column : main_collect) {
            if (column.getKey().startsWith(ApplyTemplateUtils.FIELD_BUSPLANDETAIL)) {
                checkBoxColKey = column.getKey();
                continue;
            }
            if (!column.getKey().startsWith(ApplyTemplateUtils.FIELD_SUBTOTAL_STATUS)) continue;
            subtotalKey = column.getKey();
        }
        Map<String, ColCfgPropEnum> colAggConfig = colConfigMap.get(ColCfgPropTypeEnum.AGGREGATE);
        Map<String, ColCfgPropEnum> colConfig = colConfigMap.get(ColCfgPropTypeEnum.EDIT_TYPE);
        Map<String, ColCfgPropEnum> colSummaryDisplayConfig = colConfigMap.get(ColCfgPropTypeEnum.SUMMARYDISPLAY);
        Set<String> summaryDisplayKeys = ApplyBillPluginUitl.getSummaryDisplayKeysFromTempBaseConfig(main_collect, colSummaryDisplayConfig);
        Set<String> modifKeys = ApplyBillPluginUitl.getModifKeysFromTempBaseConfig(main_collect, colConfig);
        Set<String> aggKeys = ApplyBillPluginUitl.getAggKeysFromTempBaseConfig(main_collect, colAggConfig);
        Set detailAtColumn = ApplyTemplateUtils.getDetailAtColumnKeys(main_collect, (Long)modelId);
        EntryTemplateConfig mainEntrytemplateConfig = new EntryTemplateConfig();
        mainEntrytemplateConfig.setModelId(modelId);
        mainEntrytemplateConfig.setName(template.getString("name"));
        mainEntrytemplateConfig.setCurrencyColumnKeys(currencyColumnKeys);
        mainEntrytemplateConfig.setRateColumnKeys(rateColumnKeys);
        mainEntrytemplateConfig.setNumber(template.getString("number"));
        mainEntrytemplateConfig.setTemplateID(((Long)template.getPkValue()).longValue());
        mainEntrytemplateConfig.setEntryColumns(main_collect);
        mainEntrytemplateConfig.setEntryTable(table);
        mainEntrytemplateConfig.setBusPlanDetailKey(checkBoxColKey);
        mainEntrytemplateConfig.setSubtotalKey(subtotalKey);
        mainEntrytemplateConfig.setDimKeysList(dimKeyList);
        mainEntrytemplateConfig.setRowDimNums(rowDimNumList);
        mainEntrytemplateConfig.setColDimNums(ApplyTemplateUtils.getColDimNums((String)template.getString("cachedata_tag")));
        mainEntrytemplateConfig.setOrgColumnKey(ApplyTemplateUtils.getOrgOrAccountColumnKey(main_collect, (List)dimKeyList, (boolean)false));
        mainEntrytemplateConfig.setAccountColumnKey(ApplyTemplateUtils.getOrgOrAccountColumnKey(main_collect, (List)dimKeyList, (boolean)true));
        mainEntrytemplateConfig.setRefDimKeyMap(ApplyTemplateUtils.getRefDimKeyMap(main_collect));
        mainEntrytemplateConfig.setColumnIndex(ApplyTemplateUtils.getColumnIndexMap(main_collect));
        List notTreeDimColumn = ApplyTemplateUtils.getNotTreeDimColumn(statisticsDimCfg, main_collect, (IModelCacheHelper)modelCacheHelper);
        mainEntrytemplateConfig.setNotTreeDimKeys(notTreeDimColumn);
        mainEntrytemplateConfig.setAggKeys(aggKeys);
        mainEntrytemplateConfig.setSummaryDisplayKeys(summaryDisplayKeys);
        mainEntrytemplateConfig.setModifKeys(modifKeys);
        mainEntrytemplateConfig.setDetailAtColumn(detailAtColumn);
        String unit = template.getString("amountunit");
        mainEntrytemplateConfig.setUnit(StringUtils.isEmpty((CharSequence)unit) ? "1" : unit);
        Map<String, Long> HiddentDimMemMap = BgApplyBillUtils.getInstance().getHiddenDimMemMap(template.getString("cachedata_tag"), datasetId, modelCacheHelper, allDimValSetting);
        mainEntrytemplateConfig.setHiddenDimMemMap(HiddentDimMemMap);
        mainEntrytemplateConfig.setDatasetId(datasetId.longValue());
        Map rowDimisionAutoUpdateColumnKeys = ApplyTemplateUtils.getRowDimisionAutoUpdateColumnKeys(main_collect);
        mainEntrytemplateConfig.setRowDimisionAutoUpdateColumnKeys(rowDimisionAutoUpdateColumnKeys);
        List applyTemplateBizRanges = ApplyTemplateDimRangeService.getInstance().getApplytemplateDimRange((Long)template.getPkValue(), datasetId, modelId);
        mainEntrytemplateConfig.setApplyTemplateBizRanges(applyTemplateBizRanges);
        return mainEntrytemplateConfig;
    }

    public static EntryTemplateConfig createBizEntryConfig(DynamicObject template, List<BaseColumn> biz_collect, String table, Long modelId, Long datasetId, IModelCacheHelper modelCacheHelper, ColumnList columnList, Map<String, Map<String, String>> allDimValSetting) {
        String detailKey = null;
        String combineDimensionKey = null;
        String bizplanTabKey = null;
        for (BaseColumn column : biz_collect) {
            if (column.getKey().startsWith(ApplyTemplateUtils.FIELD_COMBINEDIMENSION)) {
                combineDimensionKey = column.getKey();
                continue;
            }
            if (column.getKey().startsWith(ApplyTemplateUtils.FIELD_DETAILID)) {
                detailKey = column.getKey();
                continue;
            }
            if (!column.getKey().startsWith(ApplyTemplateUtils.FIELD_BIZPLAN_TABKEY)) continue;
            bizplanTabKey = column.getKey();
        }
        Map<String, String> biz_sumcollect = ApplyBillPluginUitl.selectBizEntryAggKeys(biz_collect);
        Set currencyColumnKeys = ApplyTemplateUtils.getCurrencyColumnKeys(biz_collect, (Long)modelId);
        Set rateColumnKeys = ApplyTemplateUtils.getRateColumnAndUpFormula(biz_collect, (Long)modelId);
        List dimKeyList = ApplyTemplateUtils.getDimKeyList(biz_collect);
        List rowDimNumList = ApplyTemplateUtils.getRowDimNumList(biz_collect, (IModelCacheHelper)modelCacheHelper);
        HashMap<String, List> bizplantabkeyfieldsMap = new HashMap<String, List>(16);
        for (BaseColumn baseColumn : biz_collect) {
            String bizPlanTabKey = baseColumn.getBizPlanTabKey();
            if (!StringUtils.isNotEmpty((CharSequence)bizPlanTabKey)) continue;
            bizplantabkeyfieldsMap.computeIfAbsent(bizPlanTabKey, s -> new ArrayList(16)).add(baseColumn.getKey());
        }
        EntryTemplateConfig bizEntrytemplateConfig = new EntryTemplateConfig();
        bizEntrytemplateConfig.setModelId(modelId);
        bizEntrytemplateConfig.setCurrencyColumnKeys(currencyColumnKeys);
        bizEntrytemplateConfig.setRateColumnKeys(rateColumnKeys);
        bizEntrytemplateConfig.setName(template.getString("name"));
        bizEntrytemplateConfig.setNumber(template.getString("number"));
        bizEntrytemplateConfig.setTemplateID(((Long)template.getPkValue()).longValue());
        bizEntrytemplateConfig.setEntryColumns(biz_collect);
        bizEntrytemplateConfig.setBizSumColumns(biz_sumcollect);
        bizEntrytemplateConfig.setEntryTable(table);
        bizEntrytemplateConfig.setCombineDimensionKey(combineDimensionKey);
        bizEntrytemplateConfig.setBizDetailKey(detailKey);
        bizEntrytemplateConfig.setBizPlanTabKey(bizplanTabKey);
        bizEntrytemplateConfig.setDatasetId(datasetId.longValue());
        bizEntrytemplateConfig.setColumnIndex(ApplyTemplateUtils.getColumnIndexMap(biz_collect));
        String unit = template.getString("amountunit");
        bizEntrytemplateConfig.setUnit(StringUtils.isEmpty((CharSequence)unit) ? "1" : unit);
        Map rowDimisionAutoUpdateColumnKeys = ApplyTemplateUtils.getRowDimisionAutoUpdateColumnKeys(biz_collect);
        bizEntrytemplateConfig.setRowDimisionAutoUpdateColumnKeys(rowDimisionAutoUpdateColumnKeys);
        bizEntrytemplateConfig.setDimKeysList(dimKeyList);
        bizEntrytemplateConfig.setRowDimNums(rowDimNumList);
        bizEntrytemplateConfig.setBizplanTabKeyFieldsMap(bizplantabkeyfieldsMap);
        Map<String, Map<String, Long>> bizPlanHiddenDimMemMap = BgApplyBillUtils.getInstance().getBizPlanHiddenDimMemMap(columnList, datasetId, modelCacheHelper, allDimValSetting);
        bizEntrytemplateConfig.setBizPlanHiddenDimMemMap(bizPlanHiddenDimMemMap);
        return bizEntrytemplateConfig;
    }

    public static Map<String, String> selectBizEntryAggKeys(Collection<BaseColumn> biz_collect) {
        HashMap<String, String> biz_sumcollect = new HashMap<String, String>(16);
        for (BaseColumn column : biz_collect) {
            MeasureColumn column1;
            if (column instanceof MeasureColumn) {
                column1 = (MeasureColumn)column;
                if (!column1.isIssummary()) continue;
                biz_sumcollect.put(column1.getKey(), column1.getHcolumnkey());
                continue;
            }
            if (column instanceof NumberColumn) {
                column1 = (NumberColumn)column;
                if (!column1.isIssummary()) continue;
                biz_sumcollect.put(column1.getKey(), column1.getHcolumnkey());
                continue;
            }
            if (column instanceof CalculateColumn) {
                column1 = (CalculateColumn)column;
                if (!column1.isIssummary()) continue;
                biz_sumcollect.put(column1.getKey(), column1.getHcolumnkey());
                continue;
            }
            if (column instanceof RelationValueColumn) {
                column1 = (RelationValueColumn)column;
                if (!column1.isIssummary()) continue;
                biz_sumcollect.put(column1.getKey(), column1.getHcolumnkey());
                continue;
            }
            if (!(column instanceof DimensionDataColumn) || !(column1 = (DimensionDataColumn)column).isIssummary()) continue;
            biz_sumcollect.put(column1.getKey(), column1.getHcolumnkey());
        }
        return biz_sumcollect;
    }

    public static Set<String> getModifKeysFromTempBaseConfig(List<BaseColumn> main_collect, Map<String, ColCfgPropEnum> colConfig) {
        HashSet<String> modifKeys = new HashSet<String>(16);
        if (colConfig != null) {
            main_collect.forEach(column -> {
                ColCfgPropEnum colConfigType = (ColCfgPropEnum)colConfig.get(column.getKey());
                if (ColCfgPropEnum.WRITE == colConfigType && column.getFieldtype() != FieldTypeEnum.BaseDataField) {
                    modifKeys.add(column.getKey());
                }
            });
        }
        return modifKeys;
    }

    public static Set<String> getAggKeysFromTempBaseConfig(List<BaseColumn> main_collect, Map<String, ColCfgPropEnum> colAggConfig) {
        HashSet<String> aggKeys = new HashSet<String>(16);
        if (colAggConfig != null) {
            main_collect.forEach(column -> {
                ColCfgPropEnum colConfigType = (ColCfgPropEnum)colAggConfig.get(column.getKey());
                if (ColCfgPropEnum.AGGREGATE == colConfigType && column.getFieldtype() == FieldTypeEnum.NumberField) {
                    aggKeys.add(column.getKey());
                }
            });
        }
        return aggKeys;
    }

    public static Set<String> getSummaryDisplayKeysFromTempBaseConfig(List<BaseColumn> main_collect, Map<String, ColCfgPropEnum> colSummaryDisplayConfig) {
        HashSet<String> summaryDisplayKeys = new HashSet<String>(16);
        if (colSummaryDisplayConfig != null) {
            main_collect.forEach(column -> {
                ColCfgPropEnum colConfigType = (ColCfgPropEnum)colSummaryDisplayConfig.get(column.getKey());
                if (ColCfgPropEnum.SUMMARYDISPLAY == colConfigType) {
                    summaryDisplayKeys.add(column.getKey());
                }
            });
        }
        return summaryDisplayKeys;
    }

    public static void setColumnBaseStatus(List<BaseColumn> columnList, Map<String, ColCfgPropEnum> colConfig) {
        columnList.forEach(column -> {
            DimensionDataColumn col;
            if (colConfig != null) {
                ColCfgPropEnum colConfigType = (ColCfgPropEnum)colConfig.get(column.getKey());
                if (ColCfgPropEnum.READONLY == colConfigType) {
                    column.setEnable(false);
                } else if (ColCfgPropEnum.HIDE == colConfigType) {
                    column.setBaseVisible(false);
                    column.setEnable(false);
                }
            }
            if (StringUtils.equals((CharSequence)column.getType().getName(), (CharSequence)ColumnEnum.Cal.getName())) {
                column.setEnable(false);
                ColumnStyle columnStyle = new ColumnStyle();
                columnStyle.setBackColor("#fff8e1");
                column.setStyle(columnStyle);
            } else if (StringUtils.equals((CharSequence)column.getType().getName(), (CharSequence)ColumnEnum.DimensionData.getName())) {
                col = (DimensionDataColumn)column;
                if (col.getOpenCalFormula() && StringUtils.isNotEmpty((CharSequence)col.getFormula())) {
                    column.setEnable(false);
                    ColumnStyle columnStyle = new ColumnStyle();
                    columnStyle.setBackColor("#fff8e1");
                    column.setStyle(columnStyle);
                }
            } else if (StringUtils.equals((CharSequence)column.getType().getName(), (CharSequence)ColumnEnum.NumberC.getName())) {
                col = (NumberColumn)column;
                if (StringUtils.isNotEmpty((CharSequence)col.getFormula())) {
                    column.setEnable(false);
                }
            } else if (StringUtils.equals((CharSequence)column.getType().getName(), (CharSequence)ColumnEnum.FixedValue.getName())) {
                column.setEnable(false);
            } else if (StringUtils.equals((CharSequence)column.getType().getName(), (CharSequence)ColumnEnum.Measure.getName()) && column.getIspullfrommodel()) {
                column.setEnable(false);
            }
        });
    }

    public static void setColumnCustomStatus(List<BaseColumn> columnList, Map<Long, Map<String, FormatColumn>> templateColumnsFormat, Long templateId) {
        columnList.forEach(column -> {
            Map formatColumnMap;
            if (templateColumnsFormat != null && (formatColumnMap = (Map)templateColumnsFormat.get(templateId)) != null) {
                String textKey;
                FormatColumn textFormatColumn;
                FormatColumn formatColumn = (FormatColumn)formatColumnMap.get(column.getKey());
                if (formatColumn != null) {
                    if (!formatColumn.isVisible()) {
                        column.setCustomVisible(false);
                    }
                    if (formatColumn.isFreeze()) {
                        column.setFreeze(true);
                    }
                }
                if (column.getKey().contains("_text") && (textFormatColumn = (FormatColumn)formatColumnMap.get(textKey = column.getKey().substring(0, column.getKey().length() - 5))) != null) {
                    if (!textFormatColumn.isVisible()) {
                        column.setCustomVisible(false);
                    }
                    if (textFormatColumn.isFreeze()) {
                        column.setFreeze(true);
                    }
                }
            }
        });
    }

    public static void rollbackBillData(String billNumber, SchemeAssignDimGroup schemeAssignDimGroup, Set<String> refBillNumbs, Long modelId, String billType, CentralAppShowInfo showInfo) {
        Set templateIds = showInfo.getTemplates();
        HashSet<String> billNums = new HashSet<String>(16);
        billNums.addAll(refBillNumbs);
        billNums.add(billNumber);
        QFilter qFilter = new QFilter("approvebillno", "in", billNums);
        List appAdjustRecords = ApproveRecordUtil.getInstance().getAppAdjustRecords(qFilter);
        if (appAdjustRecords.isEmpty()) {
            return;
        }
        Map varInfo = ReportVarUtil.getVarInfo((SchemeAssignDimGroup)schemeAssignDimGroup);
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        FormTypeEnum billFormType = FormTypeEnum.APPROVE;
        Map auditTrailAllCfg = ApplyTemplateColCfgService.getInstance().queryColAuditTrailAllCfgByTemplateId(templateIds, billFormType);
        DBRoute route = new DBRoute("epm");
        BgApplyBillUtils applyBillUtils = BgApplyBillUtils.getInstance();
        Map<Long, EntryTemplateConfig> allTempConfig = ApplyBillPluginUitl.buildTempConfig(templateIds, billFormType, modelCacheHelper, varInfo);
        HashMap<String, EntryTemplateConfig> allTemplateConfig = new HashMap<String, EntryTemplateConfig>(allTempConfig.size());
        allTempConfig.forEach((tempId, config) -> allTemplateConfig.put(tempId.toString(), (EntryTemplateConfig)config));
        Map<Long, Map<String, Map<String, Object>>> finalAdjustVals = ApplyBillPluginUitl.mergeAdjustRecord(appAdjustRecords, allTempConfig);
        showInfo.setAccountSet(null);
        showInfo.setEntitySet(null);
        Map<Long, DetailMembBillData> subSourceData = ApplyBillPluginUitl.getSubSourceData(modelCacheHelper, allTemplateConfig, billNumber, showInfo);
        Map<String, List<Object[]>> allData = applyBillUtils.getAuditBillData(showInfo, billNumber, allTemplateConfig, false);
        Long userId = UserUtils.getUserId();
        Timestamp now = new Timestamp(TimeServiceHelper.now().getTime());
        Map<Long, DetailMembBillData> allSourceData = ApplyBillPluginUitl.buildSourceData(allData, allTemplateConfig, modelCacheHelper);
        for (Map.Entry<Long, Map<String, Map<String, Object>>> adjustValEntry : finalAdjustVals.entrySet()) {
            Long templateId = adjustValEntry.getKey();
            Map<String, Map<String, Object>> allRowAdjustData = adjustValEntry.getValue();
            EntryTemplateConfig templateConfig = allTempConfig.get(templateId);
            DetailMembBillData sourceData = allSourceData.get(templateId);
            HashSet<Long> toDelRowIds = new HashSet<Long>(16);
            HashMap<String, List<Object[]>> toUpVals = new HashMap<String, List<Object[]>>(16);
            ArrayList<AuditRecordObj> recordObjs = new ArrayList<AuditRecordObj>(16);
            Map columnMap = templateConfig.selectColumnMap();
            for (Map.Entry<String, Map<String, Object>> entry : allRowAdjustData.entrySet()) {
                String rowDimMembStr = entry.getKey();
                RowDataStatus rowDataStatus = (RowDataStatus)sourceData.getDetailRowStatus().get(rowDimMembStr);
                if (rowDataStatus == null) continue;
                Object[] rowData = (Object[])sourceData.getAllRowData().get(rowDataStatus.getRowIndex());
                Long rowId = ApplyBillAggHelper.getInstance().getRowId(rowData);
                String refBillNum = ApplyBillAggHelper.getInstance().getBillNumberOnRow(rowData);
                Map<String, Object> rowAdjVals = entry.getValue();
                AuditRecordObj recordObj = new AuditRecordObj();
                Map<String, Long> rowDimMembIds = applyBillUtils.getDimMembList(templateConfig.getDimKeysList(), templateConfig.selectColumnMapDimNum(), rowData, templateConfig.getColumnIndex());
                recordObj.setRowDimGroup(rowDimMembIds);
                recordObj.setTemplateId(templateId);
                recordObj.setDataSetId(Long.valueOf(templateConfig.getDatasetId()));
                for (Map.Entry<String, Object> rowAdjValEntry : rowAdjVals.entrySet()) {
                    AdjustRecordColInfo recordColInfo = new AdjustRecordColInfo();
                    recordColInfo.setKey(rowAdjValEntry.getKey());
                    Object value = rowAdjValEntry.getValue();
                    BaseColumn baseColumn = (BaseColumn)columnMap.get(rowAdjValEntry.getKey());
                    if (baseColumn != null && baseColumn.getFieldtype() == FieldTypeEnum.Date && value instanceof String) {
                        value = DateTimeUtils.parseToDate((String)((String)value));
                        rowAdjValEntry.setValue(value);
                    }
                    recordColInfo.setAdjust(value);
                    recordObj.setDetail(rowDataStatus.isDetail());
                    recordObj.getChangeDataInfos().add(recordColInfo);
                }
                recordObjs.add(recordObj);
                if (refBillNum.equals(billNumber)) {
                    toDelRowIds.add(rowId);
                    continue;
                }
                ApplyBillPluginUitl.rollBackVal(rowData, templateConfig.getColumnIndex(), rowAdjVals);
                ApplyBillPluginUitl.selectToUpdateVal(rowAdjVals, templateConfig.getEntryTable(), userId, now, rowId, toUpVals);
            }
            if (!toDelRowIds.isEmpty()) {
                StringBuilder sql = new StringBuilder();
                sql.append("delete from ").append(templateConfig.getEntryTable()).append(" where fentryid in (").append(SqlBatchUtils.getBatchParamsSql((int)toDelRowIds.size())).append(')');
                DB.execute((DBRoute)route, (String)sql.toString(), (Object[])toDelRowIds.toArray());
            }
            if (!toUpVals.isEmpty()) {
                for (Map.Entry<String, Map<String, Object>> entry : toUpVals.entrySet()) {
                    DB.executeBatch((DBRoute)route, (String)entry.getKey(), (List)((List)((Object)entry.getValue())));
                }
            }
            if (subSourceData != null && subSourceData.size() > 0) {
                sourceData = subSourceData.get(templateId);
            }
            ApplyBillPluginUitl.saveAuditBillOlapData(recordObjs, templateConfig, sourceData, modelCacheHelper, (Map)auditTrailAllCfg.get(templateId));
        }
    }

    public static Map<Long, EntryTemplateConfig> buildTempConfig(Set<Long> templateIds, FormTypeEnum formTypeEnumByBillType, IModelCacheHelper modelCacheHelper, Map<String, Map<String, String>> allDimValSetting) {
        HashMap<Long, EntryTemplateConfig> result = new HashMap<Long, EntryTemplateConfig>(templateIds.size());
        Map templateObjs = BusinessDataServiceHelper.loadFromCache((Object[])templateIds.toArray(), (String)"eb_applytemplate");
        templateObjs.forEach((tempId, tempObj) -> {
            Long templateId = (Long)tempId;
            Long datasetId = tempObj.getLong("dataset_id");
            ColumnList columnList = ApplyTemplateUtils.getEntrycfgByApplyTemplate((DynamicObject)tempObj);
            ApplyTemplateUtils.changeVarOnColumn((ColumnList)columnList, (Long)datasetId, (IModelCacheHelper)modelCacheHelper, (Map)allDimValSetting);
            List<BaseColumn> main_collect = columnList.getColumns().stream().filter(ee -> "h".equals(ee.getCategory())).collect(Collectors.toList());
            Map colConfigMap = ApplyTemplateColCfgService.getInstance().queryColCfgMapByTemplateId(templateId, formTypeEnumByBillType);
            EntryTemplateConfig mainEntryConfig = ApplyBillPluginUitl.createMainEntryConfig(tempObj, main_collect, (String)columnList.getEntityinfomap().get("mainentryentity"), modelCacheHelper, colConfigMap, datasetId, allDimValSetting);
            result.put(templateId, mainEntryConfig);
        });
        return result;
    }

    public static Map<Long, DetailMembBillData> buildSourceData(Map<String, List<Object[]>> allData, Map<String, EntryTemplateConfig> allTempalteConfig, IModelCacheHelper modelCacheHelper) {
        HashMap<Long, DetailMembBillData> result = new HashMap<Long, DetailMembBillData>(allData.size());
        BigDecimal unitData = BigDecimal.ONE;
        for (Map.Entry<String, List<Object[]>> allRowData : allData.entrySet()) {
            DetailMembBillData sourceData = new DetailMembBillData();
            EntryTemplateConfig templateConfig = allTempalteConfig.get(allRowData.getKey());
            long busModelid = templateConfig.getDatasetId();
            Long bizCtrlRangeId = DatasetServiceHelper.getInstance().getBizModelIdByDataSetId(Long.valueOf(busModelid));
            Map viewIds = modelCacheHelper.getViewsByBusModel(bizCtrlRangeId);
            ApplyBillAggHelper.getInstance().initDetailDataGroup(sourceData, allRowData.getValue(), modelCacheHelper, viewIds, unitData, templateConfig);
            result.put(templateConfig.getTemplateID(), sourceData);
        }
        return result;
    }

    public static void rollBackVal(Object[] rowData, Map<String, Integer> columnIndex, Map<String, Object> rowAdjVals) {
        rowAdjVals.forEach((columnKey, adjVal) -> {
            int index = (Integer)columnIndex.get(columnKey);
            if (adjVal instanceof Integer) {
                Integer nowVal = (Integer)rowData[index];
                if (nowVal == null) {
                    nowVal = 0;
                }
                nowVal = nowVal + (Integer)adjVal;
                rowAdjVals.put((String)columnKey, nowVal);
            } else if (adjVal instanceof BigDecimal) {
                BigDecimal nowVal = (BigDecimal)rowData[index];
                if (nowVal == null) {
                    nowVal = BigDecimal.ZERO;
                }
                nowVal = nowVal.add((BigDecimal)adjVal);
                rowAdjVals.put((String)columnKey, nowVal);
            }
        });
    }

    public static Map<Long, Map<String, Map<String, Object>>> mergeAdjustRecord(List<AppAdjustRecord> adjustRecords, Map<Long, EntryTemplateConfig> allTemplateConfig) {
        BgApplyBillUtils applyBillUtils = BgApplyBillUtils.getInstance();
        HashMap<Long, Map<String, Map<String, Object>>> result = new HashMap<Long, Map<String, Map<String, Object>>>(16);
        StringBuilder sb = new StringBuilder();
        adjustRecords.sort(Comparator.comparing(AppAdjustRecord::getApproveTime));
        adjustRecords.forEach(record -> {
            Long templateId = record.getTemplate();
            EntryTemplateConfig templateConfig = (EntryTemplateConfig)allTemplateConfig.get(templateId);
            if (templateConfig != null) {
                Map allRowAdjRecord = result.computeIfAbsent(templateId, k -> new HashMap(16));
                Map dimMembs = record.getDimMemberMap();
                List rowDimNums = templateConfig.getRowDimNums();
                sb.setLength(0);
                for (String dimNum : rowDimNums) {
                    sb.append(dimMembs.get(dimNum)).append(',');
                }
                sb.deleteCharAt(sb.length() - 1);
                Map changeVals = allRowAdjRecord.computeIfAbsent(sb.toString(), key -> new HashMap(16));
                Map baseColumnMap = templateConfig.selectColumnMap();
                record.getColDataInfos().forEach(adjVals -> {
                    String afterAdjust = (String)adjVals.getAfterAdjust();
                    String preAdjust = (String)adjVals.getPreAdjust();
                    BaseColumn column = (BaseColumn)baseColumnMap.get(adjVals.getKey());
                    FieldTypeEnum fieldtype = column.getFieldtype();
                    if (fieldtype == FieldTypeEnum.IntField) {
                        Integer val = (Integer)changeVals.computeIfAbsent(adjVals.getKey(), key -> 0);
                        val = val - applyBillUtils.formatInt(afterAdjust) + applyBillUtils.formatInt(preAdjust);
                        changeVals.put(adjVals.getKey(), val);
                    } else if (fieldtype == FieldTypeEnum.NumberField) {
                        BigDecimal val = (BigDecimal)changeVals.computeIfAbsent(adjVals.getKey(), key -> BigDecimal.ZERO);
                        val = val.subtract(applyBillUtils.formatBigDecimal(afterAdjust)).add(applyBillUtils.formatBigDecimal(preAdjust));
                        changeVals.put(adjVals.getKey(), val);
                    } else if (!changeVals.containsKey(adjVals.getKey())) {
                        changeVals.put(adjVals.getKey(), preAdjust);
                    }
                });
            }
        });
        return result;
    }

    public static Map<String, Map<String, Set<String>>> selectAdjustColumn(List<AppAdjustRecord> adjustRecords, Map<Long, EntryTemplateConfig> allTemplateConfig, Map<Long, String> tempIdMapEntityKey) {
        HashMap<String, Map<String, Set<String>>> result = new HashMap<String, Map<String, Set<String>>>(16);
        StringBuilder sb = new StringBuilder();
        adjustRecords.forEach(record -> {
            Long templateId = record.getTemplate();
            EntryTemplateConfig templateConfig = (EntryTemplateConfig)allTemplateConfig.get(templateId);
            if (templateConfig != null) {
                String entryKey = (String)tempIdMapEntityKey.get(templateId);
                Map allRowAdjRecord = result.computeIfAbsent(entryKey, k -> new HashMap(16));
                Map dimMembs = record.getDimMemberMap();
                List rowDimNums = templateConfig.getRowDimNums();
                sb.setLength(0);
                for (String dimNum : rowDimNums) {
                    sb.append(dimMembs.get(dimNum)).append(',');
                }
                sb.deleteCharAt(sb.length() - 1);
                Set adjustedColumn = allRowAdjRecord.computeIfAbsent(sb.toString(), key -> new HashSet(16));
                record.getColDataInfos().forEach(adjVals -> adjustedColumn.add(adjVals.getKey()));
            }
        });
        return result;
    }

    public static String selectDimMembIdStr(StringBuilder sb, DynamicObject row, List<String> dimColumnKeys) {
        sb.setLength(0);
        for (String dimColumnKey : dimColumnKeys) {
            DynamicObject memb = row.getDynamicObject(dimColumnKey);
            if (memb == null) continue;
            sb.append(memb.getString("id")).append(',');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static void saveAuditBillOlapData(List<AuditRecordObj> auditRecordObjs, EntryTemplateConfig tempConfig, DetailMembBillData detailMembBillData, IModelCacheHelper modelCacheHelper, Map<String, ApplyTemplateAtAllCfgEntity> refAuditTrail) {
        ApplyBillPluginUitl.saveAuditBillOlapData(false, auditRecordObjs, tempConfig, detailMembBillData, modelCacheHelper, refAuditTrail, null);
    }

    public static void updateNewRowChangeRecord(List<AuditRecordObj> auditRecordObjs, EntryTemplateConfig tempConfig, IModelCacheHelper modelCacheHelper) {
        if (auditRecordObjs == null || auditRecordObjs.isEmpty()) {
            return;
        }
        BgApplyBillUtils applyBillUtils = BgApplyBillUtils.getInstance();
        ArrayList<RowDimMembInfo> detailRecord = new ArrayList<RowDimMembInfo>(16);
        HashMap<String, Set<String>> dimMembGroup = new HashMap<String, Set<String>>(16);
        List<BaseColumn> measureCols = tempConfig.getEntryColumns().stream().filter(column -> !(!(column instanceof MeasureColumn) && !(column instanceof DimensionDataColumn) || column.getFieldtype() != FieldTypeEnum.NumberField && column.getFieldtype() != FieldTypeEnum.IntField || !tempConfig.getModifKeys().contains(column.getKey()))).collect(Collectors.toList());
        Map<String, BaseColumn> recordColumnMap = measureCols.stream().collect(Collectors.toMap(BaseColumn::getKey, c -> c));
        ApplyBillPluginUitl.selectRowDimMembInfo(auditRecordObjs, tempConfig, modelCacheHelper, null, detailRecord, new HashMap<Integer, List<Integer>>(16), dimMembGroup, recordColumnMap.keySet(), new HashMap<Integer, String[]>(16));
        Map<String, Map<String, String>> allColDimMembers = applyBillUtils.getAllColDimMembers(measureCols, tempConfig.getDatasetId(), modelCacheHelper, (Boolean)true);
        allColDimMembers.values().forEach(colMembs -> applyBillUtils.mergeMap((Map<String, String>)colMembs, (Map<String, Set<String>>)dimMembGroup));
        Map<String, String> hideDimMembers = BgApplyBillUtils.getInstance().getHideDimMembersFromTempConfig(modelCacheHelper, tempConfig);
        applyBillUtils.mergeMap(hideDimMembers, dimMembGroup);
        Map<MembersKey, Object> olapData = BgApplyBillUtils.getInstance().queryOlapData(modelCacheHelper, modelCacheHelper.getModelobj().getId(), tempConfig.getDatasetId(), dimMembGroup, true, tempConfig.getTemplateID());
        List dimensionList = modelCacheHelper.getDimensionList(Long.valueOf(tempConfig.getDatasetId()));
        ApplyBillPluginUitl.matchOlapData4AuditRecord(hideDimMembers, tempConfig.getRowDimNums(), detailRecord, auditRecordObjs, recordColumnMap, olapData, dimensionList, allColDimMembers, null, (membersKey, dimMemberNums, column, olapVal, adjustInfo) -> {
            if (olapVal != null) {
                Object addSubVal = adjustInfo.getAdjust();
                if (column.getFieldtype() == FieldTypeEnum.NumberField) {
                    adjustInfo.setPreAdjust(olapVal);
                    addSubVal = ((BigDecimal)addSubVal).subtract((BigDecimal)olapVal);
                    adjustInfo.setAdjust(addSubVal);
                } else if (column.getFieldtype() == FieldTypeEnum.IntField) {
                    adjustInfo.setPreAdjust(olapVal);
                    addSubVal = (Integer)addSubVal - (Integer)olapVal;
                    adjustInfo.setAdjust(addSubVal);
                }
            }
        });
    }

    public static void saveAuditBillOlapData(boolean isBlended, List<AuditRecordObj> auditRecordObjs, EntryTemplateConfig tempConfig, DetailMembBillData detailMembBillData, IModelCacheHelper modelCacheHelper, Map<String, ApplyTemplateAtAllCfgEntity> refAuditTrail, String byBillType) {
        if (auditRecordObjs == null || auditRecordObjs.isEmpty()) {
            return;
        }
        Long modelId = modelCacheHelper.getModelobj().getId();
        BgApplyBillUtils applyBillUtils = BgApplyBillUtils.getInstance();
        ArrayList<RowDimMembInfo> detailRecord = new ArrayList<RowDimMembInfo>(16);
        HashMap<Integer, List<Integer>> notDetailRecord = new HashMap<Integer, List<Integer>>(16);
        HashMap<String, Set<String>> dimMembGroup = new HashMap<String, Set<String>>(16);
        List<BaseColumn> measureCols = tempConfig.getEntryColumns().stream().filter(column -> (column instanceof MeasureColumn || column instanceof DimensionDataColumn && !((DimensionDataColumn)column).getOpenCalFormula()) && tempConfig.getModifKeys().contains(column.getKey())).collect(Collectors.toList());
        Map<String, BaseColumn> recordColumnMap = measureCols.stream().collect(Collectors.toMap(c -> c.getKey(), c -> c));
        HashMap<Integer, String[]> detailRowDimMembNums = new HashMap<Integer, String[]>(16);
        ApplyBillPluginUitl.selectRowDimMembInfo(auditRecordObjs, tempConfig, modelCacheHelper, detailMembBillData, detailRecord, notDetailRecord, dimMembGroup, recordColumnMap.keySet(), detailRowDimMembNums);
        if (notDetailRecord.isEmpty() && detailRecord.isEmpty()) {
            return;
        }
        Map<String, Map<String, String>> allColDimMembers = applyBillUtils.getAllColDimMembers(measureCols, tempConfig.getDatasetId(), modelCacheHelper, (Boolean)true);
        allColDimMembers.values().forEach(membMap -> {
            String cfr_ignored_0 = (String)membMap.remove(SysDimensionEnum.AuditTrail.getNumber());
        });
        allColDimMembers.values().forEach(colMembs -> applyBillUtils.mergeMap((Map<String, String>)colMembs, (Map<String, Set<String>>)dimMembGroup));
        Map<String, String> hideDimMembers = BgApplyBillUtils.getInstance().getHideDimMembersFromTempConfig(modelCacheHelper, tempConfig);
        applyBillUtils.mergeMap(hideDimMembers, dimMembGroup);
        Set trailMembs = dimMembGroup.computeIfAbsent(SysDimensionEnum.AuditTrail.getNumber(), key -> new HashSet(16));
        refAuditTrail.values().forEach(membs -> {
            trailMembs.add(membs.getAdjustMembNum());
            trailMembs.add(membs.getRatioMembNum());
            trailMembs.add(membs.getShareMembNum());
        });
        trailMembs.remove("");
        trailMembs.remove(null);
        Map<Object, Object> olapData = new HashMap(16);
        olapData = !ApplyBillPluginUitl.notRejectBill(byBillType) ? BgApplyBillUtils.getInstance().queryOlapData(modelCacheHelper, modelId, tempConfig.getDatasetId(), dimMembGroup, true, tempConfig.getTemplateID()) : BgApplyBillUtils.getInstance().queryOlapDataNotAuth(modelCacheHelper, modelId, tempConfig.getDatasetId(), dimMembGroup, true, tempConfig.getTemplateID());
        log.info("saveAuditBillOlapData==>olapData={}", (Object)SerializationUtils.toJsonString(olapData));
        List dimensionList = modelCacheHelper.getDimensionList(Long.valueOf(tempConfig.getDatasetId()));
        List rowDimNums = tempConfig.getRowDimNums();
        HashMap<MembersKey, OlapDataEntry> detailOlapDataMap = null;
        if (isBlended) {
            detailOlapDataMap = new HashMap<MembersKey, OlapDataEntry>(16);
        }
        List<OlapDataEntry> toSaveOlapData = ApplyBillPluginUitl.addDetailChangeData(hideDimMembers, rowDimNums, detailRecord, auditRecordObjs, recordColumnMap, olapData, dimensionList, allColDimMembers, refAuditTrail, detailOlapDataMap);
        Map<Integer, Map<String, Pair<OlapDataEntry, BigDecimal>>> notDetailOlapData = ApplyBillPluginUitl.shareNotDetailSubData(recordColumnMap, notDetailRecord, auditRecordObjs, rowDimNums, allColDimMembers, olapData, dimensionList, hideDimMembers, detailRowDimMembNums, refAuditTrail, detailMembBillData, detailOlapDataMap);
        log.info("saveAuditBillOlapData==>adjustRecord={}", (Object)SerializationUtils.toJsonString(auditRecordObjs));
        if (detailOlapDataMap != null) {
            toSaveOlapData.addAll(detailOlapDataMap.values());
        }
        notDetailOlapData.values().forEach(v -> v.values().forEach(obj -> toSaveOlapData.add((OlapDataEntry)obj.p1)));
        log.info("saveAuditBillOlapData==>toSaveOlapData={}", (Object)SerializationUtils.toJsonString(toSaveOlapData));
        if (!ApplyBillPluginUitl.notRejectBill(byBillType)) {
            BgApplyBillUtils.getInstance().saveOlapData(toSaveOlapData, tempConfig.getDatasetId(), UserUtils.getUserId(), modelCacheHelper, tempConfig.getNumber());
        } else {
            BgApplyBillUtils.getInstance().saveOlapData(toSaveOlapData, tempConfig.getDatasetId(), UserUtils.getUserId(), modelCacheHelper, false, tempConfig.getNumber());
        }
    }

    private static boolean notRejectBill(String byBillType) {
        if (byBillType == null) {
            return false;
        }
        return byBillType.equals(ApplyBillType.APPLYREJECT.getNumber()) || byBillType.equals(ApplyBillType.REJECT.getNumber()) || byBillType.equals(ApplyBillType.COLLECTREJECT.getNumber());
    }

    private static Map<String, String> getDimNumMapColumn(List<String> dimColunmkeys, List<String> dimNums) {
        HashMap<String, String> result = new HashMap<String, String>(dimColunmkeys.size());
        for (int i = 0; i < dimColunmkeys.size(); ++i) {
            result.put(dimNums.get(i), dimColunmkeys.get(i));
        }
        return result;
    }

    private static void selectRowDimMembInfo(List<AuditRecordObj> auditRecordObjs, EntryTemplateConfig tempConfig, IModelCacheHelper modelCacheHelper, DetailMembBillData detailMembBillData, List<RowDimMembInfo> detailRecord, Map<Integer, List<Integer>> notDetailRecord, Map<String, Set<String>> dimMembGroup, Set<String> recordColumnKeys, Map<Integer, String[]> detailRowDimMembNums) {
        HashMap<String, Dimension> dimensionCache = new HashMap<String, Dimension>(16);
        Map columnMapDimNum = tempConfig.selectColumnMapDimNum();
        Map columnIndex = tempConfig.getColumnIndex();
        List dimKeysList = tempConfig.getDimKeysList();
        List rowDimNums = tempConfig.getRowDimNums();
        Map<String, String> dimNumMapColumn = ApplyBillPluginUitl.getDimNumMapColumn(dimKeysList, rowDimNums);
        int index = -1;
        HashMap<String, String> dimMembMap = new HashMap<String, String>(16);
        HashMap<String, Long> dimViewMap = new HashMap<String, Long>(16);
        for (AuditRecordObj recordObj : auditRecordObjs) {
            ++index;
            boolean hasRecordColumn = false;
            for (AdjustRecordColInfo record : recordObj.getChangeDataInfos()) {
                if (!recordColumnKeys.contains(record.getKey())) continue;
                hasRecordColumn = true;
                break;
            }
            if (!hasRecordColumn) continue;
            if (recordObj.isDetail()) {
                String[] rowDimMembNums = ApplyBillPluginUitl.seletDimMemb(recordObj, modelCacheHelper, dimViewMap, dimensionCache, rowDimNums);
                for (int i = 0; i < rowDimNums.size(); ++i) {
                    Set membNums = dimMembGroup.computeIfAbsent((String)rowDimNums.get(i), (Function<String, Set<String>>)((Function<String, Set>)key -> new HashSet(16)));
                    membNums.add(rowDimMembNums[i]);
                }
                RowDimMembInfo info = new RowDimMembInfo(index, rowDimMembNums);
                detailRecord.add(info);
                continue;
            }
            if (detailMembBillData == null) continue;
            ApplyBillPluginUitl.seletDimMemb(recordObj, dimMembMap, dimNumMapColumn, dimViewMap, modelCacheHelper, dimensionCache);
            List<Integer> detailRowIndex = ApplyBillAggHelper.getInstance().getDetailRowDataIndex(dimMembMap, tempConfig.getDimKeysList(), tempConfig.getColumnIndex(), detailMembBillData);
            for (Integer rowIndex : detailRowIndex) {
                if (detailRowDimMembNums.containsKey(rowIndex)) continue;
                Object[] row = (Object[])detailMembBillData.getAllRowData().get(rowIndex);
                String[] rowDimMembNums = ApplyBillPluginUitl.seletDimMemb(row, dimKeysList, modelCacheHelper, dimViewMap, dimensionCache, columnMapDimNum, columnIndex);
                for (int i = 0; i < rowDimNums.size(); ++i) {
                    Set membNums = dimMembGroup.computeIfAbsent((String)rowDimNums.get(i), (Function<String, Set<String>>)((Function<String, Set>)key -> new HashSet(16)));
                    membNums.add(rowDimMembNums[i]);
                }
                detailRowDimMembNums.put(rowIndex, rowDimMembNums);
            }
            notDetailRecord.put(index, detailRowIndex);
        }
    }

    private static void matchOlapData4AuditRecord(Map<String, String> hideDimMembers, List<String> rowDimNums, List<RowDimMembInfo> detailRecord, List<AuditRecordObj> auditRecordObjs, Map<String, BaseColumn> recordColumnMap, Map<MembersKey, Object> olapData, List<Dimension> dimensionList, Map<String, Map<String, String>> allColDimMembers, Map<String, ApplyTemplateAtAllCfgEntity> refAuditTrail, OlapDataConsumer olapDataConsumer) {
        for (RowDimMembInfo membInfo : detailRecord) {
            int index = membInfo.getRowIndex();
            AuditRecordObj recordObj = auditRecordObjs.get(index);
            HashMap<String, String> rowDimMembNums = new HashMap<String, String>(16);
            String[] membNums = membInfo.getDimMembNums();
            for (int i = 0; i < rowDimNums.size(); ++i) {
                rowDimMembNums.put(rowDimNums.get(i), membNums[i]);
            }
            for (AdjustRecordColInfo adjustInfo : recordObj.getChangeDataInfos()) {
                ApplyTemplateAtAllCfgEntity auditTrailNums;
                String columnKey = adjustInfo.getKey();
                BaseColumn column = recordColumnMap.get(columnKey);
                if (column == null) continue;
                Map<String, String> colDimMembs = allColDimMembers.get(columnKey);
                HashMap<String, String> dimMembNums = new HashMap<String, String>(16);
                dimMembNums.putAll(colDimMembs);
                dimMembNums.putAll(rowDimMembNums);
                dimMembNums.putAll(hideDimMembers);
                if (refAuditTrail != null && (auditTrailNums = refAuditTrail.get(columnKey)) != null && StringUtils.isNotEmpty((CharSequence)auditTrailNums.getAdjustMembNum())) {
                    dimMembNums.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrailNums.getAdjustMembNum());
                }
                MembersKey membersKey = BgApplyBillUtils.getInstance().getMembersKey(dimMembNums, dimensionList);
                Object olapVal = olapData.get(membersKey);
                olapDataConsumer.apply(membersKey, dimMembNums, column, olapVal, adjustInfo);
            }
        }
    }

    private static List<OlapDataEntry> addDetailChangeData(Map<String, String> hideDimMembers, List<String> rowDimNums, List<RowDimMembInfo> detailRecord, List<AuditRecordObj> auditRecordObjs, Map<String, BaseColumn> recordColumnMap, Map<MembersKey, Object> olapData, List<Dimension> dimensionList, Map<String, Map<String, String>> allColDimMembers, Map<String, ApplyTemplateAtAllCfgEntity> refAuditTrail, Map<MembersKey, OlapDataEntry> detailOlapDataMap) {
        ArrayList<OlapDataEntry> toSaveOlapData = new ArrayList<OlapDataEntry>(16);
        ApplyBillPluginUitl.matchOlapData4AuditRecord(hideDimMembers, rowDimNums, detailRecord, auditRecordObjs, recordColumnMap, olapData, dimensionList, allColDimMembers, refAuditTrail, (membersKey, dimMemberNums, column, olapVal, adjustInfo) -> {
            Object addSubVal = adjustInfo.getAdjust();
            OlapDataEntry olapDataEntry = new OlapDataEntry();
            olapDataEntry.setDimMemMap(dimMemberNums);
            if (column.getFieldtype() == FieldTypeEnum.NumberField) {
                olapDataEntry.setValue(olapVal == null ? addSubVal : new BigDecimal(addSubVal.toString()).add(new BigDecimal(olapVal.toString())));
            } else if (column.getFieldtype() == FieldTypeEnum.IntField) {
                olapDataEntry.setValue(olapVal == null ? addSubVal : Integer.valueOf((Integer)addSubVal + (Integer)olapVal));
            } else {
                olapDataEntry.setValue(addSubVal);
            }
            if (detailOlapDataMap != null) {
                detailOlapDataMap.put(membersKey, olapDataEntry);
            } else {
                toSaveOlapData.add(olapDataEntry);
            }
        });
        return toSaveOlapData;
    }

    private static Map<Integer, Map<String, Pair<OlapDataEntry, BigDecimal>>> shareNotDetailSubData(Map<String, BaseColumn> recordColumnMap, Map<Integer, List<Integer>> notDetailRecord, List<AuditRecordObj> auditRecordObjs, List<String> rowDimNums, Map<String, Map<String, String>> allColDimMembers, Map<MembersKey, Object> olapData, List<Dimension> dimensionList, Map<String, String> hideDimMembers, Map<Integer, String[]> detailRowDimMembNums, Map<String, ApplyTemplateAtAllCfgEntity> refAuditTrail, DetailMembBillData detailMembBillData, Map<MembersKey, OlapDataEntry> detailOlapDataMap) {
        int recordColumnSize = recordColumnMap.size();
        HashMap<Integer, Map<String, Pair<OlapDataEntry, BigDecimal>>> toSaveData = new HashMap<Integer, Map<String, Pair<OlapDataEntry, BigDecimal>>>(16);
        for (Map.Entry<Integer, List<Integer>> entry : notDetailRecord.entrySet()) {
            int recordIndex = entry.getKey();
            List<Integer> detailRowIndex = entry.getValue();
            AuditRecordObj recordObj = auditRecordObjs.get(recordIndex);
            List changeDataInfos = recordObj.getChangeDataInfos();
            HashMap<String, BigDecimal> totalVals = new HashMap<String, BigDecimal>(recordColumnSize);
            for (Integer index : detailRowIndex) {
                HashMap<String, String> rowDimMembNums = new HashMap<String, String>(16);
                String[] membNums = detailRowDimMembNums.get(index);
                for (int i = 0; i < rowDimNums.size(); ++i) {
                    rowDimMembNums.put(rowDimNums.get(i), membNums[i]);
                }
                Map changeVals = toSaveData.computeIfAbsent(index, key -> new HashMap(recordColumnSize));
                for (AdjustRecordColInfo adjustRecord : changeDataInfos) {
                    String columnKey = adjustRecord.getKey();
                    if (!recordColumnMap.containsKey(columnKey)) continue;
                    BigDecimal total = totalVals.computeIfAbsent(columnKey, key -> BigDecimal.ZERO);
                    Pair changeValPair = (Pair)changeVals.get(columnKey);
                    if (changeValPair == null) {
                        Object data;
                        BigDecimal applyVal;
                        OlapDataEntry olapDataEntry;
                        HashMap<String, String> dimMembNums = new HashMap<String, String>(16);
                        Map<String, String> colDimMembs = allColDimMembers.get(columnKey);
                        dimMembNums.putAll(colDimMembs);
                        dimMembNums.putAll(rowDimMembNums);
                        dimMembNums.putAll(hideDimMembers);
                        ApplyTemplateAtAllCfgEntity auditTrailNums = refAuditTrail.get(columnKey);
                        if (auditTrailNums != null) {
                            dimMembNums.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrailNums.getShareMembNum());
                        }
                        MembersKey membersKey = BgApplyBillUtils.getInstance().getMembersKey(dimMembNums, dimensionList);
                        if (detailOlapDataMap == null || (olapDataEntry = detailOlapDataMap.remove(membersKey)) == null) {
                            olapDataEntry = new OlapDataEntry();
                            BigDecimal shareVal = (BigDecimal)olapData.get(membersKey);
                            olapDataEntry.setDimMemMap(dimMembNums);
                            olapDataEntry.setValue((Object)(shareVal == null ? BigDecimal.ZERO : shareVal));
                        }
                        HashMap<String, String> dimMembNumsNew = new HashMap<String, String>(dimMembNums);
                        if (auditTrailNums != null) {
                            dimMembNumsNew.put(SysDimensionEnum.AuditTrail.getNumber(), auditTrailNums.getRatioMembNum());
                        }
                        changeValPair = new Pair((Object)olapDataEntry, (Object)((applyVal = ConvertUtils.toDecimal((Object)(data = olapData.get(membersKey = BgApplyBillUtils.getInstance().getMembersKey(dimMembNumsNew, dimensionList))))) == null ? BigDecimal.ZERO : applyVal.abs()));
                        changeVals.put(columnKey, changeValPair);
                    }
                    total = total.add((BigDecimal)changeValPair.p2);
                    totalVals.put(columnKey, total);
                }
            }
            for (AdjustRecordColInfo adjustRecord : changeDataInfos) {
                BigDecimal sumData;
                String columnKey = adjustRecord.getKey();
                if (!recordColumnMap.containsKey(columnKey)) continue;
                Object adjust = adjustRecord.getAdjust();
                BigDecimal changeSubVal = ConvertUtils.toDecimal((Object)adjust);
                if (changeSubVal == null) {
                    changeSubVal = BigDecimal.ZERO;
                }
                BigDecimal bigDecimal = sumData = totalVals.get(columnKey) == null ? BigDecimal.ZERO : (BigDecimal)totalVals.get(columnKey);
                if (sumData.compareTo(BigDecimal.ZERO) == 0) {
                    int earliestRow = ApplyBillPluginUitl.getEarliestRow(detailMembBillData.getAllRowData(), detailRowIndex);
                    if (earliestRow == -1) continue;
                    Pair changeVals = (Pair)((Map)toSaveData.get(earliestRow)).get(columnKey);
                    BigDecimal newData = (BigDecimal)((OlapDataEntry)changeVals.p1).getValue();
                    if (newData == null) {
                        newData = BigDecimal.ZERO;
                    }
                    ((OlapDataEntry)changeVals.p1).setValue((Object)newData.add(changeSubVal));
                    continue;
                }
                BigDecimal lastVal = changeSubVal.add(BigDecimal.ZERO);
                int lastIndex = detailRowIndex.size() - 1;
                for (int i = 0; i <= lastIndex; ++i) {
                    BigDecimal shareData;
                    Integer rowIndex = detailRowIndex.get(i);
                    Pair changeVals = (Pair)((Map)toSaveData.get(rowIndex)).get(columnKey);
                    if (i == lastIndex) {
                        shareData = lastVal;
                    } else {
                        BigDecimal calcData = (BigDecimal)changeVals.p2;
                        shareData = calcData.divide(sumData, 10, RoundingMode.HALF_UP).multiply(changeSubVal).setScale(2, RoundingMode.HALF_UP);
                        lastVal = lastVal.subtract(shareData);
                    }
                    BigDecimal newData = (BigDecimal)((OlapDataEntry)changeVals.p1).getValue();
                    if (newData == null) {
                        newData = BigDecimal.ZERO;
                    }
                    ((OlapDataEntry)changeVals.p1).setValue((Object)newData.add(shareData));
                }
            }
        }
        return toSaveData;
    }

    public static int getEarliestRow(List<Object[]> allRowData, List<Integer> rowIndexs) {
        int result = -1;
        ApplyBillAggHelper billAggHelper = ApplyBillAggHelper.getInstance();
        Timestamp earliestCreateTime = null;
        for (int index : rowIndexs) {
            Object[] rowData = allRowData.get(index);
            Timestamp createTime = billAggHelper.getCreateTime(rowData);
            if (earliestCreateTime != null && !createTime.before(earliestCreateTime)) continue;
            result = index;
            earliestCreateTime = createTime;
        }
        return result;
    }

    private static String[] seletDimMemb(AuditRecordObj recordObj, IModelCacheHelper modelCacheHelper, Map<String, Long> dimViewMap, Map<String, Dimension> dimensionCache, List<String> rowDimNums) {
        String[] result = new String[recordObj.getRowDimGroup().size()];
        int index = 0;
        for (String rowDimNum : rowDimNums) {
            Dimension dimension = dimensionCache.computeIfAbsent(rowDimNum, key -> modelCacheHelper.getDimension(rowDimNum));
            Member member = dimension.getMember(dimViewMap.get(rowDimNum), (Long)recordObj.getRowDimGroup().get(rowDimNum));
            result[index] = member.getNumber();
            ++index;
        }
        return result;
    }

    private static String[] seletDimMemb(Object[] rowObjects, List<String> dimColumnKeys, IModelCacheHelper modelCacheHelper, Map<String, Long> dimViewMap, Map<String, Dimension> dimensionCache, Map<String, String> columnMapDimNum, Map<String, Integer> columnIndex) {
        String[] result = new String[dimColumnKeys.size()];
        int index = 0;
        for (String dimColumnKey : dimColumnKeys) {
            String dimNum = columnMapDimNum.get(dimColumnKey);
            Long membId = (Long)rowObjects[columnIndex.get(dimColumnKey)];
            Dimension dimension = dimensionCache.computeIfAbsent(dimNum, key -> modelCacheHelper.getDimension(dimNum));
            Member member = dimension.getMember(dimViewMap.get(dimNum), membId);
            result[index] = member.getNumber();
            ++index;
        }
        return result;
    }

    private static void seletDimMemb(AuditRecordObj recordObj, Map<String, String> dimMembNums, Map<String, String> dimNumMapColumn, Map<String, Long> dimViewMap, IModelCacheHelper modelCacheHelper, Map<String, Dimension> dimensionCache) {
        dimMembNums.clear();
        for (Map.Entry dimMemb : recordObj.getRowDimGroup().entrySet()) {
            String dimNum = (String)dimMemb.getKey();
            Dimension dimension = dimensionCache.computeIfAbsent(dimNum, key -> modelCacheHelper.getDimension(dimNum));
            Member member = dimension.getMember(dimViewMap.get(dimNum), (Long)dimMemb.getValue());
            dimMembNums.put(dimNumMapColumn.get(dimNum), member.getNumber());
        }
    }

    public static void selectToUpdateVal(Map<String, Object> changedVal, String tableName, Long userId, Timestamp nowTime, Long rowId, Map<String, List<Object[]>> toUpdateVals) {
        StringBuilder sb = new StringBuilder();
        sb.append("update ").append(tableName).append(" set ");
        Object[] paramVals = new Object[changedVal.size() + 3];
        int count = 0;
        for (Map.Entry<String, Object> valEntry : changedVal.entrySet()) {
            sb.append('f').append(valEntry.getKey()).append("=?,");
            paramVals[count] = valEntry.getValue();
            ++count;
        }
        sb.append("fmodifier").append("=?,");
        sb.append("fmodifydate").append("=?");
        sb.append(" where fentryid = ?");
        paramVals[count++] = userId;
        paramVals[count++] = nowTime;
        paramVals[count++] = rowId;
        String sql = sb.toString();
        List rowVals = toUpdateVals.computeIfAbsent(sql, k -> new ArrayList(16));
        rowVals.add(paramVals);
    }

    public static void changeValValue(Collection<BaseColumn> columns, Map<String, Map<String, String>> varInfo, IModelCacheHelper modelCacheHelper) {
    }

    public static Long getReportSchemeByBill(String billNumber, String billType) {
        Long schemeId = 0L;
        if (StringUtils.isNotEmpty((CharSequence)billNumber)) {
            if (ApplyBillType.APPLYAUDIT.getNumber().equals(billType) || ApplyBillType.COLLECYAUDIT.getNumber().equals(billType) || ApplyBillType.COLLECTAUDITSTATISTICS.getNumber().equals(billType) || ApplyBillType.AUDITSTATISTICS.getNumber().equals(billType)) {
                schemeId = ApplyBillPluginUitl.getReportSchemeByBill(billNumber, "reportscheme", "billno", "eb_centralappbill");
            } else if (ApplyBillType.APPLY.getNumber().equals(billType) || ApplyBillType.COLLECY.getNumber().equals(billType) || ApplyBillType.APPLYSTATISTICS.getNumber().equals(billType) || ApplyBillType.COLLECTSTATISTICS.getNumber().equals(billType) || ApplyBillType.COLLECTVIEWSTATISTICS.getNumber().equals(billType) || ApplyBillType.COLLECYVIEW.getNumber().equals(billType)) {
                schemeId = ApplyBillPluginUitl.getReportSchemeByBill(billNumber, "applyscheme", "billnumber", "eb_bgapplybill");
            } else if (ApplyBillType.SPLIT.getNumber().equals(billType)) {
                schemeId = ApplyBillPluginUitl.getReportSchemeByBill(billNumber, "bgapplyscheme", "billnumber", "eb_bgdecompose");
            } else if (ApplyBillType.REJECT.getNumber().equals(billType) || ApplyBillType.APPLYREJECT.getNumber().equals(billType) || ApplyBillType.COLLECTREJECT.getNumber().equals(billType)) {
                schemeId = ApplyBillPluginUitl.getReportSchemeByBill(billNumber, "applyscheme", "billnumber", "eb_bgapplybill");
            }
        }
        return schemeId;
    }

    private static Long getReportSchemeByBill(String billNumber, String propKey, String numbKey, String entryKey) {
        DynamicObject schemeObj;
        QFilter numberFilter = new QFilter(numbKey, "=", (Object)billNumber);
        DynamicObject billObj = BusinessDataServiceHelper.loadSingleFromCache((String)entryKey, (String)propKey, (QFilter[])new QFilter[]{numberFilter});
        if (billObj != null && (schemeObj = billObj.getDynamicObject(propKey)) != null) {
            return schemeObj.getLong("id");
        }
        return 0L;
    }

    public static SchemeAssignDimGroup getReportSchemeAssignDimGroupByBill(String billNumber, String billType) {
        SchemeAssignDimGroup schemeAssignDimGroup = new SchemeAssignDimGroup();
        if (StringUtils.isNotEmpty((CharSequence)billNumber)) {
            DynamicObject billObj;
            if (ApplyBillType.APPLYAUDIT.getNumber().equals(billType) || ApplyBillType.COLLECYAUDIT.getNumber().equals(billType) || ApplyBillType.COLLECTAUDITSTATISTICS.getNumber().equals(billType) || ApplyBillType.AUDITSTATISTICS.getNumber().equals(billType) || ApplyBillType.AUDIT.getNumber().equals(billType)) {
                schemeAssignDimGroup = ApplyBillPluginUitl.getReportSchemeAssignDimGroupByBill(billNumber, "reportscheme", "billno", "eb_centralappbill");
            } else if (ApplyBillType.APPLY.getNumber().equals(billType) || ApplyBillType.COLLECY.getNumber().equals(billType) || ApplyBillType.APPLYSTATISTICS.getNumber().equals(billType) || ApplyBillType.COLLECTSTATISTICS.getNumber().equals(billType) || ApplyBillType.COLLECTVIEWSTATISTICS.getNumber().equals(billType) || ApplyBillType.COLLECYVIEW.getNumber().equals(billType)) {
                schemeAssignDimGroup = ApplyBillPluginUitl.getReportSchemeAssignDimGroupByBill(billNumber, "applyscheme", "billnumber", "eb_bgapplybill");
            } else if (ApplyBillType.SPLIT.getNumber().equals(billType)) {
                schemeAssignDimGroup = ApplyBillPluginUitl.getReportSchemeAssignDimGroupByBill(billNumber, "bgapplyscheme", "billnumber", "eb_bgdecompose");
            } else if ((ApplyBillType.REJECT.getNumber().equals(billType) || ApplyBillType.APPLYREJECT.getNumber().equals(billType) || ApplyBillType.COLLECTREJECT.getNumber().equals(billType)) && (billObj = QueryServiceHelper.queryOne((String)"eb_bgapplybill", (String)"srcbillnumber", (QFilter[])new QFilter[]{new QFilter("billnumber", "=", (Object)billNumber)})) != null) {
                schemeAssignDimGroup = ApplyBillPluginUitl.getReportSchemeAssignDimGroupByBill(billObj.getString("srcbillnumber"), ApplyBillType.AUDIT.getNumber());
            }
        }
        return schemeAssignDimGroup;
    }

    private static SchemeAssignDimGroup getReportSchemeAssignDimGroupByBill(String billNumber, String schemePropKey, String numbKey, String entryKey) {
        QFilter numberFilter = new QFilter(numbKey, "=", (Object)billNumber);
        DynamicObject billObj = QueryServiceHelper.queryOne((String)entryKey, (String)(schemePropKey + ",year,version,datatype,model"), (QFilter[])new QFilter[]{numberFilter});
        if (billObj != null) {
            return new SchemeAssignDimGroup(Long.valueOf(billObj.getLong("model")), Long.valueOf(billObj.getLong(schemePropKey)), Long.valueOf(billObj.getLong("year")), Long.valueOf(billObj.getLong("version")), Long.valueOf(billObj.getLong("datatype")));
        }
        return new SchemeAssignDimGroup();
    }

    public static List<String> getMatchSourceKeys(List<String> sourceKeys, int rowIndex, IDataModel model) {
        ArrayList<String> matchFields = new ArrayList<String>(16);
        ArrayList<String> tempFileds = new ArrayList<String>(16);
        for (String key : sourceKeys) {
            if (key.contains("|")) {
                String[] arrs = key.split("\\|");
                tempFileds.addAll(Arrays.asList(arrs));
                continue;
            }
            tempFileds.add(key);
        }
        if (!tempFileds.isEmpty()) {
            for (String tempFiled : tempFileds) {
                DynamicObject dynamicObject = (DynamicObject)model.getValue(tempFiled, rowIndex);
                Long id = dynamicObject == null ? 0L : dynamicObject.getLong("id");
                if (id == 0L) continue;
                matchFields.add(tempFiled);
            }
        }
        return matchFields.stream().distinct().collect(Collectors.toList());
    }

    public static void arrangeCombine(List<List<Long>> arrays, List<Long> tempRes, int depth, List<List<Long>> results) {
        if (depth == arrays.size()) {
            results.add(new ArrayList<Long>(tempRes));
            return;
        }
        List<Long> currentArray = arrays.get(depth);
        for (int i = 0; i < currentArray.size(); ++i) {
            tempRes.add(currentArray.get(i));
            ApplyBillPluginUitl.arrangeCombine(arrays, tempRes, depth + 1, results);
            tempRes.remove(tempRes.size() - 1);
        }
    }

    public static Map<String, List<Map<String, String>>> getRowMemberByFilterDimensionScheme(List<BaseColumn> enableSchemeRowDims) {
        HashMap<String, List<Map<String, String>>> result = new HashMap<String, List<Map<String, String>>>(16);
        for (BaseColumn rowDimColumn : enableSchemeRowDims) {
            if (!(rowDimColumn instanceof RowDimensionColumn)) continue;
            RowDimensionColumn rowDimensionColumn = (RowDimensionColumn)rowDimColumn;
            List dimensionRelationSchemas = rowDimensionColumn.getDimensionRelationSchemas();
            QFilter qSchemaFilter = new QFilter("id", "in", (Object)dimensionRelationSchemas);
            Map schemes = BusinessDataServiceHelper.loadFromCache((String)"epm_dimensionrelation", (String)"id,entryentity.seq,entryentity.dimension", (QFilter[])new QFilter[]{qSchemaFilter});
            Collection values = schemes.values();
            HashMap<Long, Integer> relatonIdMapDimSize = new HashMap<Long, Integer>(16);
            HashMap<Long, Map> relationIdMapMap = new HashMap<Long, Map>(16);
            for (DynamicObject value : values) {
                Long relationId = value.getLong("id");
                DynamicObjectCollection dynamicObjectCollection = value.getDynamicObjectCollection("entryentity");
                relatonIdMapDimSize.put(relationId, dynamicObjectCollection.size());
                for (DynamicObject entry : dynamicObjectCollection) {
                    String seq = entry.getString("seq");
                    String dimNumber = entry.getString("dimension.number");
                    String field = "dimension" + seq;
                    Map stringStringMap = relationIdMapMap.computeIfAbsent(relationId, s -> new LinkedHashMap(16));
                    stringStringMap.put(dimNumber, field);
                }
            }
            Integer max = (Integer)Collections.max(new ArrayList(relatonIdMapDimSize.values()));
            ArrayList<Long> relationIds = new ArrayList<Long>(16);
            for (Map.Entry entry : relatonIdMapDimSize.entrySet()) {
                Integer value = (Integer)entry.getValue();
                Long key = (Long)entry.getKey();
                if (!Objects.equals(value, max)) continue;
                relationIds.add(key);
            }
            QFilter qFilter2 = new QFilter("relationid", "in", relationIds);
            qFilter2.and(new QFilter("status", "=", (Object)"1"));
            Map map = BusinessDataServiceHelper.loadFromCache((String)"epm_dimmemberrelation", (String)"relationid,dimension1,dimension2,dimension3,dimension4,dimension5,dimension6", (QFilter[])new QFilter[]{qFilter2});
            HashMap<Long, List> relationIdMapDatas = new HashMap<Long, List>(16);
            for (DynamicObject value : map.values()) {
                long relationid = value.getLong("relationid.id");
                List dynamicObjects = relationIdMapDatas.computeIfAbsent(relationid, s -> new ArrayList(16));
                dynamicObjects.add(value);
            }
            for (Long relationId : relationIds) {
                List dynamicObjects = (List)relationIdMapDatas.get(relationId);
                Map stringStringMap = (Map)relationIdMapMap.get(relationId);
                for (DynamicObject dynamicObject : dynamicObjects) {
                    String keyj = String.join((CharSequence)"!", stringStringMap.keySet());
                    HashMap<String, String> map2 = new HashMap<String, String>(16);
                    for (Map.Entry stringStringEntry : stringStringMap.entrySet()) {
                        String dimNumber = (String)stringStringEntry.getKey();
                        String field = (String)stringStringEntry.getValue();
                        map2.put(dimNumber, dynamicObject.getString(field));
                    }
                    List strings = result.computeIfAbsent(keyj, s -> new ArrayList(16));
                    strings.add(map2);
                }
            }
        }
        return result;
    }

    public static Map<String, ApplyTemplateDimensionRelation> getTargetKeyMapApplyTemplateDimensionRelations(List<BaseColumn> allColumns) {
        HashMap<String, ApplyTemplateDimensionRelation> mapResult = new HashMap<String, ApplyTemplateDimensionRelation>(16);
        List enableSchemeRowDims = allColumns.stream().filter(s -> {
            RowDimensionColumn rowDimensionColumn;
            return s instanceof RowDimensionColumn && (rowDimensionColumn = (RowDimensionColumn)s).getEnableDimensionRelation() != false && !rowDimensionColumn.getDimensionRelationSchemas().isEmpty();
        }).collect(Collectors.toList());
        if (enableSchemeRowDims.isEmpty()) {
            return mapResult;
        }
        for (BaseColumn rowDimColumn : enableSchemeRowDims) {
            Map stringStringMap;
            if (!(rowDimColumn instanceof RowDimensionColumn)) continue;
            ApplyTemplateDimensionRelation result = new ApplyTemplateDimensionRelation();
            result.setRelationDimColumn(rowDimColumn);
            mapResult.put(rowDimColumn.getKey(), result);
            HashMap relationIdMapSourceIdjoinMapTargetIds = new HashMap(16);
            result.setRelationIdMapSourceIdjoinMapTargetIds(relationIdMapSourceIdjoinMapTargetIds);
            RowDimensionColumn rowDimensionColumn = (RowDimensionColumn)rowDimColumn;
            List dimensionRelationSchemas = rowDimensionColumn.getDimensionRelationSchemas();
            QFilter qSchemaFilter = new QFilter("id", "in", (Object)dimensionRelationSchemas);
            Map schemes = BusinessDataServiceHelper.loadFromCache((String)"epm_dimensionrelation", (String)"id,entryentity.seq,entryentity.dimension", (QFilter[])new QFilter[]{qSchemaFilter});
            Collection values = schemes.values();
            HashMap<Long, Integer> relatonIdMapDimSize = new HashMap<Long, Integer>(16);
            HashMap<Long, Map> relationIdMapMap = new HashMap<Long, Map>(16);
            for (DynamicObject value : values) {
                Long relationId = value.getLong("id");
                DynamicObjectCollection dynamicObjectCollection = value.getDynamicObjectCollection("entryentity");
                relatonIdMapDimSize.put(relationId, dynamicObjectCollection.size());
                for (DynamicObject entry : dynamicObjectCollection) {
                    String seq = entry.getString("seq");
                    String dimNumber = entry.getString("dimension.number");
                    String field = "dimension" + seq;
                    stringStringMap = relationIdMapMap.computeIfAbsent(relationId, s -> new LinkedHashMap(16));
                    stringStringMap.put(dimNumber, field);
                }
            }
            Integer max = (Integer)Collections.max(new ArrayList(relatonIdMapDimSize.values()));
            ArrayList<Long> relationIds = new ArrayList<Long>(16);
            for (Map.Entry entry : relatonIdMapDimSize.entrySet()) {
                Integer value = (Integer)entry.getValue();
                Long key = (Long)entry.getKey();
                if (!Objects.equals(value, max)) continue;
                relationIds.add(key);
            }
            QFilter qFilter2 = new QFilter("relationid", "in", relationIds);
            qFilter2.and(new QFilter("status", "=", (Object)"1"));
            Map map = BusinessDataServiceHelper.loadFromCache((String)"epm_dimmemberrelation", (String)"relationid,dimension1,dimension2,dimension3,dimension4,dimension5,dimension6", (QFilter[])new QFilter[]{qFilter2});
            HashMap<Long, List> relationIdMapDatas = new HashMap<Long, List>(16);
            for (DynamicObject value : map.values()) {
                long relationid = value.getLong("relationid.id");
                List dynamicObjects = relationIdMapDatas.computeIfAbsent(relationid, s -> new ArrayList(16));
                dynamicObjects.add(value);
            }
            HashMap relationIdMapsourceDimNumbersMap = new HashMap(16);
            for (Long relationId : relationIds) {
                List dynamicObjects = (List)relationIdMapDatas.get(relationId);
                stringStringMap = (Map)relationIdMapMap.get(relationId);
                ArrayList<String> fieldv = new ArrayList<String>(16);
                LinkedHashMap<String, Set> sourceMapTargetIds = new LinkedHashMap<String, Set>();
                relationIdMapSourceIdjoinMapTargetIds.put(relationId, sourceMapTargetIds);
                result.setRelationIdMapsourceDimNumbersMap(relationIdMapsourceDimNumbersMap);
                ArrayList<String> sourceDimNumbers = new ArrayList<String>(16);
                relationIdMapsourceDimNumbersMap.put(relationId, sourceDimNumbers);
                int i = 0;
                for (DynamicObject dynamicObject : dynamicObjects) {
                    fieldv.clear();
                    String keyj = String.join((CharSequence)"!", stringStringMap.keySet());
                    Long targetId = 0L;
                    for (Map.Entry stringStringEntry : stringStringMap.entrySet()) {
                        String dimNumber = (String)stringStringEntry.getKey();
                        String field = (String)stringStringEntry.getValue();
                        if (dimNumber.equals(rowDimensionColumn.getDimNumber())) {
                            targetId = dynamicObject.getLong(field);
                            continue;
                        }
                        if (i == 0) {
                            sourceDimNumbers.add(dimNumber);
                        }
                        fieldv.add(dynamicObject.getString(field));
                    }
                    String sourceStr = String.join((CharSequence)"_", fieldv);
                    Set targetIds = sourceMapTargetIds.computeIfAbsent(sourceStr, s -> new HashSet(16));
                    targetIds.add(targetId);
                    ++i;
                }
            }
        }
        return mapResult;
    }

    private static Map<Long, DetailMembBillData> getSubSourceData(IModelCacheHelper modelCacheHelper, Map<String, EntryTemplateConfig> allTemplateConfig, String billNumber, CentralAppShowInfo showInfo) {
        Long parentId;
        Map<Long, DetailMembBillData> subSourceData = null;
        ApproveBill approveBill = ApproveBillUtil.getInstance().getApproveBill(new QFilter("billno", "=", (Object)billNumber));
        if (approveBill != null && IDUtils.isNotNull((Long)(parentId = approveBill.getParentId()))) {
            showInfo.setApproveBillConfigs(approveBill.getApproveconfig());
            Map<String, List<Object[]>> subData = BgApplyBillUtils.getInstance().getAuditBillDataNew(showInfo, billNumber, allTemplateConfig, false, false);
            subSourceData = ApplyBillPluginUitl.buildSourceData(subData, allTemplateConfig, modelCacheHelper);
        }
        return subSourceData;
    }
}

