/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.applybill.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.applytemplate.config.service.ApplyTemplateDimAreaCfgService;
import kd.epm.eb.business.ebupgrades.utils.UpgradesTaskUtil;
import kd.epm.eb.common.applyTemplate.TempDimConfig;
import kd.epm.eb.common.applyTemplate.entity.tableconfig.BizTableConfig;
import kd.epm.eb.common.applyTemplate.entity.tableconfig.DimFlexInfo;
import kd.epm.eb.common.applytemplatecolumn.BaseColumn;
import kd.epm.eb.common.applytemplatecolumn.CalculateColumn;
import kd.epm.eb.common.applytemplatecolumn.ColumnList;
import kd.epm.eb.common.applytemplatecolumn.DataMapDimension;
import kd.epm.eb.common.applytemplatecolumn.DimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.DimensionDataColumn;
import kd.epm.eb.common.applytemplatecolumn.MeasureColumn;
import kd.epm.eb.common.applytemplatecolumn.RelationDimensionColumn;
import kd.epm.eb.common.applytemplatecolumn.RowDimensionColumn;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.ApplyDimAreaPanelEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;

public class ApplyTemplateUpgradeHelper {
    private static final Log log = LogFactory.getLog(ApplyTemplateUpgradeHelper.class);
    private static final ApplyTemplateUpgradeHelper instance = new ApplyTemplateUpgradeHelper();
    private static final ApplyTemplateDimAreaCfgService dimAreaCfgService = ApplyTemplateDimAreaCfgService.getInstance();
    private IModelCacheHelper modelCacheHelper;
    private Map<Long, String> varIdNumberMap;

    public static ApplyTemplateUpgradeHelper getInstance() {
        return instance;
    }

    public void upgrade(IFormView view, Long modelId) {
        List<DynamicObject> needUpgradeTemplates = this.checkNeedUpgradeTemplates(modelId);
        if (needUpgradeTemplates.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u7684\u7533\u62a5\u6a21\u677f\u65e0\u9700\u5347\u7ea7\u3002", (String)"ApplyTemplateUpgradeHelper_1", (String)"epm-eb-business", (Object[])new Object[0]));
            return;
        }
        this.doUpgrade(modelId, needUpgradeTemplates);
        view.showSuccessNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f\u3002", (String)"ApplyTemplateUpgradeHelper_2", (String)"epm-eb-business", (Object[])new Object[0]));
    }

    private void doUpgrade(Long modelId, List<DynamicObject> needUpgradeTemplates) {
        if (CollectionUtils.isEmpty(needUpgradeTemplates)) {
            return;
        }
        this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        this.varIdNumberMap = QueryServiceHelper.query((String)"eb_periodvariable", (String)"id,number", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray()).stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getString("number")));
        long startUpgradeTime = System.currentTimeMillis();
        log.info("needUpgradeTemplates size : " + needUpgradeTemplates.size());
        for (DynamicObject object : needUpgradeTemplates) {
            long dataSetId = object.getLong("dataset.id");
            DimFlexInfo dimFlexInfo = new DimFlexInfo();
            List tempDimConfigList = SerializationUtils.fromJsonStringToList((String)object.getString("cachedata_tag"), TempDimConfig.class);
            tempDimConfigList.forEach(arg_0 -> ((DimFlexInfo)dimFlexInfo).addDimConfig(arg_0));
            ColumnList columnList = (ColumnList)SerializationUtils.fromJsonString((String)object.getString("entrycfgjson_tag"), ColumnList.class);
            this.upgradeColumns(dataSetId, columnList);
            BizTableConfig bizTableConfig = this.setDefaultBizTableConfig(dataSetId, columnList, dimFlexInfo);
            object.set("entrycfgjson_tag", (Object)SerializationUtils.toJsonString((Object)columnList));
            if (bizTableConfig == null) continue;
            this.upgradeBizPlanTable(bizTableConfig, (String)columnList.getEntityinfomap().get("bizentryentity"));
        }
        SaveServiceHelper.save((DynamicObject[])needUpgradeTemplates.toArray(new DynamicObject[0]));
        log.info("upgrade time :" + (System.currentTimeMillis() - startUpgradeTime));
    }

    private void upgradeBizPlanTable(BizTableConfig bizTableConfig, String bizEntryTable) {
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)("alter table " + bizEntryTable + " add (fbizplantabkey nvarchar(100) default '');"));
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (String)("update " + bizEntryTable + " set fbizplantabkey = '" + bizTableConfig.getTabKey() + "' where fbillnumber != '';"));
    }

    private List<DynamicObject> checkNeedUpgradeTemplates(Long modelId) {
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"eb_applytemplate", (String)"entrycfgjson_tag,cachedata_tag,dataset", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray());
        return Arrays.stream(objects).filter(e -> !StringUtils.include((String)e.getString("entrycfgjson_tag"), (String)"bizTableConfigList")).collect(Collectors.toList());
    }

    private BizTableConfig setDefaultBizTableConfig(Long dataSetId, ColumnList columnList, DimFlexInfo dimFlexInfo) {
        List<BaseColumn> bizColumnList = columnList.getColumns().stream().filter(c -> ApplyDimAreaPanelEnum.BIZ.getColumnCategory().equals(c.getCategory())).collect(Collectors.toList());
        if (!bizColumnList.isEmpty()) {
            BizTableConfig bizTableConfig = new BizTableConfig(GlobalIdUtil.genStringId().toLowerCase());
            bizTableConfig.setSort(0);
            bizTableConfig.setTabNumber("default");
            bizTableConfig.setTabName(ResManager.loadKDString((String)"\u9ed8\u8ba4\u4e1a\u52a1\u8ba1\u5212", (String)"ApplyTemplateDimAreaEditPlugin_22", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            bizTableConfig.setDimFlexInfo(dimFlexInfo);
            bizTableConfig.setColumnKeys(this.getBizColumnKeys(dataSetId, columnList.getColumns(), bizColumnList, bizTableConfig, dimFlexInfo.getRowDims()));
            bizColumnList.forEach(e -> e.setBizPlanTabKey(bizTableConfig.getTabKey()));
            columnList.addBizTableConfig(bizTableConfig);
            return bizTableConfig;
        }
        return null;
    }

    private Set<String> getBizColumnKeys(Long dataSetId, Collection<BaseColumn> columns, List<BaseColumn> bizColumnList, BizTableConfig bizTableConfig, Set<String> mainRowDims) {
        Set existKeys = columns.stream().map(BaseColumn::getKey).collect(Collectors.toSet());
        List mainColumns = columns.stream().filter(e -> ApplyDimAreaPanelEnum.MAIN.getColumnCategory().equals(e.getCategory())).collect(Collectors.toList());
        List defaultDimColumns = dimAreaCfgService.getDefaultRowDimColumns(this.modelCacheHelper, dataSetId, mainRowDims, ApplyDimAreaPanelEnum.BIZ.getColumnCategory(), existKeys);
        for (RowDimensionColumn bizRowDimColumn : defaultDimColumns) {
            Optional<BaseColumn> first;
            bizRowDimColumn.setBizPlanTabKey(bizTableConfig.getTabKey());
            String dimNumber = bizRowDimColumn.getDimNumber();
            if (!mainRowDims.contains(dimNumber) || !(first = mainColumns.stream().filter(e -> e instanceof RowDimensionColumn && ((RowDimensionColumn)e).getDimNumber().equals(dimNumber)).findFirst()).isPresent()) continue;
            RowDimensionColumn rowDimensionColumn = (RowDimensionColumn)first.get();
            bizRowDimColumn.setDimensionMemberRanges(rowDimensionColumn.getDimensionMemberRanges());
            bizRowDimColumn.setEnableDimensionRelation(rowDimensionColumn.getEnableDimensionRelation());
            bizRowDimColumn.setDimensionRelationSchemas(rowDimensionColumn.getDimensionRelationSchemas());
        }
        bizColumnList.addAll(defaultDimColumns);
        columns.addAll(defaultDimColumns);
        return bizColumnList.stream().map(BaseColumn::getKey).collect(Collectors.toSet());
    }

    private void upgradeColumns(Long dataSetId, ColumnList columnList) {
        Collection columns = columnList.getColumns();
        ArrayList<Object> afterUpdateColumns = new ArrayList<Object>(columns.size());
        for (BaseColumn column : columns) {
            DimensionDataColumn dimensionDataColumn;
            RowDimensionColumn rowDimensionColumn;
            RowDimensionColumn updateColumn = null;
            if (column instanceof DimensionColumn) {
                DimensionColumn dimensionColumn = (DimensionColumn)column;
                updateColumn = rowDimensionColumn = new RowDimensionColumn();
                this.setBaseColumnFields((BaseColumn)dimensionColumn, (BaseColumn)rowDimensionColumn);
                rowDimensionColumn.setHide(Boolean.valueOf(false));
                rowDimensionColumn.setShowOptionEnum(dimensionColumn.getShowOptionEnum());
                rowDimensionColumn.setBussinessModelId(dimensionColumn.getBussinessModelId());
                rowDimensionColumn.setDimensionId(dimensionColumn.getDimensionId());
                rowDimensionColumn.setDimensionMemberRanges(dimensionColumn.getDimensionMemberRanges());
                rowDimensionColumn.setDimNumber(dimensionColumn.getDimNumber());
                rowDimensionColumn.setEnableDimensionRelation(Boolean.valueOf(false));
            } else if (column instanceof RelationDimensionColumn) {
                RelationDimensionColumn relationDimensionColumn = (RelationDimensionColumn)column;
                updateColumn = rowDimensionColumn = new RowDimensionColumn();
                this.setBaseColumnFields((BaseColumn)relationDimensionColumn, (BaseColumn)rowDimensionColumn);
                Dimension dimension = this.modelCacheHelper.getDimension(Long.valueOf(relationDimensionColumn.getDimensionId()));
                rowDimensionColumn.setHide(Boolean.valueOf(false));
                rowDimensionColumn.setShowOptionEnum(relationDimensionColumn.getShowOptionEnum());
                rowDimensionColumn.setBussinessModelId(relationDimensionColumn.getBussinessModelId());
                rowDimensionColumn.setDimensionId(relationDimensionColumn.getDimensionId());
                rowDimensionColumn.setDimNumber(dimension != null ? dimension.getDimNum() : null);
                rowDimensionColumn.setDimensionMemberRanges(relationDimensionColumn.getDimensionMemberRanges());
                rowDimensionColumn.setEnableDimensionRelation(Boolean.valueOf(true));
                rowDimensionColumn.setDimensionRelationSchemas(Collections.singletonList(relationDimensionColumn.getDimensionBussSchemeId()));
            } else if (column instanceof MeasureColumn) {
                MeasureColumn measureColumn = (MeasureColumn)column;
                dimensionDataColumn = new DimensionDataColumn();
                updateColumn = dimensionDataColumn;
                this.setBaseColumnFields((BaseColumn)measureColumn, (BaseColumn)dimensionDataColumn);
                dimensionDataColumn.setIsaggregation(measureColumn.isIsaggregation());
                dimensionDataColumn.setSummaryDisplay(measureColumn.isSummaryDisplay());
                dimensionDataColumn.setBeforesubmitnolook(measureColumn.isBeforesubmitnolook());
                dimensionDataColumn.setDataMapDimensions(this.dealDataMapDimensions(dataSetId, measureColumn.getDataMapDimensions()));
                dimensionDataColumn.setIssummary(measureColumn.isIssummary());
                dimensionDataColumn.setHcolumnkey(measureColumn.getHcolumnkey());
                dimensionDataColumn.setContainRowDim(measureColumn.isContainRowDim());
                dimensionDataColumn.setFormula("");
            } else if (column instanceof CalculateColumn) {
                CalculateColumn calculateColumn = (CalculateColumn)column;
                dimensionDataColumn = new DimensionDataColumn();
                updateColumn = dimensionDataColumn;
                this.setBaseColumnFields((BaseColumn)calculateColumn, (BaseColumn)dimensionDataColumn);
                dimensionDataColumn.setBeforesubmitnolook(calculateColumn.isBeforesubmitnolook());
                dimensionDataColumn.setDataMapDimensions(this.dealDataMapDimensions(dataSetId, calculateColumn.getDataMapDimensions()));
                dimensionDataColumn.setIssummary(calculateColumn.isIssummary());
                dimensionDataColumn.setHcolumnkey(calculateColumn.getHcolumnkey());
                dimensionDataColumn.setFormula(calculateColumn.getFormula());
                dimensionDataColumn.setOpenCalFormula(true);
            }
            if (updateColumn != null) {
                afterUpdateColumns.add(updateColumn);
                continue;
            }
            afterUpdateColumns.add(column);
        }
        columns.clear();
        columns.addAll(afterUpdateColumns);
    }

    private List<DataMapDimension> dealDataMapDimensions(Long dataSetId, List<DataMapDimension> dataMapDimensions) {
        if (CollectionUtils.isEmpty(dataMapDimensions)) {
            return dataMapDimensions;
        }
        for (DataMapDimension dataMapDimension : dataMapDimensions) {
            Dimension dimension;
            String dimNum = dataMapDimension.getDimNum();
            long dimensionId = dataMapDimension.getDimensionId();
            String membNum = dataMapDimension.getMembNum();
            long dimensionRememberId = dataMapDimension.getDimensionRememberId();
            if (dimNum != null || (dimension = this.modelCacheHelper.getDimension(Long.valueOf(dimensionId))) == null) continue;
            dataMapDimension.setDimNum(dimension.getNumber());
            if (membNum != null || !IDUtils.isNotEmptyLong((Long)dimensionRememberId).booleanValue()) continue;
            if (dataMapDimension.isVar()) {
                dataMapDimension.setMembNum(this.varIdNumberMap.get(dimensionRememberId));
                continue;
            }
            Long viewId = this.modelCacheHelper.getViewByDataSetAndDimNumber(dataSetId, dimension.getNumber());
            Member member = dimension.getMember(viewId, Long.valueOf(dimensionRememberId));
            if (member == null) continue;
            dataMapDimension.setMembNum(member.getNumber());
        }
        return dataMapDimensions;
    }

    private void setBaseColumnFields(BaseColumn oldColumn, BaseColumn newColumn) {
        newColumn.setWidth(oldColumn.getWidth());
        newColumn.setBaseVisible(oldColumn.isBaseVisible());
        newColumn.setCustomVisible(oldColumn.isCustomVisible());
        newColumn.setStyle(oldColumn.getStyle());
        newColumn.setEnable(oldColumn.isEnable());
        newColumn.setFireUpdEvt(oldColumn.isFireUpdEvt());
        newColumn.setScale(oldColumn.getScale());
        newColumn.setEnumdata(oldColumn.getEnumdata());
        newColumn.setCategory(oldColumn.getCategory());
        newColumn.setIsdoubletitle(oldColumn.isIsdoubletitle());
        newColumn.setGrouptitle(oldColumn.getGrouptitle());
        newColumn.setPkid(oldColumn.getPkId());
        newColumn.setSort(oldColumn.getSort());
        newColumn.setTitle(oldColumn.getTitle());
        newColumn.setKey(oldColumn.getKey());
        newColumn.setIsmustinput(oldColumn.getIsmustinput().booleanValue());
        newColumn.setIspullfrommodel(oldColumn.getIspullfrommodel());
        newColumn.setBaseEntityId(oldColumn.getBaseEntityId());
        newColumn.setFreeze(oldColumn.isFreeze());
        newColumn.setIgnoreDB(oldColumn.isIgnoreDB());
        newColumn.setFieldtype(oldColumn.getFieldtype());
    }

    public void restoreOldData(IFormView view, Long modelId) {
        HashSet<Long> pkIds = new HashSet<Long>(16);
        String sql = "select fid from t_eb_applytemplate_bak where fmodelid = ? ";
        try (DataSet ds = DB.queryDataSet((String)"queryPkIds", (DBRoute)DBRoute.of((String)"epm"), (String)sql, (Object[])new Object[]{modelId});){
            while (ds.hasNext()) {
                pkIds.add(ds.next().getLong("fid"));
            }
        }
        if (pkIds.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u56de\u6eda\u7684\u6570\u636e\u3002", (String)"ApplyTemplateUpgradeHelper_3", (String)"epm-eb-business", (Object[])new Object[0]));
            return;
        }
        log.info("rollBack Data:" + SerializationUtils.toJsonString(pkIds));
        QFilter qFilter = new QFilter("fmodelid", "=", (Object)modelId).and("fid", "in", pkIds);
        UpgradesTaskUtil.getInstance().rollDataFromBak("t_eb_applytemplate", qFilter.toString());
        view.showSuccessNotification(ResManager.loadKDString((String)"\u8fd8\u539f\u6210\u529f\u3002", (String)"ApplyTemplateUpgradeHelper_4", (String)"epm-eb-business", (Object[])new Object[0]));
    }

    public void backOldData(Long modelId) {
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"eb_applytemplate", (String)"id,entrycfgjson_tag", (QFilter[])new QFilter("model", "=", (Object)modelId).toArray());
        Set ids = Arrays.stream(objects).filter(e -> !StringUtils.include((String)e.getString("entrycfgjson_tag"), (String)"bizTableConfigList")).map(e -> e.getLong("id")).collect(Collectors.toSet());
        if (ids.size() == 0) {
            return;
        }
        UpgradesTaskUtil.getInstance().backupsDataByIds("t_eb_applytemplate", ids, "fid");
    }
}

