/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.approveBill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.approvetype.ApproveUtils;
import kd.epm.eb.business.decompose.service.DataDecomposeService;
import kd.epm.eb.business.ebupgrades.utils.UpgradesTaskUtil;
import kd.epm.eb.business.utils.WorkFlowUtil;
import kd.epm.eb.common.approveBill.Entity.ApproveBillStatus;
import kd.epm.eb.common.approveBill.Entity.CentralBillType;
import kd.epm.eb.common.approveBill.LocalApproveDimMemLock;
import kd.epm.eb.common.bgmddatalock.v2.DataLockService;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.ebcommon.common.enums.RangeEnum;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.reportprocess.helper.MemberHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.cache.Cache;

public class ApproveBillServiceHelper {
    private static final Log log = LogFactory.getLog(ApproveBillServiceHelper.class);

    public static void stopWorkFlowForOldBills(Set<Long> approveBillIds) {
        log.info("stopWorkFlowForOldBills approveBillIds={}", approveBillIds);
        Map<Long, List<Long>> billReportMap = ApproveUtils.getInstance().getReportProcessIdsByBillIds(approveBillIds);
        if (CollectionUtils.isEmpty(billReportMap)) {
            log.error("stopWorkFlowForOldBills approveBillIds={}, billReportMap is empty", approveBillIds);
            return;
        }
        HashSet<Long> reportIds = new HashSet<Long>(16);
        billReportMap.values().stream().forEach(ids -> reportIds.addAll((Collection<Long>)ids));
        Map<Long, Set<Long>> reportBillMap = ApproveBillServiceHelper.getReportBillMap(reportIds, CentralBillType.Normal);
        if (CollectionUtils.isEmpty(reportBillMap)) {
            log.error("stopWorkFlowForOldBills approveBillIds={}, reportBillMap is empty", approveBillIds);
            return;
        }
        HashSet<Long> oldBillIds = new HashSet<Long>(16);
        for (Map.Entry<Long, Set<Long>> entry : reportBillMap.entrySet()) {
            Optional<Long> optional;
            Set<Long> billIds = entry.getValue();
            if (billIds.size() < 2 || !(optional = billIds.stream().filter(id -> !approveBillIds.contains(id)).findFirst()).isPresent()) continue;
            oldBillIds.add(optional.get());
        }
        if (oldBillIds.isEmpty()) {
            log.error("stopWorkFlowForOldBills approveBillIds={}, oldBillIds is empty", approveBillIds);
            return;
        }
        Map<Long, List<Long>> oldBillReportMap = ApproveUtils.getInstance().getReportProcessIdsByBillIds(oldBillIds);
        HashSet<Long> oldReportIds = new HashSet<Long>(16);
        oldBillReportMap.values().stream().forEach(ids -> oldReportIds.addAll((Collection<Long>)ids));
        Map<Long, Set<Long>> oldReportBillMap = ApproveBillServiceHelper.getReportBillMap(oldReportIds, CentralBillType.Normal);
        if (CollectionUtils.isEmpty(oldReportBillMap)) {
            log.error("stopWorkFlowForOldBills approveBillIds={}, oldReportBillMap is empty", approveBillIds);
            return;
        }
        HashSet<String> stopBillIds = new HashSet<String>(16);
        for (Map.Entry<Long, List<Long>> entry : oldBillReportMap.entrySet()) {
            Long approveBillId = entry.getKey();
            List<Long> processIds = entry.getValue();
            boolean isAllOccupy = true;
            for (Long processId : processIds) {
                Set<Long> billIds = oldReportBillMap.get(processId);
                if (!CollectionUtils.isEmpty(billIds) && billIds.size() >= 2) continue;
                isAllOccupy = false;
                break;
            }
            if (!isAllOccupy) continue;
            stopBillIds.add(approveBillId.toString());
        }
        log.info("stopWorkFlowForOldBills approveBillIds={}, stopBillIds={}", approveBillIds, stopBillIds);
        if (!stopBillIds.isEmpty()) {
            WorkFlowUtil.stopWorkFlowProcess(stopBillIds);
        }
    }

    public static Set<Long> getReportBillMap(Long reportId, CentralBillType billType) {
        return ApproveBillServiceHelper.getReportBillMap(Collections.singleton(reportId), billType).get(reportId);
    }

    public static Map<Long, Set<Long>> getReportBillMap(Collection<Long> reportIds, CentralBillType billType) {
        QFilter reportFilter = new QFilter("id", "in", reportIds);
        DynamicObjectCollection reportList = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id,model,period,version,datatype,entity,template", (QFilter[])reportFilter.toArray());
        HashSet<Long> periodIds = new HashSet<Long>(16);
        HashSet<Long> versionIds = new HashSet<Long>(16);
        HashSet<Long> dataTypeIds = new HashSet<Long>(16);
        HashSet<Long> templateIds = new HashSet<Long>(16);
        HashSet<Long> entityIds = new HashSet<Long>(16);
        Long modelId = 0L;
        HashMap<String, Long> dimReportMap = new HashMap<String, Long>(16);
        StringBuilder dimStr = new StringBuilder();
        for (DynamicObject report : reportList) {
            Long reportId = report.getLong("id");
            modelId = report.getLong("model");
            Long periodId = report.getLong("period");
            Long versionId = report.getLong("version");
            Long datatypeId = report.getLong("datatype");
            Long templateId = report.getLong("template");
            Long entityId = report.getLong("entity");
            periodIds.add(periodId);
            versionIds.add(versionId);
            dataTypeIds.add(datatypeId);
            templateIds.add(templateId);
            entityIds.add(entityId);
            dimStr.append(periodId).append('!').append(versionId).append('!').append(datatypeId).append('!').append(templateId).append('!').append(entityId);
            dimReportMap.put(dimStr.toString(), reportId);
            dimStr.setLength(0);
        }
        QFilter qFilter = new QFilter("modelid", "=", (Object)modelId);
        qFilter.and("dim_period", "in", periodIds);
        qFilter.and("dim_version", "in", versionIds);
        qFilter.and("dim_datatype", "in", dataTypeIds);
        qFilter.and("entryentity.tempid", "in", templateIds);
        qFilter.and("eborgid", "in", entityIds);
        if (billType != null) {
            qFilter.and("splitbilltype", "=", (Object)billType.getNumber());
        }
        qFilter.and("billstatus", "!=", (Object)ApproveBillStatus.DISCARD.getNumber());
        String fields = "id, dim_datatype, dim_period, dim_version, eborgid, entryentity.tempid as tempid";
        DynamicObjectCollection approveBills = QueryServiceHelper.query((String)"eb_approvebill", (String)fields, (QFilter[])qFilter.toArray(), (String)"createdate desc");
        HashMap<Long, Set<Long>> reportBillMap = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject approveBill : approveBills) {
            Long billId = approveBill.getLong("id");
            Long periodId = approveBill.getLong("dim_period");
            Long versionId = approveBill.getLong("dim_version");
            Long datatypeId = approveBill.getLong("dim_datatype");
            Long templateId = approveBill.getLong("tempid");
            Long entityId = approveBill.getLong("eborgid");
            String signKey = periodId + "!" + versionId + "!" + datatypeId + "!" + templateId + "!" + entityId;
            Long reportId = (Long)dimReportMap.get(signKey);
            Set billIds = reportBillMap.computeIfAbsent(reportId, v -> new LinkedHashSet(16));
            billIds.add(billId);
        }
        return reportBillMap;
    }

    public static void unauditReportsForLocal(Set<Long> reportIds) {
        log.info("unauditReportsForLocal reportIds={}", reportIds);
        HashSet<Long> approveBillIds = new HashSet<Long>(16);
        DynamicObjectCollection reportList = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id,approvebill", (QFilter[])new QFilter[]{new QFilter("id", "in", reportIds)});
        for (DynamicObject report : reportList) {
            Long approveBillId = report.getLong("approvebill");
            approveBillIds.add(approveBillId);
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("update t_eb_reportprocess set fstatus = '0', fsubmitdate = null, fsubmituser = 0, fsubmitentity = 0, fapprovebill = 0 where ", new Object[0]);
        sqlBuilder.appendIn("fid", reportIds.toArray());
        sqlBuilder.append(" and (fmodifier = 0 or fmodifier is null)", new Object[0]);
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
        sqlBuilder = new SqlBuilder();
        sqlBuilder.append("update t_eb_reportprocess set fstatus = '7', fsubmitdate = null, fsubmituser = 0, fsubmitentity = 0, fapprovebill = 0 where ", new Object[0]);
        sqlBuilder.appendIn("fid", reportIds.toArray());
        sqlBuilder.append(" and fmodifier != 0", new Object[0]);
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
        UpgradesTaskUtil.getInstance().clearDataEntityCache("eb_reportprocess");
        QFilter qFilter = new QFilter("approvebillid", "in", approveBillIds);
        DynamicObjectCollection localApproveBills = QueryServiceHelper.query((String)"eb_localapprovebill", (String)"approvebillid,model,bizmodel,org.number,orgviewid,version,datatype,period", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)localApproveBills)) {
            return;
        }
        HashMap<Long, LocalApproveDimMemLock> approveDimMemLockMap = new HashMap<Long, LocalApproveDimMemLock>(16);
        for (DynamicObject localApproveBill : localApproveBills) {
            Long approveBillId = localApproveBill.getLong("approvebillid");
            LocalApproveDimMemLock dimMemLock = new LocalApproveDimMemLock();
            dimMemLock.setApproveBillId(approveBillId);
            dimMemLock.setModelId(Long.valueOf(localApproveBill.getLong("model")));
            dimMemLock.setBizModelId(Long.valueOf(localApproveBill.getLong("bizmodel")));
            dimMemLock.setPeriodId(Long.valueOf(localApproveBill.getLong("period")));
            dimMemLock.setVersionId(Long.valueOf(localApproveBill.getLong("version")));
            dimMemLock.setDatatypeId(Long.valueOf(localApproveBill.getLong("datatype")));
            dimMemLock.setEntityNumber(localApproveBill.getString("org.number"));
            approveDimMemLockMap.put(approveBillId, dimMemLock);
        }
        ApproveBillServiceHelper.unlockDimMem(approveDimMemLockMap);
    }

    public static void unauditReportsForWF(Set<Long> approveBillIds, Set<Long> reportIds) {
        DynamicObject[] approveBills;
        log.info("unauditReportsForWF approveBillIds={}, reportIds={}", approveBillIds, reportIds);
        QFilter reportFilter = new QFilter("id", "in", reportIds);
        DynamicObjectCollection reportList = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id,model,template", (QFilter[])reportFilter.toArray());
        HashMap<Long, Long> reportModelMap = new HashMap<Long, Long>(reportIds.size());
        HashSet<Long> removeTempIds = new HashSet<Long>(16);
        for (DynamicObject report : reportList) {
            removeTempIds.add(report.getLong("template"));
            reportModelMap.put(report.getLong("id"), report.getLong("model"));
        }
        HashMap<Long, LocalApproveDimMemLock> approveDimMemLockMap = new HashMap<Long, LocalApproveDimMemLock>(16);
        for (DynamicObject approveBill : approveBills = BusinessDataServiceHelper.load((Object[])approveBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_approvebill"))) {
            DynamicObjectCollection entryEntity = approveBill.getDynamicObjectCollection("entryentity");
            HashSet<Long> tempIds = new HashSet<Long>(16);
            for (DynamicObject entry : entryEntity) {
                Long tempId = entry.getLong("tempid.id");
                tempIds.add(tempId);
            }
            Set updateTempIds = tempIds.stream().filter(id -> !removeTempIds.contains(id)).collect(Collectors.toSet());
            DynamicObjectCollection tempList = approveBill.getDynamicObjectCollection("entryentity");
            tempList.clear();
            for (Long tempId : updateTempIds) {
                DynamicObject entry = tempList.addNew();
                entry.set("tempid", (Object)tempId);
            }
            Long approveBillId = approveBill.getLong("id");
            LocalApproveDimMemLock dimMemLock = new LocalApproveDimMemLock();
            dimMemLock.setApproveBillId(approveBillId);
            dimMemLock.setModelId(Long.valueOf(approveBill.getLong("modelid.id")));
            dimMemLock.setBizModelId(Long.valueOf(approveBill.getLong("bizmodelid.id")));
            dimMemLock.setPeriodId(Long.valueOf(approveBill.getLong("dim_period.id")));
            dimMemLock.setVersionId(Long.valueOf(approveBill.getLong("dim_version.id")));
            dimMemLock.setDatatypeId(Long.valueOf(approveBill.getLong("dim_datatype.id")));
            dimMemLock.setEntityNumber(approveBill.getString("eborgid.number"));
            dimMemLock.setOrgViewId(Long.valueOf(approveBill.getLong("orgviewid.id")));
            approveDimMemLockMap.put(approveBillId, dimMemLock);
        }
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])approveBills);
                ApproveBillServiceHelper.updateReports(approveBills, approveBillIds, removeTempIds);
            }
            catch (Throwable e) {
                tx.markRollback();
                log.error(e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
        }
        ApproveBillServiceHelper.unlockDimMem(approveDimMemLockMap);
        DataDecomposeService.getInstance().deleteAdjustRecordForReportUnaudit(reportModelMap);
    }

    private static void updateReports(DynamicObject[] approveBills, Set<Long> approveBillIds, Set<Long> removeTempIds) {
        DynamicObject[] reportProcessList;
        Long modelId = approveBills[0].getLong("modelid.id");
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        HashSet<Long> periodIds = new HashSet<Long>(16);
        HashSet<Long> versionIds = new HashSet<Long>(16);
        HashSet<Long> datatypeIds = new HashSet<Long>(16);
        HashSet entityIds = new HashSet(16);
        for (DynamicObject approveBill : approveBills) {
            Long orgId = approveBill.getLong("eborgid.id");
            Long orgViewId = approveBill.getLong("orgviewid.id");
            Set orgIds = MemberHelper.getEntityIdSetByView((IModelCacheHelper)modelCacheHelper, (Long)orgViewId, (Long)orgId, (Integer)RangeEnum.VALUE_50.getValue());
            Long periodId = approveBill.getLong("dim_period.id");
            Long versionId = approveBill.getLong("dim_version.id");
            Long datatypeId = approveBill.getLong("dim_datatype.id");
            entityIds.addAll(orgIds);
            periodIds.add(periodId);
            versionIds.add(versionId);
            datatypeIds.add(datatypeId);
        }
        QFilter reportFilter = new QFilter("model", "=", (Object)modelId);
        reportFilter.and("period", "in", periodIds);
        reportFilter.and("version", "in", versionIds);
        reportFilter.and("datatype", "in", datatypeIds);
        reportFilter.and("entity", "in", entityIds);
        reportFilter.and("template", "in", removeTempIds);
        for (DynamicObject reportProcess : reportProcessList = BusinessDataServiceHelper.load((String)"eb_reportprocess", (String)"id,approvebill.id,status,submituser,submitdate,submitentity,modifier.id", (QFilter[])reportFilter.toArray())) {
            Long billId = reportProcess.getLong("approvebill.id");
            if (!approveBillIds.contains(billId)) continue;
            reportProcess.set("submituser", (Object)0L);
            reportProcess.set("submitdate", null);
            reportProcess.set("submitentity", (Object)0L);
            reportProcess.set("approvebill", (Object)0L);
            Long modifier = reportProcess.getLong("modifier.id");
            if (IDUtils.isNull((Long)modifier)) {
                reportProcess.set("status", (Object)BgTaskStateEnum.UNPREPARED.getNumber());
                continue;
            }
            reportProcess.set("status", (Object)BgTaskStateEnum.TEMPSAVE.getNumber());
        }
        SaveServiceHelper.save((DynamicObject[])reportProcessList);
    }

    public static void unLockDimMemForLocalApprove(Set<Long> approveBillIds) {
        log.info("unLockDimMemForLocalApprove approveBillIds={}", approveBillIds);
        QFilter qFilter = new QFilter("id", "in", approveBillIds);
        DynamicObjectCollection approveBills = QueryServiceHelper.query((String)"eb_approvebill", (String)"id,modelid,bizmodelid,eborgid.number,orgviewid,dim_period,dim_datatype,dim_version", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)approveBills)) {
            return;
        }
        HashMap<Long, LocalApproveDimMemLock> approveDimMemLockMap = new HashMap<Long, LocalApproveDimMemLock>(16);
        for (DynamicObject approveBill : approveBills) {
            Long approveBillId = approveBill.getLong("id");
            LocalApproveDimMemLock dimMemLock = new LocalApproveDimMemLock();
            dimMemLock.setApproveBillId(approveBillId);
            dimMemLock.setModelId(Long.valueOf(approveBill.getLong("modelid")));
            dimMemLock.setBizModelId(Long.valueOf(approveBill.getLong("bizmodelid")));
            dimMemLock.setOrgViewId(Long.valueOf(approveBill.getLong("orgviewid")));
            dimMemLock.setPeriodId(Long.valueOf(approveBill.getLong("dim_period")));
            dimMemLock.setVersionId(Long.valueOf(approveBill.getLong("dim_version")));
            dimMemLock.setDatatypeId(Long.valueOf(approveBill.getLong("dim_datatype")));
            dimMemLock.setEntityNumber(approveBill.getString("eborgid.number"));
            approveDimMemLockMap.put(approveBillId, dimMemLock);
        }
        ApproveBillServiceHelper.unlockDimMem(approveDimMemLockMap);
    }

    private static void unlockDimMem(Map<Long, LocalApproveDimMemLock> approveDimMemLockMap) {
        if (CollectionUtils.isEmpty(approveDimMemLockMap)) {
            return;
        }
        OperationResult operationResult = new OperationResult();
        for (Map.Entry<Long, LocalApproveDimMemLock> entry : approveDimMemLockMap.entrySet()) {
            Long approveBillId = entry.getKey();
            LocalApproveDimMemLock dimMemLock = entry.getValue();
            Long modelId = dimMemLock.getModelId();
            Long versionId = dimMemLock.getVersionId();
            Long datatypeId = dimMemLock.getDatatypeId();
            Long periodId = dimMemLock.getPeriodId();
            Long bizModelId = dimMemLock.getBizModelId();
            Long orgViewId = dimMemLock.getOrgViewId();
            String entityNumber = dimMemLock.getEntityNumber();
            Long auditTrailId = IDUtils.toLong((Object)Cache.get().get("approve_datalock_audittrail:" + approveBillId));
            if (IDUtils.isNull((Long)auditTrailId)) continue;
            log.info("unlockDimMem approveBillId={}", (Object)approveBillId);
            DataLockService.getInstance().unLock(operationResult, modelId, bizModelId, orgViewId, versionId, datatypeId, auditTrailId, entityNumber, periodId);
            Cache.get().remove("approve_datalock_audittrail:" + approveBillId);
        }
    }

    public static void saveLocalApproveBill(Set<Long> approveBillIds) {
        QFilter qFilter = new QFilter("id", "in", approveBillIds);
        DynamicObjectCollection approveBills = QueryServiceHelper.query((String)"eb_approvebill", (String)"id,modelid,bizmodelid,eborgid,orgviewid,dim_period,dim_datatype,dim_version", (QFilter[])qFilter.toArray());
        ArrayList<DynamicObject> localApproveBills = new ArrayList<DynamicObject>(approveBills.size());
        for (DynamicObject approveBill : approveBills) {
            DynamicObject localApproveBill = BusinessDataServiceHelper.newDynamicObject((String)"eb_localapprovebill");
            localApproveBill.set("approvebillid", (Object)approveBill.getLong("id"));
            localApproveBill.set("model", (Object)approveBill.getLong("modelid"));
            localApproveBill.set("bizmodel", (Object)approveBill.getLong("bizmodelid"));
            localApproveBill.set("org", (Object)approveBill.getLong("eborgid"));
            localApproveBill.set("orgviewid", (Object)approveBill.getLong("orgviewid"));
            localApproveBill.set("period", (Object)approveBill.getLong("dim_period"));
            localApproveBill.set("datatype", (Object)approveBill.getLong("dim_datatype"));
            localApproveBill.set("version", (Object)approveBill.getLong("dim_version"));
            localApproveBill.set("audittime", (Object)TimeServiceHelper.now());
            localApproveBills.add(localApproveBill);
        }
        SaveServiceHelper.save((DynamicObject[])localApproveBills.toArray(new DynamicObject[0]));
    }
}

