/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.approvetype;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.engine.dynprocess.freeflow.WFFlowElement;
import kd.bos.workflow.engine.dynprocess.freeflow.WFJointAuditTask;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityImpl;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.epm.eb.business.approveBill.ApproveBillServiceHelper;
import kd.epm.eb.business.approveBill.RejectOnReportService;
import kd.epm.eb.business.approveBill.helper.ApproveBillSubmitHelper;
import kd.epm.eb.business.centralrelation.CentralRelationShotService;
import kd.epm.eb.business.ebupgrades.utils.UpgradesTaskUtil;
import kd.epm.eb.business.utils.WorkFlowUtil;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.approveBill.CentralBillRptSubmitHelper;
import kd.epm.eb.common.approveBill.Entity.ApproveBillInfo;
import kd.epm.eb.common.approveBill.Entity.ApproveBillStatus;
import kd.epm.eb.common.approveBill.Entity.ApproveBillSubMitDim;
import kd.epm.eb.common.approveBill.Entity.CentralBillType;
import kd.epm.eb.common.approveBill.Entity.LocalApproveRecord;
import kd.epm.eb.common.approveBill.Entity.RejectNodeInfo;
import kd.epm.eb.common.approveBill.Entity.RejectOpinionRecord;
import kd.epm.eb.common.approveBill.Entity.RejectStatus;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.ebcommon.common.enums.RangeEnum;
import kd.epm.eb.common.enums.AuditTypeEnum;
import kd.epm.eb.common.enums.BgTaskStateEnum;
import kd.epm.eb.common.enums.LocalRecordTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.examine.request.CheckRange;
import kd.epm.eb.common.examine.request.ReportCheckRange;
import kd.epm.eb.common.examine.request.ReportRelation;
import kd.epm.eb.common.permission.EBPermission;
import kd.epm.eb.common.pojo.BasedataPojo;
import kd.epm.eb.common.reportprocess.entity.domain.ReportProcess;
import kd.epm.eb.common.reportprocess.entity.dto.TemplateEntityDto;
import kd.epm.eb.common.reportprocess.entity.request.BaseRptProcessRequest;
import kd.epm.eb.common.reportprocess.helper.ApproveBillHelper;
import kd.epm.eb.common.reportprocess.helper.MemberHelper;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessAggService;
import kd.epm.eb.common.reportprocess.service.impl.ReportProcessServiceImpl;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.DynamicObjectUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.common.utils.convert.Convert;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class ApproveUtils {
    private static final Log log = LogFactory.getLog(ApproveUtils.class);
    private static final ApproveUtils instance = new ApproveUtils();

    public static ApproveUtils getInstance() {
        return instance;
    }

    public boolean isFromAuditPage(IFormView view) {
        IFormView parentView = view.getParentView();
        if (parentView == null) {
            return false;
        }
        String isNewApprovePage = parentView.getPageCache().get("isNewApprovePage");
        return StringUtils.isNotEmpty((String)isNewApprovePage);
    }

    public boolean isFromHasDealPage(IFormView view) {
        Object wfTaskOnlyView = view.getFormShowParameter().getCustomParam("wfTaskOnlyView");
        if (wfTaskOnlyView == null) {
            return false;
        }
        return "true".equals(wfTaskOnlyView.toString());
    }

    public boolean isFromHasDealPage(IFormView view, String billStatus) {
        BillShowParameter formShowParameter = (BillShowParameter)view.getFormShowParameter();
        if (!EBPermission.wfApps.contains(formShowParameter.getAppId())) {
            return false;
        }
        Object onlyView = formShowParameter.getCustomParam("onlyView");
        if (onlyView != null) {
            return Convert.toBool((Object)onlyView, (Boolean)false);
        }
        Object type = formShowParameter.getCustomParam("type");
        return type != null && "handled".equals(type.toString());
    }

    public boolean isFromWfApp(IFormView view) {
        Object isWfApp = view.getFormShowParameter().getCustomParam("isWfApp");
        return Convert.toBool((Object)isWfApp, (Boolean)false);
    }

    public Map<Long, List<Long>> getReportProcessIdsByBill(Map<Long, ApproveBillSubMitDim> billMitDims) {
        if (billMitDims.size() == 0) {
            return new HashMap<Long, List<Long>>(16);
        }
        Long modelId = billMitDims.values().iterator().next().getModelId();
        HashSet periods = new HashSet(16);
        HashSet dataTypes = new HashSet(16);
        HashSet versions = new HashSet(16);
        HashSet entityIds = new HashSet(16);
        HashSet templateIs = new HashSet(16);
        StringBuilder sb = new StringBuilder(16);
        HashMap dimBillIdMap = new HashMap(16);
        billMitDims.forEach((billId, dimInfo) -> {
            periods.add(dimInfo.getYearPeriodId());
            versions.add(dimInfo.getVersionId());
            entityIds.add(dimInfo.getOrgId());
            dataTypes.add(dimInfo.getDataTypeId());
            dimInfo.getTempIds().forEach(tempId -> {
                templateIs.add(tempId);
                sb.append(dimInfo.getYearPeriodId()).append(',').append(dimInfo.getVersionId()).append(',').append(dimInfo.getOrgId()).append(',').append(dimInfo.getDataTypeId()).append(',').append(tempId);
                dimBillIdMap.put(sb.toString(), billId);
                sb.setLength(0);
            });
        });
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid,fperiod,fdatatype,fversion,fentity,ftemplate from t_eb_reportprocess where ", new Object[0]);
        sqlBuilder.append("fmodel = ? ", new Object[]{modelId});
        sqlBuilder.append(" and ", new Object[0]).appendIn("fperiod", periods.toArray());
        sqlBuilder.append(" and ", new Object[0]).appendIn("fdatatype", dataTypes.toArray());
        sqlBuilder.append(" and ", new Object[0]).appendIn("fversion", versions.toArray());
        sqlBuilder.append(" and ", new Object[0]).appendIn("fentity", entityIds.toArray());
        sqlBuilder.append(" and ", new Object[0]).appendIn("ftemplate", templateIs.toArray());
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>(16);
        try (DataSet ds = DB.queryDataSet((String)"queryReportProcess", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long reportId = row.getLong("fid");
                Long periodId = row.getLong("fperiod");
                Long dataTypeId = row.getLong("fdatatype");
                Long versionId = row.getLong("fversion");
                Long entityId = row.getLong("fentity");
                Long tempId = row.getLong("ftemplate");
                sb.append(periodId).append(',').append(versionId).append(',').append(entityId).append(',').append(dataTypeId).append(',').append(tempId);
                Long billId2 = (Long)dimBillIdMap.get(sb.toString());
                if (billId2 != null) {
                    result.computeIfAbsent(billId2, key -> new ArrayList(16)).add(reportId);
                }
                sb.setLength(0);
            }
        }
        return result;
    }

    public Map<Long, List<Long>> getReportProcessIdsByBillIds(Collection<Long> billIds) {
        DynamicObject[] approveBills = BusinessDataServiceHelper.load((Object[])billIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_approvebill"));
        return this.getReportProcessIdsByBill(Arrays.asList(approveBills));
    }

    public Map<Long, List<Long>> getReportProcessIdsByBill(Collection<DynamicObject> billObjs) {
        Long tempId;
        if (billObjs.size() == 0) {
            return new HashMap<Long, List<Long>>(16);
        }
        HashSet<Long> periods = new HashSet<Long>(16);
        HashSet<Long> dataTypes = new HashSet<Long>(16);
        HashSet<Long> versions = new HashSet<Long>(16);
        HashSet<Long> entityIds = new HashSet<Long>(16);
        HashSet<Long> templateIs = new HashSet<Long>(16);
        StringBuilder sb = new StringBuilder(16);
        HashMap<String, Set> dimBillIdMap = new HashMap<String, Set>(16);
        Long modelId = null;
        for (DynamicObject approveBill : billObjs) {
            modelId = approveBill.getLong("modelid.id");
            Long dim_org = approveBill.getLong("eborgid.id");
            Long dim_period = approveBill.getLong("dim_period.id");
            Long dim_datatype = approveBill.getLong("dim_datatype.id");
            Long dim_version = approveBill.getLong("dim_version.id");
            Long billId = approveBill.getLong("id");
            periods.add(dim_period);
            versions.add(dim_version);
            entityIds.add(dim_org);
            dataTypes.add(dim_datatype);
            for (DynamicObject temp : approveBill.getDynamicObjectCollection("entryentity")) {
                tempId = temp.getLong("tempid.id");
                templateIs.add(tempId);
                sb.append(dim_period).append(',').append(dim_version).append(',').append(dim_org).append(',').append(dim_datatype).append(',').append(tempId);
                String dimStr = sb.toString();
                dimBillIdMap.computeIfAbsent(dimStr, key -> new HashSet(16)).add(billId);
                sb.setLength(0);
            }
        }
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>(16);
        if (periods.size() > 0 && dataTypes.size() > 0 && versions.size() > 0 && entityIds.size() > 0 && templateIs.size() > 0) {
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fid,fperiod,fdatatype,fversion,fentity,ftemplate from t_eb_reportprocess where ", new Object[0]);
            sqlBuilder.append("fmodel = ? ", new Object[]{modelId});
            sqlBuilder.append(" and ", new Object[0]).appendIn("fperiod", periods.toArray());
            sqlBuilder.append(" and ", new Object[0]).appendIn("fdatatype", dataTypes.toArray());
            sqlBuilder.append(" and ", new Object[0]).appendIn("fversion", versions.toArray());
            sqlBuilder.append(" and ", new Object[0]).appendIn("fentity", entityIds.toArray());
            sqlBuilder.append(" and ", new Object[0]).appendIn("ftemplate", templateIs.toArray());
            try (DataSet ds = DB.queryDataSet((String)"queryReportProcess", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
                while (ds.hasNext()) {
                    Row row = ds.next();
                    Long reportId = row.getLong("fid");
                    Long periodId = row.getLong("fperiod");
                    Long dataTypeId = row.getLong("fdatatype");
                    Long versionId = row.getLong("fversion");
                    Long entityId = row.getLong("fentity");
                    tempId = row.getLong("ftemplate");
                    sb.append(periodId).append(',').append(versionId).append(',').append(entityId).append(',').append(dataTypeId).append(',').append(tempId);
                    Set billIdSet = (Set)dimBillIdMap.get(sb.toString());
                    if (billIdSet != null) {
                        for (Long id : billIdSet) {
                            result.computeIfAbsent(id, key -> new ArrayList(16)).add(reportId);
                        }
                    }
                    sb.setLength(0);
                }
            }
        }
        return result;
    }

    public Set<Long> getApproveReportProcessIds(Collection<Long> approveBillIds) {
        if (approveBillIds.size() == 0) {
            return new HashSet<Long>(16);
        }
        HashSet<Long> models = new HashSet<Long>(16);
        HashSet<Long> periods = new HashSet<Long>(16);
        HashSet<Long> dataTypes = new HashSet<Long>(16);
        HashSet<Long> versions = new HashSet<Long>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid, fmodelid, fdimversionnew, fdimperiodnew, fdimdatatype, feborgid from t_eb_approvebill where ", new Object[0]);
        sqlBuilder.appendIn("fid", approveBillIds.toArray());
        try (DataSet ds = DB.queryDataSet((String)"queryApproveBillPageDims", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                Row row = ds.next();
                models.add(row.getLong("fmodelid"));
                periods.add(row.getLong("fdimperiodnew"));
                dataTypes.add(row.getLong("fdimdatatype"));
                versions.add(row.getLong("fdimversionnew"));
            }
        }
        HashSet<Long> allRefProcessIds = new HashSet<Long>(16);
        sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid from t_eb_reportprocess where ", new Object[0]);
        sqlBuilder.appendIn("fmodel", models.toArray());
        sqlBuilder.append(" and ", new Object[0]).appendIn("fperiod", periods.toArray());
        sqlBuilder.append(" and ", new Object[0]).appendIn("fdatatype", dataTypes.toArray());
        sqlBuilder.append(" and ", new Object[0]).appendIn("fversion", versions.toArray());
        sqlBuilder.append(" and ", new Object[0]).appendIn("fapprovebill", approveBillIds.toArray());
        try (DataSet ds = DB.queryDataSet((String)"queryReportProcess", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long reportId = row.getLong("fid");
                allRefProcessIds.add(reportId);
            }
        }
        return allRefProcessIds;
    }

    public Map<Long, ReportProcess> getApproveRefReportProcessInfo(Collection<Long> approveBillIds) {
        if (approveBillIds.size() == 0) {
            return new HashMap<Long, ReportProcess>(16);
        }
        QFilter qFilter = new QFilter("id", "in", approveBillIds);
        String fields = "id, dim_datatype, dim_period, dim_version, eborgid, entryentity.tempid as tempid, modelid, orgviewid";
        DynamicObjectCollection approveBills = QueryServiceHelper.query((String)"eb_approvebill", (String)fields, (QFilter[])new QFilter[]{qFilter});
        if (approveBills.size() == 0) {
            return new HashMap<Long, ReportProcess>(16);
        }
        HashMap<String, BaseRptProcessRequest> requestMap = new HashMap<String, BaseRptProcessRequest>(16);
        for (DynamicObject approveBill : approveBills) {
            long modelId = approveBill.getLong("modelid");
            long orgViewId = approveBill.getLong("orgviewid");
            long dim_period = approveBill.getLong("dim_period");
            long dim_datatype = approveBill.getLong("dim_datatype");
            long dim_version = approveBill.getLong("dim_version");
            String signKey = modelId + "!" + orgViewId + "!" + dim_period + "!" + dim_datatype + "!" + dim_version;
            BaseRptProcessRequest baseRptProcessRequest = requestMap.computeIfAbsent(signKey, k -> new BaseRptProcessRequest(Long.valueOf(modelId), Long.valueOf(orgViewId), Long.valueOf(dim_period), Long.valueOf(dim_datatype), Long.valueOf(dim_version), new ArrayList(16)));
            List templateEntityDtoList = baseRptProcessRequest.getTemplateEntityDtoList();
            templateEntityDtoList.add(new TemplateEntityDto(Long.valueOf(approveBill.getLong("tempid")), Long.valueOf(approveBill.getLong("eborgid"))));
        }
        ArrayList queryRptProcessRequests = new ArrayList(requestMap.values());
        ReportProcessAggService instance = ReportProcessAggService.getInstance();
        List reportProcessList = instance.getReportProcessList(queryRptProcessRequests);
        return reportProcessList.stream().collect(Collectors.toMap(ReportProcess::getId, e -> e));
    }

    public Set<Long> getApproveRefReportProcessInfoWithAllEntity(Collection<Long> approveBillIds) {
        if (approveBillIds.size() == 0) {
            return new HashSet<Long>(16);
        }
        return this.getRefReportProcessInfoWithAllEntity(approveBillIds, null);
    }

    public Set<Long> getProcessRefReportProcessInfoWithAllEntity(Collection<Long> processIds) {
        if (processIds.size() == 0) {
            return new HashSet<Long>(16);
        }
        return this.getRefReportProcessInfoWithAllEntity(null, processIds);
    }

    private Set<Long> getRefReportProcessInfoWithAllEntity(Collection<Long> approveBillIds, Collection<Long> processIds) {
        Map<Long, List<Long>> map = this.getRefReportProcessInfoMapWithAllEntity(approveBillIds, processIds, null);
        HashSet<Long> retProcessIds = new HashSet<Long>(16);
        map.forEach((key, value) -> retProcessIds.addAll((Collection<Long>)value));
        return retProcessIds;
    }

    public Map<Long, List<Long>> getRefReportProcessInfoMapWithAllEntity(Collection<Long> approveBillIds, Collection<Long> processIds, Collection<Long> entitySet) {
        QFilter qFilter;
        String table;
        String fields;
        if (approveBillIds == null && processIds == null) {
            return Collections.emptyMap();
        }
        HashSet<Long> models = new HashSet<Long>(16);
        HashSet<Long> periods = new HashSet<Long>(16);
        HashSet<Long> dataTypes = new HashSet<Long>(16);
        HashSet<Long> versions = new HashSet<Long>(16);
        HashSet<Long> templates = new HashSet<Long>(16);
        LinkedHashSet<String> dimRangeList = new LinkedHashSet<String>();
        if (approveBillIds != null) {
            fields = "dim_datatype as datatype, dim_period as period, dim_version as version, eborgid as entity, entryentity.tempid as template, modelid as model";
            table = "eb_approvebill";
            qFilter = new QFilter("id", "in", approveBillIds);
            qFilter.and("parentbillid", "=", (Object)0L);
        } else {
            fields = "datatype, period, version, entity, template, model";
            table = "eb_reportprocess";
            qFilter = new QFilter("id", "in", processIds);
        }
        DynamicObjectCollection approveBills = QueryServiceHelper.query((String)table, (String)fields, (QFilter[])new QFilter[]{qFilter});
        if (approveBills.isEmpty()) {
            return Collections.emptyMap();
        }
        for (DynamicObject approveBill : approveBills) {
            ArrayList<String> submitInfos = new ArrayList<String>(16);
            submitInfos.add(approveBill.getString("template"));
            templates.add(approveBill.getLong("template"));
            submitInfos.add(approveBill.getString("version"));
            versions.add(approveBill.getLong("version"));
            submitInfos.add(approveBill.getString("datatype"));
            dataTypes.add(approveBill.getLong("datatype"));
            submitInfos.add(approveBill.getString("period"));
            periods.add(approveBill.getLong("period"));
            submitInfos.add(approveBill.getString("entity"));
            models.add(approveBill.getLong("model"));
            dimRangeList.add(String.join((CharSequence)"!", submitInfos));
        }
        LinkedHashMap<Long, List<Long>> map = new LinkedHashMap<Long, List<Long>>();
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid, ftemplate, fsubmitentity, fdatatype, fversion, fperiod, fapprovebill from t_eb_reportprocess where ", new Object[0]);
        sqlBuilder.appendIn("fmodel", models.toArray());
        sqlBuilder.append(" and ", new Object[0]).appendIn("fperiod", periods.toArray());
        sqlBuilder.append(" and ", new Object[0]).appendIn("fdatatype", dataTypes.toArray());
        sqlBuilder.append(" and ", new Object[0]).appendIn("fversion", versions.toArray());
        sqlBuilder.append(" and ", new Object[0]).appendIn("ftemplate", templates.toArray());
        if (CollectionUtils.isNotEmpty(entitySet)) {
            sqlBuilder.append(" and ", new Object[0]).appendIn("fentity", entitySet.toArray());
        }
        try (DataSet ds = DB.queryDataSet((String)"queryReportProcess", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                Row row = ds.next();
                ArrayList<String> submitInfos = new ArrayList<String>(16);
                submitInfos.add(row.getString("ftemplate"));
                submitInfos.add(row.getString("fversion"));
                submitInfos.add(row.getString("fdatatype"));
                submitInfos.add(row.getString("fperiod"));
                submitInfos.add(row.getString("fsubmitentity"));
                String dimRangeKey = String.join((CharSequence)"!", submitInfos);
                if (!dimRangeList.contains(dimRangeKey)) continue;
                List process = map.computeIfAbsent(row.getLong("fapprovebill"), k -> new ArrayList(16));
                process.add(row.getLong("fid"));
            }
        }
        return map;
    }

    public Set<Long> getApproveRefReportProcessIds(Collection<Long> approveBillIds) {
        Map<Long, ReportProcess> reportProcessInfo = this.getApproveRefReportProcessInfo(approveBillIds);
        return new HashSet<Long>(reportProcessInfo.keySet());
    }

    public void deleteRefApproveDesc(Collection<Long> reportProcessIds) {
        if (reportProcessIds.size() == 0) {
            return;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("delete from t_eb_approvedesc where ", new Object[0]);
        sqlBuilder.appendIn("fprocessid", reportProcessIds.toArray());
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
    }

    public void saveApproveDesc(Set<Long> approveBills, Map<String, String> variables) {
        if (MapUtils.isEmpty(variables)) {
            return;
        }
        String descInfo = variables.get("descInfo");
        if (StringUtils.isEmpty((String)descInfo)) {
            return;
        }
        String batchOrgCommit = variables.get("batchOrgCommit");
        boolean isBatchOrgCommit = "true".equals(batchOrgCommit);
        HashMap<String, String> descMap = (HashMap<String, String>)SerializationUtils.fromJsonString((String)descInfo, HashMap.class);
        if (descMap == null) {
            descMap = new HashMap<String, String>(16);
        }
        HashMap tmpOrRptProcessDescMap = new HashMap(16);
        descMap.forEach((key, value) -> tmpOrRptProcessDescMap.put(ConvertUtils.toLong((Object)key), (String)value));
        Set<Long> reportProcessIds = this.getApproveRefReportProcessIds(approveBills);
        Map<Long, Long> templateProcessMap = this.getProcessRefTemplateInfo(reportProcessIds);
        HashSet<Long> processIds = new HashSet<Long>(templateProcessMap.keySet());
        String insertsSql = "insert into t_eb_approvedesc(fid,fprocessid,fdesc) values (?,?,?)";
        String updateSql = "update t_eb_approvedesc set fdesc = ? where fprocessid = ?";
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(16);
        ArrayList<Object[]> updateParams = new ArrayList<Object[]>(16);
        Map<Long, String> approveDescMap = this.getApproveDescMap(processIds);
        long[] pkIds = DB.genGlobalLongIds((int)(processIds.size() - approveDescMap.size()));
        int index = -1;
        for (Long processId : processIds) {
            String desc;
            Long templateId = templateProcessMap.getOrDefault(processId, 0L);
            if (approveDescMap.containsKey(processId)) {
                desc = "";
                desc = isBatchOrgCommit ? tmpOrRptProcessDescMap.getOrDefault(processId, "") : tmpOrRptProcessDescMap.getOrDefault(templateId, "");
                updateParams.add(new Object[]{desc, processId});
                continue;
            }
            desc = "";
            desc = isBatchOrgCommit ? tmpOrRptProcessDescMap.getOrDefault(processId, "") : tmpOrRptProcessDescMap.getOrDefault(templateId, "");
            if (!StringUtils.isNotEmpty((String)desc)) continue;
            insertParams.add(new Object[]{pkIds[++index], processId, desc});
        }
        if (insertParams.size() != 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)insertsSql, insertParams);
        }
        if (updateParams.size() != 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)updateSql, updateParams);
        }
    }

    public Map<Long, String> getApproveDescMap(Collection<Long> processIds) {
        if (processIds == null || processIds.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, String> approveDescMap = new HashMap<Long, String>(128);
        List batchObjects = DynamicObjectUtils.getBatchObjects(processIds);
        for (Collection _objects : batchObjects) {
            if (_objects == null || _objects.isEmpty()) continue;
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select fprocessid, fdesc from t_eb_approvedesc where ", new Object[0]);
            sqlBuilder.appendIn("fprocessid", _objects.toArray());
            DataSet ds = DB.queryDataSet((String)"queryApproveDesc", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sqlBuilder);
            Throwable throwable = null;
            try {
                while (ds.hasNext()) {
                    Row row = ds.next();
                    approveDescMap.put(row.getLong("fprocessid"), row.getString("fdesc"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
            }
        }
        return approveDescMap;
    }

    public void deleteRelBailOrg(Set<Long> canDoBills) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("delete from t_eb_approvebailorg where ", new Object[0]);
        sqlBuilder.appendIn("fid", canDoBills.toArray());
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
        UpgradesTaskUtil.getInstance().clearDataEntityCache("eb_approvebill");
    }

    public boolean notInWorkFlow(long approveBillId, String type) {
        return this.notInWorkFlow(approveBillId, type, new HashMap<String, List<IApprovalRecordGroup>>(16));
    }

    public boolean notInWorkFlow(long approveBillId, String type, Map<String, List<IApprovalRecordGroup>> records) {
        return this.notInWorkFlow(approveBillId, type, true, records);
    }

    public boolean notInWorkFlow(long approveBillId, String type, boolean needReQueryRecord, Map<String, List<IApprovalRecordGroup>> records) {
        AuditTypeEnum auditType = AuditTypeEnum.getAuditType((String)type);
        if (AuditTypeEnum.LOCAL == auditType) {
            return true;
        }
        return this.notInWorkFlow(approveBillId, needReQueryRecord, records);
    }

    public boolean notInWorkFlow(long approveBillId, boolean needReQueryRecord, Map<String, List<IApprovalRecordGroup>> records) {
        if (approveBillId == 0L) {
            return true;
        }
        String businessKey = String.valueOf(approveBillId);
        boolean isInProcess = WorkflowServiceHelper.inProcess((String)businessKey);
        if (isInProcess) {
            return false;
        }
        List allApprovalRecord = null;
        if (needReQueryRecord) {
            allApprovalRecord = records.computeIfAbsent(businessKey, k -> WorkFlowUtil.getAllApprovalRecord((String)businessKey));
        }
        return allApprovalRecord == null || allApprovalRecord.isEmpty();
    }

    public boolean notInWorkFlowWithoutType(long approveBillId) {
        if (approveBillId == 0L) {
            return true;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)approveBillId);
        DynamicObject bill = QueryServiceHelper.queryOne((String)"eb_approvebill", (String)"id, audittype", (QFilter[])new QFilter[]{qFilter});
        if (bill == null) {
            return true;
        }
        return this.notInWorkFlow(approveBillId, bill.getString("audittype"));
    }

    public void updateProcessDynamics(List<DynamicObject> processDynamics, Map<Long, Long> processTemplateMap, Set<Long> approveBillIds) {
        HashSet<Long> processIds = new HashSet<Long>(processTemplateMap.keySet());
        if (processDynamics.size() == 1) {
            DynamicObject dynamicObject = processDynamics.get(0);
            processIds.add(dynamicObject.getLong("id"));
            approveBillIds.add(dynamicObject.getLong("approvebill"));
            processTemplateMap.put(dynamicObject.getLong("id"), dynamicObject.getLong("template.id"));
        }
        HashSet<Long> relateBills = new HashSet<Long>(approveBillIds);
        Map<Long, Long> processRefApproveBills = ApproveUtils.getInstance().getProcessRefMainApproveBillIdsByDim(processIds, true);
        approveBillIds.addAll(processRefApproveBills.values());
        HashMap<Long, String> rejectStatusMap = new HashMap<Long, String>(16);
        Map<Long, String> rejectOpinionMap = this.getApproveRejectOpinionMap(processIds, approveBillIds, rejectStatusMap);
        approveBillIds.remove(0L);
        relateBills.remove(0L);
        Map<Long, String> approveDescMap = this.getApproveDescMap(processIds);
        HashMap<Long, String> auditTypeMap = new HashMap<Long, String>(16);
        Map<Long, String> approveBillNoMap = this.queryRelBillInfo(approveBillIds, auditTypeMap);
        List<String> pkIds = approveBillIds.stream().map(String::valueOf).collect(Collectors.toList());
        Map<String, String> nextAuditorMap = this.getNextAuditor(pkIds);
        ArrayList<Long> _processIds = new ArrayList<Long>(approveBillIds.size());
        List<Long> inRejectApproveBills = this.getInRejectApproveBills(approveBillIds, _processIds);
        Map subApproveBillLists = ApproveBillHelper.getSubApproveBillLists(relateBills, (boolean)false);
        HashMap<String, List<IApprovalRecordGroup>> records = new HashMap<String, List<IApprovalRecordGroup>>(pkIds.size());
        Map<Long, String> srcBillNoMap = RejectOnReportService.getInstance().getSrcBillNo(approveBillIds);
        for (DynamicObject processDynamic : processDynamics) {
            Long template;
            List<ApproveBillInfo> bills;
            List approveBills;
            String opinion;
            String rejectStatus;
            long processId = processDynamic.getLong("id");
            String desc = approveDescMap.get(processId);
            if (!StringUtils.isEmpty((String)desc)) {
                processDynamic.set("approvedesc", (Object)desc);
            }
            long approveBillId = processDynamic.getLong("approvebill");
            String billNo = approveBillNoMap.get(approveBillId);
            String status = processDynamic.getString("status");
            if (StringUtils.isNotEmpty((String)billNo)) {
                if (this.notInWorkFlow(approveBillId, (String)auditTypeMap.get(approveBillId), records)) {
                    billNo = ResManager.loadKDString((String)"\u672c\u5730\u5ba1\u6838", (String)"ApproveUtils_0", (String)"epm-eb-business", (Object[])new Object[0]);
                } else {
                    String srcBillNo = srcBillNoMap.get(approveBillId);
                    if (StringUtils.isNotEmpty((String)srcBillNo)) {
                        billNo = billNo + ";" + srcBillNo;
                    }
                    billNo = ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u5ba1\u6838-\u5ba1\u6838\u5355\u636e\uff1a%s", (String)"ApproveUtils_1", (String)"epm-eb-business", (Object[])new Object[]{billNo});
                }
            }
            processDynamic.set("audittype", (Object)billNo);
            String auditor = nextAuditorMap.get(String.valueOf(approveBillId));
            if (StringUtils.isNotEmpty((String)auditor)) {
                processDynamic.set("auditor", (Object)auditor);
            }
            if (approveBillId == 0L) {
                Long _approveBillId = processRefApproveBills.get(processId);
                approveBillId = _approveBillId == null ? 0L : _approveBillId;
            }
            processDynamic.set("rejecthasmodify", (Object)"");
            boolean isInReject = inRejectApproveBills.contains(approveBillId);
            if (isInReject) {
                processDynamic.set("rejecthasmodify", (Object)"");
            }
            if (StringUtils.isNotEmpty((String)(rejectStatus = (String)rejectStatusMap.get(processId)))) {
                processDynamic.set("rejecthasmodify", (Object)("1".equals(rejectStatus) ? "\u2714" : ""));
            }
            if (approveBillId == 0L) {
                processDynamic.set("rejecthasmodify", (Object)"");
            }
            if ((isInReject || _processIds.contains(processId) || BgTaskStateEnum.INCOMPLETE.getNumber().equals(status)) && StringUtils.isNotEmpty((String)(opinion = rejectOpinionMap.get(processId)))) {
                processDynamic.set("rejectopinion", (Object)opinion);
            }
            long entity = processDynamic.getLong("entity");
            long submitEntity = processDynamic.getLong("submitentity");
            if (approveBillId == 0L || entity != submitEntity || (approveBills = (List)subApproveBillLists.get(approveBillId)) == null || approveBills.isEmpty() || (bills = this.getFilterBills(approveBills, template = processTemplateMap.getOrDefault(processId, 0L))).isEmpty()) continue;
            processDynamic.set("splitbills", (Object)String.valueOf(bills.size()));
        }
    }

    public List<ApproveBillInfo> getFilterBills(List<ApproveBillInfo> approveBills, Long template) {
        ArrayList<ApproveBillInfo> bills = new ArrayList<ApproveBillInfo>(16);
        for (ApproveBillInfo approveBill : approveBills) {
            Set templates = approveBill.getTemplates();
            if (template == null || !templates.contains(template)) continue;
            bills.add(approveBill);
        }
        return bills;
    }

    public Map<Long, String> queryRelBillInfo(Collection<Long> approveBillIds, Map<Long, String> auditTypeMap) {
        HashMap<Long, String> billNoMap = new HashMap<Long, String>(16);
        QFilter qFilter = new QFilter("id", "in", approveBillIds);
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"eb_approvebill", (String)"id, billno, audittype", (QFilter[])new QFilter[]{qFilter});
        bills.forEach(e -> {
            long pkId = e.getLong("id");
            billNoMap.put(pkId, e.getString("billno"));
            auditTypeMap.put(pkId, e.getString("audittype"));
        });
        return billNoMap;
    }

    public boolean isExtClassExist() {
        boolean exitClass = false;
        try {
            Class.forName("kd.bos.ext.fi.eb.ApprovalPagePlugin");
            exitClass = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return exitClass;
    }

    public void saveRejectOpinion(List<Object[]> params) {
        String sql = "insert into t_eb_approverejectopinion(fid,fprocessid,fmustreject,fopinion,fauditnode,frejectnode,frejectstatus,frejectuser,frejecttime,fdiscard,fiscurinstance,fapprovebillid) values (?,?,?,?,?,?,?,?,?,?,?,?)";
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, params);
    }

    public void saveTmpRejectOpinion(List<Object[]> params) {
        String sql = "insert into t_eb_approverejectopinion_tmp(fid,fprocessid,fmustreject,fopinion,fauditnode,frejectnode,frejectuser,frejecttime,fapprovebillid) values (?,?,?,?,?,?,?,?,?)";
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, params);
    }

    public void deleteRejectOpinions(Collection<Long> bills) {
        if (bills == null || bills.size() == 0) {
            return;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("delete from t_eb_approverejectopinion where ", new Object[0]);
        sqlBuilder.appendIn("fapprovebillid", bills.toArray());
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
        sqlBuilder = new SqlBuilder();
        sqlBuilder.append("delete from t_eb_approverejectopinion_tmp where ", new Object[0]);
        sqlBuilder.appendIn("fapprovebillid", bills.toArray());
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
    }

    public Map<String, String> getNextAuditor(List<String> pkIds) {
        HashMap<String, String> nodeMap = new HashMap<String, String>(16);
        String[] ids = new String[pkIds.size()];
        pkIds.toArray(ids);
        Map allPro = WorkflowServiceHelper.getBizProcessStatus((String[])ids);
        for (Map.Entry entry : allPro.entrySet()) {
            String pkid = (String)entry.getKey();
            List node = (List)entry.getValue();
            HashMap auditorMap = new HashMap(16);
            node.forEach(e -> {
                if (e.getProcessStatus().equals("1")) {
                    List auditors;
                    String nodeStr = e.getCurrentNodeName();
                    String auditor = e.getParticipantName();
                    if (auditor != null && !"".equals(auditor.trim()) && !(auditors = auditorMap.computeIfAbsent(nodeStr, k -> new ArrayList(16))).contains(auditor)) {
                        auditors.add(auditor);
                    }
                }
            });
            if (auditorMap.size() == 0) continue;
            nodeMap.put(pkid, auditorMap.entrySet().stream().map(e -> (String)e.getKey() + "/" + String.join((CharSequence)",", (Iterable)e.getValue())).collect(Collectors.joining(";")));
        }
        return nodeMap;
    }

    private Map<Long, String> getApproveRejectOpinionMap(Set<Long> processIds, Set<Long> approveBillIds, Map<Long, String> rejectStatusMap) {
        if (processIds.isEmpty()) {
            return Collections.emptyMap();
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fprocessid, frejectstatus, fopinion, frejecttime, fdiscard from t_eb_approverejectopinion where fiscurinstance = '1' and ", new Object[0]);
        sqlBuilder.appendIn("fprocessid", processIds.toArray());
        sqlBuilder.append(" and ", new Object[0]).appendIn("fapprovebillid", approveBillIds.toArray());
        HashMap<Long, Timestamp> modifyTimeMap = new HashMap<Long, Timestamp>(16);
        HashMap<Long, String> rejectOpinionMap = new HashMap<Long, String>(16);
        try (DataSet ds = DB.queryDataSet((String)"queryRejectOpinion", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long processId = row.getLong("fprocessid");
                Timestamp rejectTime = row.getTimestamp("frejecttime");
                Timestamp timestamp = (Timestamp)modifyTimeMap.get(processId);
                if (timestamp != null && (rejectTime == null || !timestamp.before(rejectTime))) continue;
                modifyTimeMap.put(processId, rejectTime);
                rejectStatusMap.put(processId, row.getString("frejectstatus"));
                String discard = row.getString("fdiscard");
                if (!"0".equals(discard)) continue;
                rejectOpinionMap.put(processId, row.getString("fopinion"));
            }
        }
        return rejectOpinionMap;
    }

    public Map<Long, List<RejectOpinionRecord>> getApproveRejectOpinions(Set<Long> processIds, Set<Long> approveBillIds, boolean inWorkFlow) {
        return this.getApproveRejectOpinions(processIds, approveBillIds, inWorkFlow, false);
    }

    public Map<Long, List<RejectOpinionRecord>> getApproveRejectOpinions(Set<Long> processIds, Set<Long> approveBillIds, boolean inWorkFlow, boolean isTmp) {
        if (processIds.size() == 0) {
            return new HashMap<Long, List<RejectOpinionRecord>>(16);
        }
        HashMap<Long, List> userTimeMap = new HashMap<Long, List>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fprocessid, frejectuser, frejecttime from t_eb_approverejectstatus where ", new Object[0]);
        sqlBuilder.appendIn("fprocessid", processIds.toArray());
        sqlBuilder.append(" and ", new Object[0]).appendIn("fapprovebillid", approveBillIds.toArray());
        try (DataSet ds = DB.queryDataSet((String)"queryRejectStatus", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long processId = row.getLong("fprocessid");
                List userTimes = userTimeMap.computeIfAbsent(processId, k -> new ArrayList(16));
                userTimes.add(new Pair((Object)row.getTimestamp("frejecttime"), (Object)row.getLong("frejectuser")));
            }
        }
        HashMap<Long, List<RejectOpinionRecord>> rejectOpinions = new HashMap<Long, List<RejectOpinionRecord>>(16);
        sqlBuilder = new SqlBuilder();
        String table = "t_eb_approverejectopinion";
        if (isTmp) {
            table = table + "_tmp";
        }
        sqlBuilder.append("select fprocessid, fopinion, fauditnode, frejectuser, frejecttime from " + table + " where ", new Object[0]);
        if (inWorkFlow) {
            if (isTmp) {
                sqlBuilder.append("fisused = '0' and ", new Object[0]);
            } else {
                sqlBuilder.append("fiscurinstance = '1' and ", new Object[0]);
            }
        }
        sqlBuilder.appendIn("fprocessid", processIds.toArray());
        sqlBuilder.append(" and ", new Object[0]).appendIn("fapprovebillid", approveBillIds.toArray());
        try (DataSet ds = DB.queryDataSet((String)"queryRejectOpinion", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long processId = row.getLong("fprocessid");
                List rejectOpinionRecords = rejectOpinions.computeIfAbsent(processId, k -> new ArrayList(16));
                RejectOpinionRecord record = new RejectOpinionRecord();
                Timestamp rejectTime = row.getTimestamp("frejecttime");
                Long rejectUser = row.getLong("frejectuser");
                if (rejectTime != null) {
                    record.setTime(new Date(rejectTime.getTime()));
                    List userTimes = userTimeMap.getOrDefault(processId, new ArrayList(16));
                    List collect = userTimes.stream().filter(e -> e.p1 != null && ((Timestamp)e.p1).compareTo(rejectTime) == 0 && e.p2 != null && ((Long)e.p2).equals(rejectUser)).collect(Collectors.toList());
                    if (collect.size() != 0) {
                        record.setRejectOnReport(true);
                    }
                }
                record.setOpinion(row.getString("fopinion"));
                record.setNodeId(row.getString("fauditnode"));
                record.setUserId(rejectUser);
                rejectOpinionRecords.add(record);
            }
        }
        return rejectOpinions;
    }

    public Set<String> getNotAllDealProcesses(Collection<Long> processIds, Collection<Long> approveBillIds) {
        Set<Long> notDealProcessIds = this.getRejectOnReportProcessIds(processIds, approveBillIds);
        notDealProcessIds.addAll(this.getRejectOnApproveProcessIds(processIds, approveBillIds));
        return this.getTempNameNumberByProcessIds(notDealProcessIds);
    }

    public Set<String> getTempNameNumberByProcessIds(Set<Long> notDealProcessIds) {
        return this.getTempNameNumberByProcessIds(notDealProcessIds, false);
    }

    public Set<String> getTempNameNumberByProcessIds(Set<Long> notDealProcessIds, boolean onlyName) {
        HashSet<String> notDealProcesses = new HashSet<String>(16);
        Map<Long, BasedataPojo> templateInfos = this.getTemplateInfoByProcessIds(notDealProcessIds);
        if (templateInfos.size() == 0) {
            return notDealProcesses;
        }
        for (BasedataPojo dataPojo : templateInfos.values()) {
            String retString = dataPojo.getName();
            if (!onlyName) {
                retString = dataPojo.getNumber() + "  " + retString;
            }
            notDealProcesses.add(retString);
        }
        return notDealProcesses;
    }

    public Map<Long, BasedataPojo> getTemplateInfoByProcessIds(Collection<Long> processIds) {
        HashMap<Long, BasedataPojo> templateInfo = new HashMap<Long, BasedataPojo>(16);
        if (processIds.size() == 0) {
            return templateInfo;
        }
        QFilter qFilter = new QFilter("id", "in", processIds);
        DynamicObjectCollection processes = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id, template.id as tempId, template.name as tmpname, template.number as tmpnumber", (QFilter[])new QFilter[]{qFilter});
        processes.forEach(e -> templateInfo.put(e.getLong("id"), new BasedataPojo(Long.valueOf(e.getLong("tempId")), e.getString("tmpname"), e.getString("tmpnumber"))));
        return templateInfo;
    }

    public Map<Long, Long> getProcessRefTemplateInfo(Collection<Long> processIds) {
        HashMap<Long, Long> refTemplateInfo = new HashMap<Long, Long>(16);
        Map<Long, BasedataPojo> templateInfos = this.getTemplateInfoByProcessIds(processIds);
        if (templateInfos.size() == 0) {
            return refTemplateInfo;
        }
        templateInfos.forEach((key, value) -> refTemplateInfo.put((Long)key, value.getId()));
        return refTemplateInfo;
    }

    public Map<Long, String> getProcessRefTemplateName(Collection<Long> processIds) {
        HashMap<Long, String> refTemplateInfo = new HashMap<Long, String>(16);
        Map<Long, BasedataPojo> templateInfos = this.getTemplateInfoByProcessIds(processIds);
        if (templateInfos.size() == 0) {
            return refTemplateInfo;
        }
        templateInfos.forEach((key, value) -> refTemplateInfo.put((Long)key, value.getName()));
        return refTemplateInfo;
    }

    public Set<Long> getRejectOnReportProcessIds(Collection<Long> processIds, Collection<Long> approveBillIds) {
        if (processIds.size() == 0 || approveBillIds.size() == 0) {
            return new HashSet<Long>(16);
        }
        HashSet<Long> notDealProcessIds = new HashSet<Long>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fprocessid from t_eb_approverejectstatus where fisreject in ('1','2') and fprocessid != 0 and ", new Object[0]);
        sqlBuilder.appendIn("fprocessid", processIds.toArray());
        sqlBuilder.append(" and ", new Object[0]).appendIn("fapprovebillid", approveBillIds.toArray());
        try (DataSet ds = DB.queryDataSet((String)"checkIsNotAllDeal_status", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                Row row = ds.next();
                notDealProcessIds.add(row.getLong("fprocessid"));
            }
        }
        return notDealProcessIds;
    }

    public Set<Long> getRejectOnApproveProcessIds(Collection<Long> processIds, Collection<Long> approveBillIds) {
        if (processIds.size() == 0) {
            return new HashSet<Long>(16);
        }
        HashSet<Long> notDealProcessIds = new HashSet<Long>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fprocessid from t_eb_approverejectopinion where fdiscard = '0' and fmustreject = '1' and frejectstatus = '0' and fiscurinstance = '1' and ", new Object[0]);
        sqlBuilder.appendIn("fprocessid", processIds.toArray());
        if (approveBillIds.size() != 0) {
            sqlBuilder.append(" and ", new Object[0]).appendIn("fapprovebillid", approveBillIds.toArray());
        }
        try (DataSet ds = DB.queryDataSet((String)"checkIsNotAllDeal_opinion", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                Row row = ds.next();
                notDealProcessIds.add(row.getLong("fprocessid"));
            }
        }
        return notDealProcessIds;
    }

    public List<Long> getInRejectApproveBills(Collection<Long> approveBillIds, Collection<Long> processIds) {
        if (approveBillIds.isEmpty()) {
            return Collections.emptyList();
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fapprovebillid, fprocessid from t_eb_approverejectstatus where fisreject in ('1','2') and ", new Object[0]);
        sqlBuilder.appendIn("fapprovebillid", approveBillIds.toArray());
        ArrayList<Long> rejectApproveBills = new ArrayList<Long>(approveBillIds.size());
        try (DataSet ds = DB.queryDataSet((String)"queryRejectedApproveBill", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long processId = row.getLong("fprocessid");
                if (processId != 0L) {
                    processIds.add(processId);
                    continue;
                }
                rejectApproveBills.add(row.getLong("fapprovebillid"));
            }
        }
        return rejectApproveBills;
    }

    public Map<Long, String> getProcessRejectStatusByApprove(Collection<Long> approveBillIds) {
        Timestamp timestamp;
        Timestamp rejectTime;
        Long processId;
        Row row;
        HashMap<Long, String> rejectProcessInfos = new HashMap<Long, String>(16);
        if (approveBillIds == null || approveBillIds.size() == 0) {
            return rejectProcessInfos;
        }
        Set<Long> reportProcessIds = this.getApproveRefReportProcessIds(approveBillIds);
        if (reportProcessIds.size() == 0) {
            return rejectProcessInfos;
        }
        Long approveBillId = approveBillIds.iterator().next();
        String businessKey = String.valueOf(approveBillId);
        Long taskId = WorkflowServiceHelper.getTaskIdByBusinessKeyAndUserId((String)businessKey, (Long)UserUtils.getUserId());
        String curNodeId = WorkFlowUtil.getCurNodeId((Long)taskId);
        if (StringUtils.isEmpty((String)curNodeId)) {
            return rejectProcessInfos;
        }
        HashMap<Long, Timestamp> processRejectTimeMap = new HashMap<Long, Timestamp>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fprocessid, frejecttime from t_eb_approverejectopinion where fiscurinstance = '1' and fauditnode = ? and ", new Object[]{curNodeId});
        sqlBuilder.appendIn("fprocessid", reportProcessIds.toArray());
        sqlBuilder.append(" and fapprovebillid = ?", new Object[]{approveBillId});
        try (DataSet ds = DB.queryDataSet((String)"queryCurNodeOpinion", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                row = ds.next();
                processId = row.getLong("fprocessid");
                rejectTime = row.getTimestamp("frejecttime");
                timestamp = (Timestamp)processRejectTimeMap.get(processId);
                if (timestamp != null && !timestamp.before(rejectTime)) continue;
                processRejectTimeMap.put(processId, rejectTime);
            }
        }
        sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fisreject, fprocessid, frejecttime from t_eb_approverejectstatus where ", new Object[0]);
        sqlBuilder.appendIn("fprocessid", reportProcessIds.toArray());
        sqlBuilder.append(" and fapprovebillid = ?", new Object[]{approveBillId});
        ds = DB.queryDataSet((String)"queryRejectedApproveBill", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
        var11_11 = null;
        try {
            while (ds.hasNext()) {
                row = ds.next();
                processId = row.getLong("fprocessid");
                if (processId == 0L) continue;
                rejectTime = row.getTimestamp("frejecttime");
                timestamp = (Timestamp)processRejectTimeMap.get(processId);
                if (timestamp == null || !timestamp.equals(rejectTime)) continue;
                rejectProcessInfos.put(processId, row.getString("fisreject"));
            }
        }
        catch (Throwable throwable) {
            var11_11 = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (var11_11 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        var11_11.addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        return rejectProcessInfos;
    }

    public void saveApproveBillRejectStatus(List<Object[]> params) {
        String sql = "insert into t_eb_approverejectstatus(fid,fapprovebillid,fisreject,fprocessid,frejectuser,frejecttime) values(?,?,?,?,?,?)";
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, params);
    }

    public String getCurNodeIdByApproveBill(Long approveBillId) {
        Long taskId = WorkflowServiceHelper.getTaskIdByBusinessKeyAndUserId((String)String.valueOf(approveBillId), (Long)UserUtils.getUserId());
        return WorkFlowUtil.getCurNodeId((Long)taskId);
    }

    public String getCurNodeId(Long taskId) {
        if (taskId == null || taskId == 0L) {
            return "";
        }
        TaskInfo taskInfo = WorkflowServiceHelper.findTaskById((Long)taskId);
        String curNodeId = "";
        if (taskInfo instanceof TaskEntityImpl) {
            TaskEntityImpl taskEntity = (TaskEntityImpl)taskInfo;
            DynamicObject dynamicObject = taskEntity.getDynamicObject();
            curNodeId = dynamicObject.getString("taskdefinitionkey");
        }
        return curNodeId;
    }

    public boolean isNeedToDealReject(Long processId, Long approveBillId) {
        RejectStatus processRejectStatus = this.getProcessRejectStatus(processId, approveBillId);
        return processRejectStatus.getCanEdit();
    }

    public RejectStatus getProcessRejectStatus(Long reportProcessId) {
        DynamicObject approvebill;
        long approveBillId = 0L;
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"eb_reportprocess", (String)"approvebill", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)reportProcessId)});
        if (dy != null && (approvebill = dy.getDynamicObject("approvebill")) != null) {
            approveBillId = approvebill.getLong("id");
        }
        return this.getProcessRejectStatus(reportProcessId, approveBillId);
    }

    public RejectStatus getProcessRejectStatus(Long processId, ApproveBillInfo approveBillInfo) {
        if (approveBillInfo == null) {
            return null;
        }
        RejectStatus processRejectStatus = this.getProcessRejectStatus(processId, approveBillInfo.getBillId());
        if (CentralBillType.Child == approveBillInfo.getCentralBillType() && BgTaskStateEnum.INCOMPLETE.getNumber().equals(approveBillInfo.getStatus4Rpt()) && !CentralBillRptSubmitHelper.getNotSubmitRptProcessIds((Long)approveBillInfo.getBillId()).contains(processId)) {
            processRejectStatus.setAuditor(false);
            processRejectStatus.setSubmitNode(false);
            processRejectStatus.setRejectOnReport(false);
        }
        return processRejectStatus;
    }

    public RejectStatus getProcessRejectStatus(Long processId, Long approveBillId) {
        Map<Long, Set<Long>> approveMap;
        RejectStatus rejectStatus = new RejectStatus();
        ArrayList<Long> processIds = new ArrayList<Long>(16);
        if (approveBillId == 0L && (approveMap = ApproveBillServiceHelper.getReportBillMap(Sets.newHashSet((Object[])new Long[]{processId}), CentralBillType.Normal)).containsKey(processId) && !approveMap.get(processId).isEmpty()) {
            approveBillId = approveMap.get(processId).iterator().next();
        }
        Long userId = UserUtils.getUserId();
        String businessKey = String.valueOf(approveBillId);
        List auditors = WorkflowServiceHelper.getApproverByBusinessKey((String)businessKey);
        if (auditors.contains(userId)) {
            rejectStatus.setAuditor(true);
        }
        Long taskId = WorkflowServiceHelper.getTaskIdByBusinessKeyAndUserId((String)businessKey, (Long)userId);
        String curNodeId = WorkFlowUtil.getCurNodeId((Long)taskId);
        List allApprovalRecord = WorkFlowUtil.getAllApprovalRecord((String)businessKey);
        String submitNodeId = this.getSubmitNodeId(allApprovalRecord);
        if (StringUtils.isNotEmpty((String)submitNodeId) && submitNodeId.equals(curNodeId)) {
            rejectStatus.setSubmitNode(true);
        }
        List<Long> inRejectApproveBills = this.getInRejectApproveBills(Collections.singleton(approveBillId), processIds);
        if (processIds.size() != 0) {
            rejectStatus.setProcessIds(new ArrayList<Long>(processIds));
        }
        if (!processIds.contains(processId)) {
            return rejectStatus;
        }
        rejectStatus.setRejectOnReport(true);
        if (inRejectApproveBills.size() != 0) {
            if (!rejectStatus.isRejectOnReport()) {
                rejectStatus.setRejectOnApprove(true);
            }
            rejectStatus.setApproveBills(inRejectApproveBills);
            processIds.addAll(this.getApproveRefReportProcessIds(inRejectApproveBills));
        }
        if (!processIds.contains(processId)) {
            return rejectStatus;
        }
        String rejectNode = "";
        Timestamp timestamp = null;
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fprocessid, frejectnode, frejecttime from t_eb_approverejectopinion where fdiscard = '0' and fiscurinstance = '1' and ", new Object[0]);
        sqlBuilder.appendIn("fprocessid", processIds.toArray());
        sqlBuilder.append(" and fapprovebillid = ?", new Object[]{approveBillId});
        try (DataSet ds = DB.queryDataSet((String)"queryRejectNode", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                Timestamp rejectTime;
                String[] split;
                String _rejectNode;
                Row row = ds.next();
                Long prtId = row.getLong("fprocessid");
                if (!processId.equals(prtId) || StringUtils.isEmpty((String)(_rejectNode = row.getString("frejectnode"))) || (split = _rejectNode.split("#")).length != 2) continue;
                String rejectToUsers = split[1];
                List<String> rejectUserIds = Arrays.asList(rejectToUsers.split("_"));
                if (rejectUserIds.contains(userId.toString())) {
                    rejectStatus.setAuditor(true);
                }
                if ((rejectTime = row.getTimestamp("frejecttime")) == null || timestamp != null && !timestamp.before(rejectTime)) continue;
                timestamp = rejectTime;
                rejectNode = _rejectNode;
            }
        }
        String[] split = rejectNode.split("#");
        if (split.length == 2) {
            if (split[0].equals(submitNodeId)) {
                rejectStatus.setSubmitNode(true);
            } else {
                List<String> userSplit = Arrays.asList(split[1].split("_"));
                if (userSplit.contains(String.valueOf(userId))) {
                    rejectStatus.setReportCurDeal(true);
                }
            }
        }
        return rejectStatus;
    }

    public String getSubmitNodeId(List<IApprovalRecordGroup> allApprovalRecord) {
        if (allApprovalRecord == null || allApprovalRecord.size() == 0) {
            return "";
        }
        String submitNodeId = "";
        for (IApprovalRecordGroup approvalRecordGroup : allApprovalRecord) {
            List children;
            String groupDecisionType = approvalRecordGroup.getGroupDecisionType();
            if (!"submit".equals(groupDecisionType) || (children = approvalRecordGroup.getChildren()) == null || children.size() == 0) continue;
            submitNodeId = ((IApprovalRecordItem)children.get(0)).getActivityId();
        }
        return submitNodeId;
    }

    public void updateRejectOpinionStatus(long processId, long approveBillId) {
        if (processId == 0L) {
            return;
        }
        if (approveBillId == 0L) {
            Map<Long, Long> map = this.getProcessRefMainApproveBillIdsByDim(Collections.singleton(processId), true);
            approveBillId = map.getOrDefault(processId, 0L);
        }
        if (approveBillId != 0L && !this.isNeedToDealReject(processId, approveBillId)) {
            return;
        }
        ArrayList<Long> opinionIds = new ArrayList<Long>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid from t_eb_approverejectopinion where fdiscard = '0' and fiscurinstance = '1' and fprocessid = ? and fapprovebillid = ?", new Object[]{processId, approveBillId});
        try (DataSet ds = DB.queryDataSet((String)"queryOpinion", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                Row row = ds.next();
                opinionIds.add(row.getLong("fid"));
            }
        }
        if (opinionIds.size() != 0) {
            sqlBuilder = new SqlBuilder();
            sqlBuilder.append("update t_eb_approverejectopinion set frejectstatus = '1' where fiscurinstance = '1' and ", new Object[0]);
            sqlBuilder.appendIn("fid", opinionIds.toArray());
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
        }
    }

    public Long getProcessRefMainApproveBillId(Long processId) {
        if (IDUtils.isNull((Long)processId)) {
            return 0L;
        }
        Map<Long, Long> processRefApproveBillIds = this.getProcessRefMainApproveBillIds(Lists.newArrayList((Object[])new Long[]{processId}));
        Long approveBillId = processRefApproveBillIds.get(processId);
        return ConvertUtils.toLong((Object)approveBillId);
    }

    public Map<Long, Long> getProcessRefMainApproveBillIds(Collection<Long> processIds) {
        if (processIds == null || processIds.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, Long> processRefApproveBillIds = new HashMap<Long, Long>(16);
        String fields = "id, approvebill";
        DynamicObjectCollection processes = QueryServiceHelper.query((String)"eb_reportprocess", (String)fields, (QFilter[])new QFilter[]{new QFilter("id", "in", processIds)});
        for (DynamicObject process : processes) {
            processRefApproveBillIds.put(process.getLong("id"), process.getLong("approvebill"));
        }
        return processRefApproveBillIds;
    }

    public Map<Long, Long> getProcessRefMainApproveBillIdsByDim(Collection<Long> processIds, boolean sortLastBill) {
        HashMap<Long, Long> processRefApproveBillIds = new HashMap<Long, Long>(16);
        String fields = "id, template, version, datatype, period, entity";
        HashSet<Long> templates = new HashSet<Long>(16);
        HashSet<Long> versions = new HashSet<Long>(16);
        HashSet<Long> dataTypes = new HashSet<Long>(16);
        HashSet<Long> periods = new HashSet<Long>(16);
        HashSet<Long> entities = new HashSet<Long>(16);
        HashMap<String, Long> dimRangeMap = new HashMap<String, Long>(16);
        DynamicObjectCollection processes = QueryServiceHelper.query((String)"eb_reportprocess", (String)fields, (QFilter[])new QFilter[]{new QFilter("id", "in", processIds)});
        for (DynamicObject process : processes) {
            ArrayList<String> submitInfos = new ArrayList<String>(16);
            templates.add(process.getLong("template"));
            submitInfos.add(process.getString("template"));
            versions.add(process.getLong("version"));
            submitInfos.add(process.getString("version"));
            dataTypes.add(process.getLong("datatype"));
            submitInfos.add(process.getString("datatype"));
            periods.add(process.getLong("period"));
            submitInfos.add(process.getString("period"));
            entities.add(process.getLong("entity"));
            submitInfos.add(process.getString("entity"));
            dimRangeMap.put(String.join((CharSequence)"!", submitInfos), process.getLong("id"));
        }
        QFilter qFilter = new QFilter("dim_datatype", "in", dataTypes);
        qFilter.and("dim_period", "in", periods);
        qFilter.and("dim_version", "in", versions);
        qFilter.and("eborgid", "in", entities);
        qFilter.and("entryentity.tempid", "in", templates);
        qFilter.and("centralbilltype", "!=", (Object)CentralBillType.Child.getNumber());
        fields = "id, dim_datatype, dim_period, dim_version, eborgid, entryentity.tempid as tempid";
        String orderBy = sortLastBill ? "createdate" : null;
        DynamicObjectCollection approveBills = QueryServiceHelper.query((String)"eb_approvebill", (String)fields, (QFilter[])new QFilter[]{qFilter}, (String)orderBy);
        for (DynamicObject approveBill : approveBills) {
            ArrayList<String> submitInfos = new ArrayList<String>(16);
            submitInfos.add(approveBill.getString("tempid"));
            submitInfos.add(approveBill.getString("dim_version"));
            submitInfos.add(approveBill.getString("dim_datatype"));
            submitInfos.add(approveBill.getString("dim_period"));
            submitInfos.add(approveBill.getString("eborgid"));
            String dimRangeKey = String.join((CharSequence)"!", submitInfos);
            Long processId = (Long)dimRangeMap.get(dimRangeKey);
            if (processId == null) continue;
            processRefApproveBillIds.put(processId, approveBill.getLong("id"));
        }
        return processRefApproveBillIds;
    }

    public void updateRejectBillStatus(Collection<Long> businessKeyIds, Collection<Long> processIds) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        if (businessKeyIds.size() != 0) {
            sqlBuilder.append("update t_eb_approverejectstatus set fisreject = '0' where ", new Object[0]);
            sqlBuilder.appendIn("fapprovebillid", businessKeyIds.toArray());
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
        }
        if (processIds.size() != 0) {
            sqlBuilder = new SqlBuilder();
            sqlBuilder.append("update t_eb_approverejectopinion set fdiscard = '1' where fiscurinstance = '1' and ", new Object[0]);
            sqlBuilder.appendIn("fprocessid", processIds.toArray());
            sqlBuilder.append(" and ", new Object[0]).appendIn("fapprovebillid", businessKeyIds.toArray());
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
        }
    }

    public void updateRejectStatusByProcessId(Long processId, Long approveBillId) {
        this.updateRejectStatusByProcessIds(Collections.singleton(processId), Collections.singletonList(approveBillId));
    }

    public void updateRejectStatusByProcessIds(Collection<Long> processIds, Collection<Long> approveBillIds) {
        if (processIds.size() == 0 || approveBillIds.size() == 0) {
            return;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("update t_eb_approverejectstatus set fisreject = '0' where ", new Object[0]);
        sqlBuilder.appendIn("fprocessid", processIds.toArray());
        sqlBuilder.append(" and ", new Object[0]).appendIn("fapprovebillid", approveBillIds.toArray());
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
    }

    public void updateRejectOpinionInstance(Collection<Long> processIds, Collection<Long> approveBillIds) {
        if (processIds == null || processIds.size() == 0 || approveBillIds == null || approveBillIds.size() == 0) {
            return;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("update t_eb_approverejectopinion set fiscurinstance = '0' where ", new Object[0]);
        sqlBuilder.appendIn("fprocessid", processIds.toArray());
        sqlBuilder.append(" and ", new Object[0]).appendIn("fapprovebillid", approveBillIds.toArray());
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
    }

    public void saveLocalApproveOpinion(List<Object[]> params) {
        if (params.size() == 0) {
            return;
        }
        String sql = "insert into t_eb_localapproveopinion (fid,fprocessid,ftype,fopinion,fapprovetime,fapproveuser,fmainjob,fapprovebill,fentityid,fsubmitentityid,fviewid) values (?,?,?,?,?,?,?,?,?,?,?)";
        DB.executeBatch((DBRoute)DBRoute.of((String)"epm"), (String)sql, params);
    }

    public List<LocalApproveRecord> getLocalApproveRecords(Set<Long> processIds) {
        if (processIds == null || processIds.size() == 0) {
            return new ArrayList<LocalApproveRecord>(16);
        }
        ArrayList<LocalApproveRecord> records = new ArrayList<LocalApproveRecord>(16);
        ArrayList<Long> userIds = new ArrayList<Long>(16);
        HashSet<Long> entityIds = new HashSet<Long>(16);
        HashSet<Long> viewIds = new HashSet<Long>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select ftype, fopinion, fapprovetime, fapproveuser, fmainjob, fapprovebill, fentityid, fsubmitentityid, fviewid from t_eb_localapproveopinion where ", new Object[0]);
        sqlBuilder.appendIn("fprocessid", processIds.toArray());
        try (DataSet ds = DB.queryDataSet((String)"queryLocalOpinion", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                Row row = ds.next();
                LocalApproveRecord record = new LocalApproveRecord();
                record.setType(LocalRecordTypeEnum.getTypeByIndex((String)row.getString("ftype")));
                record.setOpinion(row.getString("fopinion"));
                Timestamp approveTime = row.getTimestamp("fapprovetime");
                if (approveTime != null) {
                    record.setApproveTime(new Date(approveTime.getTime()));
                }
                Long user = row.getLong("fapproveuser");
                record.setApproveUser(user);
                userIds.add(user);
                record.setMainJob(row.getString("fmainjob"));
                record.setBillNo(row.getString("fapprovebill"));
                Long entityId = row.getLong("fentityid");
                record.setEntityId(entityId);
                entityIds.add(entityId);
                Long submitEntityId = row.getLong("fsubmitentityid");
                record.setSubmitEntityId(submitEntityId);
                entityIds.add(submitEntityId);
                Long viewId = row.getLong("fviewid");
                record.setViewId(viewId);
                viewIds.add(viewId);
                records.add(record);
            }
        }
        HashMap<Long, String> nameMap = new HashMap<Long, String>(16);
        List userInfos = UserServiceHelper.getUserInfoByID(userIds);
        Map userMainJobs = UserServiceHelper.getUserMainJob(userIds);
        for (Map userInfo : userInfos) {
            String name = userInfo.getOrDefault("name", "").toString();
            nameMap.put(ConvertUtils.toLong(userInfo.get("id")), name);
        }
        HashMap entityInfos = new HashMap(16);
        DynamicObjectCollection members = QueryServiceHelper.query((String)SysDimensionEnum.Entity.getMemberTreemodel(), (String)"id, name", (QFilter[])new QFilter[]{new QFilter("id", "in", entityIds)});
        members.forEach(e -> entityInfos.put(e.getLong("id"), e.getString("name")));
        HashMap viewInfos = new HashMap(16);
        DynamicObjectCollection views = QueryServiceHelper.query((String)"eb_dimensionview", (String)"id, name", (QFilter[])new QFilter[]{new QFilter("id", "in", viewIds)});
        views.forEach(e -> viewInfos.put(e.getLong("id"), e.getString("name")));
        records.forEach(e -> {
            e.setUserName(nameMap.getOrDefault(e.getApproveUser(), ""));
            if (StringUtils.isEmpty((String)e.getMainJob())) {
                e.setMainJob(userMainJobs.getOrDefault(e.getApproveUser(), ""));
            }
            e.setEntityName(entityInfos.getOrDefault(e.getEntityId(), ""));
            e.setSubmitEntityName(entityInfos.getOrDefault(e.getSubmitEntityId(), ""));
            e.setViewName(viewInfos.getOrDefault(e.getViewId(), ""));
        });
        return records;
    }

    public void deleteApproveBillReadRecord(Collection<Long> approveBillIds) {
        DeleteServiceHelper.delete((String)"eb_approve_readrecord", (QFilter[])new QFilter("approvebill", "in", approveBillIds).toArray());
    }

    public void saveCurApproveBillReadRecord(Long approveBillId, Long reportProcessId) {
        if (IDUtils.isEmptyLong((Long)approveBillId).booleanValue() || IDUtils.isEmptyLong((Long)reportProcessId).booleanValue()) {
            return;
        }
        QFilter qFilter = new QFilter("approvebill", "=", (Object)approveBillId);
        qFilter.and("reportprocess", "=", (Object)reportProcessId);
        qFilter.and("creater", "=", (Object)UserUtils.getUserId());
        if (QueryServiceHelper.exists((String)"eb_approve_readrecord", (QFilter[])qFilter.toArray())) {
            return;
        }
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"eb_approve_readrecord");
        object.set("approvebill", (Object)approveBillId);
        object.set("reportprocess", (Object)reportProcessId);
        object.set("creater", (Object)UserUtils.getUserId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
    }

    public Map<Long, List<Long>> queryUserApproveBillReadRecords(Collection<Long> approveBillIds, Long userId) {
        QFilter qFilter = new QFilter("approvebill", "in", approveBillIds);
        qFilter.and("creater", "=", (Object)userId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_approve_readrecord", (String)"approvebill, reportprocess", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            HashMap<Long, List<Long>> records = new HashMap<Long, List<Long>>(16);
            for (DynamicObject dynamicObject : query) {
                long reportProcess;
                long approveBill = dynamicObject.getLong("approvebill");
                List processIds = records.computeIfAbsent(approveBill, k -> new ArrayList(16));
                if (processIds.contains(reportProcess = dynamicObject.getLong("reportprocess"))) continue;
                processIds.add(reportProcess);
            }
            return records;
        }
        return new HashMap<Long, List<Long>>(16);
    }

    public void clearProcessSubmitInfo(Set<Long> savedProcessIds) {
        if (savedProcessIds.size() == 0) {
            return;
        }
        HashSet<Long> unSaved = new HashSet<Long>(16);
        HashSet<Long> saved = new HashSet<Long>(16);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid, fmodifier from t_eb_reportprocess where ", new Object[0]);
        sqlBuilder.appendIn("fid", savedProcessIds.toArray());
        try (DataSet ds = DB.queryDataSet((String)"queryProcess", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long modifier = row.getLong("fmodifier");
                if (modifier == null || modifier == 0L) {
                    unSaved.add(row.getLong("fid"));
                    continue;
                }
                saved.add(row.getLong("fid"));
            }
        }
        if (unSaved.size() != 0) {
            sqlBuilder = new SqlBuilder();
            sqlBuilder.append("update t_eb_reportprocess set fstatus = '0', fsubmitdate = null, fsubmituser = 0, fsubmitentity = 0, fapprovebill = 0 where ", new Object[0]);
            sqlBuilder.appendIn("fid", unSaved.toArray());
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
        }
        if (saved.size() != 0) {
            sqlBuilder = new SqlBuilder();
            sqlBuilder.append("update t_eb_reportprocess set fstatus = '7', fsubmitdate = null, fsubmituser = 0, fsubmitentity = 0, fapprovebill = 0 where ", new Object[0]);
            sqlBuilder.appendIn("fid", saved.toArray());
            DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
        }
        UpgradesTaskUtil.getInstance().clearDataEntityCache("eb_reportprocess");
    }

    public Set<Long> getSelectApproveIds(DynamicObject[] dataEntities) {
        HashSet<Long> selectedApproveBillIds = new HashSet<Long>(16);
        if (dataEntities.length == 0) {
            return selectedApproveBillIds;
        }
        for (DynamicObject dataEntity : dataEntities) {
            selectedApproveBillIds.add(dataEntity.getLong("id"));
        }
        return selectedApproveBillIds;
    }

    public void saveSubmitInfos(Collection<Long> approveBillIds) {
        if (approveBillIds == null || approveBillIds.size() == 0) {
            return;
        }
        Date now = TimeServiceHelper.now();
        ArrayList<DynamicObject> submitInfos = new ArrayList<DynamicObject>(16);
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"eb_approvebill", (String)"id, approveinfo", (QFilter[])new QFilter[]{new QFilter("id", "in", approveBillIds)});
        bills.forEach(e -> {
            DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)"eb_approveinforecord");
            record.set("relateid", (Object)e.getLong("id"));
            record.set("type", (Object)"0");
            record.set("submittime", (Object)now);
            record.set("approveinfo", (Object)e.getString("approveinfo"));
            submitInfos.add(record);
        });
        Map<Long, ReportProcess> processInfo = this.getApproveRefReportProcessInfo(approveBillIds);
        Map<Long, String> approveDescMap = this.getApproveDescMap(processInfo.keySet());
        for (Map.Entry<Long, String> approveDescEntry : approveDescMap.entrySet()) {
            DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)"eb_approveinforecord");
            Long processId = approveDescEntry.getKey();
            record.set("relateid", (Object)processId);
            ReportProcess reportProcess = processInfo.getOrDefault(processId, null);
            if (reportProcess != null) {
                record.set("otherrelateid", (Object)reportProcess.getApproveBillId());
            }
            record.set("type", (Object)"1");
            record.set("submittime", (Object)now);
            record.set("approveinfo", (Object)approveDescEntry.getValue());
            submitInfos.add(record);
        }
        if (submitInfos.size() != 0) {
            SaveServiceHelper.save((DynamicObject[])submitInfos.toArray(new DynamicObject[0]));
        }
    }

    public void saveApproveBillAuditType(Collection<Long> approveBillIds) {
        DynamicObject[] needSaveDatas = BusinessDataServiceHelper.load((Object[])approveBillIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"eb_approvebill"));
        if (needSaveDatas.length == 0) {
            return;
        }
        for (DynamicObject needSaveData : needSaveDatas) {
            List nodes = WorkflowServiceHelper.getProcessElements((DynamicObject)needSaveData, (String)"submit");
            AuditTypeEnum type = nodes == null || nodes.size() != 0 ? AuditTypeEnum.WORKFLOW : AuditTypeEnum.LOCAL;
            needSaveData.set("audittype", (Object)type.getType());
        }
        SaveServiceHelper.save((DynamicObject[])needSaveDatas);
    }

    public boolean isJoinAuditNode(Long approveBillId) {
        return this.isJoinAuditNode(approveBillId, false);
    }

    public boolean isJoinAuditNode(Long approveBillId, boolean isLeaveNode) {
        String curNodeId;
        if (approveBillId == null) {
            return false;
        }
        String businessKey = String.valueOf(approveBillId);
        if (isLeaveNode) {
            List allApprovalRecord = WorkFlowUtil.getAllApprovalRecord((String)businessKey);
            if (allApprovalRecord == null || allApprovalRecord.size() == 0) {
                curNodeId = "";
            } else {
                IApprovalRecordGroup approvalRecordGroup = (IApprovalRecordGroup)allApprovalRecord.get(allApprovalRecord.size() - 1);
                List children = approvalRecordGroup.getChildren();
                if (children == null || children.size() == 0) {
                    curNodeId = "";
                } else {
                    IApprovalRecordItem iApprovalRecordItem = (IApprovalRecordItem)children.get(0);
                    curNodeId = iApprovalRecordItem.getActivityId();
                }
            }
        } else {
            Long taskId = WorkflowServiceHelper.getTaskIdByBusinessKeyAndUserId((String)businessKey, (Long)UserUtils.getUserId());
            curNodeId = WorkFlowUtil.getCurNodeId((Long)taskId);
        }
        return this.isJoinAuditNode(approveBillId, curNodeId);
    }

    public boolean isJoinAuditNode(Long approveBillId, String curNode) {
        WFFlowElement element = this.getElementByNodeId(approveBillId, curNode);
        if (element == null) {
            return false;
        }
        return element instanceof WFJointAuditTask;
    }

    public WFFlowElement getElementByNodeId(Long approveBillId, String curNode) {
        if (approveBillId == null || StringUtils.isEmpty((String)curNode)) {
            return null;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)approveBillId, (String)"eb_approvebill");
        List elements = WorkflowServiceHelper.getProcessElements((DynamicObject)dynamicObject, (String)"submit");
        if (elements == null) {
            return null;
        }
        for (WFFlowElement element : elements) {
            String id = element.getId();
            if (!curNode.equals(id)) continue;
            return element;
        }
        return null;
    }

    public boolean isCurWaitNode(long approveBill) {
        if (approveBill == 0L) {
            return false;
        }
        String node = "";
        List processWindowRecords = WorkflowServiceHelper.getProcessWindowRecords((String)String.valueOf(approveBill));
        for (Map processWindowRecord : processWindowRecords) {
            Boolean executed = Convert.toBool(processWindowRecord.get("executed"), (Boolean)false);
            if (executed.booleanValue()) continue;
            node = processWindowRecord.getOrDefault("nodeId", "").toString();
            break;
        }
        if (StringUtils.isEmpty((String)node)) {
            return false;
        }
        WFFlowElement element = this.getElementByNodeId(approveBill, node);
        if (element == null) {
            return false;
        }
        return "WaitTask".equals(element.getType());
    }

    public void saveTmpData(Collection<Long> processIds, Collection<Long> approveBills) {
        if (processIds.size() == 0) {
            return;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fprocessid,fmustreject,fopinion,fauditnode,frejectuser,frejecttime,frejectnode,fapprovebillid from t_eb_approverejectopinion_tmp where fisused = '0' and ", new Object[0]);
        sqlBuilder.appendIn("fprocessid", processIds.toArray());
        sqlBuilder.append(" and ", new Object[0]).appendIn("fapprovebillid", approveBills.toArray());
        sqlBuilder.append(" order by frejecttime asc", new Object[0]);
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        HashMap<Long, Object[]> paramMap = new HashMap<Long, Object[]>(16);
        try (DataSet ds = DB.queryDataSet((String)"queryTmpOpinion", (DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);){
            while (ds.hasNext()) {
                String mustReject;
                Row row = ds.next();
                Long processId = row.getLong("fprocessid");
                Timestamp rejectTime = row.getTimestamp("frejecttime");
                if (rejectTime == null) continue;
                Object[] object = (Object[])paramMap.get(processId);
                if (object == null) {
                    String mustReject2 = row.getString("fmustreject");
                    String opinion = row.getString("fopinion");
                    paramMap.put(processId, new Object[]{0L, processId, mustReject2, opinion, row.getString("fauditnode"), row.getString("frejectnode"), "0", row.getLong("frejectuser"), rejectTime, "0", "1", row.getLong("fapprovebillid")});
                    continue;
                }
                boolean isModifyReject = false;
                String _opinion = row.getString("fopinion");
                if (StringUtils.isNotEmpty((String)_opinion)) {
                    object[3] = _opinion;
                    object[7] = row.getLong("frejectuser");
                    object[8] = rejectTime;
                    isModifyReject = true;
                }
                if (Convert.toBool((Object)(mustReject = row.getString("fmustreject")), (Boolean)false).booleanValue()) {
                    object[2] = mustReject;
                    if (!isModifyReject) {
                        object[7] = row.getLong("frejectuser");
                        object[8] = rejectTime;
                        isModifyReject = true;
                    }
                }
                if (isModifyReject) continue;
                object[7] = row.getLong("frejectuser");
                object[8] = rejectTime;
            }
        }
        if (paramMap.size() == 0) {
            return;
        }
        long[] pkIds = DB.genGlobalLongIds((int)paramMap.size());
        int index = -1;
        for (Object[] param : paramMap.values()) {
            param[0] = pkIds[++index];
            params.add(param);
        }
        ApproveUtils.getInstance().saveRejectOpinion(params);
        sqlBuilder = new SqlBuilder();
        sqlBuilder.append("update t_eb_approverejectopinion_tmp set fisused = '1' where ", new Object[0]);
        sqlBuilder.appendIn("fprocessid", processIds.toArray());
        sqlBuilder.append(" and ", new Object[0]).appendIn("fapprovebillid", approveBills.toArray());
        DB.execute((DBRoute)DBRoute.of((String)"epm"), (SqlBuilder)sqlBuilder);
    }

    public void updateMainApproveStatus(Set<Long> selBillIds) {
        Map parentApproveBills = ApproveBillHelper.getParentApproveBills(selBillIds);
        if (parentApproveBills.size() == 0) {
            return;
        }
        Map subApproveBillLists = ApproveBillHelper.getSubApproveBillLists(new HashSet(parentApproveBills.values()), (boolean)false);
        if (subApproveBillLists.size() == 0) {
            return;
        }
        HashSet<Long> toUpdateApproves = new HashSet<Long>(16);
        for (Map.Entry entry : subApproveBillLists.entrySet()) {
            Long approveBillId = (Long)entry.getKey();
            List bills = (List)entry.getValue();
            boolean isAllPass = true;
            for (ApproveBillInfo bill : bills) {
                Long id = bill.getBillId();
                if (selBillIds.contains(id)) continue;
                String billStatus = bill.getBillStatus();
                if (ApproveBillStatus.AUDIT.getNumber().equals(billStatus)) continue;
                isAllPass = false;
                break;
            }
            if (!isAllPass) continue;
            toUpdateApproves.add(approveBillId);
        }
        if (toUpdateApproves.size() == 0) {
            return;
        }
        this.updateApproveBillType(toUpdateApproves, false);
    }

    public void updateApproveBillType(Collection<Long> billIds, boolean isMainBill) {
        DynamicObject[] bills;
        if (CollectionUtils.isEmpty(billIds)) {
            return;
        }
        for (DynamicObject bill : bills = BusinessDataServiceHelper.load((Object[])billIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_approvebill"))) {
            bill.set("centralbilltype", (Object)(isMainBill ? CentralBillType.Main.getNumber() : CentralBillType.Normal.getNumber()));
        }
        SaveServiceHelper.save((DynamicObject[])bills);
    }

    public void checkAndRejectMainBill(Long billId, String currentWFNodeNumber) {
        ApproveBillInfo approveBillInfo = ApproveBillHelper.queryBill((Long)billId);
        if (approveBillInfo == null) {
            return;
        }
        if (approveBillInfo.getCentralBillType() == CentralBillType.Child) {
            RejectNodeInfo firstRejectNodeInfo;
            List subApproveBillList = ApproveBillHelper.getSubApproveBillList((Long)approveBillInfo.getParentBillId());
            boolean allReject = true;
            for (ApproveBillInfo bill : subApproveBillList) {
                if (bill.getBillId().equals(billId) || !StringUtils.equals((String)approveBillInfo.getNodeId(), (String)bill.getNodeId()) || bill.getBillStatus().equals(ApproveBillStatus.DISCARD.getNumber()) || bill.getBillStatus().equals(ApproveBillStatus.REJECT.getNumber())) continue;
                allReject = false;
                break;
            }
            CentralBillRptSubmitHelper.buildSubmitRecord((ApproveBillInfo)approveBillInfo);
            if (allReject && (firstRejectNodeInfo = WorkFlowUtil.getFirstRejectNodeInfo((Long)approveBillInfo.getParentBillId())).isAvailable()) {
                this.updateApproveBillType(Collections.singletonList(approveBillInfo.getParentBillId()), false);
                WorkFlowUtil.reject2FirstEnableNode((RejectNodeInfo)firstRejectNodeInfo);
                log.info(String.format("rejectMainBill--cBill:%s,mBill:%s", billId, approveBillInfo.getParentBillId()));
            }
        } else {
            this.discardAllChildBills(approveBillInfo, currentWFNodeNumber);
            HashSet<Long> billIds = new HashSet<Long>(1);
            billIds.add(billId);
            ApproveUtils.getInstance().updateApproveSplitBillType(billIds);
        }
    }

    public void discardAllChildBills(ApproveBillInfo approveBillInfo, String currentNodeNumber) {
        this.discardAllChildBills(approveBillInfo, currentNodeNumber, null);
    }

    public void discardAllChildBills(ApproveBillInfo approveBillInfo, String currentNodeNumber, Set<String> nextNodeNumbers) {
        Long billId = approveBillInfo.getBillId();
        log.info("discardAllChildBills--mainBillId:{}", (Object)billId);
        int newSplitVersion = approveBillInfo.getSplitVersion();
        DynamicObject[] objs = ApproveBillHelper.loadCentralBillObj((Long)billId, (String)"billstatus,auditnode,splitversion");
        if (objs != null && objs.length > 0) {
            if (StringUtils.isNotEmpty((String)currentNodeNumber) && nextNodeNumbers == null) {
                nextNodeNumbers = new HashSet<String>(16);
                WorkFlowUtil.selFlowSignNodes((String)"eb_approvebill", (Long)billId, (String)currentNodeNumber, (boolean)true, null, nextNodeNumbers);
            }
            if (nextNodeNumbers != null) {
                LinkedList<DynamicObject> matchObjs = new LinkedList<DynamicObject>();
                for (DynamicObject obj : objs) {
                    String auditNode = obj.getString("auditnode");
                    int splitVersion = obj.getInt("splitversion");
                    if (!nextNodeNumbers.contains(auditNode) || StringUtils.equals((String)currentNodeNumber, (String)auditNode) && splitVersion >= newSplitVersion) continue;
                    matchObjs.add(obj);
                }
                if (matchObjs.isEmpty()) {
                    return;
                }
                objs = matchObjs.toArray(new DynamicObject[1]);
            }
            this.discardApproveBills(objs);
        }
        this.updateApproveBillType(Collections.singletonList(approveBillInfo.getBillId()), false);
    }

    public void discardApproveBills(Long mainBillId, Collection<Long> billIds) {
        if (CollectionUtils.isEmpty(billIds)) {
            return;
        }
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"eb_approvebill", (String)"id,billstatus", (QFilter[])new QFilter("id", "in", billIds).toArray());
        if (objs != null && objs.length > 0) {
            this.discardApproveBills(objs);
            if (!this.hasCentralBillNotPass(mainBillId)) {
                this.updateApproveBillType(Collections.singletonList(mainBillId), false);
            }
        }
    }

    public void discardApproveBills(DynamicObject[] objs) {
        ArrayList<String> billIdsStr = new ArrayList<String>(objs.length);
        ArrayList<Long> billIdList = new ArrayList<Long>(objs.length);
        for (DynamicObject obj : objs) {
            obj.set("billstatus", (Object)ApproveBillStatus.DISCARD.getNumber());
            billIdsStr.add(obj.getString("id"));
            billIdList.add(obj.getLong("id"));
        }
        SaveServiceHelper.save((DynamicObject[])objs);
        WorkFlowUtil.stopWorkFlowProcess(billIdsStr);
        CentralBillRptSubmitHelper.delSubmitRecord(billIdList);
        log.info("discardApproveBills--billIds:{}", billIdsStr);
    }

    public boolean hasCentralBillOnAudit(Long mainBillId) {
        QFilter qFilter = new QFilter("id", "=", (Object)mainBillId);
        qFilter.and("centralbilltype", "=", (Object)CentralBillType.Main.getNumber());
        return QueryServiceHelper.exists((String)"eb_approvebill", (QFilter[])qFilter.toArray());
    }

    public boolean hasCentralBillNotPass(Long mainBillId) {
        QFilter qFilter = new QFilter("parentbillid", "=", (Object)mainBillId);
        qFilter.and("centralbilltype", "=", (Object)CentralBillType.Child.getNumber());
        qFilter.and("billstatus", "in", (Object)new Object[]{ApproveBillStatus.SUBMIT.getNumber(), ApproveBillStatus.REJECT.getNumber()});
        return QueryServiceHelper.exists((String)"eb_approvebill", (QFilter[])qFilter.toArray());
    }

    public void stopBillFlowInstance(Collection<Long> billIds) {
        if (billIds.size() > 0) {
            ArrayList billIdsStr = new ArrayList(billIds.size());
            billIds.forEach(id -> billIdsStr.add(id.toString()));
            WorkFlowUtil.stopWorkFlowProcess(billIdsStr);
        }
    }

    public String buildCentralBillRptName(String tempName, String orgName) {
        if (orgName != null) {
            tempName = tempName + "\u3010" + orgName + "\u3011";
        }
        return tempName;
    }

    public List<Map<String, List<MemberCondition>>> getCentralDimRange(Long billId) {
        ApproveBillInfo approveBillInfo = ApproveBillHelper.queryBill((Long)billId);
        return this.getCentralDimRange(approveBillInfo);
    }

    public List<Map<String, List<MemberCondition>>> getCentralDimRange(ApproveBillInfo approveBillInfo) {
        ArrayList<Map<String, List<MemberCondition>>> filters = new ArrayList<Map<String, List<MemberCondition>>>(16);
        if (approveBillInfo != null && approveBillInfo.isCentralBill()) {
            filters.addAll(CentralRelationShotService.getInstance().getCentralRelShotDimMemberInfo(approveBillInfo.getBillId()));
        }
        return filters;
    }

    public Map<String, Set<String>> getMembersByRange(List<Map<String, List<MemberCondition>>> memberConditions, Long datasetId, IModelCacheHelper modelCacheHelper) {
        List<Map<String, Set<String>>> membersListByRange = this.getMembersListByRange(memberConditions, datasetId, modelCacheHelper);
        return this.mergeList(membersListByRange);
    }

    public Map<String, Set<String>> mergeList(List<Map<String, Set<String>>> membersList) {
        HashMap<String, Set<String>> rangeMembers = new HashMap<String, Set<String>>(16);
        membersList.forEach(rangeMember -> rangeMember.forEach((dimNum, members) -> rangeMembers.computeIfAbsent((String)dimNum, key -> new HashSet(16)).addAll(members)));
        return rangeMembers;
    }

    public List<Map<String, Set<String>>> getMembersListByRange(List<Map<String, List<MemberCondition>>> memberConditions, Long datasetId, IModelCacheHelper modelCacheHelper) {
        ArrayList<Map<String, Set<String>>> rangeMemberList = new ArrayList<Map<String, Set<String>>>(16);
        HashMap viewMap = new HashMap(16);
        HashSet allDimNumbers = new HashSet(16);
        memberConditions.forEach(rangeMap -> allDimNumbers.addAll(rangeMap.keySet()));
        memberConditions.forEach(rangeMap -> {
            HashMap<String, Set> rangeMembers = new HashMap<String, Set>(16);
            HashSet dimNums = new HashSet(16);
            rangeMap.forEach((dimNum, conditionList) -> {
                Long viewId = viewMap.computeIfAbsent(dimNum, key -> modelCacheHelper.getViewByDataSetAndDimNumber(datasetId, key));
                conditionList.forEach(condition -> {
                    List members = modelCacheHelper.getMember(dimNum, viewId, condition.getNumber(), Integer.parseInt(condition.getRange()));
                    if (members != null) {
                        Set memberNums = rangeMembers.computeIfAbsent((String)dimNum, key -> new HashSet(16));
                        members.forEach(member -> memberNums.add(member.getNumber()));
                    }
                });
                dimNums.add(dimNum);
            });
            for (String dimNum2 : allDimNumbers) {
                if (dimNums.contains(dimNum2)) continue;
                Long viewId = viewMap.computeIfAbsent(dimNum2, key -> modelCacheHelper.getViewByDataSetAndDimNumber(datasetId, key));
                Set memberNums = rangeMembers.computeIfAbsent(dimNum2, key -> new HashSet(16));
                modelCacheHelper.getMembers(viewId, dimNum2).forEach(member -> memberNums.add(member.getNumber()));
            }
            rangeMemberList.add(rangeMembers);
        });
        return rangeMemberList;
    }

    public void filterExamineRangeByCentralBill(ReportCheckRange reportCheckRange, Long approveBillId, IModelCacheHelper modelCacheHelper) {
        List<Map<String, List<MemberCondition>>> memberConditions;
        if (IDUtils.isNotNull((Long)approveBillId) && (memberConditions = this.getCentralDimRange(approveBillId)).size() > 0) {
            this.filterExamineRangeByBillRange(reportCheckRange, memberConditions, modelCacheHelper);
        }
    }

    public void filterExamineRangeByBillRange(ReportCheckRange reportCheckRange, List<Map<String, List<MemberCondition>>> memberConditions, IModelCacheHelper modelCacheHelper) {
        List<Map<String, Set<String>>> membersByRangeList;
        if (reportCheckRange != null && (membersByRangeList = this.getMembersListByRange(memberConditions, reportCheckRange.getDatasetId(), modelCacheHelper)).size() > 0) {
            Map<String, Set<String>> memberFilters = this.mergeList(membersByRangeList);
            for (CheckRange checkRange : reportCheckRange.getCheckRangeList()) {
                List relationList;
                Map dimMembers = checkRange.getCheckRange();
                if (dimMembers != null) {
                    dimMembers.forEach((dimNum, members) -> {
                        Set filterMembers = (Set)memberFilters.get(dimNum);
                        if (filterMembers != null && members != null) {
                            members.removeIf(member -> !filterMembers.contains(member));
                        }
                    });
                }
                if ((relationList = checkRange.getRelationList()) == null) continue;
                for (ReportRelation relation : relationList) {
                    String[] dimNumbers = relation.getDimNumbers();
                    List memberRelationList = relation.getMemberRelationList();
                    memberRelationList.removeIf(members -> {
                        boolean remove = true;
                        block0: for (Map memberRange : membersByRangeList) {
                            for (int index = 0; index < dimNumbers.length; ++index) {
                                Set memberNums = (Set)memberRange.get(dimNumbers[index]);
                                if (memberNums != null && !memberNums.contains(members[index])) continue block0;
                            }
                            remove = false;
                            break;
                        }
                        return remove;
                    });
                }
            }
        }
    }

    public void finishPreCentralBill(Long approveBillId, Set<String> preNodeNumbers) {
        DynamicObject[] objs;
        if (CollectionUtils.isNotEmpty(preNodeNumbers) && (objs = ApproveBillHelper.loadCentralBillObj((Long)approveBillId, (String)"billstatus,auditnode,splitversion")) != null && objs.length > 0) {
            LinkedList<DynamicObject> toUpdateObjs = new LinkedList<DynamicObject>();
            boolean hasNotDoneBill = false;
            for (DynamicObject billObj : objs) {
                String billStatus = billObj.getString("billstatus");
                String nodeNumber = billObj.getString("auditnode");
                if (ApproveBillStatus.DISCARD.getNumber().equals(billStatus) || ApproveBillStatus.AUDIT.getNumber().equals(billStatus)) continue;
                if (!preNodeNumbers.contains(nodeNumber)) {
                    hasNotDoneBill = true;
                    continue;
                }
                toUpdateObjs.add(billObj);
            }
            if (toUpdateObjs.size() > 0) {
                HashSet<Long> billIdSet = new HashSet<Long>(toUpdateObjs.size());
                for (DynamicObject billObj : toUpdateObjs) {
                    Long billId = billObj.getLong("id");
                    try {
                        WorkFlowUtil.dumpToSubmitOrEnd((String)"eb_approvebill", (Long)billId, (boolean)true);
                    }
                    catch (Exception e) {
                        log.error("dump4FinishPreCentralBill", (Throwable)e);
                    }
                    billIdSet.add(billId);
                    billObj.set("billstatus", (Object)ApproveBillStatus.AUDIT.getNumber());
                }
                try (TXHandle tx = TX.required();){
                    try {
                        SaveServiceHelper.save((DynamicObject[])toUpdateObjs.toArray(new DynamicObject[1]));
                        ApproveBillSubmitHelper.getInstance().updateRptProcess(billIdSet, BgTaskStateEnum.COMPLETED, OperateOption.create(), new OperationResult());
                        CentralBillRptSubmitHelper.delSubmitRecord(billIdSet);
                        if (!hasNotDoneBill) {
                            this.updateApproveBillType(Collections.singletonList(approveBillId), false);
                        }
                    }
                    catch (Exception e) {
                        tx.markRollback();
                        throw e;
                    }
                }
                log.info("finishPreCentralBill--mBill:{},preNode:{},cBill:{},hasNotDoneBill:{}", new Object[]{approveBillId, preNodeNumbers, billIdSet, hasNotDoneBill});
            }
        }
    }

    public Map<Long, Long> queryApproveBillCreateId(Collection<Long> approveBillIds) {
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"eb_approvebill", (String)"id, createrid", (QFilter[])new QFilter[]{new QFilter("id", "in", approveBillIds)});
        HashMap<Long, Long> resultMap = new HashMap<Long, Long>(16);
        for (DynamicObject bill : bills) {
            resultMap.put(bill.getLong("id"), bill.getLong("createrid"));
        }
        return resultMap;
    }

    public String isParentEntityInApprove(Map<String, Long> dimMembers, List<Long> templateIds, Long modelId, Long viewId) {
        if (dimMembers == null || dimMembers.size() == 0) {
            return null;
        }
        if (modelId == null || viewId == null) {
            return null;
        }
        QFilter qFilter = new QFilter("modelid", "=", (Object)modelId);
        qFilter.and("dim_period", "=", (Object)dimMembers.get(SysDimensionEnum.BudgetPeriod.getNumber()));
        qFilter.and("dim_version", "=", (Object)dimMembers.get(SysDimensionEnum.Version.getNumber()));
        qFilter.and("dim_datatype", "=", (Object)dimMembers.get(SysDimensionEnum.DataType.getNumber()));
        qFilter.and("entryentity.tempid", "in", templateIds);
        qFilter.and("billstatus", "in", Arrays.asList("B", "D", "E"));
        DynamicObjectCollection approveBills = QueryServiceHelper.query((String)"eb_approvebill", (String)"eborgid, billno, entryentity.tempid as temp", (QFilter[])qFilter.toArray());
        if (approveBills.size() == 0) {
            return null;
        }
        Long orgId = dimMembers.get(SysDimensionEnum.Entity.getNumber());
        HashMap orgBillMap = new HashMap(16);
        HashSet ebOrgIds = new HashSet(16);
        approveBills.stream().filter(e -> !orgId.equals(e.getLong("eborgid"))).forEach(e -> {
            orgBillMap.put(e.getLong("eborgid") + "!" + e.getLong("temp"), e.getString("billno"));
            ebOrgIds.add(e.getLong("eborgid"));
        });
        HashSet<String> ebOrgStr = new HashSet<String>(orgBillMap.keySet());
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        Dimension entity = modelCacheHelper.getDimension(SysDimensionEnum.Entity.getNumber());
        String refOrg = this.checkOrgRefInViews(entity, ebOrgStr, Collections.singleton(viewId), orgId, templateIds);
        if (StringUtils.isNotEmpty((String)refOrg)) {
            return orgBillMap.getOrDefault(refOrg, "");
        }
        Set allViewIds = DimensionViewServiceHelper.getViewsByViewId((Long)viewId);
        allViewIds.remove(viewId);
        refOrg = this.checkOrgRefInViews(entity, ebOrgStr, allViewIds, orgId, templateIds);
        if (StringUtils.isNotEmpty((String)refOrg)) {
            return orgBillMap.getOrDefault(refOrg, "");
        }
        Set entityIdSetByView = MemberHelper.getEntityIdSetByView((IModelCacheHelper)modelCacheHelper, (Long)viewId, (Long)orgId, (Integer)RangeEnum.VALUE_50.getValue());
        entityIdSetByView.removeAll(ebOrgIds);
        List reportProcessList = ReportProcessServiceImpl.getInstance().getReportProcessList(modelId, viewId, entityIdSetByView, new HashSet<Long>(templateIds), dimMembers.get(SysDimensionEnum.BudgetPeriod.getNumber()), dimMembers.get(SysDimensionEnum.DataType.getNumber()), dimMembers.get(SysDimensionEnum.Version.getNumber()));
        List processes = reportProcessList.stream().filter(e -> orgId.equals(e.getSubmitEntity())).collect(Collectors.toList());
        for (ReportProcess reportProcess : processes) {
            refOrg = this.checkOrgRefInViews(entity, ebOrgStr, allViewIds, reportProcess.getEntityId(), Lists.newArrayList((Object[])new Long[]{reportProcess.getTemplateId()}));
            if (!StringUtils.isNotEmpty((String)refOrg)) continue;
            return orgBillMap.getOrDefault(refOrg, "");
        }
        return null;
    }

    private String checkOrgRefInViews(Dimension entity, Set<String> ebOrgStr, Set<Long> allViewIds, Long orgId, List<Long> templateIds) {
        if (entity == null || ebOrgStr == null || allViewIds == null || orgId == null || templateIds == null || templateIds.size() == 0) {
            return "";
        }
        for (String ebOrg : ebOrgStr) {
            String[] split = ebOrg.split("!");
            if (split.length != 2) continue;
            Long ebOrgId = ConvertUtils.toLong((Object)split[0]);
            Long templateId = ConvertUtils.toLong((Object)split[1]);
            if (!templateIds.contains(templateId)) continue;
            for (Long allViewId : allViewIds) {
                Member mem;
                Member member = entity.getMember(allViewId, orgId);
                if (member == null || (mem = entity.getMember(allViewId, ebOrgId)) == null || mem.getLevel() == member.getLevel() || !member.getLongNumber().contains(mem.getLongNumber() + "!")) continue;
                return ebOrg;
            }
        }
        return "";
    }

    public String isParentEntityInApprove(Long approveBillId) {
        HashMap<String, Long> dimMembers = new HashMap<String, Long>(16);
        String fields = "modelid, dim_period, dim_version, dim_datatype, entryentity.tempid as tempid, orgviewid, eborgid";
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"eb_approvebill", (String)fields, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)approveBillId)});
        Long modelId = null;
        Long viewId = null;
        ArrayList<Long> templateIds = new ArrayList<Long>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (dimMembers.size() == 0) {
                dimMembers.put(SysDimensionEnum.BudgetPeriod.getNumber(), dynamicObject.getLong("dim_period"));
                dimMembers.put(SysDimensionEnum.Version.getNumber(), dynamicObject.getLong("dim_version"));
                dimMembers.put(SysDimensionEnum.DataType.getNumber(), dynamicObject.getLong("dim_datatype"));
                dimMembers.put(SysDimensionEnum.Entity.getNumber(), dynamicObject.getLong("eborgid"));
                modelId = dynamicObject.getLong("modelid");
                viewId = dynamicObject.getLong("orgviewid");
            }
            templateIds.add(dynamicObject.getLong("tempid"));
        }
        return this.isParentEntityInApprove(dimMembers, templateIds, modelId, viewId);
    }

    public boolean validateRepeat(List<DynamicObject> needSaveDatas) {
        HashSet<Long> templateIds = new HashSet<Long>(16);
        for (DynamicObject needSaveData : needSaveDatas) {
            DynamicObjectCollection entryEntity = needSaveData.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entryEntity) {
                long id = dynamicObject.getLong("id");
                long tempId = 0L;
                tempId = IDUtils.isNull((long)id) ? dynamicObject.getLong("tempid") : dynamicObject.getLong("tempid.id");
                if (templateIds.add(tempId)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean validateApproveBillReportRepeat(DynamicObject[] approveBills) {
        HashMap<String, Set> templateMap = new HashMap<String, Set>(approveBills.length);
        for (DynamicObject approveBill : approveBills) {
            long orgId = approveBill.getLong("eborgid.id");
            long periodId = approveBill.getLong("dim_period.id");
            long versionId = approveBill.getLong("dim_version.id");
            long datatypeId = approveBill.getLong("dim_datatype.id");
            String key = orgId + "_" + periodId + "_" + versionId + "_" + datatypeId;
            Set templateIds = templateMap.computeIfAbsent(key, v -> new HashSet(16));
            DynamicObjectCollection entryentity = approveBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entryentity) {
                if (templateIds.add(dynamicObject.getLong("tempid.id"))) continue;
                return true;
            }
        }
        return false;
    }

    public Pair<String, Set<Long>> validateApproveBillCanSubmit(Collection<Long> approveIds) {
        Set<Long> approveReportProcessIds = ApproveUtils.getInstance().getApproveRefReportProcessIds(approveIds);
        DynamicObject[] reportProcesses = BusinessDataServiceHelper.load((Object[])approveReportProcessIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_reportprocess"));
        StringBuilder stringBuilder = new StringBuilder();
        HashSet<Long> hasSubmitReportProcessIds = new HashSet<Long>(16);
        for (DynamicObject reportProcess : reportProcesses) {
            long approveId;
            String status = reportProcess.getString("status");
            if (!"3".equals(status) && !"5".equals(status) || approveIds.contains(approveId = reportProcess.getLong("approvebill.id"))) continue;
            hasSubmitReportProcessIds.add(reportProcess.getLong("id"));
            String userName = reportProcess.getString("submituser.name");
            String templateName = reportProcess.getString("template.name");
            String tips = ResManager.loadResFormat((String)"\u62a5\u8868%1\u5df2\u7ecf\u88ab\u7528\u6237%2\u63d0\u4ea4", (String)"", (String)"epm-eb-formplugin", (Object[])new Object[]{templateName, userName});
            stringBuilder.append(tips).append("\u3001");
        }
        if (StringUtils.isNotEmpty((String)stringBuilder.toString()) && CollectionUtils.isNotEmpty(hasSubmitReportProcessIds)) {
            return new Pair((Object)stringBuilder.substring(0, stringBuilder.length() - 1), hasSubmitReportProcessIds);
        }
        return null;
    }

    public void deleteHasSubmitReport(Set<Long> reportProcessIds, Set<Object> approveBillIds) {
        if (CollectionUtils.isEmpty(reportProcessIds) || CollectionUtils.isEmpty(approveBillIds)) {
            return;
        }
        Map reportProcess = BusinessDataServiceHelper.loadFromCache((Object[])reportProcessIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_reportprocess"));
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])approveBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_approvebill"));
        HashSet<String> entityTempStr = new HashSet<String>(reportProcess.size());
        for (Map.Entry entry : reportProcess.entrySet()) {
            DynamicObject value = (DynamicObject)entry.getValue();
            long entityId = value.getLong("entity.id");
            long periodId = value.getLong("period.id");
            long versionId = value.getLong("version.id");
            long datatypeId = value.getLong("datatype.id");
            long templateId = value.getLong("template.id");
            String key = entityId + "_" + periodId + "_" + versionId + "_" + datatypeId + "_" + templateId;
            entityTempStr.add(key);
        }
        for (DynamicObject dynamicObject : load) {
            long orgId = dynamicObject.getLong("eborgid.id");
            long periodId = dynamicObject.getLong("dim_period.id");
            long versionId = dynamicObject.getLong("dim_version.id");
            long datatypeId = dynamicObject.getLong("dim_datatype.id");
            String key = orgId + "_" + periodId + "_" + versionId + "_" + datatypeId;
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            Iterator iterator = entryentity.iterator();
            while (iterator.hasNext()) {
                DynamicObject next = (DynamicObject)iterator.next();
                long tempid = next.getLong("tempid.id");
                if (!entityTempStr.contains(key + "_" + tempid)) continue;
                iterator.remove();
            }
        }
        SaveServiceHelper.save((DynamicObject[])load);
    }

    public void updateApproveSplitBillType(Set<Long> billIds) {
        DynamicObject[] bills;
        if (CollectionUtils.isEmpty(billIds)) {
            return;
        }
        Map billMap = ApproveBillHelper.getSubApproveBillLists(billIds, (boolean)false);
        for (DynamicObject bill : bills = BusinessDataServiceHelper.load((Object[])billIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_approvebill"))) {
            Long billId = bill.getLong("id");
            String billType = bill.getString("splitbilltype");
            List subBillList = (List)billMap.get(billId);
            if (!CollectionUtils.isEmpty((Collection)subBillList) || CentralBillType.Reject.getNumber().equals(billType)) continue;
            bill.set("splitbilltype", (Object)CentralBillType.Normal.getNumber());
        }
        SaveServiceHelper.save((DynamicObject[])bills);
    }

    public void addHistoryApproveRecord(Set<Long> approveBillIds, String operation, ILocaleString opName) {
        if (approveBillIds == null || approveBillIds.size() == 0) {
            return;
        }
        QFilter qFilter = new QFilter("id", "in", approveBillIds);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_approvebill", (String)"id, billno, eborgid, orgviewid,modelid", (QFilter[])new QFilter[]{qFilter});
        HashSet<Long> entitySet = new HashSet<Long>(16);
        IModelCacheHelper orCreate = null;
        for (DynamicObject dynamicObject : query) {
            Member member;
            if (orCreate == null) {
                orCreate = ModelCacheContext.getOrCreate((Long)dynamicObject.getLong("modelid"));
            }
            if ((member = orCreate.getMember("Entity", Long.valueOf(dynamicObject.getLong("orgviewid")), Long.valueOf(dynamicObject.getLong("eborgid")))) == null) continue;
            List children = orCreate.getChildren(member, true);
            entitySet.addAll(children.stream().map(BaseCache::getId).collect(Collectors.toSet()));
        }
        Map<Long, List<Long>> refProcessIds = this.getRefReportProcessInfoMapWithAllEntity(approveBillIds, null, entitySet);
        ArrayList<DynamicObject> toSaves = new ArrayList<DynamicObject>(16);
        for (DynamicObject dynamicObject : query) {
            long billId = dynamicObject.getLong("id");
            List<Long> processIds = refProcessIds.get(billId);
            if (processIds == null || processIds.size() == 0) continue;
            toSaves.addAll(this.getToAddHistoryApproveRecord(dynamicObject, operation, opName, new HashSet<Long>(processIds)));
        }
        if (toSaves.size() != 0) {
            SaveServiceHelper.save((DynamicObject[])toSaves.toArray(new DynamicObject[0]));
        }
    }

    public void addHistoryApproveRecordWithoutRefer(Set<Long> approveBillIds, DynamicObjectCollection bills, String operation, ILocaleString opName) {
        if (approveBillIds == null || approveBillIds.size() == 0 || bills == null) {
            return;
        }
        ArrayList<String> billNos = new ArrayList<String>(16);
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(16);
        for (DynamicObject dynamicObject : bills) {
            String billNo = dynamicObject.getString("billno");
            billNos.add(billNo);
            map.put(billNo, dynamicObject);
        }
        QFilter qFilter = new QFilter("approvebill", "in", approveBillIds);
        bills = QueryServiceHelper.query((String)"eb_historyapproverecord", (String)"billno, process", (QFilter[])new QFilter[]{qFilter});
        HashMap processMap = new HashMap(16);
        bills.forEach(e -> processMap.computeIfAbsent(e.getString("billno"), k -> new ArrayList(16)).add(e.getLong("process")));
        ArrayList<DynamicObject> toSaves = new ArrayList<DynamicObject>(16);
        for (String billNo : billNos) {
            List processIds;
            DynamicObject dynamicObject = (DynamicObject)map.get(billNo);
            if (dynamicObject == null || (processIds = (List)processMap.get(billNo)) == null) continue;
            toSaves.addAll(this.getToAddHistoryApproveRecord(dynamicObject, operation, opName, new HashSet<Long>(processIds)));
        }
        if (toSaves.size() != 0) {
            SaveServiceHelper.save((DynamicObject[])toSaves.toArray(new DynamicObject[0]));
        }
    }

    public List<DynamicObject> getToAddHistoryApproveRecord(DynamicObject approve, String operation, ILocaleString opName, Set<Long> processIds) {
        if (approve == null || processIds == null || processIds.size() == 0) {
            return new ArrayList<DynamicObject>(16);
        }
        ArrayList<DynamicObject> toSaves = new ArrayList<DynamicObject>(16);
        for (Long processId : processIds) {
            DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)"eb_historyapproverecord");
            record.set("billno", (Object)approve.getString("billno"));
            record.set("approvebill", (Object)approve.getLong("id"));
            record.set("operationname", (Object)opName);
            record.set("operation", (Object)operation);
            record.set("user", (Object)UserUtils.getUserId());
            record.set("entity", (Object)approve.getLong("eborgid"));
            record.set("view", (Object)approve.getLong("orgviewid"));
            record.set("process", (Object)processId);
            record.set("audittime", (Object)TimeServiceHelper.now());
            toSaves.add(record);
        }
        return toSaves;
    }

    public void saveReportStatusRecord(Set<Long> approveBillIds) {
    }

    public void deleteReportStatusRecord(Set<Long> approveBillIds) {
    }

    public void updateReportStatusForUnSubmit(Set<Long> approveBillIds) {
    }

    public static Set<String> getApproveBillNumber(Collection<Long> billIds) {
        DynamicObjectCollection approveBills = QueryServiceHelper.query((String)"eb_approvebill", (String)"billno", (QFilter[])new QFilter("id", "in", billIds).toArray());
        if (CollectionUtils.isNotEmpty((Collection)approveBills)) {
            return approveBills.stream().map(e -> e.getString("billno")).collect(Collectors.toSet());
        }
        return new HashSet<String>(0);
    }

    public Map<Long, List<Long>> getReportProcessIdsByBillIds(Collection<Long> approveBillIds, boolean includePassive) {
        Object[] approveBills = BusinessDataServiceHelper.load((Object[])approveBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_approvebill"));
        if (kd.epm.eb.common.utils.CollectionUtils.isEmpty((Object[])approveBills)) {
            return new HashMap<Long, List<Long>>(16);
        }
        Long modelId = approveBills[0].getLong("modelid.id");
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        HashSet<Long> periodIds = new HashSet<Long>(16);
        HashSet<Long> versionIds = new HashSet<Long>(16);
        HashSet<Long> datatypeIds = new HashSet<Long>(16);
        HashSet entityIds = new HashSet(16);
        HashSet<Long> tempIds = new HashSet<Long>(16);
        HashMap<String, Set> dimBillIdMap = new HashMap<String, Set>(approveBills.length);
        StringBuilder dimStr = new StringBuilder();
        for (Object approveBill : approveBills) {
            Set orgIds;
            Long billId = approveBill.getLong("id");
            Long orgId = approveBill.getLong("eborgid.id");
            Long orgViewId = approveBill.getLong("orgviewid.id");
            if (includePassive) {
                orgIds = MemberHelper.getEntityIdSetByView((IModelCacheHelper)modelCacheHelper, (Long)orgViewId, (Long)orgId, (Integer)RangeEnum.VALUE_50.getValue());
            } else {
                orgIds = new HashSet<Long>(1);
                orgIds.add(orgId);
            }
            entityIds.addAll(orgIds);
            Long periodId = approveBill.getLong("dim_period.id");
            Long versionId = approveBill.getLong("dim_version.id");
            Long datatypeId = approveBill.getLong("dim_datatype.id");
            periodIds.add(periodId);
            versionIds.add(versionId);
            datatypeIds.add(datatypeId);
            DynamicObjectCollection tempColl = approveBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject tempObj : tempColl) {
                Long tempId = tempObj.getLong("tempid.id");
                tempIds.add(tempId);
                for (Long budgetOrgId : orgIds) {
                    dimStr.append(periodId).append('!').append(versionId).append('!').append(datatypeId).append('!').append(budgetOrgId).append('!').append(tempId);
                    Set billIds = dimBillIdMap.computeIfAbsent(dimStr.toString(), v -> new HashSet(16));
                    billIds.add(billId);
                    dimStr.setLength(0);
                }
            }
        }
        QFilter reportFilter = new QFilter("model", "=", (Object)modelId);
        reportFilter.and("period", "in", periodIds);
        reportFilter.and("version", "in", versionIds);
        reportFilter.and("datatype", "in", datatypeIds);
        reportFilter.and("entity", "in", entityIds);
        reportFilter.and("template", "in", tempIds);
        DynamicObjectCollection reportProcessList = QueryServiceHelper.query((String)"eb_reportprocess", (String)"id,approvebill,period,version,datatype,entity,template", (QFilter[])reportFilter.toArray());
        HashMap<Long, List<Long>> billReportMap = new HashMap<Long, List<Long>>(16);
        for (DynamicObject reportProcess : reportProcessList) {
            Long rptId = reportProcess.getLong("id");
            Long billId = reportProcess.getLong("approvebill");
            Long periodId = reportProcess.getLong("period");
            Long versionId = reportProcess.getLong("version");
            Long datatypeId = reportProcess.getLong("datatype");
            Long entityId = reportProcess.getLong("entity");
            Long tempId = reportProcess.getLong("template");
            dimStr.append(periodId).append('!').append(versionId).append('!').append(datatypeId).append('!').append(entityId).append('!').append(tempId);
            Set billIds = (Set)dimBillIdMap.get(dimStr.toString());
            if (CollectionUtils.isNotEmpty((Collection)billIds)) {
                for (Long id : billIds) {
                    billReportMap.computeIfAbsent(id, key -> new ArrayList(16)).add(rptId);
                }
            }
            dimStr.setLength(0);
        }
        return billReportMap;
    }
}

