/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.bizrule;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.xdb.util.ConcurrentHashSet;
import kd.epm.eb.algo.olap.LeafFeature;
import kd.epm.eb.business.bizrule.AccountRelationTester;
import kd.epm.eb.business.bizrule.RuleRelationService;
import kd.epm.eb.business.bizrule.entity.GraphNode;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.dao.formula.DimMemberPojo;
import kd.epm.eb.common.dao.formula.FormulaMemberPojo;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.PeriodEnum;
import kd.epm.eb.common.enums.ruleFunctionEnums.RuleFunctionEnum;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.rule.ruleFunction.RuleFunction;
import kd.epm.eb.common.rule.ruleFunction.RuleFunctionUtils;
import kd.epm.eb.common.thread.EpmThreadPools;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.base.JsonUtils;
import kd.epm.eb.olap.impl.bizrule.RuleCacheService;
import kd.epm.eb.olap.impl.bizrule.RuleService;
import kd.epm.eb.olap.impl.bizrule.entity.RuleCacheContext;
import kd.epm.eb.olap.impl.bizrule.entity.RuleDto;
import kd.epm.eb.olap.impl.bizrule.entity.RuleTemplateInfo;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RuleGraphService {
    private static final Log log = LogFactory.getLog(RuleGraphService.class);

    public static RuleGraphService getInstance() {
        return InnerClass.instance;
    }

    private RuleGraphService() {
    }

    public void updateGraphByModel(long modelId) {
        this.updateGraphByModel(modelId, false);
    }

    public void updateGraphByModel(long modelId, boolean asyncTemplate) {
        List bizmodelIds = BusinessModelServiceHelper.getInstance().getBusModelIdsByModelId(Long.valueOf(modelId));
        if (CollectionUtils.isEmpty((Collection)bizmodelIds)) {
            return;
        }
        for (Long bizmodelId : bizmodelIds) {
            this.updateGraphByBizCtrlRange(bizmodelId, null, modelId);
            if (asyncTemplate) {
                EpmThreadPools.RULE_HANDLE_POOL.execute(() -> RuleRelationService.getInstance().reassignRuleToTemplateByBizctrlrange(bizmodelId, null, true));
                continue;
            }
            RuleRelationService.getInstance().reassignRuleToTemplateByBizctrlrange(bizmodelId, null, true);
        }
    }

    public void updateGraphByBizCtrlRange(long bizModelId, Set<Long> currRuleIds, Long modelId) {
        List allRules = RuleService.getInstance().listRule(Long.valueOf(bizModelId), Boolean.valueOf(true), null);
        if (allRules.isEmpty()) {
            log.info("\u67e5\u8be2\u4e0d\u5230\u89c4\u5219");
            return;
        }
        this.updateGraphByBizCtrlRange(bizModelId, allRules, currRuleIds, modelId);
    }

    public void updateGraphByBizCtrlRange(long bizModelId, List<RuleDto> allRules, Set<Long> currRuleIds, Long modelId) {
        List<GraphNode> nodes = this.getGraphNodes(bizModelId, allRules, currRuleIds, modelId);
        this.saveSuccessors(bizModelId, nodes);
    }

    public void saveSuccessors(long bizModelId, List<GraphNode> nodes) {
        ArrayList<Object[]> adjObjs = new ArrayList<Object[]>(10);
        for (GraphNode node : nodes) {
            Long ruleId = node.getNodeId();
            List successors = node.getSuccessors().stream().map(e -> e + "").collect(Collectors.toList());
            List offSuccessors = node.getOffsetSuccessors().stream().map(e -> e + "").collect(Collectors.toList());
            adjObjs.add(new Object[]{String.join((CharSequence)",", successors), String.join((CharSequence)",", offSuccessors), ruleId});
        }
        String sql = "update t_eb_bizruleset set fsuccessors=? , foffsetsuccessors=? where fid=?";
        DB.executeBatch((DBRoute)BgBaseConstant.epm, (String)sql, adjObjs);
        RuleCacheService.getInstance().clearCache(Long.valueOf(bizModelId));
    }

    public List<GraphNode> getGraphNodes(long bizModelId, List<RuleDto> allRules, Set<Long> currRuleIds, Long modelId) {
        List enableRules = allRules.stream().filter(RuleDto::getStatus).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(enableRules)) {
            log.info("enableRules \u4e3a\u7a7a");
            RuleCacheService.getInstance().clearCache(Long.valueOf(bizModelId));
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        List<RuleDto> copyRules = RuleRelationService.getInstance().rebuildRightMember(allRules, modelCache);
        AccountRelationTester accountRelationTester = this.filterRelationRule(copyRules, currRuleIds);
        List<RuleDto> enableCopyRules = copyRules.stream().filter(RuleDto::getStatus).collect(Collectors.toList());
        this.checkYearValueFun(enableCopyRules, modelCache);
        return this.buildAdjNodeList(enableCopyRules, modelCache, accountRelationTester);
    }

    public void checkYearValueFun(List<RuleDto> enableCopyRules, IModelCacheHelper modelCache) {
        HashSet<String> errorMsg = new HashSet<String>(16);
        for (RuleDto ruleDto : enableCopyRules) {
            if (!ruleDto.getFormulaString().contains("@YearValue")) continue;
            try {
                List ruleFunctions = ruleDto.getFunctions().stream().filter(x -> RuleFunctionEnum.YearValue.getName().equals(x.getFunctionName())).collect(Collectors.toList());
                for (RuleFunction ruleFunction : ruleFunctions) {
                    boolean anyMatch;
                    Map allVals = ruleFunction.getAllValues();
                    Object refMemKey = allVals.get("refMemKey");
                    if (refMemKey instanceof String) {
                        String refMemKeyStr = (String)refMemKey;
                        Map rightMembers = ruleDto.getRightMembers();
                        Map rightMembersMap = (Map)rightMembers.get(refMemKeyStr);
                        if (rightMembersMap != null && rightMembersMap.size() > 0) {
                            HashMap<String, Set> oriRightMembersMap = new HashMap<String, Set>(16);
                            oriRightMembersMap.putAll(rightMembersMap);
                            Map leftMembers = ruleDto.getLeftMembers();
                            Set memberNums = (Set)leftMembers.get(SysDimensionEnum.BudgetPeriod.getNumber());
                            if (CollectionUtils.isEmpty((Collection)memberNums)) {
                                memberNums = modelCache.getMembers(SysDimensionEnum.BudgetPeriod.getNumber(), 2).stream().filter(e -> e.getLevel() == 2).map(BaseCache::getNumber).collect(Collectors.toSet());
                            }
                            Set bpSet = RuleFunctionUtils.getYearValueBpNumberSet((IModelCacheHelper)modelCache, (Map)allVals, (Set)memberNums);
                            String metMemNum = (String)((Set)leftMembers.get(SysDimensionEnum.Metric.getNumber())).iterator().next();
                            Member metMember = modelCache.getMember(SysDimensionEnum.Metric.getNumber(), null, metMemNum);
                            if (metMember != null && metMember.hasAgg()) {
                                HashSet newSet = Sets.newHashSetWithExpectedSize((int)bpSet.size());
                                bpSet.forEach(e -> newSet.addAll(modelCache.getMember(SysDimensionEnum.BudgetPeriod.getNumber(), null, e, RangeEnum.ALL.getIndex()).stream().map(BaseCache::getNumber).collect(Collectors.toSet())));
                                oriRightMembersMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), newSet);
                            } else {
                                oriRightMembersMap.put(SysDimensionEnum.BudgetPeriod.getNumber(), bpSet);
                            }
                            ruleDto.getOriRightMembers().put(refMemKeyStr, oriRightMembersMap);
                        }
                    }
                    if (Integer.parseInt((String)allVals.get("yearoffset")) != 0) continue;
                    String account = (String)allVals.get("account");
                    FormulaMemberPojo accountMemberPojo = (FormulaMemberPojo)JsonUtils.readValue((String)account, FormulaMemberPojo.class);
                    List refDimMembers = accountMemberPojo.getRefDimMembers();
                    boolean isCircle = true;
                    for (DimMemberPojo dimMemberPojo : refDimMembers) {
                        Set members = (Set)ruleDto.getLeftMembers().get(dimMemberPojo.getDimNumber());
                        if (members == null || members.isEmpty() || members.contains(dimMemberPojo.getNumber())) continue;
                        isCircle = false;
                        break;
                    }
                    String specifiedperiod = (String)allVals.get("specifiedperiod");
                    PeriodEnum periodEnum = PeriodEnum.getEnumByKey((String)specifiedperiod);
                    Set periods = (Set)ruleDto.getLeftMembers().get(SysDimensionEnum.BudgetPeriod.getNumber());
                    if (periods == null) {
                        anyMatch = true;
                    } else {
                        switch (periodEnum) {
                            case Y: {
                                anyMatch = true;
                                break;
                            }
                            case HF1: {
                                anyMatch = periods.stream().anyMatch(x -> x.contains(PeriodEnum.M01.getKey()) || x.contains(PeriodEnum.M02.getKey()) || x.contains(PeriodEnum.M03.getKey()) || x.contains(PeriodEnum.M04.getKey()) || x.contains(PeriodEnum.M05.getKey()) || x.contains(PeriodEnum.M06.getKey()));
                                break;
                            }
                            case HF2: {
                                anyMatch = periods.stream().anyMatch(x -> x.contains(PeriodEnum.M07.getKey()) || x.contains(PeriodEnum.M08.getKey()) || x.contains(PeriodEnum.M09.getKey()) || x.contains(PeriodEnum.M10.getKey()) || x.contains(PeriodEnum.M11.getKey()) || x.contains(PeriodEnum.M12.getKey()));
                                break;
                            }
                            case Q1: {
                                anyMatch = periods.stream().anyMatch(x -> x.contains(PeriodEnum.M01.getKey()) || x.contains(PeriodEnum.M02.getKey()) || x.contains(PeriodEnum.M03.getKey()));
                                break;
                            }
                            case Q2: {
                                anyMatch = periods.stream().anyMatch(x -> x.contains(PeriodEnum.M04.getKey()) || x.contains(PeriodEnum.M05.getKey()) || x.contains(PeriodEnum.M06.getKey()));
                                break;
                            }
                            case Q3: {
                                anyMatch = periods.stream().anyMatch(x -> x.contains(PeriodEnum.M07.getKey()) || x.contains(PeriodEnum.M08.getKey()) || x.contains(PeriodEnum.M09.getKey()));
                                break;
                            }
                            case Q4: {
                                anyMatch = periods.stream().anyMatch(x -> x.contains(PeriodEnum.M10.getKey()) || x.contains(PeriodEnum.M11.getKey()) || x.contains(PeriodEnum.M12.getKey()));
                                break;
                            }
                            default: {
                                anyMatch = periods.stream().anyMatch(x -> x.contains(periodEnum.getKey()));
                            }
                        }
                    }
                    if (!anyMatch || !isCircle) continue;
                    throw new KDBizException(ResManager.loadResFormat((String)"\u89c4\u5219\u201c%1\u201d\u5b58\u5728\u5faa\u73af\u4f9d\u8d56\u3002", (String)"RuleGraphService_4", (String)"epm-eb-business", (Object[])new Object[]{ruleDto.getNumber()}));
                }
            }
            catch (KDBizException e2) {
                log.error("yearValue fun is error:", (Throwable)e2);
                errorMsg.add(e2.getMessage());
            }
            if (errorMsg.isEmpty()) continue;
            StringBuilder msgString = new StringBuilder();
            for (String msg : errorMsg) {
                msgString.append(msg);
            }
            throw new KDBizException(ResManager.loadResFormat((String)msgString.toString(), (String)"RuleGraphService_42", (String)"epm-eb-business", (Object[])new Object[0]));
        }
    }

    public Set<GraphNode> getZeroNodes(Graph<GraphNode> graph) {
        return graph.nodes().stream().filter(node -> graph.inDegree(node) == 0).collect(Collectors.toSet());
    }

    public MutableGraph<GraphNode> getSyncGraph(Collection<GraphNode> templateNodes, MutableGraph<GraphNode> graph, RuleTemplateInfo ruleTemplateInfo, List<RuleDto> allEnableRule, IModelCacheHelper modelCache) {
        if (CollectionUtils.isEmpty(templateNodes)) {
            return this.initEmptyGraph();
        }
        Graph transpose = Graphs.transpose(graph);
        log.info("\u53cd\u8f6c\u56fetransposeGraph:" + transpose);
        MutableGraph<GraphNode> subTransposeGraph = this.getSubGraphForStarNode(templateNodes, (Graph<GraphNode>)transpose, allEnableRule);
        HashSet filterNodes = Sets.newHashSet();
        if (ruleTemplateInfo != null && ruleTemplateInfo.getTemplateScope() != null) {
            List<String> dimNumbers = modelCache.getDimensionList().stream().map(BaseCache::getNumber).collect(Collectors.toList());
            Map<Long, RuleDto> ruleMap = allEnableRule.stream().collect(Collectors.toMap(RuleDto::getId, e -> e));
            Map templateScope = ruleTemplateInfo.getTemplateScope();
            MutableGraph tempGraph = Graphs.copyOf(subTransposeGraph);
            while (!tempGraph.nodes().isEmpty()) {
                Set<GraphNode> zeroNodes = this.getZeroNodes((Graph<GraphNode>)tempGraph);
                GraphNode zNode = zeroNodes.iterator().next();
                RuleDto nodeRule = ruleMap.get(zNode.getNodeId());
                boolean relate = RuleRelationService.getInstance().checkRelate(nodeRule.getLeftMembers(), templateScope, dimNumbers);
                if (relate) {
                    Set reachableNodes = Graphs.reachableNodes((Graph)tempGraph, (Object)zNode);
                    filterNodes.addAll(reachableNodes);
                    tempGraph.removeNode((Object)zNode);
                    reachableNodes.forEach(arg_0 -> ((MutableGraph)tempGraph).removeNode(arg_0));
                    continue;
                }
                tempGraph.removeNode((Object)zNode);
            }
        }
        MutableGraph<GraphNode> filterGraph = this.getSubGraphForStarNode(filterNodes, (Graph<GraphNode>)subTransposeGraph, allEnableRule);
        return Graphs.copyOf((Graph)Graphs.transpose(filterGraph));
    }

    public MutableGraph<GraphNode> initEmptyGraph() {
        return GraphBuilder.directed().allowsSelfLoops(false).build();
    }

    public MutableGraph<GraphNode> getSubGraphForStarNode(Collection<GraphNode> nodes, Graph<GraphNode> graph, List<RuleDto> rules) {
        Map<Long, RuleDto> ruleMap = rules.stream().collect(Collectors.toMap(RuleDto::getId, e -> e, (v1, v2) -> v1));
        HashMap offsetMap = Maps.newHashMap();
        for (RuleDto ruleDto : rules) {
            String[] stringArray = StringUtils.split((String)ruleDto.getOffSuccessors(), (String)",");
            if (stringArray.length <= 0) continue;
            offsetMap.put(ruleDto.getId(), Arrays.stream(stringArray).map(Long::parseLong).collect(Collectors.toSet()));
        }
        HashMap beOffsetMap = Maps.newHashMap();
        for (Map.Entry entry : offsetMap.entrySet()) {
            Long ruleId = (Long)entry.getKey();
            Set offsetRuleIds = (Set)entry.getValue();
            for (Long offId : offsetRuleIds) {
                Set beOffSets = beOffsetMap.computeIfAbsent(offId, v -> Sets.newHashSet());
                beOffSets.add(ruleId);
            }
        }
        HashSet<GraphNode> hashSet = new HashSet<GraphNode>(16);
        for (GraphNode node : nodes) {
            Set reachableNodes = Graphs.reachableNodes(graph, (Object)node);
            hashSet.addAll(reachableNodes);
            for (GraphNode reachableNode : reachableNodes) {
                RuleDto offRule;
                Set offsetRules = (Set)offsetMap.get(reachableNode.getNodeId());
                if (offsetRules != null) {
                    for (Long offsetRule : offsetRules) {
                        offRule = ruleMap.get(offsetRule);
                        if (offRule == null) continue;
                        hashSet.add(new GraphNode(offRule.getId(), offRule.getNumber()));
                    }
                }
                if ((offsetRules = (Set)beOffsetMap.get(reachableNode.getNodeId())) == null) continue;
                for (Long offsetRule : offsetRules) {
                    offRule = ruleMap.get(offsetRule);
                    if (offRule == null) continue;
                    hashSet.add(new GraphNode(offRule.getId(), offRule.getNumber()));
                }
            }
        }
        return Graphs.inducedSubgraph(graph, hashSet);
    }

    public MutableGraph<GraphNode> getDagGraphByBizmodel(long bizmodelId) {
        RuleCacheContext ruleCacheContext = RuleCacheService.getInstance().listRuleFromLocalCache(Long.valueOf(bizmodelId));
        if (CollectionUtils.isEmpty((Collection)ruleCacheContext.getRuleDtoList())) {
            return this.initEmptyGraph();
        }
        return this.getDagGraphByBizmodel(ruleCacheContext.getRuleDtoList());
    }

    public MutableGraph<GraphNode> getDagGraphByBizmodel(List<RuleDto> ruleDtos) {
        if (CollectionUtils.isEmpty(ruleDtos)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u89c4\u5219\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RuleGraphService_0", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        List<GraphNode> nodes = this.getAdjNodeList(ruleDtos);
        Long modelId = ruleDtos.get(0).getModelId();
        QFilter qFilter = new QFilter("modelid", "=", (Object)modelId);
        MutableGraph<GraphNode> graph = this.buildDagGraph(nodes);
        return graph;
    }

    public List<GraphNode> buildAdjNodeList(List<RuleDto> ruleDtos, IModelCacheHelper modelCache, AccountRelationTester accountRelationTester) {
        ConcurrentHashSet nodes = new ConcurrentHashSet();
        HashMap<Long, Map<String, Boolean>> ruleRightMemberNotLeafMap = new HashMap<Long, Map<String, Boolean>>(16);
        for (RuleDto ruleDto : ruleDtos) {
            LeafFeature leafFeature = ruleDto.getLeafFeature();
            if (leafFeature == LeafFeature.NOTLEAF || leafFeature == LeafFeature.ALL) continue;
            Map viewMap = ruleDto.getViewMap();
            ConcurrentHashMap<String, Boolean> rightMemberNotLeafMap = new ConcurrentHashMap<String, Boolean>(16);
            Map rightMembers = ruleDto.getRightMembers();
            Map oriRightMembers = ruleDto.getOriRightMembers();
            for (Map.Entry entry : rightMembers.entrySet()) {
                String memberKey = (String)entry.getKey();
                Map nextRightMember = (Map)entry.getValue();
                if (oriRightMembers.containsKey(memberKey)) {
                    nextRightMember = (Map)oriRightMembers.get(memberKey);
                }
                boolean isNotLeaf = false;
                for (Map.Entry setEntry : nextRightMember.entrySet()) {
                    String dimNumber = (String)setEntry.getKey();
                    Set members = (Set)setEntry.getValue();
                    List _members = modelCache.getMembers(dimNumber, viewMap.getOrDefault(dimNumber, 0L), (Collection)members);
                    for (Member member : _members) {
                        if (member.isLeaf()) continue;
                        isNotLeaf = true;
                        break;
                    }
                    if (!isNotLeaf) continue;
                    break;
                }
                rightMemberNotLeafMap.put(memberKey, isNotLeaf);
            }
            ruleRightMemberNotLeafMap.put(ruleDto.getId(), rightMemberNotLeafMap);
        }
        List<Object> modRules = ruleDtos;
        if (accountRelationTester.isInit() && CollectionUtils.isNotEmpty((Collection)accountRelationTester.getCurrentRule()) && accountRelationTester.getCurrentRule().size() < 20) {
            modRules = ruleDtos.stream().filter(e -> accountRelationTester.getCurrentRule().contains(e.getId())).collect(Collectors.toList());
            this.buildAdjNode(modRules, ruleDtos, modelCache, accountRelationTester, (ConcurrentHashSet<GraphNode>)nodes, ruleRightMemberNotLeafMap);
            this.buildAdjNode(ruleDtos, modRules, modelCache, accountRelationTester, (ConcurrentHashSet<GraphNode>)nodes, ruleRightMemberNotLeafMap);
        } else {
            this.buildAdjNode(modRules, ruleDtos, modelCache, accountRelationTester, (ConcurrentHashSet<GraphNode>)nodes, ruleRightMemberNotLeafMap);
        }
        this.resetOffsetSuccessor2Successor((Set<GraphNode>)nodes, ruleDtos, modelCache);
        return new ArrayList<GraphNode>((Collection<GraphNode>)nodes);
    }

    private void buildAdjNode(List<RuleDto> modRules, List<RuleDto> ruleDtos, IModelCacheHelper modelCache, AccountRelationTester accountRelationTester, ConcurrentHashSet<GraphNode> nodes, Map<Long, Map<String, Boolean>> ruleRightMemberNotLeafMap) {
        ConcurrentHashSet errorMsg = new ConcurrentHashSet(16);
        CountDownLatch latch = new CountDownLatch(modRules.size());
        String traceId = RequestContext.getOrCreate().getTraceId();
        List dimNumbers = modelCache.getDimensionList().stream().map(BaseCache::getNumber).collect(Collectors.toList());
        for (RuleDto preNode : modRules) {
            EpmThreadPools.RULE_HANDLE_POOL.execute(() -> {
                RequestContext.getOrCreate().setTraceId(traceId);
                GraphNode preGraphNode = new GraphNode(preNode.getId(), preNode.getNumber(), preNode.getName());
                try {
                    for (RuleDto nextNode : ruleDtos) {
                        int isSuccessor = RuleRelationService.getInstance().isRuleSuccessor(preNode, nextNode, dimNumbers, ruleRightMemberNotLeafMap);
                        if (isSuccessor == Integer.MAX_VALUE) continue;
                        if (isSuccessor == 0) {
                            if (!preNode.getId().equals(nextNode.getId())) {
                                preGraphNode.addSuccessor(nextNode.getId());
                                continue;
                            }
                            if (!RuleRelationService.getInstance().checkRuleRightMemberRelate(preNode, dimNumbers) && preNode.isSkipSelf()) continue;
                            throw new KDBizException(ResManager.loadResFormat((String)"\u89c4\u5219\u201c%1\u201d\u5b58\u5728\u5faa\u73af\u4f9d\u8d56\u3002", (String)"RuleGraphService_4", (String)"epm-eb-business", (Object[])new Object[]{preNode.getNumber()}));
                        }
                        preGraphNode.addOffsetSuccessor(nextNode.getId());
                    }
                    nodes.add((Object)preGraphNode);
                }
                catch (Exception e) {
                    log.error("\u4e1a\u52a1\u89c4\u5219\u5904\u7406\u540e\u7ee7\u51fa\u9519", (Throwable)e);
                    errorMsg.add((Object)(e.getMessage() + ""));
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u591a\u7ebf\u7a0b\u5904\u7406\u540e\u7ee7\u51fa\u9519\u3002", (String)"RuleGraphService_41", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        if (!errorMsg.isEmpty()) {
            StringBuilder msgString = new StringBuilder();
            for (String msg : errorMsg) {
                msgString.append(msg);
            }
            throw new KDBizException(ResManager.loadResFormat((String)msgString.toString(), (String)"RuleGraphService_42", (String)"epm-eb-business", (Object[])new Object[0]));
        }
    }

    private void delPredecessor(List<RuleDto> ruleDtos, Set<Long> currRules) {
        for (RuleDto r : ruleDtos) {
            String exclude;
            if (currRules.contains(r.getId())) {
                r.setSuccessors("");
                r.setOffSuccessors("");
                continue;
            }
            String[] split = StringUtils.split((String)r.getSuccessors(), (String)",");
            if (split.length > 0) {
                exclude = Arrays.stream(split).map(Long::parseLong).filter(e -> !currRules.contains(e)).map(String::valueOf).collect(Collectors.joining(","));
                r.setSuccessors(exclude);
            }
            if ((split = StringUtils.split((String)r.getOffSuccessors(), (String)",")).length <= 0) continue;
            exclude = Arrays.stream(split).map(Long::parseLong).filter(e -> !currRules.contains(e)).map(String::valueOf).collect(Collectors.joining(","));
            r.setSuccessors(exclude);
        }
    }

    private AccountRelationTester filterRelationRule(List<RuleDto> ruleList, Set<Long> currRules) {
        boolean partSwitch = ParamQueryServiceHelper.getBoolean((long)ruleList.get(0).getModelId(), (ParamEnum)ParamEnum.BG019);
        if (!partSwitch) {
            return new AccountRelationTester(false);
        }
        if (!CollectionUtils.isNotEmpty(currRules)) {
            return new AccountRelationTester(false);
        }
        AccountRelationTester accountRelationTester = new AccountRelationTester(true);
        this.delPredecessor(ruleList, currRules);
        accountRelationTester.setCurrentRule(new HashSet<Long>(currRules));
        return accountRelationTester;
    }

    private void resetOffsetSuccessor2Successor(Set<GraphNode> nodes, List<RuleDto> ruleDtos, IModelCacheHelper modelCache) {
        MutableGraph<GraphNode> graph = this.buildDagGraph(nodes);
        QFilter qFilter = new QFilter("modelid", "=", (Object)modelCache.getModelobj().getId());
        DynamicObject obj = QueryServiceHelper.queryOne((String)"eb_ruleparamconfig", (String)"cyclicswitch", (QFilter[])qFilter.toArray());
        boolean allowCycle = false;
        if (obj != null) {
            allowCycle = obj.getBoolean("cyclicswitch");
        }
        if (!allowCycle) {
            MutableGraph originExeGraph = Graphs.copyOf(graph);
            this.validCycle((MutableGraph<GraphNode>)originExeGraph);
        }
        for (GraphNode currNode : nodes) {
            Set offsetSuccessors = currNode.getOffsetSuccessors();
            if (CollectionUtils.isEmpty((Collection)offsetSuccessors)) continue;
            Iterator ite = offsetSuccessors.iterator();
            while (ite.hasNext()) {
                GraphNode offNode;
                Set reachNodes;
                Long offsetSuccessor = (Long)ite.next();
                if (offsetSuccessor.equals(currNode.getNodeId()) || (reachNodes = Graphs.reachableNodes(graph, (Object)(offNode = new GraphNode(offsetSuccessor)))).contains(currNode)) continue;
                currNode.getSuccessors().add(offsetSuccessor);
                if (!currNode.equals((Object)offNode)) {
                    graph.putEdge((Object)currNode, (Object)offNode);
                }
                ite.remove();
            }
        }
    }

    private List<GraphNode> getAdjNodeList(List<RuleDto> ruleDtos) {
        ArrayList<GraphNode> nodes = new ArrayList<GraphNode>(10);
        for (RuleDto currRule : ruleDtos) {
            GraphNode node = new GraphNode(currRule.getId(), currRule.getNumber(), currRule.getName());
            String successors = currRule.getSuccessors();
            if (StringUtils.isNotBlank((CharSequence)successors)) {
                for (String su : StringUtils.split((String)successors, (String)",")) {
                    node.addSuccessor(Long.valueOf(Long.parseLong(su)));
                }
            }
            nodes.add(node);
        }
        return nodes;
    }

    public MutableGraph<GraphNode> buildDagGraph(Collection<GraphNode> nodes) {
        MutableGraph<GraphNode> graph = this.initEmptyGraph();
        if (CollectionUtils.isEmpty(nodes)) {
            return graph;
        }
        Map<Long, GraphNode> ruleMap = nodes.stream().collect(Collectors.toMap(GraphNode::getNodeId, e -> e, (v1, v2) -> {
            throw new KDBizException(ResManager.loadKDString((String)"nodes\u8282\u70b9\u5217\u8868\u91cc\u9762\u6709\u91cd\u590d\u8282\u70b9\u3002", (String)"RuleGraphService_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }));
        for (GraphNode node : nodes) {
            if (!graph.nodes().contains(node)) {
                graph.addNode((Object)node);
            }
            for (Long successorRuleId : node.getSuccessors()) {
                GraphNode n1 = ruleMap.get(successorRuleId);
                if (n1 == null) {
                    log.warn("\u89c4\u5219\u540e\u7ee7\u8282\u70b9\u4e0d\u5b58\u5f02\u5e38\u3002\u8282\u70b9id:{}", (Object)successorRuleId);
                    continue;
                }
                if (node.getNodeId().equals(n1.getNodeId())) {
                    throw new KDBizException(ResManager.loadResFormat((String)"\u89c4\u5219\uff1a%s\u5b58\u5728\u81ea\u5faa\u73af\u3002", (String)"RuleGraphService_2", (String)"epm-eb-business", (Object[])new Object[]{n1.getNodeNumber()}));
                }
                graph.putEdge((Object)node, (Object)n1);
            }
        }
        MutableGraph originExeGraph = Graphs.copyOf(graph);
        log.info("graph\u521b\u5efa\u6210\u529f:" + originExeGraph);
        return originExeGraph;
    }

    public void validCycle(MutableGraph<GraphNode> graph) {
        if (!Graphs.hasCycle(graph)) {
            return;
        }
        for (GraphNode node : graph.nodes()) {
            Set reachNodes = Graphs.reachableNodes(graph, (Object)node);
            for (GraphNode reachNode : reachNodes) {
                Set subReachNodes;
                if (reachNode.equals((Object)node) || !(subReachNodes = Graphs.reachableNodes(graph, (Object)reachNode)).contains(node)) continue;
                ArrayList<GraphNode> pathList = new ArrayList<GraphNode>(10);
                this.getCyclePath(graph, node, node, pathList);
                String pathStr = pathList.stream().map(GraphNode::getNodeNumber).collect(Collectors.joining("->"));
                throw new KDBizException(ResManager.loadResFormat((String)"\u89c4\u5219\u201c%1\u201d\u5b58\u5728\u5faa\u73af\u4f9d\u8d56\u3002", (String)"RuleGraphService_4", (String)"epm-eb-business", (Object[])new Object[]{pathStr}));
            }
        }
    }

    public void getCyclePath(MutableGraph<GraphNode> graph, GraphNode originNode, GraphNode nextStartNode, List<GraphNode> pathList) {
        pathList.add(nextStartNode);
        Set successors = graph.successors((Object)nextStartNode);
        if (successors.contains(originNode)) {
            pathList.add(originNode);
            return;
        }
        for (GraphNode successor : successors) {
            Set reachNodes = Graphs.reachableNodes(graph, (Object)successor);
            if (!reachNodes.contains(originNode) || pathList.contains(successor)) continue;
            this.getCyclePath(graph, originNode, successor, pathList);
            break;
        }
    }

    public Map<GraphNode, Set<GraphNode>> getChildGraphNodesMap(MutableGraph<GraphNode> graph) {
        if (graph == null || graph.nodes().isEmpty()) {
            return Collections.emptyMap();
        }
        ArrayList<GraphNode> zeroNodeList = new ArrayList<GraphNode>(16);
        HashMap<GraphNode, Set> reachableNodesMap = new HashMap<GraphNode, Set>(16);
        Set<GraphNode> zeroNodes = RuleGraphService.getInstance().getZeroNodes((Graph<GraphNode>)graph);
        for (GraphNode zeroNode : zeroNodes) {
            Set reachableNodes = Graphs.reachableNodes(graph, (Object)zeroNode);
            reachableNodesMap.put(zeroNode, reachableNodes);
            zeroNodeList.add(zeroNode);
        }
        HashMap<GraphNode, Set<GraphNode>> resultNodesMap = new HashMap<GraphNode, Set<GraphNode>>(16);
        HashSet<GraphNode> hasIntersectionNodes = new HashSet<GraphNode>(16);
        for (int i = 0; i < zeroNodeList.size(); ++i) {
            GraphNode zeroNode = (GraphNode)zeroNodeList.get(i);
            if (hasIntersectionNodes.contains(zeroNode)) continue;
            Set graphNodes = (Set)reachableNodesMap.get(zeroNode);
            Set resultNodes = resultNodesMap.computeIfAbsent(zeroNode, k -> new HashSet(graphNodes));
            for (int j = 0; j < zeroNodeList.size(); ++j) {
                GraphNode _zeroNode = (GraphNode)zeroNodeList.get(j);
                if (_zeroNode.equals((Object)zeroNode) || hasIntersectionNodes.contains(_zeroNode)) continue;
                Set _graphNodes = (Set)resultNodesMap.getOrDefault(_zeroNode, (Set<GraphNode>)reachableNodesMap.get(_zeroNode));
                if (!resultNodes.stream().anyMatch(_graphNodes::contains)) continue;
                resultNodes.addAll(_graphNodes);
                hasIntersectionNodes.add(_zeroNode);
            }
        }
        return resultNodesMap;
    }

    private static class InnerClass {
        private static RuleGraphService instance = new RuleGraphService();

        private InnerClass() {
        }
    }
}

