/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.centralapproval;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.centralapproval.CentralAppBillService;
import kd.epm.eb.common.centralapproval.AppBillStatusEnum;
import kd.epm.eb.common.centralapproval.AppBillSubStatusEnum;
import kd.epm.eb.common.centralapproval.ApproveBill;
import kd.epm.eb.common.centralapproval.ApproveBillConfig;
import kd.epm.eb.common.centralapproval.ApproveBillEntry;
import kd.epm.eb.common.centralapproval.ApproveMutex;
import kd.epm.eb.common.utils.StringUtils;

public class ApproveBillUtil {
    private static final ApproveBillUtil instance = new ApproveBillUtil();

    public static ApproveBillUtil getInstance() {
        return instance;
    }

    public List<ApproveBill> getApproveBills(QFilter qFilter) {
        DynamicObject[] load;
        ArrayList<ApproveBill> approveBills = new ArrayList<ApproveBill>(16);
        List<Object> idList = CentralAppBillService.getInstance().getIdList(qFilter, "eb_centralappbill", null);
        if (idList.size() != 0 && (load = (DynamicObject[])BusinessDataServiceHelper.load((Object[])idList.toArray(), (IDataEntityType)ORM.create().getDataEntityType("eb_centralappbill"))) != null && load.length != 0) {
            for (DynamicObject dynamicObject : load) {
                approveBills.add(this.createApproveBill(dynamicObject));
            }
        }
        return approveBills;
    }

    public List<ApproveBill> getApproveBills(QFilter qFilter, String orderBy) {
        DynamicObject[] load;
        ArrayList<ApproveBill> approveBills = new ArrayList<ApproveBill>(16);
        List<Object> idList = CentralAppBillService.getInstance().getIdList(qFilter, "eb_centralappbill", orderBy);
        if (idList.size() != 0 && (load = (DynamicObject[])BusinessDataServiceHelper.load((Object[])idList.toArray(), (IDataEntityType)ORM.create().getDataEntityType("eb_centralappbill"))) != null && load.length != 0) {
            DynamicObject[] afterFilter;
            for (DynamicObject dynamicObject : afterFilter = ApproveBillUtil.orderBy(load, idList)) {
                approveBills.add(this.createApproveBill(dynamicObject));
            }
        }
        return approveBills;
    }

    private static DynamicObject[] orderBy(DynamicObject[] objs, List<Object> idList) {
        if (idList.size() > 1) {
            DynamicObject obj;
            HashMap<Object, DynamicObject> maps = new HashMap<Object, DynamicObject>(objs.length);
            DynamicObject[] dynamicObjectArray = objs;
            int n = dynamicObjectArray.length;
            for (int i = 0; i < n; ++i) {
                DynamicObject dynamicObject;
                obj = dynamicObject = dynamicObjectArray[i];
                maps.put(obj.getPkValue(), obj);
            }
            ArrayList<DynamicObject> listDyn = new ArrayList<DynamicObject>(objs.length);
            for (Object id : idList) {
                obj = (DynamicObject)maps.get(id);
                if (obj == null) continue;
                listDyn.add(obj);
            }
            return listDyn.toArray(new DynamicObject[0]);
        }
        return objs;
    }

    public ApproveBill getApproveBill(QFilter qFilter) {
        DynamicObject bill = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_centralappbill", (QFilter[])new QFilter[]{qFilter});
        return this.createApproveBill(bill);
    }

    public ApproveBill createApproveBill(DynamicObject cenAppBill) {
        if (cenAppBill == null) {
            return null;
        }
        ApproveBill approveBill = new ApproveBill(Long.valueOf(cenAppBill.getLong("id")), cenAppBill.getString("name"), cenAppBill.getString("billno"));
        approveBill.setModel(Long.valueOf(cenAppBill.getLong("model.id")));
        approveBill.setYear(Long.valueOf(cenAppBill.getLong("year.id")));
        approveBill.setVersion(Long.valueOf(cenAppBill.getLong("version.id")));
        approveBill.setDatatype(Long.valueOf(cenAppBill.getLong("datatype.id")));
        approveBill.setReportScheme(Long.valueOf(cenAppBill.getLong("reportscheme.id")));
        approveBill.setBizModelId(Long.valueOf(cenAppBill.getLong("reportscheme.bizrange_id")));
        approveBill.setReportEntity(Long.valueOf(cenAppBill.getLong("reportentity.id")));
        String centralAppPlan = cenAppBill.getString("centralappplan");
        HashSet<String> waitPlans = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((String)centralAppPlan)) {
            String[] split = centralAppPlan.trim().split(",");
            waitPlans.addAll(Arrays.asList(split));
        }
        approveBill.setCentralWaitPlan(waitPlans);
        String centralShowPlan = cenAppBill.getString("centralshowplan");
        if (StringUtils.isNotEmpty((String)centralShowPlan)) {
            Map plans = (Map)SerializationUtils.deSerializeFromBase64((String)centralShowPlan);
            approveBill.setCentralProcessPlan(plans);
        }
        approveBill.setCurNode(cenAppBill.getString("curnode"));
        approveBill.setBillStatus(AppBillStatusEnum.getStatusByNumber((String)cenAppBill.getString("billstatus")));
        approveBill.setCreator(Long.valueOf(cenAppBill.getLong("creater.id")));
        approveBill.setCreateDate(cenAppBill.getDate("createdate"));
        approveBill.setModifier(Long.valueOf(cenAppBill.getLong("modifier.id")));
        approveBill.setModifyDate(cenAppBill.getDate("modifydate"));
        approveBill.setAuditor(Long.valueOf(cenAppBill.getLong("auditor.id")));
        approveBill.setAuditDate(cenAppBill.getDate("auditdate"));
        approveBill.setBailadminorg(Long.valueOf(cenAppBill.getLong("bailadminorg.id")));
        approveBill.setParentId(Long.valueOf(cenAppBill.getLong("parentid")));
        approveBill.setMainbill(cenAppBill.getBoolean("ismainbill"));
        approveBill.setSubStatusEnum(AppBillSubStatusEnum.getStatusByNumber((String)cenAppBill.getString("itemstatus")));
        approveBill.setCentralorg(Long.valueOf(cenAppBill.getLong("centralorg.id")));
        approveBill.setSplitnode(cenAppBill.getString("splitnode"));
        String aconfig = cenAppBill.getString("approveconfig_tag");
        List approveconfigTag = new ArrayList();
        if (StringUtils.isNotEmpty((String)aconfig)) {
            approveconfigTag = SerializationUtils.fromJsonStringToList((String)cenAppBill.getString("approveconfig_tag"), ApproveBillConfig.class);
        }
        approveBill.setApproveconfig(approveconfigTag);
        DynamicObjectCollection apptypes = cenAppBill.getDynamicObjectCollection("approvetypes");
        HashSet<Long> appprovetypeIds = new HashSet<Long>(apptypes.size());
        for (DynamicObject apptype : apptypes) {
            appprovetypeIds.add(apptype.getLong("fbasedataId.id"));
        }
        approveBill.setApprovetypes(appprovetypeIds);
        approveBill.setHasSubitems(cenAppBill.getBoolean("ishassubitems"));
        DynamicObjectCollection centRalAppRptEntity = cenAppBill.getDynamicObjectCollection("centralapprptentity");
        approveBill.setApproveBillEntries(this.createApproveBillEntries(centRalAppRptEntity));
        return approveBill;
    }

    public List<ApproveBillEntry> createApproveBillEntries(DynamicObjectCollection centRalAppRptEntities) {
        ArrayList<ApproveBillEntry> entries = new ArrayList<ApproveBillEntry>(16);
        for (DynamicObject centRalAppRptEntity : centRalAppRptEntities) {
            ApproveBillEntry approveBillEntry = new ApproveBillEntry();
            approveBillEntry.setId(Long.valueOf(centRalAppRptEntity.getLong("id")));
            approveBillEntry.setReportBillNo(centRalAppRptEntity.getString("reportbillno"));
            approveBillEntry.setSumBillNo(centRalAppRptEntity.getString("sumbillno"));
            approveBillEntry.setTemplate(Long.valueOf(centRalAppRptEntity.getLong("template.id")));
            approveBillEntry.setReportType(centRalAppRptEntity.getString("reporttype"));
            approveBillEntry.setEntity(Long.valueOf(centRalAppRptEntity.getLong("entity.id")));
            approveBillEntry.setCentralEntity(Long.valueOf(centRalAppRptEntity.getLong("centralentity.id")));
            approveBillEntry.setReporter(Long.valueOf(centRalAppRptEntity.getLong("reporter.id")));
            approveBillEntry.setReportDate(centRalAppRptEntity.getDate("reportdate"));
            entries.add(approveBillEntry);
        }
        return entries;
    }

    private DynamicObject toDynamicObject(ApproveBill approveBill) {
        DynamicObject bill = null;
        try {
            bill = BusinessDataServiceHelper.loadSingle((Object)approveBill.getId(), (String)"eb_centralappbill");
        }
        catch (Exception e) {
            bill = BusinessDataServiceHelper.loadSingleFromCache((Object)approveBill.getId(), (String)"eb_centralappbill");
        }
        if (bill == null) {
            bill = BusinessDataServiceHelper.newDynamicObject((String)"eb_centralappbill");
            bill.set("id", (Object)approveBill.getId());
        }
        bill.set("name", (Object)approveBill.getName());
        bill.set("billno", (Object)approveBill.getBillNo());
        bill.set("model", (Object)approveBill.getModel());
        bill.set("year", (Object)approveBill.getYear());
        bill.set("version", (Object)approveBill.getVersion());
        bill.set("datatype", (Object)approveBill.getDatatype());
        bill.set("reportscheme", (Object)approveBill.getReportScheme());
        bill.set("reportentity", (Object)approveBill.getReportEntity());
        bill.set("centralappplan", (Object)String.join((CharSequence)",", approveBill.getCentralWaitPlan() == null ? new ArrayList(0) : approveBill.getCentralWaitPlan()));
        Map plans = approveBill.getCentralProcessPlan();
        String centralProcessPlan = SerializationUtils.serializeToBase64((Object)plans);
        bill.set("centralshowplan", (Object)centralProcessPlan);
        bill.set("curnode", (Object)approveBill.getCurNode());
        bill.set("billstatus", (Object)approveBill.getBillStatus().getNumber());
        bill.set("creater", (Object)approveBill.getCreator());
        bill.set("createdate", (Object)approveBill.getCreateDate());
        bill.set("modifier", (Object)approveBill.getModifier());
        bill.set("modifydate", (Object)approveBill.getModifyDate());
        bill.set("auditor", (Object)approveBill.getAuditor());
        bill.set("auditdate", (Object)approveBill.getAuditDate());
        bill.set("bailadminorg", (Object)approveBill.getBailadminorg());
        bill.set("parentid", (Object)approveBill.getParentId());
        bill.set("ismainbill", (Object)approveBill.isMainbill());
        bill.set("itemstatus", (Object)approveBill.getSubStatusEnum().getNumber());
        bill.set("centralorg", (Object)approveBill.getCentralorg());
        bill.set("ishassubitems", (Object)approveBill.isHasSubitems());
        bill.set("approveconfig_tag", (Object)SerializationUtils.toJsonString((Object)approveBill.getApproveconfig()));
        DynamicObjectCollection approvetypes = bill.getDynamicObjectCollection("approvetypes");
        Set atypte = approveBill.getApprovetypes();
        if (!atypte.isEmpty()) {
            Map approvetypeModels = BusinessDataServiceHelper.loadFromCache((Object[])atypte.toArray(), (String)"eb_approvaltypeentity");
            approvetypeModels.values().forEach(s -> {
                DynamicObject item = new DynamicObject(approvetypes.getDynamicObjectType());
                item.set("fbasedataId", s);
                approvetypes.add((Object)item);
            });
        }
        bill.set("approvetypes", (Object)approvetypes);
        bill.set("centralapprptentity", (Object)this.toEntryDynamicObjectCollection(approveBill.getApproveBillEntries(), bill));
        bill.set("splitnode", (Object)approveBill.getSplitnode());
        return bill;
    }

    public DynamicObject toNewDynamicObject2(ApproveBill approveBill) {
        DynamicObject bill = BusinessDataServiceHelper.newDynamicObject((String)"eb_centralappbill");
        bill.set("name", (Object)approveBill.getName());
        bill.set("billno", (Object)approveBill.getBillNo());
        bill.set("model", (Object)approveBill.getModel());
        bill.set("year", (Object)approveBill.getYear());
        bill.set("version", (Object)approveBill.getVersion());
        bill.set("datatype", (Object)approveBill.getDatatype());
        bill.set("reportscheme", (Object)approveBill.getReportScheme());
        bill.set("reportentity", (Object)approveBill.getReportEntity());
        bill.set("curnode", (Object)approveBill.getCurNode());
        bill.set("billstatus", (Object)approveBill.getBillStatus().getNumber());
        bill.set("creater", (Object)approveBill.getCreator());
        bill.set("createdate", (Object)approveBill.getCreateDate());
        bill.set("modifier", (Object)approveBill.getModifier());
        bill.set("modifydate", (Object)approveBill.getModifyDate());
        bill.set("auditor", (Object)approveBill.getAuditor());
        bill.set("auditdate", (Object)approveBill.getAuditDate());
        bill.set("bailadminorg", (Object)approveBill.getBailadminorg());
        bill.set("parentid", (Object)approveBill.getParentId());
        bill.set("ismainbill", (Object)approveBill.isMainbill());
        bill.set("itemstatus", (Object)approveBill.getSubStatusEnum().getNumber());
        bill.set("centralorg", (Object)approveBill.getCentralorg());
        bill.set("ishassubitems", (Object)approveBill.isHasSubitems());
        bill.set("approveconfig_tag", (Object)SerializationUtils.toJsonString((Object)approveBill.getApproveconfig()));
        DynamicObjectCollection approvetypes = bill.getDynamicObjectCollection("approvetypes");
        Set atypte = approveBill.getApprovetypes();
        if (!atypte.isEmpty()) {
            Map approvetypeModels = BusinessDataServiceHelper.loadFromCache((Object[])atypte.toArray(), (String)"eb_approvaltypeentity");
            approvetypeModels.values().forEach(s -> {
                DynamicObject item = new DynamicObject(approvetypes.getDynamicObjectType());
                item.set("fbasedataId", s);
                approvetypes.add((Object)item);
            });
        }
        bill.set("approvetypes", (Object)approvetypes);
        bill.set("centralapprptentity", (Object)this.toEntryDynamicObjectCollection(approveBill.getApproveBillEntries(), bill));
        bill.set("splitnode", (Object)approveBill.getSplitnode());
        return bill;
    }

    private DynamicObjectCollection toEntryDynamicObjectCollection(List<ApproveBillEntry> approveBillEntries, DynamicObject bill) {
        DynamicObjectCollection entryEntities = bill.getDynamicObjectCollection("centralapprptentity");
        for (ApproveBillEntry approveBillEntry : approveBillEntries) {
            Long id = approveBillEntry.getId();
            if (id != 0L) continue;
            DynamicObject row = entryEntities.addNew();
            row.set("reportbillno", (Object)approveBillEntry.getReportBillNo());
            row.set("sumbillno", (Object)approveBillEntry.getSumBillNo());
            row.set("reporttype", (Object)approveBillEntry.getReportType());
            row.set("template", (Object)approveBillEntry.getTemplate());
            row.set("entity", (Object)approveBillEntry.getEntity());
            row.set("centralentity", (Object)approveBillEntry.getCentralEntity());
            row.set("reporter", (Object)approveBillEntry.getReporter());
            row.set("reportdate", (Object)approveBillEntry.getReportDate());
        }
        return entryEntities;
    }

    private DynamicObject[] toDynamicObjects(Collection<ApproveBill> approveBills) {
        ArrayList bills = new ArrayList(16);
        approveBills.forEach(e -> bills.add(this.toDynamicObject((ApproveBill)e)));
        return bills.toArray(new DynamicObject[0]);
    }

    public void save(Collection<ApproveBill> approveBills) {
        DynamicObject[] dynamicObjects = this.toDynamicObjects(approveBills);
        Object[] result = SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        if (result == null || result.length == 0) {
            SaveServiceHelper.saveOperate((String)"eb_centralappbill", (DynamicObject[])dynamicObjects);
        }
    }

    public boolean isCollectAudit(ApproveBill bill) {
        List approveBillEntries = bill.getApproveBillEntries();
        for (ApproveBillEntry approveBillEntry : approveBillEntries) {
            String sumBillNo = approveBillEntry.getSumBillNo();
            if (!StringUtils.isNotEmpty((String)sumBillNo)) continue;
            return true;
        }
        return false;
    }

    public boolean isCollectAudit(List<ApproveBillEntry> approveBillEntries) {
        for (ApproveBillEntry approveBillEntry : approveBillEntries) {
            String sumBillNo = approveBillEntry.getSumBillNo();
            if (!StringUtils.isNotEmpty((String)sumBillNo)) continue;
            return true;
        }
        return false;
    }

    private List<ApproveMutex> getApproveMutexes(QFilter qFilter) {
        ArrayList<ApproveMutex> approveMutexes = new ArrayList<ApproveMutex>(16);
        List<Object> idList = CentralAppBillService.getInstance().getIdList(qFilter, "eb_centralappmutex", null);
        if (idList.size() == 0) {
            return approveMutexes;
        }
        DynamicObject[] mutexes = (DynamicObject[])BusinessDataServiceHelper.load((Object[])idList.toArray(), (IDataEntityType)ORM.create().getDataEntityType("eb_centralappmutex"));
        if (mutexes == null || mutexes.length == 0) {
            return approveMutexes;
        }
        for (DynamicObject mutex : mutexes) {
            approveMutexes.add(this.createApproveMutex(mutex));
        }
        return approveMutexes;
    }

    private ApproveMutex getApproveMutex(QFilter qFilter) {
        Object id = CentralAppBillService.getInstance().getIdSingle(qFilter, "eb_centralappmutex");
        if (id == null) {
            return null;
        }
        DynamicObject mutex = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_centralappmutex");
        if (mutex == null) {
            return null;
        }
        return this.createApproveMutex(mutex);
    }

    public List<ApproveMutex> getApproveMutexes(Long modelId) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        return this.getApproveMutexes(qFilter);
    }

    public ApproveMutex getApproveMutexes(String billNo, String nodeNumber, Long approverId, String uniqueKey) {
        QFilter qFilter = new QFilter("billno", "=", (Object)billNo);
        qFilter.and(new QFilter("nodenumber", "=", (Object)nodeNumber));
        qFilter.and(new QFilter("approver", "=", (Object)approverId));
        qFilter.and(new QFilter("uniquekey", "=", (Object)uniqueKey));
        return this.getApproveMutex(qFilter);
    }

    private ApproveMutex createApproveMutex(DynamicObject mutex) {
        if (mutex == null) {
            return null;
        }
        ApproveMutex approveMutex = new ApproveMutex();
        approveMutex.setBillNo(mutex.getString("billno"));
        approveMutex.setNodeNumber(mutex.getString("nodenumber"));
        approveMutex.setNodeName(mutex.getString("nodename"));
        String schemeJson = mutex.getString("schemes");
        Set schemes = (Set)SerializationUtils.fromJsonString((String)schemeJson, Set.class);
        approveMutex.setCentralSchemes(schemes);
        approveMutex.setModelId(Long.valueOf(mutex.getLong("model.id")));
        approveMutex.setApproverId(Long.valueOf(mutex.getLong("approver.id")));
        approveMutex.setCreateDate(mutex.getDate("createdate"));
        approveMutex.setUniqueKey(mutex.getString("uniquekey"));
        return approveMutex;
    }

    public void releaseMutex(String billNo, String nodeNumber, Long approverId, String uniqueKey) {
        QFilter qFilter = new QFilter("billno", "=", (Object)billNo);
        qFilter.and(new QFilter("nodenumber", "=", (Object)nodeNumber));
        qFilter.and(new QFilter("approver", "=", (Object)approverId));
        qFilter.and(new QFilter("uniquekey", "=", (Object)uniqueKey));
        DeleteServiceHelper.delete((String)"eb_centralappmutex", (QFilter[])new QFilter[]{qFilter});
    }
}

