/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataGather.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.BasedataEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.dataGather.entity.DataGatherGLMember;
import kd.epm.eb.business.dataGather.entity.DataGatherGLTypeRange;
import kd.epm.eb.business.dataGather.service.DataGatherCommon;
import kd.epm.eb.common.utils.StringUtils;

public class DataGatherGLAssInfoService {
    private static final Log log = LogFactory.getLog(DataGatherGLAssInfoService.class);

    public static DataGatherGLAssInfoService getInstance() {
        return InnerClass.instance;
    }

    private DataGatherGLAssInfoService() {
    }

    public Collection<DataGatherGLTypeRange> queryAssInfos(int sqlBatch, List<Long> assZuHeIds) {
        Collection<DataGatherGLTypeRange> assInfos = this.queryAssTypeIds("gl_assist_bd", assZuHeIds);
        Collection<DataGatherGLTypeRange> assInfos2 = this.queryAssTypeIds("gl_assist_txt", assZuHeIds);
        if (assInfos != null && assInfos2 != null && assInfos2.size() > 0) {
            assInfos.addAll(assInfos2);
        }
        DataGatherCommon.doLogWithTime((long)0L, (String)"queryAssInfos before query", (Log)log);
        this.queryAndSetAssValue(sqlBatch, assInfos);
        DataGatherCommon.doLogWithTime((long)0L, (String)"queryAssInfos after query", (Log)log);
        return assInfos;
    }

    private Collection<DataGatherGLTypeRange> queryAssTypeIds(String formId, List<Long> assZuHeIds) {
        String selectFields = "id,asstype,assval,hg ";
        QFilter qFilter = new QFilter("hg", "in", assZuHeIds);
        DataGatherCommon.doLogWithTime((long)0L, (String)("queryAssTypeIds.assZuHeIds.size():" + assZuHeIds.size()), (Log)log);
        Map dataRows = BusinessDataServiceHelper.loadFromCache((String)formId, (String)selectFields, (QFilter[])qFilter.toArray());
        if (dataRows == null || dataRows.size() == 0) {
            return null;
        }
        ArrayList<DataGatherGLTypeRange> returns = new ArrayList<DataGatherGLTypeRange>(DataGatherCommon.initSize);
        for (Map.Entry entry : dataRows.entrySet()) {
            DynamicObject dataRow = (DynamicObject)entry.getValue();
            if (dataRow == null) continue;
            DataGatherGLTypeRange typeRange = this.assemblyGLTypeRange(dataRow);
            ArrayList<DataGatherGLMember> subMembers = new ArrayList<DataGatherGLMember>(DataGatherCommon.initSize);
            DataGatherGLMember subMember = new DataGatherGLMember();
            subMember.setNumber(dataRow.getString("assval"));
            subMembers.add(subMember);
            typeRange.setSubMembers(subMembers);
            returns.add(typeRange);
        }
        return returns;
    }

    private DataGatherGLTypeRange assemblyGLTypeRange(DynamicObject dataRow) {
        DataGatherGLTypeRange typeRange = new DataGatherGLTypeRange();
        typeRange.setFlexField(dataRow.getString("asstype"));
        typeRange.setTypeId(Long.valueOf(dataRow.getLong("hg.id")));
        typeRange.setValueType(0);
        return typeRange;
    }

    private void queryAndSetAssValue(int sqlBatch, Collection<DataGatherGLTypeRange> assInfos) {
        if (assInfos == null || assInfos.size() == 0) {
            return;
        }
        Map<Object, DynamicObject> assTypeDataRows = this.getAssTypeAndSourceInfo(assInfos);
        if (assTypeDataRows == null || assTypeDataRows.size() == 0) {
            return;
        }
        HashMap<String, String> dimNumberMap = new HashMap<String, String>(16);
        for (Map.Entry<Object, DynamicObject> entry : assTypeDataRows.entrySet()) {
            DynamicObject assTypeDataRow = entry.getValue();
            if (assTypeDataRow == null) continue;
            String flexfield = assTypeDataRow.getString("flexfield");
            String number = assTypeDataRow.getString("number");
            dimNumberMap.put(flexfield, number);
            DataGatherCommon.doLogWithTime((long)0L, (String)("queryAndSetAssValue before switch:" + assTypeDataRow.getString("valuetype")), (Log)log);
            switch (assTypeDataRow.getString("valuetype")) {
                case "1": {
                    List<Long> assValueIds = this.getAssValueIdByFlexField(flexfield, assInfos);
                    if (assValueIds == null || assValueIds.size() == 0) break;
                    this.setAssValueInfo(flexfield, assInfos, assTypeDataRow, this.queryAssValueInfoByBase(sqlBatch, assValueIds, assTypeDataRow));
                    break;
                }
                case "2": {
                    List<Long> assValueIds = this.getAssValueIdByFlexField(flexfield, assInfos);
                    if (assValueIds == null || assValueIds.size() == 0) break;
                    this.setAssValueInfo(flexfield, assInfos, assTypeDataRow, this.queryAssValueInfoByAss(assValueIds, assTypeDataRow));
                    break;
                }
                case "3": {
                    this.setAssValueInfoBy3(flexfield, assInfos, assTypeDataRow);
                }
            }
        }
        assInfos.forEach(row -> row.setNumber((String)dimNumberMap.get(row.getFlexField())));
    }

    private Map<Object, DynamicObject> getAssTypeAndSourceInfo(Collection<DataGatherGLTypeRange> assInfos) {
        Set assTypeNumbers = assInfos.stream().map(assInfo -> assInfo.getFlexField()).collect(Collectors.toSet());
        DataGatherCommon.doLogWithTime((long)0L, (String)("getAssTypeAndSourceInfo.assTypeNumbers.size():" + assTypeNumbers.size()), (Log)log);
        String selectFields = "valuetype,flexfield,valuesource,assistanttype,number";
        QFilter qFilter = new QFilter("flexfield", "in", assTypeNumbers);
        DataGatherCommon.doLogWithTime((long)0L, (String)"getAssTypeAndSourceInfo before load", (Log)log);
        return BusinessDataServiceHelper.loadFromCache((String)"bd_asstacttype", (String)selectFields, (QFilter[])qFilter.toArray());
    }

    private void setValueInfo(DataGatherGLTypeRange assInfo, DataGatherGLMember subMember, DynamicObject assTypeDataRow, DynamicObject valueDataRow) {
        if (assTypeDataRow == null) {
            return;
        }
        DataGatherCommon.doLogWithTime((long)0L, (String)"setValueInfo part1", (Log)log);
        assInfo.setTypeName(assTypeDataRow.getString("valuesource.name"));
        assInfo.setTypeNumber(assTypeDataRow.getString("valuesource.number"));
        assInfo.setValueType(assTypeDataRow.getInt("valuetype"));
        DataGatherCommon.doLogWithTime((long)0L, (String)"setValueInfo part2", (Log)log);
        if ("3".equalsIgnoreCase(assTypeDataRow.getString("valuetype"))) {
            DataGatherCommon.doLogWithTime((long)0L, (String)"setValueInfo part3", (Log)log);
            subMember.setId(Long.valueOf(0L));
            subMember.setName(((DataGatherGLMember)assInfo.getSubMembers().iterator().next()).getNumber());
            subMember.setNumber(((DataGatherGLMember)assInfo.getSubMembers().iterator().next()).getNumber());
        } else {
            DataGatherCommon.doLogWithTime((long)0L, (String)"setValueInfo part4", (Log)log);
            assInfo.setTypeFormId(assTypeDataRow.getString("valuesource.number"));
            if (valueDataRow == null) {
                subMember.setId(Long.valueOf(0L));
                subMember.setName("");
                subMember.setNumber("");
            } else {
                String nameProp = "name";
                String numberProp = "number";
                IDataEntityType dataEntityType = valueDataRow.getDataEntityType();
                if (dataEntityType instanceof BasedataEntityType) {
                    BasedataEntityType entityType = (BasedataEntityType)dataEntityType;
                    if (!valueDataRow.containsProperty(numberProp) && StringUtils.isNotEmpty((String)entityType.getNumberProperty())) {
                        numberProp = entityType.getNumberProperty();
                    }
                    if (!valueDataRow.containsProperty(nameProp)) {
                        nameProp = numberProp;
                    }
                }
                subMember.setId(Long.valueOf(valueDataRow.getLong("id")));
                subMember.setName(valueDataRow.getString(nameProp));
                subMember.setNumber(valueDataRow.getString(numberProp));
            }
        }
        DataGatherCommon.doLogWithTime((long)0L, (String)"setValueInfo part5", (Log)log);
        if ("2".equalsIgnoreCase(String.valueOf(assInfo.getValueType())) && assTypeDataRow.getString("assistanttype") != null) {
            DataGatherCommon.doLogWithTime((long)0L, (String)"setValueInfo part6", (Log)log);
            assInfo.setTypeFormId("bd_asstacttype");
            assInfo.setTypeName(assTypeDataRow.getString("assistanttype.name"));
            assInfo.setTypeNumber(assTypeDataRow.getString("assistanttype.number"));
        }
        DataGatherCommon.doLogWithTime((long)0L, (String)"setValueInfo end", (Log)log);
    }

    private void setAssValueInfo(String flexfield, Collection<DataGatherGLTypeRange> assInfos, DynamicObject assTypeDataRow, Map<Object, DynamicObject> valueDataRows) {
        if (valueDataRows == null || valueDataRows.size() == 0) {
            return;
        }
        if (assInfos == null || assInfos.size() == 0) {
            return;
        }
        DataGatherCommon.doLogWithTime((long)0L, (String)("setAssValueInfo before" + flexfield), (Log)log);
        for (Map.Entry<Object, DynamicObject> entry : valueDataRows.entrySet()) {
            DynamicObject valueDataRow = entry.getValue();
            if (valueDataRow == null) continue;
            this.setAssValueInfoSingle(flexfield, assInfos, assTypeDataRow, valueDataRow);
        }
    }

    private void setAssValueInfoSingle(String flexfield, Collection<DataGatherGLTypeRange> assInfos, DynamicObject assTypeDataRow, DynamicObject valueDataRow) {
        for (DataGatherGLTypeRange assInfo : assInfos) {
            Collection subMembers;
            if (!flexfield.equalsIgnoreCase(assInfo.getFlexField()) || (subMembers = assInfo.getSubMembers()) == null || subMembers.size() == 0) continue;
            for (DataGatherGLMember subMember : subMembers) {
                if (!valueDataRow.getString("id").equalsIgnoreCase(subMember.getNumber()) && !valueDataRow.getString("id").equalsIgnoreCase(subMember.getId() == null ? "" : subMember.getId().toString())) continue;
                this.setValueInfo(assInfo, subMember, assTypeDataRow, valueDataRow);
            }
        }
    }

    private void setAssValueInfoBy3(String flexfield, Collection<DataGatherGLTypeRange> assInfos, DynamicObject assTypeDataRow) {
        for (DataGatherGLTypeRange assInfo : assInfos) {
            Collection subMembers;
            if (!flexfield.equalsIgnoreCase(assInfo.getFlexField()) || (subMembers = assInfo.getSubMembers()) == null || subMembers.size() == 0) continue;
            for (DataGatherGLMember subMember : subMembers) {
                this.setValueInfo(assInfo, subMember, assTypeDataRow, null);
            }
        }
    }

    private Map<Object, DynamicObject> doSqlBatch(String formId, String selectFields, String filterField, List<Long> ids, int sqlBatch) {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        DataGatherCommon.doLogWithTime((long)0L, (String)"doSqlBatch start", (Log)log);
        HashMap<Object, DynamicObject> returns = new HashMap<Object, DynamicObject>(ids.size());
        int fetchSize = sqlBatch == 0 ? DataGatherCommon.sqlBatch : sqlBatch;
        QFilter qFilter = null;
        for (int pos = 0; pos <= ids.size() && fetchSize > 0; pos += fetchSize) {
            if (fetchSize > ids.size() - pos) {
                fetchSize = ids.size() - pos;
            }
            if (fetchSize <= 0) continue;
            qFilter = new QFilter(filterField, "in", ids.subList(pos, pos + fetchSize));
            returns.putAll(this.getDataFromCache(formId, selectFields, filterField, qFilter));
        }
        DataGatherCommon.doLogWithTime((long)0L, (String)"doSqlBatch end", (Log)log);
        return returns;
    }

    private Map<Object, DynamicObject> getDataFromCache(String formId, String selectFields, String filterField, QFilter subQFilter) {
        return BusinessDataServiceHelper.loadFromCache((String)formId, (String)selectFields, (QFilter[])subQFilter.toArray());
    }

    private Map<Object, DynamicObject> queryAssValueInfoByBase(int sqlBatch, List<Long> assValueIds, DynamicObject assTypeDataRow) {
        if (assValueIds == null || assValueIds.size() == 0) {
            return null;
        }
        DataGatherCommon.doLogWithTime((long)0L, (String)"queryAssValueInfoByBase:before", (Log)log);
        String formId = assTypeDataRow.getString("valuesource.number");
        String selectFields = "id,number, number as name ";
        DataGatherCommon.doLogWithTime((long)0L, (String)("queryAssValueInfoByBase:assValueIds.size:" + assValueIds.size() + "_FromId: " + formId), (Log)log);
        return this.doSqlBatch(formId, selectFields, "id", assValueIds, sqlBatch);
    }

    private Map<Object, DynamicObject> queryAssValueInfoByAss(List<Long> assValueIds, DynamicObject assTypeDataRow) {
        if (assValueIds == null || assValueIds.size() == 0) {
            return null;
        }
        if (assTypeDataRow.getString("assistanttype") == null) {
            return null;
        }
        String selectFields = "id,number,name ";
        QFilter qFilter = new QFilter("number", "=", (Object)assTypeDataRow.getString("assistanttype.number"));
        DynamicObject groupDy = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_assistantdatagroup", (String)selectFields, (QFilter[])qFilter.toArray());
        if (groupDy == null) {
            return null;
        }
        qFilter = new QFilter("group.id", "=", (Object)groupDy.getLong("id"));
        return BusinessDataServiceHelper.loadFromCache((String)"bos_assistantdata_detail", (String)selectFields, (QFilter[])qFilter.toArray());
    }

    private List<Long> getAssValueIdByFlexField(String flexfield, Collection<DataGatherGLTypeRange> assInfos) {
        if (assInfos == null || assInfos.size() == 0) {
            return null;
        }
        HashSet returns = new HashSet(DataGatherCommon.initSize);
        for (DataGatherGLTypeRange assInfo : assInfos) {
            if (!flexfield.equalsIgnoreCase(assInfo.getFlexField())) continue;
            returns.addAll(assInfo.getSubMembers().stream().map(subMember -> Long.parseLong(subMember.getNumber())).collect(Collectors.toSet()));
        }
        DataGatherCommon.doLogWithTime((long)0L, (String)"getAssValueIdByFlexField", (Log)log);
        return new ArrayList<Long>(returns);
    }

    private static class InnerClass {
        private static DataGatherGLAssInfoService instance = new DataGatherGLAssInfoService();

        private InnerClass() {
        }
    }
}

