/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.dataintegration.service.handler;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.business.dataintegration.entity.AbstractDataIntegration;
import kd.epm.eb.business.dataintegration.entity.DataIntegration;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationDimMap;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationMetricMap;
import kd.epm.eb.business.dataintegration.entity.DataIntegrationQuery;
import kd.epm.eb.business.dataintegration.entity.context.EasIntegrationCusContext;
import kd.epm.eb.business.dataintegration.entity.context.IntegrationContext;
import kd.epm.eb.business.dataintegration.entity.context.IntegrationCusContext;
import kd.epm.eb.business.dataintegration.service.DataIntegrationDataService;
import kd.epm.eb.business.dataintegration.service.handler.DataInIntegrationHandler;
import kd.epm.eb.business.easupgrade.utils.EASDataIntegrationUtil;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.olap.api.metadata.IKDCell;
import org.apache.commons.lang3.StringUtils;

public class CusDataIntegrationHandler
extends DataInIntegrationHandler {
    private static final int pageSize = 50000;
    private List<String> columnNames;
    private String sqlStr;
    private List<String> dimSources = new ArrayList<String>(10);
    private Map<String, Map<String, String>> idNumberMapFromEas = new HashMap<String, Map<String, String>>(16);

    public IntegrationCusContext init(IntegrationContext globalContext) {
        IntegrationCusContext cusContext = super.init(globalContext);
        DataIntegration dataIntegration = this.getEasDataIntegration();
        this.buildColAndSqlInfo(dataIntegration);
        this.loadIdNumMap4Eas(dataIntegration);
        EasIntegrationCusContext easCusContext = new EasIntegrationCusContext(cusContext);
        List<DataIntegrationMetricMap> metMapList = this.getMetMapList();
        if (metMapList.size() > 0) {
            easCusContext.setSourceDataCountDiv(metMapList.size());
        }
        easCusContext.setSynCount(globalContext.getTotalDataCount());
        easCusContext.setCalculateSynCount(false);
        return easCusContext;
    }

    public Map<String, Long> getSchemeDimviewMap(AbstractDataIntegration dataIntegration, List<DataIntegrationQuery> filters) {
        HashMap resultMap = this.getCommonView(dataIntegration, filters);
        DynamicObject object = dataIntegration.getObject();
        DynamicObjectCollection dimmapentity = object.getDynamicObjectCollection("dimmapentity");
        if (CollectionUtils.isNotEmpty((Collection)dimmapentity)) {
            for (DynamicObject dynamicObject : dimmapentity) {
                DynamicObject viewObj = dynamicObject.getDynamicObject("dimmemberview");
                if (viewObj == null) continue;
                String dimmembnum = dynamicObject.getString("dimtarget");
                resultMap.put(dimmembnum, viewObj.getLong("id"));
            }
        }
        return resultMap;
    }

    private void loadIdNumMap4Eas(DataIntegration dataIntegration) {
        DynamicObject integrationObj = dataIntegration.getObject();
        long easDBId = integrationObj.getLong("easdb_id");
        if (IDUtils.isNotNull((long)easDBId)) {
            List firstMemberMap = dataIntegration.getFirstDimMap();
            this.dimSources = EASDataIntegrationUtil.getDimSources((Iterable)firstMemberMap, DataIntegrationDimMap::getDimsource);
            this.idNumberMapFromEas = EASDataIntegrationUtil.getIdNumberMapFromEas(this.dimSources, (long)easDBId);
        }
    }

    private void buildColAndSqlInfo(DataIntegration dataIntegration) {
        String tableName = dataIntegration.getTableName();
        this.columnNames = DB.getColumnNames((DBRoute)DBRoute.of((String)"epm"), (String)tableName);
        String primaryKey = this.getPrimaryKey(dataIntegration.getTargetobjId());
        String field = String.join((CharSequence)",", this.columnNames);
        String orderField = StringUtils.isBlank((CharSequence)primaryKey) ? this.columnNames.get(0) : primaryKey;
        StringBuilder sql = new StringBuilder();
        sql.append("select top ").append(50000).append(",").append("%s").append(" ").append(field).append(" from ").append(tableName).append(" order by ").append(orderField).append(" ASC");
        this.sqlStr = sql.toString();
    }

    public boolean readData(IntegrationContext globalContext, IntegrationCusContext cusContext) {
        EasIntegrationCusContext easCusContext = this.getEasCusContext(cusContext);
        int offset = easCusContext.getDataRowOffset();
        String sql = String.format(this.sqlStr, offset);
        List mapList = (List)DB.query((DBRoute)DBRoute.of((String)"epm"), (String)sql, rs -> {
            ArrayList<HashMap> dataList = new ArrayList<HashMap>(10);
            while (rs.next()) {
                HashMap row = Maps.newHashMapWithExpectedSize((int)30);
                for (String column : this.columnNames) {
                    row.put(column, rs.getString(column));
                }
                dataList.add(row);
            }
            return dataList;
        });
        cusContext.setSourceRowData(mapList);
        boolean isEnd = false;
        if (mapList.isEmpty() || mapList.size() > 50000) {
            isEnd = true;
        } else {
            easCusContext.setDataRowOffset(offset + 50000);
        }
        return isEnd;
    }

    public void convertData(IntegrationContext globalContext, IntegrationCusContext cusContext) {
        EasIntegrationCusContext easCusContext = this.getEasCusContext(cusContext);
        List sourceRowData = easCusContext.getSourceRowData();
        EASDataIntegrationUtil.convertEasData((List)sourceRowData, this.dimSources, this.idNumberMapFromEas);
        List cellData = this.coverToEbData(globalContext, cusContext);
        cusContext.setTargetRowData(cellData);
    }

    protected void selToKdCell(List<IKDCell> kdCells, String[] dimMemberNums, Object row, int metricIndex, Dimension metricDim, IntegrationCusContext cusContext) {
        Map rowData = (Map)row;
        List cells = DataIntegrationDataService.getInstance().metricMapper(this.getEasDataIntegration(), metricIndex, rowData, dimMemberNums, metricDim);
        kdCells.addAll(cells);
    }

    private String getPrimaryKey(Long tarObjId) {
        DynamicObject tarObj = BusinessDataServiceHelper.loadSingle((Object)tarObjId, (String)"isc_metadata_schema");
        if (tarObj != null) {
            DynamicObjectCollection properties = tarObj.getDynamicObjectCollection("prop_entryentity");
            for (DynamicObject prop : properties) {
                boolean isPrimaryKey = prop.getBoolean("is_primary_key");
                if (!isPrimaryKey) continue;
                return prop.getString("prop_name");
            }
        }
        return "";
    }

    public List<DataIntegrationMetricMap> getMetMapList() {
        return this.getEasDataIntegration().getMetMapList();
    }

    private DataIntegration getEasDataIntegration() {
        return (DataIntegration)this.getDataIntegration();
    }

    private EasIntegrationCusContext getEasCusContext(IntegrationCusContext context) {
        return (EasIntegrationCusContext)context;
    }

    protected Pair<String, String> getFieldValue(Object row, IntegrationCusContext param, String fieldStr) {
        if (row != null) {
            String[] fieldArr;
            Map rowData = (Map)row;
            for (String field : fieldArr = StringUtils.split((String)fieldStr, (String)",")) {
                String _field = "f" + field;
                String value = (String)rowData.get(_field);
                if (StringUtils.isBlank((CharSequence)value)) {
                    value = (String)rowData.get(_field = _field.toLowerCase());
                    String string = value = StringUtils.isNotBlank((CharSequence)value) ? value : (String)rowData.get(StringUtils.upperCase((String)_field));
                }
                if (StringUtils.isBlank((CharSequence)value)) continue;
                return new Pair((Object)field, (Object)value);
            }
        }
        return null;
    }

    public void selDataToLog(String logKey, Map<String, Object> logData) {
        super.selDataToLog(logKey, logData);
        logData.put("columnNames", this.columnNames);
        logData.put("sqlStr", this.sqlStr);
        logData.put("dimSources", this.dimSources);
        logData.put("idNumberMapFromEas_size", this.idNumberMapFromEas == null ? 0 : this.idNumberMapFromEas.size());
    }
}

