/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.formula;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.business.formula.AcctFormulaParser;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.formula.BudFormulaConfig;
import kd.epm.eb.common.formula.FormulaParam;
import kd.epm.eb.common.formula.FormulaResult;
import kd.epm.eb.common.olapdao.BgmdOlapReader;
import kd.epm.eb.common.olapdao.OlapReadOption;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.permission.membPerm.DimMemberPermChecker;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.pojo.BasedataPojo;
import kd.epm.eb.common.pojo.DimViewMember;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.LogHelper;
import kd.epm.eb.common.utils.LogSignHelper;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.olap.service.OlapManager;
import kd.epm.eb.olap.service.request.QueryRequest;

public class AcctFormulaExecutor {
    private static final Log log = LogFactory.getLog(AcctFormulaExecutor.class);

    public static Map<String, FormulaResult> executeBatch(Map<String, List<String>> formulaConfigs, FormulaParam formulaParam) {
        if ("VBud".equalsIgnoreCase(formulaParam.getType())) {
            return AcctFormulaExecutor.executeBud(formulaConfigs, formulaParam);
        }
        return new HashMap<String, FormulaResult>(16);
    }

    public static Map<String, FormulaResult> executeBud(Map<String, List<String>> formulaConfigs, FormulaParam formulaParam) {
        HashMap<String, FormulaResult> result = new HashMap<String, FormulaResult>(formulaConfigs.size());
        HashMap<Long, Map<String, Set<String>>> dimMembersOnDataSet = new HashMap<Long, Map<String, Set<String>>>(16);
        HashMap<Long, IModelCacheHelper> modelCacheHelperMap = new HashMap<Long, IModelCacheHelper>(16);
        HashMap<Long, Long> datasetMapModelId = new HashMap<Long, Long>(16);
        HashMap<Long, List<Dimension>> dimLists = new HashMap<Long, List<Dimension>>(16);
        HashMap<Long, Boolean> orgCheckStatus = new HashMap<Long, Boolean>(16);
        HashMap<Long, Map<String, List<String>>> formulaInfoOnDataset = new HashMap<Long, Map<String, List<String>>>(16);
        LogHelper logHelper = new LogHelper("execAcctFormula", log);
        logHelper.addInfoLog(String.format("formulaSize:%s,commonParam:%s", formulaConfigs.size(), SerializationUtils.toJsonString((Object)formulaParam)));
        block0: for (Map.Entry<String, List<String>> entry : formulaConfigs.entrySet()) {
            String formulaId = entry.getKey();
            BudFormulaConfig formulaConfig = AcctFormulaExecutor.parse2Config(formulaId, entry.getValue(), formulaParam.getType(), result);
            if (formulaConfig == null) continue;
            Long datasetId = formulaConfig.getDataset().getId();
            Long modelId = formulaConfig.getModel().getId();
            IModelCacheHelper modelCacheHelper = modelCacheHelperMap.computeIfAbsent(modelId, ModelCacheContext::getOrCreate);
            Map defaultViews = modelCacheHelper.getViewsByDataSet(datasetId);
            datasetMapModelId.put(datasetId, modelId);
            List dimList = dimLists.computeIfAbsent(datasetId, arg_0 -> ((IModelCacheHelper)modelCacheHelper).getDimensionList(arg_0));
            Map dimMembers = formulaConfig.getDimMembers();
            HashMap<String, String> dimMemberNums = new HashMap<String, String>(dimList.size());
            StringBuilder membNumsB = new StringBuilder();
            for (Dimension dim : dimList) {
                DimViewMember membInfo = (DimViewMember)dimMembers.get(dim.getNumber());
                String dimNum2 = dim.getNumber();
                if (membInfo == null) {
                    if (SysDimensionEnum.Entity.getNumber().equals(dimNum2) && AcctFormulaExecutor.checkMemberExist(orgCheckStatus, modelCacheHelper, defaultViews, dimNum2, formulaParam.getOrgNum())) {
                        membInfo = new DimViewMember(Long.valueOf(0L), null, formulaParam.getOrgNum());
                    } else if (SysDimensionEnum.BudgetPeriod.getNumber().equals(dimNum2)) {
                        BasedataPojo periodMember = (BasedataPojo)dimMembers.get(SysDimensionEnum.Period.getNumber());
                        BasedataPojo yearMember = (BasedataPojo)dimMembers.get(SysDimensionEnum.Year.getNumber());
                        String bgPeriodNumber = null;
                        bgPeriodNumber = periodMember == null && yearMember == null ? formulaParam.getPeriodNum() : (periodMember != null && yearMember == null ? formulaParam.getYearStr() + "." + periodMember.getNumber() : (periodMember == null ? yearMember.getNumber() + "." + formulaParam.getPeriodStr() : yearMember.getNumber() + "." + periodMember.getNumber()));
                        if (dim.getMemberByNoView(bgPeriodNumber) != null) {
                            membInfo = new DimViewMember(Long.valueOf(0L), null, bgPeriodNumber);
                        }
                    } else if (!dim.isPreset()) {
                        membInfo = new DimViewMember(Long.valueOf(0L), null, dim.getNoneNumber());
                    }
                    if (membInfo != null) {
                        dimMembers.put(dimNum2, membInfo);
                    }
                }
                if (membInfo == null || "@".equals(membInfo.getNumber())) {
                    result.put(formulaId, FormulaResult.newErrorResult((String)ResManager.loadResFormat((String)"\u7ef4\u5ea6%1\u7684\u6210\u5458\u4e0d\u5b58\u5728", (String)"AcctFormulaExecutor_1", (String)"epm-eb-business", (Object[])new Object[]{dimNum2})));
                    continue block0;
                }
                membNumsB.append(membInfo.getNumber()).append(',');
                dimMemberNums.put(dimNum2, membInfo.getNumber());
            }
            Map allDimMembNums = dimMembersOnDataSet.computeIfAbsent(datasetId, key -> new HashMap(16));
            dimMemberNums.forEach((dimNum, memb) -> allDimMembNums.computeIfAbsent(dimNum, key -> new HashSet(16)).add(memb));
            Map memberNumStrs = formulaInfoOnDataset.computeIfAbsent(datasetId, key -> new HashMap(16));
            List keys = memberNumStrs.computeIfAbsent(membNumsB.toString(), key -> new LinkedList());
            keys.add(formulaId);
        }
        formulaConfigs.clear();
        if (LogSignHelper.needLog((String)"AcctFormulaExecutor", (String)"dimMembersOnDataSet")) {
            CommonServiceHelper.handleLog((Log)log, (String)"AcctFormulaExecutor-dimMembers", (String)SerializationUtils.toJsonString(dimMembersOnDataSet));
        }
        if (LogSignHelper.needLog((String)"AcctFormulaExecutor", (String)"formulaInfoOnDataset")) {
            CommonServiceHelper.handleLog((Log)log, (String)"AcctFormulaExecutor-formulaInfo", (String)SerializationUtils.toJsonString(formulaInfoOnDataset));
        }
        logHelper.addInfoLog("parseConfigEnd");
        AcctFormulaExecutor.queryData(result, dimMembersOnDataSet, formulaInfoOnDataset, datasetMapModelId, dimLists);
        logHelper.addInfoLog("queryDataEnd,resultSize:" + result.size());
        return result;
    }

    private static BudFormulaConfig parse2Config(String formulaId, List<String> formulaParams, String type, Map<String, FormulaResult> resultMap) {
        BudFormulaConfig formulaConfig = null;
        try {
            formulaConfig = (BudFormulaConfig)AcctFormulaParser.parser((String)type, formulaParams);
        }
        catch (Exception e) {
            FormulaResult errorResult;
            if (e instanceof KDBizException) {
                errorResult = FormulaResult.newErrorResult((String)e.getMessage());
            } else {
                log.error(String.format("AcctFormulaParserError:%s", SerializationUtils.toJsonString(formulaParams)), (Throwable)e);
                errorResult = FormulaResult.newErrorResult((String)ResManager.loadKDString((String)"\u516c\u5f0f\u89e3\u6790\u51fa\u9519", (String)"AcctFormulaExecutor_2", (String)"epm-eb-business", (Object[])new Object[0]));
            }
            resultMap.put(formulaId, errorResult);
        }
        return formulaConfig;
    }

    private static void queryData(Map<String, FormulaResult> formulaResultMap, Map<Long, Map<String, Set<String>>> allDimMembNums, Map<Long, Map<String, List<String>>> formulaInfoOnDataset, Map<Long, Long> datasetModelMap, Map<Long, List<Dimension>> dimLists) {
        Long userId = UserUtils.getUserId();
        allDimMembNums.forEach((datasetId, dimMembNums) -> {
            Map formulaInfo = (Map)formulaInfoOnDataset.get(datasetId);
            if (formulaInfo != null) {
                Long modelId = (Long)datasetModelMap.get(datasetId);
                List dimensionList = (List)dimLists.get(datasetId);
                DimMemberPermChecker permChecker = CommonUtils.checkVBudDataPerm((Long)modelId, (boolean)false) ? DimMembPermHelper.getPermChecker((Long)modelId, (Long)datasetId, (Long)userId, (DimMembPermType)DimMembPermType.READ) : null;
                int metricDimIndex = 1;
                Dimension metricDim = null;
                for (Dimension dim : dimensionList) {
                    if (dim.getNumber().equals(SysDimensionEnum.Metric.getNumber())) {
                        metricDim = dim;
                        break;
                    }
                    ++metricDimIndex;
                }
                HashMap metricTypeMap = metricDim == null ? new HashMap(16) : metricDim.getAllMembers().stream().filter(member -> member.getDatatype() != null).collect(Collectors.toMap(BaseCache::getNumber, Member::getDatatype));
                boolean checkVBudDataPerm = permChecker != null && !permChecker.hasAllPerm();
                try (BgmdOlapReader olapReader = OlapManager.getInstance().queryReader(new QueryRequest((Long)datasetModelMap.get(datasetId), datasetId, dimMembNums), new OlapReadOption());){
                    StringBuilder membNums = new StringBuilder();
                    HashMap<String, MemberItem> memberGroup = new HashMap<String, MemberItem>(dimensionList.size());
                    while (olapReader.hasNext()) {
                        membNums.setLength(0);
                        Object[] next = olapReader.next();
                        Object val = next[0];
                        for (int i = 1; i < next.length; ++i) {
                            membNums.append(next[i]).append(',');
                            if (!checkVBudDataPerm) continue;
                            Dimension dimension = (Dimension)dimensionList.get(i - 1);
                            MemberItem item = new MemberItem(true, Long.valueOf(0L), (String)next[i]);
                            item.setNumberFirst(true);
                            memberGroup.put(dimension.getNumber(), item);
                        }
                        String numberStr = membNums.toString();
                        List formulaIds = (List)formulaInfo.remove(numberStr);
                        if (formulaIds == null) continue;
                        String metricNumber = (String)next[metricDimIndex];
                        String memberType = (String)metricTypeMap.get(metricNumber);
                        if (MetricDataTypeEnum.isDate((String)memberType)) {
                            val = ConvertUtils.from((String)((String)val));
                        }
                        FormulaResult result = new FormulaResult(val);
                        if (checkVBudDataPerm && !permChecker.check(memberGroup)) {
                            result.setNoPermError(numberStr);
                        }
                        formulaIds.forEach(key -> formulaResultMap.put((String)key, result));
                    }
                }
            }
        });
    }

    private static boolean checkMemberExist(Map<Long, Boolean> checkStatus, IModelCacheHelper modelCacheHelper, Map<String, Long> defaultViews, String dimNum, String memberNum) {
        Long modelId = modelCacheHelper.getModelobj().getId();
        return checkStatus.computeIfAbsent(modelId, mId -> {
            Member member = modelCacheHelper.getMember(dimNum, (Long)defaultViews.get(dimNum), memberNum);
            return member != null;
        });
    }
}

