/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.quote;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.business.quote.CheckQuote;
import kd.epm.eb.business.quote.QuoteBaseCheck;
import kd.epm.eb.business.quote.QuoteCheck;
import kd.epm.eb.business.quote.QuoteCheckResult;
import kd.epm.eb.business.quote.QuoteDelete;
import kd.epm.eb.business.quote.QuoteRegDataCheck;
import kd.epm.eb.business.quote.QuoteSave;
import kd.epm.eb.business.quote.QuoteShrekDataCheck;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.dao.memberQuote.MemberQuoteDao;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.memberQuote.MemberTypeEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.JSONUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.common.utils.period.PeriodLeadUtils;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import org.jetbrains.annotations.NotNull;

public class MemberQuote {
    private static final Log log = LogFactory.getLog(MemberQuote.class);

    public static MemberQuote get() {
        return new MemberQuote();
    }

    public void save(List<MemberQuoteDao> quotes) {
        QuoteSave.get().save(quotes);
    }

    public Set<Long> checkQuote(@NotNull CheckQuote checkQuote) {
        HashSet result = Sets.newHashSetWithExpectedSize((int)checkQuote.getMemberIds().size());
        result.addAll(QuoteBaseCheck.get().checkQuote(checkQuote));
        result.addAll(QuoteCheck.get().checkQuote(checkQuote));
        result.addAll(QuoteRegDataCheck.get().checkQuote(checkQuote));
        result.addAll(QuoteShrekDataCheck.get().checkQuote(checkQuote));
        return result;
    }

    public Set<Long> checkDataQuote(@NotNull CheckQuote checkQuote) {
        return QuoteShrekDataCheck.get().checkQuote(checkQuote);
    }

    public QuoteCheckResult checkQuoteResult(@NotNull CheckQuote checkQuote) {
        QuoteCheckResult result = QuoteBaseCheck.get().checkQuoteResult(checkQuote);
        result = result.merge(QuoteCheck.get().checkQuoteResult(checkQuote));
        result = result.merge(QuoteRegDataCheck.get().checkQuoteResult(checkQuote));
        if (checkQuote.isDataCheck()) {
            result = result.merge(QuoteShrekDataCheck.get().checkQuoteResult(checkQuote));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)result.getMsg()) && result.getMsg().endsWith(",")) {
            result.setMsg(result.getMsg().substring(0, result.getMsg().lastIndexOf(44)));
        }
        return result;
    }

    public QuoteCheckResult checkQuoteDataResult(@NotNull CheckQuote checkQuote) {
        return QuoteShrekDataCheck.get().checkQuoteResult(checkQuote);
    }

    public boolean delete(int source, @NotNull Collection<Long> sourceIds) {
        return QuoteDelete.get().delete(source, sourceIds);
    }

    public Set<Long> queryQuote(@NotNull Long modelId, @NotNull Long dimensionId, @NotNull Set<Long> memberIds, int resource) {
        if (memberIds.isEmpty()) {
            return Collections.emptySet();
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fsourceid from t_eb_memberquoteentry ", new Object[0]);
        sql.append("where exists (select fid from t_eb_memberquote where t_eb_memberquoteentry.fquoteid = fid and fmodelid = ?", new Object[]{modelId});
        sql.append(" and fdimensionid = ?", new Object[]{dimensionId});
        sql.append(" and ", new Object[0]).appendIn("fmemberid", memberIds.toArray()).append(")", new Object[0]);
        if (resource != -1) {
            sql.append(" and fsourcetype = ?", new Object[]{resource});
        }
        LinkedHashSet resourceIds = Sets.newLinkedHashSet();
        try (DataSet ds = DB.queryDataSet((String)"queryQuote", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    resourceIds.add(row.getLong("fsourceid"));
                }
            }
        }
        return resourceIds;
    }

    public Set<Long> queryQuote(@NotNull Long modelId, @NotNull Long dimensionId, @NotNull Set<Long> datasetIds, @NotNull Object[] memberIds, int resource) {
        if (CollectionUtils.isEmpty((Object[])memberIds)) {
            return Collections.emptySet();
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select t.fmemberid from t_eb_memberquote t left join t_eb_memberquoteentry e on t.fid = e.fquoteid where t.fmodelid = ? and t.fdimensionid = ?", new Object[]{modelId, dimensionId});
        if (CollectionUtils.isNotEmpty(datasetIds)) {
            sql.append(" and ", new Object[0]).appendIn("t.fdatasetid", datasetIds.toArray());
        }
        sql.append(" and ", new Object[0]).appendIn("t.fmemberid", memberIds);
        sql.append(" and e.fsourcetype = ?", new Object[]{resource});
        LinkedHashSet refMemberIds = Sets.newLinkedHashSet();
        try (DataSet ds = DB.queryDataSet((String)"queryRefMember", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    refMemberIds.add(row.getLong("fmemberid"));
                }
            }
        }
        return refMemberIds;
    }

    public Set<Long> queryDataQuote(@NotNull Long modelId, @NotNull Long dimensionId, Long viewId, @NotNull Set<Long> memberIds) {
        if (memberIds.isEmpty()) {
            return Collections.emptySet();
        }
        CheckQuote checkQuote = new CheckQuote(modelId, dimensionId, viewId, memberIds, MemberTypeEnum.MEMBER);
        checkQuote.setCheckChild(false);
        return QuoteShrekDataCheck.get().checkQuote(checkQuote);
    }

    public Set<Long> filterQuote(@NotNull Long modelId, @NotNull Long busModelId, @NotNull Set<Long> resourceIds, Map<Long, Long> variableMap, @NotNull List<Map<Long, Long>> members) {
        HashMap<String, Map> varValues;
        Map viewIds;
        IModelCacheHelper modelCache;
        HashMap resourceMap;
        HashSet<Long> filterIds;
        block36: {
            filterIds = new HashSet<Long>(resourceIds.size());
            if (resourceIds.isEmpty() || members.isEmpty()) {
                return filterIds;
            }
            SqlBuilder sql = new SqlBuilder();
            sql.append("select t.fid, e.fsourceid, t.fdimensionid, t.fmemberid, t.ftype, e.frange, e.fext, e.fviewid from t_eb_memberquote t join t_eb_memberquoteentry e on t.fid  = e.fquoteid where t.fmodelid = ? and ", new Object[]{modelId});
            sql.appendIn("e.fsourceid", resourceIds.toArray());
            sql.append(" and t.ftype in (?, ?, ?)", new Object[]{MemberTypeEnum.MEMBER.getType(), MemberTypeEnum.VARIABLE.getType(), MemberTypeEnum.ATTRIBUTEVALUE.getType()});
            int only = RangeEnum.ONLY.getIndex();
            resourceMap = Maps.newHashMapWithExpectedSize((int)resourceIds.size());
            modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            viewIds = modelCache.getViewsByBusModel(busModelId);
            List views = modelCache.getViewGroupViewsByBusModelAndDimNumber(busModelId, SysDimensionEnum.Entity.getNumber());
            HashSet<Long> memberRootIds = new HashSet<Long>(16);
            for (Long _viewId : views) {
                memberRootIds.add(modelCache.getRootMember(SysDimensionEnum.Entity.getNumber(), _viewId).getId());
            }
            LinkedHashMap varCacheMap = Maps.newLinkedHashMap();
            LinkedHashMap leadCacheMap = Maps.newLinkedHashMap();
            int MEMBER_TYPE = MemberTypeEnum.MEMBER.getType();
            int VAR_TYPE = MemberTypeEnum.VARIABLE.getType();
            int PROP_TYPE = MemberTypeEnum.ATTRIBUTEVALUE.getType();
            varValues = new HashMap<String, Map>();
            if (!variableMap.isEmpty()) {
                DynamicObjectCollection variables = QueryServiceHelper.query((String)"eb_periodvariable", (String)"id,number,name,dimension.id,dimension.number", (QFilter[])new QFilter("id", "in", variableMap.keySet()).toArray());
                for (DynamicObject variable : variables) {
                    Member member;
                    Map varVal = varValues.computeIfAbsent(variable.getString("dimension.number"), f -> new HashMap());
                    Iterator dimension = modelCache.getDimension(Long.valueOf(variable.getLong("dimension.id")));
                    if (dimension == null || (member = dimension.getMember((Long)viewIds.get(dimension.getNumber()), variableMap.get(variable.getLong("id")))) == null) continue;
                    varVal.put(variable.getString("number") + '!' + variable.getString("name"), member.getNumber());
                }
            }
            MemberPropCache propCache = MemberPropCacheService.getOrCreate((Long)modelId);
            DataSet ds = DB.queryDataSet((String)"queryQuote", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
            Iterator iterator = null;
            try {
                if (ds == null) break block36;
                for (Object row : ds) {
                    Set refMemberSet;
                    Map refMemberMap;
                    Dimension dimension;
                    Integer type = row.getInteger("ftype");
                    Long dimId = row.getLong("fdimensionid");
                    Long memberId = row.getLong("fmemberid");
                    Long viewId = row.getLong("fviewid");
                    if (MEMBER_TYPE == type) {
                        List memberRange;
                        Member member;
                        Map refMemberMap2 = resourceMap.computeIfAbsent(row.getLong("fsourceid"), f -> new HashMap(32));
                        int range = only;
                        try {
                            String rangeStr = row.getString("frange");
                            if (StringUtils.isNotEmpty((String)rangeStr)) {
                                range = Convert.toInt((Object)rangeStr.trim());
                            }
                        }
                        catch (Exception ex) {
                            log.error(ex.getMessage(), (Throwable)ex);
                        }
                        if (memberRootIds.contains(memberId)) continue;
                        Set refMemberSet2 = refMemberMap2.computeIfAbsent(dimId, f -> new LinkedHashSet());
                        if (range == only) {
                            refMemberSet2.add(memberId);
                            continue;
                        }
                        Dimension dimension2 = modelCache.getDimension(dimId);
                        if (dimension2 == null) continue;
                        if (IDUtils.isEmptyLong((Long)viewId).booleanValue()) {
                            viewId = (Long)viewIds.get(dimension2.getNumber());
                        }
                        if ((member = dimension2.getStructOfMember(memberId)) == null || !CollectionUtils.isNotEmpty((Collection)(memberRange = modelCache.getMember(dimension2.getNumber(), viewId, member.getNumber(), range)))) continue;
                        refMemberSet2.addAll(memberRange.stream().filter(Objects::nonNull).map(BaseCache::getId).collect(Collectors.toSet()));
                        continue;
                    }
                    if (VAR_TYPE == type) {
                        String leadNumber;
                        dimension = modelCache.getDimension(dimId);
                        if (dimension == null) continue;
                        Long _varRefMemberId = variableMap.get(memberId);
                        if (IDUtils.isNotNull((Long)_varRefMemberId)) {
                            Member member;
                            Map refMemberMap3 = resourceMap.computeIfAbsent(row.getLong("fsourceid"), f -> new HashMap(32));
                            Set refMemberSet3 = refMemberMap3.computeIfAbsent(dimId, f -> new LinkedHashSet());
                            refMemberSet3.add(_varRefMemberId);
                            String extStr = row.getString("fext");
                            if (!StringUtils.isNotEmpty((String)extStr) || !PeriodLeadUtils.hasPeriodDim((String)dimension.getNumber()) || (member = dimension.getMember(null, _varRefMemberId)) == null) continue;
                            String periodNumber = member.getNumber();
                            try {
                                String[] offsets;
                                String extInfo;
                                Map extMap = (Map)JSONUtils.parse((String)extStr, Map.class);
                                if (extMap == null || !StringUtils.isNotEmpty((String)(extInfo = (String)extMap.get("offset")))) continue;
                                for (String _offset : offsets = extInfo.split(";")) {
                                    PeriodLeadUtils.PeriodLead lead = PeriodLeadUtils.parse((String)_offset);
                                    if (lead == null || !StringUtils.isNotEmpty((String)(leadNumber = PeriodLeadUtils.get((String)periodNumber, (PeriodLeadUtils.PeriodLead)lead, (Map)leadCacheMap))) || (member = dimension.getMember(null, leadNumber)) == null) continue;
                                    refMemberSet3.add(member.getId());
                                }
                                continue;
                            }
                            catch (Exception ex) {
                                log.error("parse-json-error:" + extStr, (Throwable)ex);
                                continue;
                            }
                        }
                        DynamicObject var = varCacheMap.computeIfAbsent(memberId, arg_0 -> MemberQuote.lambda$filterQuote$5((Row)row, arg_0));
                        if (!StringUtils.equals((String)"2", (String)var.getString("grouptype"))) continue;
                        try {
                            Member member;
                            leadNumber = ReportVarUtil.getRealDimByVar((Long)modelId, (String)var.getString("number"), (String)dimension.getNumber(), varValues);
                            if (!StringUtils.isNotEmpty((String)leadNumber) || (member = dimension.getMember((Long)viewIds.get(dimension.getNumber()), leadNumber)) == null) continue;
                            refMemberMap = resourceMap.computeIfAbsent(row.getLong("fsourceid"), f -> new HashMap(32));
                            refMemberSet = refMemberMap.computeIfAbsent(dimId, f -> new LinkedHashSet());
                            refMemberSet.add(member.getId());
                        }
                        catch (Exception ex) {
                            log.warn("var-trans-error" + var.getString("number"));
                        }
                        continue;
                    }
                    if (PROP_TYPE != type) continue;
                    dimension = modelCache.getDimension(dimId);
                    Long _viewId = (Long)viewIds.get(dimension.getNumber());
                    List propMembers = propCache.getMembersByPropValues(dimId, _viewId, memberId);
                    refMemberMap = resourceMap.computeIfAbsent(row.getLong("fsourceid"), f -> new HashMap(32));
                    refMemberSet = refMemberMap.computeIfAbsent(dimId, f -> new LinkedHashSet());
                    refMemberSet.addAll(propMembers.stream().map(BaseCache::getId).collect(Collectors.toSet()));
                }
            }
            catch (Throwable dimension) {
                iterator = dimension;
                throw dimension;
            }
            finally {
                if (ds != null) {
                    if (iterator != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable dimension) {
                            ((Throwable)((Object)iterator)).addSuppressed(dimension);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        ArrayList dimensionNumberStringList = Lists.newArrayList((Object[])new String[]{SysDimensionEnum.BudgetPeriod.getNumber(), SysDimensionEnum.Entity.getNumber()});
        for (Map map : resourceMap.values()) {
            for (String dimensionNumberString : dimensionNumberStringList) {
                Set memberIdLongSet;
                Dimension currentDimension = modelCache.getDimension(dimensionNumberString);
                if (currentDimension == null || (memberIdLongSet = (Set)map.get(currentDimension.getId())) == null || memberIdLongSet.isEmpty()) continue;
                Long viewIdLong = (Long)viewIds.get(currentDimension.getNumber());
                HashSet finalMemberIdLongSet = new HashSet(memberIdLongSet);
                for (Long memberIdLong : memberIdLongSet) {
                    Member budgetPeriodMember = currentDimension.getMember(viewIdLong, memberIdLong);
                    if (budgetPeriodMember == null) continue;
                    finalMemberIdLongSet.addAll(budgetPeriodMember.getAllMembers().stream().map(BaseCache::getId).collect(Collectors.toSet()));
                }
                map.put(currentDimension.getId(), finalMemberIdLongSet);
            }
        }
        log.info("ReportSDK-all-finalResourceMap" + JSON.toJSONString((Object)resourceMap));
        log.info("ReportSDK-all-resourceMap" + JSON.toJSONString((Object)resourceMap));
        log.info("ReportSDK-memberMap" + JSON.toJSONString(members));
        log.info("ReportSDK-variableMap" + JSON.toJSONString(variableMap));
        log.info("ReportSDK-varValues" + JSONUtils.toString(varValues));
        for (Map.Entry entry : resourceMap.entrySet()) {
            Long resourceId = (Long)entry.getKey();
            Map refMemberMap = (Map)entry.getValue();
            for (Map<Long, Long> _member : members) {
                if (CollectionUtils.include((Map)refMemberMap, _member)) {
                    filterIds.add(resourceId);
                    continue;
                }
                log.info("ReportSDK-memberFilter-no-include:" + resourceId);
                log.info("ReportSDK-resourceMap" + JSON.toJSONString((Object)refMemberMap));
            }
        }
        ModelCacheContext.remove();
        MemberPropCacheService.remove();
        return filterIds;
    }

    public Set<Long> filterQuoteNew(@NotNull Long modelId, @NotNull Long busModelId, @NotNull Set<Long> resourceIds, Map<Long, Long> variableMap, @NotNull List<Map<Long, Long>> members) {
        Map refMemberMap;
        HashMap<String, Map> varValues;
        Map viewIds;
        IModelCacheHelper modelCache;
        HashMap resourceMap;
        HashSet<Long> filterIds;
        block34: {
            Member member;
            Dimension dimension;
            filterIds = new HashSet<Long>(resourceIds.size());
            if (resourceIds.isEmpty() || members.isEmpty()) {
                return filterIds;
            }
            SqlBuilder sql = new SqlBuilder();
            sql.append("select t.fid, e.fsourceid, t.fdimensionid, t.fmemberid, t.ftype, e.frange, e.fext from t_eb_memberquote t join t_eb_memberquoteentry e on t.fid  = e.fquoteid where t.fmodelid = ? and ", new Object[]{modelId});
            sql.appendIn("e.fsourceid", resourceIds.toArray());
            sql.append(" and t.ftype in (?, ?)", new Object[]{MemberTypeEnum.MEMBER.getType(), MemberTypeEnum.VARIABLE.getType()});
            int only = RangeEnum.ONLY.getIndex();
            resourceMap = Maps.newHashMapWithExpectedSize((int)resourceIds.size());
            modelCache = ModelCacheContext.getOrCreate((Long)modelId);
            viewIds = modelCache.getViewsByBusModel(busModelId);
            List views = modelCache.getViewGroupViewsByBusModelAndDimNumber(busModelId, SysDimensionEnum.Entity.getNumber());
            HashSet<Long> memberRootIds = new HashSet<Long>(16);
            for (Long _viewId : views) {
                memberRootIds.add(modelCache.getRootMember(SysDimensionEnum.Entity.getNumber(), _viewId).getId());
            }
            LinkedHashMap varCacheMap = Maps.newLinkedHashMap();
            LinkedHashMap leadCacheMap = Maps.newLinkedHashMap();
            int MEMBER_TYPE = MemberTypeEnum.MEMBER.getType();
            int VAR_TYPE = MemberTypeEnum.VARIABLE.getType();
            varValues = new HashMap<String, Map>();
            if (!variableMap.isEmpty()) {
                DynamicObjectCollection variables = QueryServiceHelper.query((String)"eb_periodvariable", (String)"id,number,name,dimension.id,dimension.number", (QFilter[])new QFilter("id", "in", variableMap.keySet()).toArray());
                for (DynamicObject variable : variables) {
                    Map varVal = varValues.computeIfAbsent(variable.getString("dimension.number"), f -> new HashMap());
                    dimension = modelCache.getDimension(Long.valueOf(variable.getLong("dimension.id")));
                    if (dimension == null || (member = dimension.getMember((Long)viewIds.get(dimension.getNumber()), variableMap.get(variable.getLong("id")))) == null) continue;
                    varVal.put(variable.getString("number") + '!' + variable.getString("name"), member.getNumber());
                }
            }
            Map baseViewMap = modelCache.getViewsByBusModelIncludeBase(busModelId);
            DataSet ds = DB.queryDataSet((String)"queryQuote", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
            Iterator iterator = null;
            try {
                if (ds == null) break block34;
                for (Row row : ds) {
                    String leadNumber;
                    Long viewId;
                    Set refMemberSet;
                    int type = row.getInteger("ftype");
                    Long dimId = row.getLong("fdimensionid");
                    Long memberId = row.getLong("fmemberid");
                    if (MEMBER_TYPE == type) {
                        int range;
                        refMemberMap = resourceMap.computeIfAbsent(row.getLong("fsourceid"), f -> new HashMap(32));
                        try {
                            String rangeStr = row.getString("frange");
                            range = StringUtils.isNotEmpty((String)rangeStr) ? Convert.toInt((Object)rangeStr.trim()) : only;
                        }
                        catch (Exception exception) {
                            range = only;
                        }
                        if (memberRootIds.contains(memberId)) continue;
                        refMemberSet = refMemberMap.computeIfAbsent(dimId, f -> new LinkedHashSet());
                        if (range == only) {
                            refMemberSet.add(memberId);
                            continue;
                        }
                        dimension = modelCache.getDimension(dimId);
                        if (dimension == null || (member = dimension.getMember(viewId = (Long)viewIds.get(dimension.getNumber()), memberId)) == null) continue;
                        if (member.isAnalyzeMember()) {
                            viewId = modelCache.getAnalyzeMemberViewId((Long)baseViewMap.get(dimension.getNumber()), member);
                        }
                        List memberRange = modelCache.getMember(dimension.getNumber(), viewId, member.getNumber(), range);
                        refMemberSet.addAll(memberRange.stream().filter(Objects::nonNull).map(BaseCache::getId).collect(Collectors.toSet()));
                        continue;
                    }
                    if (VAR_TYPE != type || (dimension = modelCache.getDimension(dimId)) == null) continue;
                    viewId = (Long)viewIds.get(dimension.getNumber());
                    Long l = variableMap.get(memberId);
                    if (IDUtils.isNotNull((Long)l)) {
                        refMemberMap = resourceMap.computeIfAbsent(row.getLong("fsourceid"), f -> new HashMap(32));
                        refMemberSet = refMemberMap.computeIfAbsent(dimId, f -> new LinkedHashSet());
                        refMemberSet.add(l);
                        String extStr = row.getString("fext");
                        if (!StringUtils.isNotEmpty((String)extStr) || !PeriodLeadUtils.hasPeriodDim((String)dimension.getNumber()) || (member = dimension.getMember(viewId, l)) == null) continue;
                        String periodNumber = member.getNumber();
                        try {
                            String[] offsets;
                            String extInfo;
                            Map extMap = (Map)JSONUtils.parse((String)extStr, Map.class);
                            if (extMap == null || !StringUtils.isNotEmpty((String)(extInfo = (String)extMap.get("offset")))) continue;
                            for (String _offset : offsets = extInfo.split(";")) {
                                PeriodLeadUtils.PeriodLead lead = PeriodLeadUtils.parse((String)_offset);
                                if (lead == null || !StringUtils.isNotEmpty((String)(leadNumber = PeriodLeadUtils.get((String)periodNumber, (PeriodLeadUtils.PeriodLead)lead, (Map)leadCacheMap))) || (member = dimension.getMember(viewId, leadNumber)) == null) continue;
                                refMemberSet.add(member.getId());
                            }
                            continue;
                        }
                        catch (Exception ex) {
                            log.error("parse-json-error:" + extStr, (Throwable)ex);
                            continue;
                        }
                    }
                    DynamicObject var = varCacheMap.computeIfAbsent(memberId, f -> BusinessDataServiceHelper.loadSingleFromCache((Object)row.getLong("fmemberid"), (String)"eb_periodvariable", (String)"id,number,offset,grouptype"));
                    if (!StringUtils.equals((String)"2", (String)var.getString("grouptype"))) continue;
                    try {
                        leadNumber = ReportVarUtil.getRealDimByVar((Long)modelId, (String)var.getString("number"), (String)dimension.getNumber(), varValues);
                        if (!StringUtils.isNotEmpty((String)leadNumber) || (member = dimension.getMember(null, leadNumber)) == null) continue;
                        refMemberMap = resourceMap.computeIfAbsent(row.getLong("fsourceid"), f -> new HashMap(32));
                        refMemberSet = refMemberMap.computeIfAbsent(dimId, f -> new LinkedHashSet());
                        refMemberSet.add(member.getId());
                    }
                    catch (Exception ex) {
                        log.warn("var-trans-error" + var.getString("number"));
                    }
                }
            }
            catch (Throwable throwable) {
                iterator = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (iterator != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)((Object)iterator)).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        ArrayList dimensionNumberStringList = Lists.newArrayList((Object[])new String[]{SysDimensionEnum.BudgetPeriod.getNumber(), SysDimensionEnum.Entity.getNumber()});
        for (Map map : resourceMap.values()) {
            for (String string : dimensionNumberStringList) {
                Set memberIdLongSet;
                Dimension currentDimension = modelCache.getDimension(string);
                if (currentDimension == null || (memberIdLongSet = (Set)map.get(currentDimension.getId())) == null || memberIdLongSet.isEmpty()) continue;
                Long viewIdLong = (Long)viewIds.get(currentDimension.getNumber());
                HashSet finalMemberIdLongSet = new HashSet(16);
                for (Long memberIdLong : memberIdLongSet) {
                    Member budgetPeriodMember = currentDimension.getMember(viewIdLong, memberIdLong);
                    if (budgetPeriodMember == null) continue;
                    finalMemberIdLongSet.addAll(budgetPeriodMember.getAllMembers().stream().map(item -> item.getId()).collect(Collectors.toSet()));
                }
                map.put(currentDimension.getId(), finalMemberIdLongSet);
            }
        }
        log.info("ReportSDK-all-finalResourceMap" + JSON.toJSONString((Object)resourceMap));
        log.info("ReportSDK-all-resourceMap" + JSON.toJSONString((Object)resourceMap));
        log.info("ReportSDK-memberMap" + JSON.toJSONString(members));
        log.info("ReportSDK-variableMap" + JSON.toJSONString(variableMap));
        log.info("ReportSDK-varValues" + JSONUtils.toString(varValues));
        for (Map.Entry entry : resourceMap.entrySet()) {
            Long resourceId = (Long)entry.getKey();
            refMemberMap = (Map)entry.getValue();
            for (Map map : members) {
                if (CollectionUtils.includeByIgn((Map)refMemberMap, (Map)map)) {
                    filterIds.add(resourceId);
                    continue;
                }
                log.info("ReportSDK-memberFilter-no-include:" + resourceId);
                log.info("ReportSDK-resourceMap" + JSON.toJSONString((Object)refMemberMap));
            }
        }
        ModelCacheContext.remove();
        return filterIds;
    }

    public Map<Long, Map<String, Set<Long>>> queryQuote(@NotNull Long resourceId) {
        if (IDUtils.isNull((Long)resourceId)) {
            return Collections.emptyMap();
        }
        return this.queryQuote(Collections.singletonList(resourceId));
    }

    public Map<Long, Map<String, Set<Long>>> queryQuote(@NotNull Collection<Object> resourceIds) {
        if (resourceIds.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap memberIdMap = Maps.newLinkedHashMap();
        SqlBuilder sql = new SqlBuilder();
        sql.append("select t.fdimensionid, t.fmemberid, ftype from t_eb_memberquote t where exists (select fquoteid from t_eb_memberquoteentry where ", new Object[0]);
        sql.appendIn("fsourceid", resourceIds.toArray());
        sql.append(" and t.fid = fquoteid)", new Object[0]);
        try (DataSet ds = DB.queryDataSet((String)"queryQuote", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    Map memberType = memberIdMap.computeIfAbsent(row.getLong("fdimensionid"), f -> Maps.newLinkedHashMap());
                    Set memberIds = memberType.computeIfAbsent(row.getString("ftype"), f -> Sets.newLinkedHashSet());
                    memberIds.add(row.getLong("fmemberid"));
                }
            }
        }
        return memberIdMap;
    }

    public Map<Long, Map<Long, Map<String, Set<Long>>>> queryQuoteWithResourceId(@NotNull Collection<Long> resourceIds) {
        if (resourceIds.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap quoteInfo = Maps.newLinkedHashMap();
        SqlBuilder sql = new SqlBuilder();
        sql.append("select t.fdimensionid, t.fmemberid, fsourceid, ftype from t_eb_memberquote t left join t_eb_memberquoteentry m on t.fid = m.fquoteid where ", new Object[0]);
        sql.appendIn("fsourceid", resourceIds.toArray());
        try (DataSet ds = DB.queryDataSet((String)"queryQuote", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    Map memberIdMap = quoteInfo.computeIfAbsent(row.getLong("fsourceid"), f -> Maps.newLinkedHashMap());
                    Map memberType = memberIdMap.computeIfAbsent(row.getLong("fdimensionid"), f -> Maps.newLinkedHashMap());
                    Set memberIds = memberType.computeIfAbsent(row.getString("ftype"), f -> Sets.newLinkedHashSet());
                    memberIds.add(row.getLong("fmemberid"));
                }
            }
        }
        return quoteInfo;
    }

    public Map<Long, Map<Long, List<Object[]>>> queryTemplateQuote(@NotNull Set<Long> templateIdSet) {
        Serializable sourceId;
        LinkedHashMap result = Maps.newLinkedHashMap();
        if (CollectionUtils.isEmpty(templateIdSet)) {
            return result;
        }
        HashMap<Long, Map> sourceQuoteRangeMap = new HashMap<Long, Map>(16);
        HashSet<Long> quoteIds = new HashSet<Long>(16);
        SqlBuilder sqlBuilder1 = new SqlBuilder();
        sqlBuilder1.append("select fsourceid as sourceId, fquoteid as quoteId, frange as frange,fviewid as viewid from t_eb_memberquoteentry where ", new Object[0]);
        sqlBuilder1.appendIn("fsourceid", templateIdSet.toArray());
        try (DataSet ds = DB.queryDataSet((String)"queryTemplateQuoteEntry", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sqlBuilder1);){
            while (ds.hasNext()) {
                Row next = ds.next();
                Long quoteId = next.getLong("quoteId");
                sourceId = next.getLong("sourceId");
                String range1 = next.getString("frange");
                int range = RangeEnum.ONLY.getIndex();
                if (StringUtils.isNotEmpty((String)range1)) {
                    range = Integer.parseInt(range1.trim());
                }
                Long viewid = next.getLong("viewid");
                Map map = sourceQuoteRangeMap.computeIfAbsent((Long)sourceId, t -> new HashMap(16));
                Set integers = map.computeIfAbsent(quoteId, t -> new HashSet(16));
                integers.add(range + "!" + viewid);
                quoteIds.add(quoteId);
            }
        }
        if (CollectionUtils.isEmpty(quoteIds)) {
            return result;
        }
        SqlBuilder sqlBuilder2 = new SqlBuilder();
        sqlBuilder2.append("select fid, fdimensionid as dimensionId, fmemberid as memberId, ftype as memberType from t_eb_memberquote where ftype in ('0','1','7') and ", new Object[0]);
        sqlBuilder2.appendIn(" fid ", quoteIds.toArray());
        HashMap quoteMemberDimMap = new HashMap(16);
        DataSet ds = DB.queryDataSet((String)"queryTemplateQuote", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sqlBuilder2);
        sourceId = null;
        try {
            while (ds.hasNext()) {
                Row next = ds.next();
                String dimensionId = next.getString("dimensionId");
                String memberId = next.getString("memberId");
                String memberType = next.getString("memberType");
                Long fid = next.getLong("fid");
                HashMap<String, String> map = new HashMap<String, String>(16);
                map.put("dimensionId", dimensionId);
                map.put("memberId", memberId);
                map.put("memberType", memberType);
                quoteMemberDimMap.put(fid, map);
            }
        }
        catch (Throwable next) {
            sourceId = next;
            throw next;
        }
        finally {
            if (ds != null) {
                if (sourceId != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable next) {
                        ((Throwable)sourceId).addSuppressed(next);
                    }
                } else {
                    ds.close();
                }
            }
        }
        for (Map.Entry entry : sourceQuoteRangeMap.entrySet()) {
            Long templateId = (Long)entry.getKey();
            Map value = (Map)entry.getValue();
            Map dimMems = result.computeIfAbsent(templateId, t -> new HashMap(16));
            for (Map.Entry longIntegerEntry : value.entrySet()) {
                Long quoteId = (Long)longIntegerEntry.getKey();
                Map dimMemMap = (Map)quoteMemberDimMap.get(quoteId);
                if (dimMemMap == null) continue;
                String dimensionId = (String)dimMemMap.get("dimensionId");
                String memberId = (String)dimMemMap.get("memberId");
                String memberType = (String)dimMemMap.get("memberType");
                Set ranges = (Set)longIntegerEntry.getValue();
                for (String range : ranges) {
                    String[] split = range.split("!");
                    if (split.length != 2) continue;
                    List mems = dimMems.computeIfAbsent(IDUtils.toLong((Object)dimensionId), t -> new LinkedList());
                    mems.add(new Object[]{memberId, Integer.parseInt(split[0].trim()), memberType, IDUtils.toLong((Object)split[1])});
                }
            }
        }
        return result;
    }

    public void clearQuote(@NotNull Long modelId, @NotNull Long dimensionId, Long ... memberIds) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("delete from ", new Object[0]).append("t_eb_memberquote", new Object[0]).append(" where fmodelid = ?", new Object[]{modelId});
        sql.append(" and fdimensionid = ?", new Object[]{dimensionId});
        if (memberIds != null && memberIds.length > 0) {
            sql.append(" and ", new Object[0]).appendIn("fmemberid", (Object[])memberIds);
        }
        sql.append(" and fstatus = '0'", new Object[0]);
        DB.execute((DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
    }

    private static /* synthetic */ DynamicObject lambda$filterQuote$5(Row row, Long f) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)row.getLong("fmemberid"), (String)"eb_periodvariable", (String)"id,number,offset,grouptype");
    }
}

