/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.business.reportscheme.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.business.reportscheme.entity.TebScheme;
import kd.epm.eb.business.reportscheme.entity.TebTemplateAssignOrg;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.RptSchemeStatusEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.reportprocess.entity.dto.TemplateEntityDto;
import kd.epm.eb.common.reportprocess.helper.MemberHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.UserUtils;

public class ReportSchemeService {
    private static final ReportSchemeService instance = new ReportSchemeService();

    private ReportSchemeService() {
    }

    public static ReportSchemeService getInstance() {
        return instance;
    }

    public DynamicObjectCollection queryReocrdBySchemeIdTemplateIdAndOrgId(Long schemeId, Set<Long> templateIds, Set<Long> orgIds) {
        String selectFields = "id,template.id,template.name,template.number,templatetype,org.id,org.number,org.name,allocatetime,orgrange,recordseq,applytemplate.id,applytemplate.name,applytemplate.number";
        QFilter qf = new QFilter("scheme", "=", (Object)schemeId);
        if (CollectionUtils.isNotEmpty(templateIds)) {
            qf.and(new QFilter("template", "in", templateIds).or(new QFilter("applytemplate", "in", templateIds)));
        }
        if (CollectionUtils.isNotEmpty(orgIds)) {
            qf.and(new QFilter("org", "in", orgIds));
        }
        return QueryServiceHelper.query((String)"eb_templateorg", (String)selectFields, (QFilter[])new QFilter[]{qf}, (String)"allocatetime desc");
    }

    public void deleteRecordByIdTemplateIdAndOrgId(Long schemeId, Set<Long> templateIds, Set<Long> orgIds, Set<Long> recordId, String range) {
        QFilter qFilter = new QFilter("scheme", "=", (Object)schemeId);
        qFilter.and(new QFilter("orgrange", "=", (Object)range));
        if (CollectionUtils.isNotEmpty(recordId)) {
            qFilter.and(new QFilter("id", "not in", recordId));
        }
        if (CollectionUtils.isNotEmpty(templateIds)) {
            qFilter.and(new QFilter("template", "in", templateIds).or(new QFilter("applytemplate", "in", templateIds)));
        }
        if (CollectionUtils.isNotEmpty(orgIds)) {
            qFilter.and(new QFilter("org", "in", orgIds));
        }
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((String)"eb_templateorg", (QFilter[])new QFilter[]{qFilter});
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public DynamicObjectCollection querySchemeByModelId(String selectFields, Long modelId) {
        return QueryServiceHelper.query((String)"eb_rptscheme", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)modelId)}, (String)"modifydate desc");
    }

    public DynamicObjectCollection querySchemeByQFilters(String selectFields, List<QFilter> qFilters) {
        return this.querySchemeByQFilters(selectFields, null, qFilters);
    }

    public DynamicObjectCollection querySchemeByQFilters(String selectFields, Long modelId, List<QFilter> qFilters) {
        LinkedList<QFilter> qFilterList = new LinkedList<QFilter>();
        if (IDUtils.isNotNull((Long)modelId)) {
            qFilterList.add(new QFilter("model", "=", (Object)modelId));
        }
        if (qFilters != null) {
            qFilterList.addAll(qFilters);
        }
        return QueryServiceHelper.query((String)"eb_rptscheme", (String)selectFields, (QFilter[])qFilterList.toArray(new QFilter[0]), (String)"modifydate desc");
    }

    public int getMaxSeq(Long modelId) {
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection list = QueryServiceHelper.query((String)"eb_rptscheme", (String)"schemeseq", (QFilter[])new QFilter[]{qf}, (String)"schemeseq desc", (int)1);
        if (list == null || list.size() == 0) {
            return 0;
        }
        return ((DynamicObject)list.get(0)).getInt("schemeseq");
    }

    public DynamicObject saveScheme(TebScheme scheme, boolean isNew) {
        DynamicObject schemeObj = this.packageSchemeObject(scheme, isNew);
        List<DynamicObject> dynamicObjectList = this.packageAllocateObjects(scheme);
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{schemeObj});
                if (CollectionUtils.isNotEmpty(dynamicObjectList)) {
                    SaveServiceHelper.save((DynamicObject[])dynamicObjectList.toArray(new DynamicObject[0]));
                }
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
        return schemeObj;
    }

    public void deleteSchemes(List<Long> schemeIds) {
        try (TXHandle tx = TX.required();){
            try {
                DeleteServiceHelper.delete((String)"eb_rptscheme", (QFilter[])new QFilter[]{new QFilter("id", "in", schemeIds)});
                this.deleteRecord(schemeIds);
            }
            catch (Throwable e) {
                tx.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public void deleteRecord(List<Long> schemeIds) {
        if (schemeIds != null && schemeIds.size() > 0) {
            DeleteServiceHelper.delete((String)"eb_templateorg", (QFilter[])new QFilter[]{new QFilter("scheme", "in", schemeIds)});
        }
    }

    public void deleteRecordById(List<Long> recordIds) {
        if (recordIds != null && recordIds.size() > 0) {
            DeleteServiceHelper.delete((String)"eb_templateorg", (QFilter[])new QFilter[]{new QFilter("id", "in", recordIds)});
        }
    }

    public void deleteRecord(Long schemeId) {
        if (schemeId != null) {
            DeleteServiceHelper.delete((String)"eb_templateorg", (QFilter[])new QFilter[]{new QFilter("scheme", "=", (Object)schemeId)});
        }
    }

    private DynamicObject packageSchemeObject(TebScheme scheme, boolean isNew) {
        DynamicObject dyScheme = null;
        if (isNew) {
            dyScheme = this.getNewDynamicObject("eb_rptscheme");
            dyScheme.set("creater", (Object)scheme.getCreatorId());
            dyScheme.set("createdate", (Object)scheme.getCreateTime());
            dyScheme.set("schemeseq", (Object)scheme.getSeq());
        } else {
            dyScheme = BusinessDataServiceHelper.loadSingle((Object)scheme.getId(), (String)"eb_rptscheme");
        }
        if (dyScheme == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u4fdd\u5b58\u5931\u8d25\u3002", (String)"ReportSchemeService_1", (String)"epm-eb-business", (Object[])new Object[0]));
        }
        dyScheme.set("id", (Object)scheme.getId());
        dyScheme.set("number", (Object)scheme.getNumber());
        dyScheme.set("name", (Object)scheme.getName());
        dyScheme.set("applyscope", (Object)scheme.getApplyscope());
        dyScheme.set("status", (Object)scheme.getStatus());
        dyScheme.set("description", (Object)scheme.getDescription());
        dyScheme.set("modifier", (Object)scheme.getModifierId());
        dyScheme.set("modifydate", (Object)scheme.getCreateTime());
        dyScheme.set("model", (Object)scheme.getModelId());
        dyScheme.set("bizrange", (Object)scheme.getBizRangeId());
        dyScheme.set("orgview", (Object)scheme.getOrgViewId());
        dyScheme.set("commitcheck", (Object)scheme.isCommitcheck());
        return dyScheme;
    }

    private List<DynamicObject> packageAllocateObjects(TebScheme scheme) {
        List allocateRecords = scheme.getAllocateRecords();
        if (allocateRecords == null || allocateRecords.size() == 0) {
            return new ArrayList<DynamicObject>(16);
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(allocateRecords.size());
        for (TebTemplateAssignOrg allocateRecord : allocateRecords) {
            DynamicObject obj = this.getNewDynamicObject("eb_templateorg");
            Long templateId = 0L;
            switch (allocateRecord.getTemplateType()) {
                case "0": {
                    templateId = allocateRecord.getTemplateId();
                    obj.set("template", (Object)templateId);
                    break;
                }
                case "1": {
                    templateId = allocateRecord.getApplyTemplateID();
                    obj.set("applytemplate", (Object)templateId);
                    break;
                }
            }
            obj.set("templatetype", (Object)allocateRecord.getTemplateType());
            obj.set("org", (Object)allocateRecord.getOrgId());
            obj.set("allocater", (Object)allocateRecord.getAllocatorId());
            obj.set("allocatetime", (Object)allocateRecord.getAllocateTime());
            obj.set("orgrange", (Object)allocateRecord.getOrgRange());
            obj.set("scheme", (Object)scheme.getId());
            obj.set("recordseq", (Object)allocateRecord.getSeq());
            if (CollectionUtils.isNotEmpty((Collection)allocateRecord.getDeleteEntity())) {
                DynamicObjectType deleteentity = obj.getDynamicObjectCollection("deleteentity").getDynamicObjectType();
                DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection(deleteentity, (Object)obj);
                for (Long aLong : allocateRecord.getDeleteEntity()) {
                    DynamicObject dynamicObject1 = dynamicObjectCollection.addNew();
                    dynamicObject1.set("entity", (Object)aLong);
                }
                obj.getDynamicObjectCollection("deleteentity").addAll((Collection)dynamicObjectCollection);
            }
            result.add(obj);
        }
        return result;
    }

    private DynamicObject getNewDynamicObject(String entity) {
        return BusinessDataServiceHelper.newDynamicObject((String)entity);
    }

    public void updateStatus(String status, List<Long> schemeIds) {
        DynamicObject[] objs;
        Long userId = UserUtils.getUserId();
        Date now = TimeServiceHelper.now();
        for (DynamicObject obj : objs = BusinessDataServiceHelper.load((String)"eb_rptscheme", (String)"id,status,modifier,modifydate", (QFilter[])new QFilter[]{new QFilter("id", "in", schemeIds)})) {
            obj.set("status", (Object)status);
            obj.set("modifier", (Object)userId);
            obj.set("modifydate", (Object)now);
        }
        SaveServiceHelper.save((DynamicObject[])objs);
    }

    public DynamicObject[] loadSchemes(Long[] schemeIds) {
        return BusinessDataServiceHelper.load((Object[])schemeIds, (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"eb_rptscheme").getDynamicObjectType());
    }

    public boolean exist(Long modelId, String field, String expectStr, Long schemeId) {
        QFilter qf1 = new QFilter("model", "=", (Object)modelId);
        QFilter qf2 = new QFilter(field, "=", (Object)expectStr);
        if (schemeId != null && schemeId != 0L) {
            qf2.and(new QFilter("id", "!=", (Object)schemeId));
        }
        return QueryServiceHelper.exists((String)"eb_rptscheme", (QFilter[])new QFilter[]{qf1, qf2});
    }

    public DynamicObjectCollection queryRecordBySchemeId2(Long schemeId) {
        String selectFields = "id,template,template.number,template.name,org,org.number,org.name,allocater,allocatetime,orgrange,recordseq,templatetype,applytemplate,applytemplate.name,applytemplate.number";
        QFilter qf = new QFilter("scheme", "=", (Object)schemeId);
        return QueryServiceHelper.query((String)"eb_templateorg", (String)selectFields, (QFilter[])new QFilter[]{qf}, (String)"recordseq");
    }

    public DynamicObjectCollection queryApRecordBySchemeId(Long schemeId) {
        String selectFields = "id,template,template.number,template.name,org,org.number,org.name,allocater,allocatetime,orgrange,recordseq,templatetype,applytemplate,applytemplate.name,applytemplate.number";
        QFilter qf = new QFilter("scheme", "=", (Object)schemeId);
        QFilter qf1 = new QFilter("templatetype", "=", (Object)"1");
        return QueryServiceHelper.query((String)"eb_templateorg", (String)selectFields, (QFilter[])new QFilter[]{qf, qf1}, (String)"recordseq");
    }

    public Set<Long> queryRecordId(Long schemeId, Set<Long> templateIdSet, Set<Long> entityIdSet, Long modelId, Long orgView, Set<Long> orgSelectSet) {
        if (IDUtils.isNull((Long)schemeId) || CollectionUtils.isEmpty(entityIdSet) || IDUtils.isNull((Long)modelId) || CollectionUtils.isEmpty(orgSelectSet)) {
            return null;
        }
        IModelCacheHelper orCreate = ModelCacheContext.getOrCreate((Long)modelId);
        String selectFields = "id,org,org.number,orgrange,deleteentity,deleteentity.entity";
        QFilter qf = new QFilter("scheme", "=", (Object)schemeId);
        if (CollectionUtils.isNotEmpty(templateIdSet)) {
            qf.and(new QFilter("template", "in", templateIdSet).or(new QFilter("applytemplate", "in", templateIdSet)));
        }
        qf.and(new QFilter("org", "in", entityIdSet));
        DynamicObject[] query = BusinessDataServiceHelper.load((String)"eb_templateorg", (String)selectFields, (QFilter[])new QFilter[]{qf});
        if (query == null || query.length == 0) {
            return null;
        }
        HashSet<Long> idSet = new HashSet<Long>(16);
        HashMap entityScopeMap = new HashMap(16);
        String key = "";
        for (DynamicObject dynamicObject : query) {
            Long id = dynamicObject.getLong("id");
            String number = dynamicObject.getString("org.number");
            Integer orgrange = dynamicObject.getInt("orgrange");
            key = number + "_" + orgrange;
            List member = new ArrayList(16);
            if (entityScopeMap.containsKey(key)) {
                member = (List)entityScopeMap.get(key);
            } else {
                member = orCreate.getMember(SysDimensionEnum.Entity.getNumber(), orgView, number, orgrange.intValue());
                entityScopeMap.put(key, member);
            }
            if (!CollectionUtils.isNotEmpty(member)) continue;
            Set collect = member.stream().map(x -> x.getId()).collect(Collectors.toSet());
            DynamicObjectCollection deleteentity = dynamicObject.getDynamicObjectCollection("deleteentity");
            if (CollectionUtils.isNotEmpty((Collection)deleteentity)) {
                Set collect1 = deleteentity.stream().map(x -> x.getLong("entity.id")).collect(Collectors.toSet());
                collect.removeAll(collect1);
            }
            if (Collections.disjoint(orgSelectSet, collect)) continue;
            idSet.add(id);
        }
        return CollectionUtils.isEmpty(idSet) ? null : idSet;
    }

    public Map<String, DynamicObject> getTemplateByID(Long modelId) {
        DynamicObjectCollection budget_templates;
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        DynamicObjectCollection rpt_templates = QueryServiceHelper.query((String)"eb_templateentity", (String)"id,name,number", (QFilter[])new QFilter[]{qf});
        if (rpt_templates != null) {
            for (DynamicObject object : rpt_templates) {
                map.put(object.getString("id"), object);
            }
        }
        if ((budget_templates = QueryServiceHelper.query((String)"eb_applytemplate", (String)"id,name,number", (QFilter[])new QFilter[]{qf})) != null) {
            for (DynamicObject object : budget_templates) {
                map.put(object.getString("id"), object);
            }
        }
        return map;
    }

    public Boolean isExistApReport(Long schemeId, List<TemplateEntityDto> list, IModelCacheHelper modelCacheHelper, Long viewId) {
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        HashSet<Long> orgIds = new HashSet<Long>(16);
        for (TemplateEntityDto templateEntityDto : list) {
            Integer range;
            Long entityid = templateEntityDto.getEntityId();
            List members = MemberHelper.getEntityMemberByView((IModelCacheHelper)modelCacheHelper, (Long)viewId, (Long)entityid, (Integer)(range = templateEntityDto.getEntityRange()));
            if (!CollectionUtils.isNotEmpty((Collection)members)) continue;
            for (Member member : members) {
                orgIds.add(member.getId());
            }
            if (!CollectionUtils.isNotEmpty((Collection)templateEntityDto.getDeleteEntity())) continue;
            orgIds.removeAll(templateEntityDto.getDeleteEntity());
        }
        return QueryServiceHelper.exists((String)"eb_bgapplybill", (QFilter[])new QFilter[]{new QFilter("applyscheme", "=", (Object)schemeId).and("org", "in", orgIds)});
    }

    public Boolean isExistApReport(Long model, Long schemeId, Long year, Long version, Long datatype) {
        QFBuilder qf1 = new QFBuilder("model", "=", (Object)model);
        qf1.and("applyscheme", "=", (Object)schemeId);
        qf1.and("year", "=", (Object)year);
        qf1.and("version", "=", (Object)version);
        qf1.and("datatype", "=", (Object)datatype);
        return QueryServiceHelper.exists((String)"eb_bgapplybill", (QFilter[])qf1.toArrays());
    }

    public Boolean isExistCurrentApCoBill(Long modelId, Long billId) {
        QFBuilder qf1 = new QFBuilder("id", "=", (Object)billId);
        qf1.and("model", "=", (Object)modelId);
        return QueryServiceHelper.exists((String)"eb_bgapplybill", (QFilter[])qf1.toArrays());
    }

    public Boolean isExistCurrentAuditBill(Long modelId, Long billId) {
        QFBuilder qf1 = new QFBuilder("id", "=", (Object)billId);
        qf1.and("model", "=", (Object)modelId);
        return QueryServiceHelper.exists((String)"eb_centralappbill", (QFilter[])qf1.toArrays());
    }

    public DynamicObjectCollection queryTemplateBySchemeIds(List<Long> schemeIds) {
        String selectFields = "scheme,scheme.id,scheme.name,template,template.name,allocatetime,recordseq,templatetype,applytemplate,applytemplate.name";
        QFilter qf = new QFilter("scheme", "in", schemeIds);
        return QueryServiceHelper.query((String)"eb_templateorg", (String)selectFields, (QFilter[])new QFilter[]{qf});
    }

    public DynamicObjectCollection queryRecordBySchemeAndTemplate(List<Long> schemeIds, List<Long> templateIds) {
        String selectFields = "scheme,scheme.id,scheme.name,template,template.name,allocatetime,recordseq,templatetype,applytemplate,applytemplate.name";
        QFilter qf = new QFilter("scheme", "in", schemeIds);
        QFilter qf1 = new QFilter("template", "in", templateIds);
        qf1.or(new QFilter("applytemplate", "in", templateIds));
        return QueryServiceHelper.query((String)"eb_templateorg", (String)selectFields, (QFilter[])new QFilter[]{qf, qf1});
    }

    public DynamicObjectCollection queryRecordBySchemeIds(Set<Long> schemeIds) {
        String selectFields = "scheme,scheme.id,scheme.name,scheme.createdate,scheme.orgview,template,template.name,allocatetime,recordseq,templatetype,applytemplate,applytemplate.name,org,org.name,org.number,orgrange";
        QFilter qf = new QFilter("scheme", "in", schemeIds);
        QFilter qf1 = new QFilter("templatetype", "=", (Object)"1");
        return QueryServiceHelper.query((String)"eb_templateorg", (String)selectFields, (QFilter[])new QFilter[]{qf, qf1});
    }

    public DynamicObjectCollection getApplyRecordsByScheme(Long schemeId) {
        String selectFields = "scheme,scheme.id,org,applytemplate,orgrange,org.number";
        QFilter qf = new QFilter("scheme", "in", (Object)schemeId);
        QFilter qf2 = new QFilter("templatetype", "=", (Object)"1");
        return QueryServiceHelper.query((String)"eb_templateorg", (String)selectFields, (QFilter[])new QFilter[]{qf, qf2});
    }

    public Boolean isSchemeClose(Long schemeId) {
        QFilter qf = new QFilter("id", "in", (Object)schemeId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_rptscheme", (String)"status", (QFilter[])new QFilter[]{qf});
        if (dynamicObject != null) {
            String status = dynamicObject.getString("status");
            return !RptSchemeStatusEnum.ENABLE.getNumber().equals(status);
        }
        return false;
    }

    public Long getSchemeOrgViewId(Long schemeId) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_rptscheme", (String)"orgview", (QFilter[])new QFilter("id", "=", (Object)schemeId).toArray());
        if (dynamicObject != null) {
            return dynamicObject.getLong("orgview");
        }
        return 0L;
    }
}

